/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator;

import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Allocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.CostAdjustFeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.CostAdjustFeeInfoAdapter;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.MatFeeInfoAdapter;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.OtherInWHFeeInfoAdapter;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.OtherInWHFeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.BatchAllocIterator.IBatchAllocIterator;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class MatBatchAllocIterator
implements IBatchAllocIterator {
    private static Logger logger = Logger.getLogger((String)MatBatchAllocIterator.class.getName());
    protected Map _param;
    protected Allocator _allocatorAdapter;
    protected IRowSet _data;
    protected MatFeeInfoAdapter _dataAdapter;

    public MatBatchAllocIterator(Map param, Allocator allocatorAdapter) throws AllocateException {
        this._param = param;
        this._allocatorAdapter = allocatorAdapter;
    }

    @Override
    public void FirstBatch() throws AllocateException {
        try {
            this._data.first();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    @Override
    public void NextBatch() throws AllocateException {
        try {
            this._data.next();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    @Override
    public boolean IsDone() throws AllocateException {
        try {
            return this._data.getRow() == 0 || this._data.isAfterLast();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    @Override
    public void AllocateCurrBatch() throws AllocateException {
        try {
            int position = -1;
            position = this._data.isFirst() && this._data.isLast() ? 3 : (this._data.isFirst() ? 1 : (this._data.isLast() ? 2 : 4));
            this._allocatorAdapter.allocIndirect(this._dataAdapter, position);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
    }

    @Override
    public void initData() throws Exception {
        FeeData ifee = this._allocatorAdapter.GetFeeDataControl();
        this._data = ifee.GetIndirectFeeData();
        this._dataAdapter = ifee instanceof OtherInWHFeeData ? new OtherInWHFeeInfoAdapter(this._data) : (ifee instanceof CostAdjustFeeData ? new CostAdjustFeeInfoAdapter(this._data) : new MatFeeInfoAdapter(this._data));
    }

    @Override
    public int getBatchCount() throws AllocateException {
        if (this._data != null) {
            return this._data.size();
        }
        return 0;
    }
}

