/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.AuxFeeAlloc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.ncm.AllocStdFactory;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.AutoOtherAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocUtils;
import com.kingdee.eas.ncm.bill.app.AuxFeeAlloc.AuxAllocTable;
import com.kingdee.eas.ncm.bill.app.AuxFeeAlloc.AuxFeeData;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AuxAllocator
extends AutoOtherAllocator {
    private static Logger logger = Logger.getLogger((String)AuxAllocator.class.getName());
    Map allocStdSettingCache = null;

    public AuxAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
    }

    @Override
    public CostTaskResultEnum preCheck() throws Exception {
        CostTaskResultEnum result = super.preCheck();
        if (result.getValue() >= CostTaskResultEnum.FAILURE.getValue()) {
            return result;
        }
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        if (NCMUtils.isPlannedAuxAlloc((Context)ctx, (String)companyId)) {
            StringBuffer ksql = new StringBuffer();
            ksql.append("select distinct \n");
            ksql.append("    a.FNumber, \n");
            ksql.append("    a.FName_" + ctx.getLocale() + " FName \n");
            ksql.append("from T_NCM_InnerOverheadBill b \n");
            ksql.append("join T_NCM_InnerOverheadBillEntry e \n");
            ksql.append("    on e.FParentID = b.FID \n");
            ksql.append("join T_NCM_AUXOverhead a \n");
            ksql.append("    on a.FID = e.FAuxOverheadID \n");
            ksql.append("left join T_NCM_AUXOverheadCompanyInfo ac \n");
            ksql.append("    on ac.FCompanyID = '" + companyId + "' \n");
            ksql.append("    and ac.FAUXOverheadID = a.FID \n");
            ksql.append("where b.FCompanyOrg = '" + companyId + "' \n");
            ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("    and b.FBillStatus = 4 \n");
            ksql.append("    and ( ac.FStdPrice is null or ac.FStdPrice = 0 ) \n");
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            String reason = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.AuxAllocatorResource", (String)"Reason_Item_Alloc_AuxOverheadNoSTDCost", (Locale)ctx.getLocale());
            String advice = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.AuxAllocatorResource", (String)"Advice_Item_Alloc_AuxOverheadNoSTDCost", (Locale)ctx.getLocale());
            while (rs.next()) {
                String auxOverhead = "[" + rs.getString("FNumber") + ":" + rs.getString("FName") + "]";
                AllocateException one = new AllocateException(AllocateException.ITEM_ALLOC_AUXOVERHEADNOSTDCOST, new Object[]{auxOverhead});
                this.processAllocateException(one, reason, advice);
                result = CostTaskResultEnum.FAILURE;
            }
        }
        return result;
    }

    @Override
    public AllocTable getAllocTable() {
        if (!(this._allocTable instanceof AuxAllocTable)) {
            Context ctx = (Context)this._param.get("ctx");
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            this._param.put("pool", pool);
            AuxAllocTable allocTable = new AuxAllocTable(this._param);
            this.setAllocTable(allocTable);
        }
        return this._allocTable;
    }

    @Override
    public FeeData GetFeeDataControl() {
        if (this.getFeeData() == null) {
            this.setFeeData(new AuxFeeData(this._param));
        }
        return super.getFeeData();
    }

    @Override
    protected void appendWhereSQLClause(StringBuffer sb, String companyId, String periodId) {
        sb.append('\n').append(" AND  EXISTS ( ").append('\n').append(" \tSELECT 1  ").append('\n').append("\tFROM T_NCM_InnerOverheadBill B ").append('\n').append("\tRIGHT OUTER JOIN T_NCM_InnerOverheadBillEntry E ON B.FID = E.FParentID ").append('\n').append("   INNER JOIN T_ORG_CostCenter CC ON CC.FID = E.FConsumeCostCenterID ").append('\n').append("\tWHERE  B.FBillStatus=4 AND CC.FCostCenterType IN (0,1) AND B.FCompanyOrg = '").append(companyId).append("'     AND B.FCalculatePeriod = '").append(periodId).append("'").append('\n').append("   AND data.FCostCenterOrgUnitID = CC.FID   ) ").append('\n');
    }

    @Override
    protected void appendSQLForInsertAuxAllocObjRangeTbl(String tblObjRange, StringBuffer sb) throws AllocateException {
        if (StringUtils.isEmpty((String)this._tblAllocObjectRange)) {
            super.setTblAllocObjectRange(tblObjRange);
        }
        sb.append("INSERT INTO ").append(tblObjRange).append(" (FID,FCostCenterID,FCostObjectID,FCostItemID,FIsValid,FConsumeCostCenterID,FConsumeCostObjectID ,FAuxOverheadID )").append('\n').append("SELECT newbosid('08F65F4A') AS FId, FCostCenterID,FCostObjectID, null As FCostItemID, FIsValid,").append("\t\t\t\t\t\t\t\t\t FConsumeCostCenterID,FConsumeCostObjectID,FAuxOverheadID ").append('\n').append("FROM (").append('\n').append("\tSELECT DISTINCT B.FCostCenterID as FCostCenterID,CO.FID as FCostObjectID, 1 As FIsValid , ").append('\n').append("   E.FConsumeCostCenterID as FConsumeCostCenterID,E.FConsumeCostObjectID as FConsumeCostObjectID ,E.FAuxOverheadID ").append('\n').append("\tFROM T_NCM_InnerOverheadBill B ").append('\n').append("\tRIGHT OUTER JOIN T_NCM_InnerOverheadBillEntry E ON B.FID = E.FParentID ").append('\n').append("   INNER JOIN T_ORG_CostCenter CC ON CC.FID = E.FConsumeCostCenterID ").append("\tINNER JOIN T_BD_CostObjectEntry COE ON COE.FRelatedID = E.FAuxOverheadID ").append('\n').append("\tINNER JOIN T_BD_CostObject CO ON CO.FID = COE.FParentID AND CO.FCompanyID = B.FCompanyOrg ").append('\n').append("\tWHERE  B.FBillStatus=4 AND CC.FCostCenterType IN (0,1) AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n').append(") As A ").append('\n').append(" WHERE NOT EXISTS ( ").append('\n').append(" \tSELECT 1 FROM ").append(tblObjRange).append(" RN ").append('\n').append(" \tWHERE RN.FCostCenterID=A.FCostCenterID AND RN.FCostObjectID=A.FCostObjectID ) ").append('\n');
    }

    @Override
    protected void fillObjectRange() throws AllocateException {
        super.fillObjectRange();
    }

    @Override
    protected void InsertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
        FeeData iFee = this.GetFeeDataControl();
        String sqlDirectFee = iFee.GetDirectFeeDataSql();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO {0} ( ").append("FID \t\t\t\t    ,FCompanyID \t\t\t,FCalculatePeriodID \t,FSourceBillID \t\t\t,FSourceBillEntryID \t,FSourceBillEntrySeq \t,FAuxOverheadID\t\t\t,FCostCenterID \t\t\t,FCostObjectID \t\t\t,FExpenseID \t\t\t,FCostItemID \t\t\t,FAllocStdID \t\t\t,FAllocStdData \t\t\t,FAllocQty \t\t\t\t,FTotalQty \t\t\t\t,FPrice \t\t\t\t,FAmount \t\t\t\t,FIsDirect \t\t\t\t ").append(" ) ").append('\n').append(" SELECT newbosid(''BCAAC063'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,").append('\n').append(" \"ID\" As FSourceBillID,\"ENTRYS.ID\" As FSourceBillEntryID,\"ENTRYS.Seq\" As FSourceBillEntrySeq,").append(" \"AUXOVERHEAD.ID\" As FAuxOverheadID,\"CONSUMECOSTCENTER.ID\" As FCostCenterID, ").append('\n').append(" \"CONSUMECOSTOBJECT.ID\" As FCostObjectID,\"EXPENSE.ID\" As FExpenseID, NULL As FCostItemID, null As FAllocStdID,").append('\n').append(" 1 As FAllocStdData, 0 As FAllocQty, ISNULL(\"ENTRYS.QTY\",0) As FTotalQty, ").append('\n').append(" \"ENTRYS.ACTUALPRICE\" As FPrice, ISNULL(\"ENTRYS.ACTUALAMOUNT\",0) As FAmount,1 As FIsDirect ").append('\n').append(" FROM ( {3} ) S ").append('\n');
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, sqlDirectFee);
        try {
            NCMDbUtil.execute((Context)ctx, (String)sqlInsert);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    @Override
    protected String GetSql_InsertIndirectData(String companyId, String periodId, String userId, String allocStdId, IFeeInfo currFee) throws AllocateException {
        if (AllocStdTypeEnum.AUX.equals((Object)this.getAllocStd().getAllocStdType())) {
            return this.innerOverheadBill_GetSql_InsertIndirectData(companyId, periodId, userId, allocStdId, currFee);
        }
        StringBuffer sb = new StringBuffer();
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        int qtyPrecision = currFee.getPrecision("auxOverhead.qtyPrecision");
        fm.setMaximumFractionDigits(qtyPrecision);
        String strQty = fm.format(currFee.GetQty());
        sb.append("INSERT INTO {0} ( ").append("FID \t\t\t\t    ,FCompanyID \t\t\t,FCalculatePeriodID \t,FSourceBillID \t\t\t,FSourceBillEntryID \t,FSourceBillEntrySeq \t,FAuxOverheadID\t\t\t,FCostCenterID \t\t\t,FCostObjectID \t\t\t,FExpenseID \t\t\t,FCostItemID \t\t\t,FAllocStdID \t\t\t,FAllocStdData \t\t\t,FAllocQty \t\t\t\t,FTotalQty \t\t\t\t,FPrice \t\t\t\t,FAmount \t\t\t\t,FIsDirect \t\t\t\t ").append(" ) ").append('\n').append(" SELECT newbosid(''BCAAC063'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,").append('\n').append(" ''{3}'' As FSourceBillID,''{4}'' As FSourceBillEntryID,{5} As FSourceBillEntrySeq,R.FAuxOverheadID,").append('\n').append(" R.FCostCenterID,R.FCostObjectID,''{6}'' As FExpenseID,''{7}'' As FCostItemID, ''{8}'' As FAllocStdID,").append('\n').append(" D.FQty As FAllocStdData, ROUND({9} * D.FRatio,{10})As FAllocQty, ").append('\n').append(" ROUND({11} * D.FRatio ,{12}) As FTotalQty,0 As FPrice,0 As FAmount, 0 As FIsDirect ").append('\n').append("FROM {13} R ").append('\n').append("INNER JOIN {14} D ON D.FID=R.FID ").append('\n').append("WHERE R.FIsValid =1 ");
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append(" AND D.FRatio <>0 ");
        }
        sb.append(";");
        String costItemId = currFee.GetCostItemId();
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, currFee.GetId(), currFee.GetEntryId(), currFee.GetEntrySeq(), currFee.GetExpenseId(), costItemId, this.getAllocStd().getId().toString(), strQty, String.valueOf(qtyPrecision), strQty, String.valueOf(qtyPrecision), this.getTblAllocObjectRange(), this.getTblAllocData(), currFee.GetConsumeCostCenterId());
        return sqlInsert;
    }

    private String innerOverheadBill_GetSql_InsertIndirectData(String companyId, String periodId, String userId, String allocStdId, IFeeInfo currFee) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        int qtyPrecision = currFee.getPrecision("auxOverhead.qtyPrecision");
        fm.setMaximumFractionDigits(qtyPrecision);
        String strQty = fm.format(currFee.GetQty());
        sb.append("INSERT INTO {0} ( ").append("FID \t\t\t\t    ,FCompanyID \t\t\t,FCalculatePeriodID \t,FSourceBillID \t\t\t,FSourceBillEntryID \t,FSourceBillEntrySeq \t,FAuxOverheadID\t\t\t,FCostCenterID \t\t\t,FCostObjectID \t\t\t,FExpenseID \t\t\t,FCostItemID \t\t\t,FAllocStdID \t\t\t,FAllocStdData \t\t\t,FAllocQty \t\t\t\t,FTotalQty \t\t\t\t,FPrice \t\t\t\t,FAmount \t\t\t\t,FIsDirect \t\t\t\t ").append(" ) ").append('\n').append(" SELECT newbosid(''BCAAC063'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,").append('\n').append(" ''{3}'' As FSourceBillID,''{4}'' As FSourceBillEntryID,{5} As FSourceBillEntrySeq,R.FAuxOverheadID, ").append('\n').append(" R.FCostCenterID,R.FCostObjectID,''{6}'' As FExpenseID,''{7}'' As FCostItemID, ''{8}'' As FAllocStdID,").append('\n').append(" D.FQty As FAllocStdData, ROUND({9} * D.FRatio,{10})As FAllocQty, ").append('\n').append(" ROUND({11} * D.FRatio ,{12}) As FTotalQty, 0 As FPrice,0 As FAmount,0 As FIsDirect ").append('\n').append("FROM {13} R ").append('\n').append("INNER JOIN {14} D ON D.FID=R.FID ").append('\n').append("WHERE R.FIsValid =1 ");
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append(" AND D.FRatio <>0 ");
        }
        sb.append(" AND R.FCostCenterID = ''{15}''  ");
        sb.append(";");
        String costItemId = currFee.GetCostItemId();
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, currFee.GetId(), currFee.GetEntryId(), currFee.GetEntrySeq(), currFee.GetExpenseId(), costItemId, this.getAllocStd().getId().toString(), strQty, String.valueOf(qtyPrecision), strQty, String.valueOf(qtyPrecision), this.getTblAllocObjectRange(), this.getTblAllocData(), currFee.GetConsumeCostCenterId());
        StringBuffer sql = new StringBuffer();
        sql.append('\n').append("DELETE {0} ").append('\n').append(" WHERE  fid NOT IN (SELECT   Max(fid) fid").append('\n').append("             FROM     {1} ").append('\n').append("             WHERE    FSourceBillEntryID = ''{2}'' ").append('\n').append("             GROUP BY FCostCenterID,").append('\n').append("                      fcostobjectid)").append('\n').append(" AND FSourceBillEntryID = ''{3}'' ; ").append('\n');
        String delete = MessageFormat.format(sql.toString(), this.getTblResult(), this.getTblResult(), currFee.GetEntryId(), currFee.GetEntryId());
        return sqlInsert + delete;
    }

    @Override
    protected String GetSql_AdjustDiff(IFeeInfo currFee) throws AllocateException {
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        int qtyPrecision = currFee.getPrecision("auxOverhead.qtyPrecision");
        fm.setMaximumFractionDigits(qtyPrecision);
        String strQty = fm.format(currFee.GetQty());
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} SET FAllocQty=(FAllocQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAllocQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(") ").append('\n').append(", FTotalQty=(FTotalQty + {5} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAllocQty),0.00) ").append('\n').append("\tFROM {6} S").append('\n').append("\tWHERE S.FSourceBillID=''{7}'' AND S.FSourceBillEntryID=''{8}'')").append('\n').append(") ").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {9} ").append('\n').append("\tWHERE FSourceBillID=''{10}'' AND FSourceBillEntryID=''{11}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustQty = MessageFormat.format(sb.toString(), this.getTblResult(), strQty, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), strQty, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        sb.delete(0, sb.length());
        return sqlAdjustQty + '\n';
    }

    @Override
    protected void updateDefaultCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} AS R SET (FCostItemID)=(").append('\n').append("\tSELECT distinct Exc.FCostItemID").append('\n').append("\tFROM T_NCM_ExpenseCompanyInfo Exc").append('\n').append("\tINNER JOIN T_NCM_AUXOverheadCompanyInfo Auxc ON FDefaultExpenseID=Exc.FExpenseID ").append('\n').append("\t\t  AND Exc.FCompanyOrgUnitID = Auxc.FCompanyID  ").append('\n').append("\tINNER JOIN T_NCM_InnerOverheadBillEntry OBE ON OBE.FAuxOverheadID=Auxc.FAUXOverheadID").append('\n').append("\tINNER JOIN T_NCM_InnerOverheadBill OB ON OB.FID=OBE.FParentID").append('\n').append("\t\t  AND OB.FCompanyOrg = Auxc.FCompanyID  ").append('\n').append("\twhere OB.FBillStatus = 4 and OB.FID=R.FSourceBillID AND OBE.FID =R.FSourceBillEntryID AND Exc.FCompanyOrgUnitID=''{1}'')").append('\n').append("WHERE R.FCompanyID=''{2}'' AND R.FCalculatePeriodID=''{3}'' AND (R.FCostItemID IS NULL or R.FCostItemID ='''') ");
        String sqlUpdateCostItem_Expense = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, companyId, periodId);
        try {
            NCMDbUtil.execute((Context)ctx, (String)sqlUpdateCostItem_Expense);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    protected String setPhsicalTblBill() {
        return "T_NCM_InnerOverheadBill";
    }

    protected String setPhsicalTblEntry() {
        return "T_NCM_InnerOverheadBillEntry";
    }

    protected String setFCostCenterOrgUnitID() {
        return "FConsumeCostCenterID";
    }

    @Override
    protected void removeNoCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT DISTINCT OB.FNumber, OBE.FSeq ").append("FROM {0} D ").append("INNER JOIN T_NCM_InnerOverheadBillEntry OBE ON OBE.FID=D.FSourceBillEntryID ").append("INNER JOIN T_NCM_InnerOverheadBill OB ON OB.FID=D.FSourceBillID ").append("WHERE D.FCompanyID=''{1}'' AND D.FCalculatePeriodID=''{2}'' AND D.FCostItemID IS NULL");
        String sqlNoCostItem = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId);
        sb.delete(0, sb.length());
        sb.append("DELETE {0} ").append("WHERE FCompanyID=''{1}'' AND FCalculatePeriodID=''{2}'' AND FCostItemID IS NULL");
        String sqlDeleteNoCostItem = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId);
        try {
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sqlNoCostItem);
            rs.first();
            if (rs.getRow() > 0) {
                NCMDbUtil.execute((Context)ctx, (String)sqlDeleteNoCostItem);
            }
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                String number = rs.getString("FNumber");
                String seq = String.valueOf(rs.getInt("FSeq"));
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NODEFAULT_COSTITEM_OTHER, new Object[]{number, seq}), null, null);
                rs.next();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
    }

    @Override
    protected void removeInvalidCostObject(Context ctx, String companyId, String periodId) throws AllocateException {
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT top 100 MB.FNumber, ME.FSeq, CO.FName_L2 As FCostObjectName, D.FID AS inValidId, CC.FCostCenterType FCostCenterType ").append('\n').append("FROM {0} D ").append('\n').append("INNER JOIN ").append(this.setPhsicalTblEntry()).append(" ME ON ME.FID=D.FSourceBillEntryID ").append('\n').append("INNER JOIN ").append(this.setPhsicalTblBill()).append(" MB ON MB.FID=D.FSourceBillID ").append('\n').append("INNER JOIN t_bd_CostObject CO ON CO.FID=D.FCostObjectID ").append('\n').append("INNER JOIN T_ORG_CostCenter CC ON ME.").append(this.setFCostCenterOrgUnitID()).append("=CC.FID ").append('\n').append(" left outer join {1} S on s.fcostcenterid=d.fcostcenterid and s.fcostobjectid=d.fcostobjectid ").append('\n').append("WHERE D.FCompanyID=''{2}'' AND D.FCalculatePeriodID=''{3}'' ").append('\n').append(" and MB.fcompanyorg=''{4}'' ").append('\n').append(" and S.FID is null ").append('\n');
        String sqlInvalidCostObject = MessageFormat.format(sb.toString(), this.getTblResult(), tblObjRange, companyId, periodId, companyId);
        sb.delete(0, sb.length());
        try {
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sqlInvalidCostObject);
            rs.first();
            if (rs.getRow() > 0) {
                StringBuffer inVaildIds = new StringBuffer();
                rs.first();
                while (rs.getRow() > 0 && !rs.isAfterLast()) {
                    if (inVaildIds.length() > 0) {
                        inVaildIds.append(",");
                    }
                    inVaildIds.append("'").append(rs.getString("inValidId")).append("'");
                    rs.next();
                }
                sb.append("DELETE ").append(this.getTblResult()).append(" WHERE FID in (").append(inVaildIds).append(")").append('\n');
                NCMDbUtil.execute((Context)ctx, (String)sb.toString());
                NumericExceptionSubItem except = null;
                rs.first();
                while (rs.getRow() > 0 && !rs.isAfterLast()) {
                    String number = rs.getString("FNumber");
                    String seq = String.valueOf(rs.getInt("FSeq"));
                    String costObjName = rs.getString("FCostObjectName");
                    int costCenterType = rs.getInt("FCostCenterType");
                    except = costCenterType == 1 ? AllocateException.ITEM_ALLOC_INVALID_AUSCOSTOBJ : AllocateException.ITEM_ALLOC_INVALID_COSTOBJ;
                    this.processAllocateException(new AllocateException(except, new Object[]{number, seq, costObjName}), null, null);
                    rs.next();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
        }
    }

    @Override
    protected boolean crossCostObjectSuiteRange(IFeeInfo currFee) throws AllocateException {
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        this.bRangeChanged = false;
        if (!(this.lastCostCenterId == null && currFee.GetConsumeCostCenterId() == null || this.lastCostCenterId != null && this.lastCostCenterId.equals(currFee.GetConsumeCostCenterId()))) {
            StringBuffer sb = new StringBuffer();
            String sqlInit = "UPDATE " + tblObjRange + " SET FIsValid = 0 ";
            sb.append("UPDATE ").append(tblObjRange).append(" SET FIsValid= 1 WHERE FCostCenterID = ? ");
            Object[] params = new Object[]{currFee.GetConsumeCostCenterId()};
            try {
                Context ctx = (Context)this._param.get("ctx");
                NCMDbUtil.execute((Context)ctx, (String)sqlInit);
                NCMDbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
                sb.delete(0, sb.length());
            }
            catch (BOSException e) {
                log.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
            this.lastCostCenterId = currFee.GetConsumeCostCenterId();
            this.bRangeChanged = true;
        }
        return false;
    }

    @Override
    public AllocStdInfo GetAllocStdSetting(IFeeInfo currFee) throws AllocateException {
        AllocStdInfo setting = this.GetAllocStdFromCache(currFee);
        if (setting == null) {
            this._logger.AddLog(new AllocateException(AllocateException.ITEM_AUXALLOC_NOTSET, new Object[]{currFee.GetAUXOverheadNumber().concat(" ").concat(currFee.GetAUXOverheadName()), currFee.GetCostCenterNumber().concat(" ").concat(currFee.GetCostCenterName())}));
        } else if (AllocStdTypeEnum.AUX.equals((Object)setting.getAllocStdType())) {
            String companyId = this._param.get("companyId").toString();
            Context ctx = (Context)this._param.get("ctx");
            Map checkAssistant = AllocUtils.checkAssistantCostObject(ctx, companyId, this._param.get("periodId").toString(), currFee.GetConsumeCostCenterId());
            boolean existOverHead = (Boolean)checkAssistant.get("existOverHead");
            if (!existOverHead) {
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_INPUT_AUS_CC, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetConsumeCostCenterName()}), null, null);
            } else {
                boolean existAUXOHcostObj = (Boolean)checkAssistant.get("existAUXOHcostObj");
                if (!existAUXOHcostObj) {
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_INPUT_AUSOBJ_CC, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetConsumeCostCenterName()}), null, null);
                }
            }
        }
        return setting;
    }

    @Override
    protected AllocStdInfo GetAllocStdFromCache(IFeeInfo currFee) {
        Context ctx = (Context)this._param.get("ctx");
        if (this.allocStdSettingCache == null) {
            String companyId = this._param.get("companyId").toString();
            String periodId = this._param.get("periodId").toString();
            StringBuffer sb = new StringBuffer();
            this.allocStdSettingCache = new HashMap();
            String auxOverheadId = null;
            String costCenterId = null;
            String key = null;
            try {
                sb.append(" Select std.FCostCenterID,std.FAuxOverHeadID,FallocStdID ").append(" From t_ncm_AllocStdSetByAUXOverhead std ").append(" Where std.FcompanyID = ? ").append("\t AND std.FcalculatePeriodId = ? ").append("\t AND FallocStdID is not null ");
                IRowSet rs = NCMDbUtil.executeQueryNoTx((Context)ctx, (String)sb.toString(), (Object[])new String[]{companyId, periodId});
                while (rs.next()) {
                    costCenterId = rs.getString(1);
                    auxOverheadId = rs.getString(2);
                    key = auxOverheadId + "_" + costCenterId;
                    this.allocStdSettingCache.put(key, rs.getString(3));
                }
            }
            catch (Exception e) {
                this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e));
                logger.error((Object)"", (Throwable)e);
            }
        }
        String allocStdID = (String)this.allocStdSettingCache.get(currFee.GetAUXOverheadId() + "_" + currFee.GetConsumeCostCenterId());
        try {
            return allocStdID == null ? null : AllocStdFactory.getLocalInstance((Context)ctx).getAllocStdInfo((IObjectPK)new ObjectUuidPK(allocStdID));
        }
        catch (Exception e) {
            this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e));
            logger.fatal((Object)"", (Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean initAllocDataTable() throws AllocateException {
        if (!AllocStdTypeEnum.AUX.equals((Object)this.getAllocStd().getAllocStdType())) {
            return super.initAllocDataTable();
        }
        Context ctx = (Context)this._param.get("ctx");
        String fieldList = this._ausCtx.GetFieldListForQuery();
        String fldAstList = this._ausCtx.GetMergeFormatStr("0 As {0}", ",");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer();
        sb.append("truncate table ").append(this.getTblAllocData()).append(";").append('\n');
        sb.append("INSERT INTO ").append(this.getTblAllocData()).append("(FID,").append(fieldList).append("FQty,FRatio,FRatioSum)").append('\n').append("Select FID,").append(fldAstList).append("0 As FQty, 0 As FRatio, 0 As FRatioSum ").append('\n').append("from ").append(this.getTblAllocObjectRange()).append('\n').append("where FIsValid =1 ");
        try {
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    @Override
    protected boolean updateAllocDataTable() throws AllocateException {
        if (!AllocStdTypeEnum.AUX.equals((Object)this.getAllocStd().getAllocStdType())) {
            return super.updateAllocDataTable();
        }
        Context ctx = (Context)this._param.get("ctx");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this._ausCtx.GetAllocStdUnitDataSql()).append('\n');
            sb.append(this._ausCtx.GetAllocStdFormulaUpdateSql()).append(";").append('\n');
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" SET FQty = 0 WHERE FQty < 0 ;").append('\n');
            sb.append("UPDATE ").append(this.getTblAllocData()).append(" AS ADT").append('\n').append(" SET  FRatioSum = (SELECT   Sum(A.FQty)").append('\n').append("         FROM     (SELECT DISTINCT FCostCenterID,FCostObjectID,FQty").append('\n').append("                   FROM   ").append(this.getTblAllocObjectRange()).append(" r").append('\n').append("                          INNER JOIN ").append(this.getTblAllocData()).append(" ad").append('\n').append("                                  ON ad.Fid = r.Fid").append('\n').append("                   WHERE  AD.FQty <> 0  ) A").append('\n').append("              INNER JOIN ").append(this.getTblAllocObjectRange()).append(" RN").append('\n').append("                          ON RN.FCostCenterID = A.FCostCenterID").append('\n').append("         WHERE    ADT.FID = RN.FID").append('\n').append("         GROUP BY A.FCostCenterID) ; ").append('\n');
            sb.append('\n').append(" UPDATE ").append(this.getTblAllocData()).append("    SET  FRatio = Round( FQty / FRatioSum, 12) ; ").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean checkNoAllocStdData(IFeeInfo currFee) throws AllocateException {
        IRowSet rs;
        boolean hasNoAllocStdData;
        block8: {
            if (!AllocStdTypeEnum.AUX.equals((Object)this.getAllocStd().getAllocStdType())) {
                return super.checkNoAllocStdData(currFee);
            }
            hasNoAllocStdData = false;
            Context ctx = (Context)this._param.get("ctx");
            StringBuffer sb = new StringBuffer();
            sb.append("Select top 1 FQty ").append(" FROM ").append(this.getTblAllocData()).append(" ").append("  D INNER JOIN ").append(this.getTblAllocObjectRange()).append(" R ON D.FID =  R.FID ").append(" WHERE FQty <> 0 AND R.FCostCenterID = ? ");
            rs = null;
            try {
                rs = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{currFee.GetConsumeCostCenterId()});
                if (rs.next()) break block8;
                hasNoAllocStdData = true;
                String[] hint = this._ausCtx.GetNoAllocStdDataHint();
                if (!this._param.containsKey("allocStdID")) {
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_ALLOCSTDDATA, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), this.getAllocStd().getName()}), hint[0], hint[1]);
                    break block8;
                }
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_ALLOCSTDDATA, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), this.getAllocStd().getName()}), this.getAllocStd().getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"22_BaseAllocator", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"53_AuxAllocator", (Locale)ctx.getLocale()));
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
                SQLUtils.cleanup((ResultSet)rs);
            }
            catch (SQLException e2) {
                logger.error((Object)"", (Throwable)e2);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e2), null, null);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return hasNoAllocStdData;
    }

    @Override
    public void endProcess() throws AllocateException {
        try {
            super.endProcess();
            String companyId = this._param.get("companyId").toString();
            String periodId = this._param.get("periodId").toString();
            Context ctx = (Context)this._param.get("ctx");
            ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo company = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
            int amtPrecision = currency.getPrecision();
            if (NCMUtils.isAlgebraicdAuxAlloc((Context)ctx, (String)companyId)) {
                AuxAllocator.syncBillToAllocResult(this._allocTable.GetResultTable(), amtPrecision, companyId, periodId, ctx);
                this.adjustDiff_AllocResult(this._allocTable.GetResultTable(), companyId, periodId, ctx);
            } else {
                AuxAllocator.writeCostToBillByPlannedCost(ctx, companyId, periodId);
                AuxAllocator.syncBillToAllocResult(this._allocTable.GetResultTable(), amtPrecision, companyId, periodId, ctx);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    public static void writeCostToBillByPlannedCost(Context ctx, String companyId, String periodId) throws BOSException, EASBizException {
        ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
        int amtPrecision = currency.getPrecision();
        StringBuffer ksql = new StringBuffer();
        ksql.append("update T_NCM_InnerOverheadBillEntry as e set (FActualPrice) = ( ");
        ksql.append("    select \n");
        ksql.append("        ac.FStdPrice \n");
        ksql.append("    from T_NCM_AUXOverheadCompanyInfo ac \n");
        ksql.append("    where ac.FCompanyID = '" + companyId + "' \n");
        ksql.append("    and ac.FAUXOverheadID = e.FAuxOverheadID \n");
        ksql.append(") \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from T_NCM_InnerOverheadBill b \n");
        ksql.append("    where b.FID = e.FParentID \n");
        ksql.append("    and b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update T_NCM_InnerOverheadBillEntry as e set FActualAmount = ( ");
        ksql.append("    round(FQty * FActualPrice, " + amtPrecision + ") \n");
        ksql.append(") \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from T_NCM_InnerOverheadBill b \n");
        ksql.append("    where b.FID = e.FParentID \n");
        ksql.append("    and b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append(") \n");
        ksql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)ksql.toString());
    }

    public static void syncBillToAllocResult(String _tblAuxAllocResult, int amtPrecision, String companyId, String periodId, Context ctx) throws BOSException {
        StringBuffer updates = new StringBuffer();
        updates.append('\n').append(" UPDATE ").append(_tblAuxAllocResult).append(" AS ARS SET (FPrice,FAuxOverheadID) = ").append('\n').append(" (SELECT entry.FActualPrice,entry.FAuxOverheadID ").append('\n').append("  FROM   T_NCM_InnerOverheadBillEntry As entry ").append('\n').append("   INNER JOIN ").append(_tblAuxAllocResult).append(" RS on RS.FSourceBillEntryID = entry.FID ").append('\n').append(" WHERE RS.FCompanyID =''{0}'' AND RS.FCalculatePeriodID =''{1}''\tAND RS.FID = ARS.FID   ").append('\n').append(" ) ; ").append('\n');
        updates.append(" UPDATE ").append(_tblAuxAllocResult).append(" AS ARS SET (FAmount) = ").append('\n').append(" (SELECT Round(RS.FTotalQty * entry.FActualPrice,").append(amtPrecision).append(")").append('\n').append("  FROM   T_NCM_InnerOverheadBillEntry As entry ").append('\n').append("   INNER JOIN ").append(_tblAuxAllocResult).append(" RS on RS.FSourceBillEntryID = entry.FID ").append('\n').append(" WHERE RS.FCompanyID =''{2}'' AND RS.FCalculatePeriodID =''{3}''\tAND RS.FID = ARS.FID   ").append('\n').append(" ) ; ").append('\n');
        String updatesSQL = MessageFormat.format(updates.toString(), companyId, periodId, companyId, periodId);
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)updatesSQL);
    }

    private void adjustDiff_AllocResult(String _tblAuxAllocResult, String _companyId, String _periodId, Context _ctx) throws BOSException {
        StringBuffer select = new StringBuffer();
        select.append("Select D.FEntryID, (S.FSrcSumAmount - D.FDestSumAmount ) As FAmountDiff ").append('\n').append(" FROM (").append('\n').append(" \tSELECT AAR.FSourceBillEntryID FEntryID, SUM(AAR.FAmount) FDestSumAmount ").append('\n').append(" \tFROM ").append(_tblAuxAllocResult).append(" as AAR ").append('\n').append(" \tWHERE AAR.FCompanyID= ''{0}'' AND AAR.FCalculatePeriodID= ''{1}'' ").append('\n').append(" \tGROUP by AAR.FSourceBillEntryID ").append('\n').append(" ) D ").append('\n').append(" LEFT JOIN (").append('\n').append(" \tSELECT entry.FID FEntryID, SUM(entry.FActualAmount) FSrcSumAmount ").append('\n').append(" \tFROM T_NCM_InnerOverheadBill bill ").append('\n').append(" \tLEFT JOIN T_NCM_InnerOverheadBillEntry entry ON entry.FParentid=bill.FID ").append('\n').append(" \tLEFT JOIN T_ORG_CostCenter cc ON cc.FID = entry.FConsumeCostCenterID ").append('\n').append(" \tLEFT JOIN T_BD_CostObject AS OBJ ON OBJ.FRelatedID = entry.FAuxOverheadID and bill.FCompanyorg = OBJ.FCompanyID").append('\n').append(" \tWHERE bill.FBillStatus=4 AND bill.FCompanyOrg = ''{2}'' ").append('\n').append(" \t\tAND bill.FCalculatePeriod = ''{3}'' ").append('\n').append(" \t\tAND FCostCenterType in (0, 1) ").append('\n').append(" \tGROUP BY entry.FID ").append('\n').append(" ) S ON D.FEntryID=S.FEntryID ").append('\n').append(" Where  D.FDestSumAmount <> S.FSrcSumAmount").append('\n');
        StringBuffer derivedA = new StringBuffer();
        derivedA.append("  (Select top 1 AAR.FID ").append('\n').append(" \tFROM ").append(_tblAuxAllocResult).append(" as AAR ").append('\n').append(" \tLEFT JOIN T_ORG_CostCenter CC ON CC.FID = AAR.FCostCenterID ").append('\n').append(" \tWHERE AAR.FCompanyID= ? AND AAR.FCalculatePeriodID= ? ").append('\n').append("        and AAR.FSourceBillEntryID = ? AND CC.FCostCenterType <> 1 ").append('\n').append("\tORDER BY AAR.FAmount DESC ").append('\n').append("  ) AS A ").append('\n');
        StringBuffer derivedB = new StringBuffer();
        derivedB.append("  (Select top 1 AAR.FID ").append('\n').append(" \tFROM ").append(_tblAuxAllocResult).append(" as AAR ").append('\n').append(" \tLEFT JOIN T_ORG_CostCenter CC ON CC.FID = AAR.FCostCenterID ").append('\n').append(" \tWHERE AAR.FCompanyID= ? AND AAR.FCalculatePeriodID= ? ").append('\n').append("        and AAR.FSourceBillEntryID = ? AND CC.FCostCenterType = 1 ").append('\n').append("\tORDER BY AAR.FAmount DESC ").append('\n').append("  ) AS B ").append('\n');
        StringBuffer update = new StringBuffer();
        update.append("UPDATE ").append(_tblAuxAllocResult).append(" SET FAmount =(FAmount+?) ").append('\n').append("WHERE FID =( ").append('\n').append(" SELECT ISNULL(A,B) ").append('\n').append(" FROM ( select ").append(derivedA).append(" , ").append(derivedB).append(") AS C ) ").append('\n');
        String select2 = MessageFormat.format(select.toString(), _companyId, _periodId, _companyId, _periodId);
        IRowSet rs = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            rs = NCMDbUtil.executeQuery((Context)_ctx, (String)select2);
            if (rs.size() == 0) {
                return;
            }
            conn = EJBFactory.getConnection((Context)_ctx);
            pstmt = conn.prepareStatement(update.toString());
            while (rs.next()) {
                pstmt.setDouble(1, rs.getDouble("FAmountDiff"));
                pstmt.setString(2, _companyId);
                pstmt.setString(3, _periodId);
                pstmt.setString(4, rs.getString("FEntryID"));
                pstmt.setString(5, _companyId);
                pstmt.setString(6, _periodId);
                pstmt.setString(7, rs.getString("FEntryID"));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, pstmt, conn);
        }
    }
}

