/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.ncm.bill.EopWipAdjustEntryInfo;
import com.kingdee.eas.ncm.bill.EopWipAdjustFactory;
import com.kingdee.eas.ncm.bill.EopWipAdjustInfo;
import com.kingdee.eas.ncm.bill.EopWipAdjustMatDetailInfo;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.app.AbstractEopWipAdjustControllerBean;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMGenVoucherHelper;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EopWipAdjustControllerBean
extends AbstractEopWipAdjustControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.EopWipAdjustControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkIsDup(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkIsDup(ctx, model);
        EopWipAdjustInfo info = (EopWipAdjustInfo)model;
        for (int i = 0; i < info.getEntries().size(); ++i) {
            if (info.getEntries().get(i).getCostItem() == null) continue;
            String costItemID = info.getEntries().get(i).getCostItem().getId().toString();
            CostItemInfo costItem = CostItemFactory.getLocalInstance((Context)ctx).getCostItemInfo((IObjectPK)new ObjectUuidPK(costItemID));
            if (costItem.getItemType().equals((Object)CostItemEnum.STUFF) || info.getEntries().get(i).getId() == null) continue;
            DbUtil.execute((Context)ctx, (String)"delete T_NCM_EopWipAdjustMatDetail  where FParentID=?", (Object[])new Object[]{info.getEntries().get(i).getId().toString()});
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected IObjectValue _updateBigObject(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        return null;
    }

    @Override
    protected IObjectValue _getBalanceData(Context ctx, String companyid, String periodid, String costobjectid, String costcenterid) throws BOSException {
        String EopWip = null;
        String EopWipEntry = null;
        String EopWipMatDetail = null;
        EopWipAdjustInfo info = new EopWipAdjustInfo();
        StringBuffer strSQL = new StringBuffer();
        info.setEopWipQty(SysConstant.BIGZERO);
        info.setFinishQty(SysConstant.BIGZERO);
        info.setAdjustQty(SysConstant.BIGZERO);
        try {
            EopWip = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyid, (String)"T_NCM_AllDataByCostObj");
            EopWipEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyid, (String)"T_NCM_CostCalResult");
            EopWipMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyid, (String)"T_NCM_CostCalMatDetailResult");
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
        }
        strSQL.append("select fid,isnull(FEopWIPQty,0) FEopWIPQty,isnull(FEopWIPHour,0) FEopWIPHour from ").append(EopWip).append(" where FCostCenterID='").append(costobjectid).append("' and FCostObjectID='").append(costcenterid).append("'").append(" and FCalculatePeriodID='").append(periodid).append("'");
        try {
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString());
            String parentid = null;
            if (rs1.size() > 0) {
                while (rs1.next()) {
                    info.setEopWipQty(rs1.getBigDecimal("FEopWIPQty"));
                    info.setFinishQty(rs1.getBigDecimal("FEopWIPQty"));
                    info.setSourceId(rs1.getString("fid"));
                    parentid = rs1.getString("fid");
                    BigDecimal hour = rs1.getBigDecimal("FEopWIPHour");
                    hour = hour.setScale(2, 4);
                    info.setEopWipHour(hour);
                    info.setFinishHour(hour);
                }
                strSQL.setLength(0);
                strSQL.append("select fid,FCostItemID,FEoPWIPAmount,isnull(FEoPWIPQty,0) FEoPWIPQty from ").append(EopWipEntry).append(" where FCostCenterID='").append(costobjectid).append("' and FCostObjectID='").append(costcenterid).append("'").append(" and FCalculatePeriodID='").append(periodid).append("'");
                IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString());
                if (rs2.size() > 0) {
                    while (rs2.next()) {
                        EopWipAdjustEntryInfo objectValueEntry = new EopWipAdjustEntryInfo();
                        objectValueEntry.setFinishAmount(rs2.getBigDecimal("FEoPWIPAmount"));
                        objectValueEntry.setAdjustAmount(SysConstant.BIGZERO);
                        objectValueEntry.setEopWipAmount(rs2.getBigDecimal("FEoPWIPAmount"));
                        objectValueEntry.setFinishQty(rs2.getBigDecimal("FEoPWIPQty"));
                        objectValueEntry.setAdjustQty(SysConstant.BIGZERO);
                        objectValueEntry.setEopWipQty(rs2.getBigDecimal("FEoPWIPQty"));
                        objectValueEntry.setSourceId(rs2.getString("fid"));
                        CostItemInfo costItemInfo = CostItemFactory.getLocalInstance((Context)ctx).getCostItemInfo((IObjectPK)new ObjectUuidPK(rs2.getString("FCostItemID")));
                        if (costItemInfo.getItemType().equals((Object)CostItemEnum.STUFF)) {
                            strSQL.setLength(0);
                            strSQL.append("select fid,FMaterialID,FEoPWIPQty,FEoPWIPAmount,FLot from ").append(EopWipMatDetail).append(" where FCostCenterID='").append(costobjectid).append("' and FCostObjectID='").append(costcenterid).append("'").append(" and FCalculatePeriodID='").append(periodid).append("'").append(" and FCostItemID='").append(rs2.getString("FCostItemID")).append("' \n");
                            IRowSet rs3 = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString());
                            if (rs3.size() > 0) {
                                while (rs3.next()) {
                                    EopWipAdjustMatDetailInfo matDetail = new EopWipAdjustMatDetailInfo();
                                    SelectorItemCollection select = new SelectorItemCollection();
                                    select.add("baseUnit.name");
                                    select.add("model");
                                    select.add("id");
                                    select.add("number");
                                    select.add("name");
                                    MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(rs3.getString("FMaterialID")), select);
                                    matDetail.setMaterial(material);
                                    matDetail.setEopWipQty(rs3.getBigDecimal("FEoPWIPQty"));
                                    matDetail.setEopWipAmount(rs3.getBigDecimal("FEoPWIPAmount"));
                                    matDetail.setSourceId(rs3.getString("fid"));
                                    matDetail.setBatchNo(rs3.getString("FLot"));
                                    objectValueEntry.getEntries().add(matDetail);
                                }
                            }
                        }
                        objectValueEntry.setCostItem(costItemInfo);
                        info.getEntries().add(objectValueEntry);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    @Override
    protected IObjectValue _getCostItemData(Context ctx, String companyid, String costobjectid, String costcenterid, String costitemid) throws BOSException, EASBizException {
        String EopWipEntry = null;
        EopWipAdjustEntryInfo objectValueEntry = new EopWipAdjustEntryInfo();
        objectValueEntry.setEopWipAmount(SysConstant.BIGZERO);
        objectValueEntry.setFinishAmount(SysConstant.BIGZERO);
        objectValueEntry.setEopWipQty(SysConstant.BIGZERO);
        objectValueEntry.setFinishQty(SysConstant.BIGZERO);
        StringBuffer strSQL = new StringBuffer();
        try {
            EopWipEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyid, (String)"T_NCM_CostCalResult");
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        strSQL.setLength(0);
        strSQL.append("select fid,isnull(FEoPWipAmount,0) FEoPWipAmount,isnull(FEoPWipQty,0) FEoPWipQty from ").append(EopWipEntry).append(" where  ").append(" FCostItemID='").append(costitemid).append("' and  FCostCenterID='").append(costcenterid).append("' and FCostObjectID='").append(costobjectid).append("'");
        try {
            IRowSet rs3 = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString());
            if (rs3.size() > 0) {
                while (rs3.next()) {
                    objectValueEntry.setEopWipAmount(rs3.getBigDecimal("FEoPWipAmount"));
                    objectValueEntry.setFinishAmount(rs3.getBigDecimal("FEoPWipAmount"));
                    objectValueEntry.setSourceId(rs3.getString("fid"));
                    objectValueEntry.setEopWipQty(rs3.getBigDecimal("FEoPWipQty"));
                    objectValueEntry.setFinishQty(rs3.getBigDecimal("FEoPWipQty"));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return objectValueEntry;
    }

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_EopWipAdjust";
    }

    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        super._audit(ctx, pks);
        this.saveToInitBalanceTables(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), pks, true);
        this.resetPhysicTableStatus(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), NCMUtils.GetCurrentPeriod((Context)ctx, (String)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()).getNumber());
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        super._unAudit(ctx, pks);
        this.saveToInitBalanceTables(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), pks, false);
        this.resetPhysicTableStatus(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), NCMUtils.GetCurrentPeriod((Context)ctx, (String)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()).getNumber());
    }

    private void resetPhysicTableStatus(Context ctx, String companyId, int periodId) {
        try {
            String tblPreTreatState = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalReportPreTreatState");
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append(" update " + tblPreTreatState);
            sql.append(" set FIsPreTreatreportData = 0,FIsPreTreatYearSum=0 where fperiodNUmber = " + periodId + ";\n\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveToInitBalanceTables(Context ctx, String companyId, IObjectPK[] pks, boolean isAudit) throws BOSException, EASBizException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (int i = 0; i < pks.length; ++i) {
            String[] pk = new String[]{pks[i].toString()};
            list.add(pk);
        }
        StringBuffer adjustIDs = BDCMUtils.splitPK((IObjectPK[])pks);
        String tempTable = null;
        StringBuffer createSql = new StringBuffer();
        try {
            StringBuffer sqlInsert3;
            String EopWip = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_AllDataByCostObj");
            String EopWipEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalResult");
            String EopWipMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalMatDetailResult");
            createSql.append("create table temptable ( FBillID varchar(44) ); ");
            tempTable = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)createSql.toString());
            StringBuffer insertBaseSql = new StringBuffer();
            insertBaseSql.append("insert into ").append(tempTable).append("(").append("FBillID").append(") ").append("values(?)");
            DbUtil.executeBatch((Context)ctx, (String)insertBaseSql.toString(), list);
            String insql = " select FBillID from " + tempTable;
            StringBuffer where = new StringBuffer();
            where.append(" WHERE adj.FID IN (").append(insql).append(")");
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT b.fnumber FcostObject,c.FNUMBER FcostCenter FROM T_NCM_EopWipAdjust adj ");
            sql.append(" inner join T_bd_costobject b on adj.FCOSTOBJECTID = b.fid ");
            sql.append(" inner join T_ORG_COSTCENTER c on adj.FCOSTCENTERID = c.fid ");
            sql.append(where);
            sql.append("  group by FCompanyOrg,FCalculatePeriod,b.fnumber,c.FNUMBER ");
            sql.append(" having count(1) >1 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            String costObjNum = null;
            StringBuffer costObjSb = new StringBuffer();
            while (rs.next()) {
                costObjNum = rs.getString("FcostObject");
                costObjSb.append(costObjNum);
            }
            if (costObjSb.length() > 0) {
                sql.append("\u672c\u671f\u540c\u4e00\u6210\u672c\u5bf9\u8c61\u5728\u540c\u4e00\u6210\u672c\u4e2d\u5fc3\u4e0b\u7ef4\u62a4\u4e86\u591a\u5f20\u671f\u672b\u5728\u4ea7\u6210\u672c\u8c03\u6574\u5355\uff0c\u9700\u5408\u5e76\u3002\u6210\u672c\u5bf9\u8c61\u5982\u4e0b\uff1a");
                sql.append(costObjSb);
                throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, (Object[])new String[]{sql.toString()});
            }
            StringBuffer sqlUpdate3 = new StringBuffer();
            sqlUpdate3.append(" UPDATE ").append(EopWipMatDetail).append(" as originalEntry SET (FAdjEoPWipQty,FEoPWIPQty,FAdjEoPWipAmount,FEoPWIPAmount,FEoPWIPAddqty,FEoPWIPAssistQty) = ").append(" ( SELECT ").append(isAudit ? "adjEntryEntry.FAdjustQty,adjEntryEntry.FFinishQty,adjEntryEntry.FAdjustAmount,adjEntryEntry.FFinishAmount,adjEntryEntry.FFinishQty, " : "0,adjEntryEntry.FEopWipQty,0,adjEntryEntry.FEopWipAmount,adjEntryEntry.FEopWipQty, ").append(isAudit ? " case when mmu.FBaseConvsRate > 0 then adjEntryEntry.FFinishQty/mmu.FBaseConvsRate else 0 end \n" : " case when mmu.FBaseConvsRate > 0 then adjEntryEntry.FEopWipQty/mmu.FBaseConvsRate else 0 end").append("  FROM ").append("  T_NCM_EopWipAdjust adj ").append(" INNER JOIN T_NCM_EopWipAdjustEntry adjEntry ").append("    ON adjEntry.FparentID = adj.Fid ").append(" INNER JOIN T_NCM_EopWipAdjustMatDetail adjEntryEntry ").append("    ON adjEntryEntry.FparentID = adjEntry.Fid ").append(" left join T_BD_Material mat on mat.FID = adjEntryEntry.FMaterialID \n").append(" left join t_bd_multiMeasureUnit mmu on mmu.FMaterialID = adjEntryEntry.FMaterialID and mmu.FMeasureUnitID = mat.FAssistUnit \n").append(where).append(" AND adjEntryEntry.FsourceID = originalEntry.FID").append("               and originalEntry.FMaterialID = adjEntryEntry.FMaterialID").append("               and originalEntry.FCalculatePeriodID = adj.FCalculatePeriod").append("               and originalEntry.FCompanyID = adj.FCompanyOrg ").append("               and originalEntry.FCostCenterID = adj.FCostCenterID ").append("               and originalEntry.FCostObjectID = adj.FCostObjectID )");
            DbUtil.execute((Context)ctx, (String)sqlUpdate3.toString());
            if (isAudit) {
                sqlInsert3 = new StringBuffer();
                sqlInsert3.append(" INSERT INTO ").append(EopWipMatDetail).append("(").append("FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FCostItemID ,FMaterialID ,FLot ,FAllocStdID ,FAllocStdData ,FFinishedQty ,FEoPWIPQty ,FFinishedAmount ,FEoPWIPAmount ,FCalcLevel,FFinishedAssistQty,FFinishedAddqty,FEoPWIPAssistQty,FEoPWIPAddqty,FIsReWork, FAdjEoPWipQty, FAdjEoPWipAmount ").append(")").append("(SELECT adjEntryEntry.FID,adj.FCompanyOrg,adj.FCalculatePeriod,adj.FCostCenterID, ").append("        adj.FCostObjectID,adjEntry.FCostItemID,adjEntryEntry.FMaterialID, ").append("        adjEntryEntry.FBatchNo,'',0,0,adjEntryEntry.FFinishQty,0,adjEntryEntry.FFinishAmount,0,0,0,").append("        0,0,0,adjEntryEntry.FadjustQty,adjEntryEntry.FadjustAmount ").append(" FROM ").append("  T_NCM_EopWipAdjust adj ").append(" INNER JOIN T_NCM_EopWipAdjustEntry adjEntry ").append("    ON adjEntry.FparentID = adj.Fid ").append(" INNER JOIN T_NCM_EopWipAdjustMatDetail adjEntryEntry ").append("    ON adjEntryEntry.FparentID = adjEntry.Fid ").append(where).append(" AND adjEntryEntry.FSOURCEID IS NULL AND adjEntryEntry.FID IS NOT NULL) ");
                DbUtil.execute((Context)ctx, (String)sqlInsert3.toString());
            } else {
                sqlInsert3 = new StringBuffer();
                sqlInsert3.append(" DELETE FROM ").append(EopWipMatDetail).append(" WHERE FID IN ( ").append(" SELECT adjEntryEntry.FID FROM T_NCM_EopWipAdjustMatDetail adjEntryEntry ").append("   LEFT JOIN T_NCM_EopWipAdjustEntry adjEntry ").append("     ON adjEntry.FID = adjEntryEntry.FParentid").append("   LEFT JOIN T_NCM_EopWipAdjust adj ").append("     ON adjEntry.FparentID = adj.Fid").append(where).append(" ) ");
                DbUtil.execute((Context)ctx, (String)sqlInsert3.toString());
            }
            StringBuffer sqlUpdate2 = new StringBuffer();
            sqlUpdate2.append(" UPDATE ").append(EopWipEntry).append(" as resultEntry ").append("  SET (FAdjEoPWipAmount,FEoPWIPAmount, FAdjEoPWipQty,FEopWIPQty) = ").append(" ( SELECT ").append(isAudit ? "adjEntry.FAdjustAmount, " : "0, ").append(isAudit ? "adjEntry.FFinishAmount, " : "adjEntry.FEoPWIPAmount, ").append(isAudit ? "isnull(adjEntry.FAdjustQty,0), " : "0, ").append(isAudit ? "isnull(adjEntry.FFinishQty,0) " : "isnull(adjEntry.FEopWIPQty,0)").append(" FROM ").append("  T_NCM_EopWipAdjust adj ").append(" INNER JOIN T_NCM_EopWipAdjustEntry adjEntry ").append("    ON adjEntry.FparentID = adj.Fid ").append(where).append(" AND adjEntry.FsourceID = resultEntry.FID").append("               and resultEntry.FCostItemID = adjEntry.FCostItemID").append("               and resultEntry.FCalculatePeriodID = adj.FCalculatePeriod").append("               and resultEntry.FCompanyID = adj.FCompanyOrg ").append("               and resultEntry.FCostCenterID = adj.FCostCenterID ").append("               and resultEntry.FCostObjectID = adj.FCostObjectID )");
            DbUtil.execute((Context)ctx, (String)sqlUpdate2.toString());
            if (isAudit) {
                StringBuffer sqlInsert2 = new StringBuffer();
                sqlInsert2.append(" INSERT INTO ").append(EopWipEntry).append("(").append("FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FFinishedAmount ,FEoPWIPAmount ,FRecvAmount ,FFinishedQty , FEoPWIPQty ,FCalcLevel,FFinishedAssistQty,FFinishedAddqty,FEoPWIPAssistQty,FEoPWIPAddqty ,FAdjEoPWipQty, FAdjEoPWipAmount ").append(")").append("(SELECT adjEntry.FID,adj.FCompanyOrg,adj.FCalculatePeriod,adj.FCostCenterID, ").append("        adj.FCostObjectID,adjEntry.FCostItemID,").append("        '',0,0,adjEntry.FFinishAmount,0,0,adjEntry.FFinishQty,0,0,").append("        0,0,0,adjEntry.FadjustQty,adjEntry.FadjustAmount ").append("   FROM T_NCM_EopWipAdjust adj ").append("   LEFT JOIN T_NCM_EopWipAdjustEntry adjEntry ").append("     ON adjEntry.FparentID = adj.Fid ").append(where).append(" AND adjEntry.FSOURCEID IS NULL ) ");
                DbUtil.execute((Context)ctx, (String)sqlInsert2.toString());
            } else {
                StringBuffer sqlDel2 = new StringBuffer();
                sqlDel2.append(" DELETE FROM ").append(EopWipEntry).append(" WHERE FID IN ( ").append(" SELECT adjEntry.FID FROM T_NCM_EopWipAdjustEntry adjEntry ").append("   LEFT JOIN T_NCM_EopWipAdjust adj ").append("     ON adjEntry.FparentID = adj.Fid").append(where).append(") ");
                DbUtil.execute((Context)ctx, (String)sqlDel2.toString());
            }
            StringBuffer sqlUpdate = new StringBuffer();
            sqlUpdate.append(" UPDATE ").append(EopWip).append(" as parent SET (FEopWIPQty, FEopWIPHour ,FAdjEopWipQty,FAdjEopWipHour) = ").append("( SELECT ").append(isAudit ? "adj.FFinishQty, " : "adj.FEopWIPQty, ").append(isAudit ? "adj.FFinishHour, " : "adj.FEopWIPHour, ").append(isAudit ? "adj.FAdjustQty, " : "0, ").append(isAudit ? "adj.FAdjustHour " : "0 ").append("   FROM T_NCM_EopWipAdjust adj ").append(where).append(" AND adj.FSourceID = parent.FID ").append("    AND parent.FCompanyID = adj.FCompanyOrg ").append("    AND parent.FCalculatePeriodID = adj.FCalculatePeriod ").append("    AND parent.FCostCenterID = adj.FCostCenterID ").append("    AND parent.FCostObjectID = adj.FCostObjectID )");
            DbUtil.execute((Context)ctx, (String)sqlUpdate.toString());
            if (isAudit) {
                StringBuffer sqlInsert = new StringBuffer();
                sqlInsert.append(" INSERT INTO ").append(EopWip).append("(").append("FID,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FBopWIPQty,FInputQty,FFinishedQty,FEopWIPQty, FBopWIPHour ,FInputHour ,FFinishedHour,FEopWIPHour,FCoef, FAdjEopWipQty, FAdjBoPWipQty, FAdjBopWipHour, FAdjEopWipHour ").append(")").append("(SELECT adj.FID,adj.FCompanyOrg,adj.FCalculatePeriod, ").append("        adj.FCostCenterID,adj.FCostObjectID,0,0,0,adj.FFinishQty,0,0,0,adj.FFinishHour,0,adj.FAdjustQty,0,0,adj.FAdjustHour").append(" FROM T_NCM_EopWipAdjust adj ").append(where).append(" AND adj.FSOURCEID IS NULL )");
                DbUtil.execute((Context)ctx, (String)sqlInsert.toString());
            } else {
                StringBuffer sqlDel = new StringBuffer();
                sqlDel.append("DELETE FROM ").append(EopWip).append(" WHERE FID IN ( ").append(" SELECT adj.FID FROM T_NCM_EopWipAdjust adj ").append(where).append(" ) ");
                DbUtil.execute((Context)ctx, (String)sqlDel.toString());
            }
            if (tempTable == null) return;
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                if (tempTable == null) throw throwable;
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        return;
    }

    protected void _checkIsDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EopWipAdjustInfo Info = (EopWipAdjustInfo)model;
        if (Info.getCostObject() != null && Info.getCostCenter() != null && this.checkDup(ctx, Info)) {
            throw new NcmBillException(NcmBillException.ADJ_CANNOTDUPLICATION);
        }
    }

    private boolean checkDup(Context ctx, EopWipAdjustInfo model) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)model.getCompanyOrg().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("costObject.id", (Object)model.getCostObject().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)model.getCostCenter().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)model.getCalculatePeriod().getId().toString(), CompareType.EQUALS));
        if (model.getId() != null) {
            FilterItemInfo filterItem2 = new FilterItemInfo("id", (Object)model.getId(), CompareType.NOTEQUALS);
            filterInfo.getFilterItems().add(filterItem2);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this.exists(ctx, filterInfo);
    }

    @Override
    protected void _getLastPeriodData(Context ctx, String companyId, String periodId) throws BOSException, EASBizException {
        PeriodInfo prePeriod = this.getPrePeriodInfo(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)periodId)));
        String prePeriodId = null;
        if (prePeriod != null && prePeriod.getId() != null) {
            prePeriodId = prePeriod.getId().toString();
        }
        this.getBalanceDataFromPrePeriod(ctx, companyId, prePeriodId, periodId);
    }

    private PeriodInfo getPrePeriodInfo(Context ctx, IObjectPK periodInfoPK) throws BOSException, EASBizException {
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo prePeriodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = iPeriod.getPeriodInfo(periodInfoPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)periodInfo.getBeginDate()), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.FALSE, CompareType.EQUALS));
        evi.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("endDate");
        sorter.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc != null && periodc.size() > 0) {
            prePeriodInfo = periodc.get(0);
        }
        return prePeriodInfo;
    }

    private void getBalanceDataFromPrePeriod(Context ctx, String companyId, String prePeriodID, String periodID) throws BOSException, EASBizException {
        char CLF = '\n';
        try {
            String tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
            String tblBalanceEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceEntry");
            String tblBalanceMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceMatDetail");
            String tblCostCalResult_History = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalResult_History");
            String tblCostCalMatDetailResult_History = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalMatDetailResult_History");
            StringBuffer sb = new StringBuffer();
            sb.append("truncate table ").append(tblBalance).append(";").append(CLF).append("INSERT INTO ").append(tblBalance).append("(FID,FCompanyOrg,FCalculatePeriodID,FCostCenterID,FCostObjectID,FBopWIPQty)").append("SELECT newbosid('2C942273') AS FID, S.FCompanyOrg, '").append(periodID).append("' AS FCalculatePeriod, S.FCostCenterID, S.FCostObjectID, S.FQty ").append("FROM T_NCM_WIPCountingBill AS S ").append(CLF).append("WHERE S.FCompanyOrg='").append(companyId).append("' AND S.FCalculatePeriod='").append(prePeriodID).append("' ").append(CLF).append("\tAND S.FQty <>0 ").append(CLF).append(";");
            sb.append("truncate table ").append(tblBalanceEntry).append(";").append(CLF).append("INSERT INTO ").append(tblBalanceEntry).append("(FID,FParentID,FCostItemID,FBoPWIPAmount)").append("SELECT newbosid('5CEE85BF') AS FID, B.FID As FParentID, S.FCostItemID, S.FEoPWIPAmount ").append(CLF).append("FROM ").append(tblCostCalResult_History).append(" AS S ").append(CLF).append("INNER JOIN ").append(tblBalance).append(" B ON B.FCompanyOrg=S.FCompanyID  ").append(CLF).append("\tAND B.FCostCenterID=S.FCostCenterID AND B.FCostObjectID=S.FCostObjectID ").append(CLF).append("WHERE S.FCompanyID='").append(companyId).append("' AND S.FCalculatePeriodID='").append(prePeriodID).append("' ").append(CLF).append(CLF).append("\tAND B.FCalculatePeriodID='").append(periodID).append("' ").append("\tAND S.FEoPWIPAmount <>0 ").append(CLF).append(";");
            sb.append("truncate table ").append(tblBalanceMatDetail).append(";").append(CLF).append("INSERT INTO ").append(tblBalanceMatDetail).append("(FID,FParentID,FMaterialID,FBatchNo,FQty,FAmount,FPrice)").append("SELECT newbosid('9EF9309E') AS FID, BE.FID As FParentID, S.FMaterialID, S.FLot As FBatchNo, S.FEoPWIPQty, S.FEoPWIPAmount, Round(S.FEoPWIPAmount/S.FEoPWIPQty,8)As  FPrice ").append(CLF).append("FROM ").append(tblCostCalMatDetailResult_History).append(" AS S ").append(CLF).append("INNER JOIN ").append(tblBalance).append(" B ON B.FCompanyOrg=S.FCompanyID ").append(CLF).append("\tAND B.FCostCenterID=S.FCostCenterID AND B.FCostObjectID=S.FCostObjectID ").append(CLF).append("INNER JOIN ").append(tblBalanceEntry).append(" BE ON BE.FParentID=B.FID AND BE.FCostItemID=S.FCostItemID ").append(CLF).append("WHERE S.FCompanyID='").append(companyId).append("' AND S.FCalculatePeriodID='").append(prePeriodID).append("' ").append(CLF).append("\tAND B.FCalculatePeriodID='").append(periodID).append("' ").append("\tAND S.FEoPWIPQty <>0 ").append(CLF).append(";");
            sb.append("update T_NCM_InitBalanceAdjust set FBillStatus=2 where FCompanyOrg='").append(companyId).append("' AND FCalculatePeriod='").append(periodID).append("';").append(CLF);
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected Map bizCheckForSubmit(Context ctx, List ids, Map param) throws BOSException, EASBizException {
        int i;
        final HashMap report = new HashMap();
        if (ids == null || ids.isEmpty()) {
            return report;
        }
        ArrayList<Object[]> idsParam = new ArrayList<Object[]>();
        int size = ids.size();
        for (int i2 = 0; i2 < size; ++i2) {
            idsParam.add(new Object[]{ids.get(i2)});
        }
        String costCenterIsNull = "\u672a\u5f55\u5165\u6210\u672c\u4e2d\u5fc3";
        String costObjectIsNull = "\u672a\u5f55\u5165\u6210\u672c\u5bf9\u8c61";
        String qtyISNull = "\u671f\u521d\u4e3a0\u65f6\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u6570\u91cf\u4e5f\u4e3a0";
        String finishedQtyISLittleZero = "\u8c03\u6574\u540e\u7684\u6570\u91cf\u4e0d\u5141\u8bb8\u5c0f\u4e8e0";
        String finishedISLittleZero = "\u8c03\u6574\u540e\u7684\u5de5\u65f6\u4e0d\u5141\u8bb8\u5c0f\u4e8e0";
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FID,FCostCenterID,FCostObjectID,FEopWIPqty,FAdjustQty,FFinishQty,FFinishHour \n");
        kSql.append("   from T_NCM_EopWipAdjust \n");
        kSql.append("  where FID in (");
        for (int i3 = 0; i3 < 200; ++i3) {
            if (i3 == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and (FCostCenterID is null or FCostObjectID is null or (FEopWIPqty = FAdjustQty and FEopWIPqty = 0) or FFinishQty < 0) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                String costCenterID = rs.getString("FCostCenterID");
                String costObjectID = rs.getString("FCostObjectID");
                BigDecimal finishedQty = rs.getBigDecimal("FFinishQty");
                BigDecimal finishedHour = rs.getBigDecimal("FFinishHour");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (costCenterID == null || costCenterID.length() == 0) {
                    detail.add("\u672a\u5f55\u5165\u6210\u672c\u4e2d\u5fc3");
                }
                if (costObjectID == null) {
                    detail.add("\u672a\u5f55\u5165\u6210\u672c\u5bf9\u8c61");
                }
                if (finishedQty.compareTo(new BigDecimal("0")) < 0) {
                    detail.add("\u8c03\u6574\u540e\u7684\u6570\u91cf\u4e0d\u5141\u8bb8\u5c0f\u4e8e0");
                }
                if (finishedHour.compareTo(new BigDecimal("0")) < 0) {
                    detail.add("\u8c03\u6574\u540e\u7684\u5de5\u65f6\u4e0d\u5141\u8bb8\u5c0f\u4e8e0");
                }
                if (detail.size() > 0) {
                    report.put(id, detail);
                }
            }
        });
        String noEntry = "\u5355\u636e\u6ca1\u6709\u5206\u5f55";
        kSql.setLength(0);
        kSql.append(" select FID \n");
        kSql.append("   from T_NCM_EopWipAdjust \n");
        kSql.append("  where FID in (");
        for (int i4 = 0; i4 < 200; ++i4) {
            if (i4 == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and FNumber is not null \n");
        kSql.append("    and FID not in (select FParentID from T_NCM_EopWipAdjustEntry) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                List<String> detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList<String>();
                detail.add("\u5355\u636e\u6ca1\u6709\u5206\u5f55");
                report.put(id, detail);
            }
        });
        String entryName = "\u5206\u5f55";
        String noCostItemInEntry = "\u672a\u5f55\u5165\u6210\u672c\u9879\u76ee";
        kSql.setLength(0);
        kSql.append(" select Fseq,FParentID, FCostItemID\n");
        kSql.append("   from T_NCM_EopWipAdjustEntry \n");
        kSql.append("  where FParentID in (");
        for (int i5 = 0; i5 < 200; ++i5) {
            if (i5 == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and FCostItemID is null \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FParentID");
                String costItemID = rs.getString("FCostItemID");
                String seq = rs.getString("Fseq");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (costItemID == null || costItemID.length() == 0) {
                    detail.add("\u5206\u5f55" + seq + "\u672a\u5f55\u5165\u6210\u672c\u9879\u76ee");
                }
                report.put(id, detail);
            }
        });
        String bill = "\u5355\u636e";
        String msg = "\u8c03\u6574\u5de5\u65f6\u3001\u8c03\u6574\u6570\u91cf\u3001\u8c03\u6574\u91d1\u989d\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a0";
        kSql.setLength(0);
        kSql.append(" select adjust.Fid Fid, adjust.Fnumber Fnumber  \n");
        kSql.append("   from T_NCM_EopWipAdjust adjust \n");
        kSql.append("  where adjust.Fid in (");
        for (i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append(" and adjust.FadjustHour = 0 and adjust.FadjustQty = 0 \n");
        kSql.append(" and not exists ( \n");
        kSql.append("     select 1 from T_NCM_EopWipAdjustentry entry \n");
        kSql.append("     where entry.FParentID = adjust.FID \n");
        kSql.append("     and (entry.FadjustQty <> 0 or entry.FadjustAmount <> 0) \n");
        kSql.append(" ) \n");
        kSql.append(" and not exists ( \n");
        kSql.append("     select 1 from T_NCM_EopWipAdjustentry entry \n");
        kSql.append("     join T_NCM_EopWipAdjustMatDetail mat \n");
        kSql.append("         on mat.FParentID = entry.FID \n");
        kSql.append("     where entry.FParentID = adjust.FID \n");
        kSql.append("     and (mat.FadjustQty <> 0 or mat.FadjustAmount <> 0) \n");
        kSql.append(" ) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("Fid");
                List<String> detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList<String>();
                detail.add("\u8c03\u6574\u5de5\u65f6\u3001\u8c03\u6574\u6570\u91cf\u3001\u8c03\u6574\u91d1\u989d\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a0");
                report.put(id, detail);
            }
        });
        kSql.setLength(0);
        kSql.append(" select a.fid fid,b.fnumber fnumber \n");
        kSql.append("   from T_NCM_EOPWIPADJUST a \n");
        kSql.append(" inner join T_BD_COSTOBJECT b on a.FCOSTOBJECTID = b.fid ");
        kSql.append("\twhere b.FBATCHNUMBER is null and b.FCALCULATEMODE = 4 ");
        kSql.append("  and a.fid in (");
        for (i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("fid");
                String number = rs.getString("fnumber");
                List<String> detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList<String>();
                detail.add("\u6210\u672c\u5bf9\u8c61" + number + "\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
                report.put(id, detail);
            }
        });
        return report;
    }

    @Override
    protected void _addVoucherByBill(Context ctx, List idList, String companyId, String periodId, BOTMappingInfo botpInfo) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        String boMappId = EopWipAdjustControllerBean.getMappingIdByCU(ctx, "B439CFE8", "2652E01E", DefineSysEnum.DAP);
        SelectorItemCollection botSelectors = null;
        ObjectUuidPK botpID = new ObjectUuidPK(botpInfo.getId());
        try {
            botSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botpInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < idList.size(); ++i) {
            this.generbyArrayList(ctx, (IObjectPK)new ObjectUuidPK(idList.get(i).toString()), boMappId, (IObjectPK)botpID, botSelectors);
        }
    }

    public static String getMappingIdByCU(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys) throws BOSException, EASBizException {
        String boMappId = null;
        try {
            IRowSet mapRs = NCMUtils.getMappingByCU((Context)ctx, (String)sourceBillType, (String)targetBillType, (DefineSysEnum)defineSys);
            if (mapRs == null || mapRs.size() < 1) {
                throw new CMBillException(CMBillException.NO_MATERIALREQ_VOUCHER);
            }
            while (mapRs.next()) {
                boMappId = mapRs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return boMappId;
    }

    protected void generbyArrayList(Context ctx, IObjectPK id, String botMappingId, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        if (id.toString().equals("")) {
            return;
        }
        EopWipAdjustInfo adjust = EopWipAdjustFactory.getLocalInstance(ctx).getEopWipAdjustInfo((IObjectPK)new ObjectUuidPK(id.toString()));
        Object[] params = new Object[]{adjust.getNumber()};
        if (!adjust.getBillStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new NcmBillException(NcmBillException.MUSTAUDIT, params);
        }
        if (adjust.isFiVouchered()) {
            throw new NcmBillException(NcmBillException.CHECK_FIVOUCHERED);
        }
        IObjectPK[] srcBillPks = new IObjectPK[]{id};
        DAPTransformResult dapResult = NCMGenVoucherHelper.generateVoucher((Context)ctx, (IObjectPK[])srcBillPks, (IObjectPK)botMappingPK, (SelectorItemCollection)botpSelectors);
        if (dapResult == null || dapResult.getVoucherCollection() == null || dapResult.getVoucherCollection().isEmpty()) {
            return;
        }
        VoucherCollection voucherColl = (VoucherCollection)dapResult.getVoucherCollection();
        String voucherId = voucherColl.get(0).getId().toString();
        HashMap<String, String> botpRelationMap = new HashMap<String, String>();
        botpRelationMap.put(id.toString(), voucherId);
        NCMUtils.saveBOTRelation((Context)ctx, botpRelationMap, (String)botMappingId);
        StringBuffer sql = new StringBuffer();
        sql.append("update T_NCM_EopWipAdjust  set FVoucherID='").append(voucherId).append("' , FAccountDate = (").append("select FBookedDate from T_GL_Voucher where Fid = '").append(voucherId).append("') , FFiVouchered = 1  ").append("where Fid = '").append(id).append("' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _batchReverseSave(Context ctx, List voIds) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_NCM_EopWipAdjust set FVoucherID='',faccountDate = null, ffivouchered = 0 ").append(" where FVoucherID in (?) and ").append(" NOT EXISTS (select 1 from T_GL_Voucher vo where vo.fid = T_NCM_EopWipAdjust.FVoucherID)");
        NCMServerUtils.executeSQLByBatch((Context)ctx, (String)sql.toString(), null, (Collection)voIds);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("update T_NCM_EopWipAdjust set fvoucherid='',faccountDate = null, ffivouchered = 0 ").append(" where fid = ? and ").append(" NOT EXISTS (select 1 from T_GL_Voucher vo where vo.fid = T_NCM_EopWipAdjust.fvoucherid)");
        NCMDbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{srcBillPK.toString()});
    }

    @Override
    protected void _updateMatDetailForSave(Context ctx, IObjectCollection matDetailCollection) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("delete T_NCM_EopWipAdjustMatDetail ").append("  where fparentid = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sb.toString());
            for (EopWipAdjustEntryInfo entry : matDetailCollection) {
                pstmt.setString(1, entry.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _doMonth(Context ctx, String companyId, String periodId, String userId) throws BOSException, EASBizException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("delete from T_NCM_EopWipAdjustHisMatDetail \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from T_NCM_EopWipAdjustHis b \n");
        ksql.append("    join T_NCM_EopWipAdjustHisEntry e on e.FParentID = b.FID \n");
        ksql.append("    where T_NCM_EopWipAdjustHisMatDetail.FParentID = e.FID \n");
        ksql.append("    and b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("delete from T_NCM_EopWipAdjustHisEntry \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from T_NCM_EopWipAdjustHis b \n");
        ksql.append("    where T_NCM_EopWipAdjustHisEntry.FParentID = b.FID \n");
        ksql.append("    and b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("delete from T_NCM_EopWipAdjustHis \n");
        ksql.append("where FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and FCalculatePeriod = '" + periodId + "' \n");
        ksql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into T_NCM_EopWipAdjustHis ( \n");
        ksql.append("    FID, FNumber, \n");
        ksql.append("    fCompanyOrg, FCalculatePeriod, \n");
        ksql.append("    FCostCenterID, FCostObjectID, \n");
        ksql.append("    FFiVouchered, FVoucherID, FBillStatus, FIsAuto, FBizDate, \n");
        ksql.append("    FEopWipQty, FAdjustQty, FFinishQty, \n");
        ksql.append("    FEopWipHour, FAdjustHour, FFinishHour, \n");
        ksql.append("    FCreatorID, FCreateTime, \n");
        ksql.append("    FLastUpdateUserID, FLastUpdateTime, \n");
        ksql.append("    FSourceID, FSourceBillID \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    newbosid('64506EB2'), b.FNumber, \n");
        ksql.append("    b.fCompanyOrg, b.FCalculatePeriod, \n");
        ksql.append("    b.FCostCenterID, b.FCostObjectID, \n");
        ksql.append("    b.FFiVouchered, b.FVoucherID, b.FBillStatus, b.FIsAuto, b.FBizDate, \n");
        ksql.append("    b.FEopWipQty, b.FAdjustQty, b.FFinishQty, \n");
        ksql.append("    b.FEopWipHour, b.FAdjustHour, b.FFinishHour, \n");
        ksql.append("    b.FCreatorID, b.FCreateTime, \n");
        ksql.append("    b.FLastUpdateUserID, b.FLastUpdateTime, \n");
        ksql.append("    b.FSourceID, b.FID \n");
        ksql.append("from T_NCM_EopWipAdjust b  \n");
        ksql.append("where b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append("    and b.FBillStatus = 4 \n");
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into T_NCM_EopWipAdjustHisEntry ( \n");
        ksql.append("    FID, FSeq, FParentID, \n");
        ksql.append("    FCostItemID, \n");
        ksql.append("    FEopWipQty, FAdjustQty, FFinishQty, \n");
        ksql.append("    FEopWipAmount, FAdjustAmount, FFinishAmount, \n");
        ksql.append("    FSourceID, FSourceBillEntryID \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    newbosid('B68308E0'), e.FSeq, hb.FID, \n");
        ksql.append("    e.FCostItemID, \n");
        ksql.append("    e.FEopWipQty, e.FAdjustQty, e.FFinishQty, \n");
        ksql.append("    e.FEopWipAmount, e.FAdjustAmount, e.FFinishAmount, \n");
        ksql.append("    e.FSourceID, e.FID \n");
        ksql.append("from T_NCM_EopWipAdjustEntry e \n");
        ksql.append("join T_NCM_EopWipAdjust b on b.FID = e.FParentID \n");
        ksql.append("join T_NCM_EopWipAdjustHis hb on hb.FSourceBillID = b.FID \n");
        ksql.append("where b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append("    and b.FBillStatus = 4 \n");
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into T_NCM_EopWipAdjustHisMatDetail ( \n");
        ksql.append("    FID, FSeq, FParentID, \n");
        ksql.append("    FMaterialID, FBatchNo, \n");
        ksql.append("    FEopWipQty, FAdjustQty, FFinishQty,\n");
        ksql.append("    FEopWipAmount, FAdjustAmount, FFinishAmount, \n");
        ksql.append("    FSourceID, FSourceBillEntryID \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    newbosid('46653B3F'), m.FSeq, he.FID, \n");
        ksql.append("    m.FMaterialID, m.FBatchNo, \n");
        ksql.append("    m.FEopWipQty, m.FAdjustQty, m.FFinishQty,\n");
        ksql.append("    m.FEopWipAmount, m.FAdjustAmount, m.FFinishAmount, \n");
        ksql.append("    m.FSourceID, m.FID \n");
        ksql.append("from T_NCM_EopWipAdjustMatDetail m \n");
        ksql.append("join T_NCM_EopWipAdjustEntry e on e.FID = m.FParentID \n");
        ksql.append("join T_NCM_EopWipAdjust b on b.FID = e.FParentID \n");
        ksql.append("join T_NCM_EopWipAdjustHisEntry he on he.FSourceBillEntryID = e.FID \n");
        ksql.append("where b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append("    and b.FBillStatus = 4 \n");
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("delete from T_NCM_EopWipAdjustMatDetail \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from T_NCM_EopWipAdjust b \n");
        ksql.append("    join T_NCM_EopWipAdjustEntry e on e.FParentID = b.FID \n");
        ksql.append("    where T_NCM_EopWipAdjustMatDetail.FParentID = e.FID \n");
        ksql.append("    and b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("delete from T_NCM_EopWipAdjustEntry \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from T_NCM_EopWipAdjust b \n");
        ksql.append("    where T_NCM_EopWipAdjustEntry.FParentID = b.FID \n");
        ksql.append("    and b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("delete from T_NCM_EopWipAdjust \n");
        ksql.append("where FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and FCalculatePeriod = '" + periodId + "' \n");
        ksql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)ksql.toString());
    }

    @Override
    protected void _unDoMonth(Context ctx, String companyId, String periodId, String userId) throws BOSException, EASBizException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("delete from T_NCM_EopWipAdjustMatDetail \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from T_NCM_EopWipAdjust b \n");
        ksql.append("    join T_NCM_EopWipAdjustEntry e on e.FParentID = b.FID \n");
        ksql.append("    where T_NCM_EopWipAdjustMatDetail.FParentID = e.FID \n");
        ksql.append("    and b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("delete from T_NCM_EopWipAdjustEntry \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from T_NCM_EopWipAdjust b \n");
        ksql.append("    where T_NCM_EopWipAdjustEntry.FParentID = b.FID \n");
        ksql.append("    and b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("delete from T_NCM_EopWipAdjust \n");
        ksql.append("where FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and FCalculatePeriod = '" + periodId + "' \n");
        ksql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into T_NCM_EopWipAdjust ( \n");
        ksql.append("    FID, FNumber, \n");
        ksql.append("    fCompanyOrg, FCalculatePeriod, \n");
        ksql.append("    FCostCenterID, FCostObjectID, \n");
        ksql.append("    FFiVouchered, FVoucherID, FBillStatus, FIsAuto, FBizDate, \n");
        ksql.append("    FEopWipQty, FAdjustQty, FFinishQty, \n");
        ksql.append("    FEopWipHour, FAdjustHour, FFinishHour, \n");
        ksql.append("    FCreatorID, FCreateTime, \n");
        ksql.append("    FLastUpdateUserID, FLastUpdateTime, \n");
        ksql.append("    FSourceID \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    hb.FSourceBillID, hb.FNumber, \n");
        ksql.append("    hb.fCompanyOrg, hb.FCalculatePeriod, \n");
        ksql.append("    hb.FCostCenterID, hb.FCostObjectID, \n");
        ksql.append("    hb.FFiVouchered, hb.FVoucherID, hb.FBillStatus, hb.FIsAuto, hb.FBizDate, \n");
        ksql.append("    hb.FEopWipQty, hb.FAdjustQty, hb.FFinishQty, \n");
        ksql.append("    hb.FEopWipHour, hb.FAdjustHour, hb.FFinishHour, \n");
        ksql.append("    hb.FCreatorID, hb.FCreateTime, \n");
        ksql.append("    hb.FLastUpdateUserID, hb.FLastUpdateTime, \n");
        ksql.append("    hb.FSourceID \n");
        ksql.append("from T_NCM_EopWipAdjustHis hb  \n");
        ksql.append("where hb.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and hb.FCalculatePeriod = '" + periodId + "' \n");
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into T_NCM_EopWipAdjustEntry ( \n");
        ksql.append("    FID, FSeq, FParentID, \n");
        ksql.append("    FCostItemID, \n");
        ksql.append("    FEopWipQty, FAdjustQty, FFinishQty, \n");
        ksql.append("    FEopWipAmount, FAdjustAmount, FFinishAmount, \n");
        ksql.append("    FSourceID \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    he.FSourceBillEntryID, he.FSeq, hb.FSourceBillID, \n");
        ksql.append("    he.FCostItemID, \n");
        ksql.append("    he.FEopWipQty, he.FAdjustQty, he.FFinishQty, \n");
        ksql.append("    he.FEopWipAmount, he.FAdjustAmount, he.FFinishAmount, \n");
        ksql.append("    he.FSourceID \n");
        ksql.append("from T_NCM_EopWipAdjustHisEntry he \n");
        ksql.append("join T_NCM_EopWipAdjustHis hb on hb.FID = he.FParentID \n");
        ksql.append("where hb.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and hb.FCalculatePeriod = '" + periodId + "' \n");
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into T_NCM_EopWipAdjustMatDetail ( \n");
        ksql.append("    FID, FSeq, FParentID, \n");
        ksql.append("    FMaterialID, FBatchNo, \n");
        ksql.append("    FEopWipQty, FAdjustQty, FFinishQty,\n");
        ksql.append("    FEopWipAmount, FAdjustAmount, FFinishAmount, \n");
        ksql.append("    FSourceID \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    hm.FSourceBillEntryID, hm.FSeq, he.FSourceBillEntryID, \n");
        ksql.append("    hm.FMaterialID, hm.FBatchNo, \n");
        ksql.append("    hm.FEopWipQty, hm.FAdjustQty, hm.FFinishQty,\n");
        ksql.append("    hm.FEopWipAmount, hm.FAdjustAmount, hm.FFinishAmount, \n");
        ksql.append("    hm.FSourceID \n");
        ksql.append("from T_NCM_EopWipAdjustHisMatDetail hm \n");
        ksql.append("join T_NCM_EopWipAdjustHisEntry he on he.FID = hm.FParentID \n");
        ksql.append("join T_NCM_EopWipAdjustHis hb on hb.FID = he.FParentID \n");
        ksql.append("where hb.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and hb.FCalculatePeriod = '" + periodId + "' \n");
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("delete from T_NCM_EopWipAdjustHisMatDetail \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from T_NCM_EopWipAdjustHis b \n");
        ksql.append("    join T_NCM_EopWipAdjustHisEntry e on e.FParentID = b.FID \n");
        ksql.append("    where T_NCM_EopWipAdjustHisMatDetail.FParentID = e.FID \n");
        ksql.append("    and b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("delete from T_NCM_EopWipAdjustHisEntry \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from T_NCM_EopWipAdjustHis b \n");
        ksql.append("    where T_NCM_EopWipAdjustHisEntry.FParentID = b.FID \n");
        ksql.append("    and b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("delete from T_NCM_EopWipAdjustHis \n");
        ksql.append("where FCompanyOrg = '" + companyId + "' \n");
        ksql.append("    and FCalculatePeriod = '" + periodId + "' \n");
        ksql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)ksql.toString());
    }

    @Override
    protected boolean _isNeedAdjust(Context ctx, Map params) throws BOSException, EASBizException {
        IRowSet rowSet;
        block8: {
            boolean bl;
            String companyId = (String)params.get("companyId");
            if (companyId == null || companyId.length() == 0) {
                return true;
            }
            String periodId = (String)params.get("periodId");
            if (periodId == null || periodId.length() == 0) {
                return true;
            }
            rowSet = null;
            try {
                String T_NCM_CostCalResult;
                String T_NCM_AllDataByCostObj = (String)params.get("T_NCM_AllDataByCostObj");
                if (T_NCM_AllDataByCostObj == null) {
                    T_NCM_AllDataByCostObj = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_AllDataByCostObj");
                }
                if ((T_NCM_CostCalResult = (String)params.get("T_NCM_CostCalResult")) == null) {
                    T_NCM_CostCalResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalResult");
                }
                StringBuffer ksql = new StringBuffer();
                ksql.append("select top 1 1 \n");
                ksql.append("from " + T_NCM_AllDataByCostObj + " rco \n");
                ksql.append("where ( \n");
                ksql.append("    rco.FEopWIPQty = 0 and exists ( \n");
                ksql.append("        select 1 from ( select FCostCenterID,FCostObjectID,sum(FEopWIPAmount) FEopWIPAmount from " + T_NCM_CostCalResult + "  group by FCostCenterID,FCostObjectID ) rci \n");
                ksql.append("        where rci.FCostCenterID = rco.FCostCenterID \n");
                ksql.append("            and rci.FCostObjectID = rco.FCostObjectID \n");
                ksql.append("            and rci.FEopWIPAmount <> 0 \n");
                ksql.append("    ) \n");
                ksql.append("    or \n");
                ksql.append("    rco.FEopWIPQty <> 0 and exists ( \n");
                ksql.append("        select 1 from T_BD_CostObject co \n");
                ksql.append("        join T_MM_ManufactureOrder o on o.FID = co.FOrderID \n");
                ksql.append("        where co.FCalculateMode = 7 \n");
                ksql.append("            and co.FID = rco.FCostObjectID \n");
                ksql.append("            and o.FBaseStatus in (7, 8, 11) \n");
                ksql.append("    ) \n");
                ksql.append(") \n");
                rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
                if (!rowSet.next()) break block8;
                bl = true;
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rowSet);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rowSet);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rowSet);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map _getAdjustRpt(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String companyId = (String)params.get("companyId");
        if (companyId == null || companyId.length() == 0) {
            return result;
        }
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("id");
        coll.add("number");
        coll.add("name");
        coll.add("baseCurrency.id");
        coll.add("baseCurrency.precision");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), coll);
        result.put("company", company);
        String periodId = (String)params.get("periodId");
        if (periodId == null || periodId.length() == 0) {
            return result;
        }
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        result.put("period", period);
        String loc = ctx.getLocale().toString();
        String tempTable = null;
        try {
            String T_NCM_CostCalResult;
            String T_NCM_AllDataByCostObj = (String)params.get("T_NCM_AllDataByCostObj");
            if (T_NCM_AllDataByCostObj == null) {
                T_NCM_AllDataByCostObj = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_AllDataByCostObj");
            }
            if ((T_NCM_CostCalResult = (String)params.get("T_NCM_CostCalResult")) == null) {
                T_NCM_CostCalResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalResult");
            }
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            ksql.append("\t  FCODataID varchar(44),\n");
            ksql.append("\t  FCostCenterID varchar(44),\n");
            ksql.append("\t  FCostObjectID varchar(44),\n");
            ksql.append("     FCOEopWIPQty NUMERIC(21,8), \n");
            ksql.append("     FCOEopWIPHour NUMERIC(21,8), \n");
            ksql.append("     FCIEopWIPQty NUMERIC(21,8), \n");
            ksql.append("     FCIEoPWIPAmount NUMERIC(17,4) \n");
            ksql.append(") \n");
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + tempTable + " ( \n");
            ksql.append("    FCODataID, \n");
            ksql.append("    FCostCenterID, \n");
            ksql.append("    FCostObjectID, \n");
            ksql.append("    FCOEopWIPQty, \n");
            ksql.append("    FCOEopWIPHour, \n");
            ksql.append("    FCIEoPWIPQty, \n");
            ksql.append("    FCIEoPWIPAmount \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    rco.FID FCODataID, \n");
            ksql.append("    rco.FCostCenterID, \n");
            ksql.append("    rco.FCostObjectID, \n");
            ksql.append("    max(rco.FEopWIPQty) FCOEopWIPQty, \n");
            ksql.append("    max(rco.FEopWIPHour) FCOEopWIPHour, \n");
            ksql.append("    sum(rci.FEoPWIPQty) FCIEoPWIPQty, \n");
            ksql.append("    sum(rci.FEoPWIPAmount) FCIEoPWIPAmount \n");
            ksql.append("from " + T_NCM_AllDataByCostObj + " rco \n");
            ksql.append("left join " + T_NCM_CostCalResult + " rci \n");
            ksql.append("    on rci.FCostCenterID = rco.FCostCenterID \n");
            ksql.append("    and rci.FCostObjectID = rco.FCostObjectID \n");
            ksql.append("where ( \n");
            ksql.append("    rco.FEopWIPQty = 0 and exists ( \n");
            ksql.append("        select 1 from " + T_NCM_CostCalResult + " rci \n");
            ksql.append("        where rci.FCostCenterID = rco.FCostCenterID \n");
            ksql.append("            and rci.FCostObjectID = rco.FCostObjectID \n");
            ksql.append("            and rci.FEopWIPAmount <> 0 \n");
            ksql.append("    ) \n");
            ksql.append("    or \n");
            ksql.append("    rco.FEopWIPQty <> 0 and exists ( \n");
            ksql.append("        select 1 from T_BD_CostObject co \n");
            ksql.append("        join T_MM_ManufactureOrder o on o.FID = co.FOrderID \n");
            ksql.append("        where co.FCalculateMode = 7 \n");
            ksql.append("            and co.FID = rco.FCostObjectID \n");
            ksql.append("            and o.FBaseStatus in (7, 8, 11) \n");
            ksql.append("    ) \n");
            ksql.append(") \n");
            ksql.append("group by rco.FID, rco.FCostCenterID, rco.FCostObjectID \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("select \n");
            ksql.append("    FCODataID, 0 FCheck, \n");
            ksql.append("    cc.FID FCostCenterID, cc.FNumber FCostCenterNumber, cc.FName_" + loc + " FCostCenterName, \n");
            ksql.append("    co.FID FCostObjectID, co.FNumber FCostObjectNumber, co.FName_" + loc + " FCostObjectName, \n");
            ksql.append("    co.FOrderNumber, co.FBatchNumber FLot, m.FModel, mu.FName_" + loc + " FUnitName, \n");
            ksql.append("    FCOEopWIPQty, FCOEopWIPHour, \n");
            ksql.append("    mmu.FQtyPrecision FCOEopWIPQtyPrecision, FCOEopWIPHour, \n");
            ksql.append("    FCIEopWIPQty, FCIEoPWIPAmount, \n");
            ksql.append("    a.FID FAdjustID, a.FNumber FAdjustNumber \n");
            ksql.append("from " + tempTable + " t \n");
            ksql.append("join T_ORG_CostCenter cc on cc.FID = t.FCostCenterID \n");
            ksql.append("join T_BD_CostObject co on co.FID = t.FCostObjectID \n");
            ksql.append("join T_BD_Material m on m.FID = co.FStdProductIDID \n");
            ksql.append("join T_BD_MeasureUnit mu on mu.FID = m.FBaseUnit \n");
            ksql.append("join T_BD_MultiMeasureUnit mmu on mmu.FMaterialID = m.FID \n");
            ksql.append("    and mmu.FMeasureUnitID = mu.FID \n");
            ksql.append("left join T_NCM_EopWipAdjust a on a.FSourceID = t.FCODataID \n");
            IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            result.put("rowSet", rowSet);
            if (tempTable == null) return result;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (tempTable == null) throw throwable;
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        return result;
    }

    @Override
    protected Map _genAdjustBill(Context ctx, Map params) throws BOSException, EASBizException {
        LinkedList<String> updateNumbers;
        LinkedList<String> updateIds;
        HashSet<String> existNumbers;
        StringBuffer ksql;
        PreparedStatement pstmt;
        Connection con;
        String tempTable;
        PeriodInfo period;
        String companyId;
        HashMap result;
        block22: {
            String T_NCM_CostCalMatDetailResult;
            String T_NCM_CostCalResult;
            result = new HashMap();
            companyId = (String)params.get("companyId");
            if (companyId == null || companyId.length() == 0) {
                return result;
            }
            String periodId = (String)params.get("periodId");
            if (periodId == null || periodId.length() == 0) {
                return result;
            }
            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
            String userId = (String)params.get("userId");
            if (userId == null || userId.length() == 0) {
                return result;
            }
            Set coDataIds = (Set)params.get("coDataIds");
            tempTable = null;
            con = null;
            pstmt = null;
            String T_NCM_AllDataByCostObj = (String)params.get("T_NCM_AllDataByCostObj");
            if (T_NCM_AllDataByCostObj == null) {
                T_NCM_AllDataByCostObj = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_AllDataByCostObj");
            }
            if ((T_NCM_CostCalResult = (String)params.get("T_NCM_CostCalResult")) == null) {
                T_NCM_CostCalResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalResult");
            }
            if ((T_NCM_CostCalMatDetailResult = (String)params.get("T_NCM_CostCalMatDetailResult")) == null) {
                T_NCM_CostCalMatDetailResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalMatDetailResult");
            }
            ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            ksql.append("\t  FCODataID varchar(44),\n");
            ksql.append("\t  FCostCenterID varchar(44),\n");
            ksql.append("\t  FCostObjectID varchar(44),\n");
            ksql.append("     FCOEopWIPQty NUMERIC(21,8), \n");
            ksql.append("     FCOEopWIPHour NUMERIC(21,8), \n");
            ksql.append("\t  FCIDataID varchar(44),\n");
            ksql.append("     FCostItemID varchar(44), \n");
            ksql.append("     FCIEopWIPQty NUMERIC(21,8), \n");
            ksql.append("     FCIEoPWIPAmount NUMERIC(17,4), \n");
            ksql.append("\t  FMatDataID varchar(44),\n");
            ksql.append("     FMaterialID varchar(44), \n");
            ksql.append("     FLot NVARCHAR(80), \n");
            ksql.append("     FMatEopWIPQty NUMERIC(21,8), \n");
            ksql.append("     FMatEoPWIPAmount NUMERIC(17,4) \n");
            ksql.append(") \n");
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + tempTable + " ( \n");
            ksql.append("    FCODataID, FCostCenterID, FCostObjectID, \n");
            ksql.append("    FCOEopWIPQty, FCOEopWIPHour, \n");
            ksql.append("    FCIDataID, FCostItemID, \n");
            ksql.append("    FCIEopWIPQty, FCIEoPWIPAmount, \n");
            ksql.append("    FMatDataID, FMaterialID, FLot, \n");
            ksql.append("    FMatEopWIPQty, FMatEoPWIPAmount \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    rco.FID FCODataID, rco.FCostCenterID, rco.FCostObjectID, \n");
            ksql.append("    rco.FEopWIPQty FCOEopWIPQty, rco.FEopWIPHour FCOEopWIPHour, \n");
            ksql.append("    rci.FID FCIDataID, rci.FCostItemID, \n");
            ksql.append("    rci.FEopWIPQty FCIEopWIPQty, rci.FEoPWIPAmount FCIEoPWIPAmount, \n");
            ksql.append("    rmat.FID FMatDataID, rmat.FMaterialID, rmat.FLot, \n");
            ksql.append("    rmat.FEopWIPQty FMatEopWIPQty, rmat.FEoPWIPAmount FMatEoPWIPAmount \n");
            ksql.append("from " + T_NCM_AllDataByCostObj + " rco \n");
            ksql.append("left join " + T_NCM_CostCalResult + " rci \n");
            ksql.append("    on rci.FCostCenterID = rco.FCostCenterID \n");
            ksql.append("    and rci.FCostObjectID = rco.FCostObjectID \n");
            ksql.append("left join " + T_NCM_CostCalMatDetailResult + " rmat \n");
            ksql.append("    on rmat.FCostCenterID = rci.FCostCenterID \n");
            ksql.append("    and rmat.FCostObjectID = rci.FCostObjectID \n");
            ksql.append("    and rmat.FCostItemID = rci.FCostItemID \n");
            ksql.append("where 1 = 1 \n");
            if (coDataIds != null && coDataIds.size() > 0) {
                ksql.append("and rco.FID in " + BDCMUtils.buildSqlFromIds((Set)coDataIds) + " \n");
            }
            ksql.append("and ( \n");
            ksql.append("    rco.FEopWIPQty = 0 and exists ( \n");
            ksql.append("        select 1 from " + T_NCM_CostCalResult + " rci \n");
            ksql.append("        where rci.FCostCenterID = rco.FCostCenterID \n");
            ksql.append("            and rci.FCostObjectID = rco.FCostObjectID \n");
            ksql.append("            and rci.FEopWIPAmount <> 0 \n");
            ksql.append("    ) \n");
            ksql.append("    or \n");
            ksql.append("    rco.FEopWIPQty <> 0 and exists ( \n");
            ksql.append("        select 1 from T_BD_CostObject co \n");
            ksql.append("        join T_MM_ManufactureOrder o on o.FID = co.FOrderID \n");
            ksql.append("        where co.FCalculateMode = 7 \n");
            ksql.append("            and co.FID = rco.FCostObjectID \n");
            ksql.append("            and o.FBaseStatus in (7, 8, 11) \n");
            ksql.append("    ) \n");
            ksql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            String TMP_NUMBER = "TMP_NUMBER_TODO";
            ksql.setLength(0);
            ksql.append("insert into T_NCM_EopWipAdjust ( \n");
            ksql.append("    FID, FNumber, \n");
            ksql.append("    fCompanyOrg, FCalculatePeriod, \n");
            ksql.append("    FCostCenterID, FCostObjectID, \n");
            ksql.append("    FFiVouchered, FVoucherID, FBillStatus, FIsAuto, \n");
            ksql.append("    FEopWipQty, FAdjustQty, FFinishQty, \n");
            ksql.append("    FEopWipHour, FAdjustHour, FFinishHour, \n");
            ksql.append("    FCreatorID, FCreateTime, \n");
            ksql.append("    FLastUpdateUserID, FLastUpdateTime, \n");
            ksql.append("    FSourceID \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    newbosid('B439CFE8'), '" + TMP_NUMBER + "', \n");
            ksql.append("    '" + companyId + "', '" + periodId + "', \n");
            ksql.append("    FCostCenterID, FCostObjectID, \n");
            ksql.append("    0, null, 2, 1, \n");
            ksql.append("    FCOEopWIPQty, 0 - FCOEopWIPQty, 0, \n");
            ksql.append("    FCOEopWIPHour, 0 - FCOEopWIPHour, 0, \n");
            ksql.append("    '" + userId + "', getDate(), \n");
            ksql.append("    '" + userId + "', getDate(), \n");
            ksql.append("    FCODataID \n");
            ksql.append("from ( \n");
            ksql.append("    select distinct \n");
            ksql.append("        FCODataID, \n");
            ksql.append("        FCostCenterID, FCostObjectID, \n");
            ksql.append("        FCOEopWIPQty, FCOEopWIPHour \n");
            ksql.append("    from " + tempTable + " t \n");
            ksql.append("    where not exists ( \n");
            ksql.append("        select 1 from T_NCM_EopWipAdjust b \n");
            ksql.append("        where b.FSourceID = t.FCODataID \n");
            ksql.append("    ) \n");
            ksql.append(") a \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into T_NCM_EopWipAdjustEntry ( \n");
            ksql.append("    FID, FSeq, FParentID, \n");
            ksql.append("    FCostItemID, \n");
            ksql.append("    FEopWipQty, FAdjustQty, FFinishQty, \n");
            ksql.append("    FEopWipAmount, FAdjustAmount, FFinishAmount, \n");
            ksql.append("    FSourceID \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    newbosid('D3002D59'), 1, FParentID, \n");
            ksql.append("    FCostItemID, \n");
            ksql.append("    FCIEopWIPQty, 0 - FCIEopWIPQty, 0, \n");
            ksql.append("    FCIEopWipAmount, 0 - FCIEopWipAmount, 0, \n");
            ksql.append("    FCIDataID \n");
            ksql.append("from ( \n");
            ksql.append("    select distinct \n");
            ksql.append("        FCIDataID, \n");
            ksql.append("        FCostItemID, b.FID FParentID, \n");
            ksql.append("        FCIEopWIPQty, FCIEopWipAmount \n");
            ksql.append("    from " + tempTable + " t \n");
            ksql.append("    join T_NCM_EopWipAdjust b on b.FSourceID = t.FCODataID \n");
            ksql.append("    where t.FCIDataID is not null and not exists ( \n");
            ksql.append("        select 1 from T_NCM_EopWipAdjustEntry e \n");
            ksql.append("        where e.FSourceID = t.FCIDataID \n");
            ksql.append("    ) \n");
            ksql.append(") a \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into T_NCM_EopWipAdjustMatDetail ( \n");
            ksql.append("    FID, FSeq, FParentID, \n");
            ksql.append("    FMaterialID, FBatchNo, \n");
            ksql.append("    FEopWipQty, FAdjustQty, FFinishQty,\n");
            ksql.append("    FEopWipAmount, FAdjustAmount, FFinishAmount, \n");
            ksql.append("    FSourceID \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    newbosid('8D057E08'), 1, FParentID, \n");
            ksql.append("    FMaterialID, FLot, \n");
            ksql.append("    FMatEopWIPQty, 0 - FMatEopWIPQty, 0, \n");
            ksql.append("    FMatEopWipAmount, 0 - FMatEopWipAmount, 0, \n");
            ksql.append("    FMatDataID \n");
            ksql.append("from ( \n");
            ksql.append("    select distinct \n");
            ksql.append("        FMatDataID, \n");
            ksql.append("        FMaterialID, FLot, e.FID FParentID, \n");
            ksql.append("        FMatEopWIPQty, FMatEopWipAmount \n");
            ksql.append("    from " + tempTable + " t \n");
            ksql.append("    join T_NCM_EopWipAdjustEntry e on e.FSourceID = t.FCIDataID \n");
            ksql.append("    where t.FMatDataID is not null and not exists ( \n");
            ksql.append("        select 1 from T_NCM_EopWipAdjustMatDetail m \n");
            ksql.append("        where m.FSourceID = t.FMatDataID \n");
            ksql.append("    ) \n");
            ksql.append(") a \n");
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
            existNumbers = new HashSet<String>();
            updateIds = new LinkedList<String>();
            updateNumbers = new LinkedList<String>();
            ksql.setLength(0);
            ksql.append("select FID, FNumber from T_NCM_EopWipAdjust \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            while (rowSet.next()) {
                String id = rowSet.getString("FID");
                if (id == null || id.length() == 0) continue;
                String number = rowSet.getString("FNumber");
                if (number == null || number.length() == 0 || number.equals(TMP_NUMBER)) {
                    updateIds.add(id);
                    continue;
                }
                existNumbers.add(number);
            }
            if (updateIds.size() > 0) break block22;
            HashMap hashMap = result;
            SQLUtils.cleanup(pstmt, con);
            if (tempTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
            return hashMap;
        }
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)new EopWipAdjustInfo(), companyId);
            if (ruleStatus.isExist()) {
                String[] numbers = iCodingRuleManager.getBatchNumber((IObjectValue)new EopWipAdjustInfo(), companyId, updateIds.size());
                for (int i = 0; i < numbers.length; ++i) {
                    if (existNumbers.contains(numbers[i])) continue;
                    updateNumbers.add(numbers[i]);
                    existNumbers.add(numbers[i]);
                }
                if (updateNumbers.size() < updateIds.size()) {
                    this.buildNumberNoRule(existNumbers, updateNumbers, period, updateIds.size() - updateNumbers.size());
                }
            } else {
                this.buildNumberNoRule(existNumbers, updateNumbers, period, updateIds.size());
            }
            ksql.setLength(0);
            ksql.append("update T_NCM_EopWipAdjust set FNumber = ?, FBizDate = ? where FID = ? ");
            con = EJBFactory.getConnection((Context)ctx);
            pstmt = con.prepareStatement(ksql.toString());
            for (int i = 0; i < updateIds.size(); ++i) {
                pstmt.setString(1, (String)updateNumbers.get(i));
                pstmt.setTimestamp(2, period.getEndDate());
                pstmt.setString(3, (String)updateIds.get(i));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, con);
                if (tempTable != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
        if (tempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
        return result;
    }

    private void buildNumberNoRule(Set existNumbers, List updateNumbers, PeriodInfo period, int count) {
        String prefix = "ADJUST_" + period.getNumber() + "_";
        int iCount = 0;
        int i = 1;
        while (iCount < count) {
            String iNumber = String.valueOf(i);
            String number = prefix + "00000000".substring(iNumber.length()) + iNumber;
            if (!existNumbers.contains(number)) {
                updateNumbers.add(number);
                ++iCount;
            }
            ++i;
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EopWipAdjustInfo adjInfo = (EopWipAdjustInfo)model;
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("number"));
        sics.add(new SelectorItemInfo("calculateMode"));
        sics.add(new SelectorItemInfo("batchNumber"));
        CostObjectInfo coInfo = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectInfo((IObjectPK)new ObjectUuidPK(adjInfo.getCostObject().getId()), sics);
        if (coInfo.getCalculateMode().getValue() == 4 && coInfo.getBatchNumber() == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, (Object[])new String[]{"\u6210\u672c\u5bf9\u8c61\u5f02\u5e38\uff0c\u5206\u6279\u6cd5\u6210\u672c\u5bf9\u8c61\u9700\u7ef4\u62a4\u6279\u6b21"});
        }
        return super._submit(ctx, model);
    }
}

