/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.ncm.CostCenterOrgUnitGroupInfo;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.rpt.FunctionWebserviceFacadeFactory;
import com.kingdee.eas.fi.rpt.IFunctionWebserviceFacade;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ncm.bill.CCOFeeBillEntryCollection;
import com.kingdee.eas.ncm.bill.CCOFeeBillEntryInfo;
import com.kingdee.eas.ncm.bill.CCOFeeBillFactory;
import com.kingdee.eas.ncm.bill.CCOFeeBillInfo;
import com.kingdee.eas.ncm.bill.FetchDataDirectionEnum;
import com.kingdee.eas.ncm.bill.FetchSourceEnum;
import com.kingdee.eas.ncm.bill.GLFetchDataEntryCollection;
import com.kingdee.eas.ncm.bill.GLFetchDataEntryInfo;
import com.kingdee.eas.ncm.bill.GLFetchDataException;
import com.kingdee.eas.ncm.bill.GLFetchDataInfo;
import com.kingdee.eas.ncm.bill.ICCOFeeBill;
import com.kingdee.eas.ncm.bill.IOtherFeeBill;
import com.kingdee.eas.ncm.bill.OtherFeeBillEntryCollection;
import com.kingdee.eas.ncm.bill.OtherFeeBillEntryInfo;
import com.kingdee.eas.ncm.bill.OtherFeeBillFactory;
import com.kingdee.eas.ncm.bill.OtherFeeBillInfo;
import com.kingdee.eas.ncm.bill.app.AbstractGLFetchDataControllerBean;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillBaseInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class GLFetchDataControllerBean
extends AbstractGLFetchDataControllerBean {
    private static final long serialVersionUID = 3985515211410855418L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.GLFetchDataControllerBean");
    private static final String RESOURCE_PATH = "com.kingdee.eas.ncm.bill.GLFetchDataResource";
    private Map glEntryFeildsMap = new LinkedHashMap();
    private Map glEntryQtyFeildsMap = new LinkedHashMap();
    private Map costCenter = new HashMap();
    private Map costCenterGroup = new HashMap();
    private Map expense = new HashMap();
    private Map costItem = new HashMap();
    private Map costObject = new HashMap();
    private Map costObjectSuite = new HashMap();
    private Map department = new HashMap();
    private Map sourceCostCenterMap = new HashMap();
    private Map asstAcctMap = new HashMap();
    private int costObjectOfBillRequired = -1;

    @Override
    protected IObjectValue _checkFetchDataDup(Context ctx, String orgid, String periodid, IObjectValue value) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected boolean _checkBizDul(Context ctx, IObjectPK orgpk, IObjectPK periodpk, String costcenter, String fid) throws BOSException {
        return false;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkOverheadObject(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkOverheadObject(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!(model instanceof GLFetchDataInfo)) {
            return;
        }
        GLFetchDataInfo glFetchDataInfo = (GLFetchDataInfo)model;
        GLFetchDataEntryCollection entrys = glFetchDataInfo.getEntrys();
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        this.checkAccount(ctx, entrys);
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT TOP 1 ");
        kSql.append("        co.fname_" + ctx.getLocale() + " AS costObjectName, ");
        kSql.append("        cc.fname_" + ctx.getLocale() + " AS costCenterName ");
        kSql.append(" FROM   T_BD_CostObject co ");
        kSql.append("        INNER JOIN T_BD_CostObjectEntry coEntry ");
        kSql.append("          ON co.fid = coEntry.fparentid ");
        kSql.append("        INNER JOIN T_NCM_AUXOverhead overhead ");
        kSql.append("          ON coEntry.FRelatedID = overhead.FID ");
        kSql.append("        INNER JOIN T_NCM_AUXOverheadCompanyInfo overheadCompany ");
        kSql.append("          ON overheadCompany.FAUXOverheadID = overhead.FID ");
        kSql.append("        INNER JOIN T_ORG_CostCenter cc ");
        kSql.append("          ON overheadCompany.FCostCenterID = cc.FID ");
        kSql.append(" WHERE  co.FRelatedType = 3 ");
        boolean hasData = false;
        StringBuffer sb = new StringBuffer();
        int count = entrys.size();
        for (int i = 0; i < count; ++i) {
            GLFetchDataEntryInfo entryInfo = entrys.get(i);
            if (entryInfo == null || entryInfo.getCostObject() == null || entryInfo.getCostObject().getId() == null || entryInfo.getCostCenter() == null || entryInfo.getCostCenter().getId() == null) continue;
            String costObjectId = entryInfo.getCostObject().getId().toString();
            String costCenterId = entryInfo.getCostCenter().getId().toString();
            if (StringUtils.isEmpty((String)costObjectId) || StringUtils.isEmpty((String)costCenterId)) continue;
            hasData = true;
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append("(co.FID ='" + costObjectId + "'  AND cc.FID <> '" + costCenterId + "') ");
        }
        if (!hasData) {
            return;
        }
        kSql.append("        AND ( ");
        kSql.append(sb);
        kSql.append(" ) ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
        try {
            if (rows.next()) {
                String costObjectName = rows.getString(1);
                String costCenterName = rows.getString(2);
                throw new GLFetchDataException(GLFetchDataException.ERRORCOSTCENTEROFOVERHEADOBJECT, new String[]{costObjectName, costCenterName});
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void checkAccount(Context ctx, GLFetchDataEntryCollection entrys) throws GLFetchDataException, BOSException {
        String accountID1 = null;
        String accountID2 = null;
        String accountNumber1 = null;
        String accountNumber2 = null;
        String asstAccount1 = null;
        String asstAccount2 = null;
        String asstAccountId1 = null;
        String asstAccountId2 = null;
        AccountViewInfo acctView1 = null;
        AccountViewInfo acctView2 = null;
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            acctView1 = entrys.get(i).getAccount();
            accountID1 = acctView1.getId().toString();
            accountNumber1 = acctView1.getNumber();
            asstAccount1 = entrys.get(i).getAsstAccount();
            asstAccountId1 = entrys.get(i).getAsstAccountID();
            int size2 = entrys.size();
            for (int j = i + 1; j < size2; ++j) {
                acctView2 = entrys.get(j).getAccount();
                accountID2 = acctView2.getId().toString();
                accountNumber2 = acctView2.getNumber();
                asstAccount2 = entrys.get(j).getAsstAccount();
                asstAccountId2 = entrys.get(j).getAsstAccountID();
                if (!accountID1.equals(accountID2) && !accountNumber1.startsWith(accountNumber2) && !accountNumber2.startsWith(accountNumber1) || !this.isOverlap(ctx, asstAccount1, asstAccount2, asstAccountId1, asstAccountId2)) continue;
                throw new GLFetchDataException(GLFetchDataException.OVERLAP_ASSTACCOUNT, new Object[]{i + 1, j + 1});
            }
        }
    }

    private boolean isOverlap(Context ctx, String asstAccount1, String asstAccount2, String asstAccountId1, String asstAccountId2) throws BOSException {
        if (asstAccount1 == null || asstAccount2 == null) {
            return true;
        }
        if (asstAccount1.length() == 0 || asstAccount2.length() == 0) {
            return true;
        }
        ArrayList<String> asstActTypeList = new ArrayList<String>();
        HashMap<String, String> asstActNumbers1 = new HashMap<String, String>();
        String[] temp1 = this.splitString(asstAccount1);
        String[] tempId1 = this.splitString(asstAccountId1);
        int count = temp1.length;
        for (int i = 0; i < count; i += 2) {
            asstActNumbers1.put(temp1[i], tempId1[i + 1]);
            asstActTypeList.add(temp1[i]);
        }
        HashMap<String, String> asstActNumbers2 = new HashMap<String, String>();
        String[] temp2 = this.splitString(asstAccount2);
        String[] tempId2 = this.splitString(asstAccountId2);
        int count2 = temp2.length;
        for (int i = 0; i < count2; i += 2) {
            asstActNumbers2.put(temp2[i], tempId2[i + 1]);
        }
        String asstActNumber1 = null;
        String asstActNumber2 = null;
        String asstActNumber11 = null;
        String asstActNumber12 = null;
        String asstActNumber21 = null;
        String asstActNumber22 = null;
        String asstAcctId = null;
        IObjectValue asstAcctInfo = null;
        int index = 0;
        String asstActKey = null;
        Object o = null;
        int count3 = asstActTypeList.size();
        for (int i = 0; i < count3; ++i) {
            asstActKey = asstActTypeList.get(i).toString();
            o = asstActNumbers1.get(asstActKey);
            asstActNumber1 = o == null ? ":" : asstActNumbers1.get(asstActKey).toString();
            o = asstActNumbers2.get(asstActKey);
            asstActNumber2 = o == null ? ":" : asstActNumbers2.get(asstActKey).toString();
            index = asstActNumber1.indexOf(":");
            asstAcctId = asstActNumber1.substring(0, index);
            asstAcctInfo = !this.asstAcctMap.containsKey(asstAcctId) ? this.getDynamicObject(ctx, asstAcctId) : (IObjectValue)this.asstAcctMap.get(asstAcctId);
            if (asstAcctInfo == null) continue;
            asstActNumber11 = asstAcctInfo.getString("longNumber");
            if (asstActNumber11 == null) {
                asstActNumber11 = asstAcctInfo.getString("number");
            }
            if ((asstAcctInfo = !this.asstAcctMap.containsKey(asstAcctId = asstActNumber1.substring(index + 1)) ? this.getDynamicObject(ctx, asstAcctId) : (IObjectValue)this.asstAcctMap.get(asstAcctId)) == null) continue;
            asstActNumber12 = asstAcctInfo.getString("longNumber");
            if (asstActNumber12 == null) {
                asstActNumber12 = asstAcctInfo.getString("number");
            }
            if ((asstAcctInfo = !this.asstAcctMap.containsKey(asstAcctId = asstActNumber2.substring(0, index = asstActNumber2.indexOf(":"))) ? this.getDynamicObject(ctx, asstAcctId) : (IObjectValue)this.asstAcctMap.get(asstAcctId)) == null) continue;
            asstActNumber21 = asstAcctInfo.getString("longNumber");
            if (asstActNumber21 == null) {
                asstActNumber21 = asstAcctInfo.getString("number");
            }
            if ((asstAcctInfo = !this.asstAcctMap.containsKey(asstAcctId = asstActNumber2.substring(index + 1)) ? this.getDynamicObject(ctx, asstAcctId) : (IObjectValue)this.asstAcctMap.get(asstAcctId)) == null) continue;
            asstActNumber22 = asstAcctInfo.getString("longNumber");
            if (asstActNumber22 == null) {
                asstActNumber22 = asstAcctInfo.getString("number");
            }
            int compare1 = 0;
            int compare2 = 0;
            compare1 = asstActNumber12.equals("") ? 1 : asstActNumber12.compareTo(asstActNumber21);
            compare2 = asstActNumber22.equals("") ? -1 : asstActNumber11.compareTo(asstActNumber22);
            if (compare1 >= 0 && compare2 <= 0) continue;
            return false;
        }
        return true;
    }

    private IObjectValue getDynamicObject(Context ctx, String bosId) throws BOSException {
        IObjectValue objectValue = null;
        if (bosId != null && bosId.trim().length() != 0) {
            BOSUuid uuid = BOSUuid.read((String)bosId);
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            BOSObjectType objType = uuid.getType();
            IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            objectValue = dynamicObject.getValue(objType, (IObjectPK)pk);
        }
        return objectValue;
    }

    private String[] splitString(String str) {
        ArrayList<String> stringList = new ArrayList<String>();
        Pattern pt = Pattern.compile("([^\\|]{1,})");
        Matcher matcher = pt.matcher(str);
        String v = null;
        while (matcher.find()) {
            v = matcher.group(1).trim().toString();
            stringList.add(v);
        }
        String[] result = new String[stringList.size()];
        stringList.toArray(result);
        return result;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._delete(ctx, pks);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
    }

    protected void _audit(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._audit(ctx, arrayPK);
    }

    protected void _unAudit(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._unAudit(ctx, arrayPK);
    }

    @Override
    protected String _fetchData(Context ctx, String[] ids) throws BOSException, EASBizException {
        ArrayList otherNumberList = new ArrayList();
        ArrayList ccoNumberList = new ArrayList();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.expense.*"));
        sic.add(new SelectorItemInfo("entrys.department.id"));
        for (int i = 0; i < ids.length; ++i) {
            GLFetchDataInfo ov = this.getGLFetchDataInfo(ctx, (IObjectPK)new ObjectUuidPK(ids[i]), sic);
            if (BillBaseStatusEnum.AUDITED.equals((Object)ov.getBillStatus())) {
                List[] numbers = this.fetchDataNew(ctx, ov);
                if (numbers == null) continue;
                if (numbers[0] != null) {
                    otherNumberList.addAll(numbers[0]);
                }
                if (numbers[1] == null) continue;
                ccoNumberList.addAll(numbers[1]);
                continue;
            }
            return EASResource.getString((String)RESOURCE_PATH, (String)"GLFetchDataBill_NO_AUDITED");
        }
        return this.getGetchDataResult(ctx, otherNumberList, ccoNumberList);
    }

    private String getGetchDataResult(Context ctx, List otherNumberList, List ccoNumberList) throws EASBizException, BOSException {
        if (otherNumberList.size() == 0 && ccoNumberList.size() == 0) {
            return EASResource.getString((String)RESOURCE_PATH, (String)"NO_BILL");
        }
        String message_Output = "";
        if (otherNumberList.size() > 0) {
            String[] numbers_OtherFeeBill = new String[otherNumberList.size()];
            otherNumberList.toArray(numbers_OtherFeeBill);
            if (numbers_OtherFeeBill.length > 0) {
                message_Output = this.getMessage(numbers_OtherFeeBill, "OTHER_FEE");
            }
        }
        if (ccoNumberList.size() > 0) {
            String[] numbers_ccoFeeBill = new String[ccoNumberList.size()];
            ccoNumberList.toArray(numbers_ccoFeeBill);
            if (numbers_ccoFeeBill.length > 0) {
                message_Output = message_Output + " , ";
                message_Output = message_Output + this.getMessage(numbers_ccoFeeBill, "CCO_FEE");
            }
        }
        this.clearOverheadData(ctx);
        return EASResource.getString((String)RESOURCE_PATH, (String)"FETCHDATA1") + message_Output + EASResource.getString((String)RESOURCE_PATH, (String)"FETCHDATA4");
    }

    private List[] fetchDataNew(Context ctx, GLFetchDataInfo info) throws BOSException, EASBizException {
        if (info.getCompanyOrg() == null || info.getCalculatePeriod() == null) {
            return null;
        }
        BigDecimal[][] result = this.getAcctBatchFetchData(ctx, info);
        this.clearPreviousData(ctx, info);
        List[] numbers = this.fetchDataByOverride(ctx, info, result);
        this.clearOverheadData(ctx);
        return numbers;
    }

    private BigDecimal[][] getAcctBatchFetchData(Context ctx, GLFetchDataInfo info) throws EASBizException, BOSException {
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)info.getCompanyOrg().getId().toString());
        if (period != null) {
            info.setCalculatePeriod(period);
        }
        String[][] params_jf = this.getParams(ctx, info, "JF");
        String[][] params_df = this.getParams(ctx, info, "DF");
        String[][] params_qjf = this.getParams(ctx, info, "QJF");
        String[][] params_qdf = this.getParams(ctx, info, "QDF");
        IFunctionWebserviceFacade facade = FunctionWebserviceFacadeFactory.getLocalInstance((Context)ctx);
        String[] result_jf = facade.fetchData("acct", params_jf);
        String[] result_df = facade.fetchData("acct", params_df);
        String[] result_qjf = facade.fetchData("acct", params_qjf);
        String[] result_qdf = facade.fetchData("acct", params_qdf);
        return this.computeResult(info, result_jf, result_df, result_qjf, result_qdf);
    }

    @Override
    protected List _fetchData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    private void clearPreviousData(Context ctx, GLFetchDataInfo info) throws BOSException, EASBizException {
        Object[] params = new Object[]{info.getId().toString(), info.getCompanyOrg().getId().toString(), info.getCalculatePeriod().getId().toString()};
        this.clearDataInOtherFee(ctx, params, info);
        this.clearDataInCCOFee(ctx, params, info);
    }

    private void clearDataInOtherFee(Context ctx, Object[] params, GLFetchDataInfo info) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Select TOP 1 fid From T_NCM_OtherFeeBill ").append(" Where FSourceBillID = ? And FCompanyOrg = ? And FCalculatePeriod = ? And FFivouchered = 1");
        IRowSet voucheredRS = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params);
        if (voucheredRS.size() > 0) {
            throw new GLFetchDataException(GLFetchDataException.OTHERFEEVOUCHERED, new String[]{info.getNumber()});
        }
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_OtherFeeBillEntry Where FId In ").append(" (Select entry.FId From T_NCM_OtherFeeBill parent Left outer join T_NCM_OtherFeeBillEntry entry On parent.FId = entry.FParentID ").append(" Where parent.FSourceBillID = ? And parent.FCompanyOrg = ? And parent.FCalculatePeriod = ? )");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_OtherFeeBill ").append(" Where FSourceBillID = ? And FCompanyOrg = ? And FCalculatePeriod = ? ");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
    }

    private void clearDataInCCOFee(Context ctx, Object[] params, GLFetchDataInfo info) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Select TOP 1 bill.fid From T_NCM_CCOFeeBill bill, T_NCM_CCOFeeBillEntry entry, T_NCM_OtherFeeBill otherFee ").append(" Where bill.fid = entry.FParentID and entry.fid = otherFee.FSourceBillID ").append("   and bill.FSourceBillID = ? And bill.FCompanyOrg = ? And bill.FCalculatePeriod = ? ");
        IRowSet voucheredRS = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params);
        if (voucheredRS.size() > 0) {
            throw new GLFetchDataException(GLFetchDataException.CCOFEEALLOCATED, new String[]{info.getNumber()});
        }
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_CCOFeeBillEntry Where FId In ").append(" (Select entry.FId From T_NCM_CCOFeeBill parent Left outer join T_NCM_CCOFeeBillEntry entry On parent.FId = entry.FParentID ").append(" Where parent.FSourceBillID = ? And parent.FCompanyOrg = ? And parent.FCalculatePeriod = ? )");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_CCOFeeBill ").append(" Where FSourceBillID = ? And FCompanyOrg = ? And FCalculatePeriod = ? ");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
    }

    private BigDecimal[][] computeResult(GLFetchDataInfo editData, String[] result_jf, String[] result_df, String[] result_qjf, String[] result_qdf) throws EASBizException {
        GLFetchDataEntryCollection entryCollection = editData.getEntrys();
        int count = entryCollection.size();
        GLFetchDataEntryInfo entryInfo = null;
        BigDecimal[] result = new BigDecimal[count];
        BigDecimal jf = null;
        BigDecimal df = null;
        BigDecimal[] qtyResult = new BigDecimal[count];
        BigDecimal qjf = null;
        BigDecimal qdf = null;
        for (int i = 0; i < count; ++i) {
            entryInfo = entryCollection.get(i);
            FetchDataDirectionEnum fetchDataDirection = entryInfo.getFetchDataDirect();
            try {
                jf = new BigDecimal(result_jf[i]);
            }
            catch (Exception e) {
                this.showTheException(result_jf[i]);
            }
            try {
                df = new BigDecimal(result_df[i]);
            }
            catch (Exception e) {
                this.showTheException(result_df[i]);
            }
            try {
                qjf = new BigDecimal(result_qjf[i]);
            }
            catch (Exception e) {
                this.showTheException(result_qjf[i]);
            }
            try {
                qdf = new BigDecimal(result_qdf[i]);
            }
            catch (Exception e) {
                this.showTheException(result_qdf[i]);
            }
            if (fetchDataDirection == FetchDataDirectionEnum.DEBIT) {
                result[i] = jf;
                qtyResult[i] = qjf;
                continue;
            }
            if (fetchDataDirection == FetchDataDirectionEnum.CREDIT) {
                result[i] = df;
                qtyResult[i] = qdf;
                continue;
            }
            if (fetchDataDirection == FetchDataDirectionEnum.DEBIT_CREDIT) {
                result[i] = jf.subtract(df);
                qtyResult[i] = qjf.subtract(qdf);
                continue;
            }
            if (fetchDataDirection == FetchDataDirectionEnum.CREDIT_DEBIT) {
                result[i] = df.subtract(jf);
                qtyResult[i] = qdf.subtract(qjf);
                continue;
            }
            result[i] = SysConstant.BIGZERO;
            qtyResult[i] = SysConstant.BIGZERO;
        }
        return new BigDecimal[][]{result, qtyResult};
    }

    private void showTheException(String errorMsg) throws CMBillException {
        String mesg = "error exsit!";
        if (errorMsg != null) {
            mesg = errorMsg.replaceAll("#BAD FUNCTION ", "");
        }
        throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{mesg});
    }

    private String getMessage(String[] numbers, String resourceType) {
        return EASResource.getString((String)RESOURCE_PATH, (String)resourceType) + EASResource.getString((String)RESOURCE_PATH, (String)"FETCHDATA2") + numbers[0] + EASResource.getString((String)RESOURCE_PATH, (String)"FETCHDATA3") + numbers[numbers.length - 1];
    }

    private List[] fetchDataByOverride(Context ctx, GLFetchDataInfo editData, BigDecimal[][] result) throws BOSException, EASBizException {
        List[] diffdatas = this.diffData(editData, result);
        List numberList_OtherFee = this.fetchDataToOtherFee(ctx, editData, diffdatas[0], diffdatas[1], diffdatas[4]);
        List numberList_CCOFee = this.fetchDataToCCOFee(ctx, editData, diffdatas[2], diffdatas[3], diffdatas[5]);
        return new List[]{numberList_OtherFee, numberList_CCOFee};
    }

    private List[] diffData(GLFetchDataInfo editData, BigDecimal[][] result) {
        ArrayList<GLFetchDataEntryInfo> dataToOther = new ArrayList<GLFetchDataEntryInfo>();
        ArrayList<BigDecimal> resultToOther = new ArrayList<BigDecimal>();
        ArrayList<GLFetchDataEntryInfo> dataToCCO = new ArrayList<GLFetchDataEntryInfo>();
        ArrayList<BigDecimal> resultToCCO = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> qtyResultToOther = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> qtyResultToCCO = new ArrayList<BigDecimal>();
        GLFetchDataEntryCollection entryCollection = editData.getEntrys();
        int count = entryCollection.size();
        for (int i = 0; i < count; ++i) {
            GLFetchDataEntryInfo entry = entryCollection.get(i);
            if (entry.getCostCenter() != null) {
                dataToOther.add(entry);
                resultToOther.add(result[0][i]);
                qtyResultToOther.add(result[1][i]);
                continue;
            }
            if (entry.getCostCenterGroup() == null) continue;
            dataToCCO.add(entry);
            resultToCCO.add(result[0][i]);
            qtyResultToCCO.add(result[1][i]);
        }
        return new List[]{dataToOther, resultToOther, dataToCCO, resultToCCO, qtyResultToOther, qtyResultToCCO};
    }

    private List fetchDataToOtherFee(Context ctx, GLFetchDataInfo editData, List entryCollection, List result, List qtyResult) throws BOSException, EASBizException {
        if (entryCollection.size() <= 0 || result.size() <= 0) {
            return null;
        }
        this.putOtherFetchDataToMap(entryCollection, result, qtyResult);
        List numberList_OtherFee = this.getOtherFeeBillNumber(ctx, editData, entryCollection);
        this.glEntryFeildsMap.clear();
        this.glEntryQtyFeildsMap.clear();
        if (numberList_OtherFee.size() > 0) {
            return numberList_OtherFee;
        }
        return null;
    }

    private void putOtherFetchDataToMap(List entryCollection, List result, List qtyResult) {
        String key = null;
        String costCenterID = null;
        String expenseID = null;
        String costItemID = null;
        String costObjectID = null;
        String costObjectSuiteID = null;
        String departmentID = null;
        String sourceCostCenterID = null;
        CostObjectInfo costObjectInfo = null;
        CostObjectSuiteInfo costObjectSuiteInfo = null;
        AdminOrgUnitInfo departmentInfo = null;
        CostCenterOrgUnitInfo sourceCostCenterInfo = null;
        int count = entryCollection.size();
        for (int i = 0; i < count; ++i) {
            if (result.get(i) == null) continue;
            BigDecimal dataResult = (BigDecimal)result.get(i);
            BigDecimal qtyDataResult = (BigDecimal)qtyResult.get(i);
            if (SysConstant.BIGZERO.compareTo(dataResult) == 0) continue;
            GLFetchDataEntryInfo entry = (GLFetchDataEntryInfo)entryCollection.get(i);
            costCenterID = entry.getCostCenter().getId().toString();
            expenseID = entry.getExpense().getId().toString();
            costItemID = entry.getCostItem().getId().toString();
            costObjectInfo = entry.getCostObject();
            costObjectID = costObjectInfo != null ? costObjectInfo.getId().toString() : "";
            costObjectSuiteInfo = entry.getCostObjectSuite();
            costObjectSuiteID = costObjectSuiteInfo != null ? costObjectSuiteInfo.getId().toString() : "";
            departmentInfo = entry.getDepartment();
            departmentID = departmentInfo != null ? departmentInfo.getId().toString() : "";
            sourceCostCenterInfo = entry.getSourceCostCenter();
            sourceCostCenterID = sourceCostCenterInfo != null ? sourceCostCenterInfo.getId().toString() : "";
            key = costCenterID + ";" + expenseID + ";" + costItemID + ";" + costObjectID + ";" + costObjectSuiteID + ";" + departmentID + ";" + sourceCostCenterID;
            if (this.glEntryFeildsMap.containsKey(key)) {
                BigDecimal resultInMap = (BigDecimal)this.glEntryFeildsMap.get(key);
                this.glEntryFeildsMap.put(key, dataResult.add(resultInMap));
                BigDecimal qytResultInMap = (BigDecimal)this.glEntryQtyFeildsMap.get(key);
                this.glEntryQtyFeildsMap.put(key, qtyDataResult.add(qytResultInMap));
                continue;
            }
            this.glEntryFeildsMap.put(key, dataResult);
            this.glEntryQtyFeildsMap.put(key, qtyDataResult);
            this.costCenter.put(costCenterID, entry.getCostCenter());
            this.expense.put(expenseID, entry.getExpense());
            this.costItem.put(costItemID, entry.getCostItem());
            if (costObjectID.length() > 0) {
                this.costObject.put(costObjectID, costObjectInfo);
            }
            if (costObjectSuiteID.length() > 0) {
                this.costObjectSuite.put(costObjectSuiteID, costObjectSuiteInfo);
            }
            if (departmentID.length() > 0) {
                this.department.put(departmentID, departmentInfo);
            }
            if (sourceCostCenterID.length() <= 0) continue;
            this.sourceCostCenterMap.put(sourceCostCenterID, sourceCostCenterInfo);
        }
    }

    private List getOtherFeeBillNumber(Context ctx, GLFetchDataInfo editData, List entryCollection) throws EASBizException, BOSException {
        String key = null;
        String costCenterID = null;
        String expenseID = null;
        String costItemID = null;
        String costObjectID = null;
        String costObjectSuiteID = null;
        String departmentID = null;
        String sourceCostCnterID = null;
        CostCenterOrgUnitInfo costCenterInfo = null;
        ExpenseInfo expenseInfo = null;
        CostItemInfo costItemInfo = null;
        CostObjectInfo costObjectInfo = null;
        CostObjectSuiteInfo costObjectSuiteInfo = null;
        AdminOrgUnitInfo departmentInfo = null;
        CostCenterOrgUnitInfo sourceCostCenterInfo = null;
        ArrayList<String> numberList_OtherFee = new ArrayList<String>();
        BigDecimal itemValue = null;
        BigDecimal qtyItemValue = null;
        Iterator iterator = this.glEntryFeildsMap.keySet().iterator();
        int index1 = 0;
        int index2 = 0;
        int index3 = 0;
        int index4 = 0;
        int index5 = 0;
        int index6 = 0;
        while (iterator.hasNext()) {
            key = iterator.next().toString();
            index1 = key.indexOf(";");
            costCenterID = key.substring(0, index1);
            index2 = key.indexOf(";", index1 + 1);
            expenseID = key.substring(index1 + 1, index2);
            index3 = key.indexOf(";", index2 + 1);
            costItemID = key.substring(index2 + 1, index3);
            index4 = key.indexOf(";", index3 + 1);
            costObjectID = key.substring(index3 + 1, index4);
            index5 = key.indexOf(";", index4 + 1);
            costObjectSuiteID = key.substring(index4 + 1, index5);
            index6 = key.indexOf(";", index5 + 1);
            departmentID = key.substring(index5 + 1, index6);
            sourceCostCnterID = key.substring(index6 + 1);
            costCenterInfo = (CostCenterOrgUnitInfo)this.costCenter.get(costCenterID);
            expenseInfo = (ExpenseInfo)this.expense.get(expenseID);
            costItemInfo = (CostItemInfo)this.costItem.get(costItemID);
            costObjectInfo = costObjectID != null && costObjectID.length() > 0 ? (CostObjectInfo)this.costObject.get(costObjectID) : null;
            costObjectSuiteInfo = costObjectSuiteID != null && costObjectSuiteID.length() > 0 ? (CostObjectSuiteInfo)this.costObjectSuite.get(costObjectSuiteID) : null;
            departmentInfo = departmentID != null && departmentID.length() > 0 ? (AdminOrgUnitInfo)this.department.get(departmentID) : null;
            sourceCostCenterInfo = sourceCostCnterID != null && sourceCostCnterID.length() > 0 ? (CostCenterOrgUnitInfo)this.sourceCostCenterMap.get(sourceCostCnterID) : null;
            itemValue = BDCMUtils.effectualNumeric((BigDecimal)((BigDecimal)this.glEntryFeildsMap.get(key)));
            if (expenseInfo != null && expenseInfo.isIsAllocateQty()) {
                qtyItemValue = BDCMUtils.effectualNumeric((BigDecimal)((BigDecimal)this.glEntryQtyFeildsMap.get(key)));
            }
            String preNumber = this.getOtherPreNumber(ctx, editData);
            numberList_OtherFee.add(this.fetchDataToOtherFeeBill(ctx, editData, costCenterInfo, expenseInfo, costItemInfo, costObjectInfo, costObjectSuiteInfo, departmentInfo, sourceCostCenterInfo, itemValue, qtyItemValue, preNumber));
        }
        return numberList_OtherFee;
    }

    private String getCCOPreNumber(Context ctx, GLFetchDataInfo editData) throws EASBizException, BOSException {
        return this.getPreNumber("CCOFee", ctx, editData, new CCOFeeBillInfo());
    }

    private String getOtherPreNumber(Context ctx, GLFetchDataInfo editData) throws EASBizException, BOSException {
        return this.getPreNumber("OtherFee", ctx, editData, new OtherFeeBillInfo());
    }

    private String getPreNumber(String preNumber, Context ctx, GLFetchDataInfo editData, CMBillBaseInfo info) throws EASBizException, BOSException {
        boolean hasCodingRule = this.checkCodingRule(ctx, editData.getCompanyOrg().getId().toString(), (IObjectValue)info);
        if (!hasCodingRule) {
            Timestamp now = BDCMUtils.DateToTime((Date)BDCMUtils.now());
            preNumber = preNumber + now.getYear() + now.getMonth() + now.getDay() + now.getHours() + now.getMinutes() + now.getSeconds() + new Random().nextInt(100);
            return preNumber;
        }
        return null;
    }

    private List fetchDataToCCOFee(Context ctx, GLFetchDataInfo editData, List entryCollection, List result, List qtyResult) throws BOSException, EASBizException {
        if (entryCollection.size() <= 0 || result.size() <= 0) {
            return null;
        }
        this.putCCOFetchDataToMap(entryCollection, result, qtyResult);
        List numberList_CCOFee = this.getCCOFeeBillNumber(ctx, editData, entryCollection);
        this.glEntryFeildsMap.clear();
        this.glEntryQtyFeildsMap.clear();
        if (numberList_CCOFee.size() > 0) {
            return numberList_CCOFee;
        }
        return null;
    }

    private void putCCOFetchDataToMap(List entryCollection, List result, List qtyResult) {
        String key = null;
        String expenseID = null;
        String costItemID = null;
        String costCenterGroupID = null;
        String departmentID = null;
        String sourceCostCenterID = null;
        int count = entryCollection.size();
        for (int i = 0; i < count; ++i) {
            if (result.get(i) == null) continue;
            BigDecimal resultData = (BigDecimal)result.get(i);
            BigDecimal qtyResultData = (BigDecimal)qtyResult.get(i);
            if (SysConstant.BIGZERO.compareTo(resultData) == 0) continue;
            GLFetchDataEntryInfo entry = (GLFetchDataEntryInfo)entryCollection.get(i);
            expenseID = entry.getExpense().getId().toString();
            costItemID = entry.getCostItem().getId().toString();
            costCenterGroupID = entry.getCostCenterGroup().getId().toString();
            departmentID = entry.getDepartment() != null ? entry.getDepartment().getId().toString() : "";
            sourceCostCenterID = entry.getSourceCostCenter() != null ? entry.getSourceCostCenter().getId().toString() : "";
            key = costCenterGroupID + ";" + expenseID + ";" + costItemID + ";" + departmentID + ";" + sourceCostCenterID;
            if (this.glEntryFeildsMap.containsKey(key)) {
                BigDecimal resultInMap = (BigDecimal)this.glEntryFeildsMap.get(key);
                this.glEntryFeildsMap.put(key, resultData.add(resultInMap));
                BigDecimal qtyResultInMap = (BigDecimal)this.glEntryQtyFeildsMap.get(key);
                this.glEntryQtyFeildsMap.put(key, qtyResultData.add(qtyResultInMap));
                continue;
            }
            this.glEntryFeildsMap.put(key, resultData);
            this.glEntryQtyFeildsMap.put(key, qtyResultData);
            this.costCenterGroup.put(costCenterGroupID, entry.getCostCenterGroup());
            this.expense.put(expenseID, entry.getExpense());
            this.costItem.put(costItemID, entry.getCostItem());
            this.department.put(departmentID, entry.getDepartment());
            this.sourceCostCenterMap.put(sourceCostCenterID, entry.getSourceCostCenter());
        }
    }

    private List getCCOFeeBillNumber(Context ctx, GLFetchDataInfo editData, List entryCollection) throws EASBizException, BOSException {
        String key = null;
        String expenseID = null;
        String costItemID = null;
        String costCenterGroupID = null;
        String departmentID = null;
        String sourceCostCenterID = null;
        CostCenterOrgUnitGroupInfo costCenterGroupInfo = null;
        ExpenseInfo expenseInfo = null;
        CostItemInfo costItemInfo = null;
        AdminOrgUnitInfo departmentInfo = null;
        CostCenterOrgUnitInfo sourceCostCenterInfo = null;
        ArrayList<String> numberList_CCOFee = new ArrayList<String>();
        BigDecimal itemValue = null;
        BigDecimal qtyItemValue = null;
        Iterator iterator = this.glEntryFeildsMap.keySet().iterator();
        int index1 = 0;
        int index2 = 0;
        int index3 = 0;
        int index4 = 0;
        while (iterator.hasNext()) {
            key = iterator.next().toString();
            index1 = key.indexOf(";");
            costCenterGroupID = key.substring(0, index1);
            index2 = key.indexOf(";", index1 + 1);
            expenseID = key.substring(index1 + 1, index2);
            index3 = key.indexOf(";", index2 + 1);
            costItemID = key.substring(index2 + 1, index3);
            index4 = key.indexOf(";", index3 + 1);
            departmentID = key.substring(index3 + 1, index4);
            sourceCostCenterID = key.substring(index4 + 1);
            costCenterGroupInfo = (CostCenterOrgUnitGroupInfo)this.costCenterGroup.get(costCenterGroupID);
            expenseInfo = (ExpenseInfo)this.expense.get(expenseID);
            costItemInfo = (CostItemInfo)this.costItem.get(costItemID);
            departmentInfo = departmentID != null && departmentID.length() > 0 ? (AdminOrgUnitInfo)this.department.get(departmentID) : null;
            sourceCostCenterInfo = sourceCostCenterID != null && sourceCostCenterID.length() > 0 ? (CostCenterOrgUnitInfo)this.sourceCostCenterMap.get(sourceCostCenterID) : null;
            itemValue = BDCMUtils.effectualNumeric((BigDecimal)((BigDecimal)this.glEntryFeildsMap.get(key)));
            if (expenseInfo != null && expenseInfo.isIsAllocateQty()) {
                qtyItemValue = BDCMUtils.effectualNumeric((BigDecimal)((BigDecimal)this.glEntryQtyFeildsMap.get(key)));
            }
            String preNumber = this.getCCOPreNumber(ctx, editData);
            numberList_CCOFee.add(this.fetchDataToCCOFeeBill(ctx, editData, expenseInfo, costItemInfo, costCenterGroupInfo, departmentInfo, sourceCostCenterInfo, itemValue, qtyItemValue, preNumber));
        }
        return numberList_CCOFee;
    }

    private PeriodInfo fullPeriod(Context ctx, PeriodInfo period) throws EASBizException, BOSException {
        PeriodInfo p = period;
        if (period != null && period.getId() != null && period.getEndDate() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("startDate"));
            selector.add(new SelectorItemInfo("endDate"));
            p = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectStringPK(period.getId().toString()), selector);
        }
        return p;
    }

    private String fetchDataToOtherFeeBill(Context ctx, GLFetchDataInfo editData, CostCenterOrgUnitInfo costCenterInfo, ExpenseInfo expenseInfo, CostItemInfo costItemInfo, CostObjectInfo costObjectInfo, CostObjectSuiteInfo cosInfo, AdminOrgUnitInfo departmentInfo, CostCenterOrgUnitInfo sourceCostCenterInfo, BigDecimal result, BigDecimal qtyItemValue, String newNumber) throws EASBizException, BOSException {
        int count;
        boolean isExist = false;
        String number = null;
        if (result == null) {
            result = SysConstant.BIGZERO;
        }
        if (qtyItemValue == null) {
            qtyItemValue = SysConstant.BIGZERO;
        }
        OtherFeeBillInfo newOtherFeeInfo = null;
        OtherFeeBillEntryInfo entryInfo = null;
        OtherFeeBillEntryCollection collection = null;
        newOtherFeeInfo = new OtherFeeBillInfo();
        newOtherFeeInfo.setIsAuto(true);
        newOtherFeeInfo.setFetchSource(FetchSourceEnum.FROMCCO);
        newOtherFeeInfo.setCU(editData.getCU());
        newOtherFeeInfo.setNumber(newNumber);
        newOtherFeeInfo.setCompanyOrg(editData.getCompanyOrg());
        newOtherFeeInfo.setCostCenter(costCenterInfo);
        newOtherFeeInfo.setSourceBillId(editData.getId().toString());
        newOtherFeeInfo.setSourceFunction(editData.getNumber() + "-" + editData.getDescription());
        PeriodInfo p = this.fullPeriod(ctx, editData.getCalculatePeriod());
        newOtherFeeInfo.setBizDate(p.getEndDate());
        newOtherFeeInfo.setCalculatePeriod(editData.getCalculatePeriod());
        newOtherFeeInfo.setBillStatus(BillBaseStatusEnum.AUDITED);
        newOtherFeeInfo.setAuditor(editData.getCreator());
        newOtherFeeInfo.setAuditTime(BDCMUtils.DateToTime((Date)BDCMUtils.now()));
        newOtherFeeInfo.setDepartment(departmentInfo);
        newOtherFeeInfo.setSourceCostCenter(sourceCostCenterInfo);
        isExist = false;
        entryInfo = new OtherFeeBillEntryInfo();
        entryInfo.setExpense(expenseInfo);
        entryInfo.setCostItem(costItemInfo);
        entryInfo.setAmount(result);
        expenseInfo = ExpenseFactory.getLocalInstance((Context)ctx).getExpenseInfo((IObjectPK)new ObjectUuidPK(expenseInfo.getId()));
        logger.error((Object)("===========\u8981\u7d20\u8d39\u7528" + expenseInfo.getName() + "\u662f\u5426\u5f52\u96c6\u8d39\u7528\uff1a" + expenseInfo.isIsAllocateQty()));
        logger.error((Object)("===========\u6570\u91cf\u4e3a\uff1a" + qtyItemValue));
        if (expenseInfo.isIsAllocateQty() && qtyItemValue.compareTo(BigDecimal.ZERO) != 0) {
            MeasureUnitInfo unitInfo = expenseInfo.getUnit();
            StringBuffer msg = new StringBuffer();
            msg.append(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"DO_TASK_FAILED")).append(",");
            if (unitInfo == null) {
                msg.append(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"EXPENSE_UNIT_NULL"));
                throw new EASBizException(new NumericExceptionSubItem("", msg.toString()));
            }
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT 1 FROM T_NCM_GLFetchData bill").append(" inner join T_NCM_GLFETCHDATAENTRY entry on bill.fid=entry.FPARENTID").append(" inner join T_BD_AccountView acc on acc.fid=entry.faccountid").append(" inner join T_BD_MEASUREUNIT unit on unit.fid=acc.FMEASUREUNITID").append(" where bill.fid ='").append(editData.getId()).append("' and entry.FEXPENSEID='").append(expenseInfo.getId().toString()).append("'").append(" and unit.FGROUPID = (SELECT fgroupid FROM T_BD_MEASUREUNIT where fid='").append(unitInfo.getId()).append("')");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.size() == 0) {
                msg.append(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"EXPENSE_UNIT_NOT_IN_GROUP"));
                throw new EASBizException(new NumericExceptionSubItem("", msg.toString()));
            }
            BigDecimal coefficient = unitInfo.getCoefficient();
            if (coefficient == null) {
                unitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId()));
            }
            int qtyPrecision = unitInfo.getQtyPrecision();
            coefficient = unitInfo.getCoefficient();
            logger.error((Object)("===========\u5355\u4f4d" + unitInfo.getName() + "\u4e0e\u6807\u51c6\u5355\u4f4d\u6362\u7b97\u7cfb\u6570\u4e3a\uff1a" + coefficient));
            qtyItemValue = qtyItemValue.divide(coefficient, qtyPrecision, 4);
        } else {
            qtyItemValue = BigDecimal.ZERO;
            logger.error((Object)("===========\u4e0d\u5f52\u96c6\u6570\u91cf\uff0c\u5c06\u6570\u91cf\u8bbe\u7f6e\u4e3a\uff1a" + qtyItemValue));
        }
        logger.error((Object)("===========\u6362\u7b97\u540e\u6570\u91cf\u4e3a\uff1a" + qtyItemValue));
        entryInfo.setQty(qtyItemValue);
        if (result != null && qtyItemValue != null && qtyItemValue.compareTo(SysConstant.BIGZERO) != 0) {
            entryInfo.setPrice(result.divide(qtyItemValue, expenseInfo.getPricePrecision(), 4));
        }
        entryInfo.setCostObject(costObjectInfo);
        entryInfo.setCostObjectSuite(cosInfo);
        if (newOtherFeeInfo != null && (count = (collection = newOtherFeeInfo.getEntries()).size()) > 0) {
            for (int i = count - 1; i >= 0; --i) {
                OtherFeeBillEntryInfo temp_entryInfo = collection.get(i);
                if (!temp_entryInfo.getCostItem().getId().toString().equals(costItemInfo.getId().toString())) continue;
                collection.removeObject(i);
            }
        }
        collection.add(entryInfo);
        newOtherFeeInfo.put("entrys", (Object)collection);
        IOtherFeeBill iOtherFeeBill = OtherFeeBillFactory.getLocalInstance(ctx);
        if (!isExist) {
            IObjectPK pk = iOtherFeeBill.addnew((CoreBaseInfo)newOtherFeeInfo);
            number = iOtherFeeBill.getOtherFeeBillInfo(pk).getNumber().toString();
        } else {
            iOtherFeeBill.update((IObjectPK)new ObjectStringPK(newOtherFeeInfo.getId().toString()), (CoreBaseInfo)newOtherFeeInfo);
            number = newOtherFeeInfo.getNumber();
        }
        return number;
    }

    private String fetchDataToCCOFeeBill(Context ctx, GLFetchDataInfo editData, ExpenseInfo expenseInfo, CostItemInfo costItemInfo, CostCenterOrgUnitGroupInfo costCenterGroupInfo, AdminOrgUnitInfo departmentInfo, CostCenterOrgUnitInfo sourceCostCenterInfo, BigDecimal result, BigDecimal qtyItemValue, String newNumber) throws EASBizException, BOSException {
        if (result == null) {
            result = SysConstant.BIGZERO;
        }
        if (qtyItemValue == null) {
            qtyItemValue = SysConstant.BIGZERO;
        }
        CCOFeeBillInfo newCCOFeeInfo = new CCOFeeBillInfo();
        newCCOFeeInfo.setIsAuto(true);
        newCCOFeeInfo.setCU(editData.getCU());
        newCCOFeeInfo.setNumber(newNumber);
        newCCOFeeInfo.setCompanyOrg(editData.getCompanyOrg());
        newCCOFeeInfo.setCostCenterGroup(costCenterGroupInfo);
        newCCOFeeInfo.setSourceBillId(editData.getId().toString());
        newCCOFeeInfo.setSourceFunction(editData.getNumber() + "-" + editData.getDescription());
        PeriodInfo p = this.fullPeriod(ctx, editData.getCalculatePeriod());
        newCCOFeeInfo.setBizDate(p.getEndDate());
        newCCOFeeInfo.setCalculatePeriod(editData.getCalculatePeriod());
        newCCOFeeInfo.setBillStatus(BillBaseStatusEnum.AUDITED);
        newCCOFeeInfo.setAuditor(editData.getCreator());
        newCCOFeeInfo.setAuditTime(BDCMUtils.DateToTime((Date)BDCMUtils.now()));
        newCCOFeeInfo.setDepartment(departmentInfo);
        newCCOFeeInfo.setSourceCostCenter(sourceCostCenterInfo);
        CCOFeeBillEntryInfo entryInfo = new CCOFeeBillEntryInfo();
        entryInfo.setExpense(expenseInfo);
        entryInfo.setCostItem(costItemInfo);
        entryInfo.setAmount(result);
        expenseInfo = ExpenseFactory.getLocalInstance((Context)ctx).getExpenseInfo((IObjectPK)new ObjectUuidPK(expenseInfo.getId()));
        if (!expenseInfo.isIsAllocateQty() || qtyItemValue != null) {
            // empty if block
        }
        entryInfo.setQty(qtyItemValue);
        if (result != null && qtyItemValue != null && qtyItemValue.compareTo(SysConstant.BIGZERO) != 0) {
            entryInfo.setPrice(result.divide(qtyItemValue, 2));
        }
        CCOFeeBillEntryCollection collections = newCCOFeeInfo.getEntries();
        collections.add(entryInfo);
        ICCOFeeBill iCCOFeeBill = CCOFeeBillFactory.getLocalInstance(ctx);
        IObjectPK pk = iCCOFeeBill.addnew((CoreBaseInfo)newCCOFeeInfo);
        String number = iCCOFeeBill.getCCOFeeBillInfo(pk).getNumber().toString();
        return number;
    }

    private String[][] getParams(Context ctx, GLFetchDataInfo editData, String fetchDataDirection) throws EASBizException, BOSException {
        String companyNumber = null;
        String year = "0";
        String period = "0";
        String currencyNumber = "GLC";
        String accountNumber = null;
        ObjectUuidPK pk = new ObjectUuidPK(editData.getCompanyOrg().getId());
        CompanyOrgUnitInfo comOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
        companyNumber = comOrg.getNumber();
        PeriodInfo periodInfo = editData.getCalculatePeriod();
        year = Integer.toString(periodInfo.getPeriodYear());
        period = Integer.toString(periodInfo.getPeriodNumber());
        GLFetchDataEntryCollection entryCollection = editData.getEntrys();
        int count = entryCollection.size();
        String[][] params = new String[count][];
        GLFetchDataEntryInfo entryInfo = null;
        StringBuffer accountItem = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            accountItem.setLength(0);
            entryInfo = entryCollection.get(i);
            ObjectUuidPK accpk = new ObjectUuidPK(entryInfo.getAccount().getId());
            AccountViewInfo accInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)accpk);
            accountNumber = accInfo.getNumber();
            accountItem.append(accountNumber).append(":").append(accountNumber);
            if (entryInfo.getAsstAccount() != null) {
                accountItem.append(entryInfo.getAsstAccount());
            }
            String isContainsNoVouchered = "false";
            if (this.isContainsNoVouchered(comOrg, ctx)) {
                isContainsNoVouchered = "true";
            }
            String[] params_row = new String[]{companyNumber, accountItem.toString(), fetchDataDirection, year, period, year, period, currencyNumber, isContainsNoVouchered};
            params[i] = params_row;
        }
        return params;
    }

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_GLFetchData";
    }

    private boolean checkCodingRule(Context ctx, String strCompanyID, IObjectValue aCMBillBaseInfo) throws BOSException, EASBizException {
        ICodingRuleManager icrm = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus rStatus = icrm.getRuleStatus(aCMBillBaseInfo, strCompanyID);
        if (!rStatus.isExist()) {
            String msg = NCMServerUtils.getEntityName((Context)ctx, (BOSObjectType)aCMBillBaseInfo.getBOSType());
            throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{msg});
        }
        return true;
    }

    protected boolean isCheckStart() {
        return false;
    }

    private void clearOverheadData(Context ctx) throws BOSException, EASBizException {
        StringBuffer kSql = new StringBuffer();
        kSql.append(" delete ");
        kSql.append("   from T_NCM_OtherFeeBill  ");
        kSql.append("  where FVoucherID in ");
        kSql.append("        (select FDestObjectID ");
        kSql.append("           from T_BOT_Relation ");
        kSql.append("          where FSRCObjectID in (select FID from T_NCM_InnerOverheadBill)) ");
        DbUtil.execute((Context)ctx, (String)kSql.toString());
    }

    private boolean isContainsNoVouchered(CompanyOrgUnitInfo company, Context ctx) {
        ParamItemInfo paramItemInfo;
        String value;
        String orgUnitInfoID = company.getId().toString();
        IParamItem ctr = null;
        try {
            ctr = ParamItemFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        FilterInfo paramItemFilter = new FilterInfo();
        paramItemFilter.getFilterItems().add(new FilterItemInfo("orgUnitID.id", (Object)orgUnitInfoID, CompareType.EQUALS));
        paramItemFilter.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"CM009", CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(paramItemFilter);
        ParamItemCollection collect = null;
        try {
            if (ctr != null) {
                collect = ctr.getParamItemCollection(view);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return collect == null || collect.size() <= 0 || !"false".equals(value = (paramItemInfo = collect.get(0)).getValue());
    }

    protected String[] _selectAllAuditIdsForGLFetchData(Context ctx, String companyID) throws BOSException {
        String sql = "select fid from t_ncM_GLFetchData where FBillStatus = 4 and FCompanyOrg = '" + companyID + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> idsList = new ArrayList<String>();
        try {
            while (rs.next()) {
                idsList.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String[] ids = new String[idsList.size()];
        for (int i = 0; i < idsList.size(); ++i) {
            ids[i] = idsList.get(i).toString();
        }
        return ids;
    }

    protected Map bizCheckForSubmit(final Context ctx, List ids, Map param) throws BOSException, EASBizException {
        final String companyID = param.containsKey("companyID") && param.get("companyID") != null ? (String)param.get("companyID") : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        final HashMap report = new HashMap();
        if (ids == null || ids.isEmpty()) {
            return report;
        }
        ArrayList<Object[]> idsParam = new ArrayList<Object[]>();
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            idsParam.add(new Object[]{ids.get(i)});
        }
        StringBuffer kSql = new StringBuffer();
        String noEntry = "\u5355\u636e\u6ca1\u6709\u5206\u5f55";
        String noName = "\u65b9\u6848\u540d\u79f0\u4e3a\u7a7a";
        kSql.setLength(0);
        kSql.append(" select FID,FDescription \n");
        kSql.append("   from T_NCM_GLFetchData \n");
        kSql.append("  where FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and FNumber is not null \n");
        kSql.append("    and (FID not in (select FParentID from T_NCM_GLFetchDataEntry) or FDescription is null) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                String name = rs.getString("FDescription");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (name == null || name.length() < 1) {
                    detail.add("\u65b9\u6848\u540d\u79f0\u4e3a\u7a7a");
                } else {
                    detail.add("\u5355\u636e\u6ca1\u6709\u5206\u5f55");
                }
                report.put(id, detail);
            }
        });
        String entry = "\u5206\u5f55";
        String noAccountInEntry = "\u672a\u5f55\u5165\u8d39\u7528\u79d1\u76ee";
        String noFetchDataDirectInEntry = "\u672a\u5f55\u5165\u501f\u8d37\u65b9\u5411";
        String expenseIsNull = "\u672a\u5f55\u5165\u8981\u7d20\u8d39\u7528";
        String costItemIsNull = "\u672a\u5f55\u5165\u6210\u672c\u9879\u76ee";
        String costObjectIsNull = "\u672a\u5f55\u5165\u6210\u672c\u5bf9\u8c61";
        String costCenterIsNull = "\u7684\u6210\u672c\u4e2d\u5fc3\u548c\u6210\u672c\u4e2d\u5fc3\u7ec4\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a";
        String coSql = "";
        if (this.isCostObjectOfBillRequired(ctx, companyID)) {
            coSql = "FCostObjectID, ";
        }
        kSql.setLength(0);
        kSql.append(" select FParentID,FSeq,FAccountID,FFetchDataDirect, FCostItemID, " + coSql + "FExpenseID, FCostCenterID, FCostCenterGroupID \n");
        kSql.append("   from T_NCM_GLFetchDataEntry \n");
        kSql.append("  where FParentID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        coSql = "";
        if (this.isCostObjectOfBillRequired(ctx, companyID)) {
            coSql = "or FCostObjectID is null ";
        }
        kSql.append("    and (FCostItemID is null " + coSql + " or FExpenseID is null or FAccountID is null or FFetchDataDirect is null or ( FCostCenterID is null and FCostCenterGroupID is null ) ) \n");
        kSql.append(" order by FParentID,Fseq \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                try {
                    int seq = rs.getInt("FSeq");
                    String id = rs.getString("FParentID");
                    String accountID = rs.getString("FAccountID");
                    String fetchDataDirect = rs.getString("FFetchDataDirect");
                    String costItemID = rs.getString("FCostItemID");
                    String expenseID = rs.getString("FExpenseID");
                    String costObjectID = null;
                    if (GLFetchDataControllerBean.this.isCostObjectOfBillRequired(ctx, companyID)) {
                        costObjectID = rs.getString("FCostObjectID");
                    }
                    String fCostCenterID = rs.getString("FCostCenterID");
                    String fCostCenterGroupID = rs.getString("FCostCenterGroupID");
                    List detail = null;
                    detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                    if (accountID == null || accountID.length() == 0) {
                        detail.add("\u5206\u5f55" + seq + "\u672a\u5f55\u5165\u8d39\u7528\u79d1\u76ee");
                    }
                    if (fetchDataDirect == null || fetchDataDirect.length() == 0) {
                        detail.add("\u5206\u5f55" + seq + "\u672a\u5f55\u5165\u501f\u8d37\u65b9\u5411");
                    }
                    if (expenseID == null || expenseID.length() == 0) {
                        detail.add("\u5206\u5f55" + seq + "\u672a\u5f55\u5165\u8981\u7d20\u8d39\u7528");
                    }
                    if (costItemID == null || costItemID.length() == 0) {
                        detail.add("\u5206\u5f55" + seq + "\u672a\u5f55\u5165\u6210\u672c\u9879\u76ee");
                    }
                    if (GLFetchDataControllerBean.this.isCostObjectOfBillRequired(ctx, companyID) && (costObjectID == null || costObjectID.length() == 0)) {
                        detail.add("\u5206\u5f55" + seq + "\u672a\u5f55\u5165\u6210\u672c\u5bf9\u8c61");
                    }
                    if (!(fCostCenterID != null && fCostCenterID.length() != 0 || fCostCenterGroupID != null && fCostCenterGroupID.length() != 0)) {
                        detail.add("\u5206\u5f55" + seq + "\u7684\u6210\u672c\u4e2d\u5fc3\u548c\u6210\u672c\u4e2d\u5fc3\u7ec4\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                    }
                    report.put(id, detail);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                    throw new SQLException(e.getMessage());
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage());
                    throw new SQLException(e.getMessage());
                }
            }
        });
        return report;
    }

    private boolean isCostObjectOfBillRequired(Context ctx, String companyID) throws BOSException, EASBizException {
        if (this.costObjectOfBillRequired < 0) {
            this.costObjectOfBillRequired = 0;
            if (NCMUtils.isCostObjectOfBillRequired((Context)ctx, (String)companyID)) {
                this.costObjectOfBillRequired = 1;
            }
        }
        return this.costObjectOfBillRequired == 1;
    }
}

