/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.InnerOverheadBillInfo;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.app.AbstractInnerOverheadBillControllerBean;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InnerOverheadBillControllerBean
extends AbstractInnerOverheadBillControllerBean {
    private static final long serialVersionUID = -3584648722089529636L;
    private static Logger logger = Logger.getLogger((String)InnerOverheadBillControllerBean.class.getName());

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_InnerOverheadBill";
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK objectPK = null;
        StringBuffer kSql = null;
        IRowSet rst = null;
        CompanyOrgUnitInfo company = ((InnerOverheadBillInfo)model).getCompanyOrg();
        try {
            objectPK = super._submit(ctx, model);
            String billID = objectPK.toString();
            kSql = new StringBuffer();
            kSql.append(" SELECT COUNT(ioBillEntry.FID) as count \n");
            kSql.append(" FROM   T_NCM_InnerOverheadBill ioBill \n");
            kSql.append("        INNER JOIN T_NCM_InnerOverheadBillEntry ioBillEntry \n");
            kSql.append("          ON ioBill.FID = ioBillEntry.FParentID \n");
            kSql.append(" WHERE  ioBill.FID = ? \n");
            kSql.append("        AND ioBill.FCostCenterID = ioBillEntry.FConsumeCostCenterID \n");
            kSql.append("        AND ioBillEntry.FConsumeCostObjectID IS NULL \n");
            rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{billID});
            if (rst.next() && rst.getInt("count") > 0) {
                throw new NcmBillException(NcmBillException.IOB_SAMECOSTCENTER_NEEDCOSTOBJECT);
            }
            SQLUtils.cleanup((ResultSet)rst);
            kSql.setLength(0);
            kSql.append(" SELECT COUNT(ioBillEntry.FID) as count \n");
            kSql.append(" FROM   T_NCM_InnerOverheadBillEntry ioBillEntry \n");
            kSql.append("        INNER JOIN T_BD_CostObject co \n");
            kSql.append("          ON ioBillEntry.FConsumeCostObjectID = co.FID \n");
            kSql.append("        INNER JOIN T_BD_CostObjectEntry coe \n");
            kSql.append("          ON coe.FParentID = co.FID \n");
            kSql.append("        INNER JOIN T_NCM_AUXOverhead aux \n");
            kSql.append("          ON coe.FRelatedID = aux.FID \n");
            kSql.append(" WHERE  ioBillEntry.FParentID = ? \n");
            kSql.append("        AND ioBillEntry.FConsumeCostObjectID IS NOT NULL \n");
            kSql.append("        AND aux.FID = ioBillEntry.FAUXOverheadID \n");
            rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{billID});
            if (rst.next() && rst.getInt("count") > 0) {
                throw new NcmBillException(NcmBillException.IOB_CANNOT_SAMECOSTCENTER);
            }
            SQLUtils.cleanup((ResultSet)rst);
            kSql.setLength(0);
            kSql.append(" SELECT TOP 1 aux.FName_" + ctx.getLocale() + " as auxOverheadName, \n");
            kSql.append("              costCenter.FName_" + ctx.getLocale() + " as costCenterName \n");
            kSql.append(" FROM   T_NCM_InnerOverheadBill ioBill \n");
            kSql.append("        INNER JOIN T_NCM_InnerOverheadBillEntry ioBillEntry \n");
            kSql.append("          ON ioBill.FID = ioBillEntry.FParentID \n");
            kSql.append("        INNER JOIN T_NCM_AUXOverhead aux \n");
            kSql.append("          ON aux.FID = ioBillEntry.FAuxOverheadID \n");
            kSql.append("        INNER JOIN T_NCM_AUXOverheadCompanyInfo auxCompany \n");
            kSql.append("          ON auxCompany.FAuxOverHeadID = aux.FID \n");
            kSql.append("        INNER JOIN T_ORG_CostCenter costCenter \n");
            kSql.append("          ON auxCompany.FCostCenterID = costCenter.FID \n");
            kSql.append(" WHERE  ioBill.FID = ? \n");
            kSql.append("        AND ioBill.FCostCenterID <> costCenter.FID \n");
            kSql.append("       AND auxCompany.FCompanyID ='" + company.getId().toString() + "'");
            rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{billID});
            if (rst.next()) {
                String auxOverheadName = rst.getString("auxOverheadName");
                String costCenterName = rst.getString("costCenterName");
                throw new NcmBillException(NcmBillException.IOB_OVERHEAD_TO_COSTCENTER, new Object[]{auxOverheadName, costCenterName});
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return objectPK;
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this.checkAudit(ctx, pks);
        super._audit(ctx, pk);
    }

    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkAudit(ctx, pks);
        super._audit(ctx, pks);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this.checkUnAudit(ctx, pks);
        super._unAudit(ctx, pk);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkUnAudit(ctx, pks);
        super._unAudit(ctx, pks);
    }

    private void checkAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
    }

    private void checkUnAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0) {
            return;
        }
        IRowSet rst = null;
        try {
            for (int i = 0; i < pks.length; ++i) {
                String pk = pks[i].toString();
                rst = DbUtil.executeQuery((Context)ctx, (String)" select FFiVouchered from T_NCM_InnerOverheadBill where FID = ? ", (Object[])new String[]{pk});
                if (!rst.next() || rst.getInt("FFiVouchered") != 1) continue;
                throw new CMBillException(CMBillException.CHECKISVOUCHEREDOK);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
    }

    @Override
    protected Map _batchGetRpcData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String companyId = null;
        if (paramMap.get("companyId") instanceof String) {
            companyId = paramMap.get("companyId").toString();
        }
        if (companyId != null) {
            PeriodInfo period = this.getPeriod(ctx);
            dataMap.put("currPeriod", period);
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection OrgUnitCol = iOrgUnitRelation.getFromUnit(companyId, 1, 5);
            dataMap.put("OrgUnitCol", OrgUnitCol);
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT aux.FID, ");
        kSql.append("        auxCompany.FPricePrecision, ");
        kSql.append("        auxCompany.FStdPrice ");
        kSql.append(" FROM   T_NCM_AUXOverhead aux ");
        kSql.append("        INNER JOIN T_NCM_AUXOverheadCompanyInfo auxCompany ");
        kSql.append("          ON aux.FID = auxCompany.FAuxOverheadID ");
        HashMap<String, Object[]> auxPrecisionMap = new HashMap<String, Object[]>();
        try {
            IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
            while (rst.next()) {
                auxPrecisionMap.put(rst.getString(1), new Object[]{rst.getObject(2), rst.getObject(3)});
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        dataMap.put("auxPrecisionMap", auxPrecisionMap);
        return dataMap;
    }

    private PeriodInfo getPeriod(Context ctx) {
        Date date = new Date();
        try {
            IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.GREATER_EQUALS));
            filter.setMaskString("#0 and #1");
            evi.setFilter(filter);
            PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
            if (periodc.size() > 0) {
                return periodc.get(0);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        return null;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            srcBillVO.setString("isForVoucherDel", "true");
            srcBillVO.setBoolean("Fivouchered", false);
            srcBillVO.setString("voucher", "");
        }
        if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            String voucherId = ((BOTRelationInfo)bOTRelationInfo).getDestObjectID();
            srcBillVO.setString("voucher", voucherId);
        }
        this._reverseSave(ctx, srcBillPK, srcBillVO);
    }

    protected Map bizCheckForSubmit(Context ctx, List ids, Map param) throws BOSException, EASBizException {
        HashMap<String, List<String>> report = new HashMap<String, List<String>>();
        if (CollectionUtil.isEmpty((Collection)ids)) {
            return report;
        }
        Object[] idArray = ids.toArray();
        this.checkNullAndStatusAndQty4Submit(ctx, idArray, report);
        this.checkBizInfo4Submit(ctx, idArray, report);
        this.clearField4Submit(ctx, idArray);
        return report;
    }

    private void checkNullAndStatusAndQty4Submit(Context ctx, Object[] ids, Map<String, List<String>> report) throws EASBizException, BOSException {
        if (ids == null || ids.length == 0) {
            return;
        }
        int size = ids.length;
        try {
            List<String> errMsgList;
            String id;
            String checkNullSql = "select FId, FCostCenterId, FBizDate, FCompanyOrg, FCalculatePeriod, FBillStatus from " + this.getMainTableName(ctx, null) + " where FId in (" + NCMUtils.generateQuestionMark((int)size) + ")  and (FBizDate is null or FCompanyOrg is null or FCalculatePeriod is null or FCostCenterId is null or FBillStatus not in (" + 2 + "," + 3 + "))";
            IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)checkNullSql, (Object[])ids);
            while (rowSet.next()) {
                id = rowSet.getString("FId");
                errMsgList = report.get(id);
                if (errMsgList == null) {
                    errMsgList = new ArrayList<String>();
                    report.put(id, errMsgList);
                }
                if (rowSet.getObject("FCostCenterId") == null) {
                    errMsgList.add(ResourceUtils.getMessage((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"COST_CENTER_NOT_NULL"));
                }
                if (rowSet.getObject("FBizDate") == null) {
                    errMsgList.add(ResourceUtils.getMessage((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"BIZ_DATE_NOT_NULL"));
                }
                if (rowSet.getObject("FCompanyOrg") == null) {
                    errMsgList.add(ResourceUtils.getMessage((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"COMPANY_NOT_NULL"));
                }
                if (rowSet.getObject("FCalculatePeriod") == null) {
                    errMsgList.add(ResourceUtils.getMessage((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"CALCULATE_PERIOD_NOT_NULL"));
                }
                if (rowSet.getInt("FBillStatus") == 2 || rowSet.getInt("FBillStatus") == 3) continue;
                errMsgList.add(ResourceUtils.getMessage((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"CANNOT_SUBMIT_BILL_STATUS_NOT_SAVA_OR_SUBMIT"));
            }
            checkNullSql = "select FParentId, FSeq, FAuxOverheadId, FConsumeCostCenterId, isNull(FQty, 0) as FQty from T_NCM_InnerOverheadBillEntry where FParentId in (" + NCMUtils.generateQuestionMark((int)size) + ") and (FAuxOverheadId is null or FConsumeCostCenterId is null or FQty is null or FQty <= 0)";
            rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)checkNullSql, (Object[])ids);
            while (rowSet.next()) {
                id = rowSet.getString("FParentId");
                String seq = rowSet.getString("FSeq");
                errMsgList = report.get(id);
                if (errMsgList == null) {
                    errMsgList = new ArrayList<String>();
                    report.put(id, errMsgList);
                }
                if (rowSet.getObject("FAuxOverheadId") == null) {
                    errMsgList.add(ResourceUtils.getMessage((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"ENTRY_AUX_OVERHEAD_NOT_NULL", (String[])new String[]{seq}));
                }
                if (rowSet.getObject("FConsumeCostCenterId") == null) {
                    errMsgList.add(ResourceUtils.getMessage((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"ENTRY_CONSUME_COST_CENTER_NOT_NULL", (String[])new String[]{seq}));
                }
                if (BigDecimal.ZERO.compareTo(rowSet.getBigDecimal("FQty")) < 0) continue;
                errMsgList.add(ResourceUtils.getMessage((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"ENTRY_QTY_NEED_GEN_ZERO", (String[])new String[]{seq}));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkBizInfo4Submit(Context ctx, Object[] ids, Map<String, List<String>> report) throws EASBizException, BOSException {
        List<String> errMsgList;
        String seq;
        String id;
        if (ids == null || ids.length == 0) {
            return;
        }
        int size = ids.length;
        StringBuilder checkSql = new StringBuilder();
        checkSql.append("select bill.FId, entry.FSeq from ").append(this.getMainTableName(ctx, null)).append(" bill \r\n").append("inner join T_NCM_InnerOverheadBillEntry entry on entry.FParentId = bill.FId \r\n").append("where bill.FId in (").append(NCMUtils.generateQuestionMark((int)size)).append(") \r\n").append("and bill.FCostCenterId = entry.FConsumeCostCenterId \r\n").append("and entry.FConsumeCostObjectId is null \r\n");
        IRowSet rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])ids);
        try {
            while (rowSet.next()) {
                id = rowSet.getString("FId");
                seq = rowSet.getString("FSeq");
                errMsgList = report.get(id);
                if (errMsgList == null) {
                    errMsgList = new ArrayList<String>();
                    report.put(id, errMsgList);
                }
                errMsgList.add(ResourceUtils.getMessage((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"ENTRY_IOB_SAME_COST_CENTER_NEED_COST_OBJ", (String[])new String[]{seq}));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        checkSql.setLength(0);
        checkSql.append("select entry.FParentId, entry.FSeq from T_NCM_InnerOverheadBillEntry entry \r\n").append("inner join T_BD_CostObject co on entry.FConsumeCostObjectId = co.FId \r\n").append("inner join T_BD_CostObjectEntry coe on coe.FParentId = co.FId \r\n").append("inner join T_NCM_AUXOverhead aux on aux.FId = coe.FRelatedId \r\n").append("where entry.FParentId in (").append(NCMUtils.generateQuestionMark((int)size)).append(") \r\n").append("and entry.FConsumeCostObjectId is not null \r\n").append("and aux.FId = entry.FAUXOverheadId \r\n").append("group by entry.FParentId, entry.FSeq \r\n");
        rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])ids);
        try {
            while (rowSet.next()) {
                id = rowSet.getString("FId");
                seq = rowSet.getString("FSeq");
                errMsgList = report.get(id);
                if (errMsgList == null) {
                    errMsgList = new ArrayList<String>();
                    report.put(id, errMsgList);
                }
                errMsgList.add(ResourceUtils.getMessage((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"ENTRY_IOB_CANNOT_SAME_COST_CENTER", (String[])new String[]{seq}));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        checkSql.setLength(0);
        checkSql.append("select top 1 aux.FName_").append(ctx.getLocale()).append(" as auxOverheadName, \r\n").append("costCenter.FName_").append(ctx.getLocale()).append(" as costCenterName \r\n").append("from T_NCM_InnerOverheadBill bill \r\n").append("inner join T_NCM_InnerOverheadBillEntry entry on entry.FParentId = bill.FId \r\n").append("inner join T_NCM_AUXOverhead aux on aux.FId = entry.FAuxOverheadId \r\n").append("inner join T_NCM_AUXOverheadCompanyInfo auxCompany on auxCompany.FAuxOverHeadId = aux.FId \r\n").append("inner join T_ORG_CostCenter costCenter on costCenter.FId = auxCompany.FCostCenterId \r\n").append("where bill.FId in (").append(NCMUtils.generateQuestionMark((int)size)).append(") \r\n").append("and bill.FCostCenterId <> costCenter.FId \r\n").append("and auxCompany.FCompanyId = bill.FCompanyOrg \r\n");
        rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])ids);
        try {
            while (rowSet.next()) {
                id = rowSet.getString("FId");
                errMsgList = report.get(id);
                if (errMsgList == null) {
                    errMsgList = new ArrayList<String>();
                    report.put(id, errMsgList);
                }
                errMsgList.add(ResourceUtils.getMessage((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"IOB_OVERHEAD_TO_COST_CENTER", (String[])new String[]{rowSet.getString("auxOverheadName"), rowSet.getString("costCenterName")}));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        checkSql.setLength(0);
    }

    private void clearField4Submit(Context ctx, Object[] ids) throws BOSException {
        if (ids == null || ids.length == 0) {
            return;
        }
        int size = ids.length;
        String clearFieldSql = "update T_NCM_InnerOverheadBillEntry set FMaterialId = null where FConsumeCostObjectId is null and FParentId in (" + NCMUtils.generateQuestionMark((int)size) + ")";
        NCMDbUtil.execute((Context)ctx, (String)clearFieldSql, (Object[])ids);
    }
}

