/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.control.ProductionOrderFacadeFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderFacadeFactory;
import com.kingdee.eas.ncm.bill.ImportBillTypeEnum;
import com.kingdee.eas.ncm.bill.InputQtyBillEntryInfo;
import com.kingdee.eas.ncm.bill.InputQtyBillFactory;
import com.kingdee.eas.ncm.bill.InputQtyBillInfo;
import com.kingdee.eas.ncm.bill.InputQtyImportTypeEnum;
import com.kingdee.eas.ncm.bill.app.AbstractInputQtyBillControllerBean;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InputQtyBillControllerBean
extends AbstractInputQtyBillControllerBean {
    private static Logger logger = Logger.getLogger(InputQtyBillControllerBean.class);
    protected static final char CLF = '\n';
    boolean flag = false;
    public String TblOrderQty = null;
    public String TblPrOrderQty = null;
    private String CollectTblName = null;
    private String forbidenCostObjects = null;

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_INPUTQTYBILL";
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InputQtyBillInfo info = (InputQtyBillInfo)model;
        info.setImportType(InputQtyImportTypeEnum.manual);
        return super._save(ctx, model);
    }

    @Override
    protected boolean _IntPutImport(Context ctx, boolean isReOver, String companyId, ImportBillTypeEnum billType, PeriodInfo period) throws BOSException, EASBizException {
        boolean result = false;
        StringBuffer strSQL1 = new StringBuffer();
        strSQL1.append("select  DISTINCT PARENT.FID AS PARENTID,PARENT.Fnumber AS  FNumber, ENTRY.FCostCenterOrgUnitID AS CostCenterOrgUnitID,PARENT.FBIZDATE   ").append("FROM T_IM_ManufactureRecBill AS  PARENT                            ").append(" INNER JOIN T_SCM_TransactionType TRANSTYPE ").append(" ON PARENT.FTransactionTypeID = TRANSTYPE.FID and TRANSTYPE.FIsManuCostCalculate = 1").append(" LEFT OUTER JOIN T_IM_ManufactureRecBillEntry AS  ENTRY ").append(" ON  PARENT .FID =  ENTRY .FParentID ").append(" INNER JOIN T_IM_InvUpdateType ut on ENTRY.FINVUPDATETYPEID = ut.fid ").append('\n').append(" INNER JOIN T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n').append(" INNER JOIN T_ORG_CostCenter AS  CC ").append(" ON  ENTRY.FCostCenterOrgUnitID =  CC .FID ").append(" LEFT OUTER JOIN T_BD_Period AS  YEARPERIOD ").append(" ON ( PARENT .FYear =  YEARPERIOD .FPeriodYear AND  PARENT .FPeriod =  YEARPERIOD .FPeriodNumber) ").append(" Where  ENTRY.FCompanyOrgUnitID ='").append(companyId).append("'").append("And  CC.FCostCenterType = 0 And YEARPERIOD .FID = '").append(period.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL1.toString());
        try {
            if (rs != null && rs.next()) {
                result = true;
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql1 execute exception : " + exc);
        }
        if (!result) {
            return result;
        }
        this.reNewData(ctx, companyId, period.getId().toString());
        return true;
    }

    private void reNewData(Context ctx, String companyId, String periodId) throws BOSException, EASBizException {
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
        this._clearPreviousData(ctx, companyId, periodId);
        String insertBillSQL = " insert into T_NCM_InputQtyBill ( FID,  \t\t\t\t\t\t\t\t  FSourceBillID, \t\t\t\t\t\t\t\t  FNumber, \t\t\t\t\t\t\t\t  FIsImport, \t\t\t\t\t\t\t\t  FCalculatePeriod, \t\t\t\t\t\t\t\t  FBillStatus, \t\t\t\t\t\t\t\t  FCostCenterOrgUnitID, \t\t\t\t\t\t\t\t  FCompanyOrg, \t\t\t\t\t\t\t\t  FControlUnitID, \t\t\t\t\t\t\t\t  FBIZDATE, \t\t\t\t\t\t\t\t  FCreateTime, \t\t\t\t\t\t\t\t  FCreatorID  \t\t\t\t \t\t\t\t  )          select newbosid('B2B2D2CC'),                 recBillData.ParentID,                 recBillData.FNumber,                 1,                 ?,                 3,                 recBillData.CostCenterOrgUnitID,                 ?,                 ?,                 recBillData.FBizDate,                 GetDate(),                 ?            from                  ( select distinct recBill.FID as ParentID,                                   recBill.Fnumber as FNumber, \t\t\t\t\t\t           recBillEntry.FCostCenterOrgUnitID as CostCenterOrgUnitID, \t\t\t\t\t\t           recBill.FBIZDATE \t\t\t\t     from T_IM_ManufactureRecBill recBill \t\t\t\t\t\t  inner join T_SCM_TransactionType transType\t\t\t\t\t\t\t on ( recBill.FTransactionTypeID = transType.FID \t\t\t\t\t\t\t     and transType.FIsManuCostCalculate = 1) \t\t\t\t\t\t  left outer JOIN T_IM_ManufactureRecBillEntry recBillEntry \t\t\t\t\t\t\t on recBill.FID = recBillEntry.FParentID \t \t\t\t\t\t\t\tinner join T_IM_InvUpdateType ut on recBillEntry.FINVUPDATETYPEID = ut.fid \t \t\t\t\t\t\t\tinner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 \t\t\t\t\t\t  INNER JOIN T_ORG_CostCenter CC \t\t\t\t\t\t\t recBillEntry.FCostCenterOrgUnitID = CC.FID \t\t\t\t\t\t  left outer join T_BD_Period period\t\t\t\t\t\t\t on ( recBill.FYear =  period.FPeriodYear  \t\t\t\t\t\t\t      and recBill.FPeriod =  period.FPeriodNumber) \t\t            where recBillEntry.FCostCenterOrgUnitID is not null \t\t\t          and recBill.FBaseStatus = 4 \t\t\t          and CC.FCostCenterType = 0 \t\t\t\t\t  and recBillEntry.FCompanyOrgUnitID = ? \t\t\t\t\t  and period.FID = ?                    ) recBillData ";
        String insertEntrySQL = " insert into T_NCM_InputQtyBillEntry    (FID, FSeq, FCostObjectID, FIsImport, FQty, FParentID)    select newbosid('E65D2506'),           0,           CostObject.FID,           1,           SUM(ISNULL(FBaseQty,0) * ISNULL(FQuotiety,1)),           inputBill.FID      from T_IM_ManufactureRecBillEntry recBillEntry     inner join T_NCM_InputQtyBill inputBill            on recBillEntry.FParentID = inputBill.FSourceBillID     inner join T_BD_CostObjectEntry costObjectEntry            on recBillEntry.FMaterialID = costObjectEntry.FRelatedID     inner join T_BD_CostObject costObject            on inputBill.FCompanyOrg = CostObject.FCompanyID           and costObject.FID = costObjectEntry.FParentID     where inputBill.FIsImport = 1 and recBillEntry.FCompanyOrgUnitID = ?       and inputBill.FCompanyOrg = ?       and inputBill.FCalculatePeriod = ?       and costObject.FCompanyID = ?       and costObject.FIsForbiden = 0 \t\t\t   and \n\t\t\t   ( \n\t\t\t       (costobject.FCalculateMode = 4 and Isnull(recBillEntry.FLot,' ') = Isnull(costobject.FBatchNumber,' ')) \n\t\t\t       or \n\t\t\t       (costobject.FCalculateMode = 7 and costobject.FOrderID = recBillEntry.FManuBillID) \n\t\t\t\t   or \n\t\t\t\t   (costobject.FCalculateMode in (1, 3)) \n\t\t\t   )\n    group by inputBill.FID, CostObject.FID ";
        Connection conn = null;
        PreparedStatement psBill = null;
        PreparedStatement psEntry = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            psBill = conn.prepareStatement(" insert into T_NCM_InputQtyBill ( FID,  \t\t\t\t\t\t\t\t  FSourceBillID, \t\t\t\t\t\t\t\t  FNumber, \t\t\t\t\t\t\t\t  FIsImport, \t\t\t\t\t\t\t\t  FCalculatePeriod, \t\t\t\t\t\t\t\t  FBillStatus, \t\t\t\t\t\t\t\t  FCostCenterOrgUnitID, \t\t\t\t\t\t\t\t  FCompanyOrg, \t\t\t\t\t\t\t\t  FControlUnitID, \t\t\t\t\t\t\t\t  FBIZDATE, \t\t\t\t\t\t\t\t  FCreateTime, \t\t\t\t\t\t\t\t  FCreatorID  \t\t\t\t \t\t\t\t  )          select newbosid('B2B2D2CC'),                 recBillData.ParentID,                 recBillData.FNumber,                 1,                 ?,                 3,                 recBillData.CostCenterOrgUnitID,                 ?,                 ?,                 recBillData.FBizDate,                 GetDate(),                 ?            from                  ( select distinct recBill.FID as ParentID,                                   recBill.Fnumber as FNumber, \t\t\t\t\t\t           recBillEntry.FCostCenterOrgUnitID as CostCenterOrgUnitID, \t\t\t\t\t\t           recBill.FBIZDATE \t\t\t\t     from T_IM_ManufactureRecBill recBill \t\t\t\t\t\t  inner join T_SCM_TransactionType transType\t\t\t\t\t\t\t on ( recBill.FTransactionTypeID = transType.FID \t\t\t\t\t\t\t     and transType.FIsManuCostCalculate = 1) \t\t\t\t\t\t  left outer JOIN T_IM_ManufactureRecBillEntry recBillEntry \t\t\t\t\t\t\t on recBill.FID = recBillEntry.FParentID \t \t\t\t\t\t\t\tinner join T_IM_InvUpdateType ut on recBillEntry.FINVUPDATETYPEID = ut.fid \t \t\t\t\t\t\t\tinner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 \t\t\t\t\t\t  INNER JOIN T_ORG_CostCenter CC \t\t\t\t\t\t\t recBillEntry.FCostCenterOrgUnitID = CC.FID \t\t\t\t\t\t  left outer join T_BD_Period period\t\t\t\t\t\t\t on ( recBill.FYear =  period.FPeriodYear  \t\t\t\t\t\t\t      and recBill.FPeriod =  period.FPeriodNumber) \t\t            where recBillEntry.FCostCenterOrgUnitID is not null \t\t\t          and recBill.FBaseStatus = 4 \t\t\t          and CC.FCostCenterType = 0 \t\t\t\t\t  and recBillEntry.FCompanyOrgUnitID = ? \t\t\t\t\t  and period.FID = ?                    ) recBillData ");
            psBill.setString(1, periodId);
            psBill.setString(2, companyId);
            psBill.setString(3, DefaultCU.getId().toString());
            psBill.setString(4, UserInfo2.getId().toString());
            psBill.setString(5, companyId);
            psBill.setString(6, periodId);
            psBill.executeUpdate();
            psEntry = conn.prepareStatement(" insert into T_NCM_InputQtyBillEntry    (FID, FSeq, FCostObjectID, FIsImport, FQty, FParentID)    select newbosid('E65D2506'),           0,           CostObject.FID,           1,           SUM(ISNULL(FBaseQty,0) * ISNULL(FQuotiety,1)),           inputBill.FID      from T_IM_ManufactureRecBillEntry recBillEntry     inner join T_NCM_InputQtyBill inputBill            on recBillEntry.FParentID = inputBill.FSourceBillID     inner join T_BD_CostObjectEntry costObjectEntry            on recBillEntry.FMaterialID = costObjectEntry.FRelatedID     inner join T_BD_CostObject costObject            on inputBill.FCompanyOrg = CostObject.FCompanyID           and costObject.FID = costObjectEntry.FParentID     where inputBill.FIsImport = 1 and recBillEntry.FCompanyOrgUnitID = ?       and inputBill.FCompanyOrg = ?       and inputBill.FCalculatePeriod = ?       and costObject.FCompanyID = ?       and costObject.FIsForbiden = 0 \t\t\t   and \n\t\t\t   ( \n\t\t\t       (costobject.FCalculateMode = 4 and Isnull(recBillEntry.FLot,' ') = Isnull(costobject.FBatchNumber,' ')) \n\t\t\t       or \n\t\t\t       (costobject.FCalculateMode = 7 and costobject.FOrderID = recBillEntry.FManuBillID) \n\t\t\t\t   or \n\t\t\t\t   (costobject.FCalculateMode in (1, 3)) \n\t\t\t   )\n    group by inputBill.FID, CostObject.FID ");
            psEntry.setString(1, companyId);
            psEntry.setString(2, companyId);
            psEntry.setString(3, periodId);
            psEntry.setString(4, companyId);
            psEntry.executeUpdate();
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psBill);
                SQLUtils.cleanup(psEntry);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psBill);
        SQLUtils.cleanup((Statement)psEntry);
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    protected void _clearPreviousData(Context ctx, String CompanyId, String periodId) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        Object[] params = new Object[]{CompanyId, periodId};
        strSQL.append("Delete From T_NCM_INPUTQTYBILLEntry Where FparentId in ").append(" \r\n").append("\t\t(Select FId From T_NCM_INPUTQTYBILL  ").append(" \r\n").append(" Where FIsImport = 1 And FCompanyOrg = ? And FCalculatePeriod = ?  )");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_INPUTQTYBILL ").append(" Where FIsImport = 1 And FCompanyOrg = ? And FCalculatePeriod = ? ");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
    }

    @Override
    protected Map _getMatModelAndPrecision(Context ctx, String matId) throws BOSException, EASBizException {
        String model = "";
        Integer precision = 2;
        MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(matId));
        if (materialInfo != null) {
            MultiMeasureUnitInfo multiUnitInfo;
            if (materialInfo.getModel() != null) {
                model = materialInfo.getModel();
            }
            if (materialInfo.getBaseUnit() != null && (multiUnitInfo = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialInfo.getId().toString(), materialInfo.getBaseUnit().getId().toString())) != null) {
                precision = multiUnitInfo.getQtyPrecision();
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("model", model);
        result.put("precision", precision);
        return result;
    }

    @Override
    protected Map _getMatMultUnitPrecition(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        MaterialCollection materialColl = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        if (materialColl != null && materialColl.size() > 0) {
            HashMap<String, String> param = new HashMap<String, String>();
            MaterialInfo materialInfo = null;
            for (int i = 0; i < materialColl.size(); ++i) {
                materialInfo = materialColl.get(i);
                if (materialInfo.getBaseUnit() == null) continue;
                param.put(materialInfo.getId().toString(), materialInfo.getBaseUnit().getId().toString());
            }
            if (param.size() > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("select FMaterialID, FQtyPrecision from T_BD_MultiMeasureUnit where ");
                Iterator it = param.entrySet().iterator();
                Object materialId = null;
                Object matMultUnitId = null;
                while (it.hasNext()) {
                    Map.Entry temp = it.next();
                    sb.append("(FMaterialID='").append((String)temp.getKey()).append("' and FMeasureUnitID='").append((String)temp.getValue()).append("')");
                    if (!it.hasNext()) continue;
                    sb.append(" or ");
                }
                IRowSet _Data = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (_Data != null && _Data.size() > 0) {
                    try {
                        _Data.first();
                        while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                            result.put(_Data.getString("FMaterialID"), Long.valueOf(_Data.getInt("FQtyPrecision")));
                            _Data.next();
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected String _intPutImportCount(Context ctx, boolean isReOver, String companyId, PeriodInfo period, Object[][] costData, int count) throws BOSException, EASBizException {
        this.checkIfCodingRuleExsit(ctx, companyId);
        try {
            this.isValidForImport(ctx, companyId, period, costData, count);
            this.importManufactureSpetial(ctx, companyId, period, costData, count, isReOver);
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            if (this.CollectTblName != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(this.CollectTblName);
            }
        }
        return "Success," + this.forbidenCostObjects;
    }

    private boolean isValidForImport(Context ctx, String companyId, PeriodInfo period, Object[][] costData, int count) throws BOSException, EASBizException {
        boolean result = false;
        this.createTempTable(ctx, companyId, period.getId().toString(), costData, count);
        this.forbidenCostObjects = this.checkCostObjIsForbiden(ctx);
        StringBuffer strSQL1 = new StringBuffer();
        strSQL1.append(" select FCostCenterOrgUnitID,FCostObjectID,sum(FQty),FBeginDate ");
        strSQL1.append(" from  ").append(this.CollectTblName).append(" as collectTbl");
        if (count > 0) {
            strSQL1.append(" where ( 1<>1");
        }
        for (int i = 0; i < count; ++i) {
            String costCenterID = null;
            String costObject = null;
            if (costData[i][0] != null) {
                costCenterID = costData[i][0].toString();
            }
            if (costData[i][1] != null) {
                costObject = costData[i][1].toString();
            }
            if (costCenterID != null && costCenterID.length() != 0) {
                strSQL1.append(" or (collectTbl.FCostCenterOrgUnitID = '" + costCenterID + "'");
                if (costObject != null && costObject.length() != 0) {
                    strSQL1.append(" and collectTbl.FCostObjectID ='" + costObject + "' ");
                }
                strSQL1.append(" )");
                continue;
            }
            if (costObject == null || costObject.length() == 0) continue;
            strSQL1.append(" or ( collectTbl.FCostObjectID ='" + costObject + "' )");
        }
        if (count > 0) {
            strSQL1.append(" )");
        }
        strSQL1.append(" group by FCostCenterOrgUnitID,FCostObjectID,FBeginDate");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL1.toString());
        try {
            if (rs != null && rs.next()) {
                result = true;
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql1 execute exception : " + exc);
        }
        if (!result) {
            return result;
        }
        return true;
    }

    private void executeImportManufactureSpetialSql(Context ctx, String companyId, PeriodInfo period, Object[][] costData, int count) throws BOSException, EASBizException {
        String costObject;
        String costCenterID;
        int i;
        String tblBalance = null;
        String DateTblName = null;
        UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String beginDate = sf.format(period.getBeginDate());
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            StringBuffer createDateTableSql = new StringBuffer();
            createDateTableSql.append(" create table T_NCM_DateTable( \n");
            createDateTableSql.append("     FCostCenterOrgUnitID varchar(44), \n");
            createDateTableSql.append("     FCostObjectID varchar(44), \n");
            createDateTableSql.append("     FQty decimal(21,8), \n");
            createDateTableSql.append("     FBeginDate DateTime \n");
            createDateTableSql.append(") \n");
            DateTblName = pool.createTempTable(createDateTableSql.toString());
            tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(DateTblName).append(" (FCostCenterOrgUnitID,FCostObjectID,FQty,FBeginDate) \n");
        sql.append(" select DISTINCT case \n");
        sql.append("                   when CollectTbl.FCostCenterOrgUnitID is null ");
        sql.append("                       then wipcounting.FCostCenterID ");
        sql.append("                   else CollectTbl.FCostCenterOrgUnitID end \n");
        sql.append(" ,               case \n");
        sql.append("                   when CollectTbl.FCostObjectID is null ");
        sql.append("                       then wipcounting.FCostObjectID ");
        sql.append("                   else CollectTbl.FCostObjectID end \n");
        sql.append("   ,sum(isnull(CollectTbl.FQty,0))+isnull(wipcounting.fqty,0)-max(isnull(s.FBOPWIPQTY,0)),to_date('" + beginDate + "') ");
        sql.append(" from  ").append(this.CollectTblName).append(" as CollectTbl ");
        sql.append("   full JOIN (select * from t_ncm_wipcountingbill where  fcalculateperiod = '" + period.getId().toString() + "' and fcompanyOrg = '" + companyId + "') as wipcounting  ");
        sql.append("   on wipcounting.FCostCenterID = CollectTbl.FCostCenterOrgUnitID  ");
        sql.append("   and wipcounting.FCostObjectID = CollectTbl.FCostObjectID  ");
        sql.append("   and CollectTbl.FCompanyorgunitID=wipcounting.fcompanyOrg ");
        sql.append("   full JOIN " + tblBalance + " AS s  ");
        sql.append("   ON (s.fcostcenterid = CollectTbl.fcostcenterorgunitid       and s.fcostobjectid = CollectTbl.fcostobjectid ");
        sql.append("   and CollectTbl.FCompanyorgunitID=s.fcompanyorg");
        sql.append("   and CollectTbl.FPeriodID=s.fcalculateperiodid) ");
        sql.append("   OR (s.fcostcenterid = wipcounting.FCostCenterID       and s.fcostobjectid = wipcounting.FCostObjectID ");
        sql.append("   and wipcounting.fcompanyOrg=s.fcompanyorg");
        sql.append("   and wipcounting.fcalculateperiod=s.fcalculateperiodid) ");
        sql.append(" where (CollectTbl.FCostCenterOrgUnitID is not null or wipcounting.fid is not null ");
        sql.append("   and (CollectTbl.FQty <> 0 or wipcounting.fqty <> 0 or s.FBOPWIPQTY <> 0))");
        if (count > 0) {
            sql.append("  and (1<>1 ");
        }
        for (int i2 = 0; i2 < count; ++i2) {
            String costCenterID2 = null;
            String costObject2 = null;
            if (costData[i2][0] != null) {
                costCenterID2 = costData[i2][0].toString();
            }
            if (costData[i2][1] != null) {
                costObject2 = costData[i2][1].toString();
            }
            if (costCenterID2 != null && costCenterID2.length() != 0) {
                sql.append("or (  CollectTbl.FCostCenterOrgUnitID = '" + costCenterID2 + "'");
                if (costObject2 != null && costObject2.length() != 0) {
                    sql.append(" And CollectTbl.FCostObjectID  ='" + costObject2 + "' )");
                } else {
                    sql.append(" )");
                }
            } else if (costObject2 != null && costObject2.length() != 0) {
                sql.append(" or ( CollectTbl.FCostObjectID  ='" + costObject2 + "' )");
            }
            if (costCenterID2 != null && costCenterID2.length() != 0) {
                sql.append("or (  wipcounting.FCostCenterID = '" + costCenterID2 + "'");
                if (costObject2 != null && costObject2.length() != 0) {
                    sql.append(" And wipcounting.FCostObjectID  ='" + costObject2 + "' )");
                } else {
                    sql.append(" )");
                }
            } else if (costObject2 != null && costObject2.length() != 0) {
                sql.append(" or ( wipcounting.FCostObjectID  ='" + costObject2 + "' )");
            }
            if (costCenterID2 != null && costCenterID2.length() != 0) {
                sql.append("or (  s.FCostCenterID = '" + costCenterID2 + "'");
                if (costObject2 != null && costObject2.length() != 0) {
                    sql.append(" And s.FCostObjectID  ='" + costObject2 + "' )");
                    continue;
                }
                sql.append(" )");
                continue;
            }
            if (costObject2 == null || costObject2.length() == 0) continue;
            sql.append(" or ( s.FCostObjectID  ='" + costObject2 + "' )");
        }
        if (count > 0) {
            sql.append(" )");
        }
        sql.append(" group by CollectTbl.FCostCenterOrgUnitID,wipcounting.FCostCenterID,CollectTbl.FCostObjectID,wipcounting.FCostObjectID,CollectTbl.FBeginDate,wipcounting.fqty");
        sql.append(" having (sum(isnull(CollectTbl.FQty,0))+isnull(wipcounting.fqty,0)-max(isnull(s.FBOPWIPQTY,0))) > 0");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer sqlInfo = new StringBuffer();
        StringBuffer sqlEntry = new StringBuffer();
        sqlInfo.append("insert into T_NCM_InputQtyBill ( ");
        sqlInfo.append(" FID,FCreateTime,FCreatorID,FLastUpdateTime,FLastUpdateUserID,FAuditTime,FAuditorID,FSourceBillID,FIsImport,FCalculatePeriod,FBillStatus,FCostCenterOrgUnitID,FCompanyOrg,FControlunitID,FBIZDATE)");
        sqlInfo.append(" select newbosid('B2B2D2CC'),GetDate(),?,GetDate(),?,GetDate(),?,null,1,?,4,CollectTbl.FCostCenterOrgUnitID,?,?,CollectTbl.FBeginDate");
        sqlInfo.append("        from ").append(DateTblName).append(" as CollectTbl ");
        if (count > 0) {
            sqlInfo.append(" where (1<>1 ");
        }
        for (i = 0; i < count; ++i) {
            costCenterID = null;
            costObject = null;
            if (costData[i][0] != null) {
                costCenterID = costData[i][0].toString();
            }
            if (costData[i][1] != null) {
                costObject = costData[i][1].toString();
            }
            if (costCenterID != null && costCenterID.length() != 0) {
                sqlInfo.append("or (  CollectTbl.FCostCenterOrgUnitID = '" + costCenterID + "'");
                if (costObject != null && costObject.length() != 0) {
                    sqlInfo.append(" And CollectTbl.FCostObjectID  ='" + costObject + "' )");
                    continue;
                }
                sqlInfo.append(" )");
                continue;
            }
            if (costObject == null || costObject.length() == 0) continue;
            sqlInfo.append(" or ( CollectTbl.FCostObjectID  ='" + costObject + "' )");
        }
        if (count > 0) {
            sqlInfo.append(" )");
        }
        sqlInfo.append(" group by FCostCenterOrgUnitID,FBeginDate");
        sqlEntry.append("insert into T_NCM_InputQtyBillEntry ( ");
        sqlEntry.append(" FID, FSeq, FCostObjectID, FIsImport, FQty, FParentID)");
        sqlEntry.append(" select newbosid('E65D2506'),0,CollectTbl.FCostObjectID,1,sum(CollectTbl.FQty),inputBill.FID");
        sqlEntry.append("        from ").append(DateTblName).append(" as CollectTbl ");
        sqlEntry.append("  inner join ").append("T_BD_CostObject").append(" as co ");
        sqlEntry.append("        on co.fid = CollectTbl.FCostObjectID ");
        sqlEntry.append("  inner join ").append("T_BD_material").append(" as ma ");
        sqlEntry.append("        on co.fstdproductidid = ma.FID ");
        sqlEntry.append("  inner join ").append("t_bd_multimeasureunit").append(" as unit ");
        sqlEntry.append("        on unit.fmaterialid = ma.FID and unit.Fmeasureunitid = ma.Fbaseunit ");
        sqlEntry.append("  inner join ").append("T_NCM_InputQtyBill").append(" as inputBill ");
        sqlEntry.append("        on CollectTbl.FCostCenterOrgUnitID = inputBill.FCostCenterOrgUnitID and inputBill.FIsImport = 1 and inputBill.FCompanyOrg = ? and inputBill.FCalculatePeriod = ? ");
        sqlEntry.append("  left join ").append("T_NCM_InputQtyBillentry").append(" as entry ");
        sqlEntry.append("        on inputBill.Fid = entry.Fparentid ");
        sqlEntry.append(" where entry.Fid is null \n");
        if (count > 0) {
            sqlEntry.append(" and (1<>1 ");
        }
        for (i = 0; i < count; ++i) {
            costCenterID = null;
            costObject = null;
            if (costData[i][0] != null) {
                costCenterID = costData[i][0].toString();
            }
            if (costData[i][1] != null) {
                costObject = costData[i][1].toString();
            }
            if (costCenterID != null && costCenterID.length() != 0) {
                sqlEntry.append("or (  CollectTbl.FCostCenterOrgUnitID = '" + costCenterID + "'");
                if (costObject != null && costObject.length() != 0) {
                    sqlEntry.append(" And CollectTbl.FCostObjectID  ='" + costObject + "' )");
                    continue;
                }
                sqlEntry.append(" )");
                continue;
            }
            if (costObject == null || costObject.length() == 0) continue;
            sqlEntry.append(" or ( CollectTbl.FCostObjectID  ='" + costObject + "' )");
        }
        if (count > 0) {
            sqlEntry.append(" )");
        }
        sqlEntry.append("  group by CollectTbl.FCostObjectID,inputBill.FID");
        Connection conn = null;
        PreparedStatement psBill = null;
        PreparedStatement psEntry = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            psBill = conn.prepareStatement(sqlInfo.toString());
            psBill.setString(1, UserInfo2.getId().toString());
            psBill.setString(2, UserInfo2.getId().toString());
            psBill.setString(3, UserInfo2.getId().toString());
            psBill.setString(4, period.getId().toString());
            psBill.setString(5, companyId);
            psBill.setString(6, cu.getId().toString());
            psBill.executeUpdate();
            this.getNumber(ctx, companyId, period.getId().toString());
            psEntry = conn.prepareStatement(sqlEntry.toString());
            psEntry.setString(1, companyId);
            psEntry.setString(2, period.getId().toString());
            psEntry.executeUpdate();
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psBill);
                SQLUtils.cleanup(psEntry);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psBill);
        SQLUtils.cleanup((Statement)psEntry);
        SQLUtils.cleanup((Connection)conn);
    }

    private void importManufactureSpetial(Context ctx, String companyId, PeriodInfo period, Object[][] costData, int count, boolean isReOver) throws BOSException, EASBizException {
        if (isReOver) {
            this._clearPreviousData(ctx, companyId, period.getId().toString(), costData, count);
        }
        this.executeImportManufactureSpetialSql(ctx, companyId, period, costData, count);
    }

    @Override
    protected String _IntPutImport(Context ctx, boolean isReOver, String companyId, PeriodInfo period, Object[][] costData, int count) throws BOSException, EASBizException {
        block7: {
            this.checkIfCodingRuleExsit(ctx, companyId);
            try {
                boolean bool = this.isValidForImport(ctx, companyId, period, costData, count);
                if (bool) {
                    this.importManufactureCommon(ctx, companyId, period, costData, count, isReOver);
                    break block7;
                }
                String string = "Failure";
                return string;
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            finally {
                if (this.CollectTblName != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(this.CollectTblName);
                }
            }
        }
        return "Success," + this.forbidenCostObjects;
    }

    @Override
    protected String _inputImportOrderQty(Context ctx, boolean isReOver, String companyId, PeriodInfo period, Object[][] costData, int count, String sign) throws BOSException, EASBizException {
        block9: {
            this.checkIfCodingRuleExsit(ctx, companyId);
            try {
                boolean bool = this.isValidForImportByOrderQty(ctx, companyId, period, costData, count, sign);
                if (bool) {
                    this.importManufactureOrderQty(ctx, companyId, period, costData, count, isReOver, sign);
                    if (!this.flag) {
                        String string = "Failure";
                        return string;
                    }
                    break block9;
                }
                String string = "Failure";
                return string;
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            finally {
                if (this.TblOrderQty != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(this.TblOrderQty);
                }
            }
        }
        return "Success," + this.forbidenCostObjects;
    }

    private void importManufactureOrderQty(Context ctx, String companyId, PeriodInfo period, Object[][] costData, int count, boolean isReOver, String sign) throws BOSException, EASBizException {
        if (isReOver) {
            this._clearPreviousDataByOrderData(ctx, companyId, period.getId().toString(), costData, count);
        }
        if (sign.equals("Three")) {
            this.executeImportanufactureOrderQtySql(ctx, companyId, period, costData, count);
        }
        if (sign.equals("Five")) {
            this.executeImportPrOrderQtySql(ctx, companyId, period, costData, count);
        }
    }

    private void executeImportPrOrderQtySql(Context ctx, String companyId, PeriodInfo period, Object[][] costData, int count) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        IRowSet rowSet = null;
        sql.append(" select distinct toq.FCompanyOrg,toq.FCalculatePeriod,toq.FManufactureOrderID,toq.FCostCenterID,toq.FCostObjectID,toq.FQty,period.FBeginDate,ord.Fnumber from ").append(this.TblPrOrderQty).append(" toq ").append(" LEFT OUTER JOIN t_bd_period period on toq.FCalculatePeriod = period.fid \n").append(" left join T_MM_ProductionOrder ord on ord.FID = toq.FManufactureOrderID \n").append(" where toq.FCostObjectID is not null \n");
        if (count > 0) {
            sql.append(" and (1<>1 ");
        }
        for (int i = 0; i < count; ++i) {
            String costCenterID = null;
            String costObject = null;
            if (costData[i][2] != null) {
                costCenterID = costData[i][2].toString();
            }
            if (costData[i][3] != null) {
                costObject = costData[i][3].toString();
            }
            if (costCenterID != null && costCenterID.length() != 0) {
                sql.append("or (  toq.FCostCenterID = '" + costCenterID + "'");
                if (costObject != null && costObject.length() != 0) {
                    sql.append(" And toq.FCostObjectID  ='" + costObject + "' )");
                    continue;
                }
                sql.append(" )");
                continue;
            }
            if (costObject == null || costObject.length() == 0) continue;
            sql.append(" or ( toq.FCostObjectID  ='" + costObject + "' )");
        }
        if (count > 0) {
            sql.append(" )");
        }
        sql.append(" order by toq.FCostCenterID \n");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        this.addInputQtyBillByRowSetFromPrOrderData(ctx, rowSet, companyId, period);
    }

    private void addInputQtyBillByRowSetFromPrOrderData(Context ctx, IRowSet rowSet, String companyId, PeriodInfo period) throws BOSException, EASBizException {
        try {
            InputQtyBillInfo inputQtyBill = null;
            InputQtyBillEntryInfo inputQtyBillEntry = null;
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            String costCenterID = "";
            while (rowSet.next()) {
                if (!costCenterID.equals(rowSet.getString(4))) {
                    if (costCenterID.length() > 0) {
                        this._addnew(ctx, (IObjectValue)inputQtyBill);
                    }
                    inputQtyBill = new InputQtyBillInfo();
                    costCenterID = rowSet.getString(4) != null ? rowSet.getString(4) : "";
                }
                inputQtyBill.setCompanyOrg(company);
                inputQtyBill.setCalculatePeriod(period);
                inputQtyBill.setBizDate(rowSet.getDate(7));
                inputQtyBill.setBillStatus(BillBaseStatusEnum.AUDITED);
                inputQtyBill.setIsImport(true);
                CostCenterOrgUnitInfo costCenter = new CostCenterOrgUnitInfo();
                if (rowSet.getString(4) != null) {
                    costCenter.setId(BOSUuid.read((String)rowSet.getString(4)));
                }
                inputQtyBill.setCostCenterOrgUnit(costCenter);
                inputQtyBillEntry = new InputQtyBillEntryInfo();
                inputQtyBillEntry.setIsImport(true);
                CostObjectInfo costObject = new CostObjectInfo();
                if (rowSet.getString(5) != null) {
                    costObject.setId(BOSUuid.read((String)rowSet.getString(5)));
                }
                inputQtyBillEntry.setCostObject(costObject);
                inputQtyBillEntry.setQty(new BigDecimal(rowSet.getString(6)).compareTo(new BigDecimal(0)) >= 0 ? new BigDecimal(rowSet.getString(6)) : new BigDecimal(0));
                inputQtyBillEntry.setRemark(rowSet.getString(8));
                inputQtyBill.getEntry().add(inputQtyBillEntry);
            }
            if (inputQtyBill != null) {
                this._addnew(ctx, (IObjectValue)inputQtyBill);
                this.flag = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void executeImportanufactureOrderQtySql(Context ctx, String companyId, PeriodInfo period, Object[][] costData, int count) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        IRowSet rowSet = null;
        sql.append("  select distinct toq.FCompanyOrg,toq.FCalculatePeriod,toq.FManufactureOrderID,toq.FCostCenterID,toq.FCostObjectID,toq.FQty,period.FBeginDate, mmu.FQtyPrecision from ").append(this.TblOrderQty).append(" toq ").append(" LEFT OUTER JOIN t_bd_period period on toq.FCalculatePeriod = period.fid \r\n").append(" LEFT OUTER JOIN t_bd_costObject costObject on toq.FCostObjectID = costObject.FId \n").append(" LEFT OUTER JOIN t_bd_material material on costObject.FSTDPRODUCTIDID = material.FId \n").append(" LEFT OUTER JOIN T_BD_MULTIMEASUREUNIT mmu on mmu.FMaterialID = material.FId and mmu.FMeasureUnitId = material.FBaseUnit \n");
        if (count > 0) {
            sql.append(" where (1<>1 ");
        }
        for (int i = 0; i < count; ++i) {
            String costCenterID = null;
            String costObject = null;
            if (costData[i][2] != null) {
                costCenterID = costData[i][2].toString();
            }
            if (costData[i][3] != null) {
                costObject = costData[i][3].toString();
            }
            if (costCenterID != null && costCenterID.length() != 0) {
                sql.append("or (  toq.FCostCenterID = '" + costCenterID + "'");
                if (costObject != null && costObject.length() != 0) {
                    sql.append(" And toq.FCostObjectID  ='" + costObject + "' )");
                    continue;
                }
                sql.append(" )");
                continue;
            }
            if (costObject == null || costObject.length() == 0) continue;
            sql.append(" or ( toq.FCostObjectID  ='" + costObject + "' )");
        }
        if (count > 0) {
            sql.append(" )");
        }
        sql.append(" order by toq.FCostCenterID \n");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        this.addInputQtyBillByRowSetFromOrderData(ctx, rowSet, companyId, period);
    }

    private void addInputQtyBillByRowSetFromOrderData(Context ctx, IRowSet rowSet, String companyId, PeriodInfo period) throws BOSException, EASBizException {
        try {
            InputQtyBillInfo inputQtyBill = null;
            InputQtyBillEntryInfo inputQtyBillEntry = null;
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            String costCenterID = "";
            while (rowSet.next()) {
                if (!costCenterID.equals(rowSet.getString(4))) {
                    if (costCenterID.length() > 0) {
                        this._addnew(ctx, (IObjectValue)inputQtyBill);
                    }
                    inputQtyBill = new InputQtyBillInfo();
                    costCenterID = rowSet.getString(4) != null ? rowSet.getString(4) : "";
                }
                inputQtyBill.setCompanyOrg(company);
                inputQtyBill.setCalculatePeriod(period);
                inputQtyBill.setBizDate(rowSet.getDate(7));
                inputQtyBill.setBillStatus(BillBaseStatusEnum.AUDITED);
                inputQtyBill.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
                inputQtyBill.setAuditTime(BDCMUtils.DateToTime((Date)BDCMUtils.now()));
                inputQtyBill.setIsImport(true);
                CostCenterOrgUnitInfo costCenter = new CostCenterOrgUnitInfo();
                if (rowSet.getString(4) != null) {
                    costCenter.setId(BOSUuid.read((String)rowSet.getString(4)));
                }
                inputQtyBill.setCostCenterOrgUnit(costCenter);
                inputQtyBillEntry = new InputQtyBillEntryInfo();
                inputQtyBillEntry.setIsImport(true);
                CostObjectInfo costObject = new CostObjectInfo();
                if (StringUtils.isEmpty((String)rowSet.getString(5))) {
                    throw new BOSException("\u5b58\u5728\u6ee1\u8db3\u5bfc\u5165\u6761\u4ef6\u4f46\u6210\u672c\u5bf9\u8c61\u4e3a\u7a7a\u7684\u8ba2\u5355\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (rowSet.getString(5) != null) {
                    costObject.setId(BOSUuid.read((String)rowSet.getString(5)));
                }
                inputQtyBillEntry.setCostObject(costObject);
                BigDecimal inputQty = new BigDecimal(rowSet.getString(6));
                if (inputQty.compareTo(BigDecimal.ZERO) < 0) {
                    inputQty = BigDecimal.ZERO;
                }
                int precision = 2;
                if (rowSet.getObject(8) != null) {
                    precision = rowSet.getInt(8);
                }
                inputQty = inputQty.setScale(precision, 4);
                inputQtyBillEntry.setQty(inputQty);
                inputQtyBillEntry.setManufactureOrder(rowSet.getString(3));
                inputQtyBill.getEntry().add(inputQtyBillEntry);
            }
            if (inputQtyBill != null) {
                this._addnew(ctx, (IObjectValue)inputQtyBill);
                this.flag = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean isValidForImportByOrderQty(Context ctx, String companyId, PeriodInfo period, Object[][] costData, int count, String sign) throws BOSException, EASBizException {
        IRowSet rs;
        StringBuffer selectSql;
        boolean result = false;
        if (sign.equals("Three")) {
            this.createTblOrderQty(ctx, companyId, period, costData, count);
            selectSql = new StringBuffer();
            selectSql.append(" select FCalculatePeriod,FManufactureOrderID,FCostCenterID,FCostObjectID,FQty ").append(" from ").append(this.TblOrderQty).append(" as toq ");
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            try {
                if (rs != null && rs.next()) {
                    result = true;
                }
            }
            catch (SQLException exc) {
                throw new BOSException("Sql1 execute exception : " + exc);
            }
        }
        if (sign.equals("Five")) {
            this.createTblPrOrderQty(ctx, companyId, period, costData, count);
            selectSql = new StringBuffer();
            selectSql.append(" select FCalculatePeriod,FManufactureOrderID,FCostCenterID,FCostObjectID,FQty ").append(" from ").append(this.TblPrOrderQty).append(" as toq where FCostObjectID is not null ");
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            try {
                if (rs != null && rs.next()) {
                    result = true;
                }
            }
            catch (SQLException exc) {
                throw new BOSException("Sql1 execute exception : " + exc);
            }
        }
        if (!result) {
            return result;
        }
        return true;
    }

    private void createTblPrOrderQty(Context ctx, String companyId, PeriodInfo period, Object[][] costData, int count) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" create table T_NCM_PrOrderQtyTable (").append("\tFCompanyOrg varchar(44),").append("\tFCalculatePeriod varchar(44),").append("\tFManufactureOrderID varchar(44),").append("   FManufactureOrderNum varchar(80),").append("\tFCostCenterID varchar(44),").append("\tFMaterialID varchar(44),").append("\tFLot varchar(255),").append("\tFCostObjectID varchar(44),").append("\tFQty decimal(28,10))");
        try {
            this.TblPrOrderQty = pool.createTempTable(createTableSql.toString());
            ProductionOrderFacadeFactory.getLocalInstance((Context)ctx).getPOrderDataByBill(period, costData, this.TblPrOrderQty);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("update " + this.TblPrOrderQty + " \n");
        ksql.append("set FCostObjectID = ( \n");
        ksql.append("    select top 1 FID from T_BD_CostObject co \n");
        ksql.append("    where co.FCompanyID = '" + companyId + "' \n");
        ksql.append("    and co.FIsForbiden = 0 \n");
        ksql.append("    and ( \n");
        ksql.append("        co.FCalculateMode = 7 \n");
        ksql.append("        and co.FOrderID = " + this.TblPrOrderQty + ".FManufactureOrderID \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode in (1, 3) \n");
        ksql.append("        and co.FStdProductIDID = " + this.TblPrOrderQty + ".FMaterialID \n");
        ksql.append("        and co.FCompanyID = '" + companyId + "' \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode = 3 \n");
        ksql.append("        and co.FID in ( \n");
        ksql.append("            select ");
        ksql.append("                coe.FParentID ");
        ksql.append("            from T_BD_CostObjectEntry coe ");
        ksql.append("            where coe.FParentID = co.FID \n");
        ksql.append("            and FRelatedID = " + this.TblPrOrderQty + ".FMaterialID \n");
        ksql.append("            and co.FCompanyID = '" + companyId + "' \n");
        ksql.append("        ) \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode = 4 \n");
        ksql.append("        and co.FStdProductIDID = " + this.TblPrOrderQty + ".FMaterialID \n");
        ksql.append("        and ( \n");
        ksql.append("            co.FBatchNumber = " + this.TblPrOrderQty + ".FLot \n");
        ksql.append("            or \n");
        ksql.append("            co.FBatchNumber is null and " + this.TblPrOrderQty + ".FLot is null \n");
        ksql.append("        ) \n");
        ksql.append("        and co.FCompanyID = '" + companyId + "' \n");
        ksql.append("    ) \n");
        ksql.append(") \n");
        ksql.append("where FCostObjectID is null \n");
        ksql.append("; \n");
        DbUtil.execute((Context)ctx, (String)ksql.toString());
    }

    private void createTblOrderQty(Context ctx, String companyId, PeriodInfo period, Object[][] costData, int count) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" create table T_NCM_OrderQtyTable (").append("\tFCompanyOrg varchar(44),").append("\tFCalculatePeriod varchar(44),").append("\tFManufactureOrderID varchar(44),").append("\tFCostCenterID varchar(44),").append("\tFCostObjectID varchar(44),").append("   FMaterialID varchar(44),").append("   FLot nvarchar(255),").append("\tFQty decimal(28,10))");
        try {
            this.TblOrderQty = pool.createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        try {
            ManufactureOrderFacadeFactory.getLocalInstance((Context)ctx).getOrderQtyDataByBill(period, costData, this.TblOrderQty);
            this.initInductData(ctx, this.TblOrderQty, companyId);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void initInductData(Context ctx, String stempTableName, String companyID) throws BOSException, EASBizException, SQLException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("update " + stempTableName + " \n");
        ksql.append("set (FMaterialID, FLot) = ( \n");
        ksql.append("    select mo.FMaterialID, mo.FLot from T_MM_ManufactureOrder mo \n");
        ksql.append("    where mo.FID = " + stempTableName + ".FManufactureOrderID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + stempTableName + " \n");
        ksql.append("set FCostObjectID = ( \n");
        ksql.append("    select top 1 FID from T_BD_CostObject co \n");
        ksql.append("    where co.FCompanyID = '" + companyID + "' \n");
        ksql.append("    and co.FIsForbiden = 0 \n");
        ksql.append("    and ( \n");
        ksql.append("        co.FCalculateMode = 7 \n");
        ksql.append("        and co.FOrderID = " + stempTableName + ".FManufactureOrderID \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode in (1, 3) \n");
        ksql.append("        and co.FStdProductIDID = " + stempTableName + ".FMaterialID \n");
        ksql.append("        and co.FCompanyID = '" + companyID + "' \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode = 3 \n");
        ksql.append("        and co.FID in ( \n");
        ksql.append("            select ");
        ksql.append("                coe.FParentID ");
        ksql.append("            from T_BD_CostObjectEntry coe ");
        ksql.append("            where coe.FParentID = co.FID \n");
        ksql.append("            and FRelatedID = " + stempTableName + ".FMaterialID \n");
        ksql.append("            and co.FCompanyID = '" + companyID + "' \n");
        ksql.append("        ) \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode = 4 \n");
        ksql.append("        and co.FStdProductIDID = " + stempTableName + ".FMaterialID \n");
        ksql.append("        and ( \n");
        ksql.append("            co.FBatchNumber = " + stempTableName + ".FLot \n");
        ksql.append("            or \n");
        ksql.append("            co.FBatchNumber is null and " + stempTableName + ".FLot is null \n");
        ksql.append("        ) \n");
        ksql.append("        and co.FCompanyID = '" + companyID + "' \n");
        ksql.append("    ) \n");
        ksql.append(") \n");
        ksql.append("where FCostObjectID is null \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)ksql.toString());
    }

    @Override
    protected void _clearPreviousDataByOrderData(Context ctx, String CompanyId, String periodId, Object[][] costData, int count) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        Object[] params = new Object[]{CompanyId, periodId};
        strSQL.append("Delete From T_NCM_INPUTQTYBILLEntry Where FparentId in  ").append(" \r\n");
        strSQL.append("(Select DISTINCT bill.FID From T_NCM_INPUTQTYBILL as bill ").append("  INNER join T_NCM_INPUTQTYBILLEntry as entry on bill.fid=entry.FparentId ").append("  where  bill.FIsImport = 1 And bill.FCompanyOrg = ? And  bill.FCalculatePeriod = ? ");
        if (count > 0) {
            strSQL.append("and (1<>1 ");
        }
        for (int i = 0; i < count; ++i) {
            String costCenterID = null;
            String costObject = null;
            if (costData[i][2] != null) {
                costCenterID = costData[i][2].toString();
            }
            if (costData[i][3] != null) {
                costObject = costData[i][3].toString();
            }
            if (costCenterID != null && costCenterID.length() != 0) {
                strSQL.append("or (  bill.FCostCenterOrgUnitID = '" + costCenterID + "'");
                if (costObject != null && costObject.length() != 0) {
                    strSQL.append(" And entry.FCostObjectID  ='" + costObject + "' )");
                    continue;
                }
                strSQL.append(" )");
                continue;
            }
            if (costObject == null || costObject.length() == 0) continue;
            strSQL.append(" or ( entry.FCostObjectID  ='" + costObject + "' )");
        }
        if (count > 0) {
            strSQL.append(" )");
        }
        strSQL.append(" )");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_INPUTQTYBILL Where FIsImport = 1 And FCompanyOrg = ? And FCalculatePeriod = ? ");
        if (count > 0) {
            strSQL.append(" and fid not in (Select DISTINCT entry.FparentId From T_NCM_INPUTQTYBILLentry as entry) ");
        }
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
    }

    @Override
    protected void _clearPreviousData(Context ctx, String CompanyId, String periodId, Object[][] costData, int count) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        Object[] params = new Object[]{CompanyId, periodId};
        strSQL.append("Delete From T_NCM_INPUTQTYBILLEntry Where FparentId in  ").append(" \r\n");
        strSQL.append("(Select DISTINCT bill.FID From T_NCM_INPUTQTYBILL as bill ").append("  INNER join T_NCM_INPUTQTYBILLEntry as entry on bill.fid=entry.FparentId ").append("  where  bill.FIsImport = 1 And bill.FCompanyOrg = ? And  bill.FCalculatePeriod = ? ");
        if (count > 0) {
            strSQL.append("and (1<>1 ");
        }
        for (int i = 0; i < count; ++i) {
            String costCenterID = null;
            String costObject = null;
            if (costData[i][0] != null) {
                costCenterID = costData[i][0].toString();
            }
            if (costData[i][1] != null) {
                costObject = costData[i][1].toString();
            }
            if (costCenterID != null && costCenterID.length() != 0) {
                strSQL.append("or (  bill.FCostCenterOrgUnitID = '" + costCenterID + "'");
                if (costObject != null && costObject.length() != 0) {
                    strSQL.append(" And entry.FCostObjectID  ='" + costObject + "' )");
                    continue;
                }
                strSQL.append(" )");
                continue;
            }
            if (costObject == null || costObject.length() == 0) continue;
            strSQL.append(" or ( entry.FCostObjectID  ='" + costObject + "' )");
        }
        if (count > 0) {
            strSQL.append(" )");
        }
        strSQL.append(" )");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_INPUTQTYBILL Where FIsImport = 1 And FCompanyOrg = ? And FCalculatePeriod = ? ");
        if (count > 0) {
            strSQL.append(" and fid not in (Select DISTINCT entry.FparentId From T_NCM_INPUTQTYBILLentry as entry) ");
        }
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
    }

    private void checkIfCodingRuleExsit(Context ctx, String companyId) throws BOSException, EASBizException {
        if (!CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)new InputQtyBillInfo(), companyId)) {
            throw new CMBillException(CMBillException.NOCORDRULE, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"56_InputQtyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    private void executeImportManufactureCommonSql(Context ctx, String companyId, PeriodInfo period, Object[][] costData, int count) throws BOSException, EASBizException {
        String costObject;
        String costCenterID;
        int i;
        UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        StringBuffer sqlInfo = new StringBuffer();
        StringBuffer sqlEntry = new StringBuffer();
        sqlInfo.append("insert into T_NCM_InputQtyBill ( ");
        sqlInfo.append(" FID,FCreateTime,FCreatorID,FLastUpdateTime,FLastUpdateUserID,FAuditTime,FAuditorID,FIsImport,FCalculatePeriod,FBillStatus,FCostCenterOrgUnitID,FCompanyOrg,FControlunitID,FBIZDATE)");
        sqlInfo.append(" select newbosid('B2B2D2CC'),GetDate(),?,GetDate(),?,GetDate(),?,1,?,4,CollectTbl.FCostCenterOrgUnitID,?,?,CollectTbl.FBeginDate");
        sqlInfo.append("        from ").append(this.CollectTblName).append(" as CollectTbl ");
        if (count > 0) {
            sqlInfo.append(" where (1<>1 ");
        }
        for (i = 0; i < count; ++i) {
            costCenterID = null;
            costObject = null;
            if (costData[i][0] != null) {
                costCenterID = costData[i][0].toString();
            }
            if (costData[i][1] != null) {
                costObject = costData[i][1].toString();
            }
            if (costCenterID != null && costCenterID.length() != 0) {
                sqlInfo.append("or (  CollectTbl.FCostCenterOrgUnitID = '" + costCenterID + "'");
                if (costObject != null && costObject.length() != 0) {
                    sqlInfo.append(" And CollectTbl.FCostObjectID  ='" + costObject + "' )");
                    continue;
                }
                sqlInfo.append(" )");
                continue;
            }
            if (costObject == null || costObject.length() == 0) continue;
            sqlInfo.append(" or ( CollectTbl.FCostObjectID  ='" + costObject + "' )");
        }
        if (count > 0) {
            sqlInfo.append(" )");
        }
        sqlInfo.append(" group by FCostCenterOrgUnitID,FBeginDate");
        sqlEntry.append("insert into T_NCM_InputQtyBillEntry ( ");
        sqlEntry.append(" FID, FSeq, FCostObjectID, FIsImport, FQty, FParentID)");
        sqlEntry.append(" select newbosid('E65D2506'),0,CollectTbl.FCostObjectID,1,sum(CollectTbl.FQty),inputBill.FID");
        sqlEntry.append("        from ").append(this.CollectTblName).append(" as CollectTbl ");
        sqlEntry.append("  inner join ").append("T_NCM_InputQtyBill").append(" as inputBill ");
        sqlEntry.append("        on  CollectTbl.FCostCenterOrgUnitID = inputBill.FCostCenterOrgUnitID and inputBill.FIsImport = 1 and inputBill.FCompanyOrg = ? and inputBill.FCalculatePeriod = ? ");
        sqlEntry.append("  left join ").append("T_NCM_InputQtyBillentry").append(" as entry ");
        sqlEntry.append("        on inputBill.Fid = entry.Fparentid ");
        sqlEntry.append(" where entry.Fid is null \n");
        if (count > 0) {
            sqlEntry.append(" and (1<>1 ");
        }
        for (i = 0; i < count; ++i) {
            costCenterID = null;
            costObject = null;
            if (costData[i][0] != null) {
                costCenterID = costData[i][0].toString();
            }
            if (costData[i][1] != null) {
                costObject = costData[i][1].toString();
            }
            if (costCenterID != null && costCenterID.length() != 0) {
                sqlEntry.append("or (  CollectTbl.FCostCenterOrgUnitID = '" + costCenterID + "'");
                if (costObject != null && costObject.length() != 0) {
                    sqlEntry.append(" And CollectTbl.FCostObjectID  ='" + costObject + "' )");
                    continue;
                }
                sqlEntry.append(" )");
                continue;
            }
            if (costObject == null || costObject.length() == 0) continue;
            sqlEntry.append(" or ( CollectTbl.FCostObjectID  ='" + costObject + "' )");
        }
        if (count > 0) {
            sqlEntry.append(" )");
        }
        sqlEntry.append("  group by CollectTbl.FCostObjectID,inputBill.FID");
        Connection conn = null;
        PreparedStatement psBill = null;
        PreparedStatement psEntry = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            psBill = conn.prepareStatement(sqlInfo.toString());
            psBill.setString(1, UserInfo2.getId().toString());
            psBill.setString(2, UserInfo2.getId().toString());
            psBill.setString(3, UserInfo2.getId().toString());
            psBill.setString(4, period.getId().toString());
            psBill.setString(5, companyId);
            psBill.setString(6, cu.getId().toString());
            psBill.executeUpdate();
            this.getNumber(ctx, companyId, period.getId().toString());
            psEntry = conn.prepareStatement(sqlEntry.toString());
            psEntry.setString(1, companyId);
            psEntry.setString(2, period.getId().toString());
            psEntry.executeUpdate();
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psBill);
                SQLUtils.cleanup(psEntry);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psBill);
        SQLUtils.cleanup((Statement)psEntry);
        SQLUtils.cleanup((Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getNumber(Context ctx, String companyId, String periodId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_NCM_InputQtyBill bill \n");
        sql.append("  where bill.FIsImport = 1");
        sql.append("      AND FCompanyOrg = '" + companyId + "' \n");
        sql.append("      AND FCalculatePeriod = '" + periodId + "'\n");
        sql.append("      AND FNumber is null \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        PreparedStatement pstmtUpdate = null;
        Connection conn = null;
        sql.setLength(0);
        sql.append("update T_NCM_InputQtyBill set Fnumber = ? \n");
        sql.append("    where FIsImport = 1 \n");
        sql.append("      AND FCompanyOrg = '" + companyId + "' \n");
        sql.append("      AND FCalculatePeriod = '" + periodId + "'\n");
        sql.append("      AND Fid = ? \n");
        int numberCount = 0;
        if (!CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)new InputQtyBillInfo(), companyId)) {
            sql.setLength(0);
            sql.append("delete T_NCM_InputQtyBill \n");
            sql.append("    where FNumber is null \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
            return;
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtUpdate = conn.prepareStatement(sql.toString());
            while (rs.next()) {
                String newNumber = InputQtyBillFactory.getLocalInstance(ctx).getNewNumber((IObjectValue)new InputQtyBillInfo(), companyId, null);
                pstmtUpdate.setString(1, newNumber);
                pstmtUpdate.setString(2, rs.getString(1));
                pstmtUpdate.addBatch();
                if (++numberCount % 500 != 0) continue;
                pstmtUpdate.executeBatch();
                pstmtUpdate.clearBatch();
            }
            pstmtUpdate.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (EASBizException e1) {
                    throw new BOSException((Throwable)e1);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtUpdate, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtUpdate, (Connection)conn);
    }

    private void importManufactureCommon(Context ctx, String companyId, PeriodInfo period, Object[][] costData, int count, boolean isReOver) throws BOSException, EASBizException {
        if (isReOver) {
            this._clearPreviousData(ctx, companyId, period.getId().toString(), costData, count);
        }
        this.executeImportManufactureCommonSql(ctx, companyId, period, costData, count);
    }

    private void delete(Context ctx, String companyId, String sign) throws BOSException {
        StringBuffer deteleSql = new StringBuffer();
        deteleSql.append("delete T_NCM_GetNumber where FSign='");
        if (sign.equals("One")) {
            deteleSql.append("0' and  fcompanyid='" + companyId + "'");
        } else if (sign.equals("Two")) {
            deteleSql.append("1' and  fcompanyid='" + companyId + "'");
        } else if (sign.equals("four")) {
            deteleSql.append("3' and  fcompanyid='" + companyId + "'");
        } else if (sign.equals("Three")) {
            deteleSql.append("2' and  fcompanyid='" + companyId + "'");
        } else {
            deteleSql.append("4' and  fcompanyid='" + companyId + "'");
        }
        DbUtil.execute((Context)ctx, (String)deteleSql.toString());
    }

    @Override
    protected void _getNumber(Context ctx, String companyId, Object[][] costData, int count, String sign) throws BOSException {
        this.delete(ctx, companyId, sign);
        StringBuffer insertSql = new StringBuffer();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (sign.equals("One") || sign.equals("Two") || sign.equals("four")) {
            for (int i = 0; i < count; ++i) {
                insertSql.append(" insert into T_NCM_GetNumber(FID,FCompanyID,FCostCenterID,FCostObject,FSign,FUserID) values(newbosid('E65D2506'),");
                if (companyId != null) {
                    insertSql.append("'" + companyId + "',");
                }
                if (costData[i][0] != null && costData[i][0].toString().length() != 0) {
                    insertSql.append("'" + costData[i][0] + "',");
                } else {
                    insertSql.append(" null,");
                }
                if (costData[i][1] != null && costData[i][1].toString().length() != 0) {
                    insertSql.append("'" + costData[i][1] + "',");
                } else {
                    insertSql.append(" null ,");
                }
                if (sign.equals("One")) {
                    insertSql.append(" 0,");
                } else if (sign.equals("Two")) {
                    insertSql.append(" 1,");
                } else if (sign.equals("four")) {
                    insertSql.append(" 3,");
                }
                if (userInfo != null) {
                    insertSql.append("'" + userInfo.getId().toString() + "'");
                }
                insertSql.append(" );");
            }
        } else if (sign.equals("Three")) {
            for (int i = 0; i < count; ++i) {
                insertSql.append(" insert into T_NCM_GetNumber(FID,FCompanyID,FCostCenterID,FCostObject,FSign,FUserID,FStorageID,FWorkCenterID) values(newbosid('E65D2506'),");
                if (companyId != null) {
                    insertSql.append("'" + companyId + "',");
                }
                if (costData[i][2] != null && costData[i][2].toString().length() != 0) {
                    insertSql.append("'" + costData[i][2] + "',");
                } else {
                    insertSql.append(" null,");
                }
                if (costData[i][3] != null && costData[i][3].toString().length() != 0) {
                    insertSql.append("'" + costData[i][3] + "',");
                } else {
                    insertSql.append(" null ,");
                }
                if (sign.equals("One")) {
                    insertSql.append(" 0,");
                } else if (sign.equals("Two")) {
                    insertSql.append(" 1,");
                } else if (sign.equals("four")) {
                    insertSql.append(" 3,");
                } else {
                    insertSql.append(" 2,");
                }
                if (userInfo != null) {
                    insertSql.append("'" + userInfo.getId().toString() + "',");
                }
                if (costData[i][0] != null && costData[i][0].toString().length() != 0) {
                    insertSql.append("'" + costData[i][0] + "',");
                } else {
                    insertSql.append(" null,");
                }
                if (costData[i][1] != null && costData[i][1].toString().length() != 0) {
                    insertSql.append("'" + costData[i][1] + "'");
                } else {
                    insertSql.append(" null ");
                }
                insertSql.append(" );");
            }
        } else {
            for (int i = 0; i < count; ++i) {
                insertSql.append(" insert into T_NCM_GetNumber(FID,FCompanyID,FCostCenterID,FCostObject,FSign,FUserID,FStorageID,FWorkCenterID) values(newbosid('E65D2506'),");
                if (companyId != null) {
                    insertSql.append("'" + companyId + "',");
                }
                if (costData[i][2] != null && costData[i][2].toString().length() != 0) {
                    insertSql.append("'" + costData[i][2] + "',");
                } else {
                    insertSql.append(" null,");
                }
                if (costData[i][3] != null && costData[i][3].toString().length() != 0) {
                    insertSql.append("'" + costData[i][3] + "',");
                } else {
                    insertSql.append(" null ,");
                }
                if (sign.equals("One")) {
                    insertSql.append(" 0,");
                } else if (sign.equals("Two")) {
                    insertSql.append(" 1,");
                } else if (sign.equals("four")) {
                    insertSql.append(" 3,");
                } else if (sign.equals("Three")) {
                    insertSql.append(" 2,");
                } else {
                    insertSql.append(" 4,");
                }
                if (userInfo != null) {
                    insertSql.append("'" + userInfo.getId().toString() + "',");
                }
                if (costData[i][0] != null && costData[i][0].toString().length() != 0) {
                    insertSql.append("'" + costData[i][0] + "',");
                } else {
                    insertSql.append(" null,");
                }
                if (costData[i][1] != null && costData[i][1].toString().length() != 0) {
                    insertSql.append("'" + costData[i][1] + "'");
                } else {
                    insertSql.append(" null ");
                }
                insertSql.append(" );");
            }
        }
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)insertSql.toString());
    }

    @Override
    protected IRowSet _SelectNumber(Context ctx, String companyId, String sign) throws BOSException, EASBizException {
        StringBuffer SelectSql = new StringBuffer();
        IRowSet rowSet = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (sign.equals("One") || sign.equals("Two") || sign.equals("four")) {
            SelectSql.append("select getNumber.FCostCenterID,costCenter.FNumber,costCenter.FName_L2, getNumber.FCostObject,costObject.FNumber,costObject.Fname_L2,material.FModel  from T_NCM_GetNumber getNumber  left join T_ORG_CostCenter costCenter  on costCenter.fid=getNumber.FCostCenterID left join T_BD_CostObject costObject on costObject.fid=getNumber.FCostObject left join T_BD_Material material on costObject.FStdProductIDID=material.FID where getNumber.FCompanyID=? and FUserID=? and FSign='");
            if (sign.equals("One")) {
                SelectSql.append("0'");
            } else if (sign.equals("Two")) {
                SelectSql.append("1'");
            } else if (sign.equals("four")) {
                SelectSql.append("3'");
            } else {
                SelectSql.append("2'");
            }
        } else {
            SelectSql.append("select getNumber.FCostCenterID,costCenter.FNumber,costCenter.FName_L2,").append(" getNumber.FCostObject,costObject.FNumber,costObject.Fname_L2,material.FModel,").append(" getNumber.FStorageID,storage.FNumber,storage.FName_L2,").append(" getNumber.FWorkCenterID,workCenter.FNumber,workCenter.FName_L2 ").append(" from T_NCM_GetNumber getNumber ").append(" left join T_ORG_CostCenter costCenter ").append(" on costCenter.fid=getNumber.FCostCenterID").append(" left join T_BD_CostObject costObject").append(" on costObject.fid=getNumber.FCostObject").append(" left join T_BD_Material material").append(" on costObject.FStdProductIDID=material.FID").append(" left join t_ORG_BaseUnit storage").append(" on storage.fid = getNumber.FStorageID").append(" left join t_MM_WorkCenter workCenter").append(" on workCenter.fid = getNumber.FWorkCenterID").append(" where getNumber.FCompanyID=? and FUserID=? and FSign='");
            if (sign.equals("One")) {
                SelectSql.append("0'");
            } else if (sign.equals("Two")) {
                SelectSql.append("1'");
            } else if (sign.equals("Three")) {
                SelectSql.append("2'");
            } else if (sign.equals("Five")) {
                SelectSql.append("4'");
            }
        }
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)SelectSql.toString(), (Object[])new Object[]{companyId, userInfo.getId().toString()});
            return rowSet;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Object[][] _getCostCenterAndCostObject(Context ctx, String companyId, String sign) throws BOSException {
        Object[][] obj;
        StringBuffer SelectSql = new StringBuffer();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        IRowSet rowSet = null;
        if (sign.equals("One") || sign.equals("Two") || sign.equals("four")) {
            SelectSql.append("select costCenter.FID, costObject.FID  from T_NCM_GetNumber getNumber  left join T_ORG_CostCenter costCenter  on costCenter.fid=getNumber.FCostCenterID left join T_BD_CostObject costObject on costObject.fid=getNumber.FCostObject left join T_BD_Material material on costObject.FStdProductIDID=material.FID where getNumber.FCompanyID=? and FUserID=? and FSign='");
            if (sign.equals("One")) {
                SelectSql.append("0'");
            } else if (sign.equals("Two")) {
                SelectSql.append("1'");
            } else if (sign.equals("four")) {
                SelectSql.append("3'");
            } else {
                SelectSql.append("2'");
            }
            try {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)SelectSql.toString(), (Object[])new Object[]{companyId, userInfo.getId().toString()});
                obj = new Object[rowSet.size()][2];
                int i = 0;
                while (rowSet.next()) {
                    obj[i][0] = rowSet.getString(1);
                    obj[i][1] = rowSet.getString(2);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                try {
                    if (rowSet != null) {
                        rowSet.close();
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        SelectSql.append("select FStorageID, FWorkCenterID, FCostCenterID, FCostObject  from T_NCM_GetNumber getNumber  where getNumber.FCompanyID=? and FUserID=? and FSign='");
        if (sign.equals("Three")) {
            SelectSql.append("2'");
        } else {
            SelectSql.append("4'");
        }
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)SelectSql.toString(), (Object[])new Object[]{companyId, userInfo.getId().toString()});
            obj = new Object[rowSet.size()][4];
            int i = 0;
            while (rowSet.next()) {
                obj[i][0] = rowSet.getString(1);
                obj[i][1] = rowSet.getString(2);
                obj[i][2] = rowSet.getString(3);
                obj[i][3] = rowSet.getString(4);
                ++i;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (rowSet != null) {
                    rowSet.close();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return obj;
    }

    private void createTempTable(Context ctx, String companyId, String periodId, Object[][] costData, int count) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String DateTblName = null;
        StringBuffer createDateTableSql = new StringBuffer();
        createDateTableSql.append(" create table T_NCM_DateTable( \n");
        createDateTableSql.append("     fid varchar(44), \n");
        createDateTableSql.append("     FCompanyorgunitID varchar(44), \n");
        createDateTableSql.append("     FCostCenterOrgUnitID varchar(44), \n");
        createDateTableSql.append("     FCostObjectID varchar(44), \n");
        createDateTableSql.append("     FMaterialID varchar(44), \n");
        createDateTableSql.append("     FLot nvarchar(256), \n");
        createDateTableSql.append("     FManuBillID varchar(44), \n");
        createDateTableSql.append("     FManuOrderID varchar(44), \n");
        createDateTableSql.append("     FManuMaterialID varchar(44), \n");
        createDateTableSql.append("     FManuLot nvarchar(256), \n");
        createDateTableSql.append("     FQty decimal(21,8), \n");
        createDateTableSql.append("     FPeriodID varchar(44), \n");
        createDateTableSql.append("     FBeginDate DateTime \n");
        createDateTableSql.append(") \n");
        try {
            DateTblName = pool.createTempTable(createDateTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("insert into " + DateTblName + " ( \n");
        sb.append("    fid, \n");
        sb.append("    FCompanyorgunitID, \n");
        sb.append("    FCostCenterOrgUnitID, \n");
        sb.append("    FCostObjectID, \n");
        sb.append("    FMaterialID, \n");
        sb.append("    FLot, \n");
        sb.append("    FManuBillID, \n");
        sb.append("    FManuOrderID, \n");
        sb.append("    FQty, \n");
        sb.append("    FPeriodID, \n");
        sb.append("    FBeginDate \n");
        sb.append(") \n");
        sb.append("select \n");
        sb.append("    newbosid('B2B2D2CC'), \n");
        sb.append("\t   manufacturerecbillentry.fcompanyorgunitid, \n");
        sb.append("    manufacturerecbillentry.fcostcenterorgunitid, \n");
        sb.append("    manufacturerecbillentry.FCostObjectID,\n");
        sb.append("    manufacturerecbillentry.fmaterialid,\n");
        sb.append("    manufacturerecbillentry.flot, \n");
        sb.append("    manufacturerecbill.fid, \n");
        sb.append("    manufacturerecbillentry.FManuBillID, \n");
        sb.append("\t   manufacturerecbillentry.fbaseqty, \n");
        sb.append("\t   period.fid, \n");
        sb.append("\t   period.FBeginDate ");
        sb.append("FROM t_im_manufacturerecbill manufacturerecbill ");
        sb.append("INNER JOIN t_im_manufacturerecbillentry manufacturerecbillentry ");
        sb.append("    ON manufacturerecbill.fid = manufacturerecbillentry.fparentid ");
        sb.append("INNER JOIN t_org_costcenter CC ");
        sb.append("    ON CC.fid = manufacturerecbillentry.fcostcenterorgunitid ");
        sb.append("INNER JOIN t_scm_transactiontype transtype  ");
        sb.append("    ON (manufacturerecbill.ftransactiontypeid =transtype.fid ");
        sb.append("        AND transtype.fismanucostcalculate = 1 \n");
        sb.append("    ) \n");
        sb.append("\tINNER JOIN T_IM_InvUpdateType ut on manufacturerecbillentry.FINVUPDATETYPEID = ut.fid ").append('\n');
        sb.append("\tINNER JOIN T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n');
        sb.append("LEFT OUTER JOIN t_bd_period period ");
        sb.append("    ON (manufacturerecbill.fyear = period.fperiodyear ");
        sb.append("\t       AND manufacturerecbill.fperiod = period.fperiodnumber \n");
        sb.append("\t   ) \n");
        sb.append("where manufacturerecbill.fbasestatus = 4 \n");
        sb.append("    and CC.fcostcentertype = 0 \n");
        sb.append("    and period.fid = '" + periodId + "' \n");
        sb.append("    and manufacturerecbillentry.fcompanyorgunitid ='" + companyId + "' \n");
        sb.append("    and manufacturerecbillentry.fcostcenterorgunitid is not null \n");
        int costObjectCount = 0;
        for (int i = 0; i < count; ++i) {
            String costCenterID = null;
            if (costData[i][0] != null) {
                costCenterID = costData[i][0].toString();
            }
            if (costCenterID == null || costCenterID.length() == 0) continue;
            if (count > 0 && costObjectCount == 0) {
                sb.append(" and (1<>1 ");
            }
            sb.append("or manufacturerecbillentry.fcostcenterorgunitid = '" + costCenterID + "'");
            ++costObjectCount;
        }
        if (count > 0 && costObjectCount > 0) {
            sb.append(" )");
        }
        DbUtil.execute((Context)ctx, (String)sb.toString());
        StringBuffer ksql = new StringBuffer();
        ksql.append("update " + DateTblName + " t \n");
        ksql.append("set \n");
        ksql.append("\t(FCostObjectID) \n");
        ksql.append("\t\t= \n");
        ksql.append("\t( \n");
        ksql.append("\t\tselect co.fid from t_bd_costObject co \n");
        ksql.append("\t\tinner join t_Bd_costObjectEntry coe on co.FID = coe.FParentID \n");
        ksql.append("\t\tinner join t_Bd_materialcompanyinfo mac on mac.FMaterialID = coe.FRelatedID and mac.Fcreatecobyorder = '0' \n");
        ksql.append("\t\twhere t.FMaterialID = coe.FRelatedID and co.FCalculateMode = 3 and co.FCompanyID = '" + companyId + "' and t.Flot is null \n");
        ksql.append("\t\tand co.FISFORBIDEN = 0 \n");
        ksql.append("       group by co.fid \n");
        ksql.append("\t); \n");
        ksql.append("update " + DateTblName + " \n");
        ksql.append("set (FCostObjectID, FManuMaterialID, FManuLot) = ( \n");
        ksql.append("    select mo.FCostObjectID, mo.FMaterialID, mo.FLot \n");
        ksql.append("    from T_MM_ManufactureOrder mo \n");
        ksql.append("    where mo.FID = " + DateTblName + ".FManuOrderID \n");
        ksql.append(") \n");
        ksql.append("where FManuOrderID is not null \n");
        ksql.append("; \n");
        ksql.append("update " + DateTblName + " \n");
        ksql.append("set (FCostObjectID) = ( \n");
        ksql.append("    select top 1 co.FID \n");
        ksql.append("    from T_BD_CostObject co \n");
        ksql.append("    where \n");
        ksql.append("    co.FCalculateMode = 7 \n");
        ksql.append("    and co.FOrderID = " + DateTblName + ".FManuOrderID \n");
        ksql.append("    or \n");
        ksql.append("    co.FCalculateMode in (1, 3) \n");
        ksql.append("    and co.FStdProductIDID = " + DateTblName + ".FManuMaterialID \n");
        ksql.append("    and co.FCompanyID = '" + companyId + "' \n");
        ksql.append("    or \n");
        ksql.append("    co.FCalculateMode = 3 \n");
        ksql.append("    and co.FID in ( \n");
        ksql.append("        select ");
        ksql.append("            coe.FParentID ");
        ksql.append("        from T_BD_CostObjectEntry coe ");
        ksql.append("        where coe.FParentID = co.FID \n");
        ksql.append("        and FRelatedID = " + DateTblName + ".FManuMaterialID \n");
        ksql.append("        and co.FCompanyID = '" + companyId + "' \n");
        ksql.append("    ) \n");
        ksql.append("    or \n");
        ksql.append("    co.FCalculateMode = 4 \n");
        ksql.append("    and co.FStdProductIDID = " + DateTblName + ".FManuMaterialID \n");
        ksql.append("    and ( \n");
        ksql.append("        co.FBatchNumber = " + DateTblName + ".FManuLot \n");
        ksql.append("        or \n");
        ksql.append("        co.FBatchNumber is null and " + DateTblName + ".FManuLot is null \n");
        ksql.append("    ) \n");
        ksql.append("    and co.FCompanyID = '" + companyId + "' \n");
        ksql.append(") \n");
        ksql.append("where FManuOrderID is not null \n");
        ksql.append("and FCostObjectID is null \n");
        ksql.append("; \n");
        ksql.append("update " + DateTblName + " \n");
        ksql.append("set (FCostObjectID) = ( \n");
        ksql.append("    select top 1 co.FID \n");
        ksql.append("    from T_BD_CostObject co \n");
        ksql.append("    where \n");
        ksql.append("    co.FCalculateMode in (1, 3) \n");
        ksql.append("    and co.FStdProductIDID = " + DateTblName + ".FMaterialID \n");
        ksql.append("    and co.FCompanyID = '" + companyId + "' \n");
        ksql.append("    or \n");
        ksql.append("    co.FCalculateMode = 3 \n");
        ksql.append("    and co.FID in ( \n");
        ksql.append("        select ");
        ksql.append("            coe.FParentID ");
        ksql.append("        from T_BD_CostObjectEntry coe ");
        ksql.append("        where coe.FParentID = co.FID \n");
        ksql.append("        and FRelatedID = " + DateTblName + ".FMaterialID \n");
        ksql.append("    ) \n");
        ksql.append("    and co.FCompanyID = '" + companyId + "' \n");
        ksql.append("    or \n");
        ksql.append("    co.FCalculateMode = 4 \n");
        ksql.append("    and co.FStdProductIDID = " + DateTblName + ".FMaterialID \n");
        ksql.append("    and ( \n");
        ksql.append("        co.FBatchNumber = " + DateTblName + ".FLot \n");
        ksql.append("        or \n");
        ksql.append("        co.FBatchNumber is null and " + DateTblName + ".FLot is null \n");
        ksql.append("    ) \n");
        ksql.append("    and co.FCompanyID = '" + companyId + "' \n");
        ksql.append(") \n");
        ksql.append("where FCostObjectID is null \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        StringBuffer createCollectTableSql = new StringBuffer();
        createCollectTableSql.append("create table T_NCM_CollectTable ( \n");
        createCollectTableSql.append("    FCompanyorgunitID varchar(44), \n");
        createCollectTableSql.append("    FCostCenterOrgUnitID varchar(44), \n");
        createCollectTableSql.append("    FCostObjectID varchar(44), \n");
        createCollectTableSql.append("    FMaterialID varchar(44), \n");
        createCollectTableSql.append("    FLot nvarchar(255), \n");
        createCollectTableSql.append("    FQty decimal(21,8), \n");
        createCollectTableSql.append("    FPeriodID varchar(44), \n");
        createCollectTableSql.append("    FManuBillID varchar(44), \n");
        createCollectTableSql.append("    FBeginDate DateTime \n");
        createCollectTableSql.append(") \n");
        try {
            this.CollectTblName = pool.createTempTable(createCollectTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer collectSql = new StringBuffer();
        collectSql.append("insert into " + this.CollectTblName + " ( \n");
        collectSql.append("    FCompanyorgunitID, \n");
        collectSql.append("    FCostCenterOrgUnitID, \n");
        collectSql.append("    FcostobjectID, \n");
        collectSql.append("    FMaterialID, \n");
        collectSql.append("    FQty, \n");
        collectSql.append("    FPeriodID, \n");
        collectSql.append("    FManuBillID, \n");
        collectSql.append("    FBeginDate \n");
        collectSql.append(") \n");
        collectSql.append("select distinct \n");
        collectSql.append("    dateTable.FCompanyorgunitID, \n");
        collectSql.append("    FCostCenterOrgUnitID, \n");
        collectSql.append("    co.FID, \n");
        collectSql.append("    dateTable.FMaterialID, \n");
        collectSql.append("    SUM(ISNULL(FQty,0)*ISNULL(FQuotiety,1)), \n");
        collectSql.append("    dateTable.FPeriodID, \n");
        collectSql.append("    dateTable.FManuBillID, \n");
        collectSql.append("    dateTable.FBeginDate \n");
        collectSql.append("from " + DateTblName + " dateTable \n");
        collectSql.append("join T_BD_CostObject co \n");
        collectSql.append("    on co.FID = dateTable.FCostObjectID \n");
        collectSql.append("join T_BD_CostObjectEntry coe \n");
        collectSql.append("    on coe.FParentID = co.FID \n");
        collectSql.append("    and coe.FRelatedID = dateTable.FMaterialID \n");
        collectSql.append("where co.FCompanyID = '" + companyId + "' \n ");
        collectSql.append("group by \n");
        collectSql.append("    dateTable.FCompanyorgunitID, \n");
        collectSql.append("    FCostCenterOrgUnitID, \n");
        collectSql.append("    co.FID, dateTable.FMaterialID, \n");
        collectSql.append("    dateTable.FPeriodID,dateTable.FManuBillID, dateTable.FBeginDate ");
        DbUtil.execute((Context)ctx, (String)collectSql.toString());
    }

    protected Map bizCheckForSubmit(Context ctx, List ids, Map param) throws BOSException, EASBizException {
        final HashMap report = new HashMap();
        if (ids == null || ids.isEmpty()) {
            return report;
        }
        ArrayList<Object[]> idsParam = new ArrayList<Object[]>();
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            idsParam.add(new Object[]{ids.get(i)});
        }
        String costCenterIsNull = "\u672a\u5f55\u5165\u6210\u672c\u4e2d\u5fc3";
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FID \n");
        kSql.append("   from T_NCM_InputQtyBill \n");
        kSql.append("  where FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and FCostCenterOrgUnitID is null \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                List<String> detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList<String>();
                detail.add("\u672a\u5f55\u5165\u6210\u672c\u4e2d\u5fc3");
                report.put(id, detail);
            }
        });
        String noEntry = "\u5355\u636e\u6ca1\u6709\u5206\u5f55";
        kSql.setLength(0);
        kSql.append(" select FID \n");
        kSql.append("   from T_NCM_InputQtyBill \n");
        kSql.append("  where FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and FNumber is not null \n");
        kSql.append("    and FID not in (select FParentID from T_NCM_InputQtyBillEntry) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                List<String> detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList<String>();
                detail.add("\u5355\u636e\u6ca1\u6709\u5206\u5f55");
                report.put(id, detail);
            }
        });
        String noCostObjectInEntry = "\u5206\u5f55\u672a\u5f55\u5165\u6210\u672c\u5bf9\u8c61";
        String errorQtyInEntry = "\u5206\u5f55\u6570\u91cf\u4e0d\u80fd\u7b49\u4e8e0";
        kSql.setLength(0);
        kSql.append(" select FParentID, FCostObjectID, FQty \n");
        kSql.append("   from T_NCM_InputQtyBillEntry \n");
        kSql.append("  where FParentID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and (FCostObjectID is null or FQty is null or FQty = 0) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FParentID");
                String costObjectID = rs.getString("FCostObjectID");
                BigDecimal qty = rs.getBigDecimal("FQty");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (costObjectID == null || costObjectID.length() == 0) {
                    detail.add("\u5206\u5f55\u672a\u5f55\u5165\u6210\u672c\u5bf9\u8c61");
                }
                if (qty == null || qty.compareTo(SysConstant.BIGZERO) <= 0) {
                    detail.add("\u5206\u5f55\u6570\u91cf\u4e0d\u80fd\u7b49\u4e8e0");
                }
                report.put(id, detail);
            }
        });
        return report;
    }

    @Override
    protected String _checkNumber(Context ctx, String companyId, String sign) throws BOSException, EASBizException {
        StringBuffer result = new StringBuffer();
        try {
            if (sign.equals("Three")) {
                result.append(this.checkWorCenter(ctx, companyId));
                result.append("//");
                result.append(this.checkCostCenter(ctx, companyId));
            }
            if (sign.equals("Five")) {
                result.append(this.checkCostCenterPr(ctx, companyId));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer checkCostCenterPr(Context ctx, String companyID) throws BOSException, SQLException {
        StringBuffer checkResult = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("    SELECT cc.FID,cc.FNumber,cc.FName_l2 FROM T_NCM_GetNumber m \n").append("    INNER JOIN T_ORG_CostCenter cc ON cc.FID = m.FCostCenterID \n").append("    WHERE NOT EXISTS (SELECT FID FROM T_MM_ProductLine wc where wc.FCostCenterOrgUnitID = m.FCostCenterID) \n").append("AND m.FSign='4' AND m.FCompanyID = '").append(companyID + "'");
        int i = 1;
        try (IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());){
            while (rs.next()) {
                checkResult.append(i + ". \u6210\u672c\u4e2d\u5fc3" + rs.getString(2) + "\u6ca1\u6709\u5bf9\u5e94\u7684\u751f\u4ea7\u7ebf\u3002\n");
                ++i;
            }
        }
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer checkWorCenter(Context ctx, String companyID) throws BOSException, SQLException {
        StringBuffer checkResult = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("    SELECT workCenter.Fid,workCenter.FNumber,workCenter.FName_l2 From T_NCM_GetNumber m \n").append("    INNER JOIN T_MM_WORKCENTER workCenter ON m.FWorkCenterID = workCenter.FID \n").append("    WHERE workCenter.FCostCenterID is null AND m.FCompanyID = '").append(companyID + "'");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int i = 1;
            while (rs.next()) {
                checkResult.append(i + ". \u5de5\u4f5c\u4e2d\u5fc3" + rs.getString(2) + "\u6ca1\u6709\u6307\u5b9a\u6210\u672c\u4e2d\u5fc3\u3002\n");
                ++i;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer checkCostCenter(Context ctx, String companyID) throws BOSException, SQLException {
        StringBuffer checkResult = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("    SELECT cc.FID,cc.FNumber,cc.FName_l2 FROM T_NCM_GetNumber m \n").append("    INNER JOIN T_ORG_CostCenter cc ON cc.FID = m.FCostCenterID \n").append("    WHERE NOT EXISTS (SELECT FID FROM T_MM_WORKCENTER wc where wc.FCostCenterID = m.FCostCenterID) \n").append("AND m.FCompanyID = '").append(companyID + "'");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int i = 1;
            while (rs.next()) {
                checkResult.append(i + ". \u6210\u672c\u4e2d\u5fc3" + rs.getString(2) + "\u6ca1\u6709\u5bf9\u5e94\u7684\u5de5\u4f5c\u4e2d\u5fc3\u3002\n");
                ++i;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return checkResult;
    }

    private String checkCostObjIsForbiden(Context ctx) throws BOSException {
        StringBuffer getForbidenCostObj = new StringBuffer();
        getForbidenCostObj.append("SELECT co.FNumber,co.FName_" + ctx.getLocale() + " FROM ").append(this.CollectTblName).append("    data \n").append("    INNER JOIN T_BD_CostObject  co ON co.FID = data.FCostObjectID AND co.FIsForbiden = 1 \n").append("    INNER JOIN T_BD_CostObjectEntry coEntry1 on co.FID = coEntry1.FParentID \n").append("    Where coEntry1.FRelatedID in (select coEntry2.FRelatedID from T_BD_CostObjectEntry coEntry2 group by coEntry2.FRelatedid having count(1) < 2 )");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getForbidenCostObj.toString());
        StringBuffer objFnumbers = new StringBuffer();
        try {
            while (rowSet.next()) {
                objFnumbers.append(rowSet.getString(1));
                objFnumbers.append("    " + rowSet.getString(2) + "\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer delete = new StringBuffer();
        delete.append("DELETE FROM ").append(this.CollectTblName).append(" WHERE FCostObjectID IN \n").append("    (SELECT FID FROM T_BD_CostObject WHERE FIsForbiden = 1) \n");
        DbUtil.execute((Context)ctx, (String)delete.toString());
        return objFnumbers.toString();
    }

    @Override
    protected String _importByOrderRatio(Context ctx, boolean isReOver, String companyId, String periodId, Object[][] costData, int count) throws BOSException, EASBizException {
        PreparedStatement psEntry;
        Connection conn;
        String flag;
        block35: {
            this.checkIfCodingRuleExsit(ctx, companyId);
            flag = "Success";
            conn = null;
            PreparedStatement psBill = null;
            psEntry = null;
            IRowSet rst = null;
            String TMP_Data_Tbl = null;
            try {
                String costObject;
                String costCenterID;
                int i;
                StringBuffer kSql = new StringBuffer();
                kSql.setLength(0);
                kSql.append("create table TMP_Data_Tbl(       \n");
                kSql.append(" \tFProductID \t   varchar(44),   \n");
                kSql.append(" \tFManufactureOrderID  varchar(44),   \n");
                kSql.append(" \tFOrderNumber   nvarchar(255), \n");
                kSql.append(" \tFOrderQty \t   decimal(21,8), \n");
                kSql.append(" \tFRecBillAmount decimal(21,8), \n");
                kSql.append(" \tFCostCenterID  varchar(44),   \n");
                kSql.append(" \tFBizDate \t   DateTime,      \n");
                kSql.append(" \tFCostObjectId  varchar(44),   \n");
                kSql.append("   FQtyPrecision int default(4), \n");
                kSql.append("   FMaterialID varchar(44),");
                kSql.append("   FLot nvarchar(255),");
                kSql.append("   FQty           decimal(21,8),");
                kSql.append(" \tFOrderAmount   decimal(21,8)  \n");
                kSql.append(" )                               \n");
                StringBuffer where = new StringBuffer();
                if (count > 0) {
                    where.append("  and (1<>1 ");
                }
                for (int i2 = 0; i2 < count; ++i2) {
                    String costCenterID2 = null;
                    String costObject2 = null;
                    if (costData[i2][0] != null) {
                        costCenterID2 = costData[i2][0].toString();
                    }
                    if (costData[i2][1] != null) {
                        costObject2 = costData[i2][1].toString();
                    }
                    if (costCenterID2 != null && costCenterID2.length() != 0) {
                        where.append("or (  FCostCenterID = '" + costCenterID2 + "'");
                        if (costObject2 != null && costObject2.length() != 0) {
                            where.append(" And FCostObjectID  ='" + costObject2 + "' )");
                            continue;
                        }
                        if (costObject2 != null) continue;
                        where.append(")");
                        continue;
                    }
                    if (costObject2 == null || costObject2.length() == 0) continue;
                    where.append(" or ( FCostObjectID  ='" + costObject2 + "' )");
                }
                if (count > 0) {
                    where.append(" )");
                }
                TMP_Data_Tbl = TempTablePool.getInstance((Context)ctx).createTempTable(kSql.toString());
                kSql.setLength(0);
                kSql.append("INSERT INTO " + TMP_Data_Tbl + " ( ");
                kSql.append(" \tFProductID ,\n");
                kSql.append(" \tFManufactureOrderID  ,\n");
                kSql.append(" \tFOrderNumber ,\n");
                kSql.append(" \tFOrderQty ,\n");
                kSql.append(" \tFRecBillAmount,\n");
                kSql.append(" \tFCostCenterID,\n ");
                kSql.append(" \tFBizDate,\n ");
                kSql.append(" \tFCostObjectID ,\n");
                kSql.append(" \tFOrderAmount \n");
                kSql.append(" ) \n");
                kSql.append(" SELECT   mOrder.FMaterialID AS FProductID, \n");
                kSql.append("          mOrder.FID AS FManufactureOrderID, \n");
                kSql.append("          mOrder.FNumber AS FOrderNumber, \n");
                kSql.append("          mOrder.FBaseQty AS FOrderQty, \n");
                kSql.append("          SUM(ISNULL(recBillEntry.FBaseQty,0)* ISNULL(matCompany.FStandardCost,0)) AS FRecBillAmount, \n");
                kSql.append("          recBillEntry.FCostCenterOrgUnitID AS FCostCenterID, \n");
                kSql.append("          MAX(recBill.FBizDate) AS FBizDate, \n");
                kSql.append(" \t       NULL\u3000AS\u3000FCostObjectId,\n");
                kSql.append(" \t       0 AS\u3000FOrderAmount \n");
                kSql.append(" FROM     T_IM_MaterialReqBill recBill \n");
                kSql.append("          INNER JOIN T_SCM_TransactionType transType \n");
                kSql.append("            ON (recBill.FTransactionTypeID = transType.FID) \n");
                kSql.append("          INNER JOIN T_IM_MaterialReqBillEntry recBillEntry \n");
                kSql.append("            ON recBill.FID = recBillEntry.FParentID \n");
                kSql.append("          INNER JOIN T_BD_Material mat \n");
                kSql.append("            ON recBillEntry.FMaterialID = mat.FID \n");
                kSql.append("          INNER JOIN T_BD_MaterialCompanyInfo matCompany \n");
                kSql.append("            ON matCompany.FMaterialID = recBillEntry.FMaterialID \n");
                kSql.append("          INNER JOIN T_BD_MaterialPlan matPlan \n");
                kSql.append("            ON matPlan.FMaterialID = recBillEntry.FMaterialID \n");
                kSql.append("               AND matPlan.FOrgUnit = recBill.FStorageOrgUnitID \n");
                kSql.append("          INNER JOIN T_BD_Period period \n");
                kSql.append("            ON (recBill.FYear = period.FPeriodYear \n");
                kSql.append("                AND recBill.FPeriod = period.FPeriodNumber) \n");
                kSql.append("          INNER JOIN T_MM_ManufactureOrder mOrder \n");
                kSql.append("            ON mOrder.FID = recBillEntry.FSourceBillID  \n");
                kSql.append(" WHERE    recBillEntry.FCostCenterOrgUnitID IS NOT NULL  \n");
                kSql.append("          AND recBill.FBaseStatus = 4 \n");
                kSql.append("          AND recBillEntry.FCompanyOrgUnitID = ? \n");
                kSql.append("          AND period.FID = ? \n");
                kSql.append("          AND matCompany.FCompanyID = ? \n");
                kSql.append("          AND recBill.FSOURCEBILLTYPEID <> 'YnsvoPSeRzCK0b/jEufQpkY+1VI=' \n");
                kSql.append(" GROUP BY mOrder.FMaterialID,mOrder.FID,mOrder.FNumber,mOrder.FBaseQty,recBillEntry.FCostCenterOrgUnitID \n");
                DbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new String[]{companyId, periodId, companyId});
                rst = DbUtil.executeQuery((Context)ctx, (String)(" select top 1 1 from " + TMP_Data_Tbl));
                if (!rst.next()) {
                    String i2 = "NO_RECBILL_DATA";
                    return i2;
                }
                SQLUtils.cleanup((ResultSet)rst);
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_Data_Tbl + " \n");
                kSql.append(" SET    FOrderAmount = (SELECT SUM(ISNULL(stock.FPlannedBaseQty,0)* ISNULL(matCompany.FStandardCost,0)) \n");
                kSql.append("                        FROM   T_MM_ManufactureOrder mOrder \n");
                kSql.append("                               INNER JOIN T_MM_MFTOrderStock stock \n");
                kSql.append("                                 ON mOrder.FID = stock.FParentID \n");
                kSql.append("                               INNER JOIN T_BD_MaterialCompanyInfo matCompany \n");
                kSql.append("                                 ON matCompany.FMaterialID = stock.FMaterialID \n");
                kSql.append("                               INNER JOIN T_BD_MaterialPlan matPlan \n");
                kSql.append("                                 ON matPlan.FMaterialID = stock.FMaterialID \n");
                kSql.append("                                    AND matPlan.FOrgUnit = mOrder.FStorageOrgUnitID \n");
                kSql.append("                        WHERE  matCompany.FCompanyID = ? \n");
                kSql.append("                               AND mOrder.FID = " + TMP_Data_Tbl + ".FManufactureOrderID \n");
                kSql.append("                               AND mOrder.FMaterialID = " + TMP_Data_Tbl + ".FProductID) \n");
                DbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new String[]{companyId});
                kSql.setLength(0);
                kSql.append(" UPDATE " + TMP_Data_Tbl + " \n");
                kSql.append(" SET    FCostObjectID = (SELECT FID \n");
                kSql.append("                         FROM   T_BD_CostObject co \n");
                kSql.append("                         WHERE  co.FRelatedID = " + TMP_Data_Tbl + ".FProductID \n");
                kSql.append("                                AND co.FCalculateMode = 7 \n");
                kSql.append("                                AND co.FOrderID = " + TMP_Data_Tbl + ".FManufactureOrderID)  \n");
                DbUtil.execute((Context)ctx, (String)kSql.toString());
                this.initInductData(ctx, TMP_Data_Tbl, companyId);
                rst = DbUtil.executeQuery((Context)ctx, (String)(" select top 1 1 from " + TMP_Data_Tbl + " where FOrderAmount is not null and FOrderAmount <> 0 " + where.toString()));
                if (!rst.next()) {
                    String i2 = "NO_ORDER_DATA";
                    return i2;
                }
                SQLUtils.cleanup((ResultSet)rst);
                kSql.setLength(0);
                kSql.append("UPDATE " + TMP_Data_Tbl + " \n");
                kSql.append("SET FQtyPrecision = ( \n");
                kSql.append("    select \n");
                kSql.append("        FQtyPrecision \n");
                kSql.append("    from T_BD_Material m \n");
                kSql.append("    join T_BD_MultiMeasureUnit mu \n");
                kSql.append("        on mu.FMaterialID = m.FID and mu.FMeasureUnitID = m.FBaseUnit \n");
                kSql.append("    where m.FID = " + TMP_Data_Tbl + ".FProductID \n");
                kSql.append(") \n");
                DbUtil.execute((Context)ctx, (String)kSql.toString());
                kSql.setLength(0);
                kSql.append("UPDATE " + TMP_Data_Tbl + " \n");
                kSql.append("SET FQty = ( \n");
                kSql.append("    case when isnull(FOrderAmount,0)=0 \n");
                kSql.append("         then   0 \n");
                kSql.append("    else round((isnull(FOrderQty,0) * isnull(FRecBillAmount,0) / FOrderAmount),FQtyPrecision)  end  \n");
                kSql.append(") \n");
                DbUtil.execute((Context)ctx, (String)kSql.toString());
                kSql.setLength(0);
                kSql.append("DELETE FROM " + TMP_Data_Tbl + " \n");
                kSql.append("    where FCostObjectID is null or isnull(FRecBillAmount,0) = 0 \n");
                DbUtil.execute((Context)ctx, (String)kSql.toString());
                if (isReOver) {
                    this.clearPreviousDataBy(ctx, companyId, periodId, costData, count);
                }
                UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
                CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                StringBuffer sqlInfo = new StringBuffer();
                StringBuffer sqlEntry = new StringBuffer();
                sqlInfo.append("insert into T_NCM_InputQtyBill ( ");
                sqlInfo.append(" FID,FCreateTime,FCreatorID,FLastUpdateTime,FLastUpdateUserID,FAuditTime,FAuditorID,FSourceBillID,FIsImport,FCalculatePeriod,FBillStatus,FCostCenterOrgUnitID,FCompanyOrg,FControlunitID,FBIZDATE)");
                sqlInfo.append(" select newbosid('B2B2D2CC'),GetDate(),?,GetDate(),?,GetDate(),?,CollectTbl.FManufactureOrderID,1,?,4,CollectTbl.FCostCenterID,?,?,CollectTbl.FBizDate");
                sqlInfo.append("        from ").append(TMP_Data_Tbl).append(" as CollectTbl ");
                if (count > 0) {
                    sqlInfo.append(" where (1<>1 ");
                }
                for (i = 0; i < count; ++i) {
                    costCenterID = null;
                    costObject = null;
                    if (costData[i][0] != null) {
                        costCenterID = costData[i][0].toString();
                    }
                    if (costData[i][1] != null) {
                        costObject = costData[i][1].toString();
                    }
                    if (costCenterID != null && costCenterID.length() != 0) {
                        sqlInfo.append("or (  CollectTbl.FCostCenterID = '" + costCenterID + "'");
                        if (costObject != null && costObject.length() != 0) {
                            sqlInfo.append(" And CollectTbl.FCostObjectID  ='" + costObject + "' )");
                            continue;
                        }
                        sqlInfo.append(" )");
                        continue;
                    }
                    if (costObject == null || costObject.length() == 0) continue;
                    sqlInfo.append(" or ( CollectTbl.FCostObjectID  ='" + costObject + "' )");
                }
                if (count > 0) {
                    sqlInfo.append(" )");
                }
                sqlInfo.append(" group by FCostCenterID,FManufactureOrderID,FBizDate");
                sqlEntry.append("insert into T_NCM_InputQtyBillEntry ( ");
                sqlEntry.append(" FID, FSeq, FCostObjectID, FIsImport, FQty, FParentID)");
                sqlEntry.append(" select newbosid('E65D2506'),0,CollectTbl.FCostObjectID,1,ceiling(sum(CollectTbl.FQty)),inputBill.FID");
                sqlEntry.append("        from ").append(TMP_Data_Tbl).append(" as CollectTbl ");
                sqlEntry.append("  inner join ").append("T_NCM_InputQtyBill").append(" as inputBill ");
                sqlEntry.append("        on inputBill.FSourceBillID = CollectTbl.FManufactureOrderID and CollectTbl.FCostCenterID = inputBill.FCostCenterOrgUnitID and inputBill.FIsImport = 1 and inputBill.FCompanyOrg = ? and inputBill.FCalculatePeriod = ? ");
                sqlEntry.append("  left join ").append("T_NCM_InputQtyBillentry").append(" as entry ");
                sqlEntry.append("        on inputBill.Fid = entry.Fparentid ");
                sqlEntry.append(" where entry.Fid is null \n");
                if (count > 0) {
                    sqlEntry.append(" and (1<>1 ");
                }
                for (i = 0; i < count; ++i) {
                    costCenterID = null;
                    costObject = null;
                    if (costData[i][0] != null) {
                        costCenterID = costData[i][0].toString();
                    }
                    if (costData[i][1] != null) {
                        costObject = costData[i][1].toString();
                    }
                    if (costCenterID != null && costCenterID.length() != 0) {
                        sqlEntry.append("or (  CollectTbl.FCostCenterID = '" + costCenterID + "'");
                        if (costObject != null && costObject.length() != 0) {
                            sqlEntry.append(" And CollectTbl.FCostObjectID  ='" + costObject + "' )");
                            continue;
                        }
                        sqlEntry.append(" )");
                        continue;
                    }
                    if (costObject == null || costObject.length() == 0) continue;
                    sqlEntry.append(" or ( CollectTbl.FCostObjectID  ='" + costObject + "' )");
                }
                if (count > 0) {
                    sqlEntry.append(" )");
                }
                sqlEntry.append("  group by CollectTbl.FCostObjectID,inputBill.FID");
                if (conn == null) {
                    conn = EJBFactory.getConnection((Context)ctx);
                }
                psBill = conn.prepareStatement(sqlInfo.toString());
                psBill.setString(1, UserInfo2.getId().toString());
                psBill.setString(2, UserInfo2.getId().toString());
                psBill.setString(3, UserInfo2.getId().toString());
                psBill.setString(4, periodId);
                psBill.setString(5, companyId);
                psBill.setString(6, cu.getId().toString());
                psBill.executeUpdate();
                this.getNumber(ctx, companyId, periodId);
                psEntry = conn.prepareStatement(sqlEntry.toString());
                psEntry.setString(1, companyId);
                psEntry.setString(2, periodId);
                psEntry.executeUpdate();
                if (psBill == null) break block35;
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            finally {
                if (psBill != null) {
                    SQLUtils.cleanup(psBill);
                }
                if (conn != null) {
                    SQLUtils.cleanup(psEntry, conn);
                }
            }
            SQLUtils.cleanup((Statement)psBill);
        }
        if (conn != null) {
            SQLUtils.cleanup((Statement)psEntry, (Connection)conn);
        }
        return flag;
    }

    private void clearPreviousDataBy(Context ctx, String CompanyId, String periodId, Object[][] costData, int count) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        Object[] params = new Object[]{CompanyId, periodId};
        strSQL.append("Delete From T_NCM_INPUTQTYBILLEntry Where FparentId in ").append(" \r\n").append("\t\t(Select FId From T_NCM_INPUTQTYBILL  ").append(" \r\n").append(" Where  FIsImport = 1 And FCompanyOrg = ? And FCalculatePeriod = ?  ");
        if (count > 0) {
            strSQL.append("  and (1<>1 ");
        }
        for (int i = 0; i < count; ++i) {
            String costCenterID = null;
            String costObject = null;
            if (costData[i][0] != null) {
                costCenterID = costData[i][0].toString();
            }
            if (costData[i][1] != null) {
                costObject = costData[i][1].toString();
            }
            if (costCenterID != null && costCenterID.length() != 0) {
                strSQL.append("or (  FCostCenterOrgUnitID = '" + costCenterID + "'");
                if (costObject != null && costObject.length() != 0) {
                    strSQL.append(" And FCostObjectID  ='" + costObject + "' )");
                    continue;
                }
                if (costObject != null) continue;
                strSQL.append(")");
                continue;
            }
            if (costObject == null || costObject.length() == 0) continue;
            strSQL.append(" or ( FCostObjectID  ='" + costObject + "' )");
        }
        if (count > 0) {
            strSQL.append(" )");
        }
        strSQL.append(" )");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
        strSQL.setLength(0);
        strSQL.append("Delete From T_NCM_INPUTQTYBILL Where FIsImport = 1 And FCompanyOrg = ? And FCalculatePeriod = ? ");
        if (count > 0) {
            strSQL.append(" and fid not in (Select DISTINCT entry.FparentId From T_NCM_INPUTQTYBILLentry as entry) ");
        }
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
    }
}

