/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.GLFetchDataException;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.OtherFeeBillEntryCollection;
import com.kingdee.eas.ncm.bill.OtherFeeBillEntryInfo;
import com.kingdee.eas.ncm.bill.OtherFeeBillInfo;
import com.kingdee.eas.ncm.bill.app.AbstractOtherFeeBillControllerBean;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OtherFeeBillControllerBean
extends AbstractOtherFeeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.OtherFeeBillControllerBean");
    private int costObjectOfBillRequired = -1;

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_OtherFeeBill";
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkOverheadObject(ctx, model);
        this.checkInputQty(ctx, model);
        return super._submit(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.processPrecision(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.processPrecision(ctx, model);
        super._update(ctx, pk, model);
    }

    private void processPrecision(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CurrencyInfo currency;
        OtherFeeBillInfo otherFeeBill = (OtherFeeBillInfo)model;
        if (otherFeeBill.getEntries() == null || otherFeeBill.getEntries().size() <= 0) {
            return;
        }
        int amountPrecision = 2;
        CompanyOrgUnitInfo company = otherFeeBill.getCompanyOrg();
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if ((currency = company.getBaseCurrency()) == null) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
            currency = company.getBaseCurrency();
        }
        if (currency != null) {
            if (currency.getPrecision() > 0) {
                amountPrecision = currency.getPrecision();
            } else {
                try {
                    currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()));
                    amountPrecision = currency.getPrecision();
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
        BigDecimal bd = null;
        for (int i = 0; i < otherFeeBill.getEntries().size(); ++i) {
            bd = otherFeeBill.getEntries().get(i).getAmount();
            if (bd == null) continue;
            bd = bd.setScale(amountPrecision, 4);
            otherFeeBill.getEntries().get(i).setAmount(bd);
        }
    }

    private void checkOverheadObject(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!(model instanceof OtherFeeBillInfo)) {
            return;
        }
        OtherFeeBillInfo fee = (OtherFeeBillInfo)model;
        OtherFeeBillEntryCollection entrys = fee.getEntries();
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        if (fee.getCostCenter() == null || fee.getCostCenter().getId() == null) {
            return;
        }
        String costCenterId = fee.getCostCenter().getId().toString();
        if (StringUtils.isEmpty((String)costCenterId)) {
            return;
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT TOP 1 ");
        kSql.append("        co.fname_" + ctx.getLocale() + " AS costObjectName, ");
        kSql.append("        cc.fname_" + ctx.getLocale() + " AS costCenterName ");
        kSql.append(" FROM   T_BD_CostObject co ");
        kSql.append("        INNER JOIN T_BD_CostObjectEntry coEntry ");
        kSql.append("          ON co.fid = coEntry.fparentid ");
        kSql.append("        INNER JOIN T_NCM_AUXOverhead overhead ");
        kSql.append("          ON coEntry.FRelatedID = overhead.FID ");
        kSql.append("        INNER JOIN T_NCM_AUXOverheadCompanyInfo overheadCompany ");
        kSql.append("          ON overheadCompany.FAUXOverheadID = overhead.FID ");
        kSql.append("          and overheadCompany.FCompanyID = '" + fee.getCompanyOrg().getId().toString() + "'");
        kSql.append("        INNER JOIN T_ORG_CostCenter cc ");
        kSql.append("          ON overheadCompany.FCostCenterID = cc.FID ");
        kSql.append(" WHERE  co.FRelatedType = 3 ");
        kSql.append("        AND ( ");
        boolean hasData = false;
        String notFoundStr = "##########";
        int count = entrys.size();
        for (int i = 0; i < count; ++i) {
            OtherFeeBillEntryInfo entryInfo = entrys.get(i);
            String costObjectId = null;
            costObjectId = entryInfo == null || entryInfo.getCostObject() == null || entryInfo.getCostObject().getId() == null ? notFoundStr : entryInfo.getCostObject().getId().toString();
            if (StringUtils.isEmpty((String)costObjectId)) continue;
            hasData = true;
            if (i != count - 1) {
                kSql.append("(co.FID ='" + costObjectId + "'  AND cc.FID <> '" + costCenterId + "') OR ");
                continue;
            }
            kSql.append("(co.FID ='" + costObjectId + "'  AND cc.FID <> '" + costCenterId + "') ");
        }
        kSql.append(" ) ");
        if (!hasData) {
            return;
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
        try {
            if (rows.next()) {
                String costObjectName = rows.getString(1);
                String costCenterName = rows.getString(2);
                throw new GLFetchDataException(GLFetchDataException.ERRORCOSTCENTEROFOVERHEADOBJECT, new String[]{costObjectName, costCenterName});
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    protected void _generateVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        super._generateVoucher(ctx, sourceBillPk);
    }

    protected void _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList) throws BOSException, EASBizException {
        super._generateVoucher(ctx, sourceBillPkList);
    }

    @Override
    protected boolean _getBySourceId(Context ctx, String sourceIds) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select top 1 FID from T_NCM_OtherFeeBill ").append("where FSourceBillID in").append(sourceIds);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return rs != null && rs.size() > 0;
    }

    protected void checkFivouchered(Context ctx, String tableName, String ids) throws BOSException, CMBillException, SQLException {
        StringBuffer checkSql = new StringBuffer();
        checkSql.append(" select FNumber from ").append(tableName).append("  where fid in ( ").append(ids).append(" ) and FFivouchered=1 ");
        IRowSet checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        if (checkSet.next() && checkSet.getString(1) != null) {
            throw new CMBillException(CMBillException.CHECKFIVOUCHEREDOK);
        }
    }

    private void checkInputQty(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!(model instanceof OtherFeeBillInfo)) {
            return;
        }
        OtherFeeBillInfo fee = (OtherFeeBillInfo)model;
        OtherFeeBillEntryCollection entrys = fee.getEntries();
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        if (fee.getCostCenter() != null && CostCenterType.AssistantProdDept.equals((Object)fee.getCostCenter().getCostCenterType())) {
            return;
        }
        ArrayList<CostObjectInfo> costObjects = new ArrayList<CostObjectInfo>();
        boolean hasShare = false;
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            OtherFeeBillEntryInfo entry = entrys.get(i);
            if (entry.getCostObject() == null || entry.getCostObject().getId() == null || "SCOID".equals(entry.getCostObject().getNumber())) {
                hasShare = true;
                continue;
            }
            costObjects.add(entry.getCostObject());
        }
        if (hasShare) {
            try {
                StringBuffer kSql = new StringBuffer();
                String tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)fee.getCompanyOrg().getId().toString(), (String)"T_NCM_Balance");
                kSql.append(" select SUM(entry.FQty) ");
                kSql.append("   from T_NCM_InputQtyBill bill ");
                kSql.append("        left outer join T_NCM_InputQtyBillEntry entry");
                kSql.append("           on bill.FID = entry.FParentID ");
                kSql.append("   where bill.FBillStatus = 4 ");
                kSql.append("     and bill.FCompanyOrg = ? ");
                kSql.append("     and bill.FCalculatePeriod = ? ");
                kSql.append("     and bill.FCostCenterOrgUnitID = ? ");
                kSql.append(" group by bill.FCompanyOrg,bill.FCalculatePeriod,entry.FCostObjectID ");
                kSql.append("    having SUM(entry.FQty) <>0 ");
                kSql.append(" union ");
                kSql.append(" select SUM(balance.FBopWIPQty) ");
                kSql.append("   from ").append(tblBalance).append(" balance ");
                kSql.append("  where balance.FCompanyOrg = ? ");
                kSql.append("    and balance.FCalculatePeriodID = ? ");
                kSql.append("    and balance.FCostCenterID = ? ");
                kSql.append(" group by balance.FCompanyOrg,balance.FCalculatePeriodID,balance.FCostObjectID ");
                kSql.append("  having SUM(balance.FBopWIPQty) <>0 ");
            }
            catch (SQLException exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
        }
        if (!costObjects.isEmpty()) {
            CostObjectInfo[] costObjectInfos = new CostObjectInfo[costObjects.size()];
            for (int i = 0; i < costObjects.size(); ++i) {
                costObjectInfos[i] = (CostObjectInfo)costObjects.get(i);
            }
            NCMServerUtils.checkInputQty((Context)ctx, (CompanyOrgUnitInfo)fee.getCompanyOrg(), (PeriodInfo)fee.getCalculatePeriod(), (CostCenterOrgUnitInfo)fee.getCostCenter(), (CostObjectInfo[])costObjectInfos);
        }
    }

    protected Map bizCheckForSubmit(final Context ctx, List ids, Map param) throws BOSException, EASBizException {
        final String companyID = param.containsKey("companyID") && param.get("companyID") != null ? (String)param.get("companyID") : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        final HashMap report = new HashMap();
        if (ids == null || ids.isEmpty()) {
            return report;
        }
        ArrayList<Object[]> idsParam = new ArrayList<Object[]>();
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            idsParam.add(new Object[]{ids.get(i)});
        }
        String costCenterIsNull = "\u672a\u5f55\u5165\u6210\u672c\u4e2d\u5fc3";
        String bizDateIsNull = "\u672a\u5f55\u5165\u4e1a\u52a1\u65e5\u671f";
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FID,FCostCenterID,FBizDate \n");
        kSql.append("   from T_NCM_OtherFeeBill \n");
        kSql.append("  where FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and (FCostCenterID is null or FBizDate is null) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                String costCenterID = rs.getString("FCostCenterID");
                Date date = rs.getDate("FBizDate");
                List detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                if (costCenterID == null || costCenterID.length() == 0) {
                    detail.add("\u672a\u5f55\u5165\u6210\u672c\u4e2d\u5fc3");
                }
                if (date == null) {
                    detail.add("\u672a\u5f55\u5165\u4e1a\u52a1\u65e5\u671f");
                }
                report.put(id, detail);
            }
        });
        String noEntry = "\u5355\u636e\u6ca1\u6709\u5206\u5f55";
        kSql.setLength(0);
        kSql.append(" select FID \n");
        kSql.append("   from T_NCM_OtherFeeBill \n");
        kSql.append("  where FID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        kSql.append("    and FNumber is not null \n");
        kSql.append("    and FID not in (select FParentID from T_NCM_OtherFeeBillEntry) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString("FID");
                List<String> detail = null;
                detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList<String>();
                detail.add("\u5355\u636e\u6ca1\u6709\u5206\u5f55");
                report.put(id, detail);
            }
        });
        String noCostItemInEntry = "\u5206\u5f55\u672a\u5f55\u5165\u6210\u672c\u9879\u76ee";
        String noCostObjectInEntry = "\u5206\u5f55\u672a\u5f55\u5165\u6210\u672c\u5bf9\u8c61";
        String expenseIsNull = "\u5206\u5f55\u672a\u5f55\u5165\u8981\u7d20\u8d39\u7528";
        String coSql = "";
        if (this.isCostObjectOfBillRequired(ctx, companyID)) {
            coSql = "FCostObjectID, ";
        }
        kSql.setLength(0);
        kSql.append(" select FParentID, FCostItemID, " + coSql + "FExpenseID, FAmount \n");
        kSql.append("   from T_NCM_OtherFeeBillEntry \n");
        kSql.append("  where FParentID in (");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("    )");
        coSql = "";
        if (this.isCostObjectOfBillRequired(ctx, companyID)) {
            coSql = "or FCostObjectID is null ";
        }
        kSql.append("    and (FCostItemID is null " + coSql + " or FExpenseID is null ) \n");
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), idsParam, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                try {
                    String id = rs.getString("FParentID");
                    String costItemID = rs.getString("FCostItemID");
                    String expenseID = rs.getString("FExpenseID");
                    String costObjectID = null;
                    if (OtherFeeBillControllerBean.this.isCostObjectOfBillRequired(ctx, companyID)) {
                        costObjectID = rs.getString("FCostObjectID");
                    }
                    List detail = null;
                    detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                    if (costItemID == null || costItemID.length() == 0) {
                        detail.add("\u5206\u5f55\u672a\u5f55\u5165\u6210\u672c\u9879\u76ee");
                    }
                    if (OtherFeeBillControllerBean.this.isCostObjectOfBillRequired(ctx, companyID) && (costObjectID == null || costObjectID.length() == 0)) {
                        detail.add("\u5206\u5f55\u672a\u5f55\u5165\u6210\u672c\u5bf9\u8c61");
                    }
                    if (expenseID == null || expenseID.length() == 0) {
                        detail.add("\u5206\u5f55\u672a\u5f55\u5165\u8981\u7d20\u8d39\u7528");
                    }
                    report.put(id, detail);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                    throw new SQLException(e.getMessage());
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage());
                    throw new SQLException(e.getMessage());
                }
            }
        });
        String costObjectNoInputQty = "\u5206\u5f55\u6210\u672c\u5bf9\u8c61\u6ca1\u6709\u6295\u5165\u4ea7\u91cf";
        String errorCostCenter2AUXOverhead = "\u6210\u672c\u4e2d\u5fc3\u548c\u8d39\u7528\u5bf9\u8c61\u8d22\u52a1\u9875\u7b7e\u7ef4\u62a4\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u4e00\u81f4";
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("costCenter.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.costObject.id"));
        sic.add(new SelectorItemInfo("entries.costObject.number"));
        sic.add(new SelectorItemInfo("entries.costObject.name"));
        int size2 = ids.size();
        for (int i = 0; i < size2; ++i) {
            String id = ids.get(i).toString();
            OtherFeeBillInfo info = this.getOtherFeeBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id), sic);
            try {
                this.checkOverheadObject(ctx, (IObjectValue)info);
                this.checkInputQty(ctx, (IObjectValue)info);
                continue;
            }
            catch (NcmBillException exc) {
                List<String> detail;
                if (exc.getSubCode().equals(NcmBillException.NO_ANYINPUT_FORACTUALHOUR.getCode())) {
                    detail = null;
                    detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList<String>();
                    detail.add("\u5206\u5f55\u6210\u672c\u5bf9\u8c61\u6ca1\u6709\u6295\u5165\u4ea7\u91cf");
                    report.put(id, detail);
                    continue;
                }
                if (exc.getSubCode().equals(GLFetchDataException.ERRORCOSTCENTEROFOVERHEADOBJECT.getCode())) {
                    detail = null;
                    detail = report.containsKey(id) ? (List)report.get(id) : new ArrayList();
                    detail.add("\u6210\u672c\u4e2d\u5fc3\u548c\u8d39\u7528\u5bf9\u8c61\u8d22\u52a1\u9875\u7b7e\u7ef4\u62a4\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u4e00\u81f4");
                    report.put(id, detail);
                    continue;
                }
                throw exc;
            }
        }
        return report;
    }

    private boolean isCostObjectOfBillRequired(Context ctx, String companyID) throws BOSException, EASBizException {
        if (this.costObjectOfBillRequired < 0) {
            this.costObjectOfBillRequired = 0;
            if (NCMUtils.isCostObjectOfBillRequired((Context)ctx, (String)companyID)) {
                this.costObjectOfBillRequired = 1;
            }
        }
        return this.costObjectOfBillRequired == 1;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum botBillOperStateEnum, IObjectValue botRelationInfo) throws BOSException, EASBizException {
        String sql = "update T_Ncm_OtherFeeBill set FVoucherId = ?, FFiVouchered = ? where FId = ?;";
        Object[] param = null;
        if (BOTBillOperStateEnum.ADDNEW.equals((Object)botBillOperStateEnum)) {
            param = new Object[]{((BOTRelationInfo)botRelationInfo).getDestObjectID(), true, srcBillPK.toString()};
        } else if (BOTBillOperStateEnum.DELETE.equals((Object)botBillOperStateEnum)) {
            param = new Object[]{"", false, srcBillPK.toString()};
        }
        if (param != null) {
            DbUtil.execute((Context)ctx, (String)sql, param);
        }
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        super._deleteBatchData(ctx, pkArray);
        StringBuffer ids = new StringBuffer();
        ids.append("(");
        for (int i = 0; i < pkArray.length; ++i) {
            if (i != 0) {
                ids.append(",");
            }
            ids.append("'").append(pkArray[i].toString()).append("'");
        }
        ids.append(")");
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append("DELETE FROM T_BOT_RELATIONENTRY where fkeyid in ").append("( select fid FROM T_BOT_RELATION where FDESTENTITYID = '474CFD96' and FDESTOBJECTID in ").append(ids).append("); \r\n");
        deleteSql.append("DELETE FROM T_BOT_RELATION where  FDESTENTITYID = '474CFD96' and FDESTOBJECTID in ").append(ids).append(";");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
    }
}

