/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.SecondAlloc.SecAllocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.MatAllocTable;
import com.kingdee.eas.ncm.bill.app.SecondAlloc.SecAllocatorFactory.SecBaseAllocator;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class SecMatAllocator
extends SecBaseAllocator {
    private static Logger logger = Logger.getLogger((String)SecMatAllocator.class.getName());
    private String matTmpTbl = "";
    private boolean isUseSystemTempTable = true;
    protected Connection _globalConnection = null;
    protected TempTablePool _pool = null;
    boolean isOutsourcCalc = false;

    public SecMatAllocator(Map param) {
        super(param);
    }

    @Override
    public AllocTable getAllocTable() throws AllocateException {
        if (super.getAllocTable() == null) {
            Context ctx = (Context)this._param.get("ctx");
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            this._param.put("pool", pool);
            this.setAllocTable(new MatAllocTable(this._param));
        }
        return super.getAllocTable();
    }

    @Override
    public void preProcess() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String companyId = (String)this._param.get("companyId");
        try {
            this.isOutsourcCalc = NCMUtils.isDoOutSourcCalc((Context)ctx, (String)companyId);
        }
        catch (BOSException e1) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION);
        }
        this.matTmpTbl = this.initMatAllocTmpTbl();
    }

    @Override
    public void ReAllocDirect() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String calcLevel = (String)this._param.get("calcLevel");
        String companyId = (String)this._param.get("companyId");
        String periodID = (String)this._param.get("periodId");
        StringBuffer sb = new StringBuffer();
        if (this.isOutsourcCalc) {
            sb.append("update " + this.matTmpTbl + " set (FQty, FAmount, FPrice) = ( \n");
            sb.append("    Select entry.FBaseQty FQty, entry.FActualCost FAmount, entry.FUnitActualCost FPrice \n");
            sb.append("    from T_IM_MaterialReqBillEntry entry \n");
            sb.append("    where entry.FID= " + this.matTmpTbl + ".FSourceBillEntryID \n");
            sb.append(") \n");
            sb.append("where FIsDirect = 1 \n");
            sb.append("    and exists ( \n");
            sb.append("        Select top 1 1 \n");
            sb.append(" \t   from t_cal_CostObjectRank  bill \n");
            sb.append("        inner join t_cal_costObjectRankEntry entry on bill.FID = Entry.FParentID \n");
            sb.append(" \t   where entry.FcostObjectID = " + this.matTmpTbl + ".FMaterialID AND entry.FRank = " + calcLevel + " \n");
            sb.append("          AND bill.FCompanyOrg = '").append(companyId).append("' AND bill.FCalculatePeriod = '").append(periodID).append("' \n");
            sb.append("          AND bill.FLLCType = 0 \n");
            sb.append("    ) \n");
        } else {
            sb.append("update " + this.matTmpTbl + " set (FQty, FAmount, FPrice) = ( \n");
            sb.append("    Select entry.FBaseQty FQty, entry.FActualCost FAmount, entry.FUnitActualCost FPrice \n");
            sb.append("    from T_IM_MaterialReqBillEntry entry \n");
            sb.append("    where entry.FID= " + this.matTmpTbl + ".FSourceBillEntryID \n");
            sb.append(") \n");
            sb.append("where FIsDirect = 1 \n");
            sb.append("    and exists ( \n");
            sb.append("        Select top 1 1 \n");
            sb.append(" \t   from " + this.getCostCalPrdDetailResult() + " P \n");
            sb.append(" \t   where P.FProductID = " + this.matTmpTbl + ".FMaterialID AND P.FCalcLevel = " + calcLevel + " \n");
            sb.append("                 and isnull(P.FLot,'null') = isnull(" + this.matTmpTbl + ".FLot,'null') \n");
            sb.append("    ) \n");
        }
        try {
            NCMDbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    public void ReAllocIndirect() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String calcLevel = (String)this._param.get("calcLevel");
        String tblName = (String)this._param.get("matAllcStdTbl");
        String companyId = (String)this._param.get("companyId");
        String periodID = (String)this._param.get("periodId");
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("update ").append(this.matTmpTbl).append(" AS D set (FQty,FAmount)=(").append('\n').append("\tSelect round(D.FAllocStdData/S.FSumData * entry.FBaseQty ,Isnull(U.FQtyPrecision,8)) As FQty, ").append('\n').append("\t\tround(D.FAllocStdData/S.FSumData * entry.FActualCost,Isnull(CC.FPrecision,2)) As FAmount ").append('\n').append("\tFROM T_IM_MaterialReqBillEntry entry ").append('\n').append("\tLEFT OUTER JOIN T_BD_MeasureUnit U ON U.FID=entry.FBaseUnitID ").append('\n').append("\tINNER JOIN T_ORG_Company CP ON entry.FCompanyOrgUnitID = CP.FID").append('\n').append("\tLEFT OUTER JOIN T_BD_Currency CC ON CP.FBaseCurrencyID = CC.FID").append('\n').append("   INNER JOIN ").append(tblName).append(" S ON S.FSourceBillEntryID=entry.FID").append('\n').append("\twhere entry.FID= D.FSourceBillEntryID ").append('\n').append(") where D.FIsDirect=0 AND exists(").append('\n').append("\tSelect 1").append('\n').append("\tfrom (").append('\n').append("\t\tSelect M.FSourceBillEntryID,MAX(E.FBaseQty) As FSrcQty, SUM(M.FQty) As FDestQty, MAX(E.FActualCost) As FSrcAmount, SUM(M.FAmount) As FDestAmount ").append('\n').append("\t\tFROM ").append(this.matTmpTbl).append(" M ").append('\n').append("\t\tINNER JOIN T_IM_MaterialReqBillEntry E ON E.FID=M.FSourceBillEntryID").append("\t\twhere exists(").append('\n').append("\t\t\tSelect 1 From ").append(this.getCostCalPrdDetailResult()).append(" P ").append('\n').append(" \t\t\t\tINNER JOIN T_BD_COstObjectEntry coe on  coe.FRelatedID =  P.FProductID ").append('\n').append(" \t\t\t\tINNER JOIN T_BD_CostObject CO ON coe.fparentId = co.fid and co.FCompanyID = P.FCompanyID  ").append('\n').append("\t\t\twhere P.FCalcLevel = ").append(calcLevel).append(" and P.FProductID=E.FMaterialID and P.FCOMPANYID = e.FCOMPANYORGUNITID ").append('\n').append("\t\t\t   and ").append('\n').append("\t\t\t   ( ").append('\n').append("\t\t\t       (CO.FCalculateMode = 4 and Isnull(P.FLot,' ') = Isnull(CO.FBatchNumber,' ')) ").append('\n').append("\t\t\t\t   or ").append('\n').append("\t\t\t\t   (CO.FCalculateMode = 7 and CO.FOrderID is not null) ").append('\n').append("\t\t\t\t   or ").append('\n').append("\t\t\t\t   (CO.FCalculateMode in (1, 3)) ").append('\n').append("\t\t\t   ))").append('\n').append("\t\tGroup by M.FSourceBillEntryID ").append("\t) X ").append('\n').append("\twhere X.FSourceBillEntryID =D.FSourceBillEntryID  and (FSrcQty<>FDestQty or FSrcAmount<>FDestAmount )").append('\n').append(")");
            int amtPrecision = NCMUtils.getCurrencyPrecision((Context)ctx, (String)companyId);
            if (this.isOutsourcCalc) {
                sb.setLength(0);
                sb.append("update " + this.matTmpTbl + " set (FAmount, FPrice) = ( \n");
                sb.append("    select \n");
                sb.append("        case when entry.FBaseQty = 0 then \n");
                sb.append("            round(entry.FUnitActualCost * " + this.matTmpTbl + ".FQty, " + amtPrecision + ") \n");
                sb.append("            else \n");
                sb.append("            round(entry.FActualCost / entry.FBaseQty * " + this.matTmpTbl + ".FQty, " + amtPrecision + ") \n");
                sb.append("        end FAmount, \n");
                sb.append("        entry.FUnitActualCost FPrice \n");
                sb.append("    from T_IM_MaterialReqBillEntry entry \n");
                sb.append("    where entry.FID= " + this.matTmpTbl + ".FSourceBillEntryID \n");
                sb.append(") \n");
                sb.append("where FIsDirect = 0 \n");
                sb.append("    and exists ( \n");
                sb.append("        Select top 1 1 \n");
                sb.append(" \t   from t_cal_CostObjectRank  bill \n");
                sb.append("        inner join t_cal_costObjectRankEntry entry on bill.FID = Entry.FParentID \n");
                sb.append(" \t   where entry.FcostObjectID = " + this.matTmpTbl + ".FMaterialID AND entry.FRank = " + calcLevel + " \n");
                sb.append("          AND bill.FCompanyOrg = '").append(companyId).append("' AND bill.FCalculatePeriod = '").append(periodID).append("' \n");
                sb.append("          AND bill.FLLCType = 0 \n");
                sb.append("    ) \n");
                sb.append("    and ").append(this.matTmpTbl).append(".FIsRework = 0 \n");
            } else {
                sb.setLength(0);
                sb.append("update " + this.matTmpTbl + " set (FAmount, FPrice) = ( \n");
                sb.append("    select \n");
                sb.append("        case when entry.FBaseQty = 0 then \n");
                sb.append("            round(entry.FUnitActualCost * " + this.matTmpTbl + ".FQty, " + amtPrecision + ") \n");
                sb.append("            else \n");
                sb.append("            round(entry.FActualCost / entry.FBaseQty * " + this.matTmpTbl + ".FQty, " + amtPrecision + ") \n");
                sb.append("        end FAmount, \n");
                sb.append("        entry.FUnitActualCost FPrice \n");
                sb.append("    from T_IM_MaterialReqBillEntry entry \n");
                sb.append("    where entry.FID= " + this.matTmpTbl + ".FSourceBillEntryID \n");
                sb.append(") \n");
                sb.append("where FIsDirect = 0 \n");
                sb.append("    and exists ( \n");
                sb.append("        Select top 1 1 \n");
                sb.append(" \t   from " + this.getCostCalPrdDetailResult() + " P \n");
                sb.append(" \t   where P.FProductID = " + this.matTmpTbl + ".FMaterialID AND P.FCalcLevel = " + calcLevel + " \n");
                sb.append("                 and isnull(P.FLot,'null') = isnull(" + this.matTmpTbl + ".FLot,'null') \n");
                sb.append("    ) \n");
                sb.append("    and ").append(this.matTmpTbl).append(".FIsRework = 0 \n");
            }
            NCMDbUtil.execute((Context)ctx, (String)sb.toString());
            this.AdjustDiff();
            sb.delete(0, sb.length());
            sb.append("update ").append(this.matTmpTbl).append(" AS D set FPrice=(").append('\n').append("\tSelect round(D.FAmount/D.FQty,Isnull(U.FPricePrecision,8)) As FPrice ").append('\n').append("\tFROM T_IM_MaterialReqBillEntry entry ").append('\n').append("\tLEFT OUTER JOIN T_BD_Material U ON U.FID=entry.FMaterialID ").append('\n').append("\twhere entry.FID= D.FSourceBillEntryID ").append('\n').append(") where D.FIsDirect=0 AND D.FQty<>0 AND exists(").append('\n').append("\tSelect 1 ").append('\n').append("\tFROM T_IM_MaterialReqBillEntry E ").append("\tINNER JOIN ").append(this.getCostCalPrdDetailResult()).append(" P ON P.FProductID=E.FMaterialID and P.FCOMPANYID = e.FCOMPANYORGUNITID ").append('\n').append(" \tINNER JOIN T_BD_COstObjectEntry coe on  coe.FRelatedID =  P.FProductID ").append('\n').append(" \tINNER JOIN T_BD_CostObject CO ON coe.fparentId = co.fid and co.FCompanyID = P.FCompanyID  ").append('\n').append("\twhere E.FID =D.FSourceBillEntryID AND P.FCalcLevel = ").append(calcLevel).append("\t\t\t   and ").append('\n').append("\t\t\t   ( ").append('\n').append("\t\t\t       (CO.FCalculateMode = 4 and Isnull(P.FLot,' ') = Isnull(CO.FBatchNumber,' ')) ").append('\n').append("\t\t\t\t   or ").append('\n').append("\t\t\t\t   (CO.FCalculateMode = 7 and CO.FOrderID is not null) ").append('\n').append("\t\t\t\t   or ").append('\n').append("\t\t\t\t   (CO.FCalculateMode in (1, 3)) ").append('\n').append("\t\t\t   )").append('\n').append(")");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    public void endProcess() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        TempTablePool pool = (TempTablePool)this._param.get("pool");
        StringBuffer sb = new StringBuffer();
        sb.append(" update ").append(this.getTblResult()).append(" set (FQty,FAmount,FPrice) =(\n");
        sb.append("  select FQty,FAmount,FPrice From ").append(this.matTmpTbl).append(" tmpdata \n");
        sb.append("      where tmpdata.FID = ").append(this.getTblResult()).append(".FID \n");
        sb.append("  ) \n");
        try {
            NCMDbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION);
        }
        finally {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.matTmpTbl);
        }
    }

    private void AdjustDiff() throws AllocateException {
        StringBuffer sb;
        String T_TMP_MatAllocLevel;
        TempTablePool pool;
        Context ctx;
        IRowSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block8: {
            conn = null;
            pstmt = null;
            rs = null;
            String companyId = (String)this._param.get("companyId");
            String periodID = (String)this._param.get("periodId");
            ctx = (Context)this._param.get("ctx");
            String calcLevel = (String)this._param.get("calcLevel");
            pool = (TempTablePool)this._param.get("pool");
            T_TMP_MatAllocLevel = null;
            sb = new StringBuffer();
            StringBuffer sql = new StringBuffer();
            sql.append("create table T_TMP_MatAllocLevel ( \n");
            sql.append("    FSourceBillEntryID VARCHAR(44), \n");
            sql.append("    FQty NUMERIC(21,8),");
            sql.append("    FAmount NUMERIC(17,4) ");
            sql.append(") \n");
            T_TMP_MatAllocLevel = NCMDbUtil.createTempTableByPool((TempTablePool)pool, (String)sql.toString());
            if (this.isOutsourcCalc) {
                sql.setLength(0);
                sql.append("insert into " + T_TMP_MatAllocLevel + " ( \n");
                sql.append("    FSourceBillEntryID, FQty, FAmount \n");
                sql.append(") \n");
                sql.append("select \n");
                sql.append("    M.FSourceBillEntryID, \n");
                sql.append("    sum(M.FQty), \n");
                sql.append("    sum(M.FAmount) \n");
                sql.append("from " + this.matTmpTbl + " M \n");
                sql.append("inner join ( \n");
                sql.append("        select distinct entry.FcostObjectID FProductID  \n");
                sql.append("        from t_cal_CostObjectRank  bill \n");
                sql.append("        inner join t_cal_costObjectRankEntry entry on bill.FID = Entry.FParentID \n");
                sql.append(" \t   where entry.FRank = " + calcLevel + " \n");
                sql.append("          AND bill.FCompanyOrg = '").append(companyId).append("' AND bill.FCalculatePeriod = '").append(periodID).append("' \n");
                sql.append("          AND bill.FLLCType = 0 \n");
                sql.append(") P \n");
                sql.append("    on P.FProductID = M.FMaterialID \n");
                sql.append("where M.FIsDirect = 0 \n");
                sql.append("     and M.FIsreWork = 0 \n");
                sql.append("group by M.FSourceBillEntryID \n");
            } else {
                sql.setLength(0);
                sql.append("insert into " + T_TMP_MatAllocLevel + " ( \n");
                sql.append("    FSourceBillEntryID, FQty, FAmount \n");
                sql.append(") \n");
                sql.append("select \n");
                sql.append("    M.FSourceBillEntryID, \n");
                sql.append("    sum(M.FQty), \n");
                sql.append("    sum(M.FAmount) \n");
                sql.append("from " + this.matTmpTbl + " M \n");
                sql.append("inner join ( \n");
                sql.append("    select distinct FProductID, FLot \n");
                sql.append("    from ").append(this.getCostCalPrdDetailResult()).append(" \n");
                sql.append("    where FCalcLevel = " + calcLevel + " \n");
                sql.append(") P \n");
                sql.append("    on P.FProductID = M.FMaterialID and isnull(P.FLot,'null') = isnull(M.FLot,'null')\n");
                sql.append("where M.FIsDirect = 0 \n");
                sql.append("     and M.FIsreWork = 0 \n");
                sql.append("group by M.FSourceBillEntryID \n");
            }
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)pool, (String)T_TMP_MatAllocLevel, (String)"FSourceBillEntryID ASC", (boolean)false, (boolean)false);
            sb.append("Select \n");
            sb.append("\t   entry.FID FID, \n");
            sb.append("\t   (entry.FBaseQty-S.FQty) As FQtyDiff, \n");
            sb.append("\t   (entry.FActualCost-S.FAmount) As FAmountDiff \n");
            sb.append("FROM T_IM_MaterialReqBillEntry entry \n");
            sb.append("INNER JOIN " + T_TMP_MatAllocLevel + " S ON S.FSourceBillEntryID = entry.FID \n");
            sb.append("where (entry.FBaseQty <> S.FQty or entry.FActualCost <> S.FAmount) \n");
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs.size() != 0) break block8;
            SQLUtils.cleanup((ResultSet)rs, pstmt, conn);
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)T_TMP_MatAllocLevel);
            return;
        }
        try {
            sb.delete(0, sb.length());
            sb.append("UPDATE ").append(this.matTmpTbl).append(" SET FQty = (FQty + ?), FAmount = (FAmount + ?) ").append('\n').append("WHERE FID = (").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(this.matTmpTbl).append('\n').append("\tWHERE FSourceBillEntryID = ? ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(") ");
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sb.toString());
            while (rs.next()) {
                pstmt.setBigDecimal(1, rs.getBigDecimal("FQtyDiff"));
                pstmt.setBigDecimal(2, rs.getBigDecimal("FAmountDiff"));
                pstmt.setString(3, rs.getString("FID"));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, T_TMP_MatAllocLevel);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)T_TMP_MatAllocLevel);
    }

    private String initMatAllocTmpTbl() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        Object value = this._param.get("isUseSystemTempTable");
        String calcLevel = (String)this._param.get("calcLevel");
        String companyID = (String)this._param.get("companyId");
        String periodID = (String)this._param.get("periodId");
        this._globalConnection = (Connection)this._param.get("globalConnection");
        this._pool = TempTablePool.getInstance((Context)ctx);
        if (value != null && value instanceof Boolean) {
            this.isUseSystemTempTable = (Boolean)value;
        }
        String matAllocTmpTbl = "";
        StringBuffer sb = new StringBuffer();
        sb.append("Create Table matAllocTmpTbl ( \n");
        sb.append(" FID VARCHAR(44) NOT NULL,FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44), \n");
        sb.append(" FSourceBillID VARCHAR(44),FSourceBillEntryID VARCHAR(44),FMaterialID VARCHAR(44),FLot NVARCHAR(80),\n");
        sb.append(" FAllocStdData NUMERIC(24,12),FQty NUMERIC(21,8),FCommonQty NUMERIC(21,8),FAssistQty NUMERIC(21,8),\n");
        sb.append(" FPrice NUMERIC(21,8),FAmount NUMERIC(17,4),FIsDirect INT, AllocBillType VARCHAR(4),FIsRework INT NOT NULL DEFAULT 0,\n");
        sb.append(" FAdminOrgUnitID varchar(44),FWarehouseID varchar(44))\n");
        try {
            String T_NCM_CalProduct = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_CostCalPrdDetailResult");
            matAllocTmpTbl = this._pool.createTempTable(sb.toString());
            this._pool.createIndex(matAllocTmpTbl, "FID", true, false);
            this._pool.createIndex(matAllocTmpTbl, "FCostCenterID,FCostObjectID", false, false);
            this._pool.createIndex(matAllocTmpTbl, "FFSourceBillID ASC,FSourceBillEntryID", false, false);
            if (this.isOutsourcCalc) {
                sb.setLength(0);
                sb.append(" Insert Into ").append(matAllocTmpTbl);
                sb.append(" (FID,FCostCenterID,FCostObjectID,FCostItemID, \n");
                sb.append("  FSourceBillID,FSourceBillEntryID,FMaterialID,FLot, \n");
                sb.append("  FAllocStdData,FQty,FCommonQty,FAssistQty,\n");
                sb.append("  FPrice,FAmount,FIsDirect,AllocBillType,FIsRework, \n");
                sb.append("  FAdminOrgUnitID,FWarehouseID \n");
                sb.append(" ) \n");
                sb.append(" select \n");
                sb.append("  FID,FCostCenterID,FCostObjectID,FCostItemID, \n");
                sb.append("  FSourceBillID,FSourceBillEntryID,FMaterialID,FLot, \n");
                sb.append("  FAllocStdData,FQty,FCommonQty,FAssistQty,\n");
                sb.append("  FPrice,FAmount,FIsDirect,AllocBillType,FIsRework, \n");
                sb.append("  FAdminOrgUnitID,FWarehouseID \n");
                sb.append(" From ").append(this.getTblResult()).append(" matAll \n");
                sb.append(" Where exists (select 1 from t_cal_CostObjectRank  bill \n");
                sb.append("        inner join t_cal_costObjectRankEntry entry on bill.FID = Entry.FParentID \n");
                sb.append(" \t   where entry.FcostObjectID = matAll.FMaterialID AND entry.FRank = " + calcLevel + " \n");
                sb.append("          AND bill.FCompanyOrg = '").append(companyID).append("' AND bill.FCalculatePeriod = '").append(periodID).append("' \n");
                sb.append("          AND bill.FLLCType = 0 \n");
                sb.append("               ) \n");
            } else {
                sb.setLength(0);
                sb.append(" Insert Into ").append(matAllocTmpTbl);
                sb.append(" (FID,FCostCenterID,FCostObjectID,FCostItemID, \n");
                sb.append("  FSourceBillID,FSourceBillEntryID,FMaterialID,FLot, \n");
                sb.append("  FAllocStdData,FQty,FCommonQty,FAssistQty,\n");
                sb.append("  FPrice,FAmount,FIsDirect,AllocBillType,FIsRework, \n");
                sb.append("  FAdminOrgUnitID,FWarehouseID \n");
                sb.append(" ) \n");
                sb.append(" select \n");
                sb.append("  FID,FCostCenterID,FCostObjectID,FCostItemID, \n");
                sb.append("  FSourceBillID,FSourceBillEntryID,FMaterialID,FLot, \n");
                sb.append("  FAllocStdData,FQty,FCommonQty,FAssistQty,\n");
                sb.append("  FPrice,FAmount,FIsDirect,AllocBillType,FIsRework, \n");
                sb.append("  FAdminOrgUnitID,FWarehouseID \n");
                sb.append(" From ").append(this.getTblResult()).append(" matAll \n");
                sb.append(" Where exists (select 1 From ").append(T_NCM_CalProduct).append(" prd \n");
                sb.append("                 where matAll.FMaterialID = prd.FProductID and prd.FCalcLevel = ").append(calcLevel).append(" \n");
                sb.append("               ) \n");
            }
            NCMDbUtil.execute((Context)ctx, (String)sb.toString());
            sb.setLength(0);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION);
        }
        return matAllocTmpTbl;
    }
}

