/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.ICostItem;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractNCMDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)AbstractNCMDataImport.class.getName());
    protected final String ENTRY_PREFIX = "entries";
    private FilterInfo costItemFilter = null;
    private Map costItemMap = null;

    protected void prepareImport(Context ctx, IObjectValue info, Hashtable hsData) throws BOSException {
        this.prepareImport(ctx, info, hsData, null);
    }

    protected void prepareImport(Context ctx, IObjectValue info, Hashtable hsData, String prefix) throws BOSException {
        this.verifyEmpty(ctx, hsData);
        BOSObjectType type = info.getBOSType();
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
        PropertyCollection properties = entity.getPropertiesRuntime();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo prop = properties.get(i);
            String name = prop.getName();
            if (name == null) continue;
            String importKey = null;
            importKey = EmptyUtil.isEmpty((String)prefix) ? name : prefix + "." + name;
            Object data = this.getData(hsData, importKey);
            if (data == null || EmptyUtil.isEmpty((String)data.toString())) continue;
            if (prop instanceof LinkPropertyInfo) {
                IObjectValue value = null;
                LinkPropertyInfo new_name = (LinkPropertyInfo)prop;
                EntityObjectInfo sobj = new_name.getRelationship().getSupplierObject();
                BOSObjectType sobjtype = sobj.getType();
                IObjectCollection obj = this.getCollectionByNumber(ctx, data, sobjtype);
                if (obj != null && obj.size() == 1) {
                    value = obj.getObject(0);
                    info.put(name, (Object)value);
                    continue;
                }
                if (obj == null || obj.size() == 0) {
                    throw new BOSException("\u5b57\u6bb5" + sobj.getAlias() + "\u4e2d\u7f16\u7801\u4e3a" + data + "\u7684\u6570\u636e\u4e0d\u5b58\u5728");
                }
            }
            if (!(prop instanceof OwnPropertyInfo)) continue;
            OwnPropertyInfo new_name = (OwnPropertyInfo)prop;
            DataType datatype = new_name.getDataType();
            if (datatype == DataType.STRING) {
                info.setString(name, this.getString(data));
                continue;
            }
            if (datatype == DataType.DATE) {
                info.setDate(name, this.getDate(data));
                continue;
            }
            if (datatype == DataType.TIMESTAMP) {
                info.setDate(name, this.getDate(data));
                continue;
            }
            if (datatype == DataType.DECIMAL) {
                info.setBigDecimal(name, this.getAmount(data));
                continue;
            }
            if (datatype == DataType.INTEGER) {
                info.setInt(name, this.getInt(data));
                continue;
            }
            if (datatype != DataType.ENUM) continue;
            this.checkEnumData(data);
        }
    }

    private void verifyEmpty(Context ctx, Hashtable hsData) throws BOSException {
        String templateNum = this.getTemplateNumber();
        if (EmptyUtil.isEmpty((String)templateNum)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)templateNum));
        view.setFilter(filter);
        DIETemplateCollection tepleteColl = DIETemplateFactory.getLocalInstance((Context)ctx).getDIETemplateCollection(view);
        if (tepleteColl.size() == 0) {
            return;
        }
        DIETemplateInfo teplateInfo = tepleteColl.get(0);
        DIETemplateFieldEntryCollection entryColl = teplateInfo.getFieldEntries();
        for (DIETemplateFieldEntryInfo entry : entryColl) {
            String fieldNum = entry.getNumber();
            boolean isRequired = entry.isIsNeed();
            Object data = ((DataToken)hsData.get((Object)fieldNum)).data;
            if (!isRequired || !EmptyUtil.isEmpty((Object)data)) continue;
            String fieldName = entry.getName();
            throw new BOSException("\u5b57\u6bb5:" + fieldName + " \u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected String getTemplateNumber() {
        return "";
    }

    private IObjectCollection getCollectionByNumber(Context ctx, Object data, BOSObjectType sobjtype) {
        IObjectCollection obj = null;
        try {
            obj = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(sobjtype, "select * where number ='" + data + "' or name=''");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return obj;
    }

    public Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    protected BigDecimal getAmount(Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return new BigDecimal("0");
        }
        BigDecimal value = null;
        try {
            value = TypeConversionUtils.objToBigDecimal((Object)data);
        }
        catch (Exception e) {
            throw new BOSException(data + "\u6570\u503c\u8f6c\u6362\u51fa\u9519\uff01");
        }
        return value;
    }

    protected int getInt(Object data) throws BOSException {
        int value;
        if (data == null || data.toString().trim().length() == 0) {
            return 0;
        }
        try {
            value = TypeConversionUtils.objToInt((Object)data);
        }
        catch (Exception e) {
            throw new BOSException(data + " \u6570\u503c\u8f6c\u6362\u51fa\u9519\uff01");
        }
        return value;
    }

    private void checkEnumData(Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return;
        }
        try {
            TypeConversionUtils.objToInt((Object)data);
        }
        catch (Exception e) {
            throw new BOSException(data + "\u6570\u503c\u8f6c\u6362\u51fa\u9519\uff01");
        }
    }

    protected String getString(Object data) {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        return data.toString().trim();
    }

    protected Date getDate(Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        Date date = null;
        try {
            date = TypeConversionUtils.objToUtilDate((Object)data);
        }
        catch (Exception e) {
            throw new BOSException(data + "\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u65e5\u671f\u8f93\u5165\u662f\u5426\u6b63\u786e\uff01");
        }
        return date;
    }

    protected Date getDateByFeildData(String fieldName, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        Date date = null;
        try {
            date = TypeConversionUtils.objToUtilDate((Object)data);
        }
        catch (Exception e) {
            throw new BOSException(fieldName + " " + data + " \u8f6c\u6362\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u65e5\u671f\u8f93\u5165\u662f\u5426\u6b63\u786e\uff01");
        }
        return date;
    }

    protected PeriodInfo getPeriodByBizDate(Context ctx, Date date, CompanyOrgUnitInfo company) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String myString = sdf.format(date);
        try {
            date = sdf.parse(myString);
        }
        catch (ParseException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)date, CompareType.GREATER_EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        PeriodCollection pc = null;
        IPeriod ipe = PeriodFactory.getLocalInstance((Context)ctx);
        pc = ipe.getPeriodCollection(view);
        if (pc != null && pc.size() > 0) {
            return pc.get(0);
        }
        throw new BOSException(myString + " \u5728\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u5bf9\u5e94\u7684\u6838\u7b97\u671f\u95f4\uff01\u8bf7\u68c0\u67e5\u65e5\u671f\u8f93\u5165\u662f\u5426\u6b63\u786e\uff01");
    }

    protected int getIntValueByFeildData(Context ctx, String fieldName, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return 0;
        }
        int intValue = 0;
        try {
            intValue = TypeConversionUtils.objToInt((Object)data);
        }
        catch (Exception e) {
            throw new BOSException("\u8f6c\u6362 " + fieldName + " \u7684\u503c " + data + " \u51fa\u9519\uff0c\u8bf7\u68c0\u67e5 " + fieldName + " \u662f\u5426\u6b63\u786e\uff01");
        }
        return intValue;
    }

    protected int getIntValueForBooleanFeild(Context ctx, String fieldName, Object data) throws BOSException {
        int intValue = this.getIntValueByFeildData(ctx, fieldName, data);
        if (intValue == 0 || intValue == 1) {
            return intValue;
        }
        throw new BOSException(fieldName + " \u7684\u503c\u53ea\u80fd\u4e3a0\u62161\uff01");
    }

    protected BigDecimal getBigDecimalValueByFeildData(Context ctx, String fieldName, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return new BigDecimal("0");
        }
        BigDecimal value = null;
        try {
            value = TypeConversionUtils.objToBigDecimal((Object)data);
        }
        catch (Exception e) {
            throw new BOSException("\u8f6c\u6362 " + fieldName + " \u7684\u503c " + data + " \u51fa\u9519\uff0c\u8bf7\u68c0\u67e5 " + fieldName + " \u662f\u5426\u6b63\u786e\uff01");
        }
        return value;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public CostItemInfo getCostItemByNumber(Context ctx, String number) throws BOSException, EASBizException {
        if (this.costItemMap == null) {
            this.costItemMap = new HashMap();
        }
        if (this.costItemMap.containsKey(number)) {
            return (CostItemInfo)this.costItemMap.get(number);
        }
        ICostItem iCostItem = CostItemFactory.getLocalInstance((Context)ctx);
        if (this.costItemFilter == null) {
            this.costItemFilter = iCostItem.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()), "id", "CU.id");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.mergeFilter(this.costItemFilter, "and");
        view.setFilter(filter);
        CostItemCollection coll = iCostItem.getCostItemCollection(view);
        if (coll != null && coll.size() > 0) {
            CostItemInfo costItem = coll.get(0);
            this.costItemMap.put(number, costItem);
            return costItem;
        }
        throw new BOSException(this.getResource("COSTITEM_NOT_EXIST_PART1", ctx) + " " + number + " " + this.getResource("COSTITEM_NOT_EXIST_PART2", ctx));
    }

    protected String getResource(String key, Context ctx) {
        return this.getResource(key, ctx.getLocale());
    }

    protected String getResource(String key, Locale locale) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.ImportExportResource", (String)key, (Locale)locale);
    }

    public String getNotBlankString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }
}

