/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.IExpense;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.AllocStdSetByOverheadCollection;
import com.kingdee.eas.ncm.bill.AllocStdSetByOverheadFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByOverheadInfo;
import com.kingdee.eas.ncm.bill.IAllocStdSetByOverhead;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class AllocStdSetByOverheadDataImport
extends AbstractNCMDataImport {
    private CompanyOrgUnitInfo company = null;
    private CtrlUnitInfo cu = null;
    private PeriodInfo period = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AllocStdSetByOverheadFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsDataBlock, Context ctx) throws TaskExternalException {
        AllocStdSetByOverheadInfo allocStdSetByOverheadInfo = null;
        try {
            this.initOrgUnit(ctx);
            allocStdSetByOverheadInfo = this.parseData(hsDataBlock, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return allocStdSetByOverheadInfo;
    }

    private AllocStdSetByOverheadInfo parseData(Hashtable hsData, Context ctx) throws BOSException {
        AllocStdSetByOverheadInfo allocStdSetByOverheadInfo = new AllocStdSetByOverheadInfo();
        allocStdSetByOverheadInfo.setId(BOSUuid.create((BOSObjectType)allocStdSetByOverheadInfo.getBOSType()));
        allocStdSetByOverheadInfo.setCompany(this.company);
        allocStdSetByOverheadInfo.setCalculatePeriod(this.period);
        Object data = this.getData(hsData, "Expense");
        if (data != null && data.toString().trim().length() > 0) {
            try {
                IExpense iExpense = ExpenseFactory.getLocalInstance((Context)ctx);
                FilterInfo dfilter = iExpense.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()), "id", "CU.id");
                allocStdSetByOverheadInfo.setExpense(NCMDataImportUtil.getExpenseByNumber((Context)ctx, (String)this.getResource("EXPENSE_NUMBER", ctx), (String)data.toString(), (FilterInfo)dfilter));
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if ((data = this.getData(hsData, "CostCenter")) != null && data.toString().trim().length() > 0) {
            allocStdSetByOverheadInfo.setCostCenter(NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)this.getResource("COSTCENTER_NUMBER", ctx), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "AllocStd")) != null && data.toString().trim().length() > 0) {
            allocStdSetByOverheadInfo.setAllocStd(NCMDataImportUtil.getAllocStdByNumber((Context)ctx, (String)this.getResource("AllOCSTD_NUMBER", ctx), (String)data.toString()));
        }
        this.checkData(ctx, allocStdSetByOverheadInfo);
        return allocStdSetByOverheadInfo;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
            if (this.period == null) {
                try {
                    this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        AllocStdSetByOverheadInfo allocStdSetByOverheadInfo = null;
        if (coreBaseInfo instanceof AllocStdSetByOverheadInfo) {
            allocStdSetByOverheadInfo = (AllocStdSetByOverheadInfo)coreBaseInfo;
        }
        if (allocStdSetByOverheadInfo == null) {
            return;
        }
        ArrayList<CoreBaseInfo> addObjList = new ArrayList<CoreBaseInfo>();
        HashMap<String, String> updateObjects = new HashMap<String, String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this.period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)allocStdSetByOverheadInfo.getCostCenter().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("expense.id", (Object)allocStdSetByOverheadInfo.getExpense().getId().toString()));
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filter);
        try {
            IAllocStdSetByOverhead coreBase = (IAllocStdSetByOverhead)this.getController(ctx);
            AllocStdSetByOverheadCollection collection = coreBase.getAllocStdSetByOverheadCollection(eviData);
            String allocStdInfo = "";
            if (allocStdSetByOverheadInfo.getAllocStd() != null) {
                allocStdInfo = allocStdSetByOverheadInfo.getAllocStd().getId().toString();
            }
            if (collection.size() != 0 && this.isSltImportUpdate()) {
                AllocStdSetByOverheadInfo Info = collection.get(0);
                updateObjects.put(Info.getId().toString(), allocStdInfo);
            } else if (!this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            } else if (collection.size() == 0 && this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            }
            coreBase.updateAllocStdSetting(updateObjects, new ArrayList(), addObjList);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String allocStd = "";
            String allocStdName = "";
            if (rs.getString("AllocStd.number") != null) {
                allocStd = rs.getString("AllocStd.number");
            }
            if (rs.getString("AllocStd.name") != null) {
                allocStdName = rs.getString("AllocStd.name");
            }
            result.put("Expense", rs.getString("expense.number"));
            result.put("ExpenseName", rs.getString("expense.name"));
            result.put("CostCenter", rs.getString("CostCenter.number"));
            result.put("CostCenterName", rs.getString("CostCenter.name"));
            result.put("AllocStd", allocStd);
            result.put("AllocStdName", allocStdName);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void checkData(Context ctx, AllocStdSetByOverheadInfo allocStdSetByOverheadInfo) throws BOSException {
        this.checkExpense(ctx, allocStdSetByOverheadInfo);
        this.checkCostCenter(ctx, allocStdSetByOverheadInfo);
        this.checkAllocStd(ctx, allocStdSetByOverheadInfo);
    }

    private void checkExpense(Context ctx, AllocStdSetByOverheadInfo allocStdSetByOverheadInfo) throws BOSException {
        ExpenseInfo expense = allocStdSetByOverheadInfo.getExpense();
        if (expense == null) {
            throw new BOSException(this.getResource("EXPENSE_CHECK_ISEMPTY", ctx));
        }
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)expense.getCU().getId().toString(), (String)"4A255827", (String)expense.getId().toString(), (String)expense.getNumber(), (String)this.getResource("EXPENSE", ctx));
    }

    private void checkCostCenter(Context ctx, AllocStdSetByOverheadInfo allocStdSetByOverheadInfo) throws BOSException {
        CostCenterOrgUnitInfo costCenterInfo = allocStdSetByOverheadInfo.getCostCenter();
        if (costCenterInfo == null) {
            throw new BOSException(this.getResource("COSTCENTER_NUMBER_CANNOT_EMPTY", ctx));
        }
        if (costCenterInfo.isIsSealUp()) {
            throw new BOSException(this.getResource("COSTCENTER_ISSEALUP_PART1", ctx) + costCenterInfo.getNumber() + this.getResource("COSTCENTER_ISSEALUP_PART2", ctx));
        }
        NCMDataImportUtil.isCostCenterDelegateCurCompany((Context)ctx, (String)costCenterInfo.getId().toString(), (String)costCenterInfo.getNumber(), (String)this.company.getId().toString());
        CostCenterType costCenterType = costCenterInfo.getCostCenterType();
        if (!CostCenterType.AssistantProdDept.equals((Object)costCenterType)) {
            throw new BOSException(this.getResource("COSTCENTER_ISASSISTATNPRODEPT_PART1", ctx) + costCenterInfo.getNumber() + this.getResource("COSTCENTER_ISASSISTATNPRODEPT_PART2", ctx));
        }
    }

    private void checkAllocStd(Context ctx, AllocStdSetByOverheadInfo allocStdSetByOverheadInfo) throws BOSException {
        AllocStdInfo allocStdInfo = allocStdSetByOverheadInfo.getAllocStd();
        if (allocStdInfo == null) {
            return;
        }
        AllocStdTypeEnum allocStdType = allocStdInfo.getAllocStdType();
        if (!allocStdType.equals((Object)AllocStdTypeEnum.AUX)) {
            throw new BOSException(allocStdInfo.getNumber() + this.getResource("ALLOCSTD_CHECK_BY_OVERHEAD", ctx));
        }
    }
}

