/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostItem;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.AllocStdCollection;
import com.kingdee.eas.basedata.ncm.AllocStdFactory;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.ncm.IAllocStd;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.AllocStdSetByWIPCollection;
import com.kingdee.eas.ncm.bill.AllocStdSetByWIPFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByWIPInfo;
import com.kingdee.eas.ncm.bill.IAllocStdSetByWIP;
import com.kingdee.eas.ncm.common.AllocStdSetModeByWIPEnum;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class AllocStdSetByWIPDataImport
extends AbstractNCMDataImport {
    private CompanyOrgUnitInfo company = null;
    private CtrlUnitInfo cu = null;
    private PeriodInfo period = null;
    private AllocStdSetModeByWIPEnum setMode = AllocStdSetModeByWIPEnum.CostItemAndCostObj;
    Map costObjectMap = new HashMap();
    Map costCenterMap = new HashMap();
    Map costItemMap = new HashMap();
    Map allocStdMap = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AllocStdSetByWIPFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        AllocStdSetByWIPInfo allocStdSetByWIPInfo = null;
        try {
            this.initOrgUnit(ctx);
            allocStdSetByWIPInfo = this.parseData(hsData, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return allocStdSetByWIPInfo;
    }

    private AllocStdSetByWIPInfo parseData(Hashtable hsData, Context ctx) throws BOSException {
        AllocStdSetByWIPInfo allocStdSetByWIPInfo = new AllocStdSetByWIPInfo();
        allocStdSetByWIPInfo.setId(BOSUuid.create((BOSObjectType)allocStdSetByWIPInfo.getBOSType()));
        allocStdSetByWIPInfo.setCompany(this.company);
        allocStdSetByWIPInfo.setCalculatePeriod(this.period);
        Object data = null;
        if (this.setMode == AllocStdSetModeByWIPEnum.CostItemAndCostObj && (data = this.getData(hsData, "CostObject")) != null && data.toString().trim().length() > 0) {
            allocStdSetByWIPInfo.setCostObject(this.getCostObjectbyNumber(ctx, this.getResource("COSTOBJECT_NUMBER", ctx), data.toString(), this.company.getId().toString()));
        }
        if (this.setMode == AllocStdSetModeByWIPEnum.CostItemAndCostCenter && (data = this.getData(hsData, "CostCenter")) != null && data.toString().trim().length() > 0) {
            allocStdSetByWIPInfo.setCostCenter(this.getCostCenterbyNumber(ctx, this.getResource("COSTCENTER_NUMBER", ctx), data.toString()));
        }
        if ((data = this.getData(hsData, "CostItem")) != null && data.toString().trim().length() > 0) {
            allocStdSetByWIPInfo.setCostItem(this.getCostItemByNumber(ctx, this.getResource("COSTITEM_NUMBER", ctx), data.toString()));
        }
        if ((data = this.getData(hsData, "AllocStd")) != null && data.toString().trim().length() > 0) {
            allocStdSetByWIPInfo.setAllocStd(this.getAllocStdByNumber(ctx, this.getResource("AllOCSTD_NUMBER", ctx), data.toString()));
        }
        this.checkData(ctx, allocStdSetByWIPInfo);
        return allocStdSetByWIPInfo;
    }

    public AllocStdInfo getAllocStdByNumber(Context ctx, String fieldName, String number) throws BOSException {
        Object cacheObj = this.allocStdMap.get(number);
        if (cacheObj == null) {
            IAllocStd iAllocStd = AllocStdFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("allocStdType"));
            view.setSelector(sic);
            view.setFilter(filter);
            AllocStdCollection coll = iAllocStd.getAllocStdCollection(view);
            if (coll != null && coll.size() > 0) {
                cacheObj = coll.get(0);
                this.allocStdMap.put(number, cacheObj);
            } else {
                throw new BOSException(AllocStdSetByWIPDataImport.getExceptionMessage(ctx, fieldName));
            }
        }
        return (AllocStdInfo)cacheObj;
    }

    public CostItemInfo getCostItemByNumber(Context ctx, String fieldName, String number) throws BOSException {
        Object cacheObj = this.costItemMap.get(number);
        if (cacheObj == null) {
            ICostItem iCostItem = CostItemFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            view.setSelector(sic);
            view.setFilter(filter);
            CostItemCollection coll = iCostItem.getCostItemCollection(view);
            if (coll != null && coll.size() > 0) {
                cacheObj = coll.get(0);
                this.costItemMap.put(number, cacheObj);
            } else {
                throw new BOSException(AllocStdSetByWIPDataImport.getExceptionMessage(ctx, fieldName));
            }
        }
        return (CostItemInfo)cacheObj;
    }

    public CostObjectInfo getCostObjectbyNumber(Context ctx, String fieldName, String number, String companyID) throws BOSException {
        String key = companyID + number;
        Object cacheObj = this.costObjectMap.get(key);
        if (cacheObj == null) {
            ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("relatedType"));
            sic.add(new SelectorItemInfo("isForbiden"));
            view.setFilter(filter);
            view.setSelector(sic);
            CostObjectCollection coll = iCostObject.getCostObjectCollection(view);
            if (coll != null && coll.size() > 0) {
                cacheObj = coll.get(0);
                this.costObjectMap.put(key, cacheObj);
            } else {
                throw new BOSException(AllocStdSetByWIPDataImport.getExceptionMessage(ctx, fieldName));
            }
        }
        return (CostObjectInfo)cacheObj;
    }

    public CostCenterOrgUnitInfo getCostCenterbyNumber(Context ctx, String fieldName, String number) throws BOSException {
        Object cacheObj = this.costCenterMap.get(number);
        if (cacheObj == null) {
            ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            view.setFilter(filter);
            view.setSelector(sic);
            CostCenterOrgUnitCollection coll = iCostCenterOrgUnit.getCostCenterOrgUnitCollection(view);
            if (coll != null && coll.size() > 0) {
                cacheObj = coll.get(0);
                this.costCenterMap.put(number, cacheObj);
            } else {
                throw new BOSException(AllocStdSetByWIPDataImport.getExceptionMessage(ctx, fieldName));
            }
        }
        return (CostCenterOrgUnitInfo)cacheObj;
    }

    private static String getExceptionMessage(Context ctx, String fieldName) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"179_NCMDataImportUtil", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"180_NCMDataImportUtil", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"181_NCMDataImportUtil", (Locale)ctx.getLocale());
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
            if (this.period == null) {
                try {
                    this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (this.company != null) {
            this.setMode = NCMUtils.getAllocStdSetModeByWIP((Context)ctx, (String)this.company.getId().toString());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        AllocStdSetByWIPInfo allocStdSetByWIPInfo = null;
        if (coreBaseInfo instanceof AllocStdSetByWIPInfo) {
            allocStdSetByWIPInfo = (AllocStdSetByWIPInfo)coreBaseInfo;
        }
        if (allocStdSetByWIPInfo == null) {
            return;
        }
        ArrayList<CoreBaseInfo> addObjList = new ArrayList<CoreBaseInfo>();
        HashMap<String, String> updateObjects = new HashMap<String, String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this.period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costItem.id", (Object)allocStdSetByWIPInfo.getCostItem().getId().toString()));
        if (this.setMode == AllocStdSetModeByWIPEnum.CostItemAndCostObj) {
            filter.getFilterItems().add(new FilterItemInfo("costObject.id", (Object)allocStdSetByWIPInfo.getCostObject().getId().toString()));
        }
        if (this.setMode == AllocStdSetModeByWIPEnum.CostItemAndCostCenter) {
            filter.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)allocStdSetByWIPInfo.getCostCenter().getId().toString()));
        }
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filter);
        try {
            IAllocStdSetByWIP coreBase = (IAllocStdSetByWIP)this.getController(ctx);
            AllocStdSetByWIPCollection collection = coreBase.getAllocStdSetByWIPCollection(eviData);
            String allocStdInfo = "";
            if (allocStdSetByWIPInfo.getAllocStd() != null) {
                allocStdInfo = allocStdSetByWIPInfo.getAllocStd().getId().toString();
            }
            if (collection.size() != 0 && this.isSltImportUpdate()) {
                AllocStdSetByWIPInfo Info = collection.get(0);
                updateObjects.put(Info.getId().toString(), allocStdInfo);
            } else if (!this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            } else if (collection.size() == 0 && this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            }
            HashMap<String, AllocStdSetModeByWIPEnum> paramEx = new HashMap<String, AllocStdSetModeByWIPEnum>();
            paramEx.put("SetMode", this.setMode);
            this.updateAllocStdSetting(ctx, updateObjects, addObjList, paramEx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void updateAllocStdSetting(Context ctx, Map data, ArrayList addObjList, Map paramEx) throws BOSException, EASBizException {
        if (!(data != null && data.size() > 0 || addObjList != null && addObjList.size() > 0)) {
            return;
        }
        String sql = "UPDATE T_NCM_AllocStdSetByWIP SET FAllocStdID=? WHERE FID=? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            if (data != null && data.entrySet() != null) {
                for (Map.Entry entry : data.entrySet()) {
                    String id = entry.getKey().toString();
                    String allocStd = entry.getValue() == null ? null : entry.getValue().toString();
                    pstmt.setString(1, allocStd);
                    pstmt.setString(2, id);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = null;
        String companyID = null;
        if (addObjList != null && addObjList.size() > 0) {
            companyID = ((AllocStdSetByWIPInfo)addObjList.get(0)).getCompany().getId().toString();
            periodInfo = ibiz.getCacheCurrentPeriod(1001, companyID);
        }
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("INSERT INTO T_NCM_AllocStdSetByWIP(").append("FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,").append("FControlUnitID,FNumber,FBizDate,FHandlerID,FDescription,").append("FHasEffected,FAuditorID,FSourceBillID,FSourceFunction,").append("FCompanyID,FCalculatePeriodID,FCostObjectID,FCostCenterID,FCostItemID,FAllocStdID").append(")").append("VALUES(?,?,GETDate(),?,GETDate(),?,GETDate(),?,?,?,?,?,?,?,?,?,?,?,?,?)");
        PreparedStatement pstmtInsert = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sqlInsert.toString());
            if (addObjList != null) {
                for (int i = 0; i < addObjList.size(); ++i) {
                    pstmtInsert.setString(1, ((AllocStdSetByWIPInfo)addObjList.get(i)).getId().toString());
                    pstmtInsert.setString(2, UserInfo2.getId().toString());
                    pstmtInsert.setString(3, UserInfo2.getId().toString());
                    pstmtInsert.setString(4, DefaultCU.getId().toString());
                    pstmtInsert.setString(5, null);
                    pstmtInsert.setString(6, UserInfo2.getId().toString());
                    pstmtInsert.setString(7, "");
                    pstmtInsert.setString(8, "1");
                    pstmtInsert.setString(9, null);
                    pstmtInsert.setString(10, "");
                    pstmtInsert.setString(11, "");
                    pstmtInsert.setString(12, companyID);
                    pstmtInsert.setString(13, periodInfo.getId().toString());
                    pstmtInsert.setString(14, ((AllocStdSetByWIPInfo)addObjList.get(i)).getCostObject() == null ? null : ((AllocStdSetByWIPInfo)addObjList.get(i)).getCostObject().getId().toString());
                    pstmtInsert.setString(15, ((AllocStdSetByWIPInfo)addObjList.get(i)).getCostCenter() == null ? null : ((AllocStdSetByWIPInfo)addObjList.get(i)).getCostCenter().getId().toString());
                    pstmtInsert.setString(16, ((AllocStdSetByWIPInfo)addObjList.get(i)).getCostItem().getId().toString());
                    if (((AllocStdSetByWIPInfo)addObjList.get(i)).getAllocStd() == null) {
                        pstmtInsert.setString(17, null);
                    } else {
                        pstmtInsert.setString(17, ((AllocStdSetByWIPInfo)addObjList.get(i)).getAllocStd().getId().toString());
                    }
                    pstmtInsert.addBatch();
                }
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
        AllocStdSetModeByWIPEnum theSetMode = null;
        try {
            theSetMode = NCMUtils.getAllocStdSetModeByWIP((Context)ctx, (String)context.getCurrentCompany().getId().toString());
        }
        catch (BOSException e1) {
            throw new TaskExternalException("\u8bfb\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e1);
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String allocStd = "";
            String allocStdName = "";
            if (rs.getString("AllocStd.number") != null) {
                allocStd = rs.getString("AllocStd.number");
            }
            if (rs.getString("AllocStd.name") != null) {
                allocStdName = rs.getString("AllocStd.name");
            }
            if (theSetMode == AllocStdSetModeByWIPEnum.CostItemAndCostObj) {
                result.put("CostObject", rs.getString("costObject.number"));
                result.put("CostObjectName", rs.getString("costObject.name"));
            }
            if (theSetMode == AllocStdSetModeByWIPEnum.CostItemAndCostCenter) {
                result.put("CostCenter", rs.getString("costCenter.number"));
                result.put("CostCenterName", rs.getString("costCenter.name"));
            }
            result.put("CostItem", rs.getString("CostItem.number"));
            result.put("CostItemName", rs.getString("CostItem.name"));
            result.put("AllocStd", allocStd);
            result.put("AllocStdName", allocStdName);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void checkData(Context ctx, AllocStdSetByWIPInfo allocStdSetByWIPInfo) throws BOSException {
        if (this.setMode == AllocStdSetModeByWIPEnum.CostItemAndCostObj) {
            this.checkCostObject(ctx, allocStdSetByWIPInfo);
        }
        if (this.setMode == AllocStdSetModeByWIPEnum.CostItemAndCostCenter) {
            this.checkCostCenter(ctx, allocStdSetByWIPInfo);
        }
        this.checkCostItem(ctx, allocStdSetByWIPInfo);
        this.checkAllocStd(ctx, allocStdSetByWIPInfo);
    }

    private void checkCostObject(Context ctx, AllocStdSetByWIPInfo allocStdSetByWIPInfo) throws BOSException {
        CostObjectInfo costObject = allocStdSetByWIPInfo.getCostObject();
        if (costObject == null) {
            throw new BOSException(this.getResource("COSTOBJECT_NUMBER_CANNOT_EMPTY", ctx));
        }
        String costObjectCompId = costObject.getCompany().getId().toString();
        String companyId = this.company.getId().toString();
        if (!companyId.equals(costObjectCompId)) {
            throw new BOSException(costObject.getNumber() + this.getResource("COSTOBJECT_CHECK_CU", ctx));
        }
        CORelatedType relatedType = costObject.getRelatedType();
        boolean isForbiden = costObject.isIsForbiden();
        if (isForbiden || !CORelatedType.Product.equals((Object)relatedType)) {
            throw new BOSException(costObject.getNumber() + this.getResource("ALLOCSTD_ISPRODUCT", ctx));
        }
    }

    private void checkCostItem(Context ctx, AllocStdSetByWIPInfo allocStdSetByWIPInfo) throws BOSException {
        CostItemInfo costItemInfo = allocStdSetByWIPInfo.getCostItem();
        if (costItemInfo == null) {
            throw new BOSException(this.getResource("COSTITEM_NUMBER_CANNOT_EMPTY", ctx));
        }
    }

    private void checkAllocStd(Context ctx, AllocStdSetByWIPInfo allocStdSetByWIPInfo) throws BOSException {
        AllocStdInfo allocStdInfo = allocStdSetByWIPInfo.getAllocStd();
        if (allocStdInfo == null) {
            return;
        }
        AllocStdTypeEnum allocStdType = allocStdInfo.getAllocStdType();
        if (!allocStdType.equals((Object)AllocStdTypeEnum.WIPSTD)) {
            throw new BOSException(allocStdInfo.getNumber() + this.getResource("ALLOCSTD_CHECK_BY_WIP", ctx));
        }
    }

    private void checkCostCenter(Context ctx, AllocStdSetByWIPInfo allocStdSetByWIPInfo) throws BOSException {
        CostCenterOrgUnitInfo costCenterInfo = allocStdSetByWIPInfo.getCostCenter();
        if (costCenterInfo == null) {
            throw new BOSException(this.getResource("COSTCENTER_NUMBER_CANNOT_EMPTY", ctx));
        }
        if (costCenterInfo.isIsSealUp()) {
            throw new BOSException(this.getResource("COSTCENTER_ISSEALUP_PART1", ctx) + costCenterInfo.getNumber() + this.getResource("COSTCENTER_ISSEALUP_PART2", ctx));
        }
        NCMDataImportUtil.isCostCenterDelegateCurCompany((Context)ctx, (String)costCenterInfo.getId().toString(), (String)costCenterInfo.getNumber(), (String)this.company.getId().toString());
        CostCenterType costCenterType = costCenterInfo.getCostCenterType();
        if (CostCenterType.AssistantProdDept.equals((Object)costCenterType)) {
            throw new BOSException(this.getResource("COSTCENTER_ISASSISTATNPRODEPT_PART1", ctx) + costCenterInfo.getNumber() + this.getResource("COSTCENTER_ISASSISTATNPRODEPT_PART2", ctx));
        }
    }
}

