/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectEntryFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.ByProductUnitCostCollection;
import com.kingdee.eas.ncm.bill.ByProductUnitCostFactory;
import com.kingdee.eas.ncm.bill.ByProductUnitCostInfo;
import com.kingdee.eas.ncm.bill.IByProductUnitCost;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;

public class ByProductUnitCostDataImport
extends AbstractNCMDataImport {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ByProductUnitCostFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        ByProductUnitCostInfo info = null;
        try {
            info = this.parse(ctx, hsData);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("material.number", this.getNotBlankString(rs.getString("material.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("material.name")));
            result.put("costItem.number", this.getNotBlankString(rs.getString("costItem.number")));
            result.put("costItem.name", this.getNotBlankString(rs.getString("costItem.name")));
            result.put("unitCost", this.getNotBlankString(rs.getString("unitCost")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getStringValue(Hashtable hsData, String fieldName) {
        String value;
        Object data = this.getData(hsData, fieldName);
        if (data != null && (value = data.toString().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    private ByProductUnitCostInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException, TaskExternalException {
        BigDecimal unitCost;
        ByProductUnitCostInfo info = new ByProductUnitCostInfo();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = company.getId().toString();
        info.setCompany(company);
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        info.setCalculatePeriod(period);
        String value = this.getStringValue(hsData, "material.number");
        if (value == null) {
            throw new BOSException(this.getResource("MATERIAL_NUMBER_CANNOT_EMPTY", ctx));
        }
        MaterialInfo material = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)this.getResource("MATERIAL_NUMBER", ctx), (String)value);
        info.setMaterial(material);
        this.checkMaterialByClassCO(ctx, info);
        value = this.getStringValue(hsData, "costItem.number");
        if (value == null) {
            throw new BOSException(this.getResource("COSTITEM_NUMBER_CANNOT_EMPTY", ctx));
        }
        CostItemInfo costItem = this.getCostItemByNumber(ctx, value);
        info.setCostItem(costItem);
        Object data = this.getData(hsData, "unitCost");
        if (data != null && data.toString().trim().length() > 0) {
            unitCost = this.getBigDecimalValueByFeildData(ctx, this.getResource("UNIT_COST", ctx), data);
            if (unitCost.compareTo(BigDecimal.valueOf(0L)) < 0) {
                throw new NcmBillException(NcmBillException.CHECK_UNITCOST_LESSTHAN_ZERO);
            }
        } else {
            throw new BOSException(this.getResource("UNIT_COST_CANNOT_EMPTY", ctx));
        }
        info.setUnitCost(unitCost);
        this.checkExists(ctx, info);
        return info;
    }

    private void checkMaterialByClassCO(Context ctx, ByProductUnitCostInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.company", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("parent.relatedType", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("parent.calculateMode", (Object)3));
        filter.getFilterItems().add(new FilterItemInfo("parent.isForbiden", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("isMainProduct", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("isByproduct", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("RelatedID", (Object)info.getMaterial().getId().toString()));
        boolean exist = CostObjectEntryFactory.getLocalInstance((Context)ctx).exists(filter);
        if (!exist) {
            throw new BOSException(this.getResource("MATERIAL_CHECK_ISNOT_PRODUCT_PART1", ctx) + " " + info.getMaterial().getNumber() + " " + this.getResource("MATERIAL_CHECK_ISNOT_PRODUCT_PART2", ctx));
        }
    }

    private void checkExists(Context ctx, ByProductUnitCostInfo info) throws BOSException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod", (Object)info.getCalculatePeriod().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)info.getMaterial().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costItem", (Object)info.getCostItem().getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setSelector(sic);
        ByProductUnitCostCollection coll = ((IByProductUnitCost)this.getController(ctx)).getByProductUnitCostCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                info.setId(coll.get(0).getId());
            } else {
                throw new BOSException(this.getResource("BYPRODUCTUNITCOST_CHECK_PART1", ctx) + this.getResource("BYPRODUCTUNITCOST_CHECK_PART2", ctx) + info.getMaterial().getNumber() + this.getResource("BYPRODUCTUNITCOST_CHECK_PART3", ctx) + info.getCostItem().getNumber());
            }
        }
    }
}

