/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostPropertyEnum;
import com.kingdee.eas.basedata.assistant.ICostItem;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import java.util.Hashtable;
import java.util.Locale;

public class CostItemDataImport
extends AbstractNCMDataImport {
    CtrlUnitInfo cu = null;
    boolean isCUBDControlForUpdate = false;
    boolean isCUBDControlForAdd = false;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CostItemFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        CostItemInfo costItem = null;
        try {
            this.initData(ctx);
            costItem = this.parseHead(hsData, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return costItem;
    }

    private void initData(Context ctx) throws BOSException {
        if (this.cu == null) {
            this.cu = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit();
            this.isCUBDControlForAdd = NCMDataImportUtil.isCUBDControlForAdd((Context)ctx, (String)"548C5A91", (String)this.cu.getId().toString());
            this.isCUBDControlForUpdate = NCMDataImportUtil.isCUBDControlForUpdate((Context)ctx, (String)"548C5A91", (String)this.cu.getId().toString());
        }
    }

    private void checkCUBDControlForAdd(Context ctx) throws BOSException {
        if (!this.isCUBDControlForAdd) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"70_CostItemDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkCUBDControlForUpdate(Context ctx) throws BOSException {
        if (!this.isCUBDControlForUpdate) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"71_CostItemDataImport", (Locale)ctx.getLocale()));
        }
    }

    private CostItemInfo parseHead(Hashtable hsData, Context ctx) throws BOSException, TaskExternalException {
        CostPropertyEnum costProperty;
        CostItemEnum costItemType;
        CostItemInfo info = new CostItemInfo();
        info.setCU(this.cu);
        this.dealWithTheNumberByImpMode(ctx, hsData, info);
        Object data = this.getData(hsData, "name");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"72_CostItemDataImport", (Locale)ctx.getLocale()));
        }
        info.setName(data.toString());
        data = this.getData(hsData, "ItemType");
        if (data != null && data.toString().trim().length() > 0) {
            costItemType = CostItemEnum.getEnum((String)String.valueOf(this.getIntValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"73_CostItemDataImport", (Locale)ctx.getLocale()), data)));
            if (costItemType == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"74_CostItemDataImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"75_CostItemDataImport", (Locale)ctx.getLocale()));
        }
        info.setItemType(costItemType);
        data = this.getData(hsData, "TypeTree");
        if (data != null && data.toString().trim().length() > 0) {
            info.setTypeTree(NCMDataImportUtil.getCostItemTypeTreeByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"76_CostItemDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "CostProperty")) != null && data.toString().trim().length() > 0) {
            costProperty = CostPropertyEnum.getEnum((String)String.valueOf(this.getIntValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"77_CostItemDataImport", (Locale)ctx.getLocale()), data)));
            if (costProperty == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"78_CostItemDataImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"79_CostItemDataImport", (Locale)ctx.getLocale()));
        }
        info.setCostProperty(costProperty);
        data = this.getData(hsData, "isAllocateQty");
        int isForbidenInt = this.getIntValueForBooleanFeild(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"80_CostItemDataImport", (Locale)ctx.getLocale()), data);
        info.setIsAllocateQty(isForbidenInt == 1);
        data = this.getData(hsData, "unit");
        if (data != null && data.toString().trim().length() > 0) {
            info.setUnit(NCMDataImportUtil.getMeasureUnitInfoByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"81_CostItemDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        }
        data = this.getData(hsData, "pricePrecision");
        int pricePrecision = this.getIntValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"82_CostItemDataImport", (Locale)ctx.getLocale()), data);
        if (pricePrecision < 0 || pricePrecision > 12) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"83_CostItemDataImport", (Locale)ctx.getLocale()));
        }
        info.setPricePrecision(pricePrecision);
        data = this.getData(hsData, "description");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 255) {
                info.setDescription(data.toString().substring(0, 255));
            } else {
                info.setDescription(data.toString());
            }
        }
        return info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dealWithTheNumberByImpMode(Context ctx, Hashtable hsData, CostItemInfo info) throws BOSException, TaskExternalException {
        String number = hsData.get("number").toString();
        if (number == null || number.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"84_CostItemDataImport", (Locale)ctx.getLocale()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        CostItemCollection coll = ((ICostItem)this.getController(ctx)).getCostItemCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (!this.isSltImportUpdate()) throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"87_CostItemDataImport", (Locale)ctx.getLocale()));
            this.checkCUBDControlForUpdate(ctx);
            if (!this.checkCanEdit(ctx, info, coll.get(0))) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"86_CostItemDataImport", (Locale)ctx.getLocale()));
            info.setId(coll.get(0).getId());
            info.setCU(coll.get(0).getCU());
        } else {
            this.checkCUBDControlForAdd(ctx);
        }
        info.setNumber(number);
    }

    private boolean checkCanEdit(Context ctx, CostItemInfo info, CostItemInfo compareInfo) throws BOSException {
        return NCMDataImportUtil.isDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)compareInfo.getCU().getId().toString(), (String)"548C5A91", (String)compareInfo.getId().toString());
    }
}

