/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectEntryCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.Locale;

public class CostObjectImportVerify {
    public void verifyHead(Context ctx, CoreBaseInfo head) throws BOSException {
        if (!(head instanceof CostObjectInfo)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"105_CostObjectImportVerify", (Locale)ctx.getLocale()));
        }
        CostObjectInfo info = (CostObjectInfo)head;
        if (CORelatedType.Project.equals((Object)info.getRelatedType())) {
            ProjectInfo projectInfo = NCMDataImportUtil.getProjectByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"106_CostObjectImportVerify", (Locale)ctx.getLocale()), (String)info.getNumber());
            info.setName(projectInfo.getName());
        }
        this.checkEmpty(ctx, info.getCostObjectGroup(), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"98_CostObjectDataImport", (Locale)ctx.getLocale()));
        this.checkCOGruopRelatedType(ctx, info);
        if (CORelatedType.Product.equals((Object)info.getRelatedType())) {
            this.checkEmpty(ctx, info.getCalculateMode(), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"96_CostObjectDataImport", (Locale)ctx.getLocale()));
            if (CalculateModeEnum.BYBATCH.equals((Object)info.getCalculateMode())) {
                this.checkEmpty(ctx, info.getBatchNumber(), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"107_CostObjectImportVerify", (Locale)ctx.getLocale()));
            }
        }
    }

    private void checkCOGruopRelatedType(Context ctx, CostObjectInfo info) throws BOSException {
        CORelatedType coGroupRelatedType = info.getCostObjectGroup().getRelatedType();
        if (!info.getRelatedType().equals((Object)coGroupRelatedType)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"108_CostObjectImportVerify", (Locale)ctx.getLocale()));
        }
    }

    public void verifyEntry(Context ctx, CostObjectInfo head, CostObjectEntryInfo entry) throws BOSException {
        if (CORelatedType.Product.equals((Object)head.getRelatedType())) {
            this.checkMaterialValidOrNot(ctx, head, entry);
            if (CalculateModeEnum.BYCLASS.equals((Object)head.getCalculateMode())) {
                this.checkEmpty(ctx, entry.getQuotiety(), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"109_CostObjectImportVerify", (Locale)ctx.getLocale()));
                if (entry.isIsMainProduct()) {
                    if (entry.isIsByproduct()) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"110_CostObjectImportVerify", (Locale)ctx.getLocale()));
                    }
                    if (entry.getQuotiety().doubleValue() != 1.0) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"111_CostObjectImportVerify", (Locale)ctx.getLocale()));
                    }
                } else if (entry.getQuotiety().doubleValue() < 0.0) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"112_CostObjectImportVerify", (Locale)ctx.getLocale()));
                }
            }
        }
    }

    private void checkMaterialValidOrNot(Context ctx, CostObjectInfo head, CostObjectEntryInfo entry) throws BOSException {
        MaterialCompanyInfoInfo materialCompanyInfo = NCMDataImportUtil.getMaterialCompanyInfoByMaterial((Context)ctx, (String)entry.getRelatedNumber(), (String)entry.getRelatedID().toString(), (String)head.getCompany().getId().toString());
        if (!CalculateTypeEnum.SELFMANUFACTURE.equals((Object)materialCompanyInfo.getCalculateType())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + entry.getRelatedNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"113_CostObjectImportVerify", (Locale)ctx.getLocale()));
        }
        CalculateModeEnum calculateMode = head.getCalculateMode();
        if (AccountType.SPECIAL_ACCT.equals((Object)materialCompanyInfo.getAccountType())) {
            if (CalculateModeEnum.BYCLASS.equals((Object)calculateMode)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + entry.getRelatedNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"114_CostObjectImportVerify", (Locale)ctx.getLocale()));
            }
            if (CalculateModeEnum.VARIET.equals((Object)calculateMode)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + entry.getRelatedNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"115_CostObjectImportVerify", (Locale)ctx.getLocale()));
            }
        } else if (CalculateModeEnum.BYBATCH.equals((Object)calculateMode)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + entry.getRelatedNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"116_CostObjectImportVerify", (Locale)ctx.getLocale()));
        }
    }

    private void checkEmpty(Context ctx, Object obj, String msg) throws BOSException {
        if (obj == null || "".equals(obj)) {
            throw new BOSException(msg + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"117_CostObjectImportVerify", (Locale)ctx.getLocale()));
        }
    }

    public void verifyBlock(Context ctx, CostObjectInfo head, ICostObject iCostObject) throws BOSException, EASBizException {
        CORelatedType relatedType = head.getRelatedType();
        if (CORelatedType.Product.equals((Object)relatedType)) {
            CalculateModeEnum calculateMode = head.getCalculateMode();
            CostObjectEntryCollection coll = head.getEntries();
            String materialId = null;
            if (CalculateModeEnum.BYCLASS.equals((Object)calculateMode)) {
                if (coll == null || coll.size() < 2) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"118_CostObjectImportVerify", (Locale)ctx.getLocale()));
                }
                int mainPrd = 0;
                HashMap<String, String> infoMap = new HashMap<String, String>();
                for (int i = 0; i < coll.size(); ++i) {
                    CostObjectEntryInfo entryInfo = coll.get(i);
                    String relatedId = entryInfo.getRelatedID().toString();
                    if (infoMap.containsKey(relatedId)) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"119_CostObjectImportVerify", (Locale)ctx.getLocale()));
                    }
                    infoMap.put(relatedId, relatedId);
                    if (!entryInfo.isIsMainProduct()) continue;
                    ++mainPrd;
                    materialId = relatedId;
                }
                if (mainPrd != 1) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"120_CostObjectImportVerify", (Locale)ctx.getLocale()));
                }
            } else {
                if (coll == null || coll.size() != 1) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"121_CostObjectImportVerify", (Locale)ctx.getLocale()));
                }
                materialId = head.getEntries().get(0).getRelatedID().toString();
                if (CalculateModeEnum.VARIET.equals((Object)calculateMode) && iCostObject.checkMaterialUsedOrNot(head)) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"122_CostObjectImportVerify", (Locale)ctx.getLocale()));
                }
            }
            if (head.getBomID() != null) {
                String bomMatrialId;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)head.getBomID(), CompareType.EQUALS));
                view.setFilter(filterInfo);
                IObjectValue bom = (IObjectValue)BusinessProcessUtil.getValueByBosType((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"8F409A89"), (EntityViewInfo)view);
                if (bom != null && !(bomMatrialId = bom.getObjectValue("material").getBOSUuid("id").toString()).equals(materialId)) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"123_CostObjectImportVerify", (Locale)ctx.getLocale()));
                }
            }
            head.setStdProductID(NCMDataImportUtil.getMaterialByFeild((Context)ctx, (String)"id", (String)materialId));
        } else if (CORelatedType.Overhead.equals((Object)relatedType)) {
            CostObjectEntryCollection coll = head.getEntries();
            if (coll == null || coll.size() != 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"124_CostObjectImportVerify", (Locale)ctx.getLocale()));
            }
            head.setRelatedId(coll.get(0).getRelatedID());
        }
    }
}

