/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteCollection;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteEntryInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteFactory;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteInfo;
import com.kingdee.eas.basedata.assistant.ICostObjectSuite;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class CostObjectSuiteDataImport
extends AbstractNCMDataImport {
    CompanyOrgUnitInfo company = null;
    private Map coNumberMap = new HashMap();

    public int getSubmitType() {
        return 1;
    }

    public String getMainField() {
        return "number";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CostObjectSuiteFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsDataBlock, Context ctx) throws TaskExternalException {
        if (this.company == null) {
            this.company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        CostObjectSuiteInfo head = null;
        HashMap coInSameSuite = new HashMap();
        int keyCursor = 0;
        for (int i = 0; i < hsDataBlock.size(); ++i) {
            try {
                Hashtable hsData = (Hashtable)hsDataBlock.get(i);
                if (i == 0) {
                    head = this.parseHead(hsData, ctx);
                }
                CostObjectSuiteEntryInfo entry = this.parseEntry(hsData, head, ctx, coInSameSuite);
                head.getEntry().add(entry);
            }
            catch (TaskExternalException e) {
                if (keyCursor == hsDataBlock.size() - 1) {
                    e.addEntryErrorReason(0, e.getMessage());
                } else {
                    e.addEntryErrorReason(i, e.getMessage());
                }
                if (keyCursor == 0) break;
            }
            ++keyCursor;
        }
        this.veryfyBlock(ctx, head);
        return head;
    }

    private CostObjectSuiteInfo parseHead(Hashtable hsData, Context ctx) throws TaskExternalException {
        CostObjectSuiteInfo info = new CostObjectSuiteInfo();
        info.setCompany(this.company);
        this.dealWithTheNumberByImpMode(ctx, hsData, info);
        this.dealWithTheNameByImpMode(ctx, hsData, info);
        Object data = this.getData(hsData, "description");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 80) {
                info.setDescription(data.toString().substring(0, 79));
            } else {
                info.setDescription(data.toString());
            }
        }
        return info;
    }

    private void dealWithTheNumberByImpMode(Context ctx, Hashtable hsData, CostObjectSuiteInfo info) throws TaskExternalException {
        String number = hsData.get("number").toString();
        if (number == null || number.length() <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"125_CostObjectSuiteDataImport", (Locale)ctx.getLocale()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.company.getId().toString()));
        view.setFilter(filter);
        try {
            CostObjectSuiteCollection coll = ((ICostObjectSuite)this.getController(ctx)).getCostObjectSuiteCollection(view);
            if (coll != null && coll.size() >= 1) {
                if (this.isSltImportUpdate()) {
                    info.setId(coll.get(0).getId());
                } else {
                    throw new TaskExternalException(number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"126_CostObjectSuiteDataImport", (Locale)ctx.getLocale()));
                }
            }
            info.setNumber(number);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private void dealWithTheNameByImpMode(Context ctx, Hashtable hsData, CostObjectSuiteInfo info) throws TaskExternalException {
        String name = hsData.get("name").toString();
        if (name == null || name.length() <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"127_CostObjectSuiteDataImport", (Locale)ctx.getLocale()));
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)name));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.company.getId().toString()));
            if (info.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            view.setFilter(filter);
            CostObjectSuiteCollection coll = ((ICostObjectSuite)this.getController(ctx)).getCostObjectSuiteCollection(view);
            if (coll != null && coll.size() >= 1) {
                throw new TaskExternalException(name + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"128_CostObjectSuiteDataImport", (Locale)ctx.getLocale()));
            }
            info.setName(name);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private CostObjectSuiteEntryInfo parseEntry(Hashtable hsData, CostObjectSuiteInfo head, Context ctx, Map coInSameSuite) throws TaskExternalException {
        CostObjectInfo costObject;
        String coNumber;
        CostObjectSuiteEntryInfo info = new CostObjectSuiteEntryInfo();
        Object data = this.getData(hsData, "entry.number");
        if (data != null && data.toString().trim().length() > 0) {
            coNumber = data.toString();
            if (coInSameSuite.containsKey(coNumber)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"129_CostObjectSuiteDataImport", (Locale)ctx.getLocale()));
            }
            costObject = null;
            if (this.coNumberMap.containsKey(coNumber)) {
                costObject = (CostObjectInfo)this.coNumberMap.get(coNumber);
            } else {
                try {
                    costObject = NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"68_ActualHourDataImport", (Locale)ctx.getLocale()), (String)coNumber, (String)this.company.getId().toString());
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage());
                }
                this.coNumberMap.put(coNumber, costObject);
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"65_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        coInSameSuite.put(coNumber, coNumber);
        info.setCostObject(costObject);
        data = this.getData(hsData, "entry.remark");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 80) {
                info.setModel(data.toString().substring(0, 79));
            } else {
                info.setModel(data.toString());
            }
        }
        return info;
    }

    private void veryfyBlock(Context ctx, CostObjectSuiteInfo head) throws TaskExternalException {
        if (head.getEntry().size() < 2) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"130_CostObjectSuiteDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "number", rs.getString("number"));
            this.putTable(result, "name", rs.getString("name"));
            this.putTable(result, "description", rs.getString("description"));
            this.putTable(result, "entry.number", rs.getString("costObject.number"));
            this.putTable(result, "entry.remark", rs.getString("entry.model"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.CostObjectSuiteListQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        return oldFilterInfo;
    }
}

