/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.EquivalentCoefCollection;
import com.kingdee.eas.ncm.bill.EquivalentCoefFactory;
import com.kingdee.eas.ncm.bill.EquivalentCoefInfo;
import com.kingdee.eas.ncm.bill.IEquivalentCoef;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMBatchDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class EquivalentCoefDataImport
extends AbstractNCMBatchDataImport {
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.EquivalentCoefResource";
    private FilterInfo ciDBDFilter = null;
    private String T_NCM_EquivalentCoefRange = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquivalentCoefFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.company = ContextUtil.getCurrentFIUnit((Context)ctx);
        EquivalentCoefInfo info = null;
        try {
            info = this.parse(ctx, hsData);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("costCenter.number", this.getNotBlankString(rs.getString("costCenter.number")));
            result.put("costCenter.name", this.getNotBlankString(rs.getString("costCenter.name")));
            result.put("costObject.number", this.getNotBlankString(rs.getString("costObject.number")));
            result.put("costObject.name", this.getNotBlankString(rs.getString("costObject.name")));
            result.put("storageOrgUnit.number", this.getNotBlankString(rs.getString("storageOrgUnit.number")));
            result.put("order.number", this.getNotBlankString(rs.getString("morder.number")));
            result.put("project.number", this.getNotBlankString(rs.getString("project.number")));
            result.put("track.number", this.getNotBlankString(rs.getString("track.number")));
            result.put("product.number", this.getNotBlankString(rs.getString("product.number")));
            result.put("product.name", this.getNotBlankString(rs.getString("product.name")));
            result.put("batch", this.getNotBlankString(rs.getString("costObject.batchNumber")));
            result.put("costItem.number", this.getNotBlankString(rs.getString("costItem.number")));
            result.put("costItem.name", this.getNotBlankString(rs.getString("costItem.name")));
            result.put("coefficient", this.getNotBlankString(rs.getString("coefficient")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getStringValue(Hashtable hsData, String fieldName) {
        String value;
        Object data = this.getData(hsData, fieldName);
        if (data != null && (value = data.toString().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    private EquivalentCoefInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException, TaskExternalException {
        BigDecimal coefficient;
        EquivalentCoefInfo info = new EquivalentCoefInfo();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = company.getId().toString();
        info.setCompany(company);
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)company.getId().toString());
        info.setCalculatePeriod(period);
        String value = this.getStringValue(hsData, "costCenter.number");
        if (value == null) {
            throw new BOSException(this.getResource("COSTCENTER_NUMBER_CANNOT_EMPTY", ctx));
        }
        CostCenterOrgUnitInfo costCenter = NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)this.getResource("COSTCENTER_NUMBER", ctx), (String)value);
        NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)costCenter, (String)companyId);
        info.setCostCenter(costCenter);
        CostObjectInfo costObject = this.parseCostObject(hsData, ctx);
        if (costObject != null) {
            if (costObject.isIsForbiden()) {
                throw new BOSException(this.getResource(ctx, "CostObjectHasForbidCanNotImport", new Object[]{costObject.getNumber()}));
            }
        } else {
            throw new BOSException(this.getResource("COSTOBJECT_NUMBER_CANNOT_EMPTY", ctx));
        }
        info.setCostObject(costObject);
        value = this.getStringValue(hsData, "costItem.number");
        if (value == null) {
            throw new BOSException(this.getResource("COSTITEM_NUMBER_CANNOT_EMPTY", ctx));
        }
        CostItemInfo costItem = this.getCostItemByNumber(ctx, value);
        info.setCostItem(costItem);
        Object data = this.getData(hsData, "coefficient");
        if (data != null && data.toString().trim().length() > 0) {
            coefficient = this.getBigDecimalValueByFeildData(ctx, this.getResource("COEFFICIENT", ctx), data);
            if (coefficient.compareTo(BigDecimal.valueOf(0L)) < 0 || coefficient.compareTo(BigDecimal.valueOf(1L)) > 0) {
                throw new NcmBillException(NcmBillException.CHECK_COEF_BETWEEN_ZERO_ONE);
            }
        } else {
            throw new BOSException(this.getResource("COEFFICIENT_CANNOT_EMPTY", ctx));
        }
        info.setCoefficient(coefficient);
        this.checkExists(ctx, info);
        return info;
    }

    private CostObjectInfo parseCostObject(Hashtable hsData, Context ctx) throws BOSException {
        String companyId = this.company.getId().toString();
        Object storageData = this.getData(hsData, "storageOrgUnit.number");
        String storageOrgUnitNumber = null;
        if (storageData != null && storageData.toString().trim().length() > 0) {
            storageOrgUnitNumber = storageData.toString().trim();
        }
        Object costObjectData = this.getData(hsData, "costObject.number");
        String costObjectNumber = null;
        if (costObjectData != null && costObjectData.toString().trim().length() > 0) {
            costObjectNumber = costObjectData.toString().trim();
        }
        Object orderData = this.getData(hsData, "order.number");
        String orderNumber = null;
        if (orderData != null && orderData.toString().trim().length() > 0) {
            orderNumber = orderData.toString().trim();
        }
        Object productData = this.getData(hsData, "product.number");
        String productNumber = null;
        if (productData != null && productData.toString().trim().length() > 0) {
            productNumber = productData.toString().trim();
        }
        Object batchData = this.getData(hsData, "batch");
        String batch = null;
        if (batchData != null && batchData.toString().trim().length() > 0) {
            batch = batchData.toString().trim();
        }
        try {
            if (costObjectNumber != null) {
                return NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)this.getResource(ctx, "CostObjectNumber"), (String)costObjectNumber, (String)companyId);
            }
            if (orderNumber != null) {
                return NCMDataImportUtil.getCostObjectByOrder((Context)ctx, (String)companyId, (String)storageOrgUnitNumber, (String)orderNumber, (String)batch);
            }
            if (productNumber != null) {
                return NCMDataImportUtil.getCostObjectByProduct((Context)ctx, (String)companyId, (String)productNumber, (String)batch);
            }
            throw new BOSException(this.getResource(ctx, "CostObjectOrderMaterialCanNotAllEmpty"));
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkExists(Context ctx, EquivalentCoefInfo info) throws BOSException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod", (Object)info.getCalculatePeriod().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenter", (Object)info.getCostCenter().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costObject", (Object)info.getCostObject().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costItem", (Object)info.getCostItem().getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setSelector(sic);
        EquivalentCoefCollection coll = ((IEquivalentCoef)this.getController(ctx)).getEquivalentCoefCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                info.setId(coll.get(0).getId());
            } else {
                throw new BOSException(this.getResource("EQUIVALENTCOEF_CHECK_PART1", ctx) + this.getResource("EQUIVALENTCOEF_CHECK_PART2", ctx) + info.getCostCenter().getNumber() + this.getResource("EQUIVALENTCOEF_CHECK_PART3", ctx) + info.getCostObject().getNumber() + this.getResource("EQUIVALENTCOEF_CHECK_PART4", ctx) + info.getCostItem().getNumber());
            }
        }
    }

    protected String getResource(Context ctx, String resName) {
        return this.getResource(ctx, resName, null);
    }

    protected String getResource(Context ctx, String resName, Object[] params) {
        if (params != null) {
            return MessageFormat.format(ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale()), params);
        }
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale());
    }

    protected void doBeforeProcessData(Context ctx) throws Exception {
        super.doBeforeProcessData(ctx);
        StringBuffer ksql = new StringBuffer();
        ksql.append("Create Table T_NCM_EquivalentCoef ( ");
        ksql.append("FID VARCHAR(44) NOT NULL , \n ");
        ksql.append("FCostCenterID VARCHAR(44), \n ");
        ksql.append("FCostObjectID VARCHAR(44), \n ");
        ksql.append("FCostItemID VARCHAR(44)) \n ");
        this.T_NCM_EquivalentCoefRange = NCMDbUtil.createTempTable((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append(" Insert Into ").append(this.T_NCM_EquivalentCoefRange).append(" \n");
        ksql.append("       (FID,FCostCenterID,FCostObjectID,FCostItemID) \n");
        ksql.append(" Select FID,FCostCenterID,FCostObjectID,FCostItemID \n");
        ksql.append(" From T_NCM_EquivalentCoef \n");
        ksql.append(" Where FCompanyID = '" + this.companyId + "' \n");
        ksql.append("   And FCalculatePeriodID = '" + this.periodId + "' \n");
        NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndex((Context)ctx, (String)this.T_NCM_EquivalentCoefRange, (String)"FCostCenterID,FCostObjectID,FCostItemID", (boolean)false, (boolean)false);
    }

    protected String buildTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T ( \n");
        sql.append("     FID varchar(44), \n");
        this.buildCostCenterSQL(sql);
        this.buildCostObjectSQL(sql);
        this.buildStorageSQL(sql);
        this.buildOrderSQL(sql);
        this.buildProductSQL(sql);
        this.buildCostItemSQL(sql);
        sql.append("     FBatch nvarchar(255), \n");
        sql.append("     FCoefficient decimal(21,8), \n");
        sql.append("     FIndex int default(0) \n");
        sql.append(") \n");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessBlockData(Context ctx, RecordCollection coll) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + this.tempTable + " ( \n");
        sql.append("    FCostCenterNumber, \n");
        sql.append("    FCostObjectNumber, \n");
        sql.append("    FStorageOrgUnitNumber, \n");
        sql.append("    FOrderNumber, \n");
        sql.append("    FProductNumber, \n");
        sql.append("    FBatch, \n");
        sql.append("    FCostItemNumber, \n");
        sql.append("    FCoefficient, \n");
        sql.append("    FIndex \n");
        sql.append(") values (\n");
        sql.append("    ?, ?, ?, ?, ?, ?, ?, ?, ? \n");
        sql.append(") \n");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < coll.size(); ++i) {
                SimpleRecord record = (SimpleRecord)coll.get(i);
                ++this.index;
                String costCenterNumber = null;
                String costObjectNumber = null;
                String storageOrgUnitNumber = null;
                String orderNumber = null;
                String productNumber = null;
                String batch = null;
                String costItemNumber = null;
                costCenterNumber = this.getData(record, "costCenter.number");
                if (costCenterNumber == null) {
                    this.onDataError(this.index, "\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                    continue;
                }
                costObjectNumber = this.getData(record, "costObject.number");
                if (costObjectNumber == null) {
                    storageOrgUnitNumber = this.getData(record, "storageOrgUnit.number");
                    orderNumber = this.getData(record, "order.number");
                    if (orderNumber != null) {
                        if (storageOrgUnitNumber == null) {
                            this.onDataError(this.index, "\u901a\u8fc7\u8ba2\u5355\u627e\u6210\u672c\u5bf9\u8c61\uff0c\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                            continue;
                        }
                    } else {
                        productNumber = this.getData(record, "product.number");
                        if (productNumber == null) {
                            this.onDataError(this.index, "\u6210\u672c\u5bf9\u8c61\uff0c\u8ba2\u5355\uff0c\u4ea7\u54c1\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002");
                            continue;
                        }
                    }
                }
                batch = this.getData(record, "batch");
                costItemNumber = this.getData(record, "costItem.number");
                if (costItemNumber == null) {
                    this.onDataError(this.index, "\u6210\u672c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                    continue;
                }
                String strCoefficient = this.getData(record, "coefficient");
                if (strCoefficient == null) {
                    this.onDataError(this.index, "\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                    continue;
                }
                BigDecimal coefficient = null;
                try {
                    coefficient = new BigDecimal(strCoefficient);
                }
                catch (Exception e) {
                    this.onDataError(this.index, "\u7cfb\u6570\u8f6c\u6362\u53d1\u751f\u9519\u8bef\u3002");
                    continue;
                }
                if (coefficient.compareTo(BigDecimal.valueOf(0L)) < 0 || coefficient.compareTo(BigDecimal.valueOf(1L)) > 0) {
                    this.onDataError(this.index, "\u7cfb\u6570\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u96f6\u4e14\u5c0f\u4e8e\u7b49\u4e8e1\u3002");
                    continue;
                }
                int j = 0;
                pstmt.setString(++j, costCenterNumber);
                pstmt.setString(++j, costObjectNumber);
                pstmt.setString(++j, storageOrgUnitNumber);
                pstmt.setString(++j, orderNumber);
                pstmt.setString(++j, productNumber);
                pstmt.setString(++j, batch);
                pstmt.setString(++j, costItemNumber);
                pstmt.setBigDecimal(++j, coefficient);
                pstmt.setInt(++j, this.index);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        NCMDbUtil.createTempTableIndex((Context)ctx, (String)this.tempTable, (String)"FIndex", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)ctx, (String)this.tempTable, (String)"FCostCenterID,FCostObjectID,FCostItemID", (boolean)false, (boolean)false);
    }

    protected int doProcessData(Context ctx) throws Exception {
        this.fillAndVerifyCostCenter(ctx);
        this.fillAndVerifyCostObject(ctx);
        this.fillAndVerifyStorage(ctx);
        this.fillAndVerifyOrder(ctx);
        this.fillAndVerifyProduct(ctx);
        this.fillAndVerifyCostItem(ctx);
        this.findCostObjectByOrder(ctx);
        this.findCostObjectByProduct(ctx);
        this.verifyExcelDuplicate(ctx);
        this.verifyDuplicate(ctx);
        return this.submitData(ctx);
    }

    private void verifyExcelDuplicate(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select * from " + this.tempTable + " t \n");
        sql.append("where ( \n");
        sql.append("    select count(*) from " + this.tempTable + " tt \n");
        sql.append("    where tt.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and tt.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and tt.FCostItemID = t.FCostItemID \n");
        sql.append(") > 1 \n");
        sql.append("order by FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, ArrayList<Record>> map = new HashMap<String, ArrayList<Record>>();
        while (rs.next()) {
            Record record = new Record();
            record.index = rs.getInt("FIndex");
            record.costCenterId = rs.getString("FCostCenterID");
            record.costObjectId = rs.getString("FCostObjectID");
            record.costItemId = rs.getString("FCostItemID");
            String key = record.costCenterId + "-" + record.costObjectId + "-" + record.costItemId;
            ArrayList<Record> records = (ArrayList<Record>)map.get(key);
            if (records == null) {
                records = new ArrayList<Record>();
                map.put(key, records);
            }
            records.add(record);
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Record record;
            int i;
            List records = (List)map.get(it.next());
            StringBuffer error = new StringBuffer();
            error.append("\u8bb0\u5f55");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                error.append(record.index).append(",");
            }
            if (records.size() > 0) {
                error.deleteCharAt(error.length() - 1);
            }
            error.append("\u53d1\u751f\u91cd\u590d");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                this.onDataError(record.index, error.toString());
            }
        }
        if (map.size() > 0) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where ( \n");
            sql.append("    select count(*) from " + this.tempTable + " tt \n");
            sql.append("    where tt.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and tt.FCostObjectID = t.FCostObjectID \n");
            sql.append("    and tt.FCostItemID = t.FCostItemID \n");
            sql.append(") > 1 \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyDuplicate(Context ctx) throws Exception {
        if (this.isSltImportUpdate()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select * from " + this.tempTable + " t \n");
        sql.append("where exists ( \n");
        sql.append("    select 1 from " + this.T_NCM_EquivalentCoefRange + " u \n");
        sql.append("    where u.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and u.FCostItemID = t.FCostItemID \n");
        sql.append(") \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            this.onDataError(index, "\u6570\u636e\u91cd\u590d\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where exists ( \n");
            sql.append("    select 1 from " + this.T_NCM_EquivalentCoefRange + " u \n");
            sql.append("    where u.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
            sql.append("    and u.FCostItemID = t.FCostItemID \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private int submitData(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_NCM_EquivalentCoef s set ( \n");
        sql.append("    FCoefficient \n");
        sql.append(") = ( \n");
        sql.append("    select FCoefficient from " + this.tempTable + " t \n");
        sql.append("    where t.FCostCenterID = s.FCostCenterID \n");
        sql.append("    and t.FCostObjectID = s.FCostObjectID \n");
        sql.append("    and t.FCostItemID = s.FCostItemID \n");
        sql.append("    and s.FCompanyID = '" + this.companyId + "' \n");
        sql.append("    and s.FCalculatePeriodID = '" + this.periodId + "' \n");
        sql.append("); \n");
        sql.append("insert into T_NCM_EquivalentCoef ( \n");
        sql.append("    FID, \n");
        sql.append("    FCompanyID, \n");
        sql.append("    FCalculatePeriodID, \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FCostItemID, \n");
        sql.append("    FCoefficient, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    FControlUnitID \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    newbosid('588C9370'), \n");
        sql.append("    '" + this.companyId + "', \n");
        sql.append("    '" + this.periodId + "', \n");
        sql.append("    t.FCostCenterID, \n");
        sql.append("    t.FCostObjectID, \n");
        sql.append("    t.FCostItemID, \n");
        sql.append("    t.FCoefficient, \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.cuId + "' \n");
        sql.append("from " + this.tempTable + " t \n");
        sql.append("where not exists ( \n");
        sql.append("    select 1 from " + this.T_NCM_EquivalentCoefRange + " u \n");
        sql.append("    where u.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and u.FCostItemID = t.FCostItemID \n");
        sql.append("); \n");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("select count(*) from " + this.tempTable + " \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    protected void doAfterProcessData(Context ctx) throws Exception {
        if (this.tempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(this.tempTable);
        }
        if (this.T_NCM_EquivalentCoefRange != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(this.T_NCM_EquivalentCoefRange);
        }
    }

    class Record {
        public int index;
        public String costCenterId;
        public String costCenterNumber;
        public String costObjectId;
        public String costObjectNumber;
        public String costItemId;
        public String costItemNumber;
        public String orderNumber;
        public String productNumber;

        Record() {
        }
    }
}

