/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.CostCenterOrgUnitGroupInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.AbstractGLFetchDataInfo;
import com.kingdee.eas.ncm.bill.FetchDataDirectionEnum;
import com.kingdee.eas.ncm.bill.GLFetchDataCollection;
import com.kingdee.eas.ncm.bill.GLFetchDataEntryInfo;
import com.kingdee.eas.ncm.bill.GLFetchDataFactory;
import com.kingdee.eas.ncm.bill.GLFetchDataInfo;
import com.kingdee.eas.ncm.bill.IGLFetchData;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CostObjectRelatedInfo;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.CostObjectUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GLFetchDataImport
extends AbstractNCMDataImport {
    private CompanyOrgUnitInfo company = null;
    private CtrlUnitInfo cu = null;
    private PeriodInfo period = null;
    private UserInfo currUser = null;

    public int getSubmitType() {
        return 1;
    }

    public String getMainField() {
        return "Number";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return GLFetchDataFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsDataBlock, Context ctx) throws TaskExternalException {
        AbstractGLFetchDataInfo glFetchDataInfo = null;
        try {
            this.initOrgUnit(ctx);
            for (int i = 0; i < hsDataBlock.size(); ++i) {
                Map hsData = (Map)hsDataBlock.get(i);
                if (i == 0) {
                    this.CheckCanImportCompany(hsData, ctx, "companyOrg.number", this.company);
                }
                GLFetchDataEntryInfo glFetchDataEntryInfo = this.parseEntryData(hsData, ctx);
                if (i == 0) {
                    glFetchDataInfo = this.parseData(hsData, ctx);
                }
                glFetchDataInfo.getEntrys().add(glFetchDataEntryInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return glFetchDataInfo;
    }

    private GLFetchDataInfo parseData(Map<Object, Object> hsData, Context ctx) throws BOSException, TaskExternalException {
        GLFetchDataInfo glFetchDataInfo = new GLFetchDataInfo();
        glFetchDataInfo.setCalculatePeriod(this.period);
        Object data = this.getData(hsData, "companyOrg.number");
        CompanyOrgUnitInfo orgCompanyInfo = null;
        if (data != null && data.toString().trim().length() > 0) {
            orgCompanyInfo = NCMDataImportUtil.getCompanyByNumber((Context)ctx, (String)data.toString());
            glFetchDataInfo.setCompanyOrg(orgCompanyInfo);
        }
        this.checkCompanyNumber(ctx, glFetchDataInfo);
        this.dealWithTheNumberByImpMode(ctx, hsData, glFetchDataInfo);
        data = this.getData(hsData, "Name");
        if (data != null && data.toString().trim().length() > 0) {
            glFetchDataInfo.setDescription(data.toString());
        }
        data = this.getData(hsData, "Status");
        int value = 0;
        if (data != null) {
            value = "".equals(data) ? 2 : Integer.parseInt(data.toString()) + 1;
            if (value == BillBaseStatusEnum.TEMPORARILYSAVED.getValue()) {
                glFetchDataInfo.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            }
            if (value == BillBaseStatusEnum.SUBMITED.getValue()) {
                glFetchDataInfo.setBillStatus(BillBaseStatusEnum.SUBMITED);
            }
            if (value == BillBaseStatusEnum.AUDITED.getValue()) {
                glFetchDataInfo.setBillStatus(BillBaseStatusEnum.AUDITED);
            }
        }
        glFetchDataInfo.setCreator(this.currUser);
        glFetchDataInfo.setIsAuto(false);
        this.checkData(ctx, glFetchDataInfo);
        return glFetchDataInfo;
    }

    private GLFetchDataEntryInfo parseEntryData(Map<Object, Object> hsData, Context ctx) throws BOSException, EASBizException, TaskExternalException {
        Locale locale = ctx.getLocale();
        GLFetchDataEntryInfo entry = new GLFetchDataEntryInfo();
        String companyId = this.company.getId().toString();
        Object data = this.getData(hsData, "Account.Number");
        AccountViewInfo accountViewInfo = null;
        if (data != null && data.toString().trim().length() > 0) {
            accountViewInfo = NCMDataImportUtil.getAccountViewByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"241_GLFetchDataImport", (Locale)locale), (String)data.toString());
            entry.setAccount(accountViewInfo);
        }
        if (accountViewInfo != null) {
            try {
                String[] asstAccount = this.getAsstActInfoByAccount(ctx, hsData, accountViewInfo);
                entry.setAsstAccountName(this.getNotBlankString(asstAccount[1]));
                entry.setAsstAccount(this.getNotBlankString(asstAccount[0]));
                entry.setAsstAccountID(this.getNotBlankString(asstAccount[2]));
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if ((data = this.getData(hsData, "FetchDataDirect")) != null && data.toString().trim().length() > 0) {
            if (FetchDataDirectionEnum.DEBIT.getAlias(locale).equals(data.toString())) {
                entry.setFetchDataDirect(FetchDataDirectionEnum.DEBIT);
            } else if (FetchDataDirectionEnum.CREDIT.getAlias(locale).equals(data.toString())) {
                entry.setFetchDataDirect(FetchDataDirectionEnum.CREDIT);
            } else if (FetchDataDirectionEnum.DEBIT_CREDIT.getAlias(locale).equals(data.toString())) {
                entry.setFetchDataDirect(FetchDataDirectionEnum.DEBIT_CREDIT);
            } else if (FetchDataDirectionEnum.CREDIT_DEBIT.getAlias(locale).equals(data.toString())) {
                entry.setFetchDataDirect(FetchDataDirectionEnum.CREDIT_DEBIT);
            }
        }
        data = this.getData(hsData, "CostCenter.Number");
        CostCenterOrgUnitInfo costCenterInfo = null;
        if (data != null && data.toString().trim().length() > 0) {
            costCenterInfo = NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"244_GLFetchDataImport", (Locale)locale), (String)data.toString());
            entry.setCostCenter(costCenterInfo);
        }
        if ((data = this.getData(hsData, "CostCenterGroup.Number")) != null && data.toString().trim().length() > 0 && costCenterInfo == null) {
            entry.setCostCenterGroup(NCMDataImportUtil.getCostCenterGroupbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"243_GLFetchDataImport", (Locale)locale), (String)data.toString(), (String)companyId));
        }
        data = this.getData(hsData, "Expense.Number");
        ExpenseInfo expense = this.importUtil.getExpenseInfoByNumber(ctx, data, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"245_GLFetchDataImport", (Locale)locale), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"144_ExpenseDataImport", (Locale)locale));
        entry.setExpense(expense);
        this.checkExpense(ctx, expense, data);
        data = this.getData(hsData, "CostItem.Number");
        CostItemInfo costItem = this.importUtil.getCostItemInfoByNumber(ctx, data, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"246_GLFetchDataImport", (Locale)locale), null);
        if (costItem == null) {
            costItem = this.importUtil.getCostItemInfoByExpenseCompanyInfo(ctx, expense.getId().toString(), companyId);
        }
        entry.setCostItem(costItem);
        this.checkCostItem(ctx, costItem, data);
        Object objectData = this.getData(hsData, "CostObject.Number");
        Object orderData = this.getData(hsData, "order.Number");
        Object matData = this.getData(hsData, "material.Number");
        Object storageData = this.getData(hsData, "storage.number");
        Object batchNumber = this.getData(hsData, "batchNUmber");
        if (objectData != null && objectData.toString().trim().length() > 0) {
            CostObjectInfo costObjectInfo = NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"247_GLFetchDataImport", (Locale)locale), (String)objectData.toString(), (String)companyId);
            CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByCO((Context)ctx, (CostObjectInfo)costObjectInfo);
            if (costObjectRelatedInfo != null) {
                entry.setCostObject(costObjectRelatedInfo.getCostObjectInfo());
                if (costObjectRelatedInfo.getManufactureOrderInfo() != null) {
                    entry.setManufactureOrder(costObjectRelatedInfo.getManufactureOrderInfo());
                }
                entry.setMaterial(costObjectRelatedInfo.getMaterialInfo());
            }
        } else if (orderData != null && orderData.toString().trim().length() > 0) {
            ManufactureOrderInfo orderInfo = NCMDataImportUtil.getManufactureOrderByNumber((Context)ctx, (String)"\u751f\u4ea7\u8ba2\u5355", (String)orderData.toString(), (String)companyId, (String)storageData.toString());
            CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByOrder((Context)ctx, (ManufactureOrderInfo)orderInfo, (String)companyId);
            if (costObjectRelatedInfo != null) {
                entry.setCostObject(costObjectRelatedInfo.getCostObjectInfo());
                entry.setManufactureOrder(orderInfo);
                entry.setMaterial(costObjectRelatedInfo.getMaterialInfo());
            }
        } else if (matData != null && matData.toString().trim().length() > 0) {
            MaterialInfo materialInfo = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)"\u7269\u6599", (String)matData.toString());
            CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByMat((Context)ctx, (MaterialInfo)materialInfo, (String)batchNumber.toString());
            if (costObjectRelatedInfo == null && batchNumber.toString().trim().length() == 0) {
                throw new BOSException("\u8bf7\u5165\u6279\u6b21\u3002");
            }
            if (costObjectRelatedInfo == null && batchNumber.toString().trim().length() > 0) {
                throw new BOSException("\u7269\u6599\u52a0\u6279\u6b21\u627e\u4e0d\u5230\u6210\u672c\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002");
            }
            if (costObjectRelatedInfo != null) {
                entry.setCostObject(costObjectRelatedInfo.getCostObjectInfo());
                if (costObjectRelatedInfo.getManufactureOrderInfo() != null) {
                    entry.setManufactureOrder(costObjectRelatedInfo.getManufactureOrderInfo());
                }
                entry.setMaterial(materialInfo);
            }
        }
        data = this.getData(hsData, "CostObjectGroup.Number");
        if (data != null && data.toString().trim().length() > 0) {
            entry.setCostObjectSuite(NCMDataImportUtil.getCostObjectSuitebyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"248_GLFetchDataImport", (Locale)locale), (String)data.toString(), (String)companyId));
        }
        if ((data = this.getData(hsData, "Department.number")) != null && data.toString().trim().length() > 0) {
            AdminOrgUnitInfo info = NCMDataImportUtil.getFullOrgUnitInfoByNumber((Context)ctx, (String)"\u884c\u653f\u7ec4\u7ec7", (String)data.toString(), (String)this.company.getId().toString());
            entry.setDepartment(info);
        }
        if ((data = this.getData(hsData, "SourceCostCenter.Number")) != null && data.toString().trim().length() > 0) {
            CostCenterOrgUnitInfo sourceCostCenterInfo = NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"sourceCostCenter", (Locale)locale), (String)data.toString());
            entry.setSourceCostCenter(sourceCostCenterInfo);
        }
        this.checkEntryData(ctx, entry);
        return entry;
    }

    private void dealWithTheNumberByImpMode(Context ctx, Map<Object, Object> hsData, GLFetchDataInfo glFetchDataInfo) throws BOSException, TaskExternalException {
        String number;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)glFetchDataInfo, glFetchDataInfo.getCompanyOrg().getId().toString());
            if (ruleStatus.isExist()) {
                glFetchDataInfo.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                return;
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        String string = number = hsData.get("Number") == null ? null : hsData.get("Number").toString();
        if (number == null || number.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"57_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg", (Object)glFetchDataInfo.getCompanyOrg().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod", (Object)glFetchDataInfo.getCalculatePeriod().getId().toString()));
        view.setFilter(filter);
        GLFetchDataCollection coll = ((IGLFetchData)this.getController(ctx)).getGLFetchDataCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                this.checkCanEdit(ctx, coll.get(0));
                glFetchDataInfo.setId(coll.get(0).getId());
            } else {
                throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"58_ActualHourDataImport", (Locale)ctx.getLocale()));
            }
        }
        glFetchDataInfo.setNumber(number);
        glFetchDataInfo.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
    }

    private void checkCanEdit(Context ctx, GLFetchDataInfo glFetchDataInfo) throws BOSException {
        if (BillBaseStatusEnum.AUDITED.equals((Object)glFetchDataInfo.getBillStatus())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"61_ActualHourDataImport", (Locale)ctx.getLocale()) + glFetchDataInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"62_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
            if (this.period == null) {
                try {
                    this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (this.currUser == null) {
            this.currUser = (UserInfo)ctx.get((Object)"UserInfo");
        }
    }

    public Map<Object, Object> exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        try {
            result.put("Number", this.getNotBlankString(rs.getString("Number")));
            result.put("Name", this.getNotBlankString(rs.getString("description")));
            String billStatus = this.getNotBlankString(rs.getString("billStatus"));
            if (billStatus.equals(String.valueOf(BillBaseStatusEnum.ADD.getValue()))) {
                result.put("Status", String.valueOf(BillBaseStatusEnum.ADD.getValue() - 1));
            }
            if (billStatus.equals(String.valueOf(BillBaseStatusEnum.TEMPORARILYSAVED.getValue()))) {
                result.put("Status", String.valueOf(BillBaseStatusEnum.TEMPORARILYSAVED.getValue() - 1));
            }
            if (billStatus.equals(String.valueOf(BillBaseStatusEnum.SUBMITED.getValue()))) {
                result.put("Status", String.valueOf(BillBaseStatusEnum.SUBMITED.getValue() - 1));
            }
            if (billStatus.equals(String.valueOf(BillBaseStatusEnum.AUDITED.getValue()))) {
                result.put("Status", String.valueOf(BillBaseStatusEnum.AUDITED.getValue() - 1));
            }
            result.put("Company.Name", this.getNotBlankString(rs.getString("companyOrg.Name")));
            result.put("companyOrg.number", this.getNotBlankString(rs.getString("companyOrg.number")));
            result.put("Account.Number", this.getNotBlankString(rs.getString("account.number")));
            result.put("Account.Name", this.getNotBlankString(rs.getString("account.name")));
            this.exportAccountItem(result, rs, ctx);
            String fetchDataDirect = this.getNotBlankString(rs.getString("entrys.fetchDataDirect"));
            if (fetchDataDirect.equals(FetchDataDirectionEnum.DEBIT.getValue())) {
                result.put("FetchDataDirect", FetchDataDirectionEnum.DEBIT.getAlias());
            }
            if (fetchDataDirect.equals(FetchDataDirectionEnum.CREDIT.getValue())) {
                result.put("FetchDataDirect", FetchDataDirectionEnum.CREDIT.getAlias());
            }
            if (fetchDataDirect.equals(FetchDataDirectionEnum.DEBIT_CREDIT.getValue())) {
                result.put("FetchDataDirect", FetchDataDirectionEnum.DEBIT_CREDIT.getAlias());
            }
            if (fetchDataDirect.equals(FetchDataDirectionEnum.CREDIT_DEBIT.getValue())) {
                result.put("FetchDataDirect", FetchDataDirectionEnum.CREDIT_DEBIT.getAlias());
            }
            result.put("CostCenterGroup.Number", this.getNotBlankString(rs.getString("costCenterGroup.number")));
            result.put("CostCenterGroup.Name", this.getNotBlankString(rs.getString("costCenterGroup.name")));
            result.put("CostCenter.Number", this.getNotBlankString(rs.getString("costCenter.number")));
            result.put("CostCenter.Name", this.getNotBlankString(rs.getString("costCenter.name")));
            result.put("Expense.Number", this.getNotBlankString(rs.getString("expense.number")));
            result.put("Expense.Name", this.getNotBlankString(rs.getString("expense.name")));
            result.put("CostItem.Number", this.getNotBlankString(rs.getString("costItem.number")));
            result.put("CostItem.Name", this.getNotBlankString(rs.getString("costItem.name")));
            result.put("CostObject.Number", this.getNotBlankString(rs.getString("costObject.number")));
            result.put("CostObject.Name", this.getNotBlankString(rs.getString("costObject.name")));
            try {
                result.put("order.Number", this.getNotBlankString(rs.getString("manufacturerOrder.number")));
                result.put("ProjectNumber", this.getNotBlankString(rs.getString("project.number")));
                result.put("TrackNumber", this.getNotBlankString(rs.getString("trackNumber.number")));
                result.put("batchNUmber", this.getNotBlankString(rs.getString("costObject.batchNumber")));
                result.put("material.Number", this.getNotBlankString(rs.getString("material.number")));
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            result.put("CostObjectGroup.Number", this.getNotBlankString(rs.getString("costObjectSuite.number")));
            result.put("CostObjectGroup.Name", this.getNotBlankString(rs.getString("costObjectSuite.name")));
            result.put("Creator", this.getNotBlankString(rs.getString("creator.name")));
            result.put("CreateTime", this.getNotBlankString(rs.getString("createTime")));
            result.put("LastUpdateUser", this.getNotBlankString(rs.getString("lastUpdateUser.name")));
            result.put("LastUpdateTime", this.getNotBlankString(rs.getString("lastUpdateTime")));
            result.put("Auditor.Name", this.getNotBlankString(rs.getString("auditor.name")));
            result.put("AuditeTime", this.getNotBlankString(rs.getString("auditTime")));
            result.put("Department.number", this.getNotBlankString(rs.getString("department.number")));
            result.put("Department.name", this.getNotBlankString(rs.getString("department.name")));
            result.put("SourceCostCenter.Number", this.getNotBlankString(rs.getString("sourceCostCenter.number")));
            result.put("SourceCostCenter.Name", this.getNotBlankString(rs.getString("sourceCostCenter.name")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void checkData(Context ctx, GLFetchDataInfo glFetchDataInfo) throws BOSException {
        this.checkName(ctx, glFetchDataInfo);
        this.checkCompanyNumber(ctx, glFetchDataInfo);
    }

    private void checkEntryData(Context ctx, GLFetchDataEntryInfo glFetchDataEntryInfo) throws BOSException {
        this.checkAccountView(ctx, glFetchDataEntryInfo);
        this.checkFetchDataDirect(ctx, glFetchDataEntryInfo);
        this.checkCostCenter(ctx, glFetchDataEntryInfo);
        this.checkSourceCostCenter(ctx, glFetchDataEntryInfo);
    }

    private void checkName(Context ctx, GLFetchDataInfo glFetchDataInfo) throws BOSException {
        String name = glFetchDataInfo.getDescription();
        if (name == null) {
            throw new BOSException(this.getResource("GlFetchData_CheckName_IsEmpty", ctx));
        }
    }

    private void checkAccountView(Context ctx, GLFetchDataEntryInfo glFetchDataEntryInfo) throws BOSException {
        AccountViewInfo accountViewInfo = glFetchDataEntryInfo.getAccount();
        if (accountViewInfo == null) {
            throw new BOSException(this.getResource("GlFetchData_CheckAccountView_IsEmpty", ctx));
        }
    }

    private void checkFetchDataDirect(Context ctx, GLFetchDataEntryInfo glFetchDataEntryInfo) throws BOSException {
        String fetchDataDirect = glFetchDataEntryInfo.getFetchDataDirect().getValue();
        if (!("1".equals(fetchDataDirect) || "2".equals(fetchDataDirect) || "3".equals(fetchDataDirect) || "4".equals(fetchDataDirect))) {
            throw new BOSException(this.getResource("GlFetchData_CheckFetchDataDirect_IsEmpty", ctx));
        }
    }

    private void checkCostCenter(Context ctx, GLFetchDataEntryInfo glFetchDataEntryInfo) throws BOSException {
        CostCenterOrgUnitInfo costCenterInfo = glFetchDataEntryInfo.getCostCenter();
        CostCenterOrgUnitGroupInfo costCenterGroupInfo = glFetchDataEntryInfo.getCostCenterGroup();
        if (costCenterInfo == null && costCenterGroupInfo == null) {
            throw new BOSException(this.getResource("GlFetchData_CheckCostCenter_IsEmpty", ctx));
        }
    }

    private void checkSourceCostCenter(Context ctx, GLFetchDataEntryInfo glFetchDataEntryInfo) throws BOSException {
        if (glFetchDataEntryInfo.getSourceCostCenter() != null) {
            NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)glFetchDataEntryInfo.getSourceCostCenter(), (String)this.company.getId().toString());
        }
    }

    private void checkExpense(Context ctx, ExpenseInfo expenseInfo, Object data) throws TaskExternalException {
        if (expenseInfo == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"EXPENSE_NOT_EXIST", (Locale)ctx.getLocale(), (Object[])new Object[]{data}));
        }
        this.importUtil.checkExpenseTypeIsOther(ctx, expenseInfo);
        this.importUtil.checkExpenseCompanyInfo(ctx, expenseInfo.getId().toString(), this.company.getId().toString(), expenseInfo.getNumber(), this.company.getNumber());
        this.importUtil.checkDataBaseDPermission(ctx, this.cu.getId().toString(), expenseInfo.getCU().getId().toString(), expenseInfo.getId().toString(), expenseInfo.getNumber(), this.getResource("EXPENSE", ctx));
    }

    private void checkCostItem(Context ctx, CostItemInfo costItem, Object data) throws TaskExternalException {
        Locale locale = ctx.getLocale();
        if (costItem == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"COST_ITEM_NOT_EXIST", (Locale)locale, (Object[])new Object[]{data}));
        }
        this.importUtil.checkCostItemTypeIsOther(ctx, costItem);
        this.importUtil.checkDataBaseDPermission(ctx, this.cu.getId().toString(), costItem.getCU().getId().toString(), costItem.getId().toString(), costItem.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"246_GLFetchDataImport", (Locale)locale));
    }

    private void checkCompanyNumber(Context ctx, GLFetchDataInfo glFetchDataInfo) throws BOSException {
        CompanyOrgUnitInfo companyOrgUnitInfo = glFetchDataInfo.getCompanyOrg();
        if (companyOrgUnitInfo == null) {
            throw new BOSException(this.getResource("GlFetchData_CheckCompany_IsEmpty", ctx));
        }
    }

    public String[] getAsstActInfoByAccount(Context ctx, Map<Object, Object> hsData, AccountViewInfo accountViewInfo) throws BOSException, EASBizException {
        String[] asstAccount = new String[]{"", "", ""};
        StringBuffer accountNumber = new StringBuffer();
        StringBuffer accountName = new StringBuffer();
        StringBuffer accountID = new StringBuffer();
        Map asstAccountNumberMap = NCMDataImportUtil.getAsstActInfoByAccount((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"242_GLFetchDataImport", (Locale)ctx.getLocale()), (AccountViewInfo)accountViewInfo);
        if (asstAccountNumberMap == null || asstAccountNumberMap.size() == 0) {
            return asstAccount;
        }
        for (int i = 1; i <= 5; ++i) {
            String accountTypeNumber = "AccountType" + i + ".Number";
            String accountTypeName = "AccountType" + i + ".Name";
            String accountItem1Number = "AccountItem" + i + "1.Number";
            String accountItem1Name = "AccountItem" + i + "1.Name";
            String accountItem2Number = "AccountItem" + i + "2.Number";
            String accountItem2Name = "AccountItem" + i + "2.Name";
            String accounttypeNumberVal = null;
            String accounttypeNameVal = null;
            String accountItem1NumberVal = null;
            String accountItem1NameVal = null;
            String accountItem1IDVal = null;
            String accountItem2NumberVal = null;
            String accountItem2NameVal = null;
            String accountItem2IDVal = null;
            String accountItemQueryName = null;
            Object data = this.getData(hsData, accountTypeNumber);
            if (data != null && data.toString().length() > 0 && data instanceof String) {
                if (this.getData(hsData, accountItem1Number).equals("") || this.getData(hsData, accountItem1Name).equals("") || this.getData(hsData, accountItem1Number).equals("") || this.getData(hsData, accountItem1Name).equals("")) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"167_InitBalanceEditUI", (Locale)ctx.getLocale()) + data.toString() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"168_InitBalanceEditUI", (Locale)ctx.getLocale()));
                }
                accounttypeNumberVal = data.toString();
                if (!asstAccountNumberMap.containsKey(accounttypeNumberVal)) {
                    throw new BOSException(this.getResource("GlFetchDataImport_Account", ctx) + " " + accountViewInfo.getNumber() + " " + this.getResource("GlFetchDataImport_AccountNoAssrtType", ctx) + " " + accounttypeNumberVal);
                }
                accountNumber.append("|").append(accounttypeNumberVal).append("|");
                accountID.append("|").append(accounttypeNumberVal).append("|");
                accountItemQueryName = (String)asstAccountNumberMap.get(accounttypeNumberVal);
            }
            if ((data = this.getData(hsData, accountTypeName)) != null && data.toString().length() > 0 && data instanceof String) {
                accounttypeNameVal = data.toString();
                accountName.append(accounttypeNameVal).append(" = ");
            }
            if ((data = this.getData(hsData, accountItem1Number)) != null && data.toString().length() > 0 && data instanceof String) {
                if (this.getData(hsData, accountTypeNumber).equals("") || this.getData(hsData, accountTypeName).equals("")) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"169_InitBalanceEditUI", (Locale)ctx.getLocale()) + data.toString() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"170_InitBalanceEditUI", (Locale)ctx.getLocale()));
                }
                accountItem1NumberVal = data.toString();
                accountNumber.append(accountItem1NumberVal);
            }
            if ((data = this.getData(hsData, accountItem1Name)) != null && data.toString().length() > 0 && data instanceof String && (accountItem1IDVal = this.getAccountItemID(ctx, accountItemQueryName, accountItem1NumberVal, data.toString())) != null && accountItem1IDVal.length() > 0) {
                accountItem1NameVal = data.toString();
                accountName.append(accountItem1NameVal);
            }
            if (accountItem1IDVal != null && accountItem1IDVal.length() > 0) {
                accountID.append(accountItem1IDVal);
            }
            if ((data = this.getData(hsData, accountItem2Number)) != null && data.toString().length() > 0 && data instanceof String) {
                accountItem2NumberVal = data.toString();
                if (accountItem1NumberVal == null || accountItem1NumberVal.length() == 0) {
                    accountNumber.append(accountItem2NumberVal);
                }
                accountNumber.append(":").append(accountItem2NumberVal);
            } else if (accountItem1NumberVal != null && accountItem1NumberVal.length() > 0) {
                accountNumber.append(":").append(accountItem1NumberVal);
            }
            data = this.getData(hsData, accountItem2Name);
            if (data != null && data.toString().length() > 0 && data instanceof String) {
                accountItem2IDVal = this.getAccountItemID(ctx, accountItemQueryName, accountItem2NumberVal, data.toString());
                if (accountItem2IDVal != null && accountItem2IDVal.length() > 0) {
                    accountItem2NameVal = data.toString();
                }
                if (accountItem1NameVal == null || accountItem1NameVal.length() == 0) {
                    accountName.append(accountItem2NameVal);
                }
                accountName.append(":").append(accountItem2NameVal);
            } else if (accountItem1NameVal != null && accountItem1NameVal.length() > 0) {
                accountName.append(":").append(accountItem1NameVal);
            }
            if (accountItem2IDVal != null && accountItem2IDVal.length() > 0) {
                if (accountItem1IDVal == null || accountItem1IDVal.length() == 0) {
                    accountID.append(accountItem2IDVal);
                }
                accountID.append(":").append(accountItem2IDVal);
            } else if (accountItem1IDVal != null && accountItem1IDVal.length() > 0) {
                accountID.append(":").append(accountItem1IDVal);
            }
            if (accounttypeNumberVal == null || accounttypeNameVal == null) continue;
            accountName.append(" ; ");
        }
        asstAccount[0] = accountNumber.toString();
        if (accountName != null && accountName.length() > 2 && accountName.length() > 2) {
            asstAccount[1] = accountName.substring(0, accountName.length() - 2);
        }
        asstAccount[2] = accountID.toString();
        return asstAccount;
    }

    private void exportAccountItem(Map<Object, Object> tabl, IRowSet rs, Context ctx) throws SQLException {
        String accountNumber = this.getNotBlankString(rs.getString("entrys.asstAccount"));
        String accountName = this.getNotBlankString(rs.getString("entrys.asstAccountName"));
        if (accountNumber == null || accountNumber.length() < 1) {
            for (int i = 1; i <= 5; ++i) {
                String accountTypeNumber = "AccountType" + i + ".Number";
                String accountTypeName = "AccountType" + i + ".Name";
                String accountItem1Number = "AccountItem" + i + "1.Number";
                String accountItem1Name = "AccountItem" + i + "1.Name";
                String accountItem2Number = "AccountItem" + i + "2.Number";
                String accountItem2Name = "AccountItem" + i + "2.Name";
                tabl.put(accountTypeNumber, "");
                tabl.put(accountTypeName, "");
                tabl.put(accountItem1Number, "");
                tabl.put(accountItem1Name, "");
                tabl.put(accountItem2Number, "");
                tabl.put(accountItem2Name, "");
            }
            return;
        }
        String[] numbers = this.splitString(accountNumber);
        for (int index = 0; index < numbers.length && index < 10; ++index) {
            int flag = index / 2 + 1;
            String accountTypeNumber = "AccountType" + flag + ".Number";
            String accountItem1Number = "AccountItem" + flag + "1.Number";
            String accountItem2Number = "AccountItem" + flag + "2.Number";
            if (index % 2 == 0) {
                tabl.put(accountTypeNumber, numbers[index]);
                continue;
            }
            String[] accountItems = numbers[index].split(":");
            tabl.put(accountItem1Number, accountItems[0]);
            tabl.put(accountItem2Number, accountItems[1]);
        }
        String[] names = accountName.split(";");
        for (int index = 0; index < names.length && index < 10; ++index) {
            int flag = index + 1;
            String[] accountNames = names[index].split("=");
            String accountTypeName = "AccountType" + flag + ".Name";
            String accountItem1Name = "AccountItem" + flag + "1.Name";
            String accountItem2Name = "AccountItem" + flag + "2.Name";
            tabl.put(accountTypeName, accountNames[0]);
            String[] accountItemNames = accountNames[1].split(":");
            tabl.put(accountItem1Name, accountItemNames[0]);
            tabl.put(accountItem2Name, accountItemNames[1]);
        }
    }

    private String[] splitString(String str) {
        ArrayList<String> stringList = new ArrayList<String>();
        Pattern pt = Pattern.compile("([^\\|]{1,})");
        Matcher matcher = pt.matcher(str);
        String v = null;
        while (matcher.find()) {
            v = matcher.group(1).trim().toString();
            stringList.add(v);
        }
        String[] result = new String[stringList.size()];
        stringList.toArray(result);
        return result;
    }

    private String getAccountItemID(Context ctx, String queryName, String number, String name) throws BOSException {
        String itemID = "";
        MetaDataPK mdPk = MetaDataPK.create((String)queryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mdPk);
        FilterInfo filter = new FilterInfo();
        if (number == null) {
            return itemID;
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (name == null) {
            name = "";
        } else {
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            exec.setObjectView(ev);
            IRowSet rs = exec.executeQuery();
            if (!rs.next()) {
                throw new BOSException(this.getResource("GlFetchDataImport_AccountItem", ctx) + " " + number + " " + name + " " + this.getResource("GlFetchDataImport_AccountItemNoExist", ctx));
            }
            itemID = rs.getString("id");
        }
        catch (BOSException e1) {
            throw e1;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return itemID;
    }
}

