/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.IInputQtyBill;
import com.kingdee.eas.ncm.bill.InputQtyBillCollection;
import com.kingdee.eas.ncm.bill.InputQtyBillEntryCollection;
import com.kingdee.eas.ncm.bill.InputQtyBillEntryInfo;
import com.kingdee.eas.ncm.bill.InputQtyBillFactory;
import com.kingdee.eas.ncm.bill.InputQtyBillInfo;
import com.kingdee.eas.ncm.bill.InputQtyImportTypeEnum;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CostObjectRelatedInfo;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMBatchDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.CostObjectUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

public class InputQtyBillDataImport
extends AbstractNCMBatchDataImport {
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.InputQtyBillResource";
    CtrlUnitInfo cu = null;
    CompanyOrgUnitInfo company = null;

    public int getSubmitType() {
        return 1;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof InputQtyBillInfo)) {
            return;
        }
        try {
            if (coreBaseInfo.getId() != null) {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId().toString()), coreBaseInfo);
            } else {
                InputQtyBillInfo bill = (InputQtyBillInfo)coreBaseInfo;
                InputQtyBillEntryCollection billCollection = bill.getEntry();
                if (!this.isSltImportUpdate()) {
                    this.getController(ctx).addnew(coreBaseInfo);
                } else {
                    String id = this.getId(bill.getCostCenterOrgUnit().getNumber(), billCollection.get(0).getCostObject().getNumber(), bill.getCompanyOrg().getId().toString(), bill.getCalculatePeriod().getNumber() + "", ctx);
                    if (id != null && id.length() > 0) {
                        this.getController(ctx).delete((IObjectPK)new ObjectUuidPK(id));
                        this.getController(ctx).addnew(coreBaseInfo);
                    } else {
                        this.getController(ctx).addnew(coreBaseInfo);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private String getId(String costCenterNumber, String costObject, String companyID, String peroid, Context ctx) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        IRowSet rowSet = null;
        sql.append("select inputQtyBill.FID  from T_NCM_InputQtyBill inputQtyBill  inner join T_NCM_InputQtyBillentry inputQtyBillentry  on inputQtyBill.fid=inputQtyBillentry.fparentid  inner join T_ORG_CostCenter costCenter  on inputQtyBill.FcostcenterOrgUnitID=costCenter.FID  inner join t_bd_costobject costobject  on inputQtyBillentry.fcostobjectid=costobject.fid  inner join T_BD_Period period  on period.FID=inputQtyBill.FCalculatePeriod  where costCenter.FNumber=?  and  period.FNumber = ?  and inputQtyBill.FCompanyorg=?  and costobject.FNumber=?  and inputQtyBill.FBillStatus <> 4");
        try {
            rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{costCenterNumber, peroid, companyID, costObject});
            if (rowSet.next()) {
                String string = rowSet.getString(1);
                return string;
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rowSet != null) {
                rowSet.close();
            }
        }
        return null;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return InputQtyBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsDataBlock, Context ctx) throws TaskExternalException {
        InputQtyBillInfo inputQtyBill = null;
        try {
            this.initOrgUnit(ctx);
            for (int i = 0; i < hsDataBlock.size(); ++i) {
                Hashtable hsData = (Hashtable)hsDataBlock.get(i);
                if (i == 0) {
                    inputQtyBill = this.parseHead(hsData, ctx);
                    this.verifyHead(ctx, inputQtyBill);
                }
                InputQtyBillEntryInfo entry = this.parseEntry(hsData, ctx);
                inputQtyBill.getEntry().add(entry);
                this.dealWithTheNumberByImpMode(ctx, hsData, inputQtyBill);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return inputQtyBill;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
        }
    }

    private InputQtyBillInfo parseHead(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException {
        InputQtyBillInfo inputQtyBill = new InputQtyBillInfo();
        inputQtyBill.setCompanyOrg(this.company);
        Object data = this.getData(hsData, "FBizDate");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException("\u4e1a\u52a1\u65e5\u671f \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        data = this.getData(hsData, "FBillStatus");
        if (data == null || data.toString().trim().length() <= 0 || Integer.parseInt(data.toString()) != 4 && Integer.parseInt(data.toString()) != 2 && Integer.parseInt(data.toString()) != 3) {
            throw new BOSException("\u5355\u636e\u72b6\u6001\u4e0d\u5408\u6cd5");
        }
        inputQtyBill.setBillStatus(BillBaseStatusEnum.getEnum((int)Integer.parseInt(data.toString())));
        data = this.getData(hsData, "FCostCenterNumber");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException("\u6210\u672c\u4e2d\u5fc3\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        inputQtyBill.setCostCenterOrgUnit(NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)"\u6210\u672c\u4e2d\u5fc3\u7f16\u7801", (String)data.toString()));
        inputQtyBill.setIsImport(true);
        inputQtyBill.setImportType(InputQtyImportTypeEnum.fromexcel);
        return inputQtyBill;
    }

    private InputQtyBillEntryInfo parseEntry(Hashtable hsData, Context ctx) throws BOSException {
        InputQtyBillEntryInfo inputQtyBillEntry = new InputQtyBillEntryInfo();
        Object data = this.getData(hsData, "FEntryQty");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        inputQtyBillEntry.setQty(this.getBigDecimalValueByFeildData(ctx, "\u6570\u91cf", data));
        CostObjectInfo costObject = this.parseCostObject(hsData, ctx);
        inputQtyBillEntry.setCostObject(costObject);
        if (costObject == null) {
            throw new BOSException("\u6210\u672c\u5bf9\u8c61\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (costObject.isIsForbiden()) {
            throw new BOSException(this.getResource(ctx, "CostObjectHasForbidCanNotImport", new Object[]{costObject.getNumber()}));
        }
        inputQtyBillEntry.setIsImport(true);
        data = this.getData(hsData, "FEntryRemark");
        inputQtyBillEntry.setRemark(data.toString().trim());
        return inputQtyBillEntry;
    }

    private CostObjectInfo parseCostObject(Hashtable hsData, Context ctx) throws BOSException {
        String companyId = this.company.getId().toString();
        Object storageData = this.getData(hsData, "storageOrgUnit.number");
        String storageOrgUnitNumber = null;
        if (storageData != null && storageData.toString().trim().length() > 0) {
            storageOrgUnitNumber = storageData.toString().trim();
        }
        Object costObjectData = this.getData(hsData, "FCostObjectNumber");
        String costObjectNumber = null;
        if (costObjectData != null && costObjectData.toString().trim().length() > 0) {
            costObjectNumber = costObjectData.toString().trim();
        }
        Object orderData = this.getData(hsData, "order.number");
        String orderNumber = null;
        if (orderData != null && orderData.toString().trim().length() > 0) {
            orderNumber = orderData.toString().trim();
        }
        Object productData = this.getData(hsData, "material.number");
        String productNumber = null;
        if (productData != null && productData.toString().trim().length() > 0) {
            productNumber = productData.toString().trim();
        }
        Object batchData = this.getData(hsData, "batch");
        String batch = null;
        if (batchData != null && batchData.toString().trim().length() > 0) {
            batch = batchData.toString().trim();
        }
        try {
            if (costObjectNumber != null) {
                return NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)this.getResource(ctx, "CostObjectNumber"), (String)costObjectNumber, (String)companyId);
            }
            if (orderNumber != null) {
                return NCMDataImportUtil.getCostObjectByOrder((Context)ctx, (String)companyId, (String)storageOrgUnitNumber, (String)orderNumber, (String)batch);
            }
            if (productNumber != null) {
                return NCMDataImportUtil.getCostObjectByProduct((Context)ctx, (String)companyId, (String)productNumber, (String)batch);
            }
            throw new BOSException(this.getResource(ctx, "CostObjectOrderMaterialCanNotAllEmpty"));
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void dealWithTheNumberByImpMode(Context ctx, Hashtable hsData, InputQtyBillInfo info) throws BOSException, TaskExternalException {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)info, info.getCompanyOrg().getId().toString());
            if (ruleStatus.isExist()) {
                return;
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        String number = hsData.get("FNumber").toString();
        if (number == null || number.length() <= 0) {
            throw new BOSException("\u5355\u636e\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg", (Object)info.getCompanyOrg().getId().toString()));
        view.setFilter(filter);
        InputQtyBillCollection coll = ((IInputQtyBill)this.getController(ctx)).getInputQtyBillCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                this.checkCanEdit(info, coll.get(0));
                info.setId(coll.get(0).getId());
            } else {
                throw new BOSException(number + " \u5355\u636e\u7f16\u53f7\u91cd\u590d!");
            }
        }
        info.setNumber(number);
    }

    private void checkCanEdit(InputQtyBillInfo info, InputQtyBillInfo compaareInfo) throws BOSException {
        if (!BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)compaareInfo.getBillStatus())) {
            throw new BOSException("\u5355\u636e\u7f16\u53f7\u4e3a " + compaareInfo.getNumber() + " \u7684\u6570\u636e\u4e0d\u662f\u65b0\u589e\u72b6\u6001\uff0c\u4e0d\u80fd\u4fee\u6539!");
        }
    }

    private void verifyHead(Context ctx, InputQtyBillInfo inputQtyBill) throws BOSException {
        this.checkCostCenter(ctx, inputQtyBill);
    }

    private void checkCostCenter(Context ctx, InputQtyBillInfo inputQtyBill) throws BOSException {
        NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)inputQtyBill.getCostCenterOrgUnit(), (String)inputQtyBill.getCompanyOrg().getId().toString());
    }

    protected String getResource(Context ctx, String resName) {
        return this.getResource(ctx, resName, null);
    }

    protected String getResource(Context ctx, String resName, Object[] params) {
        if (params != null) {
            return MessageFormat.format(ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale()), params);
        }
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale());
    }

    protected void doBeforeProcessData(Context ctx) throws Exception {
        super.doBeforeProcessData(ctx);
    }

    protected String buildTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T ( \n");
        sql.append("     FID varchar(44), \n");
        this.buildCostCenterSQL(sql);
        this.buildCostObjectSQL(sql);
        this.buildStorageSQL(sql);
        this.buildOrderSQL(sql);
        this.buildProductSQL(sql);
        sql.append("     FNumber VARCHAR(88), \n");
        sql.append("     FInnerNumber VARCHAR(88), \n");
        sql.append("     FBizDate  DateTime, \n");
        sql.append("     FPeriodID  varchar(44), \n");
        sql.append("     FBillStatus INT, \n");
        sql.append("     FBatch nvarchar(255), \n");
        sql.append("     FQty  NUMERIC(28,10), \n");
        sql.append("     FRemark NVARCHAR(255), \n");
        sql.append("     FIsUpdate int default(0), \n");
        sql.append("     FIndex int default(0) \n");
        sql.append(") \n");
        return sql.toString();
    }

    protected void doProcessBlockData(Context ctx, RecordCollection coll) throws Exception {
        PreparedStatement pstmtInsert = null;
        Connection conn = null;
        Set set = this.getInputBillNum(ctx);
        MaterialInfo material = null;
        BigDecimal inputQty = null;
        int qtyPrecision = 4;
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
        }
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("INSERT INTO ").append(this.tempTable).append(" ( \n").append("FNumber,FBizDate,FBillStatus,FCostCenterNumber,FCostObjectNumber, \n").append("FStorageOrgUnitNumber,FOrderNumber,FProductNumber,FBatch,FQty,FRemark,FInnerNumber,FIndex  ) \n").append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sqlInsert.toString());
            for (int rowIndex = 0; rowIndex < coll.size(); ++rowIndex) {
                CostObjectInfo costObjectInfo;
                String remark;
                String productNumber;
                String orderNumber;
                String storageOrgUnitNumber;
                String costObjectNumber;
                IRecord rowData;
                block23: {
                    ++this.index;
                    rowData = coll.get(rowIndex);
                    costObjectNumber = null;
                    storageOrgUnitNumber = null;
                    orderNumber = null;
                    productNumber = null;
                    remark = null;
                    String number = null;
                    number = this.getData((SimpleRecord)rowData, "FNumber");
                    if (set.contains(number) && !this.isSltImportUpdate()) {
                        this.onDataError(this.index, "\u5355\u636e\u7f16\u7801" + number + "\u91cd\u590d\uff01");
                        continue;
                    }
                    String dateStr = this.getData((SimpleRecord)rowData, "FBizDate");
                    if (dateStr == null) {
                        this.onDataError(this.index, "\u4e1a\u52a1\u65e5\u671f \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        continue;
                    }
                    Calendar c = Calendar.getInstance();
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        Date date = df.parse(dateStr);
                        PeriodInfo currentPeriod = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
                        Date begin = currentPeriod.getBeginDate();
                        if (date.before(begin)) {
                            this.onDataError(this.index, "\u4e0d\u80fd\u5bfc\u5165\u4ee5\u524d\u671f\u95f4\u7684\u5355\u636e\uff01");
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        this.onDataError(this.index, "\u65e5\u671f\u6709\u8bef");
                    }
                    continue;
                }
                remark = this.getData((SimpleRecord)rowData, "FEntryRemark");
                if (remark != null && remark.length() > 255) {
                    this.onDataError(this.index, "\u5907\u6ce8\u6700\u591a\u53ea\u80fd\u5f55\u5165255\u4e2a\u5b57\u7b26\uff01");
                    continue;
                }
                costObjectNumber = this.getData((SimpleRecord)rowData, "FCostObjectNumber");
                if (costObjectNumber != null && costObjectNumber.toString().trim().length() > 0 && (costObjectInfo = NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"247_GLFetchDataImport", (Locale)ctx.getLocale()), (String)costObjectNumber.toString(), (String)this.company.getId().toString())).getStdProductID() != null) {
                    material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(costObjectInfo.getStdProductID().getId().toString()));
                }
                if (costObjectNumber == null) {
                    storageOrgUnitNumber = this.getData((SimpleRecord)rowData, "storageOrgUnit.number");
                    orderNumber = this.getData((SimpleRecord)rowData, "order.number");
                    if (orderNumber != null) {
                        if (storageOrgUnitNumber == null) {
                            this.onDataError(this.index, "\u901a\u8fc7\u8ba2\u5355\u627e\u6210\u672c\u5bf9\u8c61\uff0c\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                            continue;
                        }
                        ManufactureOrderInfo orderInfo = NCMDataImportUtil.getManufactureOrderByNumber((Context)ctx, (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"160_InitBalanceEditUI_Order"), (String)orderNumber.toString(), (String)this.company.getId().toString(), (String)storageOrgUnitNumber.toString());
                        CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByOrder((Context)ctx, (ManufactureOrderInfo)orderInfo, (String)this.company.getId().toString());
                        if (material == null) {
                            material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(costObjectRelatedInfo.getCostObjectInfo().getStdProductID().getId().toString()));
                        }
                    } else {
                        productNumber = this.getData((SimpleRecord)rowData, "material.number");
                        if (productNumber == null) {
                            this.onDataError(this.index, "\u6210\u672c\u5bf9\u8c61\uff0c\u8ba2\u5355\uff0c\u7269\u6599\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002");
                            continue;
                        }
                        MaterialInfo materialInfo = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"162_InitBalanceEditUI_Material"), (String)productNumber.toString());
                        if (material == null) {
                            material = materialInfo;
                        }
                    }
                }
                if (material != null && material.getBaseUnit() != null) {
                    String unitID = material.getBaseUnit().getId().toString();
                    String materialID = material.getId().toString();
                    String oql = "select * where material.id = '" + materialID + "' and measureUnit.id = '" + unitID + "'";
                    MultiMeasureUnitInfo mulUnitInfo = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitInfo(oql);
                    qtyPrecision = mulUnitInfo.getQtyPrecision();
                }
                inputQty = new BigDecimal(this.getFieldValue(false, rowData, "FEntryQty", "\u6570\u91cf"));
                inputQty = inputQty.setScale(qtyPrecision, 4);
                pstmtInsert.setString(1, this.getFieldValue(false, rowData, "FNumber", "\u7f16\u7801"));
                pstmtInsert.setDate(2, TypeConversionUtils.objToDate((Object)this.getFieldValue(false, rowData, "FBizDate", "\u4e1a\u52a1\u65e5\u671f")));
                pstmtInsert.setString(3, this.getFieldValue(false, rowData, "FBillStatus", "\u5355\u636e\u72b6\u6001"));
                pstmtInsert.setString(4, this.getFieldValue(false, rowData, "FCostCenterNumber", "\u6210\u672c\u4e2d\u5fc3\u7f16\u7801"));
                pstmtInsert.setString(5, costObjectNumber);
                pstmtInsert.setString(6, storageOrgUnitNumber);
                pstmtInsert.setString(7, orderNumber);
                pstmtInsert.setString(8, productNumber);
                pstmtInsert.setString(9, this.getFieldValue(true, rowData, "batch", ""));
                pstmtInsert.setBigDecimal(10, inputQty);
                pstmtInsert.setString(11, this.getFieldValue(true, rowData, "FEntryRemark", ""));
                pstmtInsert.setString(12, this.getFieldValue(true, rowData, "FNumber", ""));
                pstmtInsert.setInt(13, this.index);
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e1) {
            try {
                throw new TaskExternalException(e1.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
    }

    protected int doProcessData(Context ctx) throws Exception {
        this.fillPeriod(ctx);
        this.fillAndVerifyCostCenter(ctx);
        this.fillAndVerifyCostObject(ctx);
        this.fillAndVerifyStorage(ctx);
        this.fillAndVerifyOrder(ctx);
        this.fillAndVerifyProduct(ctx);
        this.findCostObjectByOrder(ctx);
        this.findCostObjectByProduct(ctx);
        this.verifyBaseStatusa(ctx);
        this.verifyBillData(ctx);
        return this.submitData(ctx);
    }

    private int submitData(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        if (this.isSltImportUpdate()) {
            sql.append("update T_NCM_InputQtyBillEntry entry set (\n");
            sql.append("    FQty,FREMARK_" + ctx.getLocale() + " \n");
            sql.append(") = ( \n");
            sql.append("    select top 1 t.FQty, t.FRemark from " + this.tempTable + " t \n");
            sql.append("    inner join T_NCM_InputQtyBill bill ON bill.FCostCenterOrgUnitID = t.FCostCenterID \n");
            sql.append("                                       AND bill.FCompanyOrg = '" + this.companyId + "' \n");
            sql.append("                                       AND bill.FCalculatePeriod = t.FPeriodID \n");
            sql.append("    where t.FCostObjectID = entry.FCostObjectID AND bill.FID = entry.FParentID \n");
            sql.append("); \n");
            sql.append("update T_NCM_InputQtyBill bill set (\n");
            sql.append("    FBillStatus \n");
            sql.append(") = ( \n");
            sql.append("    select top 1 t.FBillStatus from " + this.tempTable + " t \n");
            sql.append("    inner join T_NCM_InputQtyBillEntry entry ON t.FCostObjectID = entry.FCostObjectID \n");
            sql.append("                                where  bill.FCostCenterOrgUnitID = t.FCostCenterID \n");
            sql.append("                                       AND bill.FCompanyOrg = '" + this.companyId + "' \n");
            sql.append("                                       AND bill.FCalculatePeriod = t.FPeriodID \n");
            sql.append("                                       AND bill.FID = entry.FParentID \n");
            sql.append("                                       AND bill.FNumber = t.FNumber \n");
            sql.append("); \n");
            sql.append("update " + this.tempTable + " t set FIsUpdate = 1 \n");
            sql.append("   where exists (select 1 from T_NCM_InputQtyBill bill \n");
            sql.append("                          inner join T_NCM_InputQtyBillEntry entry on bill.FID = entry.FParentID \n");
            sql.append("                 where bill.FCostCenterOrgUnitID = t.FCostCenterID \n");
            sql.append("                   AND bill.FCompanyOrg = '" + this.companyId + "' \n");
            sql.append("                   AND bill.FCalculatePeriod = t.FPeriodID \n");
            sql.append("                   AND entry.FCostObjectID = t.FCostObjectID); \n");
        }
        sql.append("insert into T_NCM_InputQtyBill ( \n");
        sql.append("    FID, \n");
        sql.append("    FCompanyOrg, \n");
        sql.append("    FCalculatePeriod, \n");
        sql.append("    FNumber, \n");
        sql.append("    FCostCenterOrgUnitID, \n");
        sql.append("    FBizDate, \n");
        sql.append("    FBillStatus, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    FControlUnitID, \n");
        sql.append("    FIsImport, \n");
        sql.append("    FIsSystem \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    newbosid('B2B2D2CC'), \n");
        sql.append("    '" + this.companyId + "', \n");
        sql.append("    data.FPeriodID, \n");
        sql.append("    data.FNumber, \n");
        sql.append("    data.FCostCenterID, \n");
        sql.append("    data.FBizDate, \n");
        sql.append("    data.FBillStatus, \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.cuId + "', \n");
        sql.append("    1, \n");
        sql.append("    1 \n");
        sql.append("   From ( select distinct t.FNumber as FNumber ,t.FPeriodID as FPeriodID,t.FCostCenterID as FCostCenterID, \n");
        sql.append("                 t.FBillStatus as FBillStatus,t.FBizDate as FBizDate \n");
        sql.append("          from ").append(this.tempTable).append(" t \n");
        sql.append("          where t.FIsUpdate = 0 \n");
        if (this.isSltImportUpdate()) {
            sql.append("          and not exists ( \n");
            sql.append("                select 1 from T_NCM_InputQtyBill bill \n");
            sql.append("                where bill.FCostCenterOrgUnitID = t.FCostCenterID \n");
            sql.append("                  and bill.FCompanyOrg = '" + this.companyId + "' \n");
            sql.append("                  and bill.FCalculatePeriod = t.FPeriodID) \n");
        }
        sql.append("         ) AS data; \n");
        sql.append("insert into T_NCM_InputQtyBillEntry ( \n");
        sql.append("    FID, \n");
        sql.append("    FParentID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FManufactureOrderID, \n");
        sql.append("    FMaterialID, \n");
        sql.append("    FQty, \n");
        sql.append("    FIsImport, \n");
        sql.append("    FREMARK_" + ctx.getLocale() + " \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    newbosid('E65D2506'), \n");
        sql.append("    EntryData.FID, \n");
        sql.append("    EntryData.FCostObjectID, \n");
        sql.append("    EntryData.FOrderMaterialID, \n");
        sql.append("    EntryData.FProductID, \n");
        sql.append("    EntryData.FQty, \n");
        sql.append("    1, \n");
        sql.append("    EntryData.FREMARK \n");
        sql.append("   From ( select distinct bill.FID as FID, t.FCostObjectID as FCostObjectID, \n");
        sql.append("                 t.FOrderMaterialID as FOrderMaterialID, t.FProductID as FProductID, t.FQty as FQty,t.FRemark as FRemark \n");
        sql.append("          from ").append(this.tempTable).append(" t \n");
        sql.append("          inner join T_NCM_InputQtyBill bill on bill.FIsSystem = 1");
        sql.append("                                                      and bill.FCompanyOrg = '" + this.companyId + "' \n");
        sql.append("                                                      and bill.FCalculatePeriod = t.FPeriodID \n");
        sql.append("                                                      and bill.FNumber = t.FNumber \n");
        sql.append("          where FIsUpdate = 0 \n");
        sql.append("         ) AS EntryData; ");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        this.getNumber(ctx);
        sql.setLength(0);
        sql.append(" update T_NCM_InputQtyBill set FIsSystem = 0 \n");
        sql.append(" where FIsSystem = 1 ");
        sql.append("   and FCompanyOrg = '" + this.companyId + "' \n");
        sql.append("   and FCalculatePeriod IN (select distinct FperiodID from " + this.tempTable + ") \n");
        NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update T_NCM_InputQtyBill  \n");
        sql.append(" set FAuditorID = '" + this.userId + "', ");
        sql.append("     FAuditTime = getdate() ");
        sql.append("where FBillStatus = 4 and FAuditorID is null and FAuditTime is null \n");
        NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update T_NCM_InputQtyBill  \n");
        sql.append(" set FAuditorID = null, ");
        sql.append("     FAuditTime = null ");
        sql.append("where FBillStatus <> 4 \n");
        NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("select count(*) from " + this.tempTable + " \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    private String getFieldValue(boolean isCanNUll, IRecord rowData, String fieldName, String messageName) throws TaskRunnerException {
        String returnValue = rowData.get(fieldName).toString();
        if ("FBillStatus".equals(fieldName) && !"2".equals(returnValue) && !"3".equals(returnValue) && !"4".equals(returnValue)) {
            this.onDataError(this.index, messageName + "\u503c\u4e0d\u6b63\u786e");
        }
        if (isCanNUll) {
            return returnValue;
        }
        if (returnValue == null || returnValue.length() == 0) {
            this.onDataError(this.index, messageName + "\u4e3a\u7a7a");
        }
        return returnValue;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getNumber(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fnumber from T_NCM_InputQtyBill bill \n");
        sql.append("  where bill.FIsSystem = 1");
        sql.append("    AND bill.FCompanyOrg = '" + this.companyId + "' \n");
        sql.append("    AND bill.FCalculatePeriod in (select distinct FperiodID from " + this.tempTable + ") \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        PreparedStatement pstmtUpdate = null;
        Connection conn = null;
        sql.setLength(0);
        sql.append("update T_NCM_InputQtyBill set Fnumber = ? \n");
        sql.append("    where FIsSystem = 1 \n");
        sql.append("      AND FCompanyOrg = '" + this.companyId + "' \n");
        sql.append("      AND FCalculatePeriod in (select distinct FperiodID from " + this.tempTable + ") \n");
        sql.append("      AND FNumber = ? \n");
        int numberCount = 0;
        if (!CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)new InputQtyBillInfo(), this.companyId)) {
            return;
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtUpdate = conn.prepareStatement(sql.toString());
            while (rs.next()) {
                String newNumber = InputQtyBillFactory.getLocalInstance(ctx).getNewNumber((IObjectValue)new InputQtyBillInfo(), this.companyId, null);
                pstmtUpdate.setString(1, newNumber);
                pstmtUpdate.setString(2, rs.getString(1));
                pstmtUpdate.addBatch();
                if (++numberCount % 500 != 0) continue;
                pstmtUpdate.executeBatch();
                pstmtUpdate.clearBatch();
            }
            pstmtUpdate.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (EASBizException e1) {
                    throw new BOSException((Throwable)e1);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtUpdate, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtUpdate, (Connection)conn);
    }

    protected void verifyBaseStatusa(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where  FBillStatus not in (2,3,4) ;\n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            this.onDataError(index, "\u5355\u636e\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where FCostObjectID is null \n");
            sql.append("and FOrderID is not null \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    protected void verifyBillData(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select FNumber from  \n");
        sql.append("    (select distinct FNumber,FCostCenterNumber from " + this.getTempTable() + " \n");
        sql.append("    ) data    \n");
        sql.append("group by FNumber \n");
        sql.append("having count(1) > 1; \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            String number = rs.getString("FNumber");
            this.onDataError(this.index, "\u5355\u636e" + number + "\u51fa\u73b0\u4e86\u591a\u4e2a\u6210\u672c\u4e2d\u5fc3");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where FNumber in \n");
            sql.append("  (select FNumber from  \n");
            sql.append("     (select distinct FNumber,FCostCenterNumber from " + this.getTempTable() + " \n");
            sql.append("     ) data    \n");
            sql.append("    group by FNumber \n");
            sql.append("    having count(1) > 1 \n");
            sql.append("   );\n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    protected Set getInputBillNum(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        HashSet<String> set = new HashSet<String>();
        String number = null;
        sql.setLength(0);
        sql.append("select Fnumber from T_NCM_InputQtyBill \n");
        sql.append("where  FCompanyOrg = '" + this.companyId + "' ;\n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            number = rs.getString("FNUmber");
            if (set.contains(number)) continue;
            set.add(number);
        }
        return set;
    }

    class Record {
        public int index;
        public String costCenterId;
        public String costCenterNumber;
        public String costObjectId;
        public String costObjectNumber;
        public String orderNumber;
        public String productNumber;

        Record() {
        }
    }
}

