/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.IOtherFeeBill;
import com.kingdee.eas.ncm.bill.OtherFeeBillCollection;
import com.kingdee.eas.ncm.bill.OtherFeeBillEntryInfo;
import com.kingdee.eas.ncm.bill.OtherFeeBillFactory;
import com.kingdee.eas.ncm.bill.OtherFeeBillInfo;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CostObjectRelatedInfo;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.CostObjectUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class OtherFeeBillDataImport
extends AbstractNCMDataImport {
    CtrlUnitInfo cu = null;
    CompanyOrgUnitInfo company = null;
    CurrencyInfo baseCurrencyInfo = null;

    public int getSubmitType() {
        return 1;
    }

    public String getMainField() {
        return "number";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return OtherFeeBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsDataBlock, Context ctx) throws TaskExternalException {
        OtherFeeBillInfo otherFeeBill = null;
        try {
            this.initData(ctx);
            for (int i = 0; i < hsDataBlock.size(); ++i) {
                Map hsData = (Map)hsDataBlock.get(i);
                if (i == 0) {
                    otherFeeBill = this.parseHead(hsData, ctx);
                    this.verifyHead(ctx, otherFeeBill);
                }
                OtherFeeBillEntryInfo entry = this.parseEntry(hsData, ctx);
                otherFeeBill.getEntries().add(entry);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return otherFeeBill;
    }

    private void initData(Context ctx) throws TaskExternalException {
        if (this.cu == null || this.company == null || this.baseCurrencyInfo == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
            if (this.baseCurrencyInfo == null) {
                this.baseCurrencyInfo = this.importUtil.getBaseCurrencyInfoByCompanyId(ctx, this.company.getId().toString());
            }
        }
    }

    private OtherFeeBillInfo parseHead(Map<Object, Object> hsData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        OtherFeeBillInfo otherFeeBill = new OtherFeeBillInfo();
        otherFeeBill.setCompanyOrg(this.company);
        this.dealWithTheNumberByImpMode(ctx, hsData, otherFeeBill);
        Locale locale = ctx.getLocale();
        Object data = this.getData(hsData, "bizDate");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"60_ActualHourDataImport", (Locale)locale));
        }
        Date bizDate = this.getDateByFeildData(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"59_ActualHourDataImport", (Locale)locale), data);
        PeriodInfo period = this.getPeriodByBizDate(ctx, bizDate, this.company);
        otherFeeBill.setBizDate(bizDate);
        otherFeeBill.setCalculatePeriod(period);
        data = this.getData(hsData, "costCenter");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"64_ActualHourDataImport", (Locale)locale));
        }
        otherFeeBill.setCostCenter(NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"63_ActualHourDataImport", (Locale)locale), (String)data.toString()));
        data = this.getData(hsData, "description");
        if (data != null && data.toString().trim().length() > 0) {
            otherFeeBill.setDescription(data.toString());
        }
        if ((data = this.getData(hsData, "department")) != null && data.toString().trim().length() > 0) {
            AdminOrgUnitInfo info = NCMDataImportUtil.getFullOrgUnitInfoByNumber((Context)ctx, (String)"\u884c\u653f\u7ec4\u7ec7", (String)data.toString(), (String)this.company.getId().toString());
            otherFeeBill.setDepartment(info);
        }
        if ((data = this.getData(hsData, "sourceCostCenter")) != null && data.toString().trim().length() > 0) {
            CostCenterOrgUnitInfo sourceCostCenterInfo = NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"sourceCostCenter", (Locale)locale), (String)data.toString());
            otherFeeBill.setSourceCostCenter(sourceCostCenterInfo);
        }
        return otherFeeBill;
    }

    private void dealWithTheNumberByImpMode(Context ctx, Map<Object, Object> hsData, OtherFeeBillInfo info) throws BOSException, TaskExternalException {
        String number;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)info, info.getCompanyOrg().getId().toString());
            if (ruleStatus.isExist()) {
                info.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                if (!this.isSltImportUpdate()) {
                    return;
                }
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        String string = number = hsData.get("number") == null ? null : hsData.get("number").toString();
        if (number == null || number.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"57_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg", (Object)info.getCompanyOrg().getId().toString()));
        view.setFilter(filter);
        OtherFeeBillCollection coll = ((IOtherFeeBill)this.getController(ctx)).getOtherFeeBillCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                this.checkCanEdit(ctx, info, coll.get(0));
                info.setId(coll.get(0).getId());
            } else {
                throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"58_ActualHourDataImport", (Locale)ctx.getLocale()));
            }
        }
        info.setNumber(number);
        info.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
    }

    private void checkCanEdit(Context ctx, OtherFeeBillInfo info, OtherFeeBillInfo compaareInfo) throws BOSException {
        if (!BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)compaareInfo.getBillStatus())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"61_ActualHourDataImport", (Locale)ctx.getLocale()) + compaareInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"62_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
    }

    private OtherFeeBillEntryInfo parseEntry(Map<Object, Object> hsData, Context ctx) throws BOSException, EASBizException, TaskExternalException {
        CostObjectRelatedInfo costObjectRelatedInfo;
        Object objectData;
        Locale locale = ctx.getLocale();
        OtherFeeBillEntryInfo otherFeeBillEntry = new OtherFeeBillEntryInfo();
        Object data = this.getData(hsData, "expense");
        ExpenseInfo expense = this.importUtil.getExpenseInfoByNumber(ctx, data, this.getResource("EXPENSE_NUMBER", ctx), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"144_ExpenseDataImport", (Locale)locale));
        otherFeeBillEntry.setExpense(expense);
        this.checkExpense(ctx, expense, data);
        boolean allocQty = expense.isIsAllocateQty();
        data = this.getData(hsData, "costItem");
        CostItemInfo costItem = this.importUtil.getCostItemInfoByNumber(ctx, data, this.getResource("COSTITEM_NUMBER", ctx), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"84_CostItemDataImport", (Locale)locale));
        this.checkCostItem(ctx, costItem, data);
        otherFeeBillEntry.setCostItem(costItem);
        data = this.getData(hsData, "qty");
        if (allocQty) {
            int qtyPrecision = 8;
            if (expense.getUnit() != null) {
                qtyPrecision = expense.getUnit().getQtyPrecision();
            }
            if (data != null && data.toString().trim().length() > 0) {
                otherFeeBillEntry.setQty(this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"157_InitBalanceMatDetailDataImport", (Locale)locale), data, qtyPrecision));
            } else {
                otherFeeBillEntry.setQty(BigDecimal.ZERO);
            }
        } else if (data != null && data.toString().trim().length() > 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"196_OtherFeeBillDataImport", (Locale)locale));
        }
        data = this.getData(hsData, "price");
        if (allocQty) {
            int pricePrecision = expense.getPricePrecision();
            if (data != null && data.toString().trim().length() > 0) {
                otherFeeBillEntry.setPrice(this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"158_InitBalanceMatDetailDataImport", (Locale)locale), data, pricePrecision));
            } else {
                otherFeeBillEntry.setPrice(BigDecimal.ZERO);
            }
        } else if (data != null && data.toString().trim().length() > 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"197_OtherFeeBillDataImport", (Locale)locale));
        }
        int amountPrecision = 2;
        if (this.baseCurrencyInfo != null) {
            amountPrecision = this.baseCurrencyInfo.getPrecision();
        }
        if ((data = this.getData(hsData, "amount")) == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"165_InitBalanceMatDetailDataImport", (Locale)locale));
        }
        otherFeeBillEntry.setAmount(this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"159_InitBalanceMatDetailDataImport", (Locale)locale), data, amountPrecision));
        if (allocQty) {
            this.recalculate(otherFeeBillEntry);
        }
        if ((data = this.getData(hsData, "costObjectSuite")) != null && data.toString().trim().length() > 0) {
            otherFeeBillEntry.setCostObjectSuite(NCMDataImportUtil.getCostObjectSuitebyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"198_OtherFeeBillDataImport", (Locale)locale), (String)data.toString(), (String)this.company.getId().toString()));
        }
        if ((objectData = this.getData(hsData, "costObject")) == null) {
            objectData = "";
        }
        Object orderData = this.getData(hsData, "manufactureOrder");
        Object matData = this.getData(hsData, "material");
        Object storageData = this.getData(hsData, "storage.number");
        Object batchNumber = this.getData(hsData, "batchNumber");
        if (objectData.toString().trim().length() > 0) {
            CostObjectInfo costObjectInfo = NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"247_GLFetchDataImport", (Locale)locale), (String)objectData.toString(), (String)this.company.getId().toString());
            if (costObjectInfo != null && costObjectInfo.isIsForbiden()) {
                throw new BOSException(costObjectInfo.getNumber() + "\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5");
            }
            costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByCO((Context)ctx, (CostObjectInfo)costObjectInfo);
            if (costObjectRelatedInfo != null) {
                otherFeeBillEntry.setCostObject(costObjectRelatedInfo.getCostObjectInfo());
            }
        }
        if (objectData.equals("") && !orderData.equals("") && orderData.toString().trim().length() > 0) {
            ManufactureOrderInfo orderInfo = NCMDataImportUtil.getManufactureOrderByNumber((Context)ctx, (String)"\u751f\u4ea7\u8ba2\u5355", (String)orderData.toString(), (String)this.company.getId().toString(), (String)storageData.toString());
            if (!orderInfo.getBaseStatus().toString().equals("\u4e0b\u8fbe")) {
                throw new BOSException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u53f7");
            }
            costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByOrder((Context)ctx, (ManufactureOrderInfo)orderInfo, (String)this.company.getId().toString());
            if (costObjectRelatedInfo != null) {
                otherFeeBillEntry.setCostObject(costObjectRelatedInfo.getCostObjectInfo());
            }
        }
        if (objectData.equals("") && orderData.equals("") && !matData.equals("") && matData.toString().trim().length() > 0) {
            MaterialInfo materialInfo = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)"\u7269\u6599", (String)matData.toString());
            if (!materialInfo.getStatus().toString().equals("\u6838\u51c6")) {
                throw new BOSException("\u7269\u6599" + materialInfo.getName() + "\u975e\u6cd5");
            }
            costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByMat((Context)ctx, (MaterialInfo)materialInfo, (String)batchNumber.toString());
            if (costObjectRelatedInfo != null) {
                otherFeeBillEntry.setCostObject(costObjectRelatedInfo.getCostObjectInfo());
            } else {
                if (batchNumber.toString().equals("")) {
                    throw new BOSException("\u8bf7\u5f55\u5165\u6279\u6b21");
                }
                throw new BOSException("\u7269\u6599 + \u6279\u6b21\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6210\u672c\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
            }
        }
        return otherFeeBillEntry;
    }

    private void verifyHead(Context ctx, OtherFeeBillInfo otherFeeBill) throws BOSException {
        this.checkCostCenter(ctx, otherFeeBill);
        this.checkSourceCostCenter(ctx, otherFeeBill);
    }

    private void checkCostCenter(Context ctx, OtherFeeBillInfo otherFeeBillInfo) throws BOSException {
        NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)otherFeeBillInfo.getCostCenter(), (String)otherFeeBillInfo.getCompanyOrg().getId().toString());
    }

    private void checkSourceCostCenter(Context ctx, OtherFeeBillInfo otherFeeBillInfo) throws BOSException {
        if (otherFeeBillInfo.getSourceCostCenter() != null) {
            NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)otherFeeBillInfo.getSourceCostCenter(), (String)otherFeeBillInfo.getCompanyOrg().getId().toString());
        }
    }

    private void checkExpense(Context ctx, ExpenseInfo expense, Object data) throws TaskExternalException {
        Locale locale = ctx.getLocale();
        if (expense == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"EXPENSE_NOT_EXIST", (Locale)locale, (Object[])new Object[]{data}));
        }
        this.importUtil.checkExpenseTypeIsOther(ctx, expense);
        this.importUtil.checkExpenseCompanyInfo(ctx, expense.getId().toString(), this.company.getId().toString(), expense.getNumber(), this.company.getNumber());
        this.importUtil.checkDataBaseDPermission(ctx, this.cu.getId().toString(), expense.getCU().getId().toString(), expense.getId().toString(), expense.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"131_ExpenseCompanyInfoDataImport", (Locale)locale));
    }

    private void checkCostItem(Context ctx, CostItemInfo costItem, Object data) throws TaskExternalException {
        Locale locale = ctx.getLocale();
        if (costItem == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"COST_ITEM_NOT_EXIST", (Locale)locale, (Object[])new Object[]{data}));
        }
        this.importUtil.checkCostItemTypeIsOther(ctx, costItem);
        this.importUtil.checkDataBaseDPermission(ctx, this.cu.getId().toString(), costItem.getCU().getId().toString(), costItem.getId().toString(), costItem.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"137_ExpenseCompanyInfoDataImport", (Locale)locale));
    }

    private void recalculate(OtherFeeBillEntryInfo entry) {
        ExpenseInfo expenseInfo = entry.getExpense();
        int pricePrecision = expenseInfo.getPricePrecision();
        int qtyPrecision = 8;
        if (expenseInfo.getUnit() != null) {
            qtyPrecision = expenseInfo.getUnit().getQtyPrecision();
        }
        BigDecimal qty = entry.getQty();
        BigDecimal price = entry.getPrice();
        BigDecimal amount = entry.getAmount();
        if (qty.compareTo(BigDecimal.ZERO) != 0) {
            price = amount.divide(qty, pricePrecision, RoundingMode.HALF_UP);
            entry.setPrice(price);
        } else if (qty.compareTo(BigDecimal.ZERO) == 0 && price.compareTo(BigDecimal.ZERO) != 0) {
            qty = amount.divide(price, qtyPrecision, RoundingMode.HALF_UP);
            entry.setQty(qty);
        }
    }
}

