/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.IUnitStandardHour;
import com.kingdee.eas.ncm.bill.UnitStandardHourCollection;
import com.kingdee.eas.ncm.bill.UnitStandardHourFactory;
import com.kingdee.eas.ncm.bill.UnitStandardHourInfo;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMBatchDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class UnitStandardHourDataImport
extends AbstractNCMBatchDataImport {
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.UnitStandardHourResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return UnitStandardHourFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        UnitStandardHourInfo actualHour = null;
        try {
            this.initOrgUnit(ctx);
            actualHour = this.parseHead(hsData, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return actualHour;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("costCenter.number", this.getNotBlankString(rs.getString("costCenter.number")));
            result.put("costCenter.name", this.getNotBlankString(rs.getString("costCenter.name")));
            result.put("product.number", this.getNotBlankString(rs.getString("product.number")));
            result.put("product.name", this.getNotBlankString(rs.getString("product.name")));
            result.put("batch", this.getNotBlankString(rs.getString("costObject.batchNumber")));
            result.put("unitStandhour", this.getNotBlankString(rs.getString("stdUnitHour")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.company == null) {
            this.company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        if (this.period == null) {
            try {
                this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private UnitStandardHourInfo parseHead(Hashtable hsData, Context ctx) throws BOSException, TaskExternalException {
        UnitStandardHourInfo actualHour = new UnitStandardHourInfo();
        actualHour.setCompanyOrg(this.company);
        actualHour.setCalculatePeriod(this.period);
        this.dealWithTheCostCenter(ctx, hsData, actualHour);
        this.dealWithTheCostObject(ctx, hsData, actualHour);
        this.dealWithTheNumberByImpMode(ctx, hsData, actualHour);
        this.dealWithTheHour(ctx, hsData, actualHour);
        return actualHour;
    }

    private void dealWithTheCostCenter(Context ctx, Hashtable hsData, UnitStandardHourInfo actualHour) throws BOSException {
        Object data = this.getData(hsData, "costCenter.number");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"64_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        actualHour.setCostCenter(NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"63_ActualHourDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        this.checkCostCenter(ctx, actualHour);
    }

    private void checkCostCenter(Context ctx, UnitStandardHourInfo actualHour) throws BOSException {
        NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)actualHour.getCostCenter(), (String)actualHour.getCompanyOrg().getId().toString());
    }

    private void dealWithTheCostObject(Context ctx, Hashtable hsData, UnitStandardHourInfo actualHour) throws BOSException {
        CostObjectInfo costObject = this.parseCostObject(hsData, ctx);
        if (costObject == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"65_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        actualHour.setCostObject(costObject);
        if (costObject.isIsForbiden()) {
            throw new BOSException(this.getResource(ctx, "CostObjectHasForbidCanNotImport", new Object[]{costObject.getNumber()}));
        }
    }

    private CostObjectInfo parseCostObject(Hashtable hsData, Context ctx) throws BOSException {
        String companyId = this.company.getId().toString();
        Object storageData = this.getData(hsData, "storageOrgUnit.number");
        String storageOrgUnitNumber = null;
        if (storageData != null && storageData.toString().trim().length() > 0) {
            storageOrgUnitNumber = storageData.toString().trim();
        }
        Object costObjectData = this.getData(hsData, "costObject.number");
        String costObjectNumber = null;
        if (costObjectData != null && costObjectData.toString().trim().length() > 0) {
            costObjectNumber = costObjectData.toString().trim();
        }
        Object orderData = this.getData(hsData, "order.number");
        String orderNumber = null;
        if (orderData != null && orderData.toString().trim().length() > 0) {
            orderNumber = orderData.toString().trim();
        }
        Object productData = this.getData(hsData, "product.number");
        String productNumber = null;
        if (productData != null && productData.toString().trim().length() > 0) {
            productNumber = productData.toString().trim();
        }
        Object batchData = this.getData(hsData, "batch");
        String batch = null;
        if (batchData != null && batchData.toString().trim().length() > 0) {
            batch = batchData.toString().trim();
        }
        try {
            if (costObjectNumber != null) {
                return NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)this.getResource(ctx, "CostObjectNumber"), (String)costObjectNumber, (String)companyId);
            }
            if (orderNumber != null) {
                return NCMDataImportUtil.getCostObjectByOrder((Context)ctx, (String)companyId, (String)storageOrgUnitNumber, (String)orderNumber, (String)batch);
            }
            if (productNumber != null) {
                return NCMDataImportUtil.getCostObjectByProduct((Context)ctx, (String)companyId, (String)productNumber, (String)batch);
            }
            throw new BOSException(this.getResource(ctx, "CostObjectOrderMaterialCanNotAllEmpty"));
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void dealWithTheNumberByImpMode(Context ctx, Hashtable hsData, UnitStandardHourInfo actualHour) throws BOSException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrg", (Object)actualHour.getCompanyOrg().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod", (Object)actualHour.getCalculatePeriod().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenter", (Object)actualHour.getCostCenter().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costObject", (Object)actualHour.getCostObject().getId().toString()));
        view.setFilter(filter);
        UnitStandardHourCollection coll = ((IUnitStandardHour)this.getController(ctx)).getUnitStandardHourCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                actualHour.setId(coll.get(0).getId());
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"199_UnitStandardHourDataImport", (Locale)ctx.getLocale()) + actualHour.getCostCenter().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"200_UnitStandardHourDataImport", (Locale)ctx.getLocale()) + actualHour.getCostObject().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"201_UnitStandardHourDataImport", (Locale)ctx.getLocale()));
            }
        }
        actualHour.setNumber(actualHour.getCostCenter().getNumber() + actualHour.getCostObject().getNumber());
        actualHour.setBillStatus(BillBaseStatusEnum.ADD);
    }

    private void dealWithTheHour(Context ctx, Hashtable hsData, UnitStandardHourInfo actualHour) throws BOSException {
        BigDecimal value;
        Object data = this.getData(hsData, "unitStandhour");
        if (data != null && data.toString().trim().length() > 0) {
            value = this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"6_UnitStandardHourStrategy", (Locale)ctx.getLocale()), data);
            if (NCMConst.ZERO.compareTo(value) > 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"label263", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"202_UnitStandardHourDataImport", (Locale)ctx.getLocale()));
        }
        actualHour.setStdUnitHour(value);
    }

    protected String getResource(Context ctx, String resName) {
        return this.getResource(ctx, resName, null);
    }

    protected String getResource(Context ctx, String resName, Object[] params) {
        if (params != null) {
            return MessageFormat.format(ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale()), params);
        }
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale());
    }

    protected void doBeforeProcessData(Context ctx) throws Exception {
        super.doBeforeProcessData(ctx);
    }

    protected String buildTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T ( \n");
        sql.append("     FID varchar(44), \n");
        this.buildCostCenterSQL(sql);
        this.buildCostObjectSQL(sql);
        this.buildStorageSQL(sql);
        this.buildOrderSQL(sql);
        this.buildProductSQL(sql);
        sql.append("     FBatch nvarchar(255), \n");
        sql.append("     FUnitStandhour decimal(21,8), \n");
        sql.append("     FIndex int default(0) \n");
        sql.append(") \n");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessBlockData(Context ctx, RecordCollection coll) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + this.tempTable + " ( \n");
        sql.append("    FCostCenterNumber, \n");
        sql.append("    FProductNumber, \n");
        sql.append("    FBatch, \n");
        sql.append("    FUnitStandhour, \n");
        sql.append("    FIndex \n");
        sql.append(") values (\n");
        sql.append("    ?, ?, ?, ?, ? \n");
        sql.append(") \n");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < coll.size(); ++i) {
                SimpleRecord record = (SimpleRecord)coll.get(i);
                ++this.index;
                String costCenterNumber = null;
                String productNumber = null;
                String batch = null;
                Object co = null;
                costCenterNumber = this.getData(record, "costCenter.number");
                if (costCenterNumber == null) {
                    this.onDataError(this.index, this.getResource(ctx, "ImportCCIsNotNull"));
                    continue;
                }
                productNumber = this.getData(record, "product.number");
                if (productNumber == null) {
                    this.onDataError(this.index, this.getResource(ctx, "ImportCanotNull"));
                    continue;
                }
                batch = this.getData(record, "batch");
                String unitStandhour = this.getData(record, "unitStandhour");
                if (unitStandhour == null) {
                    this.onDataError(this.index, this.getResource(ctx, "ImportUnitHourIsNull"));
                    continue;
                }
                BigDecimal hour = new BigDecimal(unitStandhour);
                if (hour.compareTo(new BigDecimal(0)) <= 0) {
                    this.onDataError(this.index, this.getResource(ctx, "ImportUnitHour"));
                    continue;
                }
                int j = 0;
                pstmt.setString(++j, costCenterNumber);
                pstmt.setString(++j, productNumber);
                pstmt.setString(++j, batch);
                pstmt.setBigDecimal(++j, hour);
                pstmt.setInt(++j, this.index);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected int doProcessData(Context ctx) throws Exception {
        this.fillAndVerifyCostCenter(ctx);
        this.fillAndVerifyProduct(ctx);
        this.findCostObjectByProduct(ctx);
        this.verifyExcelDuplicate(ctx);
        this.verifyDuplicate(ctx);
        return this.submitData(ctx);
    }

    private void verifyExcelDuplicate(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.FIndex,t.FCostCenterID,t.FProductID,FBatch from " + this.tempTable + " t \n");
        sql.append("where ( \n");
        sql.append("    select count(*) from " + this.tempTable + " tt \n");
        sql.append("          inner join T_BD_MaterialCompanyInfo mac");
        sql.append("               on mac.FMaterialID = tt.FProductID ");
        sql.append("    where tt.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and tt.FProductID = t.FProductID \n");
        sql.append("    and ( mac.FAccountType = 1 or mac.FAccountType = 2 or mac.FAccountType = 3 or mac.FAccountType = 4 \n");
        sql.append("    or mac.FAccountType = 5 and isNull(tt.FBatch,' ') = isNull(t.FBatch,' ')) \n");
        sql.append("\tand mac.FCompanyID = '" + this.getCompanyId() + "' \n");
        sql.append(") > 1 \n");
        sql.append("order by FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, ArrayList<Record>> map = new HashMap<String, ArrayList<Record>>();
        while (rs.next()) {
            Record record = new Record();
            record.index = rs.getInt("FIndex");
            record.costCenterId = rs.getString("FCostCenterID");
            record.costObjectId = rs.getString("FProductID");
            String key = record.costCenterId + "-" + record.costObjectId;
            ArrayList<Record> records = (ArrayList<Record>)map.get(key);
            if (records == null) {
                records = new ArrayList<Record>();
                map.put(key, records);
            }
            records.add(record);
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Record record;
            int i;
            List records = (List)map.get(it.next());
            StringBuffer error = new StringBuffer();
            error.append(this.getResource(ctx, "Record"));
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                error.append(record.index).append(",");
            }
            if (records.size() > 0) {
                error.deleteCharAt(error.length() - 1);
            }
            error.append(this.getResource(ctx, "Repeat"));
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                this.onDataError(record.index, error.toString());
            }
        }
        if (map.size() > 0) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + "  \n");
            sql.append("where ( \n");
            sql.append("    select count(*) from " + this.tempTable + " tt \n");
            sql.append("          inner join T_BD_MaterialCompanyInfo mac");
            sql.append("               on mac.FMaterialID = tt.FProductID ");
            sql.append("    where tt.FCostCenterID = " + this.tempTable + ".FCostCenterID \n");
            sql.append("    and tt.FProductID = " + this.tempTable + ".FProductID \n");
            sql.append("    and ( mac.FAccountType = 1 or mac.FAccountType = 2 or mac.FAccountType = 3 or mac.FAccountType = 4 \n");
            sql.append("    or mac.FAccountType = 5 and isNull(tt.FBatch,' ') = isNull(" + this.tempTable + ".FBatch,' ')) \n");
            sql.append("\tand mac.FCompanyID = '" + this.getCompanyId() + "' \n");
            sql.append(") > 1 \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyDuplicate(Context ctx) throws Exception {
        if (this.isSltImportUpdate()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.FIndex from " + this.tempTable + " t \n");
        sql.append("where exists ( \n");
        sql.append("    select 1 from T_NCM_UnitStandardHour u \n");
        sql.append("    where u.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and u.FMaterialID = t.FProductID \n");
        sql.append("    and u.FCompanyOrg = '" + this.companyId + "' \n");
        sql.append("    and u.FCalculatePeriod = '" + this.periodId + "' \n");
        sql.append(") \n");
        sql.append(" or exists (");
        sql.append("    select 1 from T_NCM_UnitStandardHour u \n");
        sql.append("    where u.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and u.FCostObjectID is null \n");
        sql.append("    and u.FMaterialID = t.FProductID \n");
        sql.append("    and u.FCompanyOrg = '" + this.companyId + "' \n");
        sql.append("    and u.FCalculatePeriod = '" + this.periodId + "' \n");
        sql.append(") \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            this.onDataError(index, this.getResource(ctx, "DataRepeat"));
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where exists ( \n");
            sql.append("    select 1 from T_NCM_UnitStandardHour u \n");
            sql.append("    where u.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
            sql.append("    and u.FMaterialID = t.FProductID \n");
            sql.append("    and u.FCompanyOrg = '" + this.companyId + "' \n");
            sql.append("    and u.FCalculatePeriod = '" + this.periodId + "' \n");
            sql.append(") \n");
            sql.append(" or exists (");
            sql.append("    select 1 from T_NCM_UnitStandardHour u \n");
            sql.append("    where u.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and u.FCostObjectID is null \n");
            sql.append("    and u.FMaterialID = t.FProductID \n");
            sql.append("    and u.FCompanyOrg = '" + this.companyId + "' \n");
            sql.append("    and u.FCalculatePeriod = '" + this.periodId + "' \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private int submitData(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_NCM_UnitStandardHour s set ( \n");
        sql.append("    FStdUnitHour \n");
        sql.append(") = ( \n");
        sql.append("    select FUnitStandhour from " + this.tempTable + " t \n");
        sql.append("    where t.FCostCenterID = s.FCostCenterID \n");
        sql.append("    and t.FCostObjectID = s.FCostObjectID \n");
        sql.append("    and t.FProductID = s.FMaterialID \n");
        sql.append("    and s.FCompanyOrg = '" + this.companyId + "' \n");
        sql.append("    and s.FCalculatePeriod = '" + this.periodId + "' \n");
        sql.append("); \n");
        sql.append("update T_NCM_UnitStandardHour s set ( \n");
        sql.append("    FStdUnitHour \n");
        sql.append(") = ( \n");
        sql.append("    select FUnitStandhour from " + this.tempTable + " t \n");
        sql.append("    where t.FCostCenterID = s.FCostCenterID \n");
        sql.append("    and t.FCostObjectID is null \n");
        sql.append("    and t.FProductID = s.FMaterialID \n");
        sql.append("    and s.FCompanyOrg = '" + this.companyId + "' \n");
        sql.append("    and s.FCalculatePeriod = '" + this.periodId + "' \n");
        sql.append("); \n");
        sql.append("insert into T_NCM_UnitStandardHour ( \n");
        sql.append("    FID, \n");
        sql.append("    FCompanyOrg, \n");
        sql.append("    FCalculatePeriod, \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FMaterialID, \n");
        sql.append("    FStdUnitHour, \n");
        sql.append("    FBillStatus, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    FControlUnitID \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    newbosid('27163B7E'), \n");
        sql.append("    '" + this.companyId + "', \n");
        sql.append("    '" + this.periodId + "', \n");
        sql.append("    t.FCostCenterID, \n");
        sql.append("    t.FCostObjectID, \n");
        sql.append("    t.FProductID, \n");
        sql.append("    t.FUnitStandhour, \n");
        sql.append("    1, \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.cuId + "' \n");
        sql.append("from " + this.tempTable + " t \n");
        sql.append("where not exists ( \n");
        sql.append("    select 1 from T_NCM_UnitStandardHour u \n");
        sql.append("    where u.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and t.FProductID = U.FMaterialID \n");
        sql.append("    and u.FCompanyOrg = '" + this.companyId + "' \n");
        sql.append("    and u.FCalculatePeriod = '" + this.periodId + "' \n");
        sql.append(")  \n");
        sql.append("    AND not exists ( \n");
        sql.append("    select 1 from T_NCM_UnitStandardHour u \n");
        sql.append("    where u.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and u.FCostObjectID  IS NULL \n");
        sql.append("    and t.FProductID = U.FMaterialID \n");
        sql.append("    and u.FCompanyOrg = '" + this.companyId + "' \n");
        sql.append("    and u.FCalculatePeriod = '" + this.periodId + "' \n");
        sql.append("); \n");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("select count(*) from " + this.tempTable + " \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    protected void findCostObjectByProduct(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FCostObjectID \n");
        sql.append(") = ( \n");
        sql.append("    select co.FID \n");
        sql.append("    from T_BD_CostObject co \n");
        sql.append("    join T_BD_Material m \n");
        sql.append("        on m.FID = co.FStdProductIDID \n");
        sql.append("    join T_BD_MaterialCompanyInfo macomp \n");
        sql.append("        on macomp.FmaterialID = m.Fid \n");
        sql.append("    where co.FCompanyID = '" + this.getCompanyId() + "' \n");
        sql.append("\tand macomp.FCompanyID = '" + this.getCompanyId() + "' \n");
        sql.append("    and co.FIsForbiden = 0 \n");
        sql.append("    and m.FID = t.FProductID \n");
        sql.append("    and macomp.Fcreatecobyorder = 0 \n");
        sql.append("    and ( \n");
        sql.append("        co.FCalculateMode = 1 \n");
        sql.append("        or \n");
        sql.append("        co.FCalculateMode = 3 \n");
        sql.append("        or \n");
        sql.append("        co.FCalculateMode = 4 \n");
        sql.append("        and co.FBatchNumber = t.FBatch \n");
        sql.append("    ) \n");
        sql.append(") \n");
        sql.append("where FCostObjectID is null \n");
        sql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.setLength(0);
        sql.append("select data.FIndex,data.FProductNumber,data.FBatch from " + this.getTempTable() + " data \n");
        sql.append("left join T_BD_materialCompanyInfo matFI on matFI.FMaterialID = data.FProductID and FCompanyID = '" + this.getCompanyId() + "' \n");
        sql.append("where data.FCostObjectID is null \n");
        sql.append("and data.FProductID is not null \n");
        sql.append(" AND matFI.FCreateCOByOrder= 0 \n");
        sql.append(" and matFI.FCompanyID = '" + this.getCompanyId() + "'\t\n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String productNumber = rs.getString("FProductNumber");
            String batch = rs.getString("FBatch");
            this.onDataError(index, this.getResource(ctx, "ImportNoFoundMa") + productNumber + this.getResource(ctx, "ImportBath") + (batch == null ? "" : batch) + this.getResource(ctx, "ImportReEntryCO"));
        }
    }

    protected void findProductByCO(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FProductID \n");
        sql.append(") = ( \n");
        sql.append("    select m.FID \n");
        sql.append("    from T_BD_CostObject co \n");
        sql.append("    join T_BD_Material m \n");
        sql.append("        on m.FID = co.FStdProductIDID \n");
        sql.append("    join T_BD_MaterialCompanyInfo macomp \n");
        sql.append("        on macomp.FmaterialID = m.Fid \n");
        sql.append("    where co.FCompanyID = '" + this.getCompanyId() + "' \n");
        sql.append("    and co.FIsForbiden = 0 \n");
        sql.append("    and co.FID = t.FcostobjectID \n");
        sql.append("    and macomp.Fcreatecobyorder = 0 \n");
        sql.append(") \n");
        sql.append("where FCostObjectID is not null \n");
        sql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.setLength(0);
        sql.append("select data.FIndex,data.FProductNumber from " + this.getTempTable() + " data \n");
        sql.append("left join T_BD_materialCompanyInfo matFI on matFI.FMaterialID = data.FProductID and FCompanyID = '" + this.getCompanyId() + "' \n");
        sql.append("where data.FCostObjectID is not null \n");
        sql.append("and data.FProductID is  null \n");
        sql.append(" AND matFI.FCreateCOByOrder= 0 \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String CONumber = rs.getString("FProductNumber");
            this.onDataError(index, this.getResource(ctx, "ImportNoFoundCO") + CONumber + this.getResource(ctx, "ImportReMa"));
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where FCostObjectID is null \n");
            sql.append("and FProductID is not null \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    class Record {
        public int index;
        public String costCenterId;
        public String costCenterNumber;
        public String costObjectId;
        public String costObjectNumber;
        public String orderNumber;
        public String productNumber;

        Record() {
        }
    }
}

