/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.AllocStdUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.IUserDefinedDataD;
import com.kingdee.eas.ncm.bill.UserDefinedDataDCollection;
import com.kingdee.eas.ncm.bill.UserDefinedDataDFactory;
import com.kingdee.eas.ncm.bill.UserDefinedDataDInfo;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;

public class UserDefinedDataDDataImport
extends AbstractNCMDataImport {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return UserDefinedDataDFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        UserDefinedDataDInfo info = null;
        try {
            info = this.parse(ctx, hsData);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("allocStdUnitD.number", this.getNotBlankString(rs.getString("allocStdUnitD.number")));
            result.put("allocStdUnitD.name", this.getNotBlankString(rs.getString("allocStdUnitD.name")));
            result.put("material.number", this.getNotBlankString(rs.getString("material.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("material.name")));
            result.put("standardQty", this.getNotBlankString(rs.getString("standardQty")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getStringValue(Hashtable hsData, String fieldName) {
        String value;
        Object data = this.getData(hsData, fieldName);
        if (data != null && (value = data.toString().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    private UserDefinedDataDInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException, TaskExternalException {
        BigDecimal standardQty;
        UserDefinedDataDInfo info = new UserDefinedDataDInfo();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = company.getId().toString();
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        info.setCalculatePeriod(period);
        String value = this.getStringValue(hsData, "allocStdUnitD.number");
        if (value == null) {
            throw new BOSException(this.getResource("ALLOCSTDUNIT_NUMBER_CANNOT_EMPTY", ctx));
        }
        AllocStdUnitInfo allocStdUnit = NCMDataImportUtil.getAllocStdUnitByNumber((Context)ctx, (String)this.getResource("ALLOCSTDUNIT_NUMBER", ctx), (String)value);
        info.setAllocStdUnitD(allocStdUnit);
        value = this.getStringValue(hsData, "material.number");
        if (value == null) {
            throw new BOSException(this.getResource("MATERIAL_NUMBER_CANNOT_EMPTY", ctx));
        }
        MaterialInfo material = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)this.getResource("MATERIAL_NUMBER", ctx), (String)value);
        info.setMaterial(material);
        info.setUnit(material.getBaseUnit());
        Object data = this.getData(hsData, "standardQty");
        if (data != null && data.toString().trim().length() > 0) {
            standardQty = this.getBigDecimalValueByFeildData(ctx, this.getResource("STANDARDQTY", ctx), data);
            if (standardQty.compareTo(BigDecimal.valueOf(0L)) <= 0) {
                throw new BOSException(this.getResource("STANDARDQTY_MUST_MORETHAN_ZERO", ctx));
            }
        } else {
            throw new BOSException(this.getResource("STANDARDQTY_CANNOT_EMPTY", ctx));
        }
        info.setStandardQty(standardQty);
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this.checkExists(ctx, info);
        this.dealWithTheNumberByImpMode(ctx, info);
        return info;
    }

    private void checkExists(Context ctx, UserDefinedDataDInfo info) throws BOSException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("allocStdUnitD", (Object)info.getAllocStdUnitD().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)info.getMaterial().getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("auditStatus");
        view.setSelector(sic);
        UserDefinedDataDCollection coll = ((IUserDefinedDataD)this.getController(ctx)).getUserDefinedDataDCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                if (coll.get(0).isAuditStatus()) {
                    throw new BOSException(this.getResource("USERDEFINEDDATAD_CHECK1_PART1", ctx) + this.getResource("USERDEFINEDDATAD_CHECK1_PART2", ctx) + info.getAllocStdUnitD().getNumber() + this.getResource("USERDEFINEDDATAD_CHECK1_PART3", ctx) + info.getMaterial().getNumber());
                }
                info.setId(coll.get(0).getId());
            } else {
                throw new BOSException(this.getResource("USERDEFINEDDATAD_CHECK2_PART1", ctx) + this.getResource("USERDEFINEDDATAD_CHECK2_PART2", ctx) + info.getAllocStdUnitD().getNumber() + this.getResource("USERDEFINEDDATAD_CHECK2_PART3", ctx) + info.getMaterial().getNumber());
            }
        }
    }

    private void dealWithTheNumberByImpMode(Context ctx, UserDefinedDataDInfo info) throws BOSException, TaskExternalException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("allocStdUnitD", (Object)info.getAllocStdUnitD().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)info.getMaterial().getId().toString()));
        view.setFilter(filter);
        view.setFilter(filter);
        UserDefinedDataDCollection coll = ((IUserDefinedDataD)this.getController(ctx)).getUserDefinedDataDCollection(view);
        if (coll != null && coll.size() >= 1 && this.isSltImportUpdate()) {
            info.setId(coll.get(0).getId());
        }
    }
}

