/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectEntryCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.ncm.AllocStdUnitCollection;
import com.kingdee.eas.basedata.ncm.AllocStdUnitFactory;
import com.kingdee.eas.basedata.ncm.AllocStdUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.IUserDefinedData;
import com.kingdee.eas.ncm.bill.UserDefinedDataCollection;
import com.kingdee.eas.ncm.bill.UserDefinedDataFactory;
import com.kingdee.eas.ncm.bill.UserDefinedDataInfo;
import com.kingdee.eas.ncm.common.NCMCostTypeEnum;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMBatchDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class UserDefinedDataDataImport
extends AbstractNCMBatchDataImport {
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.UserDefinedDataResource";
    CtrlUnitInfo cu = null;
    private int costType = 0;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return UserDefinedDataFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        UserDefinedDataInfo userDefinedData = null;
        try {
            this.initOrgUnit(ctx);
            userDefinedData = this.parseHead(hsData, ctx);
            Object dc = this.getContextParameter("DC");
            if (dc == null) {
                userDefinedData.setCostType(NCMCostTypeEnum.NORMAL);
            } else {
                userDefinedData.setCalculatePeriod(null);
                userDefinedData.setCostType(NCMCostTypeEnum.DYNAMIC);
            }
            this.checkImportData(ctx, userDefinedData);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return userDefinedData;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("allocStdUnit.number", this.getNotBlankString(rs.getString("allocStdUnit.number")));
            result.put("allocStdUnit.name", this.getNotBlankString(rs.getString("allocStdUnit.name")));
            result.put("costCenter.number", this.getNotBlankString(rs.getString("costCenter.number")));
            result.put("costCenter.name", this.getNotBlankString(rs.getString("costCenter.name")));
            result.put("costObject.number", this.getNotBlankString(rs.getString("costObject.number")));
            result.put("costObject.name", this.getNotBlankString(rs.getString("costObject.name")));
            result.put("storageOrgUnit.number", this.getNotBlankString(rs.getString("storageOrgUnit.number")));
            result.put("order.number", this.getNotBlankString(rs.getString("morder.number")));
            result.put("project.number", this.getNotBlankString(rs.getString("project.number")));
            result.put("track.number", this.getNotBlankString(rs.getString("track.number")));
            result.put("product.number", this.getNotBlankString(rs.getString("product.number")));
            result.put("product.name", this.getNotBlankString(rs.getString("product.name")));
            result.put("batch", this.getNotBlankString(rs.getString("costObject.batchNumber")));
            result.put("material.number", this.getNotBlankString(rs.getString("material.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("material.name")));
            result.put("costItem.number", this.getNotBlankString(rs.getString("costItem.number")));
            result.put("costItem.name", this.getNotBlankString(rs.getString("costItem.name")));
            result.put("qty", this.getNotBlankString(rs.getString("qty")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
        }
        if (this.period == null) {
            try {
                this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private UserDefinedDataInfo parseHead(Hashtable hsData, Context ctx) throws BOSException, TaskExternalException {
        UserDefinedDataInfo userDefinedData = new UserDefinedDataInfo();
        userDefinedData.setCompany(this.company);
        userDefinedData.setCU(this.cu);
        userDefinedData.setCalculatePeriod(this.period);
        Object data = this.getData(hsData, "allocStdUnit.number");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"204_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        userDefinedData.setAllocStdUnit(NCMDataImportUtil.getAllocStdUnitByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"203_UserDefinedDataDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        data = this.getData(hsData, "costCenter.number");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"64_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        userDefinedData.setCostCenter(NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"63_ActualHourDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        CostObjectInfo costObject = this.parseCostObject(hsData, ctx);
        userDefinedData.setCostObject(costObject);
        data = this.getData(hsData, "material.number");
        if (data != null && data.toString().trim().length() > 0) {
            userDefinedData.setMaterial(NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"205_UserDefinedDataDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "costItem.number")) != null && data.toString().trim().length() > 0) {
            userDefinedData.setCostItem(NCMDataImportUtil.getCostItemByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"151_InitBalanceDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "qty")) != null && data.toString().trim().length() > 0) {
            BigDecimal standardQty = this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"206_UserDefinedDataDataImport", (Locale)ctx.getLocale()), data);
            if (standardQty.compareTo(BigDecimal.valueOf(0L)) <= 0) {
                throw new BOSException(this.getResource("STANDARDQTY_MUST_MORETHAN_ZERO", ctx));
            }
            userDefinedData.setQty(standardQty);
        }
        return userDefinedData;
    }

    private CostObjectInfo parseCostObject(Hashtable hsData, Context ctx) throws BOSException {
        String companyId = this.company.getId().toString();
        Object storageData = this.getData(hsData, "storageOrgUnit.number");
        String storageOrgUnitNumber = null;
        if (storageData != null && storageData.toString().trim().length() > 0) {
            storageOrgUnitNumber = storageData.toString().trim();
        }
        Object costObjectData = this.getData(hsData, "costObject.number");
        String costObjectNumber = null;
        if (costObjectData != null && costObjectData.toString().trim().length() > 0) {
            costObjectNumber = costObjectData.toString().trim();
        }
        Object orderData = this.getData(hsData, "order.number");
        String orderNumber = null;
        if (orderData != null && orderData.toString().trim().length() > 0) {
            orderNumber = orderData.toString().trim();
        }
        Object productData = this.getData(hsData, "product.number");
        String productNumber = null;
        if (productData != null && productData.toString().trim().length() > 0) {
            productNumber = productData.toString().trim();
        }
        Object batchData = this.getData(hsData, "batch");
        String batch = null;
        if (batchData != null && batchData.toString().trim().length() > 0) {
            batch = batchData.toString().trim();
        }
        try {
            if (costObjectNumber != null) {
                return NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)this.getResource(ctx, "CostObjectNumber"), (String)costObjectNumber, (String)companyId);
            }
            if (orderNumber != null) {
                return NCMDataImportUtil.getCostObjectByOrder((Context)ctx, (String)companyId, (String)storageOrgUnitNumber, (String)orderNumber, (String)batch);
            }
            if (productNumber != null) {
                return NCMDataImportUtil.getCostObjectByProduct((Context)ctx, (String)companyId, (String)productNumber, (String)batch);
            }
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void checkImportData(Context ctx, UserDefinedDataInfo userDefinedData) throws BOSException, TaskExternalException {
        this.checkAllocStdUnit(ctx, userDefinedData);
        this.checkCostCenter(ctx, userDefinedData);
        this.checkCostObject(ctx, userDefinedData);
        this.checkCostItem(ctx, userDefinedData);
        this.checkByAllocStdType(ctx, userDefinedData);
        this.checkExistByByImpMode(ctx, userDefinedData);
    }

    private void checkAllocStdUnit(Context ctx, UserDefinedDataInfo userDefinedData) throws BOSException {
        if (userDefinedData.getAllocStdUnit().isIsSys()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"193_NCMDataImportUtil", (Locale)ctx.getLocale()) + userDefinedData.getAllocStdUnit().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"207_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)userDefinedData.getAllocStdUnit().getCU().getId().toString(), (String)"9DD41AE3", (String)userDefinedData.getAllocStdUnit().getId().toString(), (String)userDefinedData.getAllocStdUnit().getNumber(), (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"208_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
    }

    private void checkCostCenter(Context ctx, UserDefinedDataInfo userDefinedData) throws BOSException {
        NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)userDefinedData.getCostCenter(), (String)userDefinedData.getCompany().getId().toString());
    }

    private void checkCostObject(Context ctx, UserDefinedDataInfo userDefinedData) throws BOSException {
        CostObjectInfo costObject = userDefinedData.getCostObject();
        if (costObject == null) {
            return;
        }
        if (costObject.isIsForbiden()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + costObject.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"209_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (!CORelatedType.Product.equals((Object)costObject.getRelatedType()) && !CORelatedType.Overhead.equals((Object)costObject.getRelatedType())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + costObject.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"210_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkCostItem(Context ctx, UserDefinedDataInfo userDefinedData) throws BOSException {
        if (userDefinedData.getCostItem() == null) {
            return;
        }
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)userDefinedData.getCostItem().getCU().getId().toString(), (String)"548C5A91", (String)userDefinedData.getCostItem().getId().toString(), (String)userDefinedData.getCostItem().getNumber(), (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"137_ExpenseCompanyInfoDataImport", (Locale)ctx.getLocale()));
    }

    private void checkByAllocStdType(Context ctx, UserDefinedDataInfo userDefinedData) throws BOSException {
        AllocStdTypeEnum type = userDefinedData.getAllocStdUnit().getAllocStdType();
        if (AllocStdTypeEnum.CLASSI == type) {
            this.checkByAllocStdType_CLASSI(ctx, userDefinedData);
        } else if (AllocStdTypeEnum.WIPSTD == type) {
            this.checkByAllocStdType_WIPSTD(ctx, userDefinedData);
        } else if (AllocStdTypeEnum.INNERCC == type && userDefinedData.getAllocStdUnit().isIsToCenter()) {
            this.checkByAllocStdType_INNERCC(ctx, userDefinedData);
        } else if (AllocStdTypeEnum.AUX == type) {
            this.checkByAllocStdType_AUX(ctx, userDefinedData);
        } else {
            this.checkByAllocStdType_INNERPRD(ctx, userDefinedData);
        }
    }

    private void checkByAllocStdType_CLASSI(Context ctx, UserDefinedDataInfo userDefinedData) throws BOSException {
        CostCenterOrgUnitInfo costCenter = userDefinedData.getCostCenter();
        if (!CostCenterType.DirectProdDept.equals((Object)costCenter.getCostCenterType())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + costCenter.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"211_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        CostObjectInfo costObject = userDefinedData.getCostObject();
        MaterialInfo material = userDefinedData.getMaterial();
        CostItemInfo costItem = userDefinedData.getCostItem();
        if (costObject == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"212_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (material == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"213_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (costItem != null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"214_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (!CalculateModeEnum.BYCLASS.equals((Object)costObject.getCalculateMode())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"215_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        this.checkMaterialByClassCO(ctx, costObject, material);
    }

    private void checkMaterialByClassCO(Context ctx, CostObjectInfo costObject, MaterialInfo material) throws BOSException {
        boolean exist = false;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)costObject.getId().toString()));
        view.setFilter(filter);
        String materialId = material.getId().toString();
        CostObjectEntryCollection coll = CostObjectEntryFactory.getLocalInstance((Context)ctx).getCostObjectEntryCollection(view);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                if (!materialId.equals(coll.get(i).getRelatedID().toString()) || coll.get(i).isIsByproduct()) continue;
                exist = true;
                break;
            }
        }
        if (!exist) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + material.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"216_UserDefinedDataDataImport", (Locale)ctx.getLocale()) + costObject.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"217_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkByAllocStdType_WIPSTD(Context ctx, UserDefinedDataInfo userDefinedData) throws BOSException {
        CostCenterOrgUnitInfo costCenter = userDefinedData.getCostCenter();
        if (!CostCenterType.DirectProdDept.equals((Object)costCenter.getCostCenterType())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + costCenter.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"211_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        CostObjectInfo costObject = userDefinedData.getCostObject();
        MaterialInfo material = userDefinedData.getMaterial();
        CostItemInfo costItem = userDefinedData.getCostItem();
        if (costObject == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"218_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (!CORelatedType.Product.equals((Object)costObject.getRelatedType())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"219_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (material != null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"220_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (costItem == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"221_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkByAllocStdType_INNERCC(Context ctx, UserDefinedDataInfo userDefinedData) throws BOSException {
        CostCenterOrgUnitInfo costCenter = userDefinedData.getCostCenter();
        if (!CostCenterType.DirectProdDept.equals((Object)costCenter.getCostCenterType())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + costCenter.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"211_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        CostObjectInfo costObject = userDefinedData.getCostObject();
        MaterialInfo material = userDefinedData.getMaterial();
        CostItemInfo costItem = userDefinedData.getCostItem();
        if (costObject != null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"222_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (material != null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"223_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (costItem != null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"224_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkByAllocStdType_AUX(Context ctx, UserDefinedDataInfo userDefinedData) throws BOSException {
        CostCenterOrgUnitInfo costCenter = userDefinedData.getCostCenter();
        if (!CostCenterType.AssistantProdDept.equals((Object)costCenter.getCostCenterType())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + costCenter.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"225_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        CostObjectInfo costObject = userDefinedData.getCostObject();
        MaterialInfo material = userDefinedData.getMaterial();
        CostItemInfo costItem = userDefinedData.getCostItem();
        if (costObject == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"226_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (!CORelatedType.Overhead.equals((Object)costObject.getRelatedType())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"227_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (material != null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"228_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (costItem != null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"229_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkByAllocStdType_INNERPRD(Context ctx, UserDefinedDataInfo userDefinedData) throws BOSException {
        CostCenterOrgUnitInfo costCenter = userDefinedData.getCostCenter();
        if (!CostCenterType.DirectProdDept.equals((Object)costCenter.getCostCenterType())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + costCenter.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"211_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        CostObjectInfo costObject = userDefinedData.getCostObject();
        MaterialInfo material = userDefinedData.getMaterial();
        CostItemInfo costItem = userDefinedData.getCostItem();
        if (costObject == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"230_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (!CORelatedType.Product.equals((Object)costObject.getRelatedType())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"231_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (material != null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"232_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
        if (costItem != null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"233_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkExistByByImpMode(Context ctx, UserDefinedDataInfo userDefinedData) throws TaskExternalException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)userDefinedData.getCompany().getId().toString()));
        if (userDefinedData.getCalculatePeriod() != null) {
            filter.getFilterItems().add(new FilterItemInfo("calculatePeriod", (Object)userDefinedData.getCalculatePeriod().getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("allocStdUnit", (Object)userDefinedData.getAllocStdUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenter", (Object)userDefinedData.getCostCenter().getId().toString()));
        if (userDefinedData.getCostObject() != null) {
            filter.getFilterItems().add(new FilterItemInfo("costObject", (Object)userDefinedData.getCostObject().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("costObject", null));
        }
        if (userDefinedData.getMaterial() != null) {
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)userDefinedData.getMaterial().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("material", null));
        }
        if (userDefinedData.getCostItem() != null) {
            filter.getFilterItems().add(new FilterItemInfo("costItem", (Object)userDefinedData.getCostItem().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("costItem", null));
        }
        filter.getFilterItems().add(new FilterItemInfo("costType", (Object)String.valueOf(userDefinedData.getCostType().getValue())));
        view.setFilter(filter);
        UserDefinedDataCollection coll = ((IUserDefinedData)this.getController(ctx)).getUserDefinedDataCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                userDefinedData.setId(coll.get(0).getId());
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"234_UserDefinedDataDataImport", (Locale)ctx.getLocale()));
            }
        }
    }

    protected String getResource(Context ctx, String resName) {
        return this.getResource(ctx, resName, null);
    }

    protected String getResource(Context ctx, String resName, Object[] params) {
        if (params != null) {
            return MessageFormat.format(ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale()), params);
        }
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale());
    }

    protected void doBeforeProcessData(Context ctx) throws Exception {
        super.doBeforeProcessData(ctx);
        Object dc = this.getContextParameter("DC");
        this.costType = dc == null ? 1 : 2;
    }

    protected String buildTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T ( \n");
        sql.append("     FID varchar(44), \n");
        this.buildAllocStdUnitSQL(sql);
        this.buildCostCenterSQL(sql);
        this.buildCostObjectSQL(sql);
        this.buildStorageSQL(sql);
        this.buildOrderSQL(sql);
        this.buildProductSQL(sql);
        this.buildCostItemSQL(sql);
        this.buildMaterialSQL(sql);
        sql.append("     FBatch nvarchar(255), \n");
        sql.append("     FQty decimal(21,8), \n");
        sql.append("     FIndex int default(0), \n");
        sql.append("\t FIsToCenter int default(0) \n");
        sql.append(") \n");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessBlockData(Context ctx, RecordCollection coll) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + this.tempTable + " ( \n");
        sql.append("    FAllocStdUnitNumber, \n");
        sql.append("    FCostCenterNumber, \n");
        sql.append("    FCostObjectNumber, \n");
        sql.append("    FStorageOrgUnitNumber, \n");
        sql.append("    FOrderNumber, \n");
        sql.append("    FProductNumber, \n");
        sql.append("    FBatch, \n");
        sql.append("    FCostItemNumber, \n");
        sql.append("    FMaterialNumber, \n");
        sql.append("    FQty, \n");
        sql.append("    FIndex, \n");
        sql.append("\tFIsToCenter \n");
        sql.append(") values (\n");
        sql.append("    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? \n");
        sql.append(") \n");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < coll.size(); ++i) {
                SimpleRecord record = (SimpleRecord)coll.get(i);
                ++this.index;
                String allocStdUnitNumber = null;
                String costCenterNumber = null;
                String costObjectNumber = null;
                String storageOrgUnitNumber = null;
                String orderNumber = null;
                String productNumber = null;
                String batch = null;
                String materialNumber = null;
                String costItemNumber = null;
                allocStdUnitNumber = this.getData(record, "allocStdUnit.number");
                AllocStdUnitInfo allocUnit = null;
                boolean isToCenter = false;
                if (allocStdUnitNumber == null) {
                    this.onDataError(this.index, "\u5206\u914d\u6807\u51c6\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                    continue;
                }
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)allocStdUnitNumber));
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                AllocStdUnitCollection allocUnitCol = AllocStdUnitFactory.getLocalInstance((Context)ctx).getAllocStdUnitCollection(view);
                if (allocUnitCol.size() != 0) {
                    allocUnit = allocUnitCol.get(0);
                }
                if (allocUnit != null) {
                    isToCenter = allocUnit.isIsToCenter();
                }
                if ((costCenterNumber = this.getData(record, "costCenter.number")) == null) {
                    this.onDataError(this.index, "\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                    continue;
                }
                costObjectNumber = this.getData(record, "costObject.number");
                if (costObjectNumber == null) {
                    storageOrgUnitNumber = this.getData(record, "storageOrgUnit.number");
                    orderNumber = this.getData(record, "order.number");
                    if (orderNumber != null) {
                        if (storageOrgUnitNumber == null) {
                            this.onDataError(this.index, "\u901a\u8fc7\u8ba2\u5355\u627e\u6210\u672c\u5bf9\u8c61\uff0c\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                            continue;
                        }
                    } else {
                        productNumber = this.getData(record, "product.number");
                    }
                }
                batch = this.getData(record, "batch");
                costItemNumber = this.getData(record, "costItem.number");
                materialNumber = this.getData(record, "material.number");
                String qty = this.getData(record, "qty");
                if (qty == null) {
                    this.onDataError(this.index, "\u6807\u51c6\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                    continue;
                }
                BigDecimal bdQty = null;
                try {
                    bdQty = new BigDecimal(qty);
                }
                catch (Exception e) {
                    this.onDataError(this.index, "\u6807\u51c6\u6570\u503c\u8f6c\u6362\u53d1\u751f\u9519\u8bef\u3002");
                    continue;
                }
                int j = 0;
                pstmt.setString(++j, allocStdUnitNumber);
                pstmt.setString(++j, costCenterNumber);
                pstmt.setString(++j, costObjectNumber);
                pstmt.setString(++j, storageOrgUnitNumber);
                pstmt.setString(++j, orderNumber);
                pstmt.setString(++j, productNumber);
                pstmt.setString(++j, batch);
                pstmt.setString(++j, costItemNumber);
                pstmt.setString(++j, materialNumber);
                pstmt.setBigDecimal(++j, bdQty);
                pstmt.setInt(++j, this.index);
                pstmt.setBoolean(++j, isToCenter);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected int doProcessData(Context ctx) throws Exception {
        this.fillAndVerifyAllocStdUnit(ctx);
        this.fillAndVerifyCostCenter(ctx);
        this.fillAndVerifyCostObject(ctx);
        this.fillAndVerifyStorage(ctx);
        this.fillAndVerifyOrder(ctx);
        this.fillAndVerifyProduct(ctx);
        this.fillAndVerifyMaterial(ctx);
        this.fillAndVerifyCostItem(ctx);
        this.findCostObjectByOrder(ctx);
        this.findCostObjectByProduct(ctx);
        this.verifyAllocStdType(ctx);
        this.verifyExcelDuplicate(ctx);
        this.verifyDuplicate(ctx);
        return this.submitData(ctx);
    }

    private void verifyAllocStdType(Context ctx) throws Exception {
        this.verifyAllocStdTypeINNERCC(ctx);
        this.verifyAllocStdTypeINNERPRD(ctx);
        this.verifyAllocStdTypeWIPSTD(ctx);
        this.verifyAllocStdTypeCLASSI(ctx);
        this.verifyAllocStdTypeAUX(ctx);
    }

    private void verifyAllocStdTypeINNERCC(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 1 \n");
        sql.append("and t.FIsToCenter = 1 \n");
        sql.append("and ( t.FCostCenterType <> 0 \n");
        sql.append("    or t.FCostObjectID is not null \n");
        sql.append("    or t.FMaterialID is not null \n");
        sql.append("    or t.FCostItemID is not null \n");
        sql.append(") \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String costCenterNumber = rs.getString("FCostCenterNumber");
            int costCenterType = rs.getInt("FCostCenterType");
            if (costCenterType != 0) {
                this.onDataError(index, "\u7f16\u7801\u4e3a" + costCenterNumber + "\u7684\u6210\u672c\u4e2d\u5fc3 \u4e0d\u662f\u76f4\u63a5\u751f\u4ea7\u90e8\u95e8\uff01");
                continue;
            }
            String costObjectId = rs.getString("FCostObjectID");
            if (costObjectId != null) {
                this.onDataError(index, "\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143(\u4ec5\u5230\u6210\u672c\u4e2d\u5fc3)\u751f\u6210\u6570\u636e\u65f6\u6210\u672c\u5bf9\u8c61\u5fc5\u987b\u4e3a\u7a7a\uff01");
                continue;
            }
            String materialId = rs.getString("FMaterialID");
            if (materialId != null) {
                this.onDataError(index, "\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143(\u4ec5\u5230\u6210\u672c\u4e2d\u5fc3)\u751f\u6210\u6570\u636e\u65f6\u7269\u6599\u5fc5\u987b\u4e3a\u7a7a\uff01");
                continue;
            }
            String costItemId = rs.getString("FCostItemID");
            if (costItemId == null) continue;
            this.onDataError(index, "\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143(\u4ec5\u5230\u6210\u672c\u4e2d\u5fc3)\u751f\u6210\u6570\u636e\u65f6\u6210\u672c\u9879\u76ee\u5fc5\u987b\u4e3a\u7a7a\uff01");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 1 \n");
            sql.append("and t.FIsToCenter = 1 \n");
            sql.append("and ( t.FCostCenterType <> 0 \n");
            sql.append("    or t.FCostObjectID is not null \n");
            sql.append("    or t.FMaterialID is not null \n");
            sql.append("    or t.FCostItemID is not null \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyAllocStdTypeINNERPRD(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 2 \n");
        sql.append("and ( t.FCostCenterType <> 0 \n");
        sql.append("    or t.FCostObjectID is null \n");
        sql.append("    or t.FCostObjectRelatedType <> 0 \n");
        sql.append("    or t.FMaterialID is not null \n");
        sql.append("    or t.FCostItemID is not null \n");
        sql.append(") \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String costCenterNumber = rs.getString("FCostCenterNumber");
            int costCenterType = rs.getInt("FCostCenterType");
            if (costCenterType != 0) {
                this.onDataError(index, "\u7f16\u7801\u4e3a" + costCenterNumber + "\u7684\u6210\u672c\u4e2d\u5fc3 \u4e0d\u662f\u76f4\u63a5\u751f\u4ea7\u90e8\u95e8\uff01");
                continue;
            }
            String costObjectId = rs.getString("FCostObjectID");
            if (costObjectId == null) {
                this.onDataError(index, "\u4ea7\u54c1\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143 \u6216 \u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143 \u751f\u6210\u6570\u636e\u65f6\u6210\u672c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                continue;
            }
            int relatedType = rs.getInt("FCostObjectRelatedType");
            if (relatedType != 0) {
                this.onDataError(index, "\u4ea7\u54c1\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143 \u6216 \u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143 \u751f\u6210\u6570\u636e\u65f6\u7684\u6210\u672c\u5bf9\u8c61\u53ea\u80fd\u4e3a\u4ea7\u54c1\u578b\u7684\uff01");
                continue;
            }
            String materialId = rs.getString("FMaterialID");
            if (materialId != null) {
                this.onDataError(index, "\u4ea7\u54c1\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143 \u6216 \u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143 \u751f\u6210\u6570\u636e\u65f6\u7269\u6599\u5fc5\u987b\u4e3a\u7a7a\uff01");
                continue;
            }
            String costItemId = rs.getString("FCostItemID");
            if (costItemId == null) continue;
            this.onDataError(index, "\u4ea7\u54c1\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143 \u6216 \u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143 \u751f\u6210\u6570\u636e\u65f6\u6210\u672c\u9879\u76ee\u5fc5\u987b\u4e3a\u7a7a\uff01");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 2 \n");
            sql.append("and ( t.FCostCenterType <> 0 \n");
            sql.append("    or t.FCostObjectID is null \n");
            sql.append("    or t.FCostObjectRelatedType <> 0 \n");
            sql.append("    or t.FMaterialID is not null \n");
            sql.append("    or t.FCostItemID is not null \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyAllocStdTypeWIPSTD(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 3 \n");
        sql.append("and ( t.FCostCenterType <> 0 \n");
        sql.append("    or t.FCostObjectID is null \n");
        sql.append("    or t.FCostObjectRelatedType <> 0 \n");
        sql.append("    or t.FMaterialID is not null \n");
        sql.append("    or t.FCostItemID is null \n");
        sql.append(") \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String costCenterNumber = rs.getString("FCostCenterNumber");
            int costCenterType = rs.getInt("FCostCenterType");
            if (costCenterType != 0) {
                this.onDataError(index, "\u7f16\u7801\u4e3a" + costCenterNumber + "\u7684\u6210\u672c\u4e2d\u5fc3 \u4e0d\u662f\u76f4\u63a5\u751f\u4ea7\u90e8\u95e8\uff01");
                continue;
            }
            String costObjectId = rs.getString("FCostObjectID");
            if (costObjectId == null) {
                this.onDataError(index, "\u5728\u4ea7\u54c1\u6210\u672c\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u6210\u672c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                continue;
            }
            int relatedType = rs.getInt("FCostObjectRelatedType");
            if (relatedType != 0) {
                this.onDataError(index, "\u5728\u4ea7\u54c1\u6210\u672c\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u7684\u6210\u672c\u5bf9\u8c61\u53ea\u80fd\u4e3a\u4ea7\u54c1\u578b\u7684\uff01");
                continue;
            }
            String materialId = rs.getString("FMaterialID");
            if (materialId != null) {
                this.onDataError(index, "\u5728\u4ea7\u54c1\u6210\u672c\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u7269\u6599\u5fc5\u987b\u4e3a\u7a7a\uff01");
                continue;
            }
            String costItemId = rs.getString("FCostItemID");
            if (costItemId != null) continue;
            this.onDataError(index, "\u5728\u4ea7\u54c1\u6210\u672c\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u6210\u672c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 3 \n");
            sql.append("and ( t.FCostCenterType <> 0 \n");
            sql.append("    or t.FCostObjectID is null \n");
            sql.append("    or t.FCostObjectRelatedType <> 0 \n");
            sql.append("    or t.FMaterialID is not null \n");
            sql.append("    or t.FCostItemID is null \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyAllocStdTypeCLASSI(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.*, coe.FID FRelatedID from " + this.tempTable + " t \n");
        sql.append("left join t_bd_costObject co on co.FID = t.FCostObjectID \n");
        sql.append("left join t_bd_costObjectentry coe on coe.FParentID = co.FID \n");
        sql.append("    and coe.FRelatedID = t.FMaterialID \n");
        sql.append("where t.FAllocStdUnitType = 4 \n");
        sql.append("and ( t.FCostCenterType <> 0 \n");
        sql.append("    or t.FCostObjectID is null \n");
        sql.append("    or t.FCostObjectCalculateMode <> 3 \n");
        sql.append("    or t.FMaterialID is null \n");
        sql.append("    or t.FCostItemID is not null \n");
        sql.append(") \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String costCenterNumber = rs.getString("FCostCenterNumber");
            String materialNumber = rs.getString("FMaterialNumber");
            String costObjectNumber = rs.getString("FCostObjectNumber");
            int costCenterType = rs.getInt("FCostCenterType");
            if (costCenterType != 0) {
                this.onDataError(index, "\u7f16\u7801\u4e3a" + costCenterNumber + "\u7684\u6210\u672c\u4e2d\u5fc3 \u4e0d\u662f\u76f4\u63a5\u751f\u4ea7\u90e8\u95e8\uff01");
                continue;
            }
            String costObjectId = rs.getString("FCostObjectID");
            if (costObjectId == null) {
                this.onDataError(index, "\u5206\u7c7b\u6cd5\u6210\u672c\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u6210\u672c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                continue;
            }
            String materialId = rs.getString("FMaterialID");
            if (materialId == null) {
                this.onDataError(index, "\u5206\u7c7b\u6cd5\u6210\u672c\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                continue;
            }
            String costItemId = rs.getString("FCostItemID");
            if (costItemId != null) {
                this.onDataError(index, "\u5206\u7c7b\u6cd5\u6210\u672c\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u6210\u672c\u9879\u76ee\u5fc5\u987b\u4e3a\u7a7a\uff01");
                continue;
            }
            int calculateMode = rs.getInt("FCostObjectCalculateMode");
            if (calculateMode != 3) {
                this.onDataError(index, "\u5206\u7c7b\u6cd5\u6210\u672c\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u53ea\u80fd\u5904\u7406\u5206\u7c7b\u6cd5\u6210\u672c\u5bf9\u8c61\uff01");
                continue;
            }
            String relatedID = rs.getString("FRelatedID");
            if (relatedID == null) continue;
            this.onDataError(index, "\u7f16\u7801\u4e3a" + materialNumber + " \u7684\u7269\u6599\u4e0d\u662f\u7f16\u7801\u4e3a " + costObjectNumber + " \u5206\u7c7b\u6cd5\u6210\u672c\u5bf9\u8c61\u7684\u975e\u526f\u4ea7\u54c1\u7684\u81ea\u5236\u7269\u6599\uff01");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 4 \n");
            sql.append("and ( t.FCostCenterType <> 0 \n");
            sql.append("    t.FCostObjectID is null \n");
            sql.append("    or t.FMaterialID is null \n");
            sql.append("    or t.FCostItemID is not null \n");
            sql.append("    or not exists ( \n");
            sql.append("        select 1 from t_bd_costObject co \n");
            sql.append("        join t_bd_costObjectentry coe on coe.FParentID = co.FID \n");
            sql.append("        where co.FID = t.FCostObjectID \n");
            sql.append("        and coe.FRelatedID = t.FMaterialID \n");
            sql.append("        and co.FCalculateMode = 3 \n");
            sql.append("    ) \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyAllocStdTypeAUX(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 5 \n");
        sql.append("and ( t.FCostCenterType <> 1 \n");
        sql.append("    or t.FCostObjectID is null \n");
        sql.append("    or t.FCostObjectRelatedType <> 3 \n");
        sql.append("    or t.FMaterialID is not null \n");
        sql.append("    or t.FCostItemID is not null \n");
        sql.append(") \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String costCenterNumber = rs.getString("FCostCenterNumber");
            int costCenterType = rs.getInt("FCostCenterType");
            if (costCenterType != 0) {
                this.onDataError(index, "\u7f16\u7801\u4e3a" + costCenterNumber + "\u7684\u6210\u672c\u4e2d\u5fc3 \u4e0d\u662f\u8f85\u52a9\u751f\u4ea7\u90e8\u95e8\uff01");
                continue;
            }
            String costObjectId = rs.getString("FCostObjectID");
            if (costObjectId == null) {
                this.onDataError(index, "\u8d39\u7528\u6210\u672c\u5bf9\u8c61\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u6210\u672c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                continue;
            }
            int relatedType = rs.getInt("FCostObjectRelatedType");
            if (relatedType != 3) {
                this.onDataError(index, "\u8d39\u7528\u6210\u672c\u5bf9\u8c61\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u7684\u6210\u672c\u5bf9\u8c61\u53ea\u80fd\u4e3a\u8d39\u7528\u578b\u7684\uff01");
                continue;
            }
            String materialId = rs.getString("FMaterialID");
            if (materialId != null) {
                this.onDataError(index, "\u8d39\u7528\u6210\u672c\u5bf9\u8c61\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u7269\u6599\u5fc5\u987b\u4e3a\u7a7a\uff01");
                continue;
            }
            String costItemId = rs.getString("FCostItemID");
            if (costItemId == null) continue;
            this.onDataError(index, "\u8d39\u7528\u6210\u672c\u5bf9\u8c61\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5355\u5143\u751f\u6210\u6570\u636e\u65f6\u6210\u672c\u9879\u76ee\u5fc5\u987b\u4e3a\u7a7a\uff01");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 5 \n");
            sql.append("and ( t.FCostCenterType <> 1 \n");
            sql.append("    or t.FCostObjectID is null \n");
            sql.append("    or t.FCostObjectRelatedType <> 3 \n");
            sql.append("    or t.FMaterialID is not null \n");
            sql.append("    or t.FCostItemID is not null \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyExcelDuplicate(Context ctx) throws Exception {
        this.verifyExcelDuplicateINNERCC(ctx);
        this.verifyExcelDuplicateINNERPRD(ctx);
        this.verifyExcelDuplicateWIPSTD(ctx);
        this.verifyExcelDuplicateCLASSI(ctx);
        this.verifyExcelDuplicateAUX(ctx);
    }

    private void verifyExcelDuplicateINNERCC(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 1 \n");
        sql.append("and ( \n");
        sql.append("    select count(*) from " + this.tempTable + " tt \n");
        sql.append("    where tt.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and tt.FCostCenterID = t.FCostCenterID and tt.FCostObjectID = t.FCostObjectID \n");
        sql.append(") > 1 \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, ArrayList<Record>> map = new HashMap<String, ArrayList<Record>>();
        while (rs.next()) {
            Record record = new Record();
            record.index = rs.getInt("FIndex");
            record.allocStdUnitId = rs.getString("FAllocStdUnitID");
            record.costCenterId = rs.getString("FCostCenterID");
            record.costObjectId = rs.getString("FCostObjectID");
            String key = record.allocStdUnitId + "-" + record.costCenterId + record.costObjectId;
            ArrayList<Record> records = (ArrayList<Record>)map.get(key);
            if (records == null) {
                records = new ArrayList<Record>();
                map.put(key, records);
            }
            records.add(record);
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Record record;
            int i;
            List records = (List)map.get(it.next());
            StringBuffer error = new StringBuffer();
            error.append("\u8bb0\u5f55");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                error.append(record.index).append(",");
            }
            if (records.size() > 0) {
                error.deleteCharAt(error.length() - 1);
            }
            error.append("\u53d1\u751f\u91cd\u590d\uff0c \u4e0d\u80fd\u65b0\u589e\u76f8\u540c\u7ec4\u5408\u7684\u6570\u636e!");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                this.onDataError(record.index, error.toString());
            }
        }
        if (map.size() > 0) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 1 \n");
            sql.append("and ( \n");
            sql.append("    select count(*) from " + this.tempTable + " tt \n");
            sql.append("    where tt.FAllocStdUnitID = t.FAllocStdUnitID \n");
            sql.append("    and tt.FCostCenterID = t.FCostCenterID \n");
            sql.append(") > 1 \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyExcelDuplicateINNERPRD(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 2 \n");
        sql.append("and ( \n");
        sql.append("    select count(*) from " + this.tempTable + " tt \n");
        sql.append("    where tt.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and tt.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and tt.FCostObjectID = t.FCostObjectID \n");
        sql.append(") > 1 \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, ArrayList<Record>> map = new HashMap<String, ArrayList<Record>>();
        while (rs.next()) {
            Record record = new Record();
            record.index = rs.getInt("FIndex");
            record.allocStdUnitId = rs.getString("FAllocStdUnitID");
            record.costCenterId = rs.getString("FCostCenterID");
            record.costObjectId = rs.getString("FCostObjectID");
            String key = record.allocStdUnitId + "-" + record.costCenterId + "-" + record.costObjectId;
            ArrayList<Record> records = (ArrayList<Record>)map.get(key);
            if (records == null) {
                records = new ArrayList<Record>();
                map.put(key, records);
            }
            records.add(record);
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Record record;
            int i;
            List records = (List)map.get(it.next());
            StringBuffer error = new StringBuffer();
            error.append("\u8bb0\u5f55");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                error.append(record.index).append(",");
            }
            if (records.size() > 0) {
                error.deleteCharAt(error.length() - 1);
            }
            error.append("\u53d1\u751f\u91cd\u590d\uff0c \u4e0d\u80fd\u65b0\u589e\u76f8\u540c\u7ec4\u5408\u7684\u6570\u636e!");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                this.onDataError(record.index, error.toString());
            }
        }
        if (map.size() > 0) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 2 \n");
            sql.append("and ( \n");
            sql.append("    select count(*) from " + this.tempTable + " tt \n");
            sql.append("    where tt.FAllocStdUnitID = t.FAllocStdUnitID \n");
            sql.append("    and tt.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and tt.FCostObjectID = t.FCostObjectID \n");
            sql.append(") > 1 \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyExcelDuplicateWIPSTD(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 3 \n");
        sql.append("and ( \n");
        sql.append("    select count(*) from " + this.tempTable + " tt \n");
        sql.append("    where tt.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and tt.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and tt.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and tt.FCostItemID = t.FCostItemID \n");
        sql.append(") > 1 \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, ArrayList<Record>> map = new HashMap<String, ArrayList<Record>>();
        while (rs.next()) {
            Record record = new Record();
            record.index = rs.getInt("FIndex");
            record.allocStdUnitId = rs.getString("FAllocStdUnitID");
            record.costCenterId = rs.getString("FCostCenterID");
            record.costObjectId = rs.getString("FCostObjectID");
            record.costItemId = rs.getString("FCostItemID");
            String key = record.allocStdUnitId + "-" + record.costCenterId + "-" + record.costObjectId + "-" + record.costItemId;
            ArrayList<Record> records = (ArrayList<Record>)map.get(key);
            if (records == null) {
                records = new ArrayList<Record>();
                map.put(key, records);
            }
            records.add(record);
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Record record;
            int i;
            List records = (List)map.get(it.next());
            StringBuffer error = new StringBuffer();
            error.append("\u8bb0\u5f55");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                error.append(record.index).append(",");
            }
            if (records.size() > 0) {
                error.deleteCharAt(error.length() - 1);
            }
            error.append("\u53d1\u751f\u91cd\u590d\uff0c \u4e0d\u80fd\u65b0\u589e\u76f8\u540c\u7ec4\u5408\u7684\u6570\u636e!");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                this.onDataError(record.index, error.toString());
            }
        }
        if (map.size() > 0) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 3 \n");
            sql.append("and ( \n");
            sql.append("    select count(*) from " + this.tempTable + " tt \n");
            sql.append("    where tt.FAllocStdUnitID = t.FAllocStdUnitID \n");
            sql.append("    and tt.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and tt.FCostObjectID = t.FCostObjectID \n");
            sql.append("    and tt.FCostItemID = t.FCostItemID \n");
            sql.append(") > 1 \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyExcelDuplicateCLASSI(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 4 \n");
        sql.append("and ( \n");
        sql.append("    select count(*) from " + this.tempTable + " tt \n");
        sql.append("    where tt.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and tt.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and tt.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and tt.FMaterialID = t.FMaterialID \n");
        sql.append(") > 1 \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, ArrayList<Record>> map = new HashMap<String, ArrayList<Record>>();
        while (rs.next()) {
            Record record = new Record();
            record.index = rs.getInt("FIndex");
            record.allocStdUnitId = rs.getString("FAllocStdUnitID");
            record.costCenterId = rs.getString("FCostCenterID");
            record.costObjectId = rs.getString("FCostObjectID");
            record.materialId = rs.getString("FMaterialID");
            String key = record.allocStdUnitId + "-" + record.costCenterId + "-" + record.costObjectId + "-" + record.materialId;
            ArrayList<Record> records = (ArrayList<Record>)map.get(key);
            if (records == null) {
                records = new ArrayList<Record>();
                map.put(key, records);
            }
            records.add(record);
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Record record;
            int i;
            List records = (List)map.get(it.next());
            StringBuffer error = new StringBuffer();
            error.append("\u8bb0\u5f55");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                error.append(record.index).append(",");
            }
            if (records.size() > 0) {
                error.deleteCharAt(error.length() - 1);
            }
            error.append("\u53d1\u751f\u91cd\u590d\uff0c \u4e0d\u80fd\u65b0\u589e\u76f8\u540c\u7ec4\u5408\u7684\u6570\u636e!");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                this.onDataError(record.index, error.toString());
            }
        }
        if (map.size() > 0) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 4 \n");
            sql.append("and ( \n");
            sql.append("    select count(*) from " + this.tempTable + " tt \n");
            sql.append("    where tt.FAllocStdUnitID = t.FAllocStdUnitID \n");
            sql.append("    and tt.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and tt.FCostObjectID = t.FCostObjectID \n");
            sql.append("    and tt.FMaterialID = t.FMaterialID \n");
            sql.append(") > 1 \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyExcelDuplicateAUX(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 5 \n");
        sql.append("and ( \n");
        sql.append("    select count(*) from " + this.tempTable + " tt \n");
        sql.append("    where tt.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and tt.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and tt.FCostObjectID = t.FCostObjectID \n");
        sql.append(") > 1 \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, ArrayList<Record>> map = new HashMap<String, ArrayList<Record>>();
        while (rs.next()) {
            Record record = new Record();
            record.index = rs.getInt("FIndex");
            record.allocStdUnitId = rs.getString("FAllocStdUnitID");
            record.costCenterId = rs.getString("FCostCenterID");
            record.costObjectId = rs.getString("FCostObjectID");
            String key = record.allocStdUnitId + "-" + record.costCenterId + "-" + record.costObjectId;
            ArrayList<Record> records = (ArrayList<Record>)map.get(key);
            if (records == null) {
                records = new ArrayList<Record>();
                map.put(key, records);
            }
            records.add(record);
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Record record;
            int i;
            List records = (List)map.get(it.next());
            StringBuffer error = new StringBuffer();
            error.append("\u8bb0\u5f55");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                error.append(record.index).append(",");
            }
            if (records.size() > 0) {
                error.deleteCharAt(error.length() - 1);
            }
            error.append("\u53d1\u751f\u91cd\u590d\uff0c \u4e0d\u80fd\u65b0\u589e\u76f8\u540c\u7ec4\u5408\u7684\u6570\u636e!");
            for (i = 0; i < records.size(); ++i) {
                record = (Record)records.get(i);
                this.onDataError(record.index, error.toString());
            }
        }
        if (map.size() > 0) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 5 \n");
            sql.append("and ( \n");
            sql.append("    select count(*) from " + this.tempTable + " tt \n");
            sql.append("    where tt.FAllocStdUnitID = t.FAllocStdUnitID \n");
            sql.append("    and tt.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and tt.FCostObjectID = t.FCostObjectID \n");
            sql.append(") > 1 \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyDuplicate(Context ctx) throws Exception {
        this.verifyDuplicateINNERCC(ctx);
        this.verifyDuplicateINNERPRD(ctx);
        this.verifyDuplicateWIPSTD(ctx);
        this.verifyDuplicateCLASSI(ctx);
        this.verifyDuplicateAUX(ctx);
    }

    private void verifyDuplicateINNERCC(Context ctx) throws Exception {
        if (this.isSltImportUpdate()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 1 \n");
        sql.append("and exists ( \n");
        sql.append("    select 1 from T_NCM_UserDefinedData u \n");
        sql.append("    where u.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and u.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and u.FCompanyID = '" + this.companyId + "' \n");
        if (this.costType == 1) {
            sql.append("    and u.FCalculatePeriodID = '" + this.periodId + "' \n");
        }
        sql.append("    and u.FCostType = " + this.costType + " \n");
        sql.append(") \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            this.onDataError(index, "\u6570\u636e\u91cd\u590d\uff0c\u4e0d\u80fd\u65b0\u589e\u76f8\u540c\u7ec4\u5408\u7684\u6570\u636e!");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 1 \n");
            sql.append("and exists ( \n");
            sql.append("    select 1 from T_NCM_UserDefinedData u \n");
            sql.append("    where u.FAllocStdUnitID = t.FAllocStdUnitID \n");
            sql.append("    and u.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and u.FCompanyID = '" + this.companyId + "' \n");
            if (this.costType == 1) {
                sql.append("    and u.FCalculatePeriodID = '" + this.periodId + "' \n");
            }
            sql.append("    and u.FCostType = " + this.costType + " \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyDuplicateINNERPRD(Context ctx) throws Exception {
        if (this.isSltImportUpdate()) {
            return;
        }
        this.dumpData(ctx, null);
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 2 \n");
        sql.append("and exists ( \n");
        sql.append("    select 1 from T_NCM_UserDefinedData u \n");
        sql.append("    where u.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and u.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and u.FCompanyID = '" + this.companyId + "' \n");
        if (this.costType == 1) {
            sql.append("    and u.FCalculatePeriodID = '" + this.periodId + "' \n");
        }
        sql.append("    and u.FCostType = " + this.costType + " \n");
        sql.append(") \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            this.onDataError(index, "\u6570\u636e\u91cd\u590d\uff0c\u4e0d\u80fd\u65b0\u589e\u76f8\u540c\u7ec4\u5408\u7684\u6570\u636e!");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 2 \n");
            sql.append("and exists ( \n");
            sql.append("    select 1 from T_NCM_UserDefinedData u \n");
            sql.append("    where u.FAllocStdUnitID = t.FAllocStdUnitID \n");
            sql.append("    and u.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
            sql.append("    and u.FCompanyID = '" + this.companyId + "' \n");
            if (this.costType == 1) {
                sql.append("    and u.FCalculatePeriodID = '" + this.periodId + "' \n");
            }
            sql.append("    and u.FCostType = " + this.costType + " \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyDuplicateWIPSTD(Context ctx) throws Exception {
        if (this.isSltImportUpdate()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select * from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 3 \n");
        sql.append("and exists ( \n");
        sql.append("    select 1 from T_NCM_UserDefinedData u \n");
        sql.append("    where u.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and u.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and u.FCostItemID = t.FCostItemID \n");
        sql.append("    and u.FCompanyID = '" + this.companyId + "' \n");
        if (this.costType == 1) {
            sql.append("    and u.FCalculatePeriodID = '" + this.periodId + "' \n");
        }
        sql.append("    and u.FCostType = " + this.costType + " \n");
        sql.append(") \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            this.onDataError(index, "\u6570\u636e\u91cd\u590d\uff0c\u4e0d\u80fd\u65b0\u589e\u76f8\u540c\u7ec4\u5408\u7684\u6570\u636e!");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 3 \n");
            sql.append("and exists ( \n");
            sql.append("    select 1 from T_NCM_UserDefinedData u \n");
            sql.append("    where u.FAllocStdUnitID = t.FAllocStdUnitID \n");
            sql.append("    and u.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
            sql.append("    and u.FCostItemID = t.FCostItemID \n");
            sql.append("    and u.FCompanyID = '" + this.companyId + "' \n");
            if (this.costType == 1) {
                sql.append("    and u.FCalculatePeriodID = '" + this.periodId + "' \n");
            }
            sql.append("    and u.FCostType = " + this.costType + " \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyDuplicateCLASSI(Context ctx) throws Exception {
        if (this.isSltImportUpdate()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select * from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 4 \n");
        sql.append("and exists ( \n");
        sql.append("    select 1 from T_NCM_UserDefinedData u \n");
        sql.append("    where u.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and u.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and u.FMaterialID = t.FMaterialID \n");
        sql.append("    and u.FCompanyID = '" + this.companyId + "' \n");
        if (this.costType == 1) {
            sql.append("    and u.FCalculatePeriodID = '" + this.periodId + "' \n");
        }
        sql.append("    and u.FCostType = " + this.costType + " \n");
        sql.append(") \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            this.onDataError(index, "\u6570\u636e\u91cd\u590d\uff0c\u4e0d\u80fd\u65b0\u589e\u76f8\u540c\u7ec4\u5408\u7684\u6570\u636e!");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 4 \n");
            sql.append("and exists ( \n");
            sql.append("    select 1 from T_NCM_UserDefinedData u \n");
            sql.append("    where u.FAllocStdUnitID = t.FAllocStdUnitID \n");
            sql.append("    and u.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
            sql.append("    and u.FMaterialID = t.FMaterialID \n");
            sql.append("    and u.FCompanyID = '" + this.companyId + "' \n");
            if (this.costType == 1) {
                sql.append("    and u.FCalculatePeriodID = '" + this.periodId + "' \n");
            }
            sql.append("    and u.FCostType = " + this.costType + " \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void verifyDuplicateAUX(Context ctx) throws Exception {
        if (this.isSltImportUpdate()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select t.* from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 5 \n");
        sql.append("and exists ( \n");
        sql.append("    select 1 from T_NCM_UserDefinedData u \n");
        sql.append("    where u.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and u.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and u.FCompanyID = '" + this.companyId + "' \n");
        if (this.costType == 1) {
            sql.append("    and u.FCalculatePeriodID = '" + this.periodId + "' \n");
        }
        sql.append("    and u.FCostType = " + this.costType + " \n");
        sql.append(") \n");
        sql.append("order by t.FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            this.onDataError(index, "\u6570\u636e\u91cd\u590d\uff0c\u4e0d\u80fd\u65b0\u589e\u76f8\u540c\u7ec4\u5408\u7684\u6570\u636e!");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.tempTable + " t \n");
            sql.append("where t.FAllocStdUnitType = 5 \n");
            sql.append("and exists ( \n");
            sql.append("    select 1 from T_NCM_UserDefinedData u \n");
            sql.append("    where u.FAllocStdUnitID = t.FAllocStdUnitID \n");
            sql.append("    and u.FCostCenterID = t.FCostCenterID \n");
            sql.append("    and u.FCostObjectID = t.FCostObjectID \n");
            sql.append("    and u.FCompanyID = '" + this.companyId + "' \n");
            if (this.costType == 1) {
                sql.append("    and u.FCalculatePeriodID = '" + this.periodId + "' \n");
            }
            sql.append("    and u.FCostType = " + this.costType + " \n");
            sql.append(") \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private int submitData(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        this.submitDataForINNERCC(ctx, sql);
        this.submitDataForINNERPRD(ctx, sql);
        this.submitDataForWIPSTD(ctx, sql);
        this.submitDataForCLASSI(ctx, sql);
        this.submitDataForAUX(ctx, sql);
        if (sql.length() > 0) {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        }
        sql.setLength(0);
        sql.append("select count(*) from " + this.tempTable + " \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    private void submitDataForINNERCC(Context ctx, StringBuffer sql) throws Exception {
        if (sql == null) {
            sql = new StringBuffer();
        }
        if (this.isSltImportUpdate()) {
            sql.append("update T_NCM_UserDefinedData d set ( \n");
            sql.append("    FQty \n");
            sql.append(") = ( \n");
            sql.append("    select FQty from " + this.tempTable + " t \n");
            sql.append("    where t.FAllocStdUnitType = 1 \n");
            sql.append("    and t.FAllocStdUnitID = d.FAllocStdUnitID \n");
            sql.append("    and t.FCostCenterID = d.FCostCenterID \n");
            sql.append("    and t.FCostObjectID = d.FCostObjectID \n");
            sql.append("    and d.FCompanyID = '" + this.companyId + "' \n");
            if (this.costType == 1) {
                sql.append("    and d.FCalculatePeriodID = '" + this.periodId + "' \n");
            }
            sql.append("    and d.FCostType = " + this.costType + " \n");
            sql.append("); \n");
        }
        sql.append("insert into T_NCM_UserDefinedData ( \n");
        sql.append("    FID, \n");
        sql.append("    FCompanyID, \n");
        sql.append("    FCalculatePeriodID, \n");
        sql.append("    FAllocStdUnitID, \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FCostItemID, \n");
        sql.append("    FmaterialID, \n");
        sql.append("    FQty, \n");
        sql.append("    FCostType, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    FControlUnitID \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    newbosid('42102BCF'), \n");
        sql.append("    '" + this.companyId + "', \n");
        if (this.costType == 1) {
            sql.append("    '" + this.periodId + "', \n");
        } else {
            sql.append("    null, \n");
        }
        sql.append("    t.FAllocStdUnitID, \n");
        sql.append("    t.FCostCenterID, \n");
        sql.append("    t.FCostObjectID, \n");
        sql.append("    null, \n");
        sql.append("    null, \n");
        sql.append("    t.FQty, \n");
        sql.append("    " + this.costType + ", \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.cuId + "' \n");
        sql.append("from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 1 \n");
        sql.append("and not exists ( \n");
        sql.append("    select 1 from T_NCM_UserDefinedData d \n");
        sql.append("    where d.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and d.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and d.FCostObjectID = t.FCostObjectID \n");
        sql.append("    and d.FCompanyID = '" + this.companyId + "' \n");
        if (this.costType == 1) {
            sql.append("    and d.FCalculatePeriodID = '" + this.periodId + "' \n");
        }
        sql.append("    and d.FCostType = " + this.costType + " \n");
        sql.append("); \n");
    }

    private void submitDataForINNERPRD(Context ctx, StringBuffer sql) throws Exception {
        if (sql == null) {
            sql = new StringBuffer();
        }
        if (this.isSltImportUpdate()) {
            sql.append("update T_NCM_UserDefinedData d set ( \n");
            sql.append("    FQty \n");
            sql.append(") = ( \n");
            sql.append("    select FQty from " + this.tempTable + " t \n");
            sql.append("    where t.FAllocStdUnitType = 2 \n");
            sql.append("    and t.FAllocStdUnitID = d.FAllocStdUnitID \n");
            sql.append("    and t.FCostCenterID = d.FCostCenterID \n");
            sql.append("    and t.FCostObjectID = d.FCostObjectID \n");
            sql.append("    and d.FCompanyID = '" + this.companyId + "' \n");
            if (this.costType == 1) {
                sql.append("    and d.FCalculatePeriodID = '" + this.periodId + "' \n");
            }
            sql.append("    and d.FCostType = " + this.costType + " \n");
            sql.append("); \n");
        }
        sql.append("insert into T_NCM_UserDefinedData ( \n");
        sql.append("    FID, \n");
        sql.append("    FCompanyID, \n");
        sql.append("    FCalculatePeriodID, \n");
        sql.append("    FAllocStdUnitID, \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FCostItemID, \n");
        sql.append("    FmaterialID, \n");
        sql.append("    FQty, \n");
        sql.append("    FCostType, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    FControlUnitID \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    newbosid('42102BCF'), \n");
        sql.append("    '" + this.companyId + "', \n");
        if (this.costType == 1) {
            sql.append("    '" + this.periodId + "', \n");
        } else {
            sql.append("    null, \n");
        }
        sql.append("    t.FAllocStdUnitID, \n");
        sql.append("    t.FCostCenterID, \n");
        sql.append("    t.FCostObjectID, \n");
        sql.append("    null, \n");
        sql.append("    null, \n");
        sql.append("    t.FQty, \n");
        sql.append("    " + this.costType + ", \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.cuId + "' \n");
        sql.append("from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 2 \n");
        sql.append("and not exists ( \n");
        sql.append("    select 1 from T_NCM_UserDefinedData d \n");
        sql.append("    where d.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and d.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and t.FCostObjectID = d.FCostObjectID \n");
        sql.append("    and d.FCompanyID = '" + this.companyId + "' \n");
        if (this.costType == 1) {
            sql.append("    and d.FCalculatePeriodID = '" + this.periodId + "' \n");
        }
        sql.append("    and d.FCostType = " + this.costType + " \n");
        sql.append("); \n");
    }

    private void submitDataForWIPSTD(Context ctx, StringBuffer sql) throws Exception {
        if (sql == null) {
            sql = new StringBuffer();
        }
        if (this.isSltImportUpdate()) {
            sql.append("update T_NCM_UserDefinedData d set ( \n");
            sql.append("    FQty \n");
            sql.append(") = ( \n");
            sql.append("    select FQty from " + this.tempTable + " t \n");
            sql.append("    where t.FAllocStdUnitType = 3 \n");
            sql.append("    and t.FAllocStdUnitID = d.FAllocStdUnitID \n");
            sql.append("    and t.FCostCenterID = d.FCostCenterID \n");
            sql.append("    and t.FCostObjectID = d.FCostObjectID \n");
            sql.append("    and t.FCostItemID = d.FCostItemID \n");
            sql.append("    and d.FCompanyID = '" + this.companyId + "' \n");
            if (this.costType == 1) {
                sql.append("    and d.FCalculatePeriodID = '" + this.periodId + "' \n");
            }
            sql.append("    and d.FCostType = " + this.costType + " \n");
            sql.append("); \n");
        }
        sql.append("insert into T_NCM_UserDefinedData ( \n");
        sql.append("    FID, \n");
        sql.append("    FCompanyID, \n");
        sql.append("    FCalculatePeriodID, \n");
        sql.append("    FAllocStdUnitID, \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FCostItemID, \n");
        sql.append("    FmaterialID, \n");
        sql.append("    FQty, \n");
        sql.append("    FCostType, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    FControlUnitID \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    newbosid('42102BCF'), \n");
        sql.append("    '" + this.companyId + "', \n");
        if (this.costType == 1) {
            sql.append("    '" + this.periodId + "', \n");
        } else {
            sql.append("    null, \n");
        }
        sql.append("    t.FAllocStdUnitID, \n");
        sql.append("    t.FCostCenterID, \n");
        sql.append("    t.FCostObjectID, \n");
        sql.append("    t.FCostItemID, \n");
        sql.append("    null, \n");
        sql.append("    t.FQty, \n");
        sql.append("    " + this.costType + ", \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.cuId + "' \n");
        sql.append("from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 3 \n");
        sql.append("and not exists ( \n");
        sql.append("    select 1 from T_NCM_UserDefinedData d \n");
        sql.append("    where d.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and d.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and t.FCostObjectID = d.FCostObjectID \n");
        sql.append("    and t.FCostItemID = d.FCostItemID \n");
        sql.append("    and d.FCompanyID = '" + this.companyId + "' \n");
        if (this.costType == 1) {
            sql.append("    and d.FCalculatePeriodID = '" + this.periodId + "' \n");
        }
        sql.append("    and d.FCostType = " + this.costType + " \n");
        sql.append("); \n");
    }

    private void submitDataForCLASSI(Context ctx, StringBuffer sql) throws Exception {
        if (sql == null) {
            sql = new StringBuffer();
        }
        if (this.isSltImportUpdate()) {
            sql.append("update T_NCM_UserDefinedData d set ( \n");
            sql.append("    FQty \n");
            sql.append(") = ( \n");
            sql.append("    select FQty from " + this.tempTable + " t \n");
            sql.append("    where t.FAllocStdUnitType = 4 \n");
            sql.append("    and t.FAllocStdUnitID = d.FAllocStdUnitID \n");
            sql.append("    and t.FCostCenterID = d.FCostCenterID \n");
            sql.append("    and t.FCostObjectID = d.FCostObjectID \n");
            sql.append("    and t.FMaterialID = d.FMaterialID \n");
            sql.append("    and d.FCompanyID = '" + this.companyId + "' \n");
            if (this.costType == 1) {
                sql.append("    and d.FCalculatePeriodID = '" + this.periodId + "' \n");
            }
            sql.append("    and d.FCostType = " + this.costType + " \n");
            sql.append("); \n");
        }
        sql.append("insert into T_NCM_UserDefinedData ( \n");
        sql.append("    FID, \n");
        sql.append("    FCompanyID, \n");
        sql.append("    FCalculatePeriodID, \n");
        sql.append("    FAllocStdUnitID, \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FCostItemID, \n");
        sql.append("    FmaterialID, \n");
        sql.append("    FQty, \n");
        sql.append("    FCostType, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    FControlUnitID \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    newbosid('42102BCF'), \n");
        sql.append("    '" + this.companyId + "', \n");
        if (this.costType == 1) {
            sql.append("    '" + this.periodId + "', \n");
        } else {
            sql.append("    null, \n");
        }
        sql.append("    t.FAllocStdUnitID, \n");
        sql.append("    t.FCostCenterID, \n");
        sql.append("    t.FCostObjectID, \n");
        sql.append("    null, \n");
        sql.append("    t.FMaterialID, \n");
        sql.append("    t.FQty, \n");
        sql.append("    " + this.costType + ", \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.cuId + "' \n");
        sql.append("from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 4 \n");
        sql.append("and not exists ( \n");
        sql.append("    select 1 from T_NCM_UserDefinedData d \n");
        sql.append("    where d.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and d.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and t.FCostObjectID = d.FCostObjectID \n");
        sql.append("    and t.FMaterialID = d.FMaterialID \n");
        sql.append("    and d.FCompanyID = '" + this.companyId + "' \n");
        if (this.costType == 1) {
            sql.append("    and d.FCalculatePeriodID = '" + this.periodId + "' \n");
        }
        sql.append("    and d.FCostType = " + this.costType + " \n");
        sql.append("); \n");
    }

    private void submitDataForAUX(Context ctx, StringBuffer sql) throws Exception {
        if (sql == null) {
            sql = new StringBuffer();
        }
        if (this.isSltImportUpdate()) {
            sql.append("update T_NCM_UserDefinedData d set ( \n");
            sql.append("    FQty \n");
            sql.append(") = ( \n");
            sql.append("    select FQty from " + this.tempTable + " t \n");
            sql.append("    where t.FAllocStdUnitType = 5 \n");
            sql.append("    and t.FAllocStdUnitID = d.FAllocStdUnitID \n");
            sql.append("    and t.FCostCenterID = d.FCostCenterID \n");
            sql.append("    and t.FCostObjectID = d.FCostObjectID \n");
            sql.append("    and d.FCompanyID = '" + this.companyId + "' \n");
            if (this.costType == 1) {
                sql.append("    and d.FCalculatePeriodID = '" + this.periodId + "' \n");
            }
            sql.append("    and d.FCostType = " + this.costType + " \n");
            sql.append("); \n");
        }
        sql.append("insert into T_NCM_UserDefinedData ( \n");
        sql.append("    FID, \n");
        sql.append("    FCompanyID, \n");
        sql.append("    FCalculatePeriodID, \n");
        sql.append("    FAllocStdUnitID, \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FCostItemID, \n");
        sql.append("    FmaterialID, \n");
        sql.append("    FQty, \n");
        sql.append("    FCostType, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    FControlUnitID \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    newbosid('42102BCF'), \n");
        sql.append("    '" + this.companyId + "', \n");
        if (this.costType == 1) {
            sql.append("    '" + this.periodId + "', \n");
        } else {
            sql.append("    null, \n");
        }
        sql.append("    t.FAllocStdUnitID, \n");
        sql.append("    t.FCostCenterID, \n");
        sql.append("    t.FCostObjectID, \n");
        sql.append("    null, \n");
        sql.append("    null, \n");
        sql.append("    t.FQty, \n");
        sql.append("    " + this.costType + ", \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.cuId + "' \n");
        sql.append("from " + this.tempTable + " t \n");
        sql.append("where t.FAllocStdUnitType = 5 \n");
        sql.append("and not exists ( \n");
        sql.append("    select 1 from T_NCM_UserDefinedData d \n");
        sql.append("    where d.FAllocStdUnitID = t.FAllocStdUnitID \n");
        sql.append("    and d.FCostCenterID = t.FCostCenterID \n");
        sql.append("    and t.FCostObjectID = d.FCostObjectID \n");
        sql.append("    and d.FCompanyID = '" + this.companyId + "' \n");
        if (this.costType == 1) {
            sql.append("    and d.FCalculatePeriodID = '" + this.periodId + "' \n");
        }
        sql.append("    and d.FCostType = " + this.costType + " \n");
        sql.append("); \n");
    }

    private String dumpData(Context ctx, StringBuffer sql) throws Exception {
        if (sql == null) {
            sql = new StringBuffer();
        }
        StringBuffer data = new StringBuffer();
        if (sql.length() > 0) {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
        }
        sql.setLength(0);
        sql.append("select * from " + this.tempTable + " order by FIndex \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            data.append("FAllocStdUnitID:" + rs.getString("FAllocStdUnitID")).append("\n");
            data.append("FAllocStdUnitNumber:" + rs.getString("FAllocStdUnitNumber")).append("\n");
            data.append("FCostCenterID:" + rs.getString("FCostCenterID")).append("\n");
            data.append("FCostCenterNumber:" + rs.getString("FCostCenterNumber")).append("\n");
            data.append("FCostObjectID:" + rs.getString("FCostObjectID")).append("\n");
            data.append("FCostObjectNumber:" + rs.getString("FCostObjectNumber")).append("\n");
            data.append("FOrderID:" + rs.getString("FOrderID")).append("\n");
            data.append("FOrderNumber:" + rs.getString("FOrderNumber")).append("\n");
            data.append("FProductID:" + rs.getString("FProductID")).append("\n");
            data.append("FProductNumber:" + rs.getString("FProductNumber")).append("\n");
            data.append("FQty:" + rs.getString("FQty")).append("\n");
            data.append("\n\n");
        }
        sql.setLength(0);
        return data.toString();
    }

    class Record {
        public int index;
        public String allocStdUnitId;
        public String costCenterId;
        public String costCenterNumber;
        public String costObjectId;
        public String costObjectNumber;
        public String orderNumber;
        public String productNumber;
        public String costItemId;
        public String costItemNumber;
        public String materialId;
        public String materialNumber;

        Record() {
        }
    }
}

