/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.IWIPCountingMaterial;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.WIPCntMatSourceTypeEnum;
import com.kingdee.eas.ncm.bill.WIPCountingMaterialFactory;
import com.kingdee.eas.ncm.bill.WIPCountingMaterialInfo;
import com.kingdee.eas.ncm.common.CMBillBaseCollection;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class WIPCountingMaterialDataImport
extends AbstractNCMDataImport {
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.WIPCountingMaterialResource";
    private int wipType = -1;
    private Map costCenterMap = new HashMap();
    private Map materialMap = new HashMap();
    private Map costObjectMap = new HashMap();
    private Map costObjectSuiteMap = new HashMap();
    CompanyOrgUnitInfo company = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return WIPCountingMaterialFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        WIPCountingMaterialInfo info = null;
        if (this.company == null) {
            this.company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        try {
            info = this.parse(ctx, hsData);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private boolean isQtyWipType(Context ctx) {
        if (this.wipType >= 0) {
            return this.wipType == 0;
        }
        try {
            this.wipType = NCMUtils.isQtyWipType((Context)ctx, (String)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()) ? 0 : 1;
        }
        catch (Exception e) {
            this.wipType = -1;
            ExceptionHandler.handle((Throwable)e);
        }
        return this.wipType == 0;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("companyOrg.name", this.getNotBlankString(rs.getString("companyOrg.name")));
            result.put("calculatePeriod.number", this.getNotBlankString(rs.getString("calculatePeriod.number")));
            result.put("costCenter.number", this.getNotBlankString(rs.getString("costCenter.number")));
            result.put("costCenter.name", this.getNotBlankString(rs.getString("costCenter.name")));
            result.put("material.number", this.getNotBlankString(rs.getString("material.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("material.name")));
            result.put("batch", this.getNotBlankString(rs.getString("batch")));
            if (this.isQtyWipType(ctx)) {
                result.put("qty", this.getNotBlankString(rs.getString("qty")));
            } else {
                result.put("amount", this.getNotBlankString(rs.getString("amount")));
            }
            result.put("costObject.number", this.getNotBlankString(rs.getString("costObject.number")));
            result.put("costObject.name", this.getNotBlankString(rs.getString("costObject.name")));
            result.put("storageOrgUnit.number", this.getNotBlankString(rs.getString("storageOrgUnit.number")));
            result.put("order.number", this.getNotBlankString(rs.getString("morder.number")));
            result.put("project.number", this.getNotBlankString(rs.getString("project.number")));
            result.put("track.number", this.getNotBlankString(rs.getString("track.number")));
            result.put("product.number", this.getNotBlankString(rs.getString("product.number")));
            result.put("product.name", this.getNotBlankString(rs.getString("product.name")));
            result.put("batch2", this.getNotBlankString(rs.getString("costObject.batchNumber")));
            result.put("costObjectSuite.number", this.getNotBlankString(rs.getString("costObjectSuite.number")));
            result.put("costObjectSuite.name", this.getNotBlankString(rs.getString("costObjectSuite.name")));
            result.put("costItem.number", this.getNotBlankString(rs.getString("costItem.number")));
            result.put("costItem.name", this.getNotBlankString(rs.getString("costItem.name")));
            String isInWH = this.getResource("NO", ctx);
            if ("true".equals(this.getNotBlankString(rs.getString("isInWH")))) {
                isInWH = this.getResource("YES", ctx);
            }
            result.put("isInWH", isInWH);
            result.put("remark", this.getNotBlankString(rs.getString("remark")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getStringValue(Hashtable hsData, String fieldName) {
        String value;
        Object data = this.getData(hsData, fieldName);
        if (data != null && (value = data.toString().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WIPCountingMaterialInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException, TaskExternalException {
        Object data;
        WIPCountingMaterialInfo info = new WIPCountingMaterialInfo();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = company.getId().toString();
        info.setCompanyOrg(company);
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)company.getId().toString());
        info.setCalculatePeriod(period);
        String value = this.getStringValue(hsData, "costCenter.number");
        if (value == null) throw new BOSException(this.getResource("COSTCENTER_NUMBER_CANNOT_EMPTY", ctx));
        CostCenterOrgUnitInfo costCenter = (CostCenterOrgUnitInfo)this.costCenterMap.get(value);
        if (costCenter == null) {
            costCenter = NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)this.getResource("COSTCENTER_NUMBER", ctx), (String)value);
            NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)costCenter, (String)companyId);
            if (!CostCenterType.DirectProdDept.equals((Object)costCenter.getCostCenterType())) {
                String msg = MessageFormat.format(this.getResource("COSTCENTER_NOT_DirectProdDept", ctx), costCenter.getNumber());
                throw new BOSException(msg);
            }
            this.costCenterMap.put(value, costCenter);
        }
        info.setCostCenter(costCenter);
        value = this.getStringValue(hsData, "material.number");
        if (value == null) throw new BOSException(this.getResource("MATERIAL_NUMBER_CANNOT_EMPTY", ctx));
        MaterialInfo material = (MaterialInfo)this.materialMap.get(value);
        if (material == null) {
            material = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)this.getResource("MATERIAL_NUMBER", ctx), (String)value);
            this.materialMap.put(value, material);
        }
        NCMDataImportUtil.getMaterialCompanyInfoByMaterial((Context)ctx, (String)material.getNumber(), (String)material.getId().toString(), (String)company.getId().toString());
        info.setMaterial(material);
        info.setUnit(material.getBaseUnit());
        value = this.getStringValue(hsData, "batch");
        if (value != null) {
            info.setBatch(value);
        }
        if (this.isQtyWipType(ctx)) {
            data = this.getData(hsData, "qty");
            if (data == null || data.toString().trim().length() <= 0) throw new BOSException(this.getResource("QTY_CANNOT_EMPTY", ctx));
            BigDecimal qty = this.getBigDecimalValueByFeildData(ctx, this.getResource("QTY", ctx), data);
            if (qty.compareTo(BigDecimal.valueOf(0L)) <= 0) {
                throw new NcmBillException(NcmBillException.CHECK_QTY_MUST_MORETHAN_ZERO);
            }
            info.setQty(qty);
            info.setBaseQty(qty);
            if (info.getMaterial().getAssistUnit() != null) {
                info.setAssistQty(qty);
            }
        } else {
            data = this.getData(hsData, "amount");
            if (data == null || data.toString().trim().length() <= 0) throw new BOSException(this.getResource("AMOUNT_CANNOT_EMPTY", ctx));
            BigDecimal amount = this.getBigDecimalValueByFeildData(ctx, this.getResource("AMOUNT", ctx), data);
            if (amount.compareTo(BigDecimal.valueOf(0L)) <= 0) {
                throw new NcmBillException(NcmBillException.CHECK_AMOUNT_MUST_MORETHAN_ZERO);
            }
            info.setAmount(amount);
        }
        CostObjectInfo costObject = this.parseCostObject(hsData, ctx);
        info.setCostObject(costObject);
        if (info.getCostObject() == null) {
            info.setIsInWH(true);
        } else if (costObject.isIsForbiden()) {
            throw new BOSException(this.getResource(ctx, "CostObjectHasForbidCanNotImport", new Object[]{costObject.getNumber()}));
        }
        value = this.getStringValue(hsData, "costObjectSuite.number");
        if (value != null) {
            CostObjectSuiteInfo costObjectSuite = (CostObjectSuiteInfo)this.costObjectSuiteMap.get(value);
            if (costObjectSuite == null) {
                costObjectSuite = NCMDataImportUtil.getCostObjectSuitebyNumber((Context)ctx, (String)this.getResource("COSTOBJECTSUITE_NUMBER", ctx), (String)value, (String)companyId);
                this.costObjectSuiteMap.put(value, costObjectSuite);
            }
            info.setCostObjectSuite(costObjectSuite);
        }
        if ((value = this.getStringValue(hsData, "costItem.number")) == null) throw new BOSException(this.getResource("COSTITEM_NUMBER_CANNOT_EMPTY", ctx));
        CostItemInfo costItem = this.getCostItemByNumber(ctx, value);
        if (costItem != null && !CostItemEnum.STUFF.equals((Object)costItem.getItemType())) {
            String msg = MessageFormat.format(this.getResource("COSTITEM_NOT_MATERIAL", ctx), costItem.getNumber());
            throw new BOSException(msg);
        }
        info.setCostItem(costItem);
        value = this.getStringValue(hsData, "remark");
        if (value != null) {
            info.setRemark(value);
        }
        this.checkExists(ctx, info);
        return info;
    }

    private CostObjectInfo parseCostObject(Hashtable hsData, Context ctx) throws BOSException {
        String companyId = this.company.getId().toString();
        Object storageData = this.getData(hsData, "storageOrgUnit.number");
        String storageOrgUnitNumber = null;
        if (storageData != null && storageData.toString().trim().length() > 0) {
            storageOrgUnitNumber = storageData.toString().trim();
        }
        Object costObjectData = this.getData(hsData, "costObject.number");
        String costObjectNumber = null;
        if (costObjectData != null && costObjectData.toString().trim().length() > 0) {
            costObjectNumber = costObjectData.toString().trim();
        }
        Object orderData = this.getData(hsData, "order.number");
        String orderNumber = null;
        if (orderData != null && orderData.toString().trim().length() > 0) {
            orderNumber = orderData.toString().trim();
        }
        Object productData = this.getData(hsData, "product.number");
        String productNumber = null;
        if (productData != null && productData.toString().trim().length() > 0) {
            productNumber = productData.toString().trim();
        }
        Object batchData = this.getData(hsData, "batch2");
        String batch = null;
        if (batchData != null && batchData.toString().trim().length() > 0) {
            batch = batchData.toString().trim();
        }
        try {
            if (costObjectNumber != null) {
                return NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)this.getResource(ctx, "CostObjectNumber"), (String)costObjectNumber, (String)companyId);
            }
            if (orderNumber != null) {
                return NCMDataImportUtil.getCostObjectByOrder((Context)ctx, (String)companyId, (String)storageOrgUnitNumber, (String)orderNumber, (String)batch);
            }
            if (productNumber != null) {
                return NCMDataImportUtil.getCostObjectByProduct((Context)ctx, (String)companyId, (String)productNumber, (String)batch);
            }
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkExists(Context ctx, WIPCountingMaterialInfo info) throws BOSException, EASBizException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrg", (Object)info.getCompanyOrg().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod", (Object)info.getCalculatePeriod().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenter", (Object)info.getCostCenter().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)info.getMaterial().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("batch", (Object)info.getBatch()));
        if (info.getCostObject() != null) {
            filter.getFilterItems().add(new FilterItemInfo("costObject", (Object)info.getCostObject().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("costObject", null));
            if (info.getCostObjectSuite() != null) {
                filter.getFilterItems().add(new FilterItemInfo("costObjectSuite", (Object)info.getCostObjectSuite().getId().toString()));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("costObjectSuite", null));
            }
        }
        if (info.getCostItem() != null) {
            filter.getFilterItems().add(new FilterItemInfo("costItem", (Object)info.getCostItem().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("costItem", null));
        }
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setSelector(sic);
        CMBillBaseCollection coll = ((IWIPCountingMaterial)this.getController(ctx)).getCMBillBaseCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                info.setId(coll.get(0).getId());
                info.setFlag(1);
                return;
            }
            String empty = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.ImportExportResource", (String)"CHECK_EMPTY", (Locale)ctx.getLocale());
            String FCostCenterNumber = info.getCostCenter().getNumber();
            String FCostCenterName = info.getCostCenter().getName();
            String costCenter = empty;
            if (FCostCenterNumber != null) {
                costCenter = "";
                if (FCostCenterName != null) {
                    costCenter = FCostCenterName;
                }
                costCenter = costCenter + "[" + FCostCenterNumber + "]";
            }
            String FMaterialNumber = info.getMaterial().getNumber();
            String FMaterialName = info.getMaterial().getName();
            String material = empty;
            if (FMaterialNumber != null) {
                material = "";
                if (FMaterialName != null) {
                    material = FMaterialName;
                }
                material = material + "[" + FMaterialNumber + "]";
            }
            String batch = empty;
            if (info.getBatch() != null) {
                batch = info.getBatch();
            }
            String FCostObjectNumber = null;
            String FCostObjectName = null;
            if (info.getCostObject() != null) {
                FCostObjectNumber = info.getCostObject().getNumber();
                FCostObjectName = info.getCostObject().getName();
            }
            String costObject = empty;
            if (FCostObjectNumber != null) {
                costObject = "";
                if (FCostObjectName != null) {
                    costObject = FCostObjectName;
                }
                costObject = costObject + "[" + FCostObjectNumber + "]";
            }
            String FcostObjectSuiteNumber = null;
            String FCostObjectSuiteName = null;
            if (info.getCostObjectSuite() != null) {
                FcostObjectSuiteNumber = info.getCostObjectSuite().getNumber();
                FCostObjectSuiteName = info.getCostObjectSuite().getName();
            }
            String costObjectSuite = empty;
            if (FcostObjectSuiteNumber != null) {
                costObjectSuite = "";
                if (FCostObjectSuiteName != null) {
                    costObjectSuite = FCostObjectSuiteName;
                }
                costObjectSuite = costObjectSuite + "[" + FcostObjectSuiteNumber + "]";
            }
            String FCostItemNumber = null;
            String FCostItemName = null;
            if (info.getCostItem() != null) {
                FCostItemNumber = info.getCostItem().getNumber();
                FCostItemName = info.getCostItem().getName();
            }
            String costItem = empty;
            if (FCostItemNumber != null) {
                costItem = "";
                if (FCostItemName != null) {
                    costItem = FCostItemName;
                }
                costItem = costItem + "[" + FCostItemNumber + "]";
            }
            Object[] params = new String[]{costCenter, material, batch, costObject, costObjectSuite, costItem};
            throw new NcmBillException(NcmBillException.CHECK_WIPCOUNTINGMATERIAL_EXIST, params);
        }
        info.setSourceType(WIPCntMatSourceTypeEnum.ManualAddNew);
        info.setFlag(0);
    }

    protected String getResource(Context ctx, String resName) {
        return this.getResource(ctx, resName, null);
    }

    protected String getResource(Context ctx, String resName, Object[] params) {
        if (params != null) {
            return MessageFormat.format(ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale()), params);
        }
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale());
    }
}

