/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Calc.AllocWIP;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CheckCalTypeEnum;
import com.kingdee.eas.ncm.cal.app.Calc.AllocWIP.AllocWIPByCoef;
import com.kingdee.eas.ncm.cal.app.Calc.AllocWIP.AllocWIPByCouting;
import com.kingdee.eas.ncm.cal.app.Calc.AllocWIP.AllocWIPByOrder;
import com.kingdee.eas.ncm.cal.app.Calc.AllocWIP.IAllocWIP;
import com.kingdee.eas.ncm.cal.app.Calc.Helper.CalcExceptionLog;
import com.kingdee.eas.ncm.cal.report.NCMReportHelper;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.AllocStdSetModeByWIPEnum;
import com.kingdee.eas.ncm.common.app.CalcTable;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class AllocWIP
implements IAllocWIP {
    private static Logger logger = Logger.getLogger((String)AllocWIP.class.getName());
    protected Map _param = null;
    protected int _rank = -1;
    protected Context _ctx;
    protected String _companyId;
    protected String _periodId;
    protected String _userId;
    protected CalcExceptionLog _log;
    protected String _CU;
    protected CalcTable _calcTable;
    protected AllocStdSetModeByWIPEnum _setMode;
    protected static final char CLF = '\n';
    protected int amtPrecision = 2;
    protected Connection _globalConnection = null;
    private int _needCostRevert = -1;
    private int isExistsAllocStdAllocByOrderStock = -1;
    AllocWIPByCoef allocWIPByCoef = null;
    AllocWIPByCouting allocWIPByCouting = null;
    AllocWIPByOrder allocWIPByOrder = null;

    public AllocWIP(Map param) {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("ctx"));
        Assert.that((boolean)param.containsKey("calcTable"));
        Assert.that((boolean)param.containsKey("log"));
        Assert.that((boolean)param.containsKey("CU"));
        this._param = param;
        this._companyId = (String)param.get("companyId");
        this._periodId = (String)param.get("periodId");
        this._userId = (String)param.get("userId");
        this._globalConnection = (Connection)param.get("globalConnection");
        this._ctx = (Context)param.get("ctx");
        this._calcTable = (CalcTable)param.get("calcTable");
        this._log = (CalcExceptionLog)param.get("log");
        this._CU = (String)param.get("CU");
        this._param.put("allocStdType", AllocStdTypeEnum.WIPSTD);
        this._setMode = (AllocStdSetModeByWIPEnum)param.get("SetMode");
        this.allocWIPByCoef = new AllocWIPByCoef(param);
        this.allocWIPByCouting = new AllocWIPByCouting(param);
        this.allocWIPByOrder = new AllocWIPByOrder(param);
    }

    @Override
    public void setCalcRank(int rank) {
        this._rank = rank;
        this.allocWIPByCoef.setCalcRank(rank);
    }

    @Override
    public CostTaskResultEnum doAllocWIP(Context ctx) throws BOSException {
        CostTaskResultEnum result = CostTaskResultEnum.SUCCESS;
        StringBuffer sb = new StringBuffer();
        boolean isCalcSuccess = true;
        try {
            this.insertCostObjectByBatch(ctx);
            isCalcSuccess = this.allocWIPandFinished(ctx);
            if (!isCalcSuccess && CostTaskResultEnum.FAILURE.getValue() > result.getValue()) {
                result = CostTaskResultEnum.FAILURE;
            }
            if (this.isNeedCostRevert()) {
                if (!this.checkRecoveryCoef() && CostTaskResultEnum.FAILURE.getValue() > result.getValue()) {
                    result = CostTaskResultEnum.FAILURE;
                }
                this.CostCalRevert(sb);
                NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";", (Connection)this._globalConnection);
                sb.delete(0, sb.length());
                this.adjustDiff_Revert();
            }
            if (!this.checkInvalidMatCost() && CostTaskResultEnum.WARN.getValue() > result.getValue()) {
                result = CostTaskResultEnum.WARN;
            }
            this.commitAllocResult();
            this.ClearTempTableData();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public void insertCostObjectByBatch(Context ctx) throws BOSException {
        Object[] _costObjList = (Object[])this._param.get("CostObjectsByBatch");
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            NCMDbUtil.execute((Context)this._ctx, (String)("truncate Table " + this._calcTable.GetTempTBL_CostObjList()), (Connection)this._globalConnection);
            con = EJBFactory.getConnection((Context)this._ctx);
            pstmt = con.prepareStatement("INSERT INTO " + this._calcTable.GetTempTBL_CostObjList() + "(FCostObjectID)Values(?)");
            for (int i = 0; i < _costObjList.length; ++i) {
                pstmt.setString(1, (String)_costObjList[i]);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.close();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }

    protected boolean allocWIPandFinished(Context ctx) throws Exception {
        boolean isCalcSuccess = true;
        this.amtPrecision = NCMUtils.getCurrencyPrecision((Context)this._ctx, (String)this._companyId);
        this._calcTable.createTempCostCalResultTable();
        this._calcTable.createTempCostCalMatDetailResultTable();
        StringBuffer sb = new StringBuffer();
        this.initDataSql_tempTblCostCalResult(sb);
        this.initDataSql_tempTblCostCalMatDetailResult(sb);
        sb.delete(0, sb.length());
        boolean isNeedAllocByCounting = this.isNeedAllocByCounting();
        boolean isNeedAllocByOrder = this.isNeedAllocByOrder();
        this.allocWIPByCoef.init();
        if (isNeedAllocByCounting) {
            this.allocWIPByCouting.init();
        }
        if (isNeedAllocByOrder) {
            this.allocWIPByOrder.init();
        }
        this.allocWIPByCoef.doAllocWIP();
        if (isNeedAllocByCounting) {
            this.allocWIPByCouting.doAllocWIP();
        }
        if (isNeedAllocByOrder) {
            this.allocWIPByOrder.doAllocWIP();
        }
        this.adjustDiffAmount();
        this.adjustDiffQty();
        return isCalcSuccess;
    }

    protected void separateAllocWIPCounting(StringBuffer sb) throws BOSException {
    }

    public void releasePrivateTempTbl() throws BOSException {
        this.allocWIPByCoef.releaseTempTable();
        this.allocWIPByCouting.releaseTempTable();
        this.allocWIPByOrder.releaseTempTable();
    }

    @Override
    public void commitAllocResult() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(this._calcTable.GetCostCalResultTable()).append("(").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append('\n').append("\tFCostObjectID,FCostItemID,FAllocStdID,FAllocStdData,").append('\n').append("\tFFinishedAmount,FEoPWIPAmount,FRecvAmount,FFinishedQty,FEoPWIPQty,FEoPWIPAddQty,FFinishedAddQty,FEoPWIPAssistQty,FFinishedAssistQty,FCalcLevel)").append('\n').append("SELECT ").append('\n').append("\tnewbosid('C4774737') AS FID,'").append(this._companyId).append("','").append(this._periodId).append("',FCostCenterID,").append('\n').append("\tFCostObjectID,FCostItemID,FAllocStdID,FAllocStdData,").append('\n').append("\tFFinishedAmount,FEoPWIPAmount,FRecvAmount,FFinishedQty,FEoPWIPQty,isnull(FEoPWIPAddQty,0),isnull(FFinishedAddQty,0),isnull(FEoPWIPAssistQty,0),isnull(FFinishedAssistQty,0),").append(this._rank).append('\n').append("FROM ").append(this._calcTable.GetTemp_CostCalResultTable()).append('\n').append(";").append('\n');
        sb.append("INSERT INTO ").append(this._calcTable.GetCostCalMatDetailResultTable()).append("(").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append('\n').append("\tFCostObjectID,FCostItemID,FMaterialID,FLot,FAllocStdID,FAllocStdData,").append('\n').append("\tFFinishedQty,FEoPWIPQty,FFinishedAmount,FEoPWIPAmount,FEoPWIPAddQty,FFinishedAddQty,FEoPWIPAssistQty,FFinishedAssistQty,FCalcLevel,FIsReWork)").append('\n').append("SELECT ").append('\n').append("\tnewbosid('C4774737') AS FID,'").append(this._companyId).append("','").append(this._periodId).append("',FCostCenterID,").append('\n').append("\tFCostObjectID,FCostItemID,FMaterialID,FLot,FAllocStdID,FAllocStdData,").append('\n').append("\tFFinishedQty,FEoPWIPQty,FFinishedAmount,FEoPWIPAmount,isnull(FEoPWIPAddQty,0),isnull(FFinishedAddQty,0),isnull(FEoPWIPAssistQty,0),isnull(FFinishedAssistQty,0),").append(this._rank).append('\n').append("   , FIsReWork ").append("FROM ").append(this._calcTable.GetTemp_CostCalMatDetailResultTable()).append('\n').append(";").append('\n');
        sb.append("INSERT INTO ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append("(").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append('\n').append("\tFCostObjectID,FProductID,FLot,FCostItemID,FAllocStdID,FAllocStdData,").append('\n').append("\tFFinishedQty,FFinishedAmount,FFinishedPrice,FRecvAmount,FTotalFinishedQty,FCalcLevel)").append('\n').append("SELECT ").append('\n').append("\tnewbosid('C4774737') AS FID,'").append(this._companyId).append("','").append(this._periodId).append("',S.FCostCenterID,").append('\n').append("\tS.FCostObjectID,M.FID As FProductID,OBJ.FBatchNumber As FLot,S.FCostItemID,S.FAllocStdID,S.FAllocStdData,").append('\n').append("\tS.FFinishedQty,S.FFinishedAmount,");
        NCMReportHelper.AppendCaseSQLClause(sb, "ISNULL(S.FFinishedAmount,0)", "ISNULL(S.FFinishedQty,1)", "ISNULL(S.FFinishedAmount,0)", "FFinishedPrice", "M.FPricePrecision");
        sb.append(" \t,S.FRecvAmount,S.FTotalFinishedQty,").append(this._rank).append('\n').append("FROM ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" S ").append('\n').append("LEFT  JOIN " + this._calcTable.GetDataByProductTable() + " dataByPrd ").append('\n').append("    on dataByPrd.FCostCenterID = S.FCostCenterID and dataByPrd.FCostObjectID = S.FCostObjectID ").append('\n').append("LEFT  JOIN T_BD_CostObject OBJ ON OBJ.FID=S.FCostObjectID ").append('\n').append("LEFT  JOIN T_BD_Material M ON M.FID = dataByPrd.FProductID ").append('\n').append("WHERE OBJ.FRelatedType=0 AND S.FFinishedQty<>0 ").append(";").append('\n');
        sb.append("INSERT INTO ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append("(").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append('\n').append("\tFCostObjectID,FProductID,FLot,FCostItemID,FAllocStdID,FAllocStdData,").append('\n').append("\tFFinishedQty,FFinishedAmount,FFinishedPrice,FRecvAmount,FTotalFinishedQty,FCalcLevel)").append('\n').append("SELECT ").append('\n').append("\tnewbosid('C4774737') AS FID,'").append(this._companyId).append("','").append(this._periodId).append("',S.FCostCenterID,").append('\n').append("\tS.FCostObjectID,M.FID As FProductID,OBJ.FBatchNumber As FLot,S.FCostItemID,S.FAllocStdID,S.FAllocStdData,").append('\n').append("\tS.FFinishedQty,S.FFinishedAmount,0 As FFinishedPrice,S.FRecvAmount,S.FTotalFinishedQty,").append(this._rank).append('\n').append("FROM ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" S ").append('\n').append("LEFT  JOIN " + this._calcTable.GetDataByProductTable() + " dataByPrd ").append('\n').append("    on dataByPrd.FCostCenterID = S.FCostCenterID and dataByPrd.FCostObjectID = S.FCostObjectID ").append('\n').append("LEFT  JOIN T_BD_CostObject OBJ ON OBJ.FID=S.FCostObjectID ").append('\n').append("LEFT  JOIN T_BD_Material M ON M.FID = dataByPrd.FProductID ").append('\n').append("WHERE OBJ.FRelatedType=0 AND S.FFinishedQty=0 ").append(";").append('\n');
        if (this.isNeedCostRevert()) {
            sb.append("Delete from T_NCM_RecoveryCoefficient ").append('\n').append("where exists(").append('\n').append("\tSelect 1").append('\n').append("\tFrom ").append(this._calcTable.GetDataByCostObjTable()).append(" Q ").append('\n').append("\tInner join ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" C ON C.FCostCenterID=Q.FCostCenterID AND C.FCostObjectID=Q.FCostObjectID ").append('\n').append("\twhere Q.FCompanyID='").append(this._companyId).append("' AND Q.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n').append("\t\tAND Q.FFinishedQty <> 0 ").append('\n').append("\t\tAND Q.FCostObjectID=T_NCM_RecoveryCoefficient.FCostObjectID").append('\n').append(");").append('\n');
            sb.append("Insert into T_NCM_RecoveryCoefficient(FID,FControlUnitID,FFICompanyID,FCostObjectID)").append('\n').append("Select newbosid('F40D03AF') AS FID,'").append(this._CU).append("' As FControlUnitID,'").append(this._companyId).append("' As FFICompanyID, FCostObjectID ").append('\n').append("From (").append('\n').append("\tSelect distinct FCostObjectID ").append('\n').append("\tFrom ").append(this._calcTable.GetDataByCostObjTable()).append(" Q ").append("\twhere Q.FCompanyID='").append(this._companyId).append("' AND Q.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n').append("\t\tAND Q.FFinishedQty <> 0 And exists(").append('\n').append("\t\t\tSelect 1").append('\n').append("\t\t\tFrom ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" C ").append('\n').append("\t\t\tWhere C.FCostCenterID=Q.FCostCenterID AND C.FCostObjectID=Q.FCostObjectID ").append('\n').append("\t)").append('\n').append(")D;").append('\n');
            sb.append("Insert into T_NCM_RecoveryCoefficientEntry(FID,FParentID,FCostItemID,FCoefficient)").append('\n').append("Select newbosid('D93D0A03') AS FID, FParentID, FCostItemID,FCoefficient ").append('\n').append("From (").append('\n').append("\tSelect bill.FID As FParentID, bill.FCostObjectID, C.FCostItemID, TO_DECIMAL(C.FRecvAmount,24,12)/TO_DECIMAL(SC.FSumRecvAmount,24,12) As FCoefficient ").append('\n').append("\t\t").append('\n').append("\tFrom T_NCM_RecoveryCoefficient bill ").append("\tLeft join (").append('\n').append("\t\tSelect FCostObjectID, FCostItemID, SUM(FRecvAmount)As FRecvAmount ").append('\n').append("\t\tFrom ").append(this._calcTable.GetTemp_CostCalResultTable()).append('\n').append("\t\tGroup by FCostObjectID,FCostItemID ").append('\n').append("\t)C ON C.FCostObjectID=bill.FCostObjectID ").append('\n').append("\tLeft join (").append('\n').append("\t\tSelect FCostObjectID, SUM(FRecvAmount)As FSumRecvAmount ").append('\n').append("\t\tFrom ").append(this._calcTable.GetTemp_CostCalResultTable()).append('\n').append("\t\tGroup by FCostObjectID ").append('\n').append("\t) SC ON SC.FCostObjectID=bill.FCostObjectID ").append('\n').append("\tWhere bill.FFICompanyID='").append(this._companyId).append("' AND SC.FSumRecvAmount <> 0 ").append('\n').append("\t\tAnd not exists(").append('\n').append("\t\t\tSelect 1").append('\n').append("\t\t\tFrom T_NCM_RecoveryCoefficientEntry e ").append('\n').append("\t\t\tWhere e.FParentID=bill.FID ").append('\n').append("\t\t)").append('\n').append(") D;").append('\n');
        }
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";", (Connection)this._globalConnection);
        if (this.isNeedCostRevert()) {
            this.adjustDiff_Coef();
        }
    }

    protected void initDataSql_tempTblCostCalResult(StringBuffer sb) throws Exception {
        sb.setLength(0);
        sb.append("INSERT INTO ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" ( ").append('\n');
        sb.append("\t   FID, ").append('\n');
        sb.append("\t   FCostCenterID, FCostObjectID, FCostItemID, ").append('\n');
        sb.append("\t   FAmount,FQty, ").append('\n');
        sb.append("    FAddqty,FAssistQty ");
        sb.append(") \n");
        sb.append("SELECT ").append('\n');
        sb.append("    newbosid('C4774737') FID, ").append('\n');
        sb.append("    FEE.FCostCenterID, FEE.FCostObjectID, FEE.FCostItemID, ").append('\n');
        sb.append("\t   SUM(FEE.FAmount) FAmount, SUM(FEE.FQty) FQty, ").append('\n');
        sb.append("    SUM(FEE.FAddqty) FAddqty,SUM(FEE.FAssistQty) FAssistQty ").append('\n');
        sb.append("FROM (").append('\n');
        sb.append("\t   SELECT ").append('\n');
        sb.append("\t       BOP.FCostCenterID, BOP.FCostObjectID, BOPEntry.FCostItemID, ").append('\n');
        sb.append("\t       Round(BOPEntry.FBoPWIPAmount," + this.amtPrecision + ") FAmount ,isnull(BOPDetail.FQty, isnull(BOPEntry.FBopWIPQty, 0)) FQty, ").append('\n');
        sb.append("        isnull(BOPDetail.FAddQty, 0) FAddqty , isnull(BOPDetail.FAssistQty, 0) FAssistQty  ");
        sb.append("\t   FROM ").append(this._calcTable.GetBalanceTable()).append(" BOP ").append('\n');
        sb.append("\t   INNER JOIN ").append(this._calcTable.GetBalanceEntryTable()).append(" BOPEntry ON BOPEntry.FParentID=BOP.FID ");
        sb.append("    Left Join ( \n");
        sb.append("        Select FParentID, sum(FQty) as FQty, sum(FAssistQty) as FAssistQty, sum(FADDQty) as FADDQty \n");
        sb.append("        from ").append(this._calcTable.GetBalanceMatDetailTable()).append(" group by FparentID \n");
        sb.append("    ) BOPDetail on BOPDetail.FParentID = BOPEntry.FID \n ");
        sb.append("\t   WHERE BOP.FCompanyOrg='").append(this._companyId).append("' ").append('\n');
        sb.append("\t       AND BOP.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n');
        sb.append("\t   UNION ALL ").append('\n');
        sb.append("\t   SELECT ").append('\n');
        sb.append("\t       FCostCenterID, FCostObjectID, FCostItemID, ").append('\n');
        sb.append("\t       FAmount, FQty, ").append('\n');
        sb.append("        FCommonQty FAddqty, FAssistQty");
        sb.append("\t   FROM ").append(this._calcTable.GetMatAllocResultTable()).append(" MAT ").append('\n');
        sb.append("\t   WHERE MAT.FCompanyID='").append(this._companyId).append("' ").append('\n');
        sb.append("\t       AND MAT.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n');
        sb.append("\t   UNION ALL ").append('\n');
        sb.append("\t   SELECT ");
        sb.append("\t       FCostCenterID, FCostObjectID, FCostItemID, FAmount, FQty , 0 FAddqty , 0 FAssistQty");
        sb.append("\t   FROM ").append(this._calcTable.GetOtherAllocResultTable()).append('\n');
        sb.append("\t   UNION ALL ").append('\n');
        sb.append("\t   SELECT ").append('\n');
        sb.append("\t       FCostCenterID, FCostObjectID, FCostItemID,  FAmount, 0 FQty, ").append('\n');
        sb.append("        0 As FAddqty , 0 FAssistQty");
        sb.append("\t   FROM ").append(this._calcTable.GetAuxAllocResultTable()).append(" AUX ").append('\n');
        sb.append("\t   WHERE AUX.FCompanyID='").append(this._companyId).append("' ").append('\n');
        sb.append("\t       AND AUX.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n');
        sb.append(") FEE ").append('\n');
        sb.append("INNER JOIN ").append(this._calcTable.GetTempTBL_CostObjList()).append(" OL ").append('\n');
        sb.append("    ON OL.FCostObjectID = FEE.FCostObjectID ").append('\n');
        sb.append("GROUP BY FEE.FCostCenterID, FEE.FCostObjectID, FEE.FCostItemID ").append('\n');
        sb.append(";");
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        this._calcTable.createTempCostCalResultTableIndex();
        NCMDbUtil.analyzeTempTableByConnection((Context)this._ctx, (Connection)this._globalConnection, (String)this._calcTable.GetTemp_CostCalResultTable());
        sb.setLength(0);
        CostDataCache costDataCache = (CostDataCache)this._param.get("CostDataCache");
        String T_TMP_AllocStdSetByWIP = this._setMode == AllocStdSetModeByWIPEnum.CostItem ? costDataCache.getAllocStdSetByWIPTable(false, false, true) : (this._setMode == AllocStdSetModeByWIPEnum.CostItemAndCostCenter ? costDataCache.getAllocStdSetByWIPTable(true, false, true) : costDataCache.getAllocStdSetByWIPTable(false, true, true));
        sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" AS D SET (FAllocStdID)=(").append('\n').append("SELECT ST.FAllocStdID").append('\n').append("\t FROM " + T_TMP_AllocStdSetByWIP + " ST ").append('\n').append("\tWHERE 1=1 ").append('\n');
        if (this._setMode == AllocStdSetModeByWIPEnum.CostItem) {
            sb.append("\tand ST.FCostItemID=D.FCostItemID ").append('\n');
        } else if (this._setMode == AllocStdSetModeByWIPEnum.CostItemAndCostCenter) {
            sb.append("\t  AND ST.FCostCenterID=D.FCostCenterID AND ST.FCostItemID=D.FCostItemID ").append('\n');
        } else {
            sb.append("\t  AND ST.FCostObjectID=D.FCostObjectID AND ST.FCostItemID=D.FCostItemID ").append('\n');
        }
        sb.append(")").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" AS D SET (FTotalFinishedQty)=(").append('\n').append("\tSELECT S.FFinishedQty ").append('\n').append("\tFROM ").append(this._calcTable.GetDataByCostObjTable()).append(" S ").append('\n').append("\tWHERE S.FCompanyID='").append(this._companyId).append("' AND S.FCalculatePeriodID = '").append(this._periodId).append("' ").append('\n').append("\t\tAND S.FCostCenterID=D.FCostCenterID AND S.FCostObjectID=D.FCostObjectID ").append('\n').append(")").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" AS D SET (FTotalEoPWIPQty)=(").append('\n').append("\tSELECT BILL.FQty As FTotalEoPWIPQty ").append('\n').append("\tFROM T_NCM_WIPCountingBill BILL ").append('\n').append("\tWHERE BILL.FCompanyOrg = '").append(this._companyId).append("' AND BILL.FCalculatePeriod = '").append(this._periodId).append("' ").append('\n').append("\t\tAND D.FCostCenterID=BILL.FCostCenterID AND D.FCostObjectID=BILL.FCostObjectID").append('\n').append(") ");
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" AS D SET (FAmountPrecision)=(").append('\n').append("\tSELECT CY.FPrecision As FAmountPrecision ").append('\n').append("\tFROM T_BD_Currency CY ").append('\n').append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append('\n').append("\tWHERE CP.FID='").append(this._companyId).append("'").append('\n').append(")").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" AS D SET (FQtyPrecision)=(").append('\n').append("\tSELECT MU.FQtyPrecision ").append('\n').append("\tFROM T_BD_Material M ").append('\n').append("   INNER JOIN T_BD_MultiMeasureUnit MU ON M.FBaseUnit=MU.FMeasureUnitID and MU.FMaterialID = M.FID").append('\n').append("\tINNER JOIN T_BD_CostObject CO ON CO.FStdProductIDID=M.FID").append('\n').append("\tWHERE CO.FID=D.FCostObjectID").append('\n').append(")").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" AS D SET (FAssistQtyPrecision)=(").append('\n').append("\tSELECT MU.FQtyPrecision ").append('\n').append("\tFROM T_BD_Material M ").append('\n').append("   INNER JOIN T_BD_MultiMeasureUnit MU ON M.FAssistUnit=MU.FMeasureUnitID and MU.FMaterialID = M.FID").append('\n').append("\tINNER JOIN T_BD_CostObject CO ON CO.FStdProductIDID=M.FID").append('\n').append("\tWHERE CO.FID=D.FCostObjectID").append('\n').append(")").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.setLength(0);
    }

    protected void initDataSql_tempTblCostCalMatDetailResult(StringBuffer sb) throws Exception {
        CostDataCache costDataCache = (CostDataCache)this._param.get("CostDataCache");
        String T_TMP_AllocStdSetByWIP = this._setMode == AllocStdSetModeByWIPEnum.CostItem ? costDataCache.getAllocStdSetByWIPTable(false, false, true) : (this._setMode == AllocStdSetModeByWIPEnum.CostItemAndCostCenter ? costDataCache.getAllocStdSetByWIPTable(true, false, true) : costDataCache.getAllocStdSetByWIPTable(false, true, true));
        sb.setLength(0);
        sb.append("INSERT INTO " + this._calcTable.GetTemp_CostCalMatDetailResultTable() + " ( ").append('\n');
        sb.append("\t   FID, FParentID, ").append('\n');
        sb.append("\t   FCostCenterID, FCostObjectID, FCostItemID, ").append('\n');
        sb.append("\t   FMaterialID, FLot, FAmount, FQty, \n").append('\n');
        sb.append("    FIsReWork, \n");
        sb.append("    FAddqty, FAssistQty, \n");
        sb.append("    FAllocStdID \n");
        sb.append(") \n");
        sb.append("SELECT ").append('\n');
        sb.append("    newbosid('C4774737') FID, CCR.FID FParentID, ").append('\n');
        sb.append("    FEE.FCostCenterID, FEE.FCostObjectID, FEE.FCostItemID, ").append('\n');
        sb.append("    FEE.FMaterialID, FEE.FLot, ").append('\n');
        sb.append("\t   SUM(FEE.FAmount) FAmount, SUM(FEE.FQty) FQty, ").append('\n');
        sb.append("    FEE.FIsReWork, ").append('\n');
        sb.append("    SUM(FEE.FAddqty) FAddqty, SUM(FEE.FAssistQty) FAssistQty, ").append('\n');
        sb.append("    ass.FAllocStdID \n");
        sb.append("FROM ( ").append('\n');
        sb.append("    select \n");
        sb.append("        BOP.FCostCenterID, BOP.FCostObjectID, BOPEntry.FCostItemID, ").append('\n');
        sb.append("        BOPDetail.FMaterialID, isnull(BOPDetail.FBatchNo,N'') As FLot,").append('\n');
        sb.append("    \t   Round(BOPDetail.FAmount," + this.amtPrecision + ") as FAmount, BOPDetail.FQty, ").append('\n');
        sb.append("        isnull(BOPDetail.FIsReWork, 0) AS FIsReWork, ");
        sb.append("        BOPDetail.FAddqty,BOPDetail.FAssistQty ");
        sb.append("    FROM " + this._calcTable.GetBalanceTable() + " BOP ").append('\n');
        sb.append("    JOIN " + this._calcTable.GetBalanceEntryTable() + " BOPEntry ").append('\n');
        sb.append("        ON BOPEntry.FParentID = BOP.FID ").append('\n');
        sb.append("\t   INNER JOIN ").append(this._calcTable.GetBalanceMatDetailTable() + " BOPDetail ").append('\n');
        sb.append("        ON BOPDetail.FParentID=BOPEntry.FID ").append('\n');
        sb.append("    INNER JOIN ").append(this._calcTable.GetTempTBL_CostObjList()).append(" OL ").append('\n');
        sb.append("        ON OL.FCostObjectID=BOP.FCostObjectID ").append('\n');
        sb.append("    WHERE BOP.FCompanyOrg='").append(this._companyId).append("' ").append('\n');
        sb.append("        AND BOP.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n');
        sb.append("\t       UNION ALL ").append('\n');
        sb.append("    select ");
        sb.append("        MAT.FCostCenterID, MAT.FCostObjectID, MAT.FCostItemID, ").append('\n');
        sb.append("        MAT.FMaterialID, isnull(MAT.FLot,N''), ").append('\n');
        sb.append("        Mat.FAmount, Mat.FQty, ").append('\n');
        sb.append("        MAt.FIsReWork, \n");
        sb.append("        MAT.FCommonQty As FAddqty , MAT.FAssistQty \n");
        sb.append("    FROM " + this._calcTable.GetMatAllocResultTable() + " MAT ").append('\n');
        sb.append("    JOIN ").append(this._calcTable.GetTempTBL_CostObjList()).append(" OL ").append('\n');
        sb.append("        ON OL.FCostObjectID=Mat.FCostObjectID ").append('\n');
        sb.append(") FEE ").append('\n');
        sb.append("JOIN ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" CCR ").append('\n');
        sb.append("    ON CCR.FCostCenterID = FEE.FCostCenterID AND CCR.FCostObjectID = FEE.FCostObjectID ").append('\n');
        sb.append("    AND CCR.FCostItemID = FEE.FCostItemID ").append('\n');
        sb.append("left join " + T_TMP_AllocStdSetByWIP + " ass \n");
        if (this._setMode == AllocStdSetModeByWIPEnum.CostItem) {
            sb.append("    ON ass.FCostItemID = FEE.FCostItemID ").append('\n');
        } else if (this._setMode == AllocStdSetModeByWIPEnum.CostItemAndCostCenter) {
            sb.append("\t   ON ass.FCostCenterID = FEE.FCostCenterID AND ass.FCostItemID = FEE.FCostItemID ").append('\n');
        } else {
            sb.append("\t   ON ass.FCostObjectID = FEE.FCostObjectID AND ass.FCostItemID = FEE.FCostItemID ").append('\n');
        }
        if (this.isExistsAllocStdAllocByOrderStock()) {
            sb.append("where ass.FAllocStdID is null or ass.FAllocStdID <> 'm6A01u6MRYaDuCbff5oz09nqRL8=' \n");
        }
        sb.append("GROUP BY CCR.FID, FEE.FCostCenterID, FEE.FCostObjectID, FEE.FCostItemID, ").append('\n');
        sb.append("    FEE.FMaterialID, FEE.FLot, ").append('\n');
        sb.append("    FEE.FIsReWork, ass.FAllocStdID \n");
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        if (this.isExistsAllocStdAllocByOrderStock()) {
            sb.setLength(0);
            sb.append("INSERT INTO " + this._calcTable.GetTemp_CostCalMatDetailResultTable() + " ( ").append('\n');
            sb.append("\t   FID,FParentID, ").append('\n');
            sb.append("\t   FCostCenterID,FCostObjectID,FCostItemID, ").append('\n');
            sb.append("\t   FMaterialID,FLot,FAmount,FQty, ").append('\n');
            sb.append("    FIsReWork, \n");
            sb.append("    FAddqty, FAssistQty, \n");
            sb.append("    FSourceBillID, FSourceBillEntryID, FIsDirect, \n");
            sb.append("    FAllocStdID \n");
            sb.append(") \n");
            sb.append("SELECT ").append('\n');
            sb.append("    newbosid('C4774737') FID, CCR.FID FParentID, ").append('\n');
            sb.append("    FEE.FCostCenterID, FEE.FCostObjectID, FEE.FCostItemID, ").append('\n');
            sb.append("    FEE.FMaterialID, FEE.FLot,").append('\n');
            sb.append("\t   FEE.FAmount, FEE.FQty, ").append('\n');
            sb.append("    FEE.FIsReWork, ").append('\n');
            sb.append("    FEE.FAddqty, FEE.FAssistQty, ").append('\n');
            sb.append("    FEE.FSourceBillID, FEE.FSourceBillEntryID, FEE.FIsDirect, ").append('\n');
            sb.append("    ass.FAllocStdID \n");
            sb.append("FROM ( ").append('\n');
            sb.append("    select \n");
            sb.append("        BOP.FCostCenterID, BOP.FCostObjectID, BOPEntry.FCostItemID, ").append('\n');
            sb.append("        BOPDetail.FMaterialID, BOPDetail.FBatchNo As FLot,").append('\n');
            sb.append("    \t   Round(BOPDetail.FAmount," + this.amtPrecision + ") FAmount, BOPDetail.FQty, ").append('\n');
            sb.append("        isnull(BOPDetail.FIsReWork, 0) FIsReWork, \n");
            sb.append("        BOPDetail.FAddqty,BOPDetail.FAssistQty, \n");
            sb.append("        null FSourceBillID, null FSourceBillEntryID, 1 FIsDirect \n");
            sb.append("    FROM " + this._calcTable.GetBalanceTable() + " BOP ").append('\n');
            sb.append("    JOIN " + this._calcTable.GetBalanceEntryTable() + " BOPEntry ").append('\n');
            sb.append("        ON BOPEntry.FParentID = BOP.FID ").append('\n');
            sb.append("\t   INNER JOIN ").append(this._calcTable.GetBalanceMatDetailTable() + " BOPDetail ").append('\n');
            sb.append("        ON BOPDetail.FParentID=BOPEntry.FID ").append('\n');
            sb.append("    INNER JOIN ").append(this._calcTable.GetTempTBL_CostObjList()).append(" OL ").append('\n');
            sb.append("        ON OL.FCostObjectID=BOP.FCostObjectID ").append('\n');
            sb.append("    WHERE BOP.FCompanyOrg='").append(this._companyId).append("' ").append('\n');
            sb.append("        AND BOP.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n');
            sb.append("\t   UNION ALL ").append('\n');
            sb.append("    select ");
            sb.append("        MAT.FCostCenterID, MAT.FCostObjectID, MAT.FCostItemID, ").append('\n');
            sb.append("        MAT.FMaterialID, MAT.FLot, ").append('\n');
            sb.append("        Mat.FAmount, Mat.FQty, ").append('\n');
            sb.append("        MAt.FIsReWork, \n");
            sb.append("        MAT.FCommonQty As FAddqty , MAT.FAssistQty, \n");
            sb.append("        MAT.FSourceBillID, MAT.FSourceBillEntryID, MAT.FIsDirect \n");
            sb.append("    FROM " + this._calcTable.GetMatAllocResultTable() + " MAT ").append('\n');
            sb.append("    JOIN ").append(this._calcTable.GetTempTBL_CostObjList()).append(" OL ").append('\n');
            sb.append("        ON OL.FCostObjectID=Mat.FCostObjectID ").append('\n');
            sb.append(") FEE ").append('\n');
            sb.append("JOIN ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" CCR ").append('\n');
            sb.append("    ON CCR.FCostCenterID = FEE.FCostCenterID AND CCR.FCostObjectID = FEE.FCostObjectID ").append('\n');
            sb.append("    AND CCR.FCostItemID = FEE.FCostItemID ").append('\n');
            sb.append("join " + T_TMP_AllocStdSetByWIP + " ass \n");
            if (this._setMode == AllocStdSetModeByWIPEnum.CostItem) {
                sb.append("    ON ass.FCostItemID = FEE.FCostItemID ").append('\n');
            } else if (this._setMode == AllocStdSetModeByWIPEnum.CostItemAndCostCenter) {
                sb.append("\t   ON ass.FCostCenterID = FEE.FCostCenterID AND ass.FCostItemID = FEE.FCostItemID ").append('\n');
            } else {
                sb.append("\t   ON ass.FCostObjectID = FEE.FCostObjectID AND ass.FCostItemID = FEE.FCostItemID ").append('\n');
            }
            sb.append("where ass.FAllocStdID = 'm6A01u6MRYaDuCbff5oz09nqRL8=' \n");
            NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        }
        this._calcTable.createTempCostCalMatDetailResultTableIndex();
        NCMDbUtil.analyzeTempTableByConnection((Context)this._ctx, (Connection)this._globalConnection, (String)this._calcTable.GetTemp_CostCalMatDetailResultTable());
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalMatDetailResultTable()).append(" AS D SET (FIsSelfManufacture)=(").append('\n').append("\tSELECT  1 ").append('\n').append("\tFROM T_BD_MaterialCompanyInfo AS  CI ").append('\n').append("\tWHERE CI.FMaterialID=D.FMaterialID AND CI.FStatus=1 AND CI.FCalculateType=2 ").append('\n').append("\t\tAND CI.FCompanyID='").append(this._companyId).append("'").append('\n').append(")");
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.setLength(0);
        if (this.isNeedCostRevert()) {
            sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalMatDetailResultTable()).append(" AS D SET (FSpendCostObjectID)=(").append('\n').append("\tSELECT top 1 OBJ.FID ").append('\n').append("\tFROM T_BD_CostObject AS OBJ ").append('\n').append("\tWHERE OBJ.FRelatedType=0 AND OBJ.FStdProductIDID=D.FMaterialID ").append('\n').append("\t\t\t   and ").append('\n').append("\t\t\t   ( ").append('\n').append("\t\t\t       (OBJ.FCalculateMode = 4 and Isnull(D.FLot,' ') = Isnull(OBJ.FBatchNumber,' ')) ").append('\n').append("\t\t\t\t   or ").append('\n').append("\t\t\t\t   (OBJ.FCalculateMode = 7 and OBJ.FOrderID is not null) ").append('\n').append("\t\t\t\t   or ").append('\n').append("\t\t\t\t   (OBJ.FCalculateMode in (1, 3)) ").append('\n').append("\t\t\t   )").append('\n').append("\t\tAND OBJ.FCompanyID='").append(this._companyId).append("'").append('\n').append("\t\tAND D.FIsSelfManufacture=1 AND FIsForbiden = 0").append(")").append('\n');
            NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
            sb.setLength(0);
        }
        sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalMatDetailResultTable()).append(" AS D SET (FAmountPrecision)=(").append('\n').append("\tSELECT CY.FPrecision As FAmountPrecision ").append('\n').append("\tFROM T_BD_Currency CY ").append('\n').append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append('\n').append("\tWHERE CP.FID='").append(this._companyId).append("'").append('\n').append(")").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalMatDetailResultTable()).append(" AS D SET (FPricePrecision)=(").append('\n').append("\tSELECT M.FPricePrecision AS FPricePrecison ").append('\n').append("\tFROM T_BD_Material M ").append('\n').append("\tWHERE M.FID=D.FMaterialID").append('\n').append(")").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalMatDetailResultTable()).append(" AS D SET (FQtyPrecision)=(").append('\n').append("\tSELECT MU.FQtyPrecision ").append('\n').append("\tFROM T_BD_Material M ").append('\n').append("\tINNER JOIN T_BD_MultiMeasureUnit MU ON M.FBaseUnit=MU.FMeasureUnitID and MU.FMaterialID = M.FID").append('\n').append("\tWHERE M.FID=D.FMaterialID").append('\n').append(")").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcTable.GetTemp_CostCalMatDetailResultTable()).append(" AS D SET (FAssistQtyPrecision)=(").append('\n').append("\tSELECT MU.FQtyPrecision ").append('\n').append("\tFROM T_BD_Material M ").append('\n').append("\tINNER JOIN T_BD_MultiMeasureUnit MU ON M.FAssistUnit=MU.FMeasureUnitID and MU.FMaterialID = M.FID").append('\n').append("\tWHERE M.FID=D.FMaterialID").append('\n').append(")").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.setLength(0);
    }

    private boolean isNeedAllocByCounting() throws BOSException, SQLException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 1 from " + this._calcTable.GetTemp_CostCalResultTable() + " \n");
        ksql.append("where FAllocStdID = 'xGHRiNoXTSCl3IYyA5xfENnqRL8=' ");
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)ksql.toString(), (Connection)this._globalConnection);
        return rs.next();
    }

    private boolean isNeedAllocByOrder() throws BOSException, SQLException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 1 from " + this._calcTable.GetTemp_CostCalResultTable() + " \n");
        ksql.append("where FAllocStdID = 'm6A01u6MRYaDuCbff5oz09nqRL8=' ");
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)ksql.toString(), (Connection)this._globalConnection);
        return rs.next();
    }

    private boolean isExistsAllocStdAllocByOrderStock() throws BOSException, SQLException {
        if (this.isExistsAllocStdAllocByOrderStock == -1) {
            CostDataCache costDataCache = (CostDataCache)this._param.get("CostDataCache");
            String T_TMP_AllocStdSetByWIP = this._setMode == AllocStdSetModeByWIPEnum.CostItem ? costDataCache.getAllocStdSetByWIPTable(false, false, true) : (this._setMode == AllocStdSetModeByWIPEnum.CostItemAndCostCenter ? costDataCache.getAllocStdSetByWIPTable(true, false, true) : costDataCache.getAllocStdSetByWIPTable(false, true, true));
            StringBuffer ksql = new StringBuffer();
            ksql.append("select top 1 1 from " + T_TMP_AllocStdSetByWIP + " \n");
            ksql.append("where FAllocStdID = 'm6A01u6MRYaDuCbff5oz09nqRL8=' ");
            IRowSet rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)ksql.toString());
            this.isExistsAllocStdAllocByOrderStock = rs.next() ? 1 : 0;
        }
        return this.isExistsAllocStdAllocByOrderStock == 1;
    }

    private boolean checkRecoveryCoef() throws BOSException, SQLException {
        boolean isSuccess = true;
        String tblSrc = this._calcTable.GetTemp_CostCalMatDetailResultTable();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT top 100 S.FCostObjectID, S.FSpendCostObjectID,").append('\n').append("\tOBJ.FName_L2 || '(' || OBJ.FNumber || ')' As FCostObjectDisp ").append('\n').append("FROM ").append(tblSrc).append(" S ").append('\n').append("LEFT OUTER JOIN T_BD_CostObject OBJ ON OBJ.FID=S.FSpendCostObjectID ").append('\n').append("WHERE S.FIsSelfManufacture=1 AND S.FSpendCostObjectID is not null ").append('\n').append("\tAND NOT EXISTS(").append('\n').append("\t\tSelect 1").append('\n').append("\t\tFROM T_NCM_RecoveryCoefficient AS bill ").append('\n').append("\t\tLEFT OUTER JOIN T_NCM_RecoveryCoefficientEntry AS entry ON bill.FID = entry.FParentID ").append('\n').append("\t\tWHERE bill.FFICompanyID='").append(this._companyId).append("' ").append('\n').append("\t\t\tAND bill.FCostObjectID=S.FSpendCostObjectID AND entry.FCoefficient <> 0 ").append('\n').append(")").append('\n');
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.delete(0, sb.length());
        String possibleReason = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_No_RecoveryCoef_Reason");
        String adviceHandle = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_No_RecoveryCoef_Advice");
        rs.first();
        while (rs.getRow() > 0 && !rs.isAfterLast()) {
            isSuccess = false;
            String allocErrorInfo = MessageFormat.format(CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_No_RecoveryCoef"), rs.getString("FCostObjectDisp"));
            this._log.AddCalcDetailLog(sb, rs.getString("FCostObjectID"), allocErrorInfo, possibleReason, adviceHandle, CheckCalTypeEnum.ALLOCWIP);
            rs.next();
        }
        if (sb.length() > 0) {
            NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";", (Connection)this._globalConnection);
            sb.delete(0, sb.length());
        }
        return isSuccess;
    }

    protected boolean checkInvalidMatCost() throws BOSException, SQLException {
        boolean isSuccess = true;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT top 100 MAT.FCostObjectID,bill.FNumber, entry.FSeq,").append('\n').append("\tM.FName_L2 || '(' || M.FNumber || ')' As FMaterialDisp ").append('\n').append("FROM T_IM_MaterialReqBillEntry entry ").append('\n').append("INNER JOIN ").append(this._calcTable.GetMatAllocResultTable()).append(" MAT ").append('\n').append("    ON MAT.FSourceBillEntryID=entry.FID ").append('\n').append("INNER JOIN ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" CR ").append('\n').append("    ON MAT.FCostCenterID = CR.FCostCenterID AND MAT.FCostObjectID = CR.FCostObjectID AND MAT.FCostItemID = CR.FCostItemID ").append('\n').append("INNER JOIN ").append(this._calcTable.GetTempTBL_CostObjList()).append(" OL ").append('\n').append("    ON OL.FCostObjectID=CR.FCostObjectID ").append('\n').append("LEFT JOIN T_IM_MaterialReqBill bill ON bill.FID=entry.FParentID ").append('\n').append("LEFT JOIN T_BD_Material M ON M.FID=entry.FMaterialID ").append('\n').append("WHERE entry.FActualCost=0 ").append('\n');
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.delete(0, sb.length());
        String possibleReason = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_WIPAlloc_No_Amount_Reason");
        String adviceHandle = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_WIPAlloc_No_Amount_Advice");
        rs.first();
        while (rs.getRow() > 0 && !rs.isAfterLast()) {
            isSuccess = false;
            String allocErrorInfo = MessageFormat.format(CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_WIPAlloc_No_Amount"), rs.getString("FNumber"), rs.getString("FSeq"), rs.getString("FMaterialDisp"));
            this._log.AddCalcDetailLog(sb, rs.getString("FCostObjectID"), allocErrorInfo, possibleReason, adviceHandle, CheckCalTypeEnum.ALLOCWIP);
            rs.next();
        }
        if (sb.length() > 0) {
            NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";", (Connection)this._globalConnection);
            sb.delete(0, sb.length());
        }
        return isSuccess;
    }

    protected void adjustDiffAmount() throws BOSException {
        String tblSrc = this._calcTable.GetTemp_CostCalResultTable();
        String tblDest = this._calcTable.GetTemp_CostCalMatDetailResultTable();
        StringBuffer sb = new StringBuffer();
        sb.append("Select D.FParentID, ").append('\n').append("\t(S.FSrcFinishedAmount-D.FDestFinishedAmount) As FFinishedAmountDiff,(S.FSrcEoPWIPAmount-D.FDestEoPWIPAmount) As FEoPWIPAmountDiff ").append('\n').append("FROM (").append('\n').append("\tSelect FParentID,Sum(FFinishedAmount)As FDestFinishedAmount,Sum(FEoPWIPAmount)As FDestEoPWIPAmount ").append('\n').append("\tFrom ").append(tblDest).append('\n').append("\tGroup by FParentID ").append('\n').append(")D").append('\n').append("Inner join (").append('\n').append("\tSelect FID,Sum(FFinishedAmount)As FSrcFinishedAmount,Sum(FEoPWIPAmount)As FSrcEoPWIPAmount ").append('\n').append("\tFrom ").append(tblSrc).append('\n').append("\tGroup by FID ").append('\n').append(")S On D.FParentID=S.FID ").append('\n').append("Where (S.FSrcFinishedAmount<>D.FDestFinishedAmount OR S.FSrcEoPWIPAmount<>D.FDestEoPWIPAmount) ").append('\n').append("\tAnd (S.FSrcFinishedAmount+S.FSrcEoPWIPAmount=D.FDestFinishedAmount + D.FDestEoPWIPAmount) ").append('\n').append("").append('\n');
        IRowSet rs = null;
        rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        PreparedStatement pstmt = null;
        try {
            sb.delete(0, sb.length());
            sb.append("UPDATE ").append(tblDest).append(" SET FFinishedAmount=(FFinishedAmount + ? ), FEoPWIPAmount=(FEoPWIPAmount + ? ) ").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(tblDest).append('\n').append("\tWHERE FParentID=? ").append('\n').append("\tORDER BY FFinishedAmount+FEoPWIPAmount DESC ").append('\n').append(")");
            pstmt = this._globalConnection.prepareStatement(sb.toString());
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                pstmt.setDouble(1, rs.getDouble("FFinishedAmountDiff"));
                pstmt.setDouble(2, rs.getDouble("FEoPWIPAmountDiff"));
                pstmt.setString(3, rs.getString("FParentID"));
                pstmt.addBatch();
                rs.next();
            }
            pstmt.executeBatch();
            pstmt.close();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
    }

    protected void adjustDiffQty() throws BOSException {
        String tblSrc = this._calcTable.GetTemp_CostCalResultTable();
        String tblDest = this._calcTable.GetTemp_CostCalMatDetailResultTable();
        StringBuffer sbQty = new StringBuffer();
        sbQty.append("Select D.FParentID, ").append('\n').append("\t(S.FSrcFinishedQty-D.FDestFinishedQty) As FFinishedQtyDiff, (S.FSrcEoPWIPQty-D.FDestEoPWIPQty) As FEoPWIPQtyDiff ").append('\n').append(" FROM (").append('\n').append("\tSelect FParentID,Sum(FFinishedQty)As FDestFinishedQty, Sum(FEoPWIPQty) as FDestEoPWIPQty ").append('\n').append("\tFrom ").append(tblDest).append('\n').append("\tGroup by FParentID ").append('\n').append(") D ").append('\n').append(" Inner join (").append('\n').append("\tSelect FID,Sum(FFinishedQty)As FSrcFinishedQty, Sum(FEoPWIPQty) as FSrcEoPWIPQty ").append('\n').append("\tFrom ").append(tblSrc).append('\n').append("\tGroup by FID ").append('\n').append(") S On D.FParentID=S.FID ").append('\n').append(" Where (S.FSrcFinishedQty<>D.FDestFinishedQty ) ").append('\n').append("\tAnd (S.FSrcFinishedQty+S.FSrcEoPWIPQty=D.FDestFinishedQty + D.FDestEoPWIPQty) ").append('\n').append("").append('\n');
        IRowSet rsQty = null;
        rsQty = NCMDbUtil.executeQuery((Context)this._ctx, (String)sbQty.toString(), (Connection)this._globalConnection);
        PreparedStatement pstmtQty = null;
        try {
            sbQty.delete(0, sbQty.length());
            sbQty.append("UPDATE ").append(tblSrc).append(" SET FFinishedQty=(FFinishedQty - ? ), FEoPWIPQty = (FEoPWIPQty - ?)").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(tblSrc).append('\n').append("\tWHERE FID=? ").append('\n').append("\tORDER BY FFinishedQty+FEoPWIPQty DESC,FFinishedAmount+FEoPWIPAmount DESC ").append('\n').append(")");
            pstmtQty = this._globalConnection.prepareStatement(sbQty.toString());
            rsQty.first();
            while (rsQty.size() > 0 && !rsQty.isAfterLast()) {
                pstmtQty.setDouble(1, rsQty.getDouble("FFinishedQtyDiff"));
                pstmtQty.setDouble(2, rsQty.getDouble("FEoPWIPQtyDiff"));
                pstmtQty.setString(3, rsQty.getString("FParentID"));
                pstmtQty.addBatch();
                rsQty.next();
            }
            pstmtQty.executeBatch();
            pstmtQty.close();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rsQty, pstmtQty);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsQty, (Statement)pstmtQty);
    }

    private void adjustDiff_Revert() throws BOSException {
        String tblDest = this._calcTable.GetTemp_CostCalResultTable();
        String tblSrc = this._calcTable.GetTemp_CostCalMatDetailResultTable();
        String tblRevertInfo = this._calcTable.GetCostCalRevertInfoTable();
        StringBuffer sb = new StringBuffer();
        sb.append("Select S.FCostCenterID,S.FCostObjectID,S.FSpendCostObjectID,(S.FSrcAmount-D.FDestAmount) As FDiff ").append('\n').append("FROM (").append('\n').append("\tSelect FCostCenterID,FCostObjectID,FSpendCostObjectID,Sum(FFinishedAmount)As FSrcAmount ").append('\n').append("\tFrom ").append(tblSrc).append('\n').append("\tWHERE FIsSelfManufacture=1 ").append('\n').append("\tGroup by FCostCenterID,FCostObjectID,FSpendCostObjectID ").append('\n').append(")S").append('\n').append("Inner join (").append('\n').append("\tSelect FCostCenterID,FCostObjectID, FSpendCostObjectID,Sum(FAmount)As FDestAmount ").append('\n').append("\tFrom ").append(tblRevertInfo).append('\n').append("\tWHERE FCompanyID='").append(this._companyId).append("' AND FCalculatePeriodID='").append(this._periodId).append("'").append('\n').append("\tGroup by FCostCenterID,FCostObjectID,FSpendCostObjectID ").append('\n').append(")D On D.FCostCenterID=S.FCostCenterID AND D.FCostObjectID=S.FCostObjectID ").append('\n').append("\tAND D.FSpendCostObjectID=S.FSpendCostObjectID ").append('\n').append("Where S.FSrcAmount<>D.FDestAmount ").append('\n').append("").append('\n');
        IRowSet rs = null;
        rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        PreparedStatement pstmt = null;
        try {
            sb.delete(0, sb.length());
            sb.append("UPDATE ").append(tblDest).append(" SET FRecvAmount=(FRecvAmount + ? ) ").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(tblDest).append('\n').append("\tWHERE FFinishedAmount<>FRecvAmount AND FCostCenterID=? AND FCostObjectID=?").append('\n').append("\t\tAND FCostItemID IN(").append('\n').append("\t\t\tSelect FCostItemID").append('\n').append("\t\t\tFrom ").append(tblRevertInfo).append('\n').append("\t\t\tWhere FCompanyID=? AND FCalculatePeriodID=? AND FCostCenterID=? AND FCostObjectID=? AND FSpendCostObjectID=? ").append('\n').append("\t\t)").append('\n').append("\tORDER BY FRecvAmount DESC ").append('\n').append(")");
            pstmt = this._globalConnection.prepareStatement(sb.toString());
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                pstmt.setDouble(1, rs.getDouble("FDiff"));
                pstmt.setString(2, rs.getString("FCostCenterID"));
                pstmt.setString(3, rs.getString("FCostObjectID"));
                pstmt.setString(4, this._companyId);
                pstmt.setString(5, this._periodId);
                pstmt.setString(6, rs.getString("FCostCenterID"));
                pstmt.setString(7, rs.getString("FCostObjectID"));
                pstmt.setString(8, rs.getString("FSpendCostObjectID"));
                pstmt.addBatch();
                rs.next();
            }
            pstmt.executeBatch();
            pstmt.close();
            sb.delete(0, sb.length());
            sb.append("UPDATE ").append(tblRevertInfo).append(" SET FAmount=(FAmount + ? ) ").append('\n').append("Where FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(tblRevertInfo).append('\n').append("\tWHERE FCompanyID=? AND FCalculatePeriodID=? AND FCostCenterID=? AND FCostObjectID=? ").append('\n').append("\t\tAND FSpendCostObjectID=? ").append('\n').append("\tORDER BY FCoef DESC ").append('\n').append(")");
            pstmt = this._globalConnection.prepareStatement(sb.toString());
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                pstmt.setDouble(1, rs.getDouble("FDiff"));
                pstmt.setString(2, this._companyId);
                pstmt.setString(3, this._periodId);
                pstmt.setString(4, rs.getString("FCostCenterID"));
                pstmt.setString(5, rs.getString("FCostObjectID"));
                pstmt.setString(6, rs.getString("FSpendCostObjectID"));
                pstmt.addBatch();
                rs.next();
            }
            pstmt.executeBatch();
            pstmt.close();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private void adjustDiff_Coef() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("Select entry.FParentID,(1-SUM(FCoefficient)) As FDiff ").append('\n').append("From T_NCM_RecoveryCoefficientEntry entry ").append("INNER JOIN T_NCM_RecoveryCoefficient bill ON bill.FID=entry.FParentID ").append("Where bill.FFICompanyID='").append(this._companyId).append("'").append('\n').append("\tAND EXISTS(").append('\n').append("\t\tSelect 1 ").append('\n').append("\t\tfrom ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" S").append('\n').append("\t\twhere S.FCostObjectID=bill.FCostObjectID").append('\n').append("\t)").append('\n').append("GROUP BY entry.FParentID ").append('\n').append("HAVING SUM(FCoefficient)<>1 ").append('\n');
        IRowSet rs = null;
        rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.delete(0, sb.length());
        sb.append("UPDATE T_NCM_RecoveryCoefficientEntry SET FCoefficient=(FCoefficient + ? ) ").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom T_NCM_RecoveryCoefficientEntry e ").append('\n').append("\tWHERE FParentID=? ").append('\n').append("\tORDER BY FCoefficient DESC ").append('\n').append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)this._ctx);
            pstmt = conn.prepareStatement(sb.toString());
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                pstmt.setDouble(1, rs.getDouble("FDiff"));
                pstmt.setString(2, rs.getString("FParentID"));
                pstmt.addBatch();
                rs.next();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void CostCalRevert(StringBuffer sb) {
        String tblDest = this._calcTable.GetTemp_CostCalResultTable();
        String tblSrc = this._calcTable.GetTemp_CostCalMatDetailResultTable();
        String tblRevertInfo = this._calcTable.GetCostCalRevertInfoTable();
        sb.append("UPDATE ").append(tblDest).append('\n').append("\tSet FRecvAmount=FFinishedAmount ").append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(tblDest).append(" Set FRecvAmount=FRecvAmount-(").append('\n').append("\tSELECT ").append('\n').append("\t\tSUM(S.FFinishedAmount) ").append('\n').append("\tFROM ").append(tblSrc).append(" S ").append('\n').append("\tWHERE S.FIsSelfManufacture=1 ").append('\n').append("\t\tAND S.FCostCenterID=").append(tblDest).append(".FCostCenterID ").append('\n').append("\t\tAND S.FCostObjectID=").append(tblDest).append(".FCostObjectID ").append('\n').append("\t\tAND S.FCostItemID=").append(tblDest).append(".FCostItemID ").append('\n').append(")").append('\n').append("WHERE EXISTS(").append("\tSELECT 1 ").append('\n').append("\tFROM ").append(tblSrc).append(" S ").append('\n').append("\tLEFT JOIN T_NCM_RecoveryCoefficient bill ON bill.FCostObjectID=S.FSpendCostObjectID ").append('\n').append("\tLEFT JOIN T_NCM_RecoveryCoefficientEntry entry ON bill.FID = entry.FParentID ").append('\n').append("\tWHERE S.FIsSelfManufacture=1 ").append('\n').append("\t\tAND S.FCostCenterID=").append(tblDest).append(".FCostCenterID ").append('\n').append("\t\tAND S.FCostObjectID=").append(tblDest).append(".FCostObjectID ").append('\n').append("\t\tAND S.FCostItemID=").append(tblDest).append(".FCostItemID ").append('\n').append("\t\tAND bill.FFICompanyID='").append(this._companyId).append("' AND entry.FCoefficient <> 0 ").append('\n').append(");").append('\n');
        sb.append("INSERT INTO ").append(tblDest).append("( ").append('\n').append("\tFID,FCostCenterID,FCostObjectID,FCostItemID) ").append('\n').append("SELECT newbosid('C4774737') AS FID, FEE.FCostCenterID, FEE.FCostObjectID, FEE.FCostItemID ").append('\n').append("FROM (").append('\n').append("\tSELECT distinct S.FCostCenterID, S.FCostObjectID, entry.FCostItemID ").append('\n').append("\tFROM ").append(tblSrc).append(" S ").append('\n').append("\tLEFT JOIN T_NCM_RecoveryCoefficient bill ON bill.FCostObjectID=S.FSpendCostObjectID ").append('\n').append("\tLEFT JOIN T_NCM_RecoveryCoefficientEntry entry ON bill.FID = entry.FParentID ").append('\n').append("\tWHERE S.FIsSelfManufacture=1 ").append('\n').append("\t\tAND bill.FFICompanyID='").append(this._companyId).append("' AND entry.FCoefficient <> 0 ").append('\n').append(") FEE ").append('\n').append("WHERE NOT EXISTS (").append('\n').append("\tSelect 1").append('\n').append("\tFROM ").append(tblDest).append(" DD ").append('\n').append("\tWHERE DD.FCostCenterID=FEE.FCostCenterID AND DD.FCostObjectID=FEE.FCostObjectID AND DD.FCostItemID=FEE.FCostItemID ").append('\n').append(") ").append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(tblDest).append(" Set FRecvAmount=FRecvAmount+(").append('\n').append("\tSELECT ").append('\n').append("\t\tSUM(ROUND(TO_DECIMAL(S.FFinishedAmount,24,12)* TO_DECIMAL(entry.FCoefficient,24,12), S.FAmountPrecision)) ").append('\n').append("\tFROM ").append(tblSrc).append(" S ").append('\n').append("\tLEFT JOIN T_NCM_RecoveryCoefficient bill ON bill.FCostObjectID=S.FSpendCostObjectID ").append('\n').append("\tLEFT JOIN T_NCM_RecoveryCoefficientEntry entry ON bill.FID = entry.FParentID ").append('\n').append("\tWHERE S.FIsSelfManufacture=1 ").append('\n').append("\t\tAND S.FCostCenterID=").append(tblDest).append(".FCostCenterID ").append('\n').append("\t\tAND S.FCostObjectID=").append(tblDest).append(".FCostObjectID ").append('\n').append("\t\tAND entry.FCostItemID=").append(tblDest).append(".FCostItemID ").append('\n').append("\t\tAND bill.FFICompanyID='").append(this._companyId).append("' AND entry.FCoefficient <> 0 ").append('\n').append(")").append('\n').append("WHERE EXISTS(").append("\tSELECT 1 ").append('\n').append("\tFROM ").append(tblSrc).append(" S ").append('\n').append("\tLEFT JOIN T_NCM_RecoveryCoefficient bill ON bill.FCostObjectID=S.FSpendCostObjectID ").append('\n').append("\tLEFT JOIN T_NCM_RecoveryCoefficientEntry entry ON bill.FID = entry.FParentID ").append('\n').append("\tWHERE S.FIsSelfManufacture=1 ").append('\n').append("\t\tAND S.FCostCenterID=").append(tblDest).append(".FCostCenterID ").append('\n').append("\t\tAND S.FCostObjectID=").append(tblDest).append(".FCostObjectID ").append('\n').append("\t\tAND entry.FCostItemID=").append(tblDest).append(".FCostItemID ").append('\n').append("\t\tAND bill.FFICompanyID='").append(this._companyId).append("' AND entry.FCoefficient <> 0 ").append('\n').append(");").append('\n');
        sb.append("INSERT INTO ").append(tblRevertInfo).append("(").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,FCostCenterID,FCostObjectID,FCostItemID,").append('\n').append("\tFSpendCostObjectID,FSpendCostItemID,FMaterialID,FLot,FAmount,FCoef )").append('\n').append("SELECT newbosid('F40D03AF') AS FID,'").append(this._companyId).append("' As FCompanyID,").append('\n').append("\t'").append(this._periodId).append("' As FCalculatePeriodID,S.FCostCenterID,S.FCostObjectID,D.FCostItemID,").append('\n').append("\tS.FSpendCostObjectID,entry.FCostItemID As FSpendCostItemID, S.FMaterialID, S.FLot, ").append('\n').append("\tROUND(TO_DECIMAL(S.FFinishedAmount,24,12) * TO_DECIMAL(entry.FCoefficient,24,12), S.FAmountPrecision)As FAmount, entry.FCoefficient As FCoef ").append('\n').append("FROM ").append(tblSrc).append(" S ").append('\n').append("LEFT JOIN ").append(tblDest).append(" D ON D.FCostCenterID=S.FCostCenterID AND D.FCostObjectID=S.FCostObjectID").append('\n').append("LEFT JOIN T_NCM_RecoveryCoefficient bill ON bill.FCostObjectID=S.FSpendCostObjectID ").append('\n').append("LEFT JOIN T_NCM_RecoveryCoefficientEntry entry ON bill.FID = entry.FParentID AND entry.FCostItemID=D.FCostItemID ").append('\n').append("WHERE S.FIsSelfManufacture=1 ").append('\n').append("\tAND bill.FFICompanyID='").append(this._companyId).append("' AND entry.FCoefficient <> 0 ").append('\n').append(";");
    }

    protected boolean checkInvalidFinishedUnitCost() throws BOSException, SQLException {
        boolean isSuccess = true;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT top 100 D.FCostObjectID,").append('\n').append("\tMax(OBJ.FName_L2) || '(' || Max(OBJ.FNumber) || ')' As FCostObjectDisp,").append('\n').append("\tSUM(FFinishedAmount)As FAmount, MAX(FTotalFinishedQty) As FQty ").append('\n').append("FROM ").append(this._calcTable.GetTemp_CostCalResultTable()).append(" D ").append('\n').append("LEFT OUTER JOIN T_BD_CostObject OBJ ON OBJ.FID=D.FCostObjectID ").append('\n').append("GROUP BY D.FCostCenterID, D.FCostObjectID ").append("HAVING (MAX(FTotalFinishedQty)>0 AND SUM(FFinishedAmount) <=0) or (MAX(FTotalFinishedQty)<0 AND SUM(FFinishedAmount) >=0)");
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.delete(0, sb.length());
        String possibleReason = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_WIPAlloc_InValid_UnitCost_Reason");
        String adviceHandle = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_WIPAlloc_InValid_UnitCost_Advice");
        rs.first();
        while (rs.getRow() > 0 && !rs.isAfterLast()) {
            isSuccess = false;
            String allocErrorInfo = MessageFormat.format(CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_WIPAlloc_InValid_UnitCost"), rs.getString("FCostObjectDisp"), rs.getString("FAmount"), rs.getString("FQty"));
            this._log.AddCalcDetailLog(sb, rs.getString("FCostObjectID"), allocErrorInfo, possibleReason, adviceHandle, CheckCalTypeEnum.ALLOCWIP);
            rs.next();
        }
        if (sb.length() > 0) {
            NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";", (Connection)this._globalConnection);
            sb.delete(0, sb.length());
        }
        return isSuccess;
    }

    protected void ClearTempTableData() throws Exception {
        this._calcTable.clearTempCostCalResultTable();
        this._calcTable.clearTempCostCalMatDetailResultTable();
    }

    public boolean isNeedCostRevert() throws BOSException {
        if (this._needCostRevert == -1) {
            IParamControl ipctr = ParamControlFactory.getLocalInstance((Context)this._ctx);
            try {
                ObjectUuidPK com = new ObjectUuidPK(this._companyId);
                String st = ipctr.getParamValue((IObjectPK)com, "CM001");
                this._needCostRevert = Boolean.valueOf(st).booleanValue() ? 1 : 0;
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return this._needCostRevert == 1;
    }
}

