/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Calc.AllocWIP;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.cal.CheckCalTypeEnum;
import com.kingdee.eas.ncm.cal.app.Calc.AllocWIP.AllocWIP;
import com.kingdee.eas.ncm.cal.app.Calc.AllocWIP.IAllocWIP;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class AllocWIPCounting
extends AllocWIP {
    private static Logger logger = Logger.getLogger((String)IAllocWIP.class.getName());
    private String tblWIPCountingMaterial = null;
    private String tblWIPCountingAllocData = null;
    private String tblWIPCountingAllocResult = null;
    private String tblCostCalMatDetailData = null;
    private String tblDataNofinishedToDealWith = null;
    private Boolean usingQtyOrAmount = null;

    @Override
    public void releasePrivateTempTbl() throws BOSException {
        if (this.tblWIPCountingMaterial != null) {
            TempTablePool.getInstance((Context)this._ctx).releaseTable(this.tblWIPCountingMaterial);
        }
        if (this.tblWIPCountingAllocData != null) {
            TempTablePool.getInstance((Context)this._ctx).releaseTable(this.tblWIPCountingAllocData);
        }
        if (this.tblCostCalMatDetailData != null) {
            TempTablePool.getInstance((Context)this._ctx).releaseTable(this.tblCostCalMatDetailData);
        }
        if (this.tblDataNofinishedToDealWith != null) {
            TempTablePool.getInstance((Context)this._ctx).releaseTable(this.tblDataNofinishedToDealWith);
        }
    }

    private String getTblCostCalMatDetailData() throws BOSException {
        if (this.tblCostCalMatDetailData == null) {
            String sqlCreateTbl = "Create Table t_temptblCostCalMatDetailData ( " + this.createSqlOfTblCostCalMatDetailData() + ", FWIPInPrdQty NUMERIC(21,8) DEFAULT 0 , FWIPFinishQty NUMERIC(21,8) DEFAULT 0 , FWIPCoefficient NUMERIC(21,8) DEFAULT 0 , FHaveDealt INT DEFAULT 0 )";
            String index = "FCostCenterid, FCostObjectId, FCostItemId, FMaterialID, FLot,FParentID";
            this.tblCostCalMatDetailData = this.createTempTable(sqlCreateTbl, index);
        }
        return this.tblCostCalMatDetailData;
    }

    private String createSqlOfTblCostCalMatDetailData() {
        String createSqlOfTblCostCalMatDetailData = "FID VARCHAR(44) ,FParentID VARCHAR(44) , FCostCenterID VARCHAR(44) , FCostObjectID VARCHAR(44) , FCostItemID VARCHAR(44) , FMaterialID VARCHAR(44) , FLot NVARCHAR(80) , FAllocStdID VARCHAR(44) , FIsSelfManufacture INT DEFAULT 0 , FSpendCostObjectID VARCHAR(44) , FAmount NUMERIC(17,4) DEFAULT 0 , FBaseQty NUMERIC(21,8) DEFAULT 0 , FFinishedBaseQty NUMERIC(21,8) DEFAULT 0 , FFinishedAmount NUMERIC(17,4) DEFAULT 0 , FEoPWIPBaseQty NUMERIC(21,8) DEFAULT 0 , FEoPWIPAmount NUMERIC(17,4) DEFAULT 0 , FPricePrecision INT DEFAULT 8 , FAmountPrecision INT DEFAULT 2 , FBaseQtyPrecision INT DEFAULT 8 , FIsReWork INT DEFAULT 0, FUnitID varchar(44) , FAssistQty NUMERIC(21,8) DEFAULT 0 , FAssistQtyPrecision INT DEFAULT 8 , FEoPWIPAssistQty NUMERIC(21,8) DEFAULT 0 , FFinishedAssistQty NUMERIC(21,8) DEFAULT 0 , FCommonQty NUMERIC(21,8) DEFAULT 0 , FCommonQtyPrecision INT DEFAULT 8 , FEoPWIPCommonQty NUMERIC(21,8) DEFAULT 0 , FFinishedCommonQty NUMERIC(21,8) DEFAULT 0 , FWIPCoefQty  NUMERIC(21,8) DEFAULT 0 , FWIPCoefAmount NUMERIC(21,8) DEFAULT 0 , FBasePrice NUMERIC(21,8) DEFAULT 0 , FCommonPrice NUMERIC(21,8) DEFAULT 0 , FAssistPrice NUMERIC(21,8) DEFAULT 0 ";
        return createSqlOfTblCostCalMatDetailData;
    }

    @Override
    protected void separateAllocWIPCounting(StringBuffer sb) throws BOSException {
        sb.delete(0, sb.length());
        this.truncateTblByGivenName(sb, this.getTblCostCalMatDetailData());
        sb.append("insert into ").append(this.getTblCostCalMatDetailData()).append('\n').append("(FID, FParentID,FCostCenterID, FCostObjectID, FCostItemID, FMaterialID, FLot, ").append('\n').append(" FAmount, FBaseQty, FIsReWork, FCommonQty , FAssistQty, ").append('\n').append(" FUnitID, FAllocStdID, FIsSelfManufacture, FSpendCostObjectID, ").append('\n').append(" FAmountPrecision, FPricePrecision, FBaseQtyPrecision, FAssistQtyPrecision, ").append('\n').append(" FWIPInPrdQty, FWIPFinishQty )").append('\n').append("select d.FID, D.FParentID,d.FCostCenterID, d.FCostObjectID, d.FCostItemID, d.FMaterialID, d.FLot, ").append('\n').append("       d.FAmount, d.FQty, d.FIsReWork, d.FAddqty , d.FAssistQty, ").append('\n').append("       d.FUnitID, d.FAllocStdID, d.FIsSelfManufacture, d.FSpendCostObjectID, ").append('\n').append("       d.FAmountPrecision, d.FPricePrecision, d.FQtyPrecision, d.FAssistQtyPrecision, ").append('\n').append("       b.FQty, b.FManuOverQtry ").append('\n').append("  from ").append(this._calcTable.GetTemp_CostCalMatDetailResultTable()).append(" d ").append('\n').append(" inner join T_NCM_WIPCountingBill b ").append('\n').append("    on d.FCostCenterid=b.FCostCenterid and d.FCostObjectId=b.FCostObjectId").append('\n').append(" where d.FAllocStdID = '").append("xGHRiNoXTSCl3IYyA5xfENnqRL8=").append("'").append('\n').append("   and b.FCompanyOrg = '").append(this._companyId).append("'").append('\n').append("   and b.FCalculatePeriod = '").append(this._periodId).append("'").append('\n').append(";").append('\n');
        sb.append("delete from ").append(this._calcTable.GetTemp_CostCalMatDetailResultTable()).append('\n').append(" where FAllocStdID = '").append("xGHRiNoXTSCl3IYyA5xfENnqRL8=").append("'").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        NCMUtils.analyzeTempTable((Context)this._ctx, (String)this.getTblCostCalMatDetailData());
    }

    public AllocWIPCounting(Map param) {
        super(param);
        try {
            this.initInformation();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void initInformation() throws BOSException {
        StringBuffer sb = new StringBuffer();
        try {
            this.truncateTblByGivenName(sb, this.getTblWIPCountingAllocResult());
            this.truncateTblByGivenName(sb, this.getTblWIPCountingMaterial());
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sb.append("insert into ").append(this.getTblWIPCountingMaterial()).append('\n').append("(FCostCenterid, FMaterialID, FLot, FCostItemId, FCostObjectId, FCostObjectSuiteId, ").append('\n').append(" FAmount, FBaseQty, FCommonQty, FAssistQty, isInWH )").append('\n').append("select FCostCenterid, FMaterialID, Fbatch AS FLot, FCostItemId, FCostObjectId, FCostObjectSuiteId, ").append('\n').append("       isnull(FAmount, 0), isnull(FBaseQty, 0), isnull(FQty, 0), isnull(FAssistQty, 0), ").append('\n').append("       FIsInWH ").append('\n').append("  from T_NCM_WIPCountingMaterial").append('\n').append(" where FCompanyOrg='").append(this._companyId).append("'").append('\n').append("   and FCalculatePeriod='").append(this._periodId).append("'").append('\n').append("   and ").append(this.usingQtyOrAmount() ? "FBaseQty" : "FAmount").append(" is not null").append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this.getTblWIPCountingMaterial()).append(" AS D ").append('\n').append("   SET (FAllocStdID)=(").append('\n').append("\tSELECT top 1 ST.FAllocStdID").append('\n').append("\t  FROM T_NCM_AllocStdSetByWIP ST ").append('\n').append("\t WHERE ST.FCompanyID='").append(this._companyId).append("' ").append('\n').append("    AND ST.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n').append("\t   AND ST.FCostObjectID=D.FCostObjectID AND ST.FCostItemID=D.FCostItemID ").append('\n').append(") where D.FCostObjectId is not null ").append('\n').append(";").append('\n');
        sb.append("delete from ").append(this.getTblWIPCountingMaterial()).append('\n').append(" where (FAllocStdID is null or FAllocStdID <>'").append("xGHRiNoXTSCl3IYyA5xfENnqRL8=").append("') ").append('\n').append("   and FCostObjectId is not null ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        NCMUtils.analyzeTempTable((Context)this._ctx, (String)this.getTblWIPCountingMaterial());
    }

    private String getTblWIPCountingMaterial() throws BOSException {
        if (this.tblWIPCountingMaterial == null) {
            String sqlCreateTbl = "Create Table t_tempTblWIPCountingMaterial ( FCostCenterid VARCHAR(44), FMaterialID VARCHAR(44), FLot NVARCHAR(80), FCostItemId VARCHAR(44), FCostObjectId VARCHAR(44), FCostObjectSuiteId VARCHAR(44), FAmount NUMERIC(21,8) DEFAULT 0 , FBaseQty NUMERIC(21,8) DEFAULT 0 , FCommonQty NUMERIC(21,8) DEFAULT 0 , FAssistQty NUMERIC(21,8) DEFAULT 0 , FHaveDealt INT DEFAULT 0 , FAllocStdID VARCHAR(44) , isInWH INT DEFAULT 0 )";
            String index = "FCostCenterid, FMaterialID, FLot, FCostItemId, FCostObjectId, FCostObjectSuiteId";
            this.tblWIPCountingMaterial = this.createTempTable(sqlCreateTbl, index);
        }
        return this.tblWIPCountingMaterial;
    }

    private String getTblDataNofinishedToDealWith() throws BOSException {
        if (this.tblDataNofinishedToDealWith == null) {
            String sqlCreateTbl = "Create Table t_tempTblDataNofinishedToDealWith ( FCostCenterid VARCHAR(44), FMaterialID VARCHAR(44), FLot NVARCHAR(80), FCostItemId VARCHAR(44), FCostObjectId VARCHAR(44), FAmount NUMERIC(21,8) DEFAULT 0 , FBaseQty NUMERIC(21,8) DEFAULT 0 , FCommonQty NUMERIC(21,8) DEFAULT 0 , FAssistQty NUMERIC(21,8) DEFAULT 0 )";
            String index = "FCostCenterid, FMaterialID, FLot, FCostItemId, FCostObjectId";
            this.tblDataNofinishedToDealWith = this.createTempTable(sqlCreateTbl, index);
        }
        return this.tblDataNofinishedToDealWith;
    }

    @Override
    protected boolean allocWIPandFinished(Context ctx) throws Exception, AllocateException, SQLException {
        boolean isSuccess = super.allocWIPandFinished(ctx);
        StringBuffer sb = new StringBuffer();
        this.dealWithDataNofinished(sb);
        this.dealWithDataNoInPrd(sb);
        this.deleteDataHaveDealt(sb);
        isSuccess = this.dealWithDataNotDealt(ctx, sb);
        this.dealWithDataNotDealtAtLast(ctx, sb);
        this.saveDataToResultTempTbl(sb);
        return isSuccess;
    }

    private void dealWithDataNofinished(StringBuffer sb) throws BOSException {
        sb.append("UPDATE ").append(this.getTblCostCalMatDetailData()).append('\n').append("   Set FEoPWIPAmount=FAmount, FEoPWIPBaseQty=FBaseQty, FFinishedAmount=0, FFinishedBaseQty=0, ").append('\n').append("       FEoPWIPCommonQty=FCommonQty, FFinishedCommonQty=0, FEoPWIPAssistQty=FAssistQty, FFinishedAssistQty=0, ").append('\n').append("       FHaveDealt=1 ").append('\n').append(" where isnull(FWIPInPrdQty, 0)>0 and isnull(FWIPFinishQty, 0)=0 ").append('\n').append("   and FHaveDealt=0 ").append('\n').append(";").append('\n');
        this.truncateTblByGivenName(sb, this.getTblDataNofinishedToDealWith());
        sb.append("insert into ").append(this.getTblDataNofinishedToDealWith()).append('\n').append("(FCostCenterid, FMaterialID, FLot, FCostItemId, FCostObjectId, FAmount, FBaseQty, FCommonQty, FAssistQty)").append('\n').append("select d.FCostCenterid, d.FMaterialID, d.FLot, d.FCostItemId, d.FCostObjectId, ").append('\n').append("       isnull(d.FAmount, 0), isnull(d.FBaseQty, 0), isnull(d.FCommonQty, 0), isnull(d.FAssistQty, 0) ").append('\n').append("  from ").append(this.getTblCostCalMatDetailData()).append(" d ").append('\n').append("  left outer join (select * from ").append(this.getTblWIPCountingMaterial()).append(" where FHaveDealt=0) b ").append('\n').append("    on d.FCostCenterID=b.FCostCenterID ").append('\n').append("   and d.FMaterialID=b.FMaterialID and isnull(d.FLot, ' ')=isnull(b.FLot, ' ') ").append('\n').append("   and d.FCostItemId=b.FCostItemId ").append('\n').append("   and d.FCostObjectId=b.FCostObjectId ").append('\n').append(" where d.FHaveDealt=1 and b.FCostObjectId is null ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private void dealWithDataNoInPrd(StringBuffer sb) throws BOSException {
        sb.append("UPDATE ").append(this.getTblCostCalMatDetailData()).append('\n').append("   Set FEoPWIPAmount=0, FEoPWIPBaseQty=0, FFinishedAmount=FAmount, FFinishedBaseQty=FBaseQty, ").append('\n').append("       FEoPWIPCommonQty=0, FFinishedCommonQty=FCommonQty, FEoPWIPAssistQty=0, FFinishedAssistQty=FAssistQty , ").append('\n').append("       FHaveDealt=1 ").append('\n').append(" where isnull(FWIPInPrdQty, 0)=0 and isnull(FWIPFinishQty, 0)>0 ").append('\n').append("   and FHaveDealt=0 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private void deleteDataHaveDealt(StringBuffer sb) throws BOSException {
        sb.append("UPDATE ").append(this.getTblWIPCountingMaterial()).append('\n').append("   Set FHaveDealt=1 ").append('\n').append(" where exists(").append('\n').append("       select 1 from ").append(this.getTblCostCalMatDetailData()).append(" d ").append('\n').append("        where d.FCostCenterID=").append(this.getTblWIPCountingMaterial()).append(".FCostCenterID ").append('\n').append("          and d.FMaterialID=").append(this.getTblWIPCountingMaterial()).append(".FMaterialID and isnull(d.FLot, ' ')=isnull(").append(this.getTblWIPCountingMaterial()).append(".FLot, ' ') ").append('\n').append("          and d.FCostItemId=").append(this.getTblWIPCountingMaterial()).append(".FCostItemId ").append('\n').append("          and d.FCostObjectId=").append(this.getTblWIPCountingMaterial()).append(".FCostObjectId ").append('\n').append("          and d.FHaveDealt=1 ").append('\n').append("       )").append('\n').append("   and FHaveDealt=0 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private boolean dealWithDataNotDealt(Context ctx, StringBuffer sb) throws BOSException, SQLException {
        boolean isSuccess = true;
        this.makeWIPCoefQryAndAmount(sb);
        IRowSet _Data = this.getWIPCountingDataThisRank(ctx, sb);
        if (_Data != null && _Data.size() > 0) {
            isSuccess = this.allocAndCalWIPCounting(ctx, sb, _Data);
        }
        return isSuccess;
    }

    private void dealWithDataNotDealtAtLast(Context ctx, StringBuffer sb) throws BOSException {
        sb.append("UPDATE ").append(this.getTblCostCalMatDetailData()).append('\n').append("   Set FEoPWIPAmount=0, FEoPWIPBaseQty=0, FFinishedAmount=FAmount, FFinishedBaseQty=FBaseQty, ").append('\n').append("       FEoPWIPCommonQty=0, FFinishedCommonQty=FCommonQty, FEoPWIPAssistQty=0, FFinishedAssistQty=FAssistQty ").append('\n').append(" where FHaveDealt=0 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private boolean allocAndCalWIPCounting(Context ctx, StringBuffer sb, IRowSet _Data) throws BOSException, SQLException {
        boolean isSuccess = true;
        DecimalFormat format = new DecimalFormat("###0.000000000000000000000");
        try {
            String lastCostCenterId = null;
            String lastMaterialId = null;
            String lastLot = null;
            String lastCostItemId = null;
            String costCenterId = null;
            String materialId = null;
            String lot = null;
            String costObjectId = null;
            String costObjectSuiteId = null;
            String costItemId = null;
            String amount = null;
            String baseQty = null;
            String commonQty = null;
            String assistQty = null;
            boolean isInWH = false;
            boolean isDataGroupChange = false;
            _Data.first();
            while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                costCenterId = _Data.getString("FCostCenterid") == null ? "" : _Data.getString("FCostCenterid");
                materialId = _Data.getString("FMaterialID") == null ? "" : _Data.getString("FMaterialID");
                lot = _Data.getString("FLot") == null ? "" : _Data.getString("FLot");
                costObjectId = _Data.getString("FCostObjectId") == null ? "" : _Data.getString("FCostObjectId");
                costItemId = _Data.getString("FCostItemId") == null ? "" : _Data.getString("FCostItemId");
                isDataGroupChange = lastCostCenterId != null && lastMaterialId != null && lastLot != null && lastCostItemId != null && (!costCenterId.equals(lastCostCenterId) || !materialId.equals(lastMaterialId) || !lot.equals(lastLot) || !costItemId.equals(lastCostItemId));
                lastCostCenterId = costCenterId;
                lastMaterialId = materialId;
                lastLot = lot;
                lastCostItemId = costItemId;
                if (isDataGroupChange) {
                    isSuccess = this.WIPAccountingCalculate(sb, lastCostCenterId, lastMaterialId, lastLot, lastCostItemId);
                }
                if (!"".equals(costObjectId)) {
                    this.allocDirect(sb, costCenterId, materialId, lot, costItemId, costObjectId);
                } else {
                    costObjectSuiteId = _Data.getString("FCostObjectSuiteId") == null ? "" : _Data.getString("FCostObjectSuiteId");
                    amount = format.format(_Data.getBigDecimal("FAmount"));
                    baseQty = format.format(_Data.getBigDecimal("FBaseQty"));
                    commonQty = format.format(_Data.getBigDecimal("FCommonQty"));
                    assistQty = format.format(_Data.getBigDecimal("FAssistQty"));
                    isInWH = _Data.getInt("isInWH") == 1;
                    this.allocInDirect(sb, costCenterId, materialId, lot, costItemId, costObjectId, costObjectSuiteId, amount, baseQty, commonQty, assistQty, isInWH);
                }
                if (_Data.isLast()) {
                    isSuccess = this.WIPAccountingCalculate(sb, lastCostCenterId, lastMaterialId, lastLot, lastCostItemId);
                }
                _Data.next();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return isSuccess;
    }

    private void allocInDirect(StringBuffer sb, String costCenterId, String materialId, String lot, String costItemId, String costObjectId, String costObjectSuiteId, String amount, String baseQty, String commonQty, String assistQty, boolean isInWH) throws SQLException, BOSException {
        IRowSet dataShouldBeDelete;
        boolean notAlloc = false;
        if (isInWH && (dataShouldBeDelete = this.getDataShouldBeDelete(sb, costCenterId, materialId, lot, costItemId, costObjectSuiteId, amount, baseQty, commonQty, assistQty)) != null && dataShouldBeDelete.size() > 0) {
            dataShouldBeDelete.first();
            if (this.usingQtyOrAmount()) {
                baseQty = dataShouldBeDelete.getString("FBaseQty");
                commonQty = dataShouldBeDelete.getString("FCommonQty");
                assistQty = dataShouldBeDelete.getString("FAssistQty");
                notAlloc = new Double(baseQty) <= 0.0;
            } else {
                amount = dataShouldBeDelete.getString("FAmount");
                boolean bl = notAlloc = new Double(amount) <= 0.0;
            }
        }
        if (notAlloc) {
            this.deleteFromTblWIPCountingMaterial(sb, costCenterId, materialId, lot, costObjectSuiteId, costItemId);
            return;
        }
        this.allocCoefficient(sb, costCenterId, materialId, lot, costItemId, costObjectSuiteId);
        this.signDealingDataInTblWIPCountingMaterial(sb, costCenterId, materialId, lot, costItemId, null, costObjectSuiteId);
        this.allocAountAndQty(sb, amount, baseQty, commonQty, assistQty);
        this.adjustDiffAllocResult(sb, amount, baseQty, commonQty, assistQty);
    }

    private void signDealingDataInTblWIPCountingMaterial(StringBuffer sb, String costCenterId, String materialId, String lot, String costItemId, String costObjectId, String costObjectSuiteId) throws BOSException {
        StringBuffer ss = new StringBuffer();
        ss.append("      (select 1 from ").append(this.getTblCostCalMatDetailData()).append(" b ").append('\n');
        if (costObjectSuiteId != null && !"".equals(costObjectSuiteId)) {
            ss.append("        inner join T_NCM_CostObjectSuiteEntry as cog ").append('\n').append("           on cog.FCostObjectID=b.FCostObjectID ").append('\n');
        }
        ss.append("        where b.FCostCenterID = '").append(costCenterId).append("'").append('\n').append("          and b.FMaterialID = '").append(materialId).append("'").append('\n').append("          and b.FLot ").append(lot != null && !"".equals(lot) ? "= '" + lot + "'" : "is null ").append('\n').append("          and b.FCostItemId ='").append(costItemId).append("'").append('\n');
        if (costObjectId != null && !"".equals(costObjectId)) {
            ss.append("          and b.FCostObjectId = '").append(costObjectId).append("'").append('\n');
        }
        if (costObjectSuiteId != null && !"".equals(costObjectSuiteId)) {
            ss.append("          and cog.FParentID ='").append(costObjectSuiteId).append("'").append('\n');
        }
        ss.append("          and b.FHaveDealt=0 )").append('\n');
        sb.append("update ").append(this.getTblWIPCountingMaterial()).append('\n').append("   set FHaveDealt=2 ").append('\n').append(" where exists ").append('\n').append(ss).append('\n').append("   and FCostCenterid='").append(costCenterId).append("'").append('\n').append("   and FMaterialID='").append(materialId).append("'").append('\n').append("   and FLot ").append(lot != null && !"".equals(lot) ? "= '" + lot + "'" : "is null ").append('\n').append("   and FCostItemId ='").append(costItemId).append("'").append('\n').append("   and FCostObjectId ").append(costObjectId != null && !"".equals(costObjectId) ? "= '" + costObjectId + "'" : "is null ").append('\n').append("   and FCostObjectSuiteId ").append(costObjectSuiteId != null && !"".equals(costObjectSuiteId) ? "= '" + costObjectSuiteId + "'" : "is null ").append('\n').append("   and FHaveDealt=0 ").append('\n').append(";").append('\n');
    }

    private IRowSet getDataShouldBeDelete(StringBuffer sb, String costCenterId, String materialId, String lot, String costItemId, String costObjectSuiteId, String amount, String baseQty, String commonQty, String assistQty) throws BOSException {
        sb.append("select ").append(amount).append("-isnull(sum(d.FAmount), 0) as FAmount, ").append('\n').append("       ").append(baseQty).append("-isnull(sum(d.FBaseQty), 0) as FBaseQty, ").append('\n').append("       ").append(commonQty).append("-isnull(sum(d.FCommonQty), 0) as FCommonQty, ").append('\n').append("       ").append(assistQty).append("-isnull(sum(d.FAssistQty), 0) as FAssistQty ").append('\n').append("  from ").append(this.getTblDataNofinishedToDealWith()).append(" as d ").append('\n');
        if (costObjectSuiteId != null && !"".equals(costObjectSuiteId)) {
            sb.append(" inner join T_NCM_CostObjectSuiteEntry as cog ").append('\n').append("    on cog.FCostObjectID=d.FCostObjectID ").append('\n');
        }
        sb.append(" where d.FCostCenterid='").append(costCenterId).append("'").append('\n').append("   and d.FMaterialID='").append(materialId);
        if (lot != null && !"".equals(lot)) {
            sb.append("' and d.FLot='").append(lot).append("'").append('\n');
        } else {
            sb.append("' and d.FLot is null ").append('\n');
        }
        sb.append("   and d.FCostItemId='").append(costItemId).append("'").append('\n');
        if (costObjectSuiteId != null && !"".equals(costObjectSuiteId)) {
            sb.append("   and cog.FParentID='").append(costObjectSuiteId).append("'").append('\n');
        }
        sb.append(" group by d.FCostCenterid, d.FMaterialID, d.FLot, d.FCostItemId ").append(";").append('\n');
        IRowSet _Data = NCMDbUtil.executeQuery((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        return _Data;
    }

    private IRowSet getWIPCountingDataThisRank(Context ctx, StringBuffer sb) throws BOSException {
        sb.append("select distinct ").append('\n').append("       b.FCostCenterid, b.FMaterialID, b.FLot, b.FCostItemId, b.FCostObjectId, b.FCostObjectSuiteId, ").append('\n').append("       isnull(b.FAmount, 0) as FAmount, isnull(b.FBaseQty, 0) as FBaseQty, ").append('\n').append("       isnull(b.FCommonQty, 0) as FCommonQty, isnull(b.FAssistQty, 0) as FAssistQty, ").append('\n').append("       b.isInWH ").append('\n').append("  from (").append('\n').append("  select distinct FCostCenterID, FMaterialID,FLot, FCostItemId, FCostObjectId").append('\n').append("    from ").append(this.getTblCostCalMatDetailData()).append('\n').append("   where FHaveDealt=0 ").append('\n').append("  ) as D inner join ").append(this.getTblWIPCountingMaterial()).append(" b ").append('\n').append("   on d.FCostCenterID=b.FCostCenterID ").append('\n').append("   and d.FMaterialID=b.FMaterialID and isnull(d.FLot, ' ')=isnull(b.FLot, ' ') ").append('\n').append("   and d.FCostItemId=b.FCostItemId ").append('\n').append(" where b.FHaveDealt=0 ").append('\n').append("    and ((b.FCostObjectId is null) or (b.FCostObjectId is not null and d.FCostObjectId=b.FCostObjectId))").append('\n').append(" order by b.FCostCenterid asc, b.FMaterialID asc, b.FLot asc, b.FCostItemId asc, b.FCostObjectId desc, b.FCostObjectSuiteId asc");
        IRowSet _Data = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        return _Data;
    }

    private void deleteFromTblWIPCountingMaterial(StringBuffer sb, String costCenterId, String materialId, String lot, String costObjectSuiteId, String costItemId) throws BOSException {
        sb.delete(0, sb.length());
        sb.append("delete from ").append(this.getTblWIPCountingMaterial()).append('\n');
        sb.append(" where FCostCenterid='").append(costCenterId).append("'").append('\n').append("   and FMaterialID='").append(materialId).append("'");
        if (lot != null && !"".equals(lot)) {
            sb.append(" and FLot='").append(lot).append("'").append('\n');
        } else {
            sb.append(" and FLot is null ").append('\n');
        }
        sb.append("   and FCostItemId='").append(costItemId).append("'").append('\n');
        if (costObjectSuiteId != null && !"".equals(costObjectSuiteId)) {
            sb.append(" and FCostObjectSuiteId='").append(costObjectSuiteId).append("'").append('\n');
        } else {
            sb.append(" and FCostObjectSuiteId is null ").append('\n');
        }
        sb.append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private void deleteFromTblWIPCountingMaterial(StringBuffer sb, String costCenterId, String materialId, String lot, String costItemId) throws BOSException {
        sb.delete(0, sb.length());
        sb.append("delete from ").append(this.getTblWIPCountingMaterial()).append('\n');
        sb.append(" where FCostCenterid='").append(costCenterId).append("'").append('\n').append("   and FMaterialID='").append(materialId).append("'");
        if (lot != null && !"".equals(lot)) {
            sb.append(" and FLot='").append(lot).append("'").append('\n');
        } else {
            sb.append(" and FLot is null ").append('\n');
        }
        sb.append("   and FCostItemId='").append(costItemId).append("'").append('\n').append("   and FHaveDealt=2 ").append('\n');
        sb.append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private boolean WIPAccountingCalculate(StringBuffer sb, String costCenterId, String materialId, String lot, String costItemId) throws EASBizException, BOSException, SQLException {
        boolean isSuccess = this.checkAllocDataBeforeCalculate(sb);
        if (isSuccess) {
            this.saveDataOfAllocResult(sb);
            this.allocWIPAccountingAndFinished(sb);
            this.updateTblWIPCountingMaterialDealt(sb, costCenterId, materialId, lot, costItemId);
        } else {
            this.deleteFromTblCostCalMatDetailData(sb);
            this.deleteFromTblWIPCountingMaterial(sb, costCenterId, materialId, lot, costItemId);
        }
        this.truncateTblByGivenName(sb, this.getTblWIPCountingAllocData());
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        return isSuccess;
    }

    private void deleteFromTblCostCalMatDetailData(StringBuffer sb) throws BOSException {
        sb.append("delete from ").append(this.getTblCostCalMatDetailData()).append('\n').append(" where exists(").append('\n').append("       select 1 from ").append(this.getTblWIPCountingAllocData()).append(" b ").append('\n').append("        where ").append(this.getTblCostCalMatDetailData()).append(".FCostCenterID=b.FCostCenterID ").append('\n').append("          and ").append(this.getTblCostCalMatDetailData()).append(".FMaterialID=b.FMaterialID and isnull(").append(this.getTblCostCalMatDetailData()).append(".FLot, ' ')=isnull(b.FLot, ' ') ").append('\n').append("          and ").append(this.getTblCostCalMatDetailData()).append(".FCostItemId=b.FCostItemId ").append('\n').append("          and ").append(this.getTblCostCalMatDetailData()).append(".FCostObjectId=b.FCostObjectId ").append('\n').append("       )").append('\n').append("   and FHaveDealt=0 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private void updateTblWIPCountingMaterialDealt(StringBuffer sb, String costCenterId, String materialId, String lot, String costItemId) throws BOSException {
        sb.append("update ").append(this.getTblWIPCountingMaterial()).append('\n').append("   set FHaveDealt=1 ").append('\n').append(" where FCostCenterid='").append(costCenterId).append("'").append('\n').append("   and FMaterialID='").append(materialId).append("'");
        if (lot != null && !"".equals(lot)) {
            sb.append(" and FLot='").append(lot).append("'").append('\n');
        } else {
            sb.append(" and FLot is null ").append('\n');
        }
        sb.append("   and FCostItemId='").append(costItemId).append("'").append('\n').append("   and FHaveDealt=2 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private void truncateTblByGivenName(StringBuffer sb, String givenName) throws BOSException {
        sb.append("truncate table ").append(givenName).append('\n').append(";").append('\n');
    }

    private boolean checkAllocDataBeforeCalculate(StringBuffer sb) throws BOSException, SQLException {
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        sb.append("select top 100 cc.FNumber as costCenterNumber, cc.FName_l2 as costCenterName, ").append("       mat.FNumber as materialNumber, mat.FName_l2 as materialName, ").append("       ci.FNumber as costItemNumber, ci.FName_l2 as costItemName, ").append('\n').append("       d.FCostObjectId as FCostObjectId, d.Flot as Flot, ").append('\n').append("       co.FNumber as costObjectNumber, co.FName_l2 as costObjectName, ").append('\n').append("       ").append(this.usingQtyOrAmount() ? "(CASE WHEN isnull(b.FAllocBaseQty, 0)>0 and isnull(b.FAllocBaseQty, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(b.FAllocBaseQty, 0))) \n ELSE CONVERT(VARCHAR, isnull(b.FAllocBaseQty, 0)) END) as alloctedData, \n(CASE WHEN isnull(d.FBaseQty, 0)>0 and isnull(d.FBaseQty, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(d.FBaseQty, 0))) \n ELSE CONVERT(VARCHAR, isnull(d.FBaseQty, 0)) END) as originalData " : "(CASE WHEN isnull(b.FAllocAmount, 0)>0 and isnull(b.FAllocAmount, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(b.FAllocAmount, 0))) \n ELSE CONVERT(VARCHAR, isnull(b.FAllocAmount, 0)) END) as alloctedData, \n(CASE WHEN isnull(d.FAmount, 0)>0 and isnull(d.FAmount, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(d.FAmount, 0))) \n ELSE CONVERT(VARCHAR, isnull(d.FAmount, 0)) END) as originalData ").append('\n').append("  from (").append('\n').append(" select FCostCenterid, FMaterialID, Flot, FCostItemId, FCostObjectId, sum(FAllocAmount) as FAllocAmount , sum(FAllocBaseQty) as FAllocBaseQty ").append('\n').append("   from ").append(this.getTblWIPCountingAllocData()).append('\n').append("  group by FCostCenterid, FMaterialID, Flot, FCostItemId, FCostObjectId ").append('\n').append(") as b left outer join ").append(this.getTblCostCalMatDetailData()).append(" as d ").append('\n').append("    on d.FCostCenterID=b.FCostCenterID and d.FMaterialID=b.FMaterialID and isnull(d.Flot,' ')=isnull(b.Flot, ' ')").append('\n').append("   and d.FCostItemId=b.FCostItemId and d.FCostObjectID=b.FCostObjectID").append('\n').append(" inner join t_org_costcenter cc on b.FCostCenterID=cc.FID").append('\n').append(" inner join t_bd_material mat on b.FMaterialID=mat.FID").append('\n').append(" inner join T_NCM_CostItem ci on b.FCostItemId=ci.FID").append('\n').append(" inner join T_BD_CostObject co on b.FCostObjectId=co.FID").append('\n').append(" where ").append(this.usingQtyOrAmount() ? "isnull(b.FAllocBaseQty, 0)>isnull(d.FBaseQty, 0)" : "isnull(b.FAllocAmount, 0)>isnull(d.FAmount, 0)").append('\n').append("   and d.FHaveDealt=0 ").append('\n').append(" order by b.FCostCenterid, b.FMaterialID, b.Flot, b.FCostItemId, b.FCostObjectId");
        IRowSet _Data = NCMDbUtil.executeQuery((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        boolean isSuccess = true;
        if (_Data != null && _Data.size() > 0) {
            String error = null;
            String errorTemplet = this.usingQtyOrAmount() ? CalculateUtil.getSrvCalResource(this._ctx, "Cost_Cal_AllocWIPCounting_Error_DESC_Qty") : CalculateUtil.getSrvCalResource(this._ctx, "Cost_Cal_AllocWIPCounting_Error_DESC_Amount");
            String errorTempletNoLot = this.usingQtyOrAmount() ? CalculateUtil.getSrvCalResource(this._ctx, "Cost_Cal_AllocWIPCounting_Error_NoLot_DESC_Qty") : CalculateUtil.getSrvCalResource(this._ctx, "Cost_Cal_AllocWIPCounting_Error_NoLot_DESC_Amount");
            String reason = this.usingQtyOrAmount() ? CalculateUtil.getSrvCalResource(this._ctx, "Cost_Cal_AllocWIPCounting_Error_Reason_Qty") : CalculateUtil.getSrvCalResource(this._ctx, "Cost_Cal_AllocWIPCounting_Error_Reason_Amount");
            String advice = this.usingQtyOrAmount() ? CalculateUtil.getSrvCalResource(this._ctx, "Cost_Cal_AllocWIPCounting_Error_Advice_Qty") : CalculateUtil.getSrvCalResource(this._ctx, "Cost_Cal_AllocWIPCounting_Error_Advice_Amount");
            String lot = null;
            _Data.first();
            while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                isSuccess = false;
                lot = _Data.getString("Flot");
                error = lot != null && lot.length() > 0 ? MessageFormat.format(errorTemplet, _Data.getString("costCenterNumber"), _Data.getString("costCenterName"), _Data.getString("materialNumber"), _Data.getString("materialName"), _Data.getString("Flot"), _Data.getString("costItemNumber"), _Data.getString("costItemName"), _Data.getString("costObjectNumber"), _Data.getString("costObjectName"), _Data.getString("alloctedData"), _Data.getString("originalData")) : MessageFormat.format(errorTempletNoLot, _Data.getString("costCenterNumber"), _Data.getString("costCenterName"), _Data.getString("materialNumber"), _Data.getString("materialName"), _Data.getString("costItemNumber"), _Data.getString("costItemName"), _Data.getString("costObjectNumber"), _Data.getString("costObjectName"), _Data.getString("alloctedData"), _Data.getString("originalData"));
                this._log.AddCalcDetailLog(sb, _Data.getString("FCostObjectID"), error, reason, advice, CheckCalTypeEnum.ALLOCWIP);
                _Data.next();
            }
            if (sb.length() > 0) {
                NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
                sb.delete(0, sb.length());
            }
        }
        return isSuccess;
    }

    private void allocDirect(StringBuffer sb, String costCenterId, String materialId, String lot, String costItemId, String costObjectId) throws BOSException {
        sb.append("insert into ").append(this.getTblWIPCountingAllocData()).append('\n').append("(FCostCenterid, FMaterialID, FLot, FCostItemId, FCostObjectId, ").append('\n').append(" FWIPCoefAmount, FWIPCoefQty, FAllocCoefficient, FBasePrice, FUnitID, FCommonPrice, FAssistPrice, ").append('\n').append(" FAllocAmount, FAllocBaseQty, FAllocCommonQty, FAllocAssistQty, FIsDirect, FHaveDealt)").append('\n').append("select b.FCostCenterid, b.FMaterialID, b.Fbatch as Flot, b.FCostItemId, b.FCostObjectId, ").append('\n');
        if (this.usingQtyOrAmount()) {
            sb.append("       ISNULL(d.FWIPCoefQty,0)*ISNULL(d.FBasePrice,0), ").append('\n').append("       ISNULL(d.FWIPCoefQty,0), ").append('\n');
        } else {
            sb.append("       ISNULL(d.FWIPCoefAmount,0), ").append('\n').append("       ISNULL(d.FWIPCoefAmount,0)/ISNULL(d.FBasePrice,1), ").append('\n');
        }
        sb.append("       1, ISNULL(d.FBasePrice,0), d.FUnitID,ISNULL(d.FCommonPrice,0), ISNULL(d.FAssistPrice,0), ").append('\n');
        if (this.usingQtyOrAmount()) {
            sb.append(" case when d.FIsRework = 0 then \n").append("       ISNULL(b.FBaseQty, 0)*ISNULL(d.FBasePrice,0) ").append('\n').append(" else 0 end, \n").append(" case when d.FIsRework = 0 then \n").append("       ISNULL(b.FBaseQty, 0) ").append('\n').append(" else 0 end, \n").append(" case when d.FIsRework = 0 then \n").append("       b.FQty ").append('\n').append(" else 0 end, \n").append(" case when d.FIsRework = 0 then \n").append("       b.FAssistQty ").append('\n').append(" else 0 end, \n");
        } else {
            sb.append(" case when d.FIsRework = 0 then \n").append("       ISNULL(b.FAmount,0) ").append('\n').append(" else 0 end, \n").append(" case when d.FIsRework = 0 then \n").append("       (CASE WHEN d.FBasePrice<>0 THEN ISNULL(b.FAmount,0)/ISNULL(d.FBasePrice,1) ELSE 0 END) ").append('\n').append(" else 0 end, \n").append(" case when d.FIsRework = 0 then \n").append("       (CASE WHEN d.FCommonPrice<>0 THEN ISNULL(b.FAmount,0)/ISNULL(d.FCommonPrice,1) ELSE 0 END) ").append('\n').append(" else 0 end, \n").append(" case when d.FIsRework = 0 then \n").append("       (CASE WHEN d.FAssistPrice<>0 THEN ISNULL(b.FAmount,0)/ISNULL(d.FAssistPrice,1) ELSE 0 END) ").append('\n').append(" else 0 end, \n");
        }
        sb.append("       1, 1 ").append('\n').append("  from T_NCM_WIPCountingMaterial as b ").append('\n').append("  inner join ").append('\n').append("      (select * from ").append(this.getTblCostCalMatDetailData()).append('\n').append("        where FHaveDealt=0 ").append('\n').append("       ) as d ").append('\n').append("    on  d.FCostCenterID=b.FCostCenterID and d.FMaterialID=b.FMaterialID and isnull(d.FLot, ' ')=isnull(b.Fbatch, ' ') ").append('\n').append("   and d.FCostItemId=b.FCostItemId AND d.FCostObjectID=b.FCostObjectID ").append('\n').append(" where b.FCompanyOrg='").append(this._companyId).append("'").append('\n').append("   and b.FCalculatePeriod='").append(this._periodId).append("'").append('\n').append("   and b.FCostCenterid='").append(costCenterId).append("'").append('\n').append("   and b.FMaterialID='").append(materialId);
        if (lot != null && !"".equals(lot)) {
            sb.append("' and b.Fbatch='").append(lot).append("'");
        } else {
            sb.append("' and b.Fbatch is null ");
        }
        sb.append('\n').append("   and b.FCostItemId='").append(costItemId).append("'").append('\n').append("   and b.FCostObjectId='").append(costObjectId).append("'").append('\n').append(";").append('\n');
        this.signDealingDataInTblWIPCountingMaterial(sb, costCenterId, materialId, lot, costItemId, costObjectId, null);
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private void saveDataToResultTempTbl(StringBuffer sb) throws BOSException {
        sb.append("insert into ").append(this._calcTable.GetTemp_CostCalMatDetailResultTable()).append('\n').append("(FID, FParentID,FCostCenterID, FCostObjectID, FCostItemID, FMaterialID, FLot, ").append('\n').append(" FIsSelfManufacture, FSpendCostObjectID, FIsReWork, FAllocStdID, ").append('\n').append(" FUnitID, FPrice, FPricePrecision, ").append('\n').append(" FQty, FQtyPrecision,FFinishedQty, FEoPWIPQty, ").append('\n').append(" FAmount, FAmountPrecision, FFinishedAmount, FEoPWIPAmount, ").append('\n').append(" FAssistQty, FAssistQtyPrecision, FEoPWIPAssistQty, FFinishedAssistQty, ").append('\n').append(" FAddqty, FAddqtyPrecision, FEoPWIPAddQty, FFinishedAddQty, ").append('\n').append(" FWIPCoefQty, FWIPCoefAmount, FAddPrice, FAssistPrice )").append('\n').append("select FID, FParentID,FCostCenterID, FCostObjectID, FCostItemID, FMaterialID, FLot, ").append('\n').append("       FIsSelfManufacture, FSpendCostObjectID, FIsReWork, FAllocStdID, ").append('\n').append("       FUnitID, FBasePrice, FPricePrecision, ").append('\n').append("       FBaseQty, FBaseQtyPrecision,FFinishedBaseQty, FEoPWIPBaseQty, ").append('\n').append("       FAmount, FAmountPrecision, FFinishedAmount, FEoPWIPAmount, ").append('\n').append("       FAssistQty, FAssistQtyPrecision, FEoPWIPAssistQty, FFinishedAssistQty, ").append('\n').append("       FCommonQty, FCommonQtyPrecision, FEoPWIPCommonQty, FFinishedCommonQty, ").append('\n').append("       FWIPCoefQty, FWIPCoefAmount, FCommonPrice, FAssistPrice ").append('\n').append("  from ").append(this.getTblCostCalMatDetailData()).append('\n').append(";").append('\n');
        sb.append("insert into ").append(this._calcTable.GetTemp_CostCalResultTable()).append('\n').append("(FCostCenterID,FCostItemID,FCostObjectID, ").append('\n').append(" FAmount,FQty, FAddqty,FAssistQty, ").append('\n').append(" FFinishedAmount, FFinishedQty, FEoPWIPAmount, FEoPWIPQty, ").append('\n').append(" FFinishedAddQty, FEoPWIPAddQty, FFinishedAssistQty, FEoPWIPAssistQty)").append('\n').append("select FCostCenterid, FCostItemId, FCostObjectId, ").append('\n').append("       SUM(FAmount), SUM(FBaseQty), SUM(FCommonqty), SUM(FAssistQty), ").append('\n').append("       SUM(FFinishedAmount), SUM(FFinishedBaseQty), SUM(FEoPWIPAmount), SUM(FEoPWIPBaseQty), ").append('\n').append("       SUM(FFinishedCommonQty), SUM(FEoPWIPCommonQty), SUM(FFinishedAssistQty), SUM(FEoPWIPAssistQty) ").append('\n').append("  from ").append(this.getTblCostCalMatDetailData()).append('\n').append(" group by FCostCenterid, FCostObjectId, FCostItemId").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        NCMUtils.analyzeTempTable((Context)this._ctx, (String)this._calcTable.GetTemp_CostCalResultTable());
    }

    private void allocWIPAccountingAndFinished(StringBuffer sb) throws BOSException {
        sb.append("insert into ").append(this.getTblWIPCountingAllocData()).append('\n').append("(FCostCenterID, FMaterialID, FLot,FCostItemId, FCostObjectID, ").append(" FAllocAmount, FAllocBaseQty, FAllocCommonQty, FAllocAssistQty, ").append('\n').append(" FHaveDealt)").append('\n').append("select FCostCenterID, FMaterialID, FLot,FCostItemId, FCostObjectID, ").append('\n').append("       sum(FAllocAmount) as FAllocAmount, sum(FAllocBaseQty) as FAllocBaseQty, ").append('\n').append("       sum(FAllocCommonQty) as FAllocCommonQty, sum(FAllocAssistQty) as FAllocAssistQty,").append('\n').append("       3 as FHaveDealt ").append('\n').append("  from ").append(this.getTblWIPCountingAllocData()).append('\n').append(" group by FCostCenterID, FMaterialID, FLot,FCostItemId, FCostObjectID ").append('\n').append(";").append('\n');
        sb.append("delete from ").append(this.getTblWIPCountingAllocData()).append('\n').append(" where FHaveDealt<>3 ").append(";").append('\n');
        sb.append("UPDATE ").append(this.getTblCostCalMatDetailData()).append('\n').append("Set (FEoPWIPAmount, FEoPWIPBaseQty, FFinishedAmount, FFinishedBaseQty, ").append('\n').append("     FEoPWIPCommonQty, FFinishedCommonQty, FEoPWIPAssistQty, FFinishedAssistQty, ").append("     FHaveDealt )=").append('\n').append("(select b.FAllocAmount as FEoPWIPAmount, b.FAllocBaseQty as FEoPWIPBaseQty, ").append('\n').append("        (").append(this.getTblCostCalMatDetailData()).append(".FAmount-b.FAllocAmount) as FFinishedAmount, (").append(this.getTblCostCalMatDetailData()).append(".FBaseQty-b.FAllocBaseQty) as FFinishedBaseQty, ").append('\n').append("        b.FAllocCommonQty as FEoPWIPCommonQty, (").append(this.getTblCostCalMatDetailData()).append(".FCommonQty-b.FAllocCommonQty) as FFinishedCommonQty, ").append('\n').append("        b.FAllocAssistQty as FEoPWIPAssistQty, (").append(this.getTblCostCalMatDetailData()).append(".FAssistQty-b.FAllocAssistQty) as FFinishedAssistQty, ").append('\n').append("        1 as FHaveDealt ").append('\n').append("   from ").append(this.getTblWIPCountingAllocData()).append(" as b ").append('\n').append("  where ").append(this.getTblCostCalMatDetailData()).append(".FCostCenterID=b.FCostCenterID and ").append(this.getTblCostCalMatDetailData()).append(".FMaterialID=b.FMaterialID and isnull(").append(this.getTblCostCalMatDetailData()).append(".FLot, ' ')=isnull(b.FLot, ' ') ").append('\n').append("    and ").append(this.getTblCostCalMatDetailData()).append(".FCostItemId=b.FCostItemId AND ").append(this.getTblCostCalMatDetailData()).append(".FCostObjectID=b.FCostObjectID ").append('\n').append("    and ").append(this.getTblCostCalMatDetailData()).append(".FHaveDealt=0 ").append('\n').append(") where ").append(this.getTblCostCalMatDetailData()).append(".FHaveDealt=0 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private String getTblWIPCountingAllocResult() throws BOSException, EASBizException, SQLException {
        if (this.tblWIPCountingAllocResult == null) {
            this.tblWIPCountingAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_WIPCountingAllocResult");
        }
        return this.tblWIPCountingAllocResult;
    }

    private String getTblWIPCountingAllocData() throws BOSException {
        if (this.tblWIPCountingAllocData == null) {
            String columns = "Create Table t_tempTblWIPCountingAllocData ( FCostCenterid VARCHAR(44), FMaterialID VARCHAR(44), FLot NVARCHAR(80), FCostItemId VARCHAR(44), FCostObjectId VARCHAR(44), FWIPCoefAmount NUMERIC(21,8) DEFAULT 0 , FWIPCoefQty NUMERIC(21,8) DEFAULT 0 , FAllocCoefficient NUMERIC(21,8) DEFAULT 0 , FAllocAmount NUMERIC(21,8) DEFAULT 0 , FAllocBaseQty NUMERIC(21,8) DEFAULT 0 , FBasePrice NUMERIC(21,8) DEFAULT 0 , FUnitID VARCHAR(44),FAllocCommonQty NUMERIC(21,8) DEFAULT 0 , FCommonPrice NUMERIC(21,8) DEFAULT 0 , FAllocAssistQty NUMERIC(21,8) DEFAULT 0 , FAssistPrice NUMERIC(21,8) DEFAULT 0 , FIsDirect INT , FHaveDealt INT DEFAULT 0 )";
            String index = "FCostCenterid, FMaterialID, FCostItemId, FCostObjectId";
            this.tblWIPCountingAllocData = this.createTempTable(columns, index);
        }
        return this.tblWIPCountingAllocData;
    }

    private void allocCoefficient(StringBuffer sb, String costCenterId, String materialId, String lot, String costItemId, String costObjectSuiteId) throws BOSException {
        sb.delete(0, sb.length());
        sb.append("update ").append(this.getTblWIPCountingAllocData()).append('\n').append("   set FHaveDealt=1 ").append('\n').append(" where FHaveDealt=0 ").append('\n').append(";").append('\n');
        sb.append("insert into ").append(this.getTblWIPCountingAllocData()).append('\n').append("(FCostCenterid, FMaterialID, FLot, FCostItemId, FCostObjectId, ").append('\n').append(" FWIPCoefAmount, FWIPCoefQty, FAllocCoefficient, ").append('\n').append(" FBasePrice, FUnitID,FCommonPrice, FAssistPrice, FIsDirect)").append('\n').append("select cmr.FCostCenterid, cmr.FMaterialID, cmr.FLot, cmr.FCostItemId, cmr.FCostObjectId, ").append('\n');
        if (this.usingQtyOrAmount()) {
            sb.append("       ISNULL(cmr.FWIPCoefQty,0)*ISNULL(cmr.FBasePrice,0), ").append('\n').append("       ISNULL(cmr.FWIPCoefQty,0), ").append('\n');
        } else {
            sb.append("       ISNULL(cmr.FWIPCoefAmount,0), ").append('\n').append("       ISNULL(cmr.FWIPCoefAmount,0)/ISNULL(cmr.FBasePrice,1), ").append('\n');
        }
        sb.append("       0, ISNULL(cmr.FBasePrice,0), cmr.FUnitID, ISNULL(cmr.FCommonPrice,0), ISNULL(cmr.FAssistPrice,0), 0 ").append('\n').append("  from ").append(this.getTblCostCalMatDetailData()).append(" as cmr ").append('\n');
        if (costObjectSuiteId != null && !"".equals(costObjectSuiteId)) {
            sb.append(" inner join T_NCM_CostObjectSuiteEntry as cog ").append('\n').append("    on cog.FCostObjectID=cmr.FCostObjectID ").append('\n');
        }
        sb.append(" where cmr.FCostCenterid='").append(costCenterId).append("'").append('\n').append("   and cmr.FMaterialID='").append(materialId);
        if (lot != null && !"".equals(lot)) {
            sb.append("' and cmr.FLot='").append(lot).append("'").append('\n');
        } else {
            sb.append("' and cmr.FLot is null ").append('\n');
        }
        sb.append("   and cmr.FCostItemId='").append(costItemId).append("'").append('\n');
        if (costObjectSuiteId != null && !"".equals(costObjectSuiteId)) {
            sb.append("   and cog.FParentID='").append(costObjectSuiteId).append("'").append('\n');
        }
        sb.append("   and cmr.FHaveDealt=0 ").append('\n');
        sb.append(";").append('\n');
        sb.append("update ").append(this.getTblWIPCountingAllocData()).append(" set FAllocCoefficient = ").append('\n');
        if (this.usingQtyOrAmount()) {
            sb.append("FWIPCoefQty/(Select ISNULL(SUM(S.FWIPCoefQty),1)As FWIPCoefQty FROM ").append(this.getTblWIPCountingAllocData()).append(" S)").append('\n').append("where (Select ISNULL(SUM(t.FWIPCoefQty),1)As FWIPCoefQty FROM ").append(this.getTblWIPCountingAllocData()).append(" t)<>0 ").append('\n');
        } else {
            sb.append("FWIPCoefAmount/(Select ISNULL(SUM(S.FWIPCoefAmount),1)As FWIPCoefAmount FROM ").append(this.getTblWIPCountingAllocData()).append(" S)").append('\n').append("where (Select ISNULL(SUM(t.FWIPCoefAmount),1)As FWIPCoefAmount FROM ").append(this.getTblWIPCountingAllocData()).append(" t)<>0 ").append('\n');
        }
        sb.append("  and FHaveDealt=0 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        NCMUtils.analyzeTempTable((Context)this._ctx, (String)this.getTblWIPCountingAllocData());
    }

    private void allocAountAndQty(StringBuffer sb, String amount, String baseQty, String commonQty, String assistQty) throws BOSException {
        if (this.usingQtyOrAmount()) {
            sb.append("update ").append(this.getTblWIPCountingAllocData()).append('\n').append("   set FAllocAmount=").append(baseQty).append("*FAllocCoefficient*FBasePrice,").append('\n').append("       FAllocBaseQty=").append(baseQty).append("*FAllocCoefficient, ").append('\n').append("       FAllocCommonQty=").append(commonQty).append("*FAllocCoefficient, ").append('\n').append("       FAllocAssistQty=").append(assistQty).append("*FAllocCoefficient").append('\n');
        } else {
            sb.append("update ").append(this.getTblWIPCountingAllocData()).append('\n').append("   set FAllocAmount=").append(amount).append("*FAllocCoefficient, ").append('\n').append("       FAllocBaseQty=(CASE WHEN FBasePrice<>0 THEN ").append(amount).append("*FAllocCoefficient/FBasePrice ELSE 0 END), ").append('\n').append("       FAllocCommonQty=(CASE WHEN FCommonPrice<>0 THEN ").append(amount).append("*FAllocCoefficient/FCommonPrice ELSE 0 END), ").append('\n').append("       FAllocAssistQty=(CASE WHEN FAssistPrice<>0 THEN ").append(amount).append("*FAllocCoefficient/FAssistPrice ELSE 0 END) ").append('\n');
        }
        sb.append(" where FHaveDealt=0 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private void adjustDiffAllocResult(StringBuffer sql, String amount, String baseQty, String commonQty, String assistQty) throws BOSException {
        StringBuffer sb = new StringBuffer();
        if (this.usingQtyOrAmount()) {
            sb.append("UPDATE {0} SET FAllocBaseQty=(FAllocBaseQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAllocBaseQty),0.00) ").append('\n').append("\t FROM {2} S WHERE S.FHaveDealt=0 ) ) ").append('\n').append(" WHERE FCostObjectId =(Select top 1 FCostObjectId From {3} ORDER BY FAllocBaseQty DESC ) ").append('\n').append("   AND FHaveDealt=0 ").append('\n').append(";").append('\n');
            String sqlAdjustAllocQty = MessageFormat.format(sb.toString(), this.getTblWIPCountingAllocData(), baseQty, this.getTblWIPCountingAllocData(), this.getTblWIPCountingAllocData());
            sql.append(sqlAdjustAllocQty);
            sb.delete(0, sb.length());
            sb.append("UPDATE {0} SET FAllocCommonQty=(FAllocCommonQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAllocCommonQty),0.00) ").append('\n').append("\tFROM {2} S WHERE S.FHaveDealt=0 ) ) ").append('\n').append(" WHERE FCostObjectId =(Select top 1 FCostObjectId From {3} ORDER BY FAllocCommonQty DESC ) ").append('\n').append("   AND FHaveDealt=0 ").append('\n').append(";").append('\n');
            String sqlAdjustAllocAddQty = MessageFormat.format(sb.toString(), this.getTblWIPCountingAllocData(), commonQty, this.getTblWIPCountingAllocData(), this.getTblWIPCountingAllocData());
            sql.append(sqlAdjustAllocAddQty);
            sb.delete(0, sb.length());
            sb.append("UPDATE {0} SET FAllocAssistQty=(FAllocAssistQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAllocAssistQty),0.00) ").append('\n').append("\tFROM {2} S WHERE S.FHaveDealt=0 ) ) ").append('\n').append(" WHERE FCostObjectId =(Select top 1 FCostObjectId From {3} ORDER BY FAllocAssistQty DESC ) ").append('\n').append("   AND FHaveDealt=0 ").append('\n').append(";").append('\n');
            String sqlAdjustAllocAssistQty = MessageFormat.format(sb.toString(), this.getTblWIPCountingAllocData(), assistQty, this.getTblWIPCountingAllocData(), this.getTblWIPCountingAllocData());
            sql.append(sqlAdjustAllocAssistQty);
        } else {
            sb.delete(0, sb.length());
            sb.append("UPDATE {0} SET FAllocAmount=(FAllocAmount + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAllocAmount),0.00) ").append('\n').append("\tFROM {2} S WHERE S.FHaveDealt=0 ) ) ").append('\n').append(" WHERE FCostObjectId =(Select top 1 FCostObjectId From {3} ORDER BY FWIPCoefAmount DESC ) ").append('\n').append("   AND FHaveDealt=0 ").append('\n').append(";").append('\n');
            String sqlAdjustAmount = MessageFormat.format(sb.toString(), this.getTblWIPCountingAllocData(), amount, this.getTblWIPCountingAllocData(), this.getTblWIPCountingAllocData());
            sql.append(sqlAdjustAmount);
        }
        sb.append("update ").append(this.getTblWIPCountingAllocData()).append('\n').append("   set FHaveDealt=1 ").append('\n').append(" where FHaveDealt=0 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sql.toString());
        sql.delete(0, sql.length());
    }

    private void saveDataOfAllocResult(StringBuffer sb) throws BOSException, EASBizException, SQLException {
        sb.append("insert into ").append(this.getTblWIPCountingAllocResult()).append('\n').append("(FID, FCompanyID, FCalculatePeriodID,").append('\n').append(" FCostCenterid, FMaterialID, FLot, FCostItemId, FCostObjectId,").append('\n').append(" FUnitID, FWIPCoefAmount, FWIPCoefQty, FAllocCoefficient, FAllocAmount,").append('\n').append(" FBaseQty, FBasePrice, FCommonQty, FCommonPrice, FAssistQty, FAssistPrice, FIsDirect)").append('\n').append("select newbosid('C4774737') AS FID ,").append('\n').append("       '").append(this._companyId).append("' as FCompanyID,").append('\n').append("       '").append(this._periodId).append("' as FCalculatePeriodID,").append('\n').append("       FCostCenterid, FMaterialID, FLot, FCostItemId, FCostObjectId,").append('\n').append("       FUnitID, FWIPCoefAmount, FWIPCoefQty, FAllocCoefficient, FAllocAmount,").append('\n').append("       FAllocBaseQty, FBasePrice, FAllocCommonQty, FCommonPrice, FAllocAssistQty, FAssistPrice, FIsDirect").append('\n').append("  from ").append(this.getTblWIPCountingAllocData()).append(";").append('\n');
    }

    private void makeWIPCoefQryAndAmount(StringBuffer sb) throws BOSException {
        sb.append("update ").append(this.getTblCostCalMatDetailData()).append('\n').append("   set FWIPCoefficient=FWIPInPrdQty/(FWIPFinishQty + FWIPInPrdQty)").append('\n').append(" where FHaveDealt=0 ").append('\n').append(";").append('\n');
        sb.append("update ").append(this.getTblCostCalMatDetailData()).append('\n').append("   set FWIPCoefQty=FBaseQty*FWIPCoefficient, FWIPCoefAmount=FAmount*FWIPCoefficient ").append('\n').append(" where FHaveDealt=0 ").append('\n').append(";").append('\n');
        sb.append("update ").append(this.getTblCostCalMatDetailData()).append(" as D ").append('\n').append("set FBasePrice=").append('\n').append("(select (CASE WHEN isnull(sum(b.FBaseQty), 0)<>0 THEN to_decimal(sum(b.FAmount),24,12)/to_decimal(sum(b.FBaseQty),24,12) ELSE 0 END) ").append('\n').append("   from ").append(this.getTblCostCalMatDetailData()).append(" b ").append('\n').append("  where d.FCostCenterID=b.FCostCenterID ").append('\n').append("    and d.FMaterialID=b.FMaterialID and isnull(d.FLot, ' ')=isnull(b.FLot, ' ') ").append('\n').append("    and d.FCostItemId=b.FCostItemId ").append('\n').append("    and d.FCostObjectId=b.FCostObjectId ").append('\n').append("    and b.FHaveDealt=0 ").append('\n').append("  group by b.FCostCenterid, b.FMaterialID, b.FLot, b.FCostItemId ").append('\n').append(") where FHaveDealt=0 ").append('\n').append(";").append('\n');
        sb.append("update ").append(this.getTblCostCalMatDetailData()).append(" as D ").append('\n').append("set FCommonPrice=").append('\n').append("(select (CASE WHEN isnull(sum(b.FCommonQty), 0)<>0 THEN to_decimal(sum(b.FAmount),24,12)/to_decimal(sum(b.FCommonQty),24,12) ELSE 0 END) ").append('\n').append("   from ").append(this.getTblCostCalMatDetailData()).append(" b ").append('\n').append("  where d.FCostCenterID=b.FCostCenterID ").append('\n').append("    and d.FMaterialID=b.FMaterialID and isnull(d.FLot, ' ')=isnull(b.FLot, ' ') ").append('\n').append("    and d.FCostItemId=b.FCostItemId ").append('\n').append("    and d.FCostObjectId=b.FCostObjectId ").append('\n').append("    and b.FHaveDealt=0 ").append('\n').append("  group by b.FCostCenterid, b.FMaterialID, b.FLot, b.FCostItemId ").append('\n').append(") where FHaveDealt=0 ").append('\n').append(";").append('\n');
        sb.append("update ").append(this.getTblCostCalMatDetailData()).append(" as D ").append('\n').append("set FAssistPrice=").append('\n').append("(select (CASE WHEN isnull(sum(b.FAssistQty), 0)<>0 THEN to_decimal(sum(b.FAmount),24,12)/to_decimal(sum(b.FAssistQty),24,12) ELSE 0 END)").append('\n').append("   from ").append(this.getTblCostCalMatDetailData()).append(" b ").append('\n').append("  where d.FCostCenterID=b.FCostCenterID ").append('\n').append("    and d.FMaterialID=b.FMaterialID and isnull(d.FLot, ' ')=isnull(b.FLot, ' ') ").append('\n').append("    and d.FCostItemId=b.FCostItemId ").append('\n').append("    and d.FCostObjectId=b.FCostObjectId ").append('\n').append("    and b.FHaveDealt=0 ").append('\n').append("  group by b.FCostCenterid, b.FMaterialID, b.FLot, b.FCostItemId ").append('\n').append(") where FHaveDealt=0 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private boolean usingQtyOrAmount() {
        if (this.usingQtyOrAmount == null) {
            this.usingQtyOrAmount = NCMUtils.isQtyWipType((Context)this._ctx, (String)this._companyId);
        }
        return this.usingQtyOrAmount;
    }

    private String createTempTable(String sqlCreateTbl, String index) throws BOSException {
        return NCMDbUtil.createTempTable((Context)this._ctx, (String)sqlCreateTbl, (String)index);
    }
}

