/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Calc.AllocWIP;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.app.Calc.AllocWIP.AllocWIP;
import com.kingdee.eas.ncm.cal.app.Calc.AllocWIP.IBatchAllocIterator;
import com.kingdee.eas.ncm.common.app.CalcTable;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchAllocByHardcodeIterator
implements IBatchAllocIterator {
    private static Logger logger = Logger.getLogger((String)BatchAllocByHardcodeIterator.class.getName());
    protected CalcTable _calcTable;
    protected AllocWIP _alloc;
    protected Map _param;
    protected Context _ctx;
    protected String _companyId;
    protected String _periodId;
    private boolean isFirstBatch = false;
    protected IRowSet _data = null;
    private int _dataCount = -1;
    public static final char CLF = '\n';
    private int iBatchCount = 0;
    private int iBatchIndex = 0;
    private boolean isDone = false;
    private ArrayList theBatch;

    public BatchAllocByHardcodeIterator(Map param, AllocWIP alloc, int rank) throws EASBizException, BOSException {
        this._alloc = alloc;
        this._param = param;
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("ctx"));
        Assert.that((boolean)param.containsKey("calcTable"));
        this._companyId = (String)param.get("companyId");
        this._periodId = (String)param.get("periodId");
        this._ctx = (Context)param.get("ctx");
        this._calcTable = (CalcTable)param.get("calcTable");
        this._data = this.GetCostObjListByLevel(rank);
    }

    @Override
    public void FirstBatch() throws EASBizException, BOSException {
        try {
            this._data.last();
            this._dataCount = this._data.getRow();
            this._data.first();
            this.iBatchCount = 0;
            this.iBatchIndex = 0;
            this.isDone = false;
            this.theBatch = new ArrayList();
            this.isFirstBatch = true;
            this.isDone = this.GetInnerGetBatch();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public boolean IsDone() throws EASBizException, BOSException {
        return this.isDone && !this.isFirstBatch;
    }

    @Override
    public void NextBatch() throws EASBizException, BOSException {
        this.isFirstBatch = false;
        this.isDone = this.GetInnerGetBatch();
    }

    @Override
    public CostTaskResultEnum AllocCurrBatch() throws EASBizException, BOSException {
        if (this.theBatch.size() > 0) {
            this._param.put("CostObjectsByBatch", this.theBatch.toArray());
            return this._alloc.doAllocWIP(this._ctx);
        }
        return CostTaskResultEnum.SUCCESS;
    }

    private IRowSet GetCostObjListByLevel(int rank) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        boolean isOutsourcCalc = NCMUtils.isDoOutSourcCalc((Context)this._ctx, (String)this._companyId);
        if (isOutsourcCalc) {
            CostDataCache costDataCache = (CostDataCache)this._param.get("CostDataCache");
            String T_TMP_CostObject = null;
            try {
                T_TMP_CostObject = costDataCache.getCostObjectTable();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            sb.append("Select DISTINCT co.FCostObjectID ").append('\n').append("FROM T_CAL_CostObjectRank R ").append('\n').append("INNER JOIN T_CAL_CostObjectRankEntry RE ON RE.FParentID= R.FID ").append('\n').append("INNER JOIN ").append(T_TMP_CostObject).append(" co ON co.FMaterialID = re.FCostObjectID and co.FIsMainProduct = 1 \n").append("WHERE R.FCompanyOrg='").append(this._companyId).append("' AND R.FCalculatePeriod='").append(this._periodId).append("'").append('\n').append("\t  AND R.FLlcType=0 AND RE.FRank=").append(rank).append('\n');
        } else {
            sb.append("Select DISTINCT RE.FCostObjectID ").append('\n').append("FROM T_CAL_CostObjectRank R ").append('\n').append("INNER JOIN T_CAL_CostObjectRankEntry RE ON RE.FParentID= R.FID ").append('\n').append("WHERE R.FCompanyOrg='").append(this._companyId).append("' AND R.FCalculatePeriod='").append(this._periodId).append("'").append('\n').append("\t  AND R.FLlcType=0 AND RE.FRank=").append(rank).append('\n');
        }
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)sb.toString());
        return rs;
    }

    private boolean GetInnerGetBatch() throws BOSException {
        try {
            int iBatchCountPerGet = this.getNumberOfOnBatch();
            if (this.iBatchCount <= 0) {
                double cnt = BigDecimal.valueOf(this._dataCount).divide(BigDecimal.valueOf(iBatchCountPerGet), 4, 4).doubleValue();
                this.iBatchCount = cnt - Math.floor(cnt) > 0.0 ? (int)Math.floor(cnt) + 1 : (int)Math.floor(cnt);
            }
            if (this.iBatchCount <= 0) {
                return true;
            }
            int i = 0;
            this.theBatch.clear();
            if (this.isFirstBatch) {
                this.theBatch.add(this._data.getString(1));
                ++i;
            }
            while (this._data.next()) {
                this.theBatch.add(this._data.getString(1));
                if (++i != iBatchCountPerGet) continue;
                ++this.iBatchIndex;
                return false;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return this.theBatch.size() == 0;
    }

    private int getNumberOfOnBatch() {
        int i;
        Object value = this._param.get("numberOfOneBatchOnWip");
        if (value != null && value instanceof Integer && (i = ((Integer)value).intValue()) > 0) {
            return i;
        }
        return 300;
    }

    @Override
    public int getBatchCount() throws EASBizException, BOSException {
        return this.iBatchCount;
    }
}

