/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.ncm.bill.app.AuxFeeAlloc.AuxAllocator;
import com.kingdee.eas.ncm.common.utils.NCMCommonParams;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.algorithm.GaussJordan;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AuxFeeCalc {
    private static Logger logger = Logger.getLogger((String)AuxFeeCalc.class.getName());
    private NCMCommonParams _ncmCommonParam;
    private Context _ctx;
    private String _companyId;
    private String _periodId;
    private String _tblAugmentedMatrix;
    private String _tblLinearEquations;
    private String _tblAuxAllocResult;

    public AuxFeeCalc(NCMCommonParams param) throws BOSException, EASBizException {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("ctx"));
        this._ncmCommonParam = param;
        this._ctx = param.getCTX();
        this._companyId = param.getCOMPANY_ID();
        this._periodId = param.getPERIOD_ID();
        try {
            this._tblAuxAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_AuxAllocResult");
            this._tblLinearEquations = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_LinearEquations");
            this._tblAugmentedMatrix = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_AugmentedMatrix");
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public void doCalc(Context ctx) throws BOSException, EASBizException {
        boolean isCalcSuccess = false;
        try {
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"18_AuxFeeCalc", (Locale)ctx.getLocale()));
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"19_AuxFeeCalc", (Locale)ctx.getLocale()));
            this.buildLinearEquationsTables();
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"20_AuxFeeCalc", (Locale)ctx.getLocale()));
            this.collectAllocatingAuxFee();
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"21_AuxFeeCalc", (Locale)ctx.getLocale()));
            this.buildAugmentedMatrixTables();
            if (NCMUtils.isPlannedAuxAlloc((Context)ctx, (String)this._companyId)) {
                this.solveLinearEquationsForPlannedCost(ctx);
                ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)this._ctx);
                CompanyOrgUnitInfo company = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this._companyId));
                CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this._ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
                int amtPrecision = currency.getPrecision();
                AuxAllocator.writeCostToBillByPlannedCost((Context)ctx, (String)this._companyId, (String)this._periodId);
                AuxAllocator.syncBillToAllocResult((String)this._tblAuxAllocResult, (int)amtPrecision, (String)this._companyId, (String)this._periodId, (Context)this._ctx);
                return;
            }
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"22_AuxFeeCalc", (Locale)ctx.getLocale()));
            this.solveLinearEquationsForUnitCost(this._ctx);
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"23_AuxFeeCalc", (Locale)ctx.getLocale()));
            this.writebackUnitCostToBill();
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"24_AuxFeeCalc", (Locale)ctx.getLocale()));
            this.adjustDiff_Bill();
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"25_AuxFeeCalc", (Locale)ctx.getLocale()));
            this.adjustDiff_AllocResult();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"26_AuxFeeCalc", (Locale)ctx.getLocale()));
        }
    }

    private void processNoEquation() {
    }

    private void buildLinearEquationsTables() throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append('\n').append(" INSERT INTO ").append(this._tblLinearEquations).append('\n').append("  (FID,FCompanyID,FCalculatePeriodID,FCostCenterID,FCostObjectID,FCostItemID) ").append('\n').append(" SELECT newbosid('978626EF'),aux.FCompanyID,FCalculatePeriodID,\t\t\t\t\t\t").append('\n').append(" \t\t BL.FCostCenterID,CO.FID,FCostItemID \t\t\t\t\t\t\t\t\t\t\t").append('\n').append(" FROM ").append(this._tblAuxAllocResult).append(" aux                                      ").append('\n').append(" INNER JOIN T_NCM_InnerOverheadBill BL on BL.FID = aux.FSourceBillID\t\t\t        ").append('\n').append(" INNER JOIN T_ORG_CostCenter CC ON CC.FID = BL.FCostCenterID and CC.FCostCenterType =1 ").append('\n').append(" inner JOIN T_bd_CostObjectEntry coe ON coe.FRelatedID = aux.FAuxOverheadID            ").append('\n').append(" inner JOIN T_bd_CostObject Co ON CO.FID = coe.fparentid and co.FCompanyID = '" + this._companyId + "' ").append('\n').append(" WHERE aux.FCompanyID = ? AND FCalculatePeriodID = ? and Co.FRelatedType = 3           ").append('\n').append(" group by aux.FCompanyID,FCalculatePeriodID,BL.FCostCenterID,CO.FID,FCostItemID    \t").append('\n').append(" order by aux.FCompanyID,FCalculatePeriodID,BL.FCostCenterID,CO.FID\t;\t\t\t\t").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sql.toString(), (Object[])new String[]{this._companyId, this._periodId});
    }

    private void collectAllocatingAuxFee() throws EASBizException, BOSException, SQLException {
        String tblMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_MatAllocResult");
        String tblOtherAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_OtherAllocResult");
        StringBuffer sql = new StringBuffer();
        sql.append('\n').append(" UPDATE  ").append(this._tblLinearEquations).append(" AS equations SET FCollectAmount = (                                      ").append('\n').append(" \tSELECT Isnull(Sum(A.FAmount),0)                                                                                  ").append('\n').append(" \tFROM (                                                                                                      \t ").append('\n').append(" \t\t\t\tSELECT rst.FCompanyID,rst.FCalculatePeriodID,rst.FCostCenterID,rst.FCostObjectID,sum(FAmount) FAmount ").append('\n').append(" \t\t\t\tFROM {0} rst                                                                          ").append('\n').append(" \t\t\t\tINNER JOIN T_BD_CostObject co on co.FID = rst.FCostObjectID AND co.FRelatedType = 3  ").append('\n').append(" \t\t\t\tWHERE rst.FCompanyID =? AND rst.FCalculatePeriodID =?                                                 ").append('\n').append(" \t\t\t\tGROUP BY rst.FCompanyID,rst.FCalculatePeriodID,rst.FCostCenterID,rst.FCostObjectID                    ").append('\n').append(" \t\t\t\tUnion All                                                                                             ").append('\n').append(" \t\t\t\tSELECT rst.FCompanyID,rst.FCalculatePeriodID,rst.FCostCenterID,rst.FCostObjectID,sum(FAmount) FAmount ").append('\n').append(" \t\t\t\tFROM {1} rst                                                                            ").append('\n').append(" \t\t\t\tINNER JOIN T_BD_CostObject co on co.FID = rst.FCostObjectID AND co.FRelatedType = 3   ").append('\n').append(" \t\t\t\tWHERE rst.FCompanyID =? AND rst.FCalculatePeriodID =?                                                 ").append('\n').append(" \t\t\t\tGROUP BY rst.FCompanyID,rst.FCalculatePeriodID,rst.FCostCenterID,rst.FCostObjectID                    ").append('\n').append(" \t\t\t ) AS A                                                                                                   ").append('\n').append(" \tWHERE equations.FCompanyID = A.FCompanyID AND equations.FCalculatePeriodID = A.FCalculatePeriodID                     \t  ").append('\n').append(" \t\t  AND equations.FCostObjectID = A.FCostObjectID                               ").append('\n').append(" \tGROUP BY A.FCompanyID,A.FCalculatePeriodID,A.FCostObjectID                                        ").append('\n').append("  )\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  ").append('\n').append(" ; ").append('\n');
        String stmt = MessageFormat.format(sql.toString(), tblMatAllocResult, tblOtherAllocResult);
        NCMDbUtil.execute((Context)this._ctx, (String)stmt, (Object[])new String[]{this._companyId, this._periodId, this._companyId, this._periodId});
        sql.delete(0, sql.length());
        sql.append('\n').append(" UPDATE  ").append(this._tblLinearEquations).append(" AS equations SET FTotalQty = ( ").append(" \tSELECT SUM(entry.FQty) FQty   ").append('\n').append(" \tFROM T_NCM_InnerOverheadBillEntry entry  ").append('\n').append(" \tinner JOIN T_bd_CostObjectEntry coe ON coe.FRelatedID = ENTRY.FAuxOverheadID    ").append('\n').append(" \tINNER JOIN T_BD_CostObject CO on CO.FID = coe.fparentid  ").append('\n').append(" \tINNER JOIN T_NCM_InnerOverheadBill parent on parent.FID = entry.FParentID  ").append('\n').append(" \tWHERE parent.FBillStatus = 4 AND parent.FCompanyOrg = ? ").append('\n').append(" \t  AND parent.FCalculatePeriod = ? and co.FRelatedType = 3 ").append('\n').append(" \t  AND equations.FCompanyID = parent.FCompanyOrg AND equations.FCalculatePeriodID = parent.FCalculatePeriod ").append('\n').append("     and equations.FCostCenterID = parent.FCostCenterID and equations.FCostObjectID = CO.FID ").append("   GROUP BY parent.FCompanyOrg ,parent.FCalculatePeriod ,ENTRY.FAuxOverheadID  ").append('\n').append(" ) ; ").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sql.toString(), (Object[])new String[]{this._companyId, this._periodId});
        sql.delete(0, sql.length());
    }

    private void buildAugmentedMatrixTables() throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append('\n').append("INSERT INTO ").append(this._tblAugmentedMatrix).append("(FParentID,FUnkownNumber)").append('\n').append("SELECT equations.FID,AUX.FAuxOverheadID ").append('\n').append("  FROM ").append(this._tblLinearEquations).append(" equations ").append('\n').append(" CROSS JOIN ( ").append('\n').append("     select distinct etr.FAuxOverheadID ").append('\n').append("       from ").append(this._tblAuxAllocResult).append(" RS ").append('\n').append("      INNER JOIN T_NCM_InnerOverheadBillEntry etr on etr.FID = RS.FSourceBillEntryID ").append('\n').append("      INNER JOIN T_bd_CostObjectEntry coe ON coe.FRelatedID = RS.FAuxOverheadID   ").append('\n').append("      INNER JOIN T_bd_CostObject co ON co.FID = coe.fparentid\t  ").append('\n').append("      WHERE RS.FCompanyID = ''{0}'' AND FCalculatePeriodID = ''{1}'' and co.FRelatedType = 3 ) AUX ").append('\n').append(" ORDER BY equations.FCompanyID,equations.FCalculatePeriodID,equations.FCostCenterID,equations.FcostObjectID,AUX.FAuxOverheadID ; ").append('\n');
        sql.append('\n').append(" UPDATE  ").append(this._tblAugmentedMatrix).append(" AS MRX SET FConstB = ( ").append(" \tSELECT FCollectAmount  ").append('\n').append(" \tFROM ").append(this._tblLinearEquations).append('\n').append(" \tequations WHERE equations.FCompanyID = ''{2}'' ").append('\n').append(" \t  AND equations.FCalculatePeriodID = ''{3}'' ").append('\n').append(" \t  AND MRX.FParentID = equations.FID  ").append('\n').append(" ) ; ").append('\n');
        sql.append('\n').append(" UPDATE  ").append(this._tblAugmentedMatrix).append(" AS MRX SET FOutputQty = ( ").append(" SELECT FTotalQty  ").append('\n').append(" \tFROM   ").append(this._tblLinearEquations).append('\n').append(" equations ").append("  INNER JOIN T_BD_CostObject CO on CO.FID = equations.FCostObjectID ").append("  INNER JOIN T_bd_CostObjectEntry coe ON coe.FParentID = co.FID ").append('\n').append(" \tWHERE equations.FCompanyID = ''{4}'' ").append('\n').append(" \t  AND equations.FCalculatePeriodID = ''{5}'' ").append('\n').append(" \t  AND coe.FRelatedID = MRX.FUnkownNumber ").append('\n').append(" ) ; ").append('\n');
        sql.append('\n').append(" UPDATE  ").append(this._tblAugmentedMatrix).append(" AS MRX SET FCoefficient = ( ").append(" \tSELECT SUM(RS.FTotalQty) FQty   ").append('\n').append(" \tFROM T_NCM_InnerOverheadBillEntry entry  ").append('\n').append(" \tINNER JOIN ").append(this._tblAuxAllocResult).append("  RS on RS.FSourceBillEntryID = entry.FID  ").append('\n').append(" \tINNER JOIN ").append(this._tblLinearEquations).append(" equations ").append('\n').append(" \t\tON equations.FCompanyID = RS.FCompanyID AND equations.FCalculatePeriodID = RS.FCalculatePeriodID ").append('\n').append(" \t\tAND equations.FCostCenterID = RS.FCostCenterID AND equations.FcostObjectID = RS.FcostObjectID ").append('\n').append(" \tWHERE RS.FCompanyID = ''{6}'' ").append('\n').append(" \t  AND RS.FCalculatePeriodID = ''{7}'' ").append('\n').append(" \t  AND MRX.FParentID = equations.FID AND  MRX.FUnkownNumber = ENTRY.FAuxOverheadID ").append('\n').append("     GROUP BY RS.FCompanyID ,RS.FCalculatePeriodID ,RS.FCostCenterID ,RS.FcostObjectID,ENTRY.FAuxOverheadID ").append('\n').append(" ) ; ").append('\n');
        String dml = MessageFormat.format(sql.toString(), this._companyId, this._periodId, this._companyId, this._periodId, this._companyId, this._periodId, this._companyId, this._periodId);
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)dml);
    }

    private void solveLinearEquationsForPlannedCost(Context ctx) throws BOSException, SQLException, EASBizException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("update " + this._tblAugmentedMatrix + " as e set (FSolution) = ( ");
        ksql.append("    select \n");
        ksql.append("        ac.FStdPrice \n");
        ksql.append("    from T_NCM_AUXOverheadCompanyInfo ac \n");
        ksql.append("    where ac.FCompanyID = '" + this._companyId + "' \n");
        ksql.append("    and ac.FAUXOverheadID = e.FUnkownNumber \n");
        ksql.append(") \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from " + this._tblLinearEquations + " b \n");
        ksql.append("    where b.FID = e.FParentID \n");
        ksql.append("    and b.FCompanyID = '" + this._companyId + "' \n");
        ksql.append("    and b.FCalculatePeriodID = '" + this._periodId + "' \n");
        ksql.append(") \n");
        ksql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("select \n");
        ksql.append(" m.FParentID, \n");
        ksql.append(" m.FUnkownNumber FAuxOverheadID, \n");
        ksql.append(" m.FOutputQty, \n");
        ksql.append(" m.FCoefficient, \n");
        ksql.append(" m.FConstB, \n");
        ksql.append(" m.FSolution, \n");
        ksql.append(" a.FName_" + this._ctx.getLocale().getLanguage() + " FAuxOverheadName \n");
        ksql.append("from " + this._tblAugmentedMatrix + " m \n");
        ksql.append("join T_NCM_AuxOverhead a \n");
        ksql.append("    on a.FID = m.FUnkownNumber \n");
        ksql.append("where exists ( \n");
        ksql.append("    select 1 from " + this._tblLinearEquations + " b \n");
        ksql.append("    where b.FID = m.FParentID \n");
        ksql.append("    and b.FCompanyID = '" + this._companyId + "' \n");
        ksql.append("    and b.FCalculatePeriodID = '" + this._periodId + "' \n");
        ksql.append(") \n");
        ksql.append("order by m.FParentID \n");
        Connection conn = null;
        PreparedStatement pstmt = null;
        IRowSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            rs = NCMDbUtil.executeQueryNoTx((Context)this._ctx, (String)ksql.toString());
            HashMap<String, ArrayList<Matrix>> equations = new HashMap<String, ArrayList<Matrix>>();
            while (rs.next()) {
                String parentID = rs.getString("FParentID");
                String auxOverheadID = rs.getString("FAuxOverheadID");
                String auxOverheadName = rs.getString("FAuxOverheadName");
                BigDecimal outputQty = UIRuleUtil.getBigDecimal((Object)rs.getObject("FOutputQty"));
                BigDecimal coefficient = UIRuleUtil.getBigDecimal((Object)rs.getObject("FCoefficient"));
                BigDecimal constB = UIRuleUtil.getBigDecimal((Object)rs.getObject("FConstB"));
                BigDecimal solution = UIRuleUtil.getBigDecimal((Object)rs.getObject("FSolution"));
                Matrix matrix = new Matrix();
                matrix.auxOverheadName = auxOverheadName;
                matrix.outputQty = outputQty;
                matrix.coefficient = coefficient;
                matrix.constB = constB;
                matrix.solution = solution;
                ArrayList<Matrix> equation = (ArrayList<Matrix>)equations.get(parentID);
                if (equation == null) {
                    equation = new ArrayList<Matrix>();
                    equations.put(parentID, equation);
                }
                equation.add(matrix);
            }
            ksql.setLength(0);
            ksql.append("update " + this._tblLinearEquations + " set \n");
            ksql.append("FAlgebraAmount = ?, \n");
            ksql.append("FTotalAmount = ?, \n");
            ksql.append("FUnitPrice = ?, \n");
            ksql.append("FEquationString = ? \n");
            ksql.append("where FID = ? \n");
            pstmt = conn.prepareStatement(ksql.toString());
            for (Map.Entry me : equations.entrySet()) {
                String parentID = (String)me.getKey();
                List equation = (List)me.getValue();
                BigDecimal allocatedAmt = SysConstant.BIGZERO;
                BigDecimal unitPrice = SysConstant.BIGZERO;
                BigDecimal constB = SysConstant.BIGZERO;
                String outEquation = "";
                String inEquation = "";
                for (int i = 0; i < equation.size(); ++i) {
                    Matrix matrix = (Matrix)equation.get(i);
                    if (matrix.coefficient != null && matrix.coefficient.compareTo(SysConstant.BIGZERO) != 0) {
                        if (matrix.solution != null) {
                            allocatedAmt = allocatedAmt.add(matrix.coefficient.multiply(matrix.solution));
                        }
                        if (inEquation.length() == 0) {
                            inEquation = inEquation + matrix.constB;
                        }
                        inEquation = inEquation + " + [" + matrix.coefficient + "][" + matrix.auxOverheadName + "]";
                        continue;
                    }
                    unitPrice = matrix.solution;
                    constB = matrix.constB;
                    outEquation = "[" + matrix.outputQty + "][" + matrix.auxOverheadName + "]";
                }
                pstmt.setBigDecimal(1, allocatedAmt);
                pstmt.setBigDecimal(2, constB.add(allocatedAmt));
                pstmt.setBigDecimal(3, unitPrice);
                pstmt.setString(4, outEquation + " ?= " + inEquation);
                pstmt.setString(5, parentID);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("ERROR SQL in NCM AuxFeeCalc is: {\n " + ksql.toString() + " \n}"), (Throwable)e);
                throw new SQLDataException("Sql exception :{\n " + ksql.toString() + " \n}", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List solveLinearEquationsForUnitCost(Context ctx) throws BOSException, SQLException, EASBizException {
        ArrayList<String> arrayList;
        IRowSet rs;
        block12: {
            StringBuffer sql = new StringBuffer();
            sql.append('\n').append(" SELECT mrx.FParentID,mrx.FUnkownNumber,mrx.FOutputQty,mrx.FCoefficient,mrx.FConstB ").append('\n').append("\t\t\t,Auxc.FPricePrecision,ax.FName_").append(this._ctx.getLocale().getLanguage()).append('\n').append(" FROM ").append('\n').append(this._tblAugmentedMatrix).append("  mrx INNER JOIN\t              \t\t\t\t          ").append('\n').append(this._tblLinearEquations).append("  equations on equations.FID = mrx.FParentID                         ").append('\n').append(" LEFT JOIN T_NCM_AUXOverheadCompanyInfo Auxc ON \t\t\t\t\t\t\t\t\t  ").append('\n').append("\t\tAuxc.FAuxOverheadID = mrx.FUnkownNumber AND Auxc.FCompanyID = equations.FCompanyID  ").append('\n').append(" inner join t_bd_costobject co on co.fid = equations.fcostobjectid                          ").append('\n').append(" LEFT join t_ncm_auxoverhead ao on ao.fid = co.FRelatedID                           ").append('\n').append(" inner join t_ncm_auxoverhead ax on ax.fid = mrx.FUnkownNumber                       ").append('\n').append(" WHERE equations.FCompanyID =? AND equations.FCalculatePeriodID =?\t\t\t\t\t\t\t      ").append('\n').append(" order by  equations.FCompanyID,equations.FCalculatePeriodID,ao.fnumber,ax.FNumber\t\t\t      ").append('\n').append(" ; ").append('\n');
            rs = null;
            rs = NCMDbUtil.executeQueryNoTx((Context)this._ctx, (String)sql.toString(), (Object[])new String[]{this._companyId, this._periodId});
            if (rs.size() != 0) break block12;
            List list = Collections.EMPTY_LIST;
            SQLUtils.cleanup((ResultSet)rs);
            return list;
        }
        try {
            LinkedHashMap matrix = new LinkedHashMap(rs.size());
            LinkedHashMap<String, String> unkownID_Names = new LinkedHashMap<String, String>();
            ArrayList<String> unkownNumbers = new ArrayList<String>();
            ArrayList<BigDecimal> unkownNumbersPrecission = new ArrayList<BigDecimal>();
            ArrayList<BigDecimal> collectAmts = new ArrayList<BigDecimal>();
            int equationCount = -1;
            while (rs.next()) {
                String parentID = rs.getString(1);
                String unkownNumber = rs.getString(2);
                BigDecimal outputQty = UIRuleUtil.getBigDecimal((Object)rs.getObject(3));
                BigDecimal coefficient = UIRuleUtil.getBigDecimal((Object)rs.getObject(4));
                BigDecimal collectAmt = UIRuleUtil.getBigDecimal((Object)rs.getObject(5));
                BigDecimal pricePrecision = UIRuleUtil.getBigDecimal((Object)rs.getObject(6));
                if (!unkownNumbers.contains(unkownNumber)) {
                    unkownID_Names.put(unkownNumber, rs.getString(7));
                    unkownNumbers.add(unkownNumber);
                    unkownNumbersPrecission.add(pricePrecision);
                }
                List<Object> equation = null;
                boolean isOldEquation = matrix.containsKey(parentID);
                if (isOldEquation) {
                    equation = (List)matrix.get(parentID);
                } else {
                    equation = new ArrayList();
                    matrix.put(parentID, equation);
                    ++equationCount;
                    collectAmts.add(collectAmt);
                }
                if (equationCount == unkownNumbers.indexOf(unkownNumber)) {
                    equation.add(outputQty.toString());
                    continue;
                }
                equation.add(coefficient.negate());
            }
            BigDecimal[][] coefficients = new BigDecimal[equationCount + 1][unkownNumbers.size()];
            BigDecimal[] constB = collectAmts.toArray(new BigDecimal[0]);
            ArrayList<String> equationStrings = new ArrayList<String>(unkownNumbers.size());
            Iterator it = matrix.entrySet().iterator();
            int equationNumber = -1;
            StringBuffer equationString = new StringBuffer();
            while (it.hasNext()) {
                int i;
                ++equationNumber;
                Map.Entry entry = it.next();
                List equation = (List)entry.getValue();
                int last = equation.size();
                for (i = 0; i < last; ++i) {
                    coefficients[equationNumber][i] = UIRuleUtil.getBigDecimal(equation.get(i));
                }
                last = equation.size();
                for (i = 0; i < last; ++i) {
                    if (!(equation.get(i) instanceof String)) continue;
                    equationString.append("[").append(UIRuleUtil.getBigDecimal(equation.get(i))).append("][").append(unkownID_Names.get(unkownNumbers.get(i))).append("]");
                    break;
                }
                equationString.append(" = ").append(constB[equationNumber]);
                last = equation.size();
                for (i = 0; i < last; ++i) {
                    if (!(equation.get(i) instanceof BigDecimal)) continue;
                    equationString.append(" + [").append(UIRuleUtil.getBigDecimal(equation.get(i)).negate()).append("][").append(unkownID_Names.get(unkownNumbers.get(i))).append("]");
                }
                equationStrings.add(equationString.toString());
                equationString.delete(0, equationString.length());
            }
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"27_AuxFeeCalc", (Locale)ctx.getLocale()));
            this.calcConsumedAmount(this._ctx, coefficients, constB, matrix, unkownNumbers, unkownNumbersPrecission, equationStrings);
            arrayList = unkownNumbers;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    private void calcConsumedAmount(Context ctx, BigDecimal[][] coefficients, BigDecimal[] constB, Map matrix, List unkownNumbers, List unkownNumbersPrecission, List equationStrings) throws BOSException {
        int amtPrecision = NCMUtils.getCurrencyPrecision((Context)ctx, (String)this._companyId);
        BigDecimal[][] coef = new BigDecimal[coefficients.length][coefficients[0].length];
        BigDecimal[] b = new BigDecimal[constB.length];
        for (int i = 0; i < coefficients.length; ++i) {
            System.arraycopy(coefficients[i], 0, coef[i], 0, coefficients[0].length);
        }
        System.arraycopy(constB, 0, b, 0, constB.length);
        int size = unkownNumbersPrecission.size();
        int[] precisions = new int[size];
        for (int j = 0; j < size; ++j) {
            precisions[j] = Integer.parseInt(unkownNumbersPrecission.get(j).toString());
        }
        logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"28_AuxFeeCalc", (Locale)ctx.getLocale()));
        BigDecimal[] solutions = GaussJordan.solve((BigDecimal[][])coef, (BigDecimal[])b, (int[])precisions, (Context)ctx);
        logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"29_AuxFeeCalc", (Locale)ctx.getLocale()));
        ArrayList<BigDecimal> allocatedAmts = new ArrayList<BigDecimal>(constB.length);
        ArrayList<BigDecimal> totalCostAmts = new ArrayList<BigDecimal>(constB.length);
        ArrayList<BigDecimal> actualPrices = new ArrayList<BigDecimal>(constB.length);
        for (int i = 0; i < coefficients.length; ++i) {
            BigDecimal allocatedAmt = SysConstant.BIGZERO;
            BigDecimal totalCostAmt = SysConstant.BIGZERO;
            BigDecimal outputQty = SysConstant.BIGZERO;
            for (int j = 0; j < solutions.length; ++j) {
                if (i == j) {
                    outputQty = coefficients[i][j];
                    continue;
                }
                allocatedAmt = allocatedAmt.add(coefficients[i][j].abs().multiply(solutions[j]));
            }
            allocatedAmts.add(allocatedAmt);
            totalCostAmt = constB[i].add(allocatedAmt);
            totalCostAmts.add(totalCostAmt);
            actualPrices.add(solutions[i]);
        }
        String[] parentIDs = matrix.keySet().toArray(new String[0]);
        if (constB.length > 0) {
            StringBuffer ksql = new StringBuffer();
            ksql.append("update " + this._tblLinearEquations + " set \n");
            ksql.append("FAlgebraAmount = round(?," + amtPrecision + "), \n");
            ksql.append("FTotalAmount = round(?," + amtPrecision + "), \n");
            ksql.append("FUnitPrice = ?, \n");
            ksql.append("FEquationString = ? \n");
            ksql.append("where FID = ? \n");
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pstmt = conn.prepareStatement(ksql.toString());
                for (int equationNum = 0; equationNum < constB.length; ++equationNum) {
                    int i = 0;
                    pstmt.setBigDecimal(++i, this.buildBigDecimal(allocatedAmts.get(equationNum), unkownNumbersPrecission.get(equationNum)));
                    pstmt.setBigDecimal(++i, this.buildBigDecimal(totalCostAmts.get(equationNum), unkownNumbersPrecission.get(equationNum)));
                    pstmt.setBigDecimal(++i, this.buildBigDecimal(actualPrices.get(equationNum), unkownNumbersPrecission.get(equationNum)));
                    pstmt.setString(++i, (String)equationStrings.get(equationNum));
                    pstmt.setString(++i, parentIDs[equationNum]);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)("ERROR SQL in NCM AuxFeeCalc is: {\n " + ksql.toString() + " \n}"), (Throwable)e);
                    throw new SQLDataException("Sql exception :{\n " + ksql.toString() + " \n}", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"30_AuxFeeCalc", (Locale)ctx.getLocale()));
        this.writeSolutions(unkownNumbers, unkownNumbersPrecission, solutions);
    }

    private BigDecimal buildBigDecimal(Object num, Object precission) {
        return UIRuleUtil.getBigDecimal((Object)num).setScale(UIRuleUtil.getIntValue((Object)precission), 4);
    }

    public static StringBuffer roundNum(Object num, Object precission) {
        return new StringBuffer().append(UIRuleUtil.getBigDecimal((Object)num).setScale(UIRuleUtil.getIntValue((Object)precission), 4));
    }

    private void writeSolutions(List unkownNumbers, List unkownNumbersPrecission, BigDecimal[] solutions) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append('\n').append(" UPDATE  ").append(this._tblAugmentedMatrix).append('\n').append("  AS MRX SET FSolution = ( \t\t\t\t\t\t\t\t\t\t   ").append('\n').append(" \tSELECT CASE MRX.FUnkownNumber \t\t\t\t\t\t\t\t\t   ").append('\n');
        Object[] params = new Object[unkownNumbers.size() * 2 + 2];
        int k = 0;
        for (int equationNum = 0; equationNum < unkownNumbers.size(); ++equationNum) {
            params[k++] = unkownNumbers.get(equationNum).toString();
            params[k++] = AuxFeeCalc.roundNum(solutions[equationNum], unkownNumbersPrecission.get(equationNum)).toString();
            sb.append("    WHEN ? ").append(" \t   THEN ? ").append('\n');
        }
        sb.append(" \t   ELSE MRX.FSolution  END \t\t\t\t\t\t\t\t   ").append('\n').append(" \tFROM   ").append(this._tblLinearEquations).append(" RS \t\t\t\t\t\t\t\t\t   ").append('\n').append("   WHERE  RS.FCompanyID = ? AND RS.FCalculatePeriodID = ? ").append('\n').append("     \tAND RS.FID = MRX.FParentID  ) ;\t\t\t\t\t\t\t\t   ").append('\n');
        params[params.length - 2] = this._companyId;
        params[params.length - 1] = this._periodId;
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Object[])params);
    }

    private void writebackUnitCostToBill() throws BOSException, EASBizException {
        StringBuffer updates = new StringBuffer();
        updates.append('\n').append(" UPDATE T_NCM_InnerOverheadBillEntry AS Etr SET (FActualPrice) = ").append('\n').append(" (SELECT A.FSolution FROM ( ").append('\n').append("   select distinct entry.FID,mrx.FSolution from ").append('\n').append("\tT_NCM_InnerOverheadBillEntry As entry ").append('\n').append("\tINNER JOIN T_NCM_InnerOverheadBill As parent on parent.FID = entry.FParentID ").append('\n').append("   INNER JOIN ").append(this._tblLinearEquations).append(" equations on equations.FCompanyID = parent.FCompanyOrg ").append('\n').append("  \t and equations.FCalculatePeriodID = parent.FCalculatePeriod  ").append('\n').append("   INNER JOIN ").append(this._tblAugmentedMatrix).append(" mrx on mrx.FParentID =equations.FID AND mrx.FUnkownNumber = entry.FAuxOverheadID ").append('\n').append("   where parent.FBillStatus = 4 and equations.FCompanyID =''{0}'' AND equations.FCalculatePeriodID =''{1}'' ").append('\n').append("\t) AS A\t").append('\n').append("  WHERE A.FID = Etr.FID      ").append('\n').append(" ) ; ").append('\n');
        ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)this._ctx);
        CompanyOrgUnitInfo company = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this._companyId));
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this._ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
        int amtPrecision = currency.getPrecision();
        updates.append(" UPDATE T_NCM_InnerOverheadBillEntry AS Etr SET (FActualAmount) = ").append('\n').append(" (SELECT Round(entry.FQty * entry.FActualPrice,").append(amtPrecision).append(")").append('\n').append("  FROM   T_NCM_InnerOverheadBillEntry As entry ").append('\n').append("\tINNER JOIN T_NCM_InnerOverheadBill parent on parent.FID = entry.FParentID ").append('\n').append(" WHERE parent.FBillStatus = 4 and parent.FCompanyOrg =''{2}'' AND parent.FCalculatePeriod =''{3}''\tAND entry.FID = Etr.FID   ").append('\n').append(" ) ; ").append('\n');
        String update = MessageFormat.format(updates.toString(), this._companyId, this._periodId, this._companyId, this._periodId);
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)update);
        AuxAllocator.syncBillToAllocResult((String)this._tblAuxAllocResult, (int)amtPrecision, (String)this._companyId, (String)this._periodId, (Context)this._ctx);
    }

    public void adjustDiff(String select, String update) throws BOSException {
        IRowSet rs = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)select);
            if (rs.size() == 0) {
                return;
            }
            conn = EJBFactory.getConnection((Context)this._ctx);
            pstmt = conn.prepareStatement(update);
            while (rs.next()) {
                pstmt.setDouble(1, rs.getDouble("FAmountDiff"));
                pstmt.setString(2, this._companyId);
                pstmt.setString(3, this._periodId);
                pstmt.setString(4, rs.getString("FCostCenterID"));
                pstmt.setString(5, rs.getString("FCostObjectID"));
                pstmt.setString(6, this._companyId);
                pstmt.setString(7, this._periodId);
                pstmt.setString(8, rs.getString("FCostCenterID"));
                pstmt.setString(9, rs.getString("FCostObjectID"));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, pstmt, conn);
        }
    }

    private void adjustDiff_Bill() throws BOSException {
        StringBuffer select = new StringBuffer();
        select.append("Select D.FCostCenterID, D.FCostObjectID, (S.FSrcSumAmount - D.FDestSumAmount )As FAmountDiff ").append('\n').append(" FROM (").append('\n').append(" \tSELECT bill.FCostCenterID, OBJ.FID FCostObjectID,SUM(entry.FActualAmount) FDestSumAmount ").append('\n').append(" \tFROM T_NCM_InnerOverheadBill bill ").append('\n').append(" \tLEFT JOIN T_NCM_InnerOverheadBillEntry entry ON entry.FParentid=bill.FID ").append('\n').append(" \tLEFT JOIN T_BD_CostObject AS OBJ ON OBJ.FRelatedID = entry.FAuxOverheadID ").append('\n').append(" \tWHERE bill.FBillStatus=4 AND bill.FCompanyOrg = ''{0}'' ").append('\n').append(" \t\tAND bill.FCalculatePeriod = ''{1}'' ").append('\n').append(" \tGROUP BY bill.FCostCenterID, OBJ.FID ").append('\n').append(" ) D ").append('\n').append(" LEFT JOIN (").append('\n').append(" \tSELECT FCostCenterID,FCostObjectID, SUM(FTotalAmount) As FSrcSumAmount ").append('\n').append(" \tFROM ").append(this._tblLinearEquations).append('\n').append(" \tWHERE FCompanyID= ''{2}'' AND FCalculatePeriodID= ''{3}'' ").append('\n').append(" \tGROUP BY FCostCenterID,FCostObjectID ").append('\n').append(" ) S ON D.FCostCenterID=S.FCostCenterid AND D.FCostObjectID=S.FCostObjectID ").append('\n').append(" Where  D.FDestSumAmount <> S.FSrcSumAmount").append('\n');
        StringBuffer derivedA = new StringBuffer();
        derivedA.append("  (Select top 1 entry.FID ").append('\n').append(" \tFROM T_NCM_InnerOverheadBill bill ").append('\n').append(" \tLEFT JOIN T_NCM_InnerOverheadBillEntry entry ON entry.FParentid=bill.FID ").append('\n').append(" \tLEFT JOIN T_BD_CostObject AS OBJ ON OBJ.FRelatedID = entry.FAuxOverheadID ").append('\n').append(" \tLEFT JOIN T_ORG_CostCenter CC ON CC.FID = entry.FConsumeCostCenterID ").append('\n').append(" \tWHERE bill.FBillStatus=4 AND bill.FCompanyOrg = ? AND bill.FCalculatePeriod = ? ").append('\n').append("        AND bill.FCostCenterID =? AND OBJ.FID =? AND CC.FCostCenterType <> 1 ").append('\n').append("\tORDER BY entry.FActualAmount DESC ").append('\n').append("  ) AS A ").append('\n');
        StringBuffer derivedB = new StringBuffer();
        derivedB.append("  (Select top 1 entry.FID ").append('\n').append(" \tFROM T_NCM_InnerOverheadBill bill ").append('\n').append(" \tLEFT JOIN T_NCM_InnerOverheadBillEntry entry ON entry.FParentid=bill.FID ").append('\n').append(" \tLEFT JOIN T_BD_CostObject AS OBJ ON OBJ.FRelatedID = entry.FAuxOverheadID ").append('\n').append(" \tLEFT JOIN T_ORG_CostCenter CC ON CC.FID = entry.FConsumeCostCenterID ").append('\n').append(" \tWHERE bill.FBillStatus=4 AND bill.FCompanyOrg = ? AND bill.FCalculatePeriod = ? ").append('\n').append("        AND bill.FCostCenterID =? AND OBJ.FID =? AND CC.FCostCenterType = 1 ").append('\n').append("\tORDER BY entry.FActualAmount DESC ").append('\n').append("  ) AS B ").append('\n');
        StringBuffer update = new StringBuffer();
        update.append("UPDATE T_NCM_InnerOverheadBillEntry SET FActualAmount =(FActualAmount+?) ").append('\n').append("WHERE FID =( ").append('\n').append(" SELECT ISNULL(A,B) ").append('\n').append(" FROM ( select  ").append(derivedA).append(" , ").append(derivedB).append(") AS C  ) ").append('\n');
        String select2 = MessageFormat.format(select.toString(), this._companyId, this._periodId, this._companyId, this._periodId);
        this.adjustDiff(select2, update.toString());
    }

    private void adjustDiff_AllocResult() throws BOSException {
        StringBuffer select = new StringBuffer();
        select.append("Select D.FEntryID, (S.FSrcSumAmount - D.FDestSumAmount ) As FAmountDiff ").append('\n').append(" FROM (").append('\n').append(" \tSELECT AAR.FSourceBillEntryID FEntryID, SUM(AAR.FAmount) FDestSumAmount ").append('\n').append(" \tFROM ").append(this._tblAuxAllocResult).append(" as AAR ").append('\n').append(" \tWHERE AAR.FCompanyID= ''{0}'' AND AAR.FCalculatePeriodID= ''{1}'' ").append('\n').append(" \tGROUP by AAR.FSourceBillEntryID ").append('\n').append(" ) D ").append('\n').append(" LEFT JOIN (").append('\n').append(" \tSELECT entry.FID FEntryID, SUM(entry.FActualAmount) FSrcSumAmount ").append('\n').append(" \tFROM T_NCM_InnerOverheadBill bill ").append('\n').append(" \tLEFT JOIN T_NCM_InnerOverheadBillEntry entry ON entry.FParentid=bill.FID ").append('\n').append(" \tLEFT JOIN T_ORG_CostCenter cc ON cc.FID = entry.FConsumeCostCenterID ").append('\n').append(" \tWHERE bill.FBillStatus=4 AND bill.FCompanyOrg = ''{2}'' ").append('\n').append(" \t\tAND bill.FCalculatePeriod = ''{3}'' ").append('\n').append(" \t\tAND FCostCenterType in (0, 1) ").append('\n').append(" \tGROUP BY entry.FID ").append('\n').append(" ) S ON D.FEntryID=S.FEntryID ").append('\n').append(" Where  D.FDestSumAmount <> S.FSrcSumAmount").append('\n');
        StringBuffer derivedA = new StringBuffer();
        derivedA.append("  (Select top 1 AAR.FID ").append('\n').append(" \tFROM ").append(this._tblAuxAllocResult).append(" as AAR ").append('\n').append(" \tLEFT JOIN T_ORG_CostCenter CC ON CC.FID = AAR.FCostCenterID ").append('\n').append(" \tWHERE AAR.FCompanyID= ? AND AAR.FCalculatePeriodID= ? ").append('\n').append("        and AAR.FSourceBillEntryID = ? AND CC.FCostCenterType <> 1 ").append('\n').append("\tORDER BY AAR.FAmount DESC ").append('\n').append("  ) AS A ").append('\n');
        StringBuffer derivedB = new StringBuffer();
        derivedB.append("  (Select top 1 AAR.FID ").append('\n').append(" \tFROM ").append(this._tblAuxAllocResult).append(" as AAR ").append('\n').append(" \tLEFT JOIN T_ORG_CostCenter CC ON CC.FID = AAR.FCostCenterID ").append('\n').append(" \tWHERE AAR.FCompanyID= ? AND AAR.FCalculatePeriodID= ? ").append('\n').append("        and AAR.FSourceBillEntryID = ? AND CC.FCostCenterType = 1 ").append('\n').append("\tORDER BY AAR.FAmount DESC ").append('\n').append("  ) AS B ").append('\n');
        StringBuffer update = new StringBuffer();
        update.append("UPDATE ").append(this._tblAuxAllocResult).append(" SET FAmount =(FAmount+?) ").append('\n').append("WHERE FID =( ").append('\n').append(" SELECT ISNULL(A,B) ").append('\n').append(" FROM ( select ").append(derivedA).append(" , ").append(derivedB).append(") AS C ) ").append('\n');
        String select2 = MessageFormat.format(select.toString(), this._companyId, this._periodId, this._companyId, this._periodId);
        IRowSet rs = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)select2);
            if (rs.size() == 0) {
                return;
            }
            conn = EJBFactory.getConnection((Context)this._ctx);
            pstmt = conn.prepareStatement(update.toString());
            while (rs.next()) {
                pstmt.setDouble(1, rs.getDouble("FAmountDiff"));
                pstmt.setString(2, this._companyId);
                pstmt.setString(3, this._periodId);
                pstmt.setString(4, rs.getString("FEntryID"));
                pstmt.setString(5, this._companyId);
                pstmt.setString(6, this._periodId);
                pstmt.setString(7, rs.getString("FEntryID"));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, pstmt, conn);
        }
    }

    static class Matrix {
        String auxOverheadName;
        BigDecimal outputQty;
        BigDecimal coefficient;
        BigDecimal constB;
        BigDecimal solution;

        Matrix() {
        }
    }
}

