/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.EopWipAdjustFactory;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.bill.app.SecondAlloc.SecAllocDispatch;
import com.kingdee.eas.ncm.cal.app.Calc.AllocWIP.AllocWIP;
import com.kingdee.eas.ncm.cal.app.Calc.AllocWIP.BatchAllocByHardcodeIterator;
import com.kingdee.eas.ncm.cal.app.Calc.AuxFeeCalc;
import com.kingdee.eas.ncm.cal.app.Calc.CalcalDispatchEx;
import com.kingdee.eas.ncm.cal.app.Calc.Helper.CalcExceptionLog;
import com.kingdee.eas.ncm.cal.app.Calc.classiCOAlloc.AllocClassiCOImpl;
import com.kingdee.eas.ncm.cal.report.NCMReportHelper;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.AllocStdSetModeByWIPEnum;
import com.kingdee.eas.ncm.common.app.CalcTable;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.task.CostTaskStatusEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.app.CostTaskExecutor;
import com.kingdee.eas.ncm.common.utils.NCMCommonParams;
import com.kingdee.eas.ncm.common.utils.NCMCommonParamsAdapter;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.DevolveCostCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalcDispatch {
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.cal.task.CostCalResource";
    protected static final char CLF = '\n';
    private static Logger logger = Logger.getLogger((String)CalcDispatch.class.getName());
    protected NCMCommonParams _ncmCommonParam;
    protected Map _param = null;
    private boolean isCheckEopWipException = false;
    private boolean isGenEopWipAdjust = false;
    protected Context _ctx;
    protected String _companyId;
    protected String _periodId;
    protected CalcExceptionLog _log;
    protected Connection _globalConnection = null;
    private String jobInstId = null;
    protected CalcTable _calcTable = null;
    private Map costTaskEntryMap = null;

    public CalcDispatch(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("ctx"));
        this._param = param;
        this._ctx = (Context)param.get("ctx");
        this._companyId = (String)param.get("companyId");
        this._periodId = (String)param.get("periodId");
        this.isCheckEopWipException = "true".equals(param.get("isCheckEopWipException"));
        this.isGenEopWipAdjust = this.isCheckEopWipException && "true".equals(param.get("isGenEopWipAdjust"));
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)this._ctx);
        param.put("CU", DefaultCU.getId().toString());
        this.costTaskEntryMap = new HashMap();
    }

    private CostDataCache getCostDataCache() {
        return (CostDataCache)this._param.get("CostDataCache");
    }

    private CostTaskExecutor getCostTaskExecutor() {
        return (CostTaskExecutor)this._param.get("CostTaskExecutor");
    }

    public HashMap doCalc() throws Throwable {
        IObjectPK pk = LogUtil.beginLog((Context)this._ctx, (String)"CalCost", (BOSObjectType)BOSObjectType.create((String)"84876FA9"), null, (String)this.getResource("COST_CAL", this._ctx.getLocale()), (String)this.getResource("COST_CAL", this._ctx.getLocale()), (String)this._companyId);
        this.jobInstId = (String)this._ctx.get((Object)"COST_CAL_JOB_INST_ID");
        CostTaskResultEnum result = CostTaskResultEnum.SUCCESS;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int lowest = CalSeverUtils.getLowestRank(this._ctx, this._companyId, this._periodId);
        this.addRankCostTaskEntries(lowest);
        PeriodInfo periodInfo = this.getPeriodInfo(this._ctx, this._periodId);
        try {
            HashMap<String, String> map;
            CostTaskEntryInfo entry;
            HashMap<String, String> params;
            HashSet<String> busiTblNames;
            try {
                this.updateCostCalEntryRunning(this._ctx, "calcStepInit");
                AllocStdSetModeByWIPEnum theSetMode = NCMUtils.getAllocStdSetModeByWIP((Context)this._ctx, (String)this._companyId);
                this._param.put("SetMode", theSetMode);
                this._globalConnection = EJBFactory.getConnection((Context)this._ctx);
                this._param.put("globalConnection", this._globalConnection);
                this._calcTable = new CalcTable(this._param);
                this._param.put("calcTable", this._calcTable);
                this._log = new CalcExceptionLog(this._param);
                this._param.put("log", this._log);
                this._ncmCommonParam = NCMCommonParamsAdapter.build((Map)this._param);
                this.updateCostCalEntryFinished(this._ctx, "calcStepInit");
            }
            catch (Throwable e) {
                this.updateCostCalEntryFinished(this._ctx, "calcStepInit", CostTaskResultEnum.EXCEPTION);
                throw e;
            }
            try {
                this.updateCostCalEntryRunning(this._ctx, "calcStepClear");
                this.clearPreCalcResult();
                busiTblNames = new HashSet<String>();
                busiTblNames.add("T_NCM_CostCalResult");
                busiTblNames.add("T_NCM_CostCalMatDetailResult");
                busiTblNames.add("T_NCM_CostCalPrdDetailResult");
                NCMDynamicTableManager.clearIndexsOfBusiTbls((Context)this._ctx, (String)this._companyId, busiTblNames);
                this.updateJobStatus(5, "calcStepClear");
                this.updateCostCalEntryFinished(this._ctx, "calcStepClear");
            }
            catch (Throwable e) {
                this.updateCostCalEntryFinished(this._ctx, "calcStepClear", CostTaskResultEnum.EXCEPTION);
                throw e;
            }
            try {
                this.updateCostCalEntryRunning(this._ctx, "calcStepGetData");
                this.getProcessData();
                this.updateJobStatus(10, "calcStepGetData");
                this.updateCostCalEntryFinished(this._ctx, "calcStepGetData");
            }
            catch (Throwable e) {
                this.updateCostCalEntryFinished(this._ctx, "calcStepGetData", CostTaskResultEnum.EXCEPTION);
                throw e;
            }
            try {
                this.updateCostCalEntryRunning(this._ctx, "preCalOut");
                this.preCalcOut();
                this.updateJobStatus(12, "preCalOut");
                this.updateCostCalEntryFinished(this._ctx, "preCalOut");
            }
            catch (Throwable e) {
                this.updateCostCalEntryFinished(this._ctx, "preCalOut", CostTaskResultEnum.EXCEPTION);
                throw e;
            }
            try {
                this.updateCostCalEntryRunning(this._ctx, "calcStepAuxCalc");
                new AuxFeeCalc(this._ncmCommonParam).doCalc(this._ctx);
                this.updateJobStatus(15, "calcStepAuxCalc");
                this.updateCostCalEntryFinished(this._ctx, "calcStepAuxCalc");
            }
            catch (Throwable e) {
                this.updateCostCalEntryFinished(this._ctx, "calcStepAuxCalc", CostTaskResultEnum.EXCEPTION);
                throw e;
            }
            result = this.doRank(periodInfo, lowest);
            try {
                if (result.getValue() <= 3) {
                    this.updateCostCalEntryRunning(this._ctx, "calcStepHour");
                }
                busiTblNames = new HashSet();
                busiTblNames.add("T_NCM_CostCalResult");
                busiTblNames.add("T_NCM_CostCalMatDetailResult");
                busiTblNames.add("T_NCM_CostCalPrdDetailResult");
                try {
                    NCMDynamicTableManager.buildIndexsOfBusiTbls((Context)this._ctx, (String)this._companyId, busiTblNames);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                this.calcCostObjectData();
                this.updateJobStatus(90, "calcStepHour");
                if (result.getValue() <= 3) {
                    this.updateCostCalEntryFinished(this._ctx, "calcStepHour");
                }
            }
            catch (Throwable e) {
                if (result.getValue() <= 3) {
                    this.updateCostCalEntryFinished(this._ctx, "calcStepHour", CostTaskResultEnum.EXCEPTION);
                }
                throw e;
            }
            CostTaskResultEnum isCheckEopWipSuccess = CostTaskResultEnum.SUCCESS;
            if (this.isCheckEopWipException && result.getValue() <= 3) {
                try {
                    this.updateCostCalEntryRunning(this._ctx, "calcStepCheckEopWip");
                    params = new HashMap<String, String>();
                    params.put("companyId", this._companyId);
                    params.put("periodId", this._periodId);
                    params.put("userId", (String)this._param.get("userId"));
                    if (EopWipAdjustFactory.getLocalInstance((Context)this._ctx).isNeedAdjust(params)) {
                        isCheckEopWipSuccess = CostTaskResultEnum.WARN;
                    }
                    if (isCheckEopWipSuccess.getValue() == 3) {
                        entry = (CostTaskEntryInfo)this.costTaskEntryMap.get("calcStepCheckEopWip");
                        entry.setReport(this.getResource("EXCEPTION_LIST", NCMConst.l1), NCMConst.l1);
                        entry.setReport(this.getResource("EXCEPTION_LIST", NCMConst.l2), NCMConst.l2);
                        entry.setReport(this.getResource("EXCEPTION_LIST", NCMConst.l3), NCMConst.l3);
                        entry.setFunction("com.kingdee.eas.ncm.cal.client.CostCalEopWipExReportUI");
                        map = new HashMap<String, String>();
                        map.put("companyId", this._companyId);
                        map.put("periodId", this._periodId);
                        entry.setParam(CostTaskUtils.encode(map));
                    }
                    if (isCheckEopWipSuccess.getValue() > result.getValue()) {
                        result = isCheckEopWipSuccess;
                    }
                    this.updateCostCalEntryFinished(this._ctx, "calcStepCheckEopWip", isCheckEopWipSuccess);
                }
                catch (Throwable e) {
                    this.updateCostCalEntryFinished(this._ctx, "calcStepCheckEopWip", CostTaskResultEnum.EXCEPTION);
                    throw e;
                }
            }
            if (this.isGenEopWipAdjust && result.getValue() <= 3) {
                try {
                    this.updateCostCalEntryRunning(this._ctx, "calcStepGenEopWip");
                    if (isCheckEopWipSuccess.getValue() == 3) {
                        params = new HashMap();
                        params.put("companyId", this._companyId);
                        params.put("periodId", this._periodId);
                        params.put("userId", (String)this._param.get("userId"));
                        EopWipAdjustFactory.getLocalInstance((Context)this._ctx).genAdjustBill(params);
                        entry = (CostTaskEntryInfo)this.costTaskEntryMap.get("calcStepGenEopWip");
                        entry.setReport(this.getResource("VIEW_RESULT", NCMConst.l1), NCMConst.l1);
                        entry.setReport(this.getResource("VIEW_RESULT", NCMConst.l2), NCMConst.l2);
                        entry.setReport(this.getResource("VIEW_RESULT", NCMConst.l3), NCMConst.l3);
                        entry.setFunction("com.kingdee.eas.ncm.bill.client.EopWipAdjustListUI");
                        map = new HashMap();
                        map.put("companyId", this._companyId);
                        map.put("periodId", this._periodId);
                        map.put("UIFactoryName", "UINewTabFactory");
                        entry.setParam(CostTaskUtils.encode(map));
                    }
                    this.updateCostCalEntryFinished(this._ctx, "calcStepGenEopWip");
                }
                catch (Throwable e) {
                    this.updateCostCalEntryFinished(this._ctx, "calcStepGenEopWip", CostTaskResultEnum.EXCEPTION);
                    throw e;
                }
            }
            if (result.getValue() <= 3) {
                this.updateJobStatus(100, "calcStepOver");
            }
            CalcalDispatchEx calcEx = new CalcalDispatchEx();
            calcEx.calcExDealwith(this._ctx, this._param);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw e;
        }
        finally {
            Throwable throwable;
            block45: {
                throwable = null;
                try {
                    this.clearCostCalReportPreTreatData();
                }
                catch (Throwable e) {
                    throwable = e;
                }
                try {
                    if (this._calcTable != null) {
                        this._calcTable.releaseTempTable();
                    }
                }
                catch (Throwable e) {
                    if (throwable != null) break block45;
                    throwable = e;
                }
            }
            SQLUtils.cleanup((Connection)this._globalConnection);
            this._globalConnection = null;
            if (throwable != null) {
                throw throwable;
            }
            if (result.getValue() <= 3) {
                LogUtil.afterLog((Context)this._ctx, (IObjectPK)pk);
            }
        }
        ret.put("result", result);
        ret.put("HasError", String.valueOf(result.getValue() >= 7));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CostTaskResultEnum doRank(PeriodInfo periodInfo, int lowest) throws Throwable {
        Throwable throwable;
        CostTaskResultEnum result;
        block53: {
            String matAllocStd;
            block52: {
                result = CostTaskResultEnum.SUCCESS;
                CostTaskResultEnum tempResult = CostTaskResultEnum.SUCCESS;
                AllocWIP alloc = null;
                matAllocStd = null;
                if (lowest < 0) {
                    return result;
                }
                int dispRank = 0;
                try {
                    alloc = new AllocWIP(this._param);
                    AllocClassiCOImpl classiAlloc = new AllocClassiCOImpl(this._ncmCommonParam);
                    int companyBaseCurrencyPrec = this.getCompanyBaseCurrencyPerc(this._ctx, this._companyId);
                    matAllocStd = this.getMatAllocStdDataTbl(this._ctx);
                    int proceCount = 5;
                    boolean isOutsourcCalc = NCMUtils.isDoOutSourcCalc((Context)this._ctx, (String)this._companyId);
                    if (isOutsourcCalc) {
                        proceCount = 7;
                    }
                    for (int rank = lowest; rank >= 0; --rank) {
                        CostTaskResultEnum rankResult;
                        block49: {
                            this.updateCostCalEntryRunning(this._ctx, "calcStepRankTop" + ++dispRank);
                            rankResult = CostTaskResultEnum.SUCCESS;
                            this._log.AddCalcLog_Head(dispRank, "HEAD");
                            this._log.AddCalcLog_PreSet(this._ctx, rank, dispRank);
                            try {
                                this.updateCostCalEntryRunning(this._ctx, "calcStepRankWip" + dispRank);
                                CostTaskResultEnum wipResult = CostTaskResultEnum.SUCCESS;
                                alloc.setCalcRank(rank);
                                int iBatch = 0;
                                BatchAllocByHardcodeIterator _iterator = new BatchAllocByHardcodeIterator(this._param, alloc, rank);
                                _iterator.FirstBatch();
                                while (!_iterator.IsDone()) {
                                    CostTaskEntryInfo entry;
                                    if (iBatch == 0) {
                                        entry = (CostTaskEntryInfo)this.costTaskEntryMap.get("calcStepRankWip" + dispRank);
                                        if (entry != null) {
                                            entry.setProgressInfo(iBatch + "/" + _iterator.getBatchCount());
                                        }
                                        this.updateCostCalEntry(this._ctx, "calcStepRankWip" + dispRank, null, null, -1L, -1L);
                                    }
                                    if ((tempResult = _iterator.AllocCurrBatch()).getValue() > wipResult.getValue()) {
                                        wipResult = tempResult;
                                    }
                                    ++iBatch;
                                    entry = (CostTaskEntryInfo)this.costTaskEntryMap.get("calcStepRankWip" + dispRank);
                                    if (entry != null) {
                                        entry.setProgressInfo(iBatch + "/" + _iterator.getBatchCount());
                                    }
                                    this.updateCostCalEntry(this._ctx, "calcStepRankWip" + dispRank, null, null, -1L, -1L);
                                    _iterator.NextBatch();
                                }
                                this.updateJobStatus(75 / (proceCount * (lowest + 1)), "calcStepRankWip");
                                if (wipResult.getValue() > rankResult.getValue()) {
                                    rankResult = wipResult;
                                }
                                this.updateCostCalEntryFinished(this._ctx, "calcStepRankWip" + dispRank, wipResult);
                            }
                            catch (Throwable e) {
                                this.updateCostCalEntryFinished(this._ctx, "calcStepRankWip" + dispRank, CostTaskResultEnum.EXCEPTION);
                                throw e;
                            }
                            if (rankResult.getValue() <= 3) {
                                try {
                                    this.updateCostCalEntryRunning(this._ctx, "calcStepRankClassCalc" + dispRank);
                                    classiAlloc.setCalcRank(rank);
                                    boolean isCalcSuccess = classiAlloc.doAllocClassiCO(this._ctx);
                                    this.updateJobStatus(75 / (proceCount * (lowest + 1)), "calcStepRankClassCalc");
                                    if (isCalcSuccess) {
                                        this.updateCostCalEntryFinished(this._ctx, "calcStepRankClassCalc" + dispRank, CostTaskResultEnum.SUCCESS);
                                        break block49;
                                    }
                                    this.updateCostCalEntryFinished(this._ctx, "calcStepRankClassCalc" + dispRank, CostTaskResultEnum.FAILURE);
                                    if (CostTaskResultEnum.FAILURE.getValue() > rankResult.getValue()) {
                                        rankResult = CostTaskResultEnum.FAILURE;
                                    }
                                }
                                catch (Throwable e) {
                                    this.updateCostCalEntryFinished(this._ctx, "calcStepRankClassCalc" + dispRank, CostTaskResultEnum.EXCEPTION);
                                    throw e;
                                }
                            }
                        }
                        this._log.UpdatePreSetCalcLog(dispRank);
                        if (rankResult.getValue() <= 3) {
                            try {
                                this.updateCostCalEntryRunning(this._ctx, "calcStepRankCalIn" + dispRank);
                                CostTaskResultEnum calcInResult = this.calcIn(rank, dispRank, periodInfo.getPeriodYear(), periodInfo.getPeriodNumber(), companyBaseCurrencyPrec);
                                if (calcInResult.getValue() == 3) {
                                    CostTaskEntryInfo entry = (CostTaskEntryInfo)this.costTaskEntryMap.get("calcStepRankCalIn" + dispRank);
                                    entry.setReport(this.getResource("VIEW_REPORT", NCMConst.l1), NCMConst.l1);
                                    entry.setReport(this.getResource("VIEW_REPORT", NCMConst.l2), NCMConst.l2);
                                    entry.setReport(this.getResource("VIEW_REPORT", NCMConst.l3), NCMConst.l3);
                                    entry.setFunction("com.kingdee.eas.ncm.cal.client.CostCalCalcInReportUI");
                                    HashMap<String, String> map = new HashMap<String, String>();
                                    map.put("companyId", this._companyId);
                                    map.put("periodId", this._periodId);
                                    map.put("typeId", entry.getId().toString());
                                    entry.setParam(CostTaskUtils.encode(map));
                                }
                                this.updateJobStatus(75 / (proceCount * (lowest + 1)), "calcStepRankCalIn");
                                if (calcInResult.getValue() > rankResult.getValue()) {
                                    rankResult = calcInResult;
                                }
                                this.updateCostCalEntryFinished(this._ctx, "calcStepRankCalIn" + dispRank, calcInResult);
                            }
                            catch (Throwable e) {
                                this.updateCostCalEntryFinished(this._ctx, "calcStepRankCalIn" + dispRank, CostTaskResultEnum.EXCEPTION);
                                throw e;
                            }
                            try {
                                this.updateCostCalEntryRunning(this._ctx, "calcStepRankCalOut" + dispRank);
                                this.calcOut(rank, dispRank);
                                this.updateJobStatus(75 / (proceCount * (lowest + 1)), "calcStepRankCalOut");
                                this.updateCostCalEntryFinished(this._ctx, "calcStepRankCalOut" + dispRank);
                            }
                            catch (Throwable e) {
                                this.updateCostCalEntryFinished(this._ctx, "calcStepRankCalOut" + dispRank, CostTaskResultEnum.EXCEPTION);
                                throw e;
                            }
                            if (isOutsourcCalc) {
                                try {
                                    this.updateCostCalEntryRunning(this._ctx, "outsourcCalcIn" + dispRank);
                                    this.outsourcCalcIn(rank, dispRank);
                                    this.updateJobStatus(75 / (proceCount * (lowest + 1)), "outsourcCalcIn");
                                    this.updateCostCalEntryFinished(this._ctx, "outsourcCalcIn" + dispRank);
                                }
                                catch (Throwable e) {
                                    this.updateCostCalEntryFinished(this._ctx, "outsourcCalcIn" + dispRank, CostTaskResultEnum.EXCEPTION);
                                    throw e;
                                }
                                try {
                                    this.updateCostCalEntryRunning(this._ctx, "outsourcCalcOut" + dispRank);
                                    this.outsourcCalcOut(rank, dispRank);
                                    this.updateJobStatus(75 / (proceCount * (lowest + 1)), "outsourcCalcOut");
                                    this.updateCostCalEntryFinished(this._ctx, "outsourcCalcOut" + dispRank);
                                }
                                catch (Throwable e) {
                                    this.updateCostCalEntryFinished(this._ctx, "outsourcCalcOut" + dispRank, CostTaskResultEnum.EXCEPTION);
                                    throw e;
                                }
                            }
                            try {
                                this.updateCostCalEntryRunning(this._ctx, "calcStepRankSecAlloc" + dispRank);
                                this.secAlloc(matAllocStd, rank, dispRank);
                                this.updateJobStatus(75 / (proceCount * (lowest + 1)), "calcStepRankSecAlloc");
                                this.updateCostCalEntryFinished(this._ctx, "calcStepRankSecAlloc" + dispRank);
                            }
                            catch (Throwable e) {
                                this.updateCostCalEntryFinished(this._ctx, "calcStepRankSecAlloc" + dispRank, CostTaskResultEnum.EXCEPTION);
                                throw e;
                            }
                        }
                        this.updateCostCalEntryFinished(this._ctx, "calcStepRankTop" + dispRank, rankResult);
                        if (rankResult.getValue() > result.getValue()) {
                            result = rankResult;
                        }
                        if (result.getValue() >= CostTaskResultEnum.FAILURE.getValue()) break;
                    }
                    throwable = null;
                }
                catch (Throwable e) {
                    try {
                        this.updateCostCalEntryFinished(this._ctx, "calcStepRankTop" + dispRank, CostTaskResultEnum.EXCEPTION);
                        throw e;
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3;
                        block51: {
                            block50: {
                                throwable3 = null;
                                try {
                                    if (alloc != null) {
                                        alloc.releasePrivateTempTbl();
                                    }
                                }
                                catch (Throwable e2) {
                                    if (throwable3 != null) break block50;
                                    throwable3 = e2;
                                }
                            }
                            try {
                                if (matAllocStd != null) {
                                    TempTablePool.getInstance((Context)this._ctx).releaseTable(matAllocStd);
                                }
                            }
                            catch (Throwable e3) {
                                if (throwable3 != null) break block51;
                                throwable3 = e3;
                            }
                        }
                        if (throwable3 != null) {
                            throw throwable3;
                        }
                        throw throwable2;
                    }
                }
                try {
                    if (alloc != null) {
                        alloc.releasePrivateTempTbl();
                    }
                }
                catch (Throwable e) {
                    if (throwable != null) break block52;
                    throwable = e;
                }
            }
            try {
                if (matAllocStd != null) {
                    TempTablePool.getInstance((Context)this._ctx).releaseTable(matAllocStd);
                }
            }
            catch (Throwable e) {
                if (throwable != null) break block53;
                throwable = e;
            }
        }
        if (throwable != null) {
            throw throwable;
        }
        return result;
    }

    protected PeriodInfo getPeriodInfo(Context ctx, String periodId) throws BOSException {
        int periodNumber;
        int periodYear;
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select FPeriodYear,FPeriodNumber from T_BD_Period where FID='").append(this._periodId).append("'");
        rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        try {
            rs.first();
            periodYear = rs.getInt("FPeriodYear");
            periodNumber = rs.getInt("FPeriodNumber");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        PeriodInfo info = new PeriodInfo();
        info.setPeriodYear(periodYear);
        info.setPeriodNumber(periodNumber);
        return info;
    }

    protected int getCompanyBaseCurrencyPerc(Context ctx, String companyId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("baseCurrency.precision");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        return company.getBaseCurrency().getPrecision();
    }

    private void clearPreCalcResult() throws BOSException {
        try {
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetCostCalResultTable(), null);
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetCostCalMatDetailResultTable(), null);
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetCostCalPrdDetailResultTable(), null);
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetDataByCostObjTable(), null);
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetDataByProductTable(), null);
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetCostCalRevertInfoTable(), null);
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetAugmentedMatrixTable(), null);
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetLinearEquationsTable(), null);
            this.clearEopWipAdjust();
            this.clearCalcInReport();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void clearEopWipAdjust() throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("delete from T_NCM_EopWipAdjustMatDetail where FParentID in ( \n");
        ksql.append("    select \n");
        ksql.append("        e.FID \n");
        ksql.append("    from T_NCM_EopWipAdjustEntry e \n");
        ksql.append("    join T_NCM_EopWipAdjust b on b.FID = e.FParentID \n");
        ksql.append("    where b.FCompanyOrg = '" + this._companyId + "' \n");
        ksql.append("        and b.FCalculatePeriod = '" + this._periodId + "' \n");
        ksql.append("        and b.FBillStatus in (1, 2, 3) \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("delete from T_NCM_EopWipAdjustEntry where FParentID in ( \n");
        ksql.append("    select \n");
        ksql.append("        b.FID \n");
        ksql.append("    from T_NCM_EopWipAdjust b \n");
        ksql.append("    where b.FCompanyOrg = '" + this._companyId + "' \n");
        ksql.append("        and b.FCalculatePeriod = '" + this._periodId + "' \n");
        ksql.append("        and b.FBillStatus in (1, 2, 3) \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("delete from T_NCM_EopWipAdjust \n");
        ksql.append("where FCompanyOrg = '" + this._companyId + "' \n");
        ksql.append("    and FCalculatePeriod = '" + this._periodId + "' \n");
        ksql.append("    and FBillStatus in (1, 2, 3) \n");
        ksql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)ksql.toString());
    }

    private void clearCostCalReportPreTreatData() throws EASBizException, BOSException, SQLException {
        String tblPreTreatState = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_CostCalReportPreTreatState");
        String sql = "update " + tblPreTreatState + " set FIsPreTreatReportData=0, FIsPreTreatYearSum=0  where FPeriodId='" + this._periodId + "'";
        NCMDbUtil.execute((Context)this._ctx, (String)sql);
    }

    private void getProcessData() throws BOSException {
        String T_TMP_CostObject;
        String T_TMP_RecBillCostObjectTable = this.getCostDataCache().getRecBillCostObjectTable();
        try {
            T_TMP_CostObject = this.getCostDataCache().getCostObjectTable();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(this._calcTable.GetDataByProductTable()).append("(").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,FCostCenterID,FCostObjectID,FProductID,FLot,FFinishedQty,FFinishedAssistQty,FFinishedAddQty )").append('\n').append("SELECT ").append('\n').append("    newbosid('C4774737') FID, ").append('\n').append("    '").append(this._companyId).append("' FCompanyID, ").append('\n').append("    '").append(this._periodId).append("' FCalculatePeriodID, ").append('\n').append("\t t.FCostCenterID, t.FCostObjectID, t.FMaterialID, co.FBatchNumber, ").append('\n').append("\t ISNULL(SUM(ENTRY.FBASEQTY),0) FFinishedQty ").append('\n').append("\t ,ISNULL(SUM(ENTRY.FAssistQty),0) FFinishedAssistQty ").append('\n').append("\t ,ISNULL(SUM(ENTRY.FQTY),0) FFinishedAddQty ").append('\n').append("FROM " + T_TMP_RecBillCostObjectTable + " t ").append('\n').append("JOIN T_IM_ManufactureRecBillEntry ENTRY ON ENTRY.FID = t.FSourceBillEntryID ").append('\n').append(" Inner Join ").append(T_TMP_CostObject).append(" co ON t.FCostObjectID = co.FCostObjectID and co.FMaterialID = ENTRY.FMaterialID ").append('\n').append("GROUP BY t.FCostCenterID, t.FCostObjectID, t.FMaterialID, co.FBatchNumber ").append('\n').append(";");
        sql.append("INSERT INTO ").append(this._calcTable.GetDataByCostObjTable()).append("(").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,FCostCenterID,FCostObjectID,FFinishedQty,FFinishedAssistQty,FFinishedAddQty)").append('\n').append(" SELECT newbosid('C4774737') AS FID,'").append(this._companyId).append("' As FCompanyID,'").append(this._periodId).append("' As FCalculatePeriodID,").append('\n').append("\t\tS.FCostCenterID,S.FCostObjectID,").append('\n').append("\t\tto_decimal( SUM(S.FFinishedQty * ISNULL(coe.FQuotiety,1)) ,24,12) As FFinishedQty ").append('\n').append("\t\t,to_decimal( SUM(S.FFinishedAssistQty * ISNULL(coe.FQuotiety,1)) ,24,12) As FFinishedAssistQty ").append('\n').append("\t\t,to_decimal( SUM(S.FFinishedAddQty * ISNULL(coe.FQuotiety,1)) ,24,12) As FFinishedAddQty ").append('\n').append(" FROM ").append(this._calcTable.GetDataByProductTable()).append(" S ").append('\n').append(" INNER JOIN T_BD_CostObject CO ON CO.FID = S.FCostObjectID ").append('\n').append(" INNER JOIN T_BD_COstObjectEntry coe on coe.FparentId = co.Fid and  coe.FRelatedID = S.FProductID ").append('\n').append(" WHERE S.FCompanyID='").append(this._companyId).append("' AND S.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n').append("  AND CO.FRelatedType =0 AND  CO.FIsForbiden =0 ").append(" GROUP BY S.FCostCenterID,S.FCostObjectID ").append('\n').append(";");
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sql.toString(), (String)";");
    }

    protected void calManufRecBillTotalActualCost(int periodYear, int periodNumber) throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("CREATE TABLE T ");
        ksql.append("( \n");
        ksql.append("    FID   \t\t\t    VARCHAR(44),\t");
        ksql.append("    FUnitActualCost \tNUMERIC(28,16)\t");
        ksql.append(") \n");
        String tblName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this._ctx);
        try {
            tblName = pool.createTempTable(ksql.toString());
            ksql.setLength(0);
            ksql.append("INSERT INTO ").append(tblName).append("(FId, FUnitActualCost) (").append('\n').append("\tSELECT entry.fid, ").append('\n');
            NCMReportHelper.AppendCaseSQLClause(ksql, "ISNULL(SUM(S.FFinishedAmount),0)", "ISNULL(MAX(S.FTotalFinishedQty),1)", "ISNULL(SUM(S.FFinishedAmount),0)", "FUnitActualCost", "MAX(mt.FPricePrecision)");
            ksql.append("       FROM ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" S ").append('\n').append("           LEFT JOIN T_IM_ManufactureRecBillEntry entry ON entry.FCostCenterOrgunitId = s.FCostCenterId ").append('\n').append("               and s.FCompanyId = entry.FCompanyOrgunitId").append('\n').append("               AND s.FProductId = entry.FMaterialId").append('\n').append("\t\t\tLEFT JOIN T_IM_ManufactureRecBill bill ON entry.FParentId = bill.FId ").append('\n').append("           INNER JOIN T_SCM_TransactionType trans ON bill.FTransactionTypeId = trans.FId AND trans.FIsManuCostCalculate = 1").append('\n').append("\t \t\tINNER JOIN T_IM_InvUpdateType ut on entry.FINVUPDATETYPEID = ut.fid ").append('\n').append("\t \t\tINNER JOIN T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n').append("           LEFT JOIN T_BD_Material mt ON mt.FId = entry.FMaterialId").append('\n').append("\t\t\tLEFT JOIN T_BD_CostObject OBJ on s.FCostObjectID = OBJ.FId").append('\n').append("\t\tWHERE bill.FBaseStatus = 4").append('\n').append("         \tAND bill.FYear = ").append(periodYear).append(" \t\t\tAND bill.FPeriod=").append(periodNumber).append('\n').append("           AND s.FCompanyId = '").append(this._companyId).append("'").append('\n').append("           AND s.FCalculatePeriodId = '").append(this._periodId).append("' ").append('\n').append("\t\t \tAND entry.FId IS NOT NULL ").append('\n').append("\t\t\t   and ").append('\n').append("\t\t\t   ( ").append('\n').append("\t\t\t       (OBJ.FCalculateMode = 4 and Isnull(ENTRY.FLot,' ') = Isnull(OBJ.FBatchNumber,' ')) ").append('\n').append("\t\t\t\t   or ").append('\n').append("\t\t\t\t   (OBJ.FCalculateMode =7 and OBJ.FOrderID = ENTRY.FManuBillID) ").append('\n').append("\t\t\t\t   or ").append('\n').append("\t\t\t\t   (OBJ.FCalculateMode in (1, 3)) ").append('\n').append("\t\t\t   )").append('\n').append("\t\tGROUP BY entry.FId);");
            NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)ksql.toString(), (String)";");
            pool.createIndex(tblName, "FID", false, false);
            ksql.setLength(0);
            ksql.append("UPDATE T_IM_ManufactureRecBill \n").append("\tSET FTotalActualCost = (").append('\n').append("\t\t\tSELECT ISNULL(SUM(entry.FActualCost), 0)").append('\n').append("\t\t\t\tFROM T_IM_ManufactureRecBillEntry entry").append('\n').append("\t\t\t\t\tJOIN ").append(tblName).append(" temp ON temp.FID = entry.FID").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBill.FID = entry.FParentID)").append('\n').append("\tWHERE FYear = " + periodYear + " ").append('\n').append("\t    and FPeriod = " + periodNumber + " ").append('\n').append("\t    and FBaseStatus = 4 ").append('\n').append("\t    and EXISTS (").append('\n').append("\t\t\tSELECT 1 ").append('\n').append("\t\t\t\tFROM T_IM_ManufactureRecBillEntry entry").append('\n').append("\t\t\t\t\tJOIN ").append(tblName).append(" temp ON temp.FID = entry.FID").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBill.FID = entry.FParentId)").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)ksql.toString(), (String)";");
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tblName != null) {
                pool.releaseTable(tblName);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CostTaskResultEnum calcIn(int rank, int dispRank, int periodYear, int periodNumber, int companyBaseCurrencyPrec) throws BOSException {
        TempTablePool pool;
        String T_TMP_BillCost;
        CostTaskResultEnum result;
        block10: {
            result = CostTaskResultEnum.SUCCESS;
            String T_TMP_CalcCost = null;
            T_TMP_BillCost = null;
            pool = TempTablePool.getInstance((Context)this._ctx);
            try {
                StringBuffer ksql = new StringBuffer();
                ksql.append("CREATE TABLE T ( \n");
                ksql.append("    FCostCenterID   \tVARCHAR(44),\t");
                ksql.append("    FCostObjectID   \tVARCHAR(44),\t");
                ksql.append("    FProductID   \t    VARCHAR(44),\t");
                ksql.append("    FLot   \t        NVARCHAR(80),\t");
                ksql.append("    FActualCost \t    NUMERIC(17, 4),\t");
                ksql.append("    FUnitActualCost \tNUMERIC(21, 8),\t");
                ksql.append("    FPricePrecision \tint\t");
                ksql.append(") \n");
                T_TMP_CalcCost = pool.createTempTable(ksql.toString());
                ksql.setLength(0);
                ksql.append("insert into " + T_TMP_CalcCost + " ( \n");
                ksql.append("    FCostCenterID,\t\n");
                ksql.append("    FCostObjectID,\t");
                ksql.append("    FProductID, \n");
                ksql.append("    FLot,\t\n");
                ksql.append("    FActualCost, \n");
                ksql.append("    FUnitActualCost, \n");
                ksql.append("    FPricePrecision \n");
                ksql.append(") \n");
                ksql.append("select \n");
                ksql.append("    r.FCostCenterID, \n");
                ksql.append("    r.FCostObjectID, \n");
                ksql.append("    r.FProductID, \n");
                ksql.append("    r.FLot, \n");
                ksql.append("    ISNULL(SUM(r.FFinishedAmount),0), \n");
                ksql.append("    case ISNULL(MAX(r.FTotalFinishedQty),1) \n");
                ksql.append("        when 0 THEN Round(TO_Decimal(ISNULL(SUM(r.FFinishedAmount),0),24,12),MAX(m.FPricePrecision)) \n");
                ksql.append("        ELSE Round( \n");
                ksql.append("            TO_Decimal(ISNULL(SUM(r.FFinishedAmount),0),24,12)/TO_Decimal(ISNULL(MAX(r.FTotalFinishedQty),1),24,12) \n");
                ksql.append("            ,MAX(m.FPricePrecision) \n");
                ksql.append("        ) \n");
                ksql.append("    end,  \n");
                ksql.append("    MAX(m.FPricePrecision) \n");
                ksql.append("from " + this._calcTable.GetCostCalPrdDetailResultTable() + " r \n");
                ksql.append("join T_BD_Material m ON m.FID = r.FProductID \n");
                ksql.append("where r.FCalcLevel = " + rank + " \n");
                ksql.append("group by r.FCostCenterID, r.FCostObjectID, \n");
                ksql.append("   r.FProductID, r.FLot \n");
                ksql.append("; \n");
                NCMDbUtil.execute((Context)this._ctx, (String)ksql.toString());
                CostTaskEntryInfo entry = (CostTaskEntryInfo)this.costTaskEntryMap.get("calcStepRankCalIn" + dispRank);
                String typeId = "";
                if (entry != null && entry.getId() != null) {
                    typeId = entry.getId().toString();
                }
                ksql.setLength(0);
                ksql.append("insert into T_NCM_CostCalCalcInReport ( \n");
                ksql.append("    FID, \n");
                ksql.append("    FCompanyID, FPeriodID, \n");
                ksql.append("    FTypeID, \n");
                ksql.append("    FCostCenterID, FCostObjectID, \n");
                ksql.append("    FProductID, FLot, \n");
                ksql.append("    FUnitActualCost \n");
                ksql.append(") \n");
                ksql.append("select top 100 \n");
                ksql.append("    newbosid('12345678'), \n");
                ksql.append("    '" + this._companyId + "', '" + this._periodId + "', \n");
                ksql.append("    '" + typeId + "', \n");
                ksql.append("    FCostCenterID, FCostObjectID, \n");
                ksql.append("    FProductID, FLot, \n");
                ksql.append("    FUnitActualCost \n");
                ksql.append("from " + T_TMP_CalcCost + " \n");
                ksql.append("where FUnitActualCost < 0 \n");
                NCMDbUtil.execute((Context)this._ctx, (String)ksql.toString());
                ksql.setLength(0);
                ksql.append("select top 1 1 from " + T_TMP_CalcCost + " \n");
                ksql.append("where FUnitActualCost < 0 \n");
                IRowSet rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)ksql.toString());
                if (rs.next()) {
                    result = CostTaskResultEnum.WARN;
                    ksql.setLength(0);
                    ksql.append("delete from " + T_TMP_CalcCost + " \n");
                    ksql.append("where FUnitActualCost < 0 \n");
                    NCMDbUtil.execute((Context)this._ctx, (String)ksql.toString());
                }
                pool.createIndex(T_TMP_CalcCost, "FCostCenterID, FCostObjectID, FProductID", false, false);
                ksql.setLength(0);
                ksql.append("CREATE TABLE T ");
                ksql.append("( \n");
                ksql.append("    FID                VARCHAR(44),\t");
                ksql.append("    FCostCenterID   \tVARCHAR(44),\t");
                ksql.append("    FCostObjectID   \tVARCHAR(44),\t");
                ksql.append("    FProductID   \t    VARCHAR(44),\t");
                ksql.append("    FLot   \t        NVARCHAR(80),\t");
                ksql.append("    FBaseQty           NUMERIC(21,8),  ");
                ksql.append("    FQTY               NUMERIC(21,8),  ");
                ksql.append("    FActualCost \t    NUMERIC(17, 4),\t");
                ksql.append("    FUnitActualCost \tNUMERIC(21, 8),\t");
                ksql.append("    FPricePrecision \tint\t            ");
                ksql.append(") \n");
                T_TMP_BillCost = pool.createTempTable(ksql.toString());
                String T_TMP_RecBillCostObjectTable = this.getCostDataCache().getRecBillCostObjectTable();
                ksql.setLength(0);
                ksql.append("INSERT INTO " + T_TMP_BillCost + " ( \n");
                ksql.append("    FID,\t\n");
                ksql.append("    FCostCenterID,\t\n");
                ksql.append("    FCostObjectID,\t\n");
                ksql.append("    FProductID, \n");
                ksql.append("    FLot,\t\n");
                ksql.append("    FBaseQty, \n");
                ksql.append("    FQTY, \n");
                ksql.append("    FActualCost, \n");
                ksql.append("    FUnitActualCost, \n");
                ksql.append("    FPricePrecision \n");
                ksql.append(") \n");
                ksql.append("SELECT \n");
                ksql.append("    e.FSourceBillEntryID, \n");
                ksql.append("    c.FCostCenterID,\t\n");
                ksql.append("    c.FCostObjectID,\t\n");
                ksql.append("    c.FProductID, \n");
                ksql.append("    c.FLot,\t\n");
                ksql.append("    e.FBaseQty, \n");
                ksql.append("    e.FQTY, \n");
                ksql.append("    ROUND(ISNULL(c.FUnitActualCost * e.FBaseQty, 0), " + companyBaseCurrencyPrec + "), \n");
                ksql.append("    c.FUnitActualCost, \n");
                ksql.append("    c.FPricePrecision \n");
                ksql.append("from " + T_TMP_RecBillCostObjectTable + " e \n");
                ksql.append("join " + T_TMP_CalcCost + " c \n");
                ksql.append("    ON c.FCostCenterID = e.FCostCenterID \n");
                ksql.append("    AND c.FCostObjectID = e.FCostObjectID \n");
                ksql.append("    AND c.FProductID = e.FMaterialID  \n");
                NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)ksql.toString(), (String)";");
                pool.createIndex(T_TMP_BillCost, "FID", false, false);
                pool.createIndex(T_TMP_BillCost, "FCostCenterID, FCostObjectID, FProductID", false, false);
                this.calcInAdjustDiff(T_TMP_CalcCost, T_TMP_BillCost);
                ksql.setLength(0);
                ksql.append("update " + T_TMP_BillCost + " \n");
                ksql.append("set FUnitActualCost = ( \n");
                ksql.append("    case ISNULL(FQty,1) \n");
                ksql.append("        when 0 then Round(TO_Decimal(ISNULL(FActualCost,0),24,12),FPricePrecision) \n");
                ksql.append("        ELSE Round( \n");
                ksql.append("            TO_Decimal(ISNULL(FActualCost,0),24,12)/TO_Decimal(ISNULL(FQty,1),24,12) \n");
                ksql.append("            ,FPricePrecision \n");
                ksql.append("        ) \n");
                ksql.append("    end \n");
                ksql.append(") \n");
                ksql.append("WHERE FQTY <> FBaseQty ").append('\n');
                ksql.append("; \n");
                ksql.append("UPDATE T_IM_ManufactureRecBillEntry ");
                ksql.append("SET (FUnitActualCost, FActualCost) = ( \n");
                ksql.append("    SELECT  \n");
                ksql.append(" \t     c.FUnitActualCost, c.FActualCost \n");
                ksql.append("    FROM " + T_TMP_BillCost + " c \n");
                ksql.append("\t WHERE T_IM_ManufactureRecBillEntry.FID = c.FID \n");
                ksql.append(") \n");
                ksql.append("; \n");
                NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)ksql.toString(), (String)";");
                if (T_TMP_CalcCost == null) break block10;
            }
            catch (BOSException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new BOSException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (T_TMP_CalcCost != null) {
                        pool.releaseTable(T_TMP_CalcCost);
                    }
                    if (T_TMP_BillCost != null) {
                        pool.releaseTable(T_TMP_BillCost);
                    }
                    throw throwable;
                }
            }
            pool.releaseTable(T_TMP_CalcCost);
        }
        if (T_TMP_BillCost != null) {
            pool.releaseTable(T_TMP_BillCost);
        }
        String status = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Sucess");
        this._log.AddCalcLog(dispRank, "", CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_CalcIn"), status, "", false, "CalcIn", 2);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcInAdjustDiff(String T_TMP_CalcCost, String T_TMP_BillCost) throws Exception {
        StringBuffer sql;
        IRowSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block4: {
            conn = null;
            pstmt = null;
            rs = null;
            sql = new StringBuffer();
            sql.setLength(0);
            sql.append("select ").append('\n');
            sql.append("    D.FCostCenterID, D.FCostObjectID, D.FProductID, ").append('\n');
            sql.append("    (S.FActualCost - D.FActualCost) FFActualCostDiff ").append('\n');
            sql.append("FROM (").append('\n');
            sql.append("\tSELECT FCostCenterID, FCostObjectID, FProductID, ").append('\n');
            sql.append("        SUM(FActualCost) FActualCost ").append('\n');
            sql.append("    FROM " + T_TMP_BillCost + " ").append('\n');
            sql.append("    GROUP BY FCostCenterID, FCostObjectID, FProductID ").append('\n');
            sql.append(") D ").append('\n');
            sql.append("JOIN " + T_TMP_CalcCost + " S ").append('\n');
            sql.append("    ON S.FCostCenterID = D.FCostCenterid AND S.FCostObjectID = D.FCostObjectID ").append('\n');
            sql.append("    AND S.FProductID = D.FProductID ").append('\n');
            sql.append("where D.FActualCost <> S.FActualCost ").append('\n');
            rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)sql.toString());
            if (rs.size() != 0) break block4;
            SQLUtils.cleanup((ResultSet)rs, pstmt, conn);
            return;
        }
        try {
            sql.delete(0, sql.length());
            sql.append("UPDATE " + T_TMP_BillCost + " SET FActualCost = (FActualCost + ?) ").append('\n');
            sql.append("WHERE FID =(").append('\n');
            sql.append("\tSelect top 1 FID ").append('\n');
            sql.append("    FROM " + T_TMP_BillCost + " c ").append('\n');
            sql.append("\tWHERE c.FCostCenterID = ? ").append('\n');
            sql.append("\tAND c.FCostobjectID = ? ").append('\n');
            sql.append("\tand c.FProductID = ? ").append('\n');
            sql.append("\tORDER BY c.FActualCost DESC ").append('\n');
            sql.append(")");
            conn = EJBFactory.getConnection((Context)this._ctx);
            pstmt = conn.prepareStatement(sql.toString());
            while (rs.next()) {
                pstmt.setDouble(1, rs.getDouble("FFActualCostDiff"));
                pstmt.setString(2, rs.getString("FCostCenterID"));
                pstmt.setString(3, rs.getString("FCostobjectID"));
                pstmt.setString(4, rs.getString("FProductID"));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    private void clearCalcInReport() throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("delete from T_NCM_CostCalCalcInReport \n");
        ksql.append("where FCompanyID = '" + this._companyId + "' \n");
        NCMDbUtil.execute((Context)this._ctx, (String)ksql.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void calcOut(int rank, int dispRank) throws BOSException {
        if (rank == 0) {
            return;
        }
        boolean isSuccess = false;
        String status = null;
        String materialIdTempTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this._ctx);
        String createMaterialTempSql = "create table t_ncm_materialRange (fmaterialid varchar(44))";
        String attachment = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_SeeReport");
        try {
            String Balance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_CostCalPrdDetailResult");
            materialIdTempTableName = pool.createTempTable(createMaterialTempSql);
            NCMDbUtil.execute((Context)this._ctx, (String)("delete from  " + materialIdTempTableName));
            NCMDbUtil.execute((Context)this._ctx, (String)("insert into " + materialIdTempTableName + " select distinct FProductID from " + Balance + " where  FCalculatePeriodID='" + this._periodId + "' AND FCalcLevel=" + rank));
            NCMDbUtil.analyzeTempTable((Context)this._ctx, (String)materialIdTempTableName);
            ICalculateFacade ida = CalculateFacadeFactory.getLocalInstance((Context)this._ctx);
            CalculateParams cps = ida.costCalculate(this.getFilterParam(this._ctx, this._companyId, materialIdTempTableName));
            if (cps != null) {
                isSuccess = cps.getBoolean("boolean");
            }
            status = isSuccess ? CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Sucess") : CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Fail");
            this._log.AddCalcLog(dispRank, "", CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_CalcOut"), status, attachment, false, "CalcOut", 3);
        }
        catch (Exception e) {
            try {
                status = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Fail");
                this._log.AddCalcLog(dispRank, "", CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_CalcOut"), status, attachment, false, "CalcOut", 3);
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (materialIdTempTableName == null) throw throwable;
                    pool.releaseTable(materialIdTempTableName);
                    throw throwable;
                }
                catch (Exception e2) {
                    logger.error((Object)"", (Throwable)e2);
                    throw new BOSException((Throwable)e2);
                }
            }
        }
        try {
            if (materialIdTempTableName == null) return;
            pool.releaseTable(materialIdTempTableName);
            return;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void secAlloc(String matAllcStdTbl, int rank, int dispRank) throws BOSException {
        if (rank == 0) {
            return;
        }
        boolean isSuccess = false;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ctx", this._ctx);
        param.put("companyId", this._companyId);
        param.put("periodId", this._periodId);
        param.put("calcLevel", String.valueOf(rank));
        param.put("matAllcStdTbl", matAllcStdTbl);
        param.put("calcTable", this._param.get("calcTable"));
        SecAllocDispatch secAlloc = new SecAllocDispatch(param);
        try {
            secAlloc.DoSecAllocate();
            isSuccess = true;
        }
        catch (AllocateException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String status = null;
        status = isSuccess ? CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Sucess") : CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Fail");
        this._log.AddCalcLog(dispRank, "", CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_SecAlloc"), status, "", false, "SecAlloc", 6);
    }

    protected CalculateParams getFilterParam(Context ctx, String companyOrgInfoID, String materialTempTableName) throws EASBizException, BOSException {
        CalculateParams params = new CalculateParams();
        params.setBoolean("ISWRITECOSTCOMPUTEREPORT", true);
        params.setString("COMPANY_ID", companyOrgInfoID);
        params.setBoolean("IsOtherInvkCostCalculate", true);
        params.setBoolean("IsCreateTmpTable", true);
        params.setBoolean("ISWRITEDEXPCOSTRPT", false);
        params.setInt("ACCOUNT_TYPE", 3);
        String strCalType = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(companyOrgInfoID), "SCM_CAL_002");
        params.setString("CALTYPE", strCalType);
        params.setBoolean("IsCostAllAccountType", true);
        params.setString("ThirdPartyMaterialTableName", materialTempTableName);
        return params;
    }

    private void calcCostObjectData() throws BOSException {
        StringBuffer sql = new StringBuffer();
        try {
            String tblAllDataByCostObj = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_AllDataByCostObj");
            NCMDbUtil.execute((Context)this._ctx, (String)("truncate table " + tblAllDataByCostObj));
            String tblBalance = this._calcTable.GetBalanceTable();
            String tblCostCalResult = this._calcTable.GetCostCalResultTable();
            String tblDataByCostObj = this._calcTable.GetDataByCostObjTable();
            sql.setLength(0);
            sql.append("insert into " + tblAllDataByCostObj + " ( \n");
            sql.append("    FID, FCompanyID, FCalculatePeriodID, FCostCenterID, FCostObjectID, \n");
            sql.append("    FBopWIPQty, FInputQty, FFinishedQty, FEopWIPQty, \n");
            sql.append("    FBopWIPHour, FInputHour, FFinishedHour, FEopWIPHour, \n");
            sql.append("    FCoef \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    newbosid('12345678'), FCompanyID, FCalculatePeriodID, FCostCenterID, FCostObjectID, \n");
            sql.append("    0, 0, 0, 0, \n");
            sql.append("    0, 0, 0, 0, \n");
            sql.append("    1 \n");
            sql.append("from ( \n");
            sql.append(" \tselect FCompanyOrg FCompanyID, FCalculatePeriod FCalculatePeriodID, FCostCenterID, FCostObjectID \n");
            sql.append(" \tfrom  T_NCM_WIPCountingBill \n");
            sql.append("    where FCompanyOrg = '" + this._companyId + "' \n");
            sql.append("      and FCalculatePeriod = '" + this._periodId + "' \n");
            sql.append("    UNION \n");
            sql.append("    select FCompanyID , FCalculatePeriodID, FCostCenterID, FCostObjectID \n");
            sql.append(" \tfrom  " + tblCostCalResult + " \n");
            sql.append(") t ");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update " + tblAllDataByCostObj + " \n");
            sql.append("    set FBopWIPQty = (select isnull(FBopWIPQty, 0) \n");
            sql.append("                        from " + tblBalance + " \n");
            sql.append("                       where FCompanyOrg = " + tblAllDataByCostObj + ".FCompanyID \n");
            sql.append("                         and FCalculatePeriodID = " + tblAllDataByCostObj + ".FCalculatePeriodID \n");
            sql.append("                         and FCostCenterID = " + tblAllDataByCostObj + ".FCostCenterID \n");
            sql.append("                         and FCostObjectID = " + tblAllDataByCostObj + ".FCostObjectID)\n");
            sql.append("  where exists \n");
            sql.append("  (select 1 \n");
            sql.append("           from " + tblBalance + " \n");
            sql.append("          where " + tblBalance + ".FCompanyOrg = " + tblAllDataByCostObj + ".FCompanyID \n");
            sql.append("            and " + tblBalance + ".FCalculatePeriodID = " + tblAllDataByCostObj + ".FCalculatePeriodID \n");
            sql.append("            and " + tblBalance + ".FCostCenterID = " + tblAllDataByCostObj + ".FCostCenterID \n");
            sql.append("            and " + tblBalance + ".FCostObjectID = " + tblAllDataByCostObj + ".FCostObjectID) \n");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            sql.setLength(0);
            sql.setLength(0);
            sql.append(" update " + tblAllDataByCostObj + " \n");
            sql.append("    set FFinishedQty = (select isnull(FFinishedQty, 0) \n");
            sql.append("                        from " + tblDataByCostObj + " \n");
            sql.append("                       where FCompanyID = " + tblAllDataByCostObj + ".FCompanyID \n");
            sql.append("                         and FCalculatePeriodID = " + tblAllDataByCostObj + ".FCalculatePeriodID \n");
            sql.append("                         and FCostCenterID = " + tblAllDataByCostObj + ".FCostCenterID \n");
            sql.append("                         and FCostObjectID = " + tblAllDataByCostObj + ".FCostObjectID)\n");
            sql.append("  where exists \n");
            sql.append("  (select 1 \n");
            sql.append("           from " + tblDataByCostObj + " \n");
            sql.append("          where FCompanyID = " + tblAllDataByCostObj + ".FCompanyID \n");
            sql.append("            and FCalculatePeriodID = " + tblAllDataByCostObj + ".FCalculatePeriodID \n");
            sql.append("            and FCostCenterID = " + tblAllDataByCostObj + ".FCostCenterID \n");
            sql.append("            and FCostObjectID = " + tblAllDataByCostObj + ".FCostObjectID) \n");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update " + tblAllDataByCostObj + " \n");
            sql.append("    set FEopWIPQty = (select isnull(FQty, 0) \n");
            sql.append("                        from T_NCM_WIPCountingBill \n");
            sql.append("                       where FCompanyOrg = " + tblAllDataByCostObj + ".FCompanyID \n");
            sql.append("                         and FCalculatePeriod = " + tblAllDataByCostObj + ".FCalculatePeriodID \n");
            sql.append("                         and FCostCenterID = " + tblAllDataByCostObj + ".FCostCenterID \n");
            sql.append("                         and FCostObjectID = " + tblAllDataByCostObj + ".FCostObjectID)\n");
            sql.append("  where exists \n");
            sql.append("  (select 1 \n");
            sql.append("           from T_NCM_WIPCountingBill \n");
            sql.append("          where FCompanyOrg = " + tblAllDataByCostObj + ".FCompanyID \n");
            sql.append("            and FCalculatePeriod = " + tblAllDataByCostObj + ".FCalculatePeriodID \n");
            sql.append("            and FCostCenterID = " + tblAllDataByCostObj + ".FCostCenterID \n");
            sql.append("            and FCostObjectID = " + tblAllDataByCostObj + ".FCostObjectID) \n");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            sql.setLength(0);
            sql.setLength(0);
            sql.append(" update " + tblAllDataByCostObj + " \n");
            sql.append("    set FBopWIPHour = (select isnull(FBopWIPHour, 0) \n");
            sql.append("                        from " + tblBalance + " \n");
            sql.append("                       where FCompanyOrg = " + tblAllDataByCostObj + ".FCompanyID \n");
            sql.append("                         and FCalculatePeriodID = " + tblAllDataByCostObj + ".FCalculatePeriodID \n");
            sql.append("                         and FCostCenterID = " + tblAllDataByCostObj + ".FCostCenterID \n");
            sql.append("                         and FCostObjectID = " + tblAllDataByCostObj + ".FCostObjectID)\n");
            sql.append("  where exists \n");
            sql.append("  (select 1 \n");
            sql.append("           from " + tblBalance + " \n");
            sql.append("          where " + tblBalance + ".FCompanyOrg = " + tblAllDataByCostObj + ".FCompanyID \n");
            sql.append("            and " + tblBalance + ".FCalculatePeriodID = " + tblAllDataByCostObj + ".FCalculatePeriodID \n");
            sql.append("            and " + tblBalance + ".FCostCenterID = " + tblAllDataByCostObj + ".FCostCenterID \n");
            sql.append("            and " + tblBalance + ".FCostObjectID = " + tblAllDataByCostObj + ".FCostObjectID) \n");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            sql.setLength(0);
            String T_TMP_SumHour = this.getCostDataCache().getSumHourTable();
            sql.append(" update " + tblAllDataByCostObj + " set FInputHour = \n");
            sql.append("               (select round(isnull(sumHour.FHour, 0)/3600,2) \n");
            sql.append("from " + T_TMP_SumHour + " sumHour \n");
            sql.append("          where " + tblAllDataByCostObj + ".fCompanyID = sumHour.FCompanyOrg \n");
            sql.append("             AND " + tblAllDataByCostObj + ".FCalculatePeriodID = sumHour.FCalculatePeriod \n");
            sql.append("             AND " + tblAllDataByCostObj + ".FCostCenterID = sumHour.FCostCenterID \n");
            sql.append("             AND " + tblAllDataByCostObj + ".FCostObjectID = sumHour.FCostObjectID) \n");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update " + tblAllDataByCostObj + " \n");
            sql.append("    set FCoef = 0; \n");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update " + tblAllDataByCostObj + " \n");
            sql.append("    set FCoef = (select ISNULL(Fcoefficient,0) \n");
            sql.append("                        from T_NCM_EquiCoefIntegrated \n");
            sql.append("                       where FCompanyID = " + tblAllDataByCostObj + ".FCompanyID \n");
            sql.append("                         and FCalculatePeriodID = " + tblAllDataByCostObj + ".FCalculatePeriodID \n");
            sql.append("                         and FCostCenterID = " + tblAllDataByCostObj + ".FCostCenterID \n");
            sql.append("                         and FCostObjectID = " + tblAllDataByCostObj + ".FCostObjectID)\n");
            sql.append("  where exists \n");
            sql.append("  (select 1 \n");
            sql.append("           from T_NCM_EquiCoefIntegrated \n");
            sql.append("          where FCompanyID = " + tblAllDataByCostObj + ".FCompanyID \n");
            sql.append("            and FCalculatePeriodID = " + tblAllDataByCostObj + ".FCalculatePeriodID \n");
            sql.append("            and FCostCenterID = " + tblAllDataByCostObj + ".FCostCenterID \n");
            sql.append("            and FCostObjectID = " + tblAllDataByCostObj + ".FCostObjectID) \n");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("  UPDATE " + tblAllDataByCostObj + " \n");
            sql.append("  SET    FFinishedHour = CASE  \n");
            sql.append("                         WHEN ISNULL(FEopWIPQty,0) * ISNULL(FCoef,1)+ ISNULL(FFinishedQty,0) = 0  \n");
            sql.append("                         THEN 0 \n");
            sql.append("                         ELSE round((ISNULL(FInputHour,0) + ISNULL(FBopWIPHour,0))* ISNULL(FFinishedQty,0)/ to_decimal((ISNULL(FEopWIPQty,0)* ISNULL(FCoef,1)+ ISNULL(FFinishedQty,0)),24,8), 2) \n");
            sql.append("                      END \n");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("  UPDATE " + tblAllDataByCostObj + " \n");
            sql.append("  SET    FEopWIPHour = isnull(FInputHour,0) + isnull(FBopWIPHour,0)- isnull(FFinishedHour,0) \n");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
    }

    private String getMatAllocStdDataTbl(Context ctx) throws BOSException, EASBizException {
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" CREATE TABLE calcSecTemp ");
        createTableSql.append("\t(");
        createTableSql.append("FSourceBillEntryID   VARCHAR(44),\t");
        createTableSql.append("FSumData\t\t\t    NUMERIC(28,16)\t");
        createTableSql.append(")");
        String tblName = null;
        try {
            String matAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_MatAllocResult");
            tblName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
            StringBuffer insertSum = new StringBuffer();
            insertSum.append("truncate table ").append(tblName).append(";").append('\n');
            insertSum.append("insert into ").append(tblName).append(" (FSourceBillEntryID, FSumData) (").append('\n').append(" select D.FSourceBillEntryID, ISNULL(SUM(D.FAllocStdData),1)As FSumData ").append('\n').append(" from ").append(matAllocResult).append(" AS D").append('\n').append(" where D.FIsDirect=0 ").append('\n').append(" GROUP BY D.FSourceBillEntryID").append('\n').append(" HAVING SUM(D.FAllocStdData) <> 0)").append(";").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)insertSum.toString(), (String)";");
        }
        catch (SQLException sqklEXC) {
            logger.error((Object)sqklEXC.getMessage(), (Throwable)sqklEXC);
            throw new BOSException((Throwable)sqklEXC);
        }
        catch (Exception Exc) {
            logger.error((Object)Exc.getMessage(), (Throwable)Exc);
            throw new BOSException((Throwable)Exc);
        }
        return tblName;
    }

    public LinkedList buildCostTaskEntries() {
        LinkedList<CostTaskEntryInfo> costTaskEntries = new LinkedList<CostTaskEntryInfo>();
        CostTaskEntryInfo calcStepInit = new CostTaskEntryInfo();
        this.setCostTaskEntryName(calcStepInit, "calcStepInit");
        calcStepInit.setTypeSeq(5110);
        calcStepInit.setSeq(0);
        calcStepInit.setProgress(1);
        calcStepInit.setResult(CostTaskResultEnum.NULL);
        calcStepInit.setLevel(1);
        calcStepInit.setLeaf(true);
        costTaskEntries.add(calcStepInit);
        this.costTaskEntryMap.put("calcStepInit", calcStepInit);
        CostTaskEntryInfo calcStepClear = new CostTaskEntryInfo();
        this.setCostTaskEntryName(calcStepClear, "calcStepClear");
        calcStepClear.setTypeSeq(5120);
        calcStepClear.setSeq(0);
        calcStepClear.setProgress(2);
        calcStepClear.setResult(CostTaskResultEnum.NULL);
        calcStepClear.setLevel(1);
        calcStepClear.setLeaf(true);
        costTaskEntries.add(calcStepClear);
        this.costTaskEntryMap.put("calcStepClear", calcStepClear);
        CostTaskEntryInfo calcStepGetData = new CostTaskEntryInfo();
        this.setCostTaskEntryName(calcStepGetData, "calcStepGetData");
        calcStepGetData.setTypeSeq(5200);
        calcStepGetData.setSeq(0);
        calcStepGetData.setProgress(2);
        calcStepGetData.setResult(CostTaskResultEnum.NULL);
        calcStepGetData.setLevel(1);
        calcStepGetData.setLeaf(true);
        costTaskEntries.add(calcStepGetData);
        this.costTaskEntryMap.put("calcStepGetData", calcStepGetData);
        CostTaskEntryInfo preCalOut = new CostTaskEntryInfo();
        this.setCostTaskEntryName(preCalOut, "preCalOut");
        preCalOut.setTypeSeq(5250);
        preCalOut.setSeq(0);
        preCalOut.setProgress(2);
        preCalOut.setResult(CostTaskResultEnum.NULL);
        preCalOut.setLevel(1);
        preCalOut.setLeaf(true);
        costTaskEntries.add(preCalOut);
        this.costTaskEntryMap.put("preCalOut", preCalOut);
        CostTaskEntryInfo calcStepAuxCalc = new CostTaskEntryInfo();
        this.setCostTaskEntryName(calcStepAuxCalc, "calcStepAuxCalc");
        calcStepAuxCalc.setTypeSeq(5300);
        calcStepAuxCalc.setSeq(0);
        calcStepAuxCalc.setProgress(3);
        calcStepAuxCalc.setResult(CostTaskResultEnum.NULL);
        calcStepAuxCalc.setLevel(1);
        calcStepAuxCalc.setLeaf(true);
        costTaskEntries.add(calcStepAuxCalc);
        this.costTaskEntryMap.put("calcStepAuxCalc", calcStepAuxCalc);
        CostTaskEntryInfo calcStepHour = new CostTaskEntryInfo();
        this.setCostTaskEntryName(calcStepHour, "calcStepHour");
        calcStepHour.setTypeSeq(5500);
        calcStepHour.setSeq(0);
        calcStepHour.setProgress(2);
        calcStepHour.setResult(CostTaskResultEnum.NULL);
        calcStepHour.setLevel(1);
        calcStepHour.setLeaf(true);
        costTaskEntries.add(calcStepHour);
        this.costTaskEntryMap.put("calcStepHour", calcStepHour);
        if (this.isCheckEopWipException) {
            CostTaskEntryInfo calcStepCheckEopWip = new CostTaskEntryInfo();
            this.setCostTaskEntryName(calcStepCheckEopWip, "calcStepCheckEopWip");
            calcStepCheckEopWip.setTypeSeq(5700);
            calcStepCheckEopWip.setSeq(0);
            calcStepCheckEopWip.setProgress(4);
            calcStepCheckEopWip.setResult(CostTaskResultEnum.NULL);
            calcStepCheckEopWip.setLevel(1);
            calcStepCheckEopWip.setLeaf(true);
            costTaskEntries.add(calcStepCheckEopWip);
            this.costTaskEntryMap.put("calcStepCheckEopWip", calcStepCheckEopWip);
        }
        if (this.isGenEopWipAdjust) {
            CostTaskEntryInfo calcStepGenEopWip = new CostTaskEntryInfo();
            this.setCostTaskEntryName(calcStepGenEopWip, "calcStepGenEopWip");
            calcStepGenEopWip.setTypeSeq(5800);
            calcStepGenEopWip.setSeq(0);
            calcStepGenEopWip.setProgress(4);
            calcStepGenEopWip.setResult(CostTaskResultEnum.NULL);
            calcStepGenEopWip.setLevel(1);
            calcStepGenEopWip.setLeaf(true);
            costTaskEntries.add(calcStepGenEopWip);
            this.costTaskEntryMap.put("calcStepGenEopWip", calcStepGenEopWip);
        }
        return costTaskEntries;
    }

    public LinkedList buildRankCostTaskEntries(int dispRank, int rank) {
        boolean isOutsourcCalc = false;
        try {
            isOutsourcCalc = NCMUtils.isDoOutSourcCalc((Context)this._ctx, (String)this._companyId);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        LinkedList<CostTaskEntryInfo> costTaskEntries = new LinkedList<CostTaskEntryInfo>();
        int seq = 0;
        CostTaskEntryInfo calcStepRankTop = new CostTaskEntryInfo();
        this.setCostTaskEntryName(calcStepRankTop, "calcStepRankTop", new Object[]{dispRank});
        calcStepRankTop.setTypeSeq(5400 + dispRank);
        calcStepRankTop.setSeq(seq++);
        calcStepRankTop.setResult(CostTaskResultEnum.NULL);
        calcStepRankTop.setLevel(1);
        calcStepRankTop.setLeaf(false);
        costTaskEntries.add(calcStepRankTop);
        this.costTaskEntryMap.put("calcStepRankTop" + dispRank, calcStepRankTop);
        CostTaskEntryInfo calcStepRankWip = new CostTaskEntryInfo();
        this.setCostTaskEntryName(calcStepRankWip, "calcStepRankWip");
        calcStepRankWip.setTypeSeq(5400 + dispRank);
        calcStepRankWip.setSeq(seq++);
        calcStepRankWip.setProgress(3);
        calcStepRankWip.setResult(CostTaskResultEnum.NULL);
        calcStepRankWip.setLevel(2);
        calcStepRankWip.setLeaf(true);
        costTaskEntries.add(calcStepRankWip);
        this.costTaskEntryMap.put("calcStepRankWip" + dispRank, calcStepRankWip);
        CostTaskEntryInfo calcStepRankClassCalc = new CostTaskEntryInfo();
        this.setCostTaskEntryName(calcStepRankClassCalc, "calcStepRankClassCalc");
        calcStepRankClassCalc.setTypeSeq(5400 + dispRank);
        calcStepRankClassCalc.setSeq(seq++);
        calcStepRankClassCalc.setProgress(3);
        calcStepRankClassCalc.setResult(CostTaskResultEnum.NULL);
        calcStepRankClassCalc.setLevel(2);
        calcStepRankClassCalc.setLeaf(true);
        costTaskEntries.add(calcStepRankClassCalc);
        this.costTaskEntryMap.put("calcStepRankClassCalc" + dispRank, calcStepRankClassCalc);
        CostTaskEntryInfo calcStepRankCalIn = new CostTaskEntryInfo();
        this.setCostTaskEntryName(calcStepRankCalIn, "calcStepRankCalIn");
        calcStepRankCalIn.setTypeSeq(5400 + dispRank);
        calcStepRankCalIn.setSeq(seq++);
        calcStepRankCalIn.setProgress(3);
        calcStepRankCalIn.setResult(CostTaskResultEnum.NULL);
        calcStepRankCalIn.setLevel(2);
        calcStepRankCalIn.setLeaf(true);
        costTaskEntries.add(calcStepRankCalIn);
        this.costTaskEntryMap.put("calcStepRankCalIn" + dispRank, calcStepRankCalIn);
        if (rank > 0) {
            CostTaskEntryInfo calcStepRankCalOut = new CostTaskEntryInfo();
            this.setCostTaskEntryName(calcStepRankCalOut, "calcStepRankCalOut");
            calcStepRankCalOut.setTypeSeq(5400 + dispRank);
            calcStepRankCalOut.setSeq(seq++);
            calcStepRankCalOut.setProgress(3);
            calcStepRankCalOut.setResult(CostTaskResultEnum.NULL);
            calcStepRankCalOut.setLevel(2);
            calcStepRankCalOut.setLeaf(true);
            costTaskEntries.add(calcStepRankCalOut);
            this.costTaskEntryMap.put("calcStepRankCalOut" + dispRank, calcStepRankCalOut);
        }
        if (isOutsourcCalc) {
            CostTaskEntryInfo outsourcCalcIn = new CostTaskEntryInfo();
            this.setCostTaskEntryName(outsourcCalcIn, "calcStepRankOutsourcCalcIn");
            outsourcCalcIn.setTypeSeq(5400 + dispRank);
            outsourcCalcIn.setSeq(seq++);
            outsourcCalcIn.setProgress(3);
            outsourcCalcIn.setResult(CostTaskResultEnum.NULL);
            outsourcCalcIn.setLevel(2);
            outsourcCalcIn.setLeaf(true);
            costTaskEntries.add(outsourcCalcIn);
            this.costTaskEntryMap.put("outsourcCalcIn" + dispRank, outsourcCalcIn);
            if (rank > 0) {
                CostTaskEntryInfo outsourcCalcOut = new CostTaskEntryInfo();
                this.setCostTaskEntryName(outsourcCalcOut, "calcStepRankOutsourcCalcOut");
                outsourcCalcOut.setTypeSeq(5400 + dispRank);
                outsourcCalcOut.setSeq(seq++);
                outsourcCalcOut.setProgress(3);
                outsourcCalcOut.setResult(CostTaskResultEnum.NULL);
                outsourcCalcOut.setLevel(2);
                outsourcCalcOut.setLeaf(true);
                costTaskEntries.add(outsourcCalcOut);
                this.costTaskEntryMap.put("outsourcCalcOut" + dispRank, outsourcCalcOut);
            }
        }
        if (rank > 0) {
            CostTaskEntryInfo calcStepRankSecAlloc = new CostTaskEntryInfo();
            this.setCostTaskEntryName(calcStepRankSecAlloc, "calcStepRankSecAlloc");
            calcStepRankSecAlloc.setTypeSeq(5400 + dispRank);
            calcStepRankSecAlloc.setSeq(seq++);
            calcStepRankSecAlloc.setProgress(3);
            calcStepRankSecAlloc.setResult(CostTaskResultEnum.NULL);
            calcStepRankSecAlloc.setLevel(2);
            calcStepRankSecAlloc.setLeaf(true);
            costTaskEntries.add(calcStepRankSecAlloc);
            this.costTaskEntryMap.put("calcStepRankSecAlloc" + dispRank, calcStepRankSecAlloc);
        }
        return costTaskEntries;
    }

    private void addRankCostTaskEntries(int lowest) throws EASBizException, BOSException {
        CostTaskExecutor executor = this.getCostTaskExecutor();
        if (executor != null) {
            int dispRank = 0;
            LinkedList costTaskEntries = new LinkedList();
            for (int rank = lowest; rank >= 0; --rank) {
                LinkedList list = this.buildRankCostTaskEntries(++dispRank, rank);
                costTaskEntries.addAll(list);
            }
            if (costTaskEntries.size() > 0) {
                executor.addCostTaskEntries(costTaskEntries);
            }
        }
    }

    private void setCostTaskEntryName(CostTaskEntryInfo costTaskEntry, String resName) {
        this.setCostTaskEntryName(costTaskEntry, resName, null);
    }

    private void setCostTaskEntryName(CostTaskEntryInfo costTaskEntry, String resName, Object[] params) {
        if (params == null) {
            costTaskEntry.setName(this.getResource(resName, NCMConst.l1), NCMConst.l1);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l2), NCMConst.l2);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l3), NCMConst.l3);
        } else {
            costTaskEntry.setName(this.getResource(resName, NCMConst.l1, params), NCMConst.l1);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l2, params), NCMConst.l2);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l3, params), NCMConst.l3);
        }
    }

    private void updateCostCalEntryRunning(Context ctx, String entryKey) throws BOSException, EASBizException {
        this.updateCostCalEntry(ctx, entryKey, CostTaskStatusEnum.RUNNING, null, CostTaskUtils.getCurrentTime((Context)ctx), -1L);
    }

    private void updateCostCalEntryFinished(Context ctx, String entryKey) throws BOSException, EASBizException {
        this.updateCostCalEntryFinished(ctx, entryKey, CostTaskResultEnum.SUCCESS);
    }

    private void updateCostCalEntryFinished(Context ctx, String entryKey, CostTaskResultEnum result) throws BOSException, EASBizException {
        this.updateCostCalEntry(ctx, entryKey, CostTaskStatusEnum.FINISHED, result, -1L, CostTaskUtils.getCurrentTime((Context)ctx));
    }

    private void updateCostCalEntry(Context ctx, String entryKey, CostTaskStatusEnum status, CostTaskResultEnum result, long beginTime, long endTime) throws BOSException, EASBizException {
        CostTaskEntryInfo entry = (CostTaskEntryInfo)this.costTaskEntryMap.get(entryKey);
        CostTaskExecutor executor = this.getCostTaskExecutor();
        if (entry != null && executor != null) {
            if (status != null) {
                entry.setStatus(status);
            }
            if (result != null) {
                entry.setResult(result);
            }
            if (beginTime > 0L) {
                entry.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)ctx)));
            }
            if (endTime > 0L) {
                entry.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)ctx)));
            }
            executor.updateCostTaskEntry(entry);
        }
    }

    private void updateJobStatus(int progress, String resName) throws BOSException {
        if (this.jobInstId != null) {
            JobInstStatusFacadeFactory.getLocalInstance((Context)this._ctx).updateProgress(this.jobInstId, 5, this.getResource(resName, NCMConst.l1), this.getResource(resName, NCMConst.l2), this.getResource(resName, NCMConst.l3));
        }
    }

    protected String getResource(String resName, Locale locale) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)locale);
    }

    protected String getResource(String resName, Locale locale, Object[] params) {
        String str = ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)locale);
        if (params != null) {
            str = MessageFormat.format(str, params);
        }
        return str;
    }

    private void outsourcCalcIn(int rank, int dispRank) throws EASBizException, BOSException {
        CalculateParams params = new CalculateParams();
        params.setString("COMPANY_ID", this._companyId);
        PeriodInfo periodInfo = NCMUtils.GetCurrentPeriod((Context)this._ctx, (String)this._companyId);
        params.setInt("PERIOD_FROM", periodInfo.getNumber());
        params.setInt("PERIOD_TO", periodInfo.getNumber());
        CostDataCache costDataCache = (CostDataCache)this._param.get("CostDataCache");
        try {
            String T_TMP_CostObject = costDataCache.getCostObjectTable();
            StringBuffer sql = new StringBuffer();
            sql.append("Select DISTINCT RE.FCostObjectID FMaterialID ").append('\n').append("FROM T_CAL_CostObjectRank R ").append('\n').append("INNER JOIN T_CAL_CostObjectRankEntry RE ON RE.FParentID= R.FID ").append('\n').append("Left JOIN ").append(T_TMP_CostObject).append(" co ON co.FMaterialID = re.FcostObjectID ").append("WHERE R.FCompanyOrg='").append(this._companyId).append("' AND R.FCalculatePeriod='").append(this._periodId).append("'").append('\n').append("\t  AND R.FLlcType=0 AND RE.FRank=").append(rank).append('\n').append("     AND co.FCostObjectID is null ").append('\n');
            IRowSet rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)sql.toString());
            params.setObject("rowset", (Object)rs);
            if (rs != null && rs.size() > 0) {
                DevolveCostCalculateFacadeFactory.getLocalInstance((Context)this._ctx).costCalculate(params);
            }
            String status = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Sucess");
            this._log.AddCalcLog(dispRank, "", CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_outsourcCalcIn"), status, "", false, "outsourcCalcIn", 4);
        }
        catch (Exception e) {
            String status = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Fail");
            this._log.AddCalcLog(dispRank, "", CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_outsourcCalcIn"), status, "", false, "outsourcCalcIn", 4);
            throw new BOSException((Throwable)e);
        }
    }

    private void outsourcCalcOut(int rank, int dispRank) throws BOSException {
        if (rank == 0) {
            return;
        }
        CostDataCache costDataCache = (CostDataCache)this._param.get("CostDataCache");
        String T_TMP_CostObject = null;
        try {
            T_TMP_CostObject = costDataCache.getCostObjectTable();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        boolean isSuccess = false;
        String status = null;
        String materialIdTempTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this._ctx);
        String createMaterialTempSql = "create table t_ncm_materialRange (fmaterialid varchar(44))";
        String attachment = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_SeeReport");
        try {
            materialIdTempTableName = pool.createTempTable(createMaterialTempSql);
            StringBuffer sql = new StringBuffer();
            sql.append(" Delete From ").append(materialIdTempTableName).append(" \n");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" Insert Into ").append(materialIdTempTableName).append(" (FMaterialID) \n").append("Select DISTINCT RE.FCostObjectID FMaterialID ").append('\n').append("FROM T_CAL_CostObjectRank R ").append('\n').append("INNER JOIN T_CAL_CostObjectRankEntry RE ON RE.FParentID= R.FID ").append('\n').append("Left JOIN ").append(T_TMP_CostObject).append(" co ON co.FMaterialID = re.FcostObjectID ").append("WHERE R.FCompanyOrg='").append(this._companyId).append("' AND R.FCalculatePeriod='").append(this._periodId).append("'").append('\n').append("\t  AND R.FLlcType=0 AND RE.FRank=").append(rank).append('\n').append("     AND co.FCostObjectID is null ").append('\n');
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            NCMDbUtil.analyzeTempTable((Context)this._ctx, (String)materialIdTempTableName);
            ICalculateFacade ida = CalculateFacadeFactory.getLocalInstance((Context)this._ctx);
            CalculateParams cps = ida.costCalculate(this.getFilterParam(this._ctx, this._companyId, materialIdTempTableName));
            if (cps != null) {
                isSuccess = cps.getBoolean("boolean");
            }
            status = isSuccess ? CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Sucess") : CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Fail");
            this._log.AddCalcLog(dispRank, "", CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_outsourcCalcOut"), status, attachment, false, "outsourcCalcOut", 5);
        }
        catch (Exception e) {
            status = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Fail");
            this._log.AddCalcLog(dispRank, "", CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_outsourcCalcOut"), status, attachment, false, "outsourcCalcOut", 5);
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (materialIdTempTableName != null) {
                    pool.releaseTable(materialIdTempTableName);
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void preCalcOut() throws BOSException {
        String materialIdTempTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this._ctx);
        StringBuffer sql = new StringBuffer();
        String status = null;
        try {
            sql.append("create table t_ncm_materialRange (fmaterialid varchar(44))");
            materialIdTempTableName = pool.createTempTable(sql.toString());
            sql.setLength(0);
            sql.append("insert into ").append(materialIdTempTableName).append("(fmaterialid)");
            sql.append(" (select distinct entry.fmaterialid from ").append("\r\n");
            sql.append("  T_IM_MATERIALREQBILLENTRY entry ").append("\r\n");
            sql.append(" inner join T_IM_MATERIALREQBILL bill on bill.fid = entry.fparentid ").append("\r\n");
            sql.append(" inner join T_SCM_TransactionType trans on trans.fid = bill.FTRANSACTIONTYPEID ").append("\r\n");
            sql.append(" inner join t_bd_period period on period.FPERIODYEAR = bill.fyear and period.FPERIODNUMBER = bill.fperiod").append("\r\n");
            sql.append(" inner join t_bd_materialcompanyinfo mat on mat.FMATERIALID = entry.fmaterialid and mat.FCOMPANYID = entry.FCOMPANYORGUNITID ").append("\r\n");
            sql.append("   and mat.FCALCULATETYPE = 2 \r\n");
            sql.append(" where bill.FBASESTATUS = 4 and trans.FISMANUCOSTCALCULATE = 1 \r\n");
            sql.append(" and period.fid ='").append(this._periodId).append("' \r\n");
            sql.append(" and entry.FCOMPANYORGUNITID ='").append(this._companyId).append("' \r\n");
            sql.append(" and NOT EXISTS (select 1 from T_NCM_WIPCOUNTINGBILL wip  \r\n");
            sql.append("    inner join T_BD_COSTOBJECT obj on wip.fcostobjectid = obj.fid  \r\n");
            sql.append("    inner join T_BD_COSTOBJECTENTRY objEntry on objEntry.fparentid = obj.fid  \r\n");
            sql.append("    where  wip.FCALCULATEPERIOD ='").append(this._periodId).append("' \r\n");
            sql.append(" \tand wip.FCOMPANYORG ='").append(this._companyId).append("' \r\n");
            sql.append(" \tand wip.FMANUOVERQTRY <> 0 ").append(" \r\n");
            sql.append(" \tand objEntry.FRELATEDID = entry.fmaterialid ) ").append(" \r\n");
            sql.append("  ) ").append(" \r\n");
            NCMDbUtil.execute((Context)this._ctx, (String)sql.toString());
            NCMDbUtil.analyzeTempTable((Context)this._ctx, (String)materialIdTempTableName);
            ICalculateFacade ida = CalculateFacadeFactory.getLocalInstance((Context)this._ctx);
            CalculateParams cps = ida.costCalculate(this.getFilterParam(this._ctx, this._companyId, materialIdTempTableName));
            Boolean isSuccess = false;
            if (cps != null) {
                isSuccess = cps.getBoolean("boolean");
            }
            status = isSuccess != false ? CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Sucess") : CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Fail");
            if (materialIdTempTableName == null) return;
        }
        catch (Exception e) {
            try {
                status = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Fail");
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (materialIdTempTableName == null) throw throwable;
                pool.releaseTable(materialIdTempTableName);
                throw throwable;
            }
        }
        pool.releaseTable(materialIdTempTableName);
        return;
    }
}

