/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Calc.Helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CalcLogCollection;
import com.kingdee.eas.ncm.cal.CalcLogFactory;
import com.kingdee.eas.ncm.cal.CalcLogLevelEnum;
import com.kingdee.eas.ncm.cal.CheckCalTypeEnum;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.utils.NCMCommonParams;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.Assert;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalcExceptionLog {
    private Context _ctx = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _userId = null;
    private Map param = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.app.Calc.Helper.CalcExceptionLog");

    public CalcExceptionLog(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("ctx"));
        this._companyId = (String)param.get("companyId");
        this._periodId = (String)param.get("periodId");
        this._ctx = (Context)param.get("ctx");
        this._userId = (String)param.get("userId");
        this.param = param;
        this.ClearPreCalcLog();
    }

    public CalcExceptionLog(NCMCommonParams param) throws BOSException {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("ctx"));
        this._companyId = param.getCOMPANY_ID();
        this._periodId = param.getPERIOD_ID();
        this._ctx = param.getCTX();
        this._userId = param.getUSER_ID();
        this.ClearPreCalcLog();
    }

    private void ClearPreCalcLog() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM T_NCM_CalcLogEntry WHERE EXISTS( ").append("\tSelect 1 ").append("\tFROM T_NCM_CalcLog L ").append("\tWHERE L.FID=T_NCM_CalcLogEntry.FParentID AND L.FCompanyID='").append(this._companyId).append("' AND L.FPeriodId='").append(this._periodId).append("' ").append(");").append("DELETE FROM T_NCM_CalcLog WHERE FCompanyID='").append(this._companyId).append("' AND FPeriodId='").append(this._periodId).append("';");
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";");
    }

    public void AddCalcLog(int dispRank, String costObjectDispName, String calcItem, String status, String attachment, boolean hasDetailLog, String costObjectID, int sort) throws BOSException {
        String rankStr = MessageFormat.format(CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Rank"), String.valueOf(dispRank));
        int hasDetail = 0;
        if (hasDetailLog) {
            hasDetail = 1;
        }
        this._writeLog(rankStr, costObjectDispName, calcItem, status, attachment, hasDetail, costObjectID, sort);
    }

    public void AddCalcDetailLog(StringBuffer sb, String costObjectID, String allocErrorInfo, String possibleReason, String adviceHandle, CheckCalTypeEnum calcItemType) {
        this.AddCalcDetailLog(sb, costObjectID, allocErrorInfo, possibleReason, adviceHandle, calcItemType, CalcLogLevelEnum.DEFAULT);
    }

    public void AddCalcDetailLog(StringBuffer sb, String costObjectID, String allocErrorInfo, String possibleReason, String adviceHandle, CheckCalTypeEnum calcItemType, CalcLogLevelEnum calcLogLevel) {
        sb.append("INSERT INTO T_NCM_CalcLogEntry(FID,FParentId,FErrorInfo,FPossibleReason,FAdviceHandle,FCalcItemType) ").append('\n').append(" SELECT newbosid('221EA50B')As FID,S.FID As FParentId,'").append(allocErrorInfo).append("','").append(possibleReason).append("','").append(adviceHandle).append("', ").append(calcItemType.getValue()).append(" FROM T_NCM_CalcLog S ").append(" WHERE FCostObjectID='").append(costObjectID).append("'").append(" AND FLevel = ").append(calcLogLevel.getValue()).append(";");
    }

    public void AddCalcLog_Head(int dispRank, String costObjectID) throws BOSException {
        String rankStr = MessageFormat.format(CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Rank"), String.valueOf(dispRank));
        this._writeLog(rankStr, "", CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_CostCal"), CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_BeginCal"), "", 0, costObjectID, 0);
    }

    public void AddCalcLog_PreSet(Context ctx, int rank, int DispRank) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String rankStr = MessageFormat.format(CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Rank"), String.valueOf(DispRank));
        String calcItem = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_AllocWIP");
        String status = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Sucess");
        Locale locale = ctx.getLocale();
        boolean isOutsourcCalc = NCMUtils.isDoOutSourcCalc((Context)this._ctx, (String)this._companyId);
        if (isOutsourcCalc) {
            CostDataCache costDataCache = (CostDataCache)this.param.get("CostDataCache");
            String T_TMP_CostObject = null;
            try {
                T_TMP_CostObject = costDataCache.getCostObjectTable();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            sb.append("INSERT INTO T_NCM_CalcLog (FID,FCompanyID,FPeriodId,FCreatorID,FCreateTime,").append("\tFCalcRank,FCostObjectDispName,FCalcItem,FStatus,FAttachment,FHasDetailLog,FCostObjectID,FLevel)").append('\n').append("SELECT newbosid('01C8A3A7'),'").append(this._companyId).append("' As FCompanyID,'").append(this._periodId).append("' As FPeriodId,").append("\t'").append(this._userId).append("' As FCreatorID, GetDate(),").append("\t'").append(rankStr).append("' As FCalcRank, SUBT.FCostObjectDispName,").append("\t'").append(calcItem).append("' As FCalcItem,'").append(status).append("' As FStatus,'' As FAttachment, 0 As FHasDetailLog, SUBT.FCostObjectID, ").append(CalcLogLevelEnum.DEFAULT.getValue()).append(" AS FLevel ").append('\n').append(" FROM ").append('\n').append(" (SELECT DISTINCT CO.FID FCOSTOBJECTID ,CO.FName_" + locale + " ||'('||CO.FNumber||')' As FCostObjectDispName ,B.FRank , CO.FNumber").append('\n').append(" FROM T_CAL_CostObjectRank A ").append('\n').append(" LEFT OUTER JOIN T_CAL_CostObjectRankENTRY B ON A.FID = B.FPARENTID").append(" INNER JOIN ").append(T_TMP_CostObject).append(" O ON O.FMaterialID = B.FCostObjectID and O.FIsMainProduct = 1").append('\n').append(" INNER JOIN T_BD_CostObject CO ON CO.FID=O.FCostObjectID AND CO.FCompanyID=A.FCOMPANYORG ").append('\n').append(" WHERE A.FLlcType=0 AND A.FBillStatus =4 AND B.FRank =").append(String.valueOf(rank)).append(" \tAND A.FCOMPANYORG =? AND A.FCalculatePeriod =? ").append(" ) AS SUBT ").append('\n').append(" ORDER BY SUBT.FRank DESC, SUBT.FNumber ");
        } else {
            sb.append("INSERT INTO T_NCM_CalcLog (FID,FCompanyID,FPeriodId,FCreatorID,FCreateTime,").append("\tFCalcRank,FCostObjectDispName,FCalcItem,FStatus,FAttachment,FHasDetailLog,FCostObjectID,FLevel)").append('\n').append("SELECT newbosid('01C8A3A7'),'").append(this._companyId).append("' As FCompanyID,'").append(this._periodId).append("' As FPeriodId,").append("\t'").append(this._userId).append("' As FCreatorID, GetDate(),").append("\t'").append(rankStr).append("' As FCalcRank, SUBT.FCostObjectDispName,").append("\t'").append(calcItem).append("' As FCalcItem,'").append(status).append("' As FStatus,'' As FAttachment, 0 As FHasDetailLog, SUBT.FCostObjectID, ").append(CalcLogLevelEnum.DEFAULT.getValue()).append(" AS FLevel ").append('\n').append(" FROM ").append('\n').append(" (SELECT DISTINCT B.FCostObjectID ,CO.FName_" + locale + " ||'('||CO.FNumber||')' As FCostObjectDispName ,B.FRank , CO.FNumber").append('\n').append(" FROM T_CAL_CostObjectRank A ").append('\n').append(" LEFT OUTER JOIN T_CAL_CostObjectRankENTRY B ON A.FID = B.FPARENTID").append(" INNER JOIN T_BD_CostObject CO ON CO.FID=B.FCostObjectID AND CO.FCompanyID=A.FCOMPANYORG ").append('\n').append(" WHERE A.FLlcType=0 AND A.FBillStatus =4 AND B.FRank =").append(String.valueOf(rank)).append(" \tAND A.FCOMPANYORG =? AND A.FCalculatePeriod =? ").append(" ) AS SUBT ").append('\n');
        }
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Object[])new String[]{this._companyId, this._periodId});
        sb.setLength(0);
        sb.append("INSERT INTO T_NCM_CalcLog (").append('\n').append("\tFID,FCompanyID,FPeriodId,FCreatorID,FCreateTime,").append('\n').append("\tFCalcRank,FCostObjectDispName,FCalcItem,FStatus,").append('\n').append("\tFAttachment,FHasDetailLog,FCostObjectID,FLevel").append('\n').append(")").append('\n').append("SELECT ").append("\tnewbosid('01C8A3A7'),cl.FCompanyID,cl.FPeriodId,cl.FCreatorID,cl.FCreateTime,").append('\n').append("\tcl.FCalcRank,cl.FCostObjectDispName,'" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"58_CalcExceptionLog", (Locale)ctx.getLocale()) + "',cl.FStatus,").append('\n').append("\tcl.FAttachment,cl.FHasDetailLog,cl.FCostObjectID,").append(CalcLogLevelEnum.ClassiCO.getValue()).append(" AS FLevel ").append('\n').append("FROM T_NCM_CalcLog cl ").append('\n').append("JOIN T_BD_CostObject co ON  co.FID = cl.FCostObjectID").append('\n').append("WHERE").append('\n').append("\tcl.FCompanyId = ? AND cl.FPeriodId = ?").append('\n').append("   AND co.FCalculateMode = ").append(3).append('\n').append("\tAND cl.FCalcRank = '").append(rankStr).append("'").append('\n').append("").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Object[])new String[]{this._companyId, this._periodId});
    }

    public void UpdatePreSetCalcLog(int dispRank) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String rankStr = MessageFormat.format(CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Rank"), String.valueOf(dispRank));
        String status = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_Fail");
        String attachment = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_ErrorLog");
        sb.append("UPDATE T_NCM_CalcLog AS D SET (FStatus,FAttachment,FHasDetailLog ,FCalcItem)=(").append("\tSelect top 1 '").append(status).append("' As FStatus,'").append(attachment).append("' As FAttachment,1 ").append("   , CASE S.FCalcItemType WHEN 3 THEN '").append(CheckCalTypeEnum.ALLOCWIP.getAlias()).append("   ' WHEN 4 THEN D.FCalcItem").append("    ELSE '").append(CheckCalTypeEnum.factCostCal.getAlias()).append("' END ").append("  FROM T_NCM_CalcLogEntry S ").append("  WHERE S.FParentId=D.FID ").append(" ) ").append("WHERE D.FCalcRank='").append(rankStr).append("' AND D.FCompanyID='").append(this._companyId).append("' AND D.FPeriodId='").append(this._periodId).append("' ");
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString());
    }

    public CalcLogCollection GetCalcLogData() {
        try {
            return CalcExceptionLog.GetCalcLogData(this._ctx, this._companyId, this._periodId);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            return null;
        }
    }

    public static CalcLogCollection GetCalcLogData(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT calcRank, costObjectDispName, calcItem, status, attachment, hasDetailLog, createTime, sort,").append("entries.*, company.*, period.*, creator.* ").append("WHERE company.id = '").append(companyId).append("' AND period.id='").append(periodId).append("'").append(" order by calcRank, sort, costObjectDispName, level, entries.errorInfo ");
        return CalcLogFactory.getLocalInstance(ctx).getCalcLogCollection(sb.toString());
    }

    private void _writeLog(String calcRank, String costObjectDispName, String calcItem, String status, String attachment, int hasDetailLog, String costObjectId, int sort) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO T_NCM_CalcLog (FID,FCompanyID,FPeriodId,FCreatorID,FCreateTime,").append("\tFCalcRank,FCostObjectDispName,FCalcItem,FStatus,FAttachment,FHasDetailLog,FCostObjectID,FSort)").append(" SELECT newbosid('01C8A3A7'),SUBT.* ").append('\n').append(" FROM ( SELECT DISTINCT '").append(this._companyId).append("' A,'").append(this._periodId).append("' B,'").append(this._userId).append("' C,GetDate() D,'").append(calcRank).append("' E,'").append(costObjectDispName).append("' F,'").append(calcItem).append("' G,'").append(status).append("' H,'").append(attachment).append("' I,").append(hasDetailLog).append(" J,'").append(costObjectId).append("' K,").append(String.valueOf(sort)).append(" L ").append('\n').append(" FROM T_NCM_CalcLog WHERE NOT EXISTS ").append('\n').append("( SELECT 1 FROM T_NCM_CalcLog WHERE FCalcRank = '" + calcRank + "' and FCompanyId =? AND FPeriodId = ? AND FCostObjectID = ? ").append(" AND FCostObjectID is not null ) ").append(" ) AS SUBT ").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString(), (Object[])new String[]{this._companyId, this._periodId, costObjectId});
    }
}

