/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Calc.classiCOAlloc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.ncm.utils.BDCMConst;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.cal.CalcLogLevelEnum;
import com.kingdee.eas.ncm.cal.CheckCalTypeEnum;
import com.kingdee.eas.ncm.cal.app.Calc.AllocWIP.data.AllocStdSet;
import com.kingdee.eas.ncm.cal.app.Calc.Helper.CalcExceptionLog;
import com.kingdee.eas.ncm.cal.app.Calc.classiCOAlloc.AllocClassiCOTable;
import com.kingdee.eas.ncm.cal.app.Calc.classiCOAlloc.ClassiCOAUSContext;
import com.kingdee.eas.ncm.cal.app.Calc.classiCOAlloc.IAllocClassiCO;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.app.CalcTable;
import com.kingdee.eas.ncm.common.utils.NCMCommonParams;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AllocClassiCOImpl
implements IAllocClassiCO {
    private static Logger logger = Logger.getLogger((String)AllocClassiCOImpl.class.getName());
    private NCMCommonParams _ncmCommonParamsparam = null;
    private int _rank = -1;
    private Context _ctx;
    private String _companyId;
    private String _periodId;
    private String _userId;
    private CalcExceptionLog _log;
    private String _CU;
    private CalcTable _calcTable;
    private static final char CLF = '\n';
    protected ClassiCOAUSContext _ausCtx;
    protected Connection _globalConnection = null;

    public AllocClassiCOImpl(NCMCommonParams param) {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("ctx"));
        Assert.that((boolean)param.containsKey("calcTable"));
        Assert.that((boolean)param.containsKey("log"));
        Assert.that((boolean)param.containsKey("CU"));
        this._ncmCommonParamsparam = param;
        this._companyId = param.getCOMPANY_ID();
        this._periodId = param.getPERIOD_ID();
        this._userId = param.getUSER_ID();
        this._ctx = param.getCTX();
        this._calcTable = param.getCALC_TABLE();
        this._log = param.getLOG();
        this._CU = param.getCU();
        this._ncmCommonParamsparam.setALLOC_STD_TYPE(AllocStdTypeEnum.CLASSI);
        this._ncmCommonParamsparam.setCALC_TABLE(this._calcTable);
        this._ausCtx = new ClassiCOAUSContext(this._ncmCommonParamsparam);
        this._globalConnection = (Connection)this._ncmCommonParamsparam.getGolbalConnection();
    }

    @Override
    public void setCalcRank(int rank) {
        this._rank = rank;
    }

    @Override
    public boolean doAllocClassiCO(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        boolean isCalcSuccess = true;
        try {
            StringBuffer ksql = new StringBuffer();
            ksql.append("select top 1 1 from ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" r ");
            ksql.append("join T_BD_CostObject co on co.FID = r.FCostObjectID ");
            ksql.append("where co.FCalculateMode = 3 and r.FCalcLevel = ").append(this._rank).append(" ");
            ksql.append("and r.FCompanyID = '").append(this._companyId).append("' ");
            ksql.append("and r.FCalculatePeriodID = '").append(this._periodId).append("'");
            IRowSet rowSet = NCMDbUtil.executeQueryNoTx((Context)this._ctx, (String)ksql.toString());
            if (rowSet.size() <= 0) {
                return true;
            }
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"47_AllocClassiCOImpl", (Locale)ctx.getLocale()));
            this.initDataSql_tempTblCostCalResult(sb);
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"48_AllocClassiCOImpl", (Locale)ctx.getLocale()));
            this.initDataSql_tempTblCostCalPrdDetailResult(sb);
            NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)" ;");
            sb.delete(0, sb.length());
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"49_AllocClassiCOImpl", (Locale)ctx.getLocale()));
            IRowSet classiStds = this.getAllocStdSetting();
            if (classiStds.size() == 0) {
                return isCalcSuccess;
            }
            AllocClassiCOTable allocTable = new AllocClassiCOTable(this._ncmCommonParamsparam);
            AllocStdSet allocList = new AllocStdSet(classiStds);
            allocList.First();
            while (!allocList.IsDone()) {
                String formulaForParse = allocList.getFormulaForParse();
                logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"50_AllocClassiCOImpl", (Locale)ctx.getLocale()));
                this._ausCtx.setStrategyContext(formulaForParse, (AllocTable)allocTable);
                logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"51_AllocClassiCOImpl", (Locale)ctx.getLocale()));
                String t_allocDataTable = this.initAllocDataTable(sb, allocList.getAllocStdId());
                logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"52_AllocClassiCOImpl", (Locale)ctx.getLocale()));
                this.updateAllocDataTable(sb, t_allocDataTable);
                NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";", (Connection)this._globalConnection);
                sb.delete(0, sb.length());
                NCMUtils.analyzeDBSystemTempTable((Context)this._ctx, (String)t_allocDataTable, (Connection)this._globalConnection);
                logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"53_AllocClassiCOImpl", (Locale)ctx.getLocale()));
                if (!this.checkInvalidAllocStdData()) {
                    return false;
                }
                NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)("UPDATE " + t_allocDataTable + " AS ADT SET  FAllocRatio = Round( FRatio / FRatioSum, 12);"), (Connection)this._globalConnection);
                logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"54_AllocClassiCOImpl", (Locale)ctx.getLocale()));
                this.adjustInvalidAllocStdData(sb);
                logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"55_AllocClassiCOImpl", (Locale)ctx.getLocale()));
                this.updateAllocStdDataToCalPrdDetailResult(sb);
                NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";", (Connection)this._globalConnection);
                sb.delete(0, sb.length());
                allocList.Next();
            }
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"56_AllocClassiCOImpl", (Locale)ctx.getLocale()));
            this.allocMainAndJoint(sb);
            NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";", (Connection)this._globalConnection);
            sb.delete(0, sb.length());
            this.adjDiffAmount();
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"57_AllocClassiCOImpl", (Locale)ctx.getLocale()));
            if (!this.checkInvalidFinishedAmount()) {
                isCalcSuccess = false;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (AllocateException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return isCalcSuccess;
    }

    @Override
    public void commitAllocResult() throws BOSException {
    }

    private void initDataSql_tempTblCostCalResult(StringBuffer sb) throws BOSException {
        sb.append('\n');
        sb.append("update " + this._calcTable.GetCostCalPrdDetailResultTable() + " \n");
        sb.append("set FTempAmount = FFinishedAmount \n");
        sb.append("where FCompanyID='" + this._companyId + "' ");
        sb.append("and FCalculatePeriodID='" + this._periodId + "' \n");
        sb.append("and FCalcLevel = " + this._rank + " \n");
        sb.append("and exists ( \n");
        sb.append("    select 1 from T_BD_CostObject co \n");
        sb.append("    where co.FCalculateMode = 3 \n");
        sb.append("    \n");
        sb.append("    and co.FID = " + this._calcTable.GetCostCalPrdDetailResultTable() + ".FCostObjectID \n");
        sb.append(") \n");
        sb.append("; \n");
        sb.append(" \n");
        sb.append('\n').append(" INSERT INTO ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append('\n').append(" ( ").append("FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FProductID ,FLot ,FCostItemID ,FAllocStdID ,FAllocStdData ,FFinishedQty ,FFinishedAmount ,FFinishedPrice ,FRecvAmount ,FTotalFinishedQty ,FVoucherid ,FCalcLevel, FTempAmount ").append(" )").append('\n').append(" SELECT ").append('\n').append(" newbosid('C4774737') ,A.FCompanyID ,A.FCalculatePeriodID ,A.FCostCenterID ,").append('\n').append(" A.FCostObjectID ,A.FProductID ,A.FLot , A.FCostItemID ,").append('\n').append(" A.FAllocStdID ,isnull(A.FAllocStdData,0) ,0 ,0 ,0 ,0 ,").append('\n').append(" A.FTotalFinishedQty ,' ' , ").append(this._rank).append('\n').append(" ,A.FTempAmount \n").append(" FROM ( SELECT distinct PR.FCompanyID ,PR.FCalculatePeriodID ,PR.FCostCenterID , ").append("  PR.FCostObjectID ,PR.FProductID ,PR.FLot , UC.FCostItemID ,PR.FAllocStdID ,PR.FAllocStdData ,PR.FTotalFinishedQty, PR.FTempAmount ").append(" FROM ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" AS PR ").append('\n').append(" INNER JOIN T_NCM_ByProductUnitCost AS UC ON UC.FCompanyID= PR.FCompanyID AND UC.FCalculatePeriodID=PR.FCalculatePeriodID ").append(" join t_bd_costobject coo on coo.fid = PR.FCostObjectID ").append('\n').append(" join t_bd_costobjectentry cooe on cooe.FparentID = coo.FID and cooe.FRelatedID = PR.FProductID ").append('\n').append("  ").append('\n').append(" where ").append("  PR.FCompanyID='").append(this._companyId).append("' and PR.FCalculatePeriodID='").append(this._periodId).append("'").append('\n').append("  AND PR.FCalcLevel = ").append(this._rank).append('\n').append("  AND coo.FCalculateMode = 3 and cooe.FIsByProduct = 1 ").append('\n').append("  AND UC.FUnitCost > 0 ").append('\n').append("  AND exists ( ").append('\n').append("      select 1 from " + this._calcTable.GetCostCalPrdDetailResultTable() + " pr2 \n").append('\n').append("      where pr2.FCompanyID='" + this._companyId + "' \n").append('\n').append("      and pr2.FCalculatePeriodID = '" + this._periodId + "' \n").append('\n').append("      and pr2.FCostCenterID = PR.FCostCenterID \n").append('\n').append("      and pr2.FCostObjectID = PR.FCostObjectID \n").append('\n').append("      and pr2.FCostItemID = UC.FCostItemID \n").append('\n').append("  ) ").append('\n').append("  AND not exists ( ").append('\n').append("      select 1 from " + this._calcTable.GetCostCalPrdDetailResultTable() + " pr2 \n").append('\n').append("      where pr2.FCompanyID='" + this._companyId + "' \n").append('\n').append("      and pr2.FCalculatePeriodID = '" + this._periodId + "' \n").append('\n').append("      and pr2.FCostCenterID = PR.FCostCenterID \n").append('\n').append("      and pr2.FCostObjectID = PR.FCostObjectID \n").append('\n').append("      and pr2.FCostItemID = UC.FCostItemID \n").append('\n').append("      and pr2.FProductID = PR.FProductID \n").append('\n').append("  ) ").append('\n').append(" ) AS A ").append(" ; ").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        sb.append("Create Table T (").append('\n');
        sb.append("    FAmount NUMERIC(17,4),FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),").append('\n');
        sb.append("    FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44))").append('\n');
        String tempTabl = NCMDbUtil.createTempTable((Context)this._ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("Insert Into ").append(tempTabl).append('\n');
        sb.append("    (FCompanyID,FCalculatePeriodID,FCostCenterID,").append('\n');
        sb.append("     FCostObjectID,FCostItemID,FAmount) ").append('\n');
        sb.append("Select ").append('\n');
        sb.append("     dbp.FCompanyID,dbp.FCalculatePeriodID,dbp.FcostCenterID,dbp.FCostObjectID,").append('\n');
        sb.append("     UC.FCostItemID,sum(dbp.FFinishedQty * UC.FUnitCost) AS FAmt").append('\n');
        sb.append("   FROM ").append(this._calcTable.GetDataByProductTable()).append(" dbp       ").append('\n');
        sb.append("   Inner JOIN  T_BD_CostObject AS  CO ON  CO.FID = dbp.FCostObjectID and  CO.FCompanyID= dbp.FCompanyID ").append('\n');
        sb.append("   AND isnull(co.FBatchNumber,'_')=Isnull(dbp.FLOT,'_')      ").append('\n');
        sb.append("   INNER JOIN T_BD_CostObjectEntry AS COE ON COE.FParentID = CO.FID     ").append('\n');
        sb.append("           AND COE.FRelatedID = dbp.FProductID                                       ").append('\n');
        sb.append("   INNER JOIN T_NCM_ByProductUnitCost AS UC ON UC.FCompanyID= dbp.FCompanyID ");
        sb.append("   AND UC.FCalculatePeriodID=dbp.FCalculatePeriodID  AND UC.FMaterialID = dbp.FProductID  ").append('\n');
        sb.append("   WHERE dbp.FCompanyID ='").append(this._companyId).append("' ").append('\n');
        sb.append("   AND dbp.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n');
        sb.append("   AND CO.FCalculateMode = ");
        sb.append(3).append('\n');
        sb.append("   AND COE.FIsByProduct = 1 ").append('\n');
        sb.append(" group by dbp.FCompanyID,dbp.FCalculatePeriodID, dbp.FcostCenterID,dbp.FCostObjectID, UC.FCostItemID ").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" AS PR SET (FFinishedAmount)=( ").append('\n').append(" SELECT  PR.FFinishedAmount - A.FAmount ").append('\n').append("  FROM ").append(tempTabl).append(" A").append('\n').append(" WHERE   A.FCompanyID ='").append(this._companyId).append("' AND  A.FCalculatePeriodID ='").append(this._periodId).append("'").append('\n').append(" AND A.FCompanyID =PR.FCompanyID AND A.FCalculatePeriodID=PR.FCalculatePeriodID ").append('\n').append(" AND A.FCostCenterID=PR.FCostCenterID AND A.FCostObjectID=PR.FCostObjectID AND A.FCostItemID=PR.FCostItemID ").append('\n').append(" AND PR.FCalcLevel = ").append(this._rank).append('\n').append(" ) ; ");
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)" ;");
        sb.delete(0, sb.length());
    }

    private void initDataSql_tempTblCostCalPrdDetailResult(StringBuffer sb) throws BOSException {
        sb.append("UPDATE ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" AS P SET (FAllocStdID)=(").append('\n').append("\tSELECT top 1 ST.FAllocStdID").append('\n').append("\tFROM T_NCM_AllocStdSetByClass ST ").append('\n').append(" \tINNER JOIN T_BD_CostObject CO ON  CO.FID = ST.FCostObjectID ").append('\n').append("\tWHERE ST.FCompanyID='").append(this._companyId).append("'  AND ST.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n').append("\t\tAND ST.FCostObjectID = P.FCostObjectID ").append('\n').append(" \tAND CO.FCalculateMode = ").append(3).append(" )").append('\n').append(";");
    }

    private IRowSet getAllocStdSetting() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("Select distinct STD.FFormulaForParse, STD.FID As FAllocStdID ").append("FROM T_NCM_AllocStd STD ").append("INNER JOIN ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" R ON R.FAllocStdID=STD.FID ").append(" WHERE STD.FAllocStdType = ").append(4);
        return NCMDbUtil.executeQueryNoTx((Context)this._ctx, (String)sb.toString());
    }

    private String initAllocDataTable(StringBuffer sb, String allocStdID) throws AllocateException {
        String fieldList = this._ausCtx.GetFieldListForQuery();
        String fldAstList = this._ausCtx.GetMergeFormatStr("0 As {0}", ",");
        String tblAllocData = this._calcTable.GetAllocDataTable(this._ausCtx.GetFieldListForCreateTbl());
        sb.append("truncate table  ").append(tblAllocData).append(";");
        sb.append("INSERT INTO ").append(tblAllocData).append("(FID,").append(fieldList).append("FRatio)").append('\n').append("Select S.FID,").append(fldAstList).append(" 0 As FRatio ").append('\n').append(" from ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append('\n').append(" as S Inner JOIN  T_BD_CostObject CO ON  CO.FID =S.FCostObjectID").append('\n').append(" Where FAllocStdID='").append(allocStdID).append("' ").append('\n').append(" AND CO.FCalculateMode = ").append(3).append(" AND FCalcLevel = ").append(this._rank).append(" and S.FProductID in (select FProductID from ").append(this._calcTable.GetDataByProductTable()).append(")").append('\n').append(";").append('\n');
        return tblAllocData;
    }

    private void updateAllocDataTable(StringBuffer sb, String t_AllocDataTable) throws AllocateException, BOSException {
        sb.append(this._ausCtx.GetAllocStdUnitDataSql());
        sb.append('\n');
        sb.append(this._ausCtx.GetAllocStdFormulaUpdateSql()).append("; ").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";", (Connection)this._globalConnection);
        sb.delete(0, sb.length());
        StringBuffer createsql = new StringBuffer();
        createsql.append(" create table temp (FRatio NUMERIC(24,10) default 0,FCompanyID varchar(44),");
        createsql.append(" FCalculatePeriodID varchar(44),FCostCenterID varchar(44),FCostObjectID varchar(44))");
        String tempTable = NCMDbUtil.createTempTable((Context)this._ctx, (String)createsql.toString());
        NCMDbUtil.createTempTableIndex((Context)this._ctx, (String)tempTable, (String)"FCompanyID,FCalculatePeriodID,FCostCenterID,FCostObjectID", (boolean)false, (boolean)false);
        createsql.setLength(0);
        createsql.append(" insert into ").append(tempTable).append("(FRatio,FCompanyID,FCalculatePeriodID,FCostCenterID,FCostObjectID)");
        createsql.append("\t\tSELECT ISNULL(sum(A.FRatio),1) FRatio, FCompanyID,FCalculatePeriodID\t    \t").append('\n').append("\t\t\t  ,FCostCenterID,FCostObjectID \t\t\t\t\t\t\t\t\t\t\t\t").append('\n').append("\t\tFROM  (         \t\t                                                        ").append('\n').append("\t\t\t\t\tSelect distinct P.FCompanyID,P.FCalculatePeriodID   \t\t\t\t").append('\n').append("\t\t\t\t\t  ,P.FCostCenterID,P.FCostObjectID,P.FProductID,ad.Fratio \t\t    ").append('\n').append("\t\t\t\t\tFrom       ").append(t_AllocDataTable).append(" AD                  ").append('\n').append("\t\t\t\t\tInner join ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append("                         P on AD.FID =P.FID                                            ").append('\n').append("\t\t\t\t\tINNER JOIN T_BD_CostObject AS CO ON CO.FID = P.FCostObjectID      \t").append('\n').append("\t\t\t\t\tINNER JOIN T_BD_CostObjectEntry COE ON COE.FParentID =CO.FID \t\t").append('\n').append("\t\t\t\t\t \tAND COE.FIsByProduct=0\t\t\t\t\t\t\t\t\t\t\t").append('\n').append("\t\t\t\t\tWhere  AD.FRatio > 0\t                                            ").append('\n').append("\t\t\t  ) AS A                             \t").append('\n').append("\t\tGROUP BY A.FCompanyID,A.FCalculatePeriodID,A.FCostCenterID,A.FCostObjectID \t\t").append('\n');
        NCMDbUtil.execute((Context)this._ctx, (String)createsql.toString(), (Connection)this._globalConnection);
        sb.append('\n').append('\n').append(" UPDATE ").append(t_AllocDataTable).append(" AS ADT SET  (FRatioSum) =                   ").append('\n').append(" (                                                                                     ").append('\n').append("\tSELECT  B.FRatio       \t\t                                                        ").append('\n').append("\tFROM ").append(tempTable).append(" AS B                                    \t\t").append('\n').append("\tINNER JOIN ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append("\t  P2 ON  P2.FCompanyID = B.FCOMPANYID AND    \t\t\t\t\t\t\t\t\t    ").append('\n').append("\t  P2.FCalculatePeriodID =B.FCalculatePeriodID AND P2.FCostCenterID = B.FCostCenterID").append('\n').append("\t  AND P2.FCostObjectID =B.FCostObjectID                                             ").append('\n').append("\tWHERE P2.FID = ADT.FID                          ").append('\n').append(" )                      ;                                                              ").append('\n');
    }

    private boolean checkInvalidAllocStdData() throws AllocateException, BOSException, SQLException {
        String allocErrorInfo;
        boolean isSuccess = true;
        String tblAllocData = this._calcTable.GetAllocDataTable(this._ausCtx.GetFieldListForCreateTbl());
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT Distinct CR.FCostObjectID,").append('\n').append("\tCC.FName_L2 || '(' || CC.FNumber || ')' As FCostCenterDisp,").append('\n').append("\tOBJ.FName_L2 || '(' || OBJ.FNumber || ')' As FCostObjectDisp").append('\n').append("FROM ").append(tblAllocData).append(" AD ").append('\n').append("INNER JOIN ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" CR ON CR.FID=AD.FID ").append('\n').append("LEFT OUTER JOIN T_BD_CostObject OBJ ON OBJ.FID=CR.FCostObjectID ").append('\n').append("LEFT OUTER JOIN T_ORG_CostCenter CC ON CC.FID=CR.FCostCenterID ").append('\n').append("LEFT OUTER JOIN T_NCM_CostItem CI ON CI.FID=CR.FCostItemID ").append('\n').append("LEFT OUTER JOIN T_NCM_AllocStd STD ON STD.FID=CR.FAllocStdID ").append('\n').append("WHERE AD.FHasAllocData=0").append('\n');
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.delete(0, sb.length());
        String[] hint = this._ausCtx.GetNoAllocStdDataHint();
        String possibleReason = hint[0];
        String adviceHandle = hint[1];
        possibleReason = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_ClassiAlloc_AllocStdData_Error_Reason");
        adviceHandle = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_ClassiAlloc_AllocStdData_Error_Advice");
        rs.first();
        while (rs.getRow() > 0 && !rs.isAfterLast()) {
            isSuccess = false;
            allocErrorInfo = MessageFormat.format(CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_ClassiAlloc_AllocStdData_Error"), rs.getString("FCostCenterDisp"), rs.getString("FCostObjectDisp"));
            this._log.AddCalcDetailLog(sb, rs.getString("FCostObjectID"), allocErrorInfo, possibleReason, adviceHandle, CheckCalTypeEnum.ALLOCCLASSICO, CalcLogLevelEnum.ClassiCO);
            rs.next();
        }
        if (sb.length() > 0) {
            NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
            return isSuccess;
        }
        sb.append("SELECT Distinct CR.FCostObjectID,").append('\n').append("\tCC.FName_L2 || '(' || CC.FNumber || ')' As FCostCenterDisp,").append('\n').append("\tOBJ.FName_L2 || '(' || OBJ.FNumber || ')' As FCostObjectDisp").append('\n').append("FROM ").append(tblAllocData).append(" AD ").append('\n').append("INNER JOIN ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" CR ON CR.FID=AD.FID ").append('\n').append("LEFT OUTER JOIN T_BD_CostObject OBJ ON OBJ.FID=CR.FCostObjectID ").append('\n').append("LEFT OUTER JOIN T_ORG_CostCenter CC ON CC.FID=CR.FCostCenterID ").append('\n').append("LEFT OUTER JOIN T_NCM_CostItem CI ON CI.FID=CR.FCostItemID ").append('\n').append("LEFT OUTER JOIN T_NCM_AllocStd STD ON STD.FID=CR.FAllocStdID ").append('\n').append("WHERE (FRatio < 0 OR FRatioSum <= 0 OR (FRatio - FRatioSum) > 0) ").append('\n');
        rs = NCMDbUtil.executeQuery((Context)this._ctx, (String)sb.toString(), (Connection)this._globalConnection);
        sb.delete(0, sb.length());
        rs.first();
        while (rs.getRow() > 0 && !rs.isAfterLast()) {
            isSuccess = false;
            allocErrorInfo = MessageFormat.format(CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_ClassiAlloc_AllocStdData_Error"), rs.getString("FCostCenterDisp"), rs.getString("FCostObjectDisp"));
            this._log.AddCalcDetailLog(sb, rs.getString("FCostObjectID"), allocErrorInfo, possibleReason, adviceHandle, CheckCalTypeEnum.ALLOCCLASSICO, CalcLogLevelEnum.ClassiCO);
            rs.next();
        }
        if (sb.length() > 0) {
            NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";");
        }
        return isSuccess;
    }

    private void adjustInvalidAllocStdData(StringBuffer sb) throws AllocateException {
        String tblAllocData = this._calcTable.GetAllocDataTable(this._ausCtx.GetFieldListForCreateTbl());
        sb.append("UPDATE ").append(tblAllocData).append(" AS D SET (FAllocRatio)=(").append('\n').append("\tSELECT DISTINCT 0 as FAllocRatio ").append('\n').append("\tFROM ").append(tblAllocData).append(" AD ").append('\n').append("\tWHERE AD.FID=D.FID AND AD.FAllocRatio < 0 ").append('\n').append(");").append('\n');
        sb.append("UPDATE ").append(tblAllocData).append(" AS D SET (FAllocRatio)=(").append('\n').append("\tSELECT DISTINCT 1 as FAllocRatio ").append('\n').append("\tFROM ").append(tblAllocData).append(" AD ").append('\n').append("\tWHERE AD.FID=D.FID AND AD.FAllocRatio > 1 ").append('\n').append(");").append('\n');
    }

    private void updateAllocStdDataToCalPrdDetailResult(StringBuffer sb) throws AllocateException {
        String tblAllocData = this._calcTable.GetAllocDataTable(this._ausCtx.GetFieldListForCreateTbl());
        sb.append("UPDATE ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" AS D SET (FAllocStdData)=(").append('\n').append("\tSELECT AD.FAllocRatio ").append('\n').append("\tFROM ").append(tblAllocData).append(" AD ").append('\n').append("\tWHERE AD.FID=D.FID ").append('\n').append(");").append('\n');
    }

    private void allocMainAndJoint(StringBuffer sb) throws BOSException {
        int amtprecision = 2;
        try {
            amtprecision = NCMUtils.getCurrencyPrecision((Context)this._ctx, (String)this._companyId);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        sb.append('\n').append("UPDATE ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" AS PR SET ").append('\n').append("   FFinishedAmount = Round(FFinishedAmount * FAllocStdData ,10) ").append('\n').append(" WHERE  EXISTS ( select 1 from ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append('\n').append(" \tP INNER JOIN T_BD_CostObject CO ON  CO.FID = P.FCostObjectID  ").append('\n').append(" \twhere P.FID = PR.FID AND CO.FCalculateMode = ").append(3).append(" ) AND PR.FCalcLevel = ").append(this._rank).append(" ; ").append('\n');
        sb.append('\n').append("UPDATE ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" AS PR SET (FTotalFinishedQty) = ( ").append('\n').append("  SELECT DISTINCT dbp.FFinishedQty FROM ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" \t AS cpr ").append('\n').append("    INNER JOIN ").append(this._calcTable.GetDataByProductTable()).append(" dbp ").append('\n').append("    ON dbp.FCompanyID = cpr.FCompanyID and dbp.FCalculatePeriodID = cpr.FCalculatePeriodID ").append("    and dbp.FCostCenterID =cpr.FCostCenterID and dbp.FCostObjectID = cpr.FCostObjectID  ").append("    and dbp.FProductID =cpr.FProductID   ").append('\n').append("  \t Inner JOIN  T_BD_CostObject AS  CO ON  CO.FID = dbp.FCostObjectID      ").append('\n').append(" \t AND isnull(co.FBatchNumber,'_')=Isnull(dbp.FLOT,'_')       ").append(" \tAND CO.FCalculateMode = ").append(3).append('\n').append(" WHERE PR.FID = cpr.fid ").append(" AND PR.FCalcLevel = ").append(this._rank).append('\n').append(" ) ; ").append('\n');
        sb.append('\n').append("UPDATE ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" AS PR SET (FAllocStdData,FFinishedPrice,FFinishedAmount)=( ").append('\n').append("  Select 1, UC.FUnitCost,dbp.FFinishedQty * UC.FUnitCost AS FAmt").append(" \tFROM ").append(this._calcTable.GetDataByProductTable()).append(" dbp       ").append('\n').append("  \tInner JOIN  T_BD_CostObject AS  CO ON  CO.FID = dbp.FCostObjectID      ").append('\n').append(" \tAND isnull(co.FBatchNumber,'_')=Isnull(dbp.FLOT,'_')      ").append('\n').append("  \tINNER JOIN T_BD_CostObjectEntry AS COE ON COE.FParentID = CO.FID     \t    ").append('\n').append("  \t\t\tAND COE.FRelatedID = dbp.FProductID \t\t\t   \t\t            ").append('\n').append(" \tINNER JOIN T_NCM_ByProductUnitCost AS UC ON UC.FCompanyID= dbp.FCompanyID ").append(" \tAND UC.FCalculatePeriodID=dbp.FCalculatePeriodID  AND UC.FMaterialID = dbp.FProductID  ").append('\n').append(" \tWHERE dbp.FCompanyID ='").append(this._companyId).append("' ").append('\n').append(" \tAND dbp.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n').append(" \tAND CO.FCalculateMode = ").append(3).append(" \tAND COE.FIsByProduct = 1 ").append('\n').append("  AND PR.FCalcLevel = ").append(this._rank).append(" AND DBP.FCompanyID =PR.FCompanyID AND DBP.FCalculatePeriodID=PR.FCalculatePeriodID ").append('\n').append(" AND DBP.FCostCenterID =PR.FCostCenterID AND DBP.FCostObjectID=PR.FCostObjectID  ").append('\n').append(" AND UC.FCostItemID =PR.FCostItemID AND DBP.FProductID =PR.FProductID ) ; ").append('\n');
        sb.append('\n').append("UPDATE ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" AS PR SET ").append('\n').append("   FFinishedAmount = Round(FFinishedAmount ," + amtprecision + ");\n ").append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjDiffAmount() throws BOSException {
        StringBuffer sb = new StringBuffer(100);
        sb.append(" create table temp (");
        sb.append(" fid varchar(44),");
        sb.append(" fdiffAmount NUMERIC(17,4))");
        String diffTemp = NCMDbUtil.createTempTable((Context)this._ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" create table temp (");
        sb.append(" FmaxAmount NUMERIC(17,4),");
        sb.append(" FCompanyID varchar(44),");
        sb.append(" FCalculatePeriodID varchar(44),");
        sb.append(" FCostCenterID varchar(44),");
        sb.append(" FCostObjectID varchar(44),");
        sb.append(" FCostItemID varchar(44),");
        sb.append(" fdiffAmount NUMERIC(17,4))");
        String tempTab = NCMDbUtil.createTempTable((Context)this._ctx, (String)sb.toString());
        sb.setLength(0);
        try {
            NCMDbUtil.createTempTableIndex((Context)this._ctx, (String)diffTemp, (String)"fid", (boolean)true, (boolean)false);
            sb.append('\n');
            sb.append(" insert into ").append(tempTab);
            sb.append("(FmaxAmount,FCompanyID,FCalculatePeriodID,FCostCenterID,FCostObjectID,FCostItemID,fdiffAmount) \n");
            sb.append(" select max(T2.FFinishedAmount) FmaxAmount ,\n");
            sb.append(" T2.FCompanyID,T2.FCalculatePeriodID,T2.FCostCenterID,T2.FCostObjectID,T2.FCostItemID ,\n");
            sb.append(" max(T2.FTempAmount) - sum(T2.FFinishedAmount) fdiffAmount \n");
            sb.append(" from  " + this._calcTable.GetCostCalPrdDetailResultTable() + " T2 \n");
            sb.append(" inner join T_BD_CostObject co on T2.fcostobjectid = co.fid \n");
            sb.append(" where co.FCalculateMode = 3\n");
            sb.append(" group by T2.FCompanyID,T2.FCalculatePeriodID,T2.FCostCenterID,T2.FCostObjectID,T2.FCostItemID ");
            sb.append(" having max(T2.FTempAmount) - sum(T2.FFinishedAmount) <> 0 ;");
            sb.append('\n');
            sb.append(" insert into ").append(diffTemp);
            sb.append("(fid,fdiffAmount) \n");
            sb.append(" select max(T2.fid) fid ,\n");
            sb.append(" max(df.fdiffAmount) fdiffAmount \n");
            sb.append(" from  " + this._calcTable.GetCostCalPrdDetailResultTable() + " T2 \n");
            sb.append(" inner join T_BD_CostObject co on T2.fcostobjectid = co.fid \n");
            sb.append(" inner join ").append(tempTab).append(" df on ");
            sb.append(" T2.FCompanyID =  df.FCompanyID ");
            sb.append(" AND T2.FCompanyID =  df.FCompanyID ");
            sb.append(" AND T2.FCalculatePeriodID =  df.FCalculatePeriodID ");
            sb.append(" AND T2.FCostCenterID =  df.FCostCenterID ");
            sb.append(" AND T2.FCostObjectID =  df.FCostObjectID ");
            sb.append(" AND T2.FCostItemID =  df.FCostItemID ");
            sb.append(" AND T2.FFinishedAmount =  df.FmaxAmount ");
            sb.append(" where co.FCalculateMode = 3\n");
            sb.append(" group by T2.FCompanyID,T2.FCalculatePeriodID,T2.FCostCenterID,T2.FCostObjectID,T2.FCostItemID;");
            sb.append('\n');
            sb.append("update " + this._calcTable.GetCostCalPrdDetailResultTable() + " T1 \n");
            sb.append("set (FFinishedAmount) = ");
            sb.append("(select T2.FFinishedAmount + TA.fdiffAmount from \n");
            sb.append(diffTemp).append(" TA \n");
            sb.append(" inner join ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" T2 ");
            sb.append(" on TA.fid = T2.fid ");
            sb.append(" where T1.fid = TA.fid);");
            sb.append('\n').append("UPDATE ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" AS PR SET ").append('\n').append("\tFFinishedPrice = CASE WHEN isnull(FFinishedQty,0) =0 THEN 0 ").append('\n').append(" ELSE ROUND( FFinishedAmount / FFinishedQty ,8) END ").append('\n').append(" WHERE  EXISTS ( select 1 from ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append('\n').append(" \tP INNER JOIN T_BD_CostObject CO ON  CO.FID = P.FCostObjectID  ").append('\n').append(" \twhere P.FID = PR.FID AND CO.FCalculateMode = ").append(3).append(" ) AND FCalcLevel = ").append(this._rank).append(" ; ").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";", (Connection)this._globalConnection);
        }
        finally {
            NCMDbUtil.releaseTempTable((Context)this._ctx, (String)diffTemp);
            NCMDbUtil.releaseTempTable((Context)this._ctx, (String)tempTab);
        }
    }

    private boolean checkInvalidFinishedAmount() throws BOSException, SQLException {
        boolean isSuccess = true;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT DISTINCT").append('\n').append("  CC.FName_").append(BDCMConst.LocLan).append(" || '(' || CC.FNumber || ')' ").append('\n').append("  As FCostCenterDisp, ").append('\n').append("  CO.FID As FCostObjectID,CO.FNumber,CO.FName_").append(BDCMConst.LocLan).append(" || '(' || CO.FNumber || ')' ").append('\n').append("  As FCostObjectDisp ").append('\n').append(" FROM ( Select Sum(PR.FFinishedAmount) AS FAmt,PR.FCompanyID,PR.FCalculatePeriodID,").append('\n').append("  PR.FcostCenterID,PR.FCostObjectID").append('\n').append(" \tFrom ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" PR ").append('\n').append("  \tInner JOIN  T_BD_CostObject AS  CO ON  CO.FID = PR.FCostObjectID      ").append('\n').append(" \tAND isnull(co.FBatchNumber,'_')=Isnull(PR.FLOT,'_')      ").append('\n').append("  \tINNER JOIN T_BD_CostObjectEntry AS COE ON COE.FParentID = CO.FID     ").append('\n').append("  \t\t\tAND COE.FRelatedID = PR.FProductID \t\t\t   \t\t                  ").append('\n').append(" \tWHERE PR.FCompanyID ='").append(this._companyId).append("' ").append('\n').append(" \tAND PR.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n').append(" \tAND CO.FCalculateMode = ").append(3).append(" \tAND COE.FIsByProduct = 1 ").append(" AND FCalcLevel = ").append(this._rank).append('\n').append("  GROUP BY PR.FCompanyID,PR.FCalculatePeriodID,PR.FcostCenterID,PR.FCostObjectID").append('\n').append("  ) AS A").append('\n').append(" INNER JOIN ").append('\n').append("  ( Select Sum(CR.FFinishedAmount) AS FFinishedAmount,CR.FCompanyID,CR.FCalculatePeriodID,").append('\n').append("  CR.FcostCenterID,CR.FCostObjectID").append('\n').append(" \tFrom ").append(this._calcTable.GetCostCalResultTable()).append(" CR ").append('\n').append("  \tInner JOIN  T_BD_CostObject AS  CO ON  CO.FID = CR.FCostObjectID      ").append('\n').append(" \tWHERE CR.FCompanyID ='").append(this._companyId).append("' ").append('\n').append(" \tAND CR.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n').append(" \tAND CO.FCalculateMode = ").append(3).append(" AND FCalcLevel = ").append(this._rank).append('\n').append("  GROUP BY CR.FCompanyID,CR.FCalculatePeriodID,CR.FcostCenterID,CR.FCostObjectID").append('\n').append("  ) AS S").append('\n').append("\tON S.FCompanyID =A.FCompanyID AND S.FCalculatePeriodID=A.FCalculatePeriodID AND S.FCostCenterID=A.FCostCenterID").append(" \tAND S.FCostObjectID=A.FCostObjectID ").append('\n').append(" INNER JOIN T_ORG_CostCenter CC ON CC.FID = A.FCostCenterID  ").append('\n').append(" INNER JOIN T_BD_CostObject CO ON CO.FID = A.FCostObjectID  ").append('\n').append(" WHERE S.FFinishedAmount - A.FAmt <= 0 and (S.FFinishedAmount <> 0 or A.FAmt <> 0)").append(" AND CO.FCalculateMode = ").append(3);
        IRowSet rs = NCMDbUtil.executeQueryNoTx((Context)this._ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        String possibleReason = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_ClassiCOAlloc_Cost_Error_Reason");
        String adviceHandle = CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_ClassiCOAlloc_Cost_Error_Advice");
        rs.first();
        while (rs.getRow() > 0 && !rs.isAfterLast()) {
            isSuccess = false;
            String allocErrorInfo = MessageFormat.format(CalculateUtil.getSrvCalResource(this._ctx, "Calc_Report_ClassiCOAlloc_Cost_Error"), rs.getString("FCostCenterDisp"), rs.getString("FCostObjectDisp"));
            this._log.AddCalcDetailLog(sb, rs.getString("FCostObjectID"), allocErrorInfo, possibleReason, adviceHandle, CheckCalTypeEnum.ALLOCCLASSICO, CalcLogLevelEnum.ClassiCO);
            rs.next();
        }
        if (sb.length() > 0) {
            NCMDbUtil.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
        }
        return isSuccess;
    }

    private void ClearTempTableData() throws AllocateException, BOSException {
    }
}

