/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CostObjectRankCollection;
import com.kingdee.eas.ncm.cal.CostObjectRankEntryCollection;
import com.kingdee.eas.ncm.cal.CostObjectRankEntryInfo;
import com.kingdee.eas.ncm.cal.CostObjectRankFactory;
import com.kingdee.eas.ncm.cal.CostObjectRankInfo;
import com.kingdee.eas.ncm.cal.ICostObjectRank;
import com.kingdee.eas.ncm.cal.LowLevelCodeTypeEnum;
import com.kingdee.eas.ncm.cal.app.AbstractCostObjectRankControllerBean;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.ICMBillBase;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.algorithm.LowLevelCode;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostObjectRankControllerBean
extends AbstractCostObjectRankControllerBean {
    private static final long serialVersionUID = 6719413746657382462L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.app.CostObjectRankControllerBean");
    private Context ctx;
    private String comId2;
    private String periodId2;
    private TempTablePool pool;
    private String sql_TMP_Uion;

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_CAL_CostObjectRank";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _rank(Context ctx, String comId, String periodId, LowLevelCodeTypeEnum llcType) throws BOSException, EASBizException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("companyId", comId);
            param.put("periodId", periodId);
            param.put("llcType", (Object)llcType);
            param.put("ctx", ctx);
            Object[] obj = this.calculateLLC(ctx, param);
            List cycledCO = (List)obj[0];
            Map objMap = (Map)obj[1];
            if (!cycledCO.isEmpty()) {
                this.throwErrorTip((String)cycledCO.get(0));
            }
            IObjectCollection iObjectCollection = this.buildBillResults(objMap);
            return iObjectCollection;
        }
        finally {
            this.dropTable();
        }
    }

    private void createTable() throws BOSException {
        StringBuffer sql_TMP_Uion = new StringBuffer();
        sql_TMP_Uion.append("Create Table ").append(" temp_table_union ").append("( FCO1 VARCHAR(44),FCO2 VARCHAR(44),FBillNumber NVARCHAR(80) ").append(")");
        try {
            this.pool = TempTablePool.getInstance((Context)this.ctx);
            this.sql_TMP_Uion = this.pool.createTempTable(sql_TMP_Uion.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void dropTable() throws BOSException {
        try {
            if (this.sql_TMP_Uion != null) {
                this.pool.releaseTable(this.sql_TMP_Uion);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getNormalSQL(String comId, String periodId) throws BOSException, EASBizException {
        int CLF = 10;
        String t_MatAllocResult = null;
        String tblBalance = null;
        String tblBalanceEntry = null;
        String tblBalanceDetail = null;
        try {
            NCMUtils.isIncludeCostAdjustData((Context)this.ctx, (String)comId);
            t_MatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.ctx, (String)comId, (String)"T_NCM_MatAllocResult");
            tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.ctx, (String)comId, (String)"T_NCM_Balance");
            tblBalanceEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.ctx, (String)comId, (String)"T_NCM_BalanceEntry");
            tblBalanceDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.ctx, (String)comId, (String)"T_NCM_BalanceMatDetail");
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (StringUtils.isEmpty((String)t_MatAllocResult)) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"105_CostObjectRankControllerBean", (Locale)this.ctx.getLocale())});
        }
        StringBuffer query = new StringBuffer();
        query.append("SELECT r.FCostObjectID ,").append('\n');
        query.append("       case when ( \n");
        query.append("                   matReqEntry.FIsReWork is null -- \u65e0\u6e90\u5355\u636e \n");
        query.append("                   or matReqEntry.FIsReWork = 0 -- \u6709\u6e90\u5355\u636e,\u4f46\u662f\u975e\u8fd4\u5de5 \n");
        query.append("                  ) then CO.FID \n");
        query.append("            else null  -- \u8fd4\u5de5,\u81ea\u5df1\u9886\u7528\u81ea\u5df1 \n");
        query.append("        end as CO2,  \n");
        query.append("        MATREQ.FNumber ").append('\n');
        query.append(" FROM ");
        query.append(t_MatAllocResult);
        query.append(" AS r").append('\n');
        query.append(" INNER JOIN T_BD_CostObject COREF ON r.FCostObjectID = COREF.fid ").append('\n');
        query.append("    and r.AllocBillType = 'MF'\n");
        query.append(" INNER JOIN T_BD_COstObjectEntry coe on  coe.FRelatedID =  r.FMaterialID ").append('\n');
        query.append(" INNER JOIN T_BD_CostObject CO ON coe.fparentId = co.fid and co.FCompanyID = r.FCompanyID  ").append('\n');
        query.append(" LEFT JOIN T_IM_MaterialReqBill AS MATREQ ON r.FSourceBillID = MATREQ.FID").append('\n');
        query.append(" left outer join T_IM_MaterialReqBillEntry matReqEntry \n");
        query.append("         on matReqEntry.FParentID = MATREQ.FID  \n");
        query.append("            and r.FSourceBillEntryId = matReqEntry.FID \n");
        query.append("           and matReqEntry.FMaterialId = r.FMaterialID \n");
        query.append("WHERE co.FRelatedType=0 and co.FIsForbiden = 0 AND coe.FIsByProduct <> 1 \n");
        query.append("AND r.FCompanyID = " + this.comId2 + " \n");
        query.append("AND r.FCalculatePeriodID = " + this.periodId2 + " \n");
        query.append("and COREF.FRelatedType=0 and COREF.FIsForbiden = 0 \n");
        query.append("and ( \n");
        query.append("    (CO.FCalculateMode = 4 and Isnull(r.FLot,' ') = Isnull(CO.FBatchNumber,' ')) \n");
        query.append("    or \n");
        query.append("    ( \n");
        query.append("        CO.FCalculateMode = 7 \n");
        query.append("        and \n");
        query.append("            ( \n");
        query.append("                CO.FOrderID is not null \n");
        query.append("                and \n");
        query.append("                exists ( \n");
        query.append("                    select 1 from T_IM_ManufactureRecBill rb \n");
        query.append("                    left join T_IM_ManufactureRecBillEntry rbe \n");
        query.append("                        on rbe.FParentID = rb.FID \n");
        query.append("                    where rbe.FManuBillID = CO.FOrderID \n");
        query.append("                        and Isnull(r.FLot,' ') = Isnull(rbe.FLot,' ') \n");
        query.append("                ) \n");
        query.append("            ) \n");
        query.append("    ) \n");
        query.append("    or \n");
        query.append("    (CO.FCalculateMode in (1, 3)) \n");
        query.append(") \n");
        query.append("AND (r.FCostObjectID is not null or CO.FID is not null) \n");
        query.append("\n");
        query.append("UNION \n");
        query.append("SELECT \n");
        query.append("    r.FCostObjectID, \n");
        query.append("    CO.FID as CO2,  \n");
        query.append("    MATREQ.FNumber \n");
        query.append("FROM " + t_MatAllocResult + " AS r \n");
        query.append("INNER JOIN T_BD_CostObject COREF \n");
        query.append("    ON r.FCostObjectID = COREF.FID \n");
        query.append("    and r.AllocBillType = 'CA'\n");
        query.append("INNER JOIN T_BD_COstObjectEntry coe \n");
        query.append("    on coe.FRelatedID = r.FMaterialID \n");
        query.append("INNER JOIN T_BD_CostObject CO \n");
        query.append("    ON coe.fparentId = co.fid and co.FCompanyID = r.FCompanyID \n");
        query.append("left join T_CL_CostAdjustBill AS MATREQ \n");
        query.append("    ON r.FSourceBillID = MATREQ.FID \n");
        query.append("left join T_CL_CostAdjustBillEntry matReqEntry \n");
        query.append("    on matReqEntry.FParentID = MATREQ.FID  \n");
        query.append("    and r.FSourceBillEntryId = matReqEntry.FID \n");
        query.append("    and matReqEntry.FMaterialId = r.FMaterialID \n");
        query.append("WHERE co.FRelatedType=0 and co.FIsForbiden = 0 AND coe.FIsByProduct <> 1 \n");
        query.append("AND r.FCompanyID = " + this.comId2 + " \n");
        query.append("AND r.FCalculatePeriodID = " + this.periodId2 + " \n");
        query.append("and COREF.FRelatedType=0 and COREF.FIsForbiden = 0 \n");
        query.append("and ( \n");
        query.append("    (CO.FCalculateMode = 4 and Isnull(r.FLot,' ') = Isnull(CO.FBatchNumber,' ')) \n");
        query.append("    or \n");
        query.append("    ( \n");
        query.append("        CO.FCalculateMode = 7 \n");
        query.append("        and \n");
        query.append("            ( \n");
        query.append("                CO.FOrderID is not null \n");
        query.append("                and \n");
        query.append("                exists ( \n");
        query.append("                    select 1 from T_IM_ManufactureRecBill rb \n");
        query.append("                    left join T_IM_ManufactureRecBillEntry rbe \n");
        query.append("                        on rbe.FParentID = rb.FID \n");
        query.append("                    where rbe.FManuBillID = CO.FOrderID \n");
        query.append("                        and Isnull(r.FLot,' ') = Isnull(rbe.FLot,' ') \n");
        query.append("                ) \n");
        query.append("            ) \n");
        query.append("    ) \n");
        query.append("    or \n");
        query.append("    (CO.FCalculateMode in (1, 3)) \n");
        query.append(") \n");
        query.append("AND (r.FCostObjectID is not null or CO.FID is not null) \n");
        query.append('\n').append("UNION").append('\n');
        query.append("SELECT mre.FCostObjectID ,").append('\n').append("       case when ( \n").append("                   mre.FIsReWork is null -- \u65e0\u6e90\u5355\u636e \n").append("                   or mre.FIsReWork = 0 -- \u6709\u6e90\u5355\u636e,\u4f46\u662f\u975e\u8fd4\u5de5 \n").append("                  ) then CO.FID \n").append("            else null  -- \u8fd4\u5de5,\u81ea\u5df1\u9886\u7528\u81ea\u5df1 \n").append("        end as CO2,  \n").append("        isnull(parent.FNumber, 'CA2012000034') ").append('\n').append(" FROM ").append("t_im_materialReqBill").append(" AS PARENT").append('\n').append(" inner join t_im_materialReqBillEntry mre on PARENT.FID = mre.FParentID and parent.FBaseStatus = 4 \n").append(" join T_SCM_TransactionType tt on tt.FID = PARENT.FTransactionTypeID \n").append("     and tt.FIsManuCostCalculate = 1 \n").append(" inner join T_IM_InvUpdateType ut on mre.FINVUPDATETYPEID = ut.fid ").append('\n').append(" inner join T_IM_STORETYPE st on ut.FSTORETYPEPREID = st.fid and st.FISFORWARDAMT = 1 ").append('\n').append(" INNER JOIN T_BD_CostObject COREF ON mre.FCostObjectID = COREF.fid ").append('\n').append(" INNER JOIN T_BD_COstObjectEntry coe on  coe.FRelatedID =  mre.FMaterialID ").append('\n').append(" INNER JOIN T_BD_CostObject CO ON coe.fparentId = co.fid and co.FCompanyID = mre.FCompanyOrgUnitID  ").append('\n').append(" inner join t_bd_period per on per.FPeriodYear = parent.FYear and per.FPeriodNumber = parent.FPeriod ").append('\n').append(" WHERE co.FRelatedType=0 and co.FIsForbiden = 0 AND coe.FIsByProduct <> 1 AND mre.FCompanyOrgUnitID =" + this.comId2).append(" AND   per .FID = " + this.periodId2).append(" and COREF.FRelatedType=0 and COREF.FIsForbiden = 0 ").append("  and ").append('\n').append("  ( ").append('\n').append("      (CO.FCalculateMode = 4 and Isnull(mre.FLot,' ') = Isnull(CO.FBatchNumber,' ')) ").append('\n').append("      or ").append('\n').append("      ( ").append('\n').append("          CO.FCalculateMode = 7 ").append('\n').append("          and ").append('\n').append("              ( ").append('\n').append("                  CO.FOrderID is not null ").append('\n').append("                  and ").append('\n').append("                  exists ( ").append('\n').append("                      select 1 from T_IM_ManufactureRecBill rb ").append('\n').append("                      left join T_IM_ManufactureRecBillEntry rbe ").append('\n').append("                          on rbe.FParentID = rb.FID ").append('\n').append("                      where rbe.FManuBillID = CO.FOrderID ").append('\n').append("                          and Isnull(mre.FLot,' ') = Isnull(rbe.FLot,' ') ").append('\n').append("                  ) ").append('\n').append("              ) ").append('\n').append("      ) ").append('\n').append("      or ").append('\n').append("      (CO.FCalculateMode in (1, 3)) ").append('\n').append("  )").append('\n').append(" AND  (mre.FCostObjectID is not null or CO.FID is not null) \n").append(" and mre.FISAdmeasure = 0 \n").append(" and parent.FBaseStatus = 4 \n");
        query.append('\n').append("UNION ").append('\n');
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT null as co2,E.FCostObjectID ,null as FNumber").append('\n').append("FROM T_NCM_InputQtyBill B ").append('\n').append("LEFT OUTER JOIN T_NCM_InputQtyBillEntry E ON B.FID = E.FParentID ").append('\n').append("WHERE B.FBillStatus=4 AND B.FCompanyOrg = " + this.comId2 + " AND B.FCalculatePeriod = " + this.periodId2).append('\n').append("GROUP BY B.FCompanyOrg,B.FCalculatePeriod, E.FCostObjectID ").append('\n').append("HAVING SUM(E.FQty) <>0 ").append('\n');
        sb.append("UNION ").append('\n').append("SELECT BB.FCostObjectID ,").append('\n').append("       case when ( \n").append("                    DT.FIsReWork = 1 -- \u8fd4\u5de5 \n").append("                  ) then null \n").append("            else CO.FID  -- \u975e\u8fd4\u5de5 \n").append("        end as CO2,  \n").append("init.fnumber as FNumber").append('\n').append("FROM ").append(tblBalance).append(" BB ").append('\n').append("LEFT JOIN ").append(tblBalanceEntry).append(" BE ON BE.FParentID=BB.FID").append('\n').append("LEFT JOIN T_NCM_InitBalance init on init.fid = BB.Fid \n").append("LEFT JOIN ").append(tblBalanceDetail).append(" DT ON DT.FParentID=BE.FID ").append('\n').append("LEFT JOIN T_BD_COstObjectEntry coe on coe.FRelatedID = DT.FMaterialID AND coe.FIsByProduct = 0 ").append('\n').append("LEFT JOIN T_BD_CostObject CO ON coe.fparentId = co.fid ").append('\n').append("\tand CO.FCompanyID = BB.FCompanyOrg  ").append('\n').append("\tAND Isnull(CO.FBatchNumber,' ')=Isnull(DT.FBatchNo,' ') and co.FRelatedType=0 and co.FIsForbiden = 0 ").append('\n').append("WHERE BB.FCompanyOrg = " + this.comId2 + " AND BB.FCalculatePeriodID = " + this.periodId2).append('\n').append("GROUP BY BB.FCompanyOrg,BB.FCalculatePeriodID,BB.FCostObjectID,CO.FID, DT.FIsReWork, init.fnumber ").append("HAVING SUM(BB.FBopWIPQty) <>0 ");
        return query.append(sb).toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRowSet buildNormalCORefData(Context ctx, Map param) throws BOSException, EASBizException {
        IRowSet iRowSet;
        block8: {
            String companyId = (String)param.get("companyId");
            String periodId = (String)param.get("periodId");
            String t_MatAllocResult = null;
            String tblBalance = null;
            String T_TMP_CostObject = null;
            try {
                CalSeverUtils.ClearInvalidAllocResult(param);
                t_MatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult");
                tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
                if (StringUtils.isEmpty((String)t_MatAllocResult)) {
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"105_CostObjectRankControllerBean", (Locale)ctx.getLocale())});
                }
                StringBuffer sql = new StringBuffer();
                this.buildNormalCORefDataMatReqAlloc(ctx, param, t_MatAllocResult);
                this.buildNormalCORefDataCostAdjustAlloc(ctx, param, t_MatAllocResult);
                this.buildNormalCORefDataOtherInWarehsAlloc(ctx, param, t_MatAllocResult);
                this.buildNormalCORefDataMatReq(ctx, param);
                this.buildNormalCORefDataInputQty(ctx, param);
                sql.setLength(0);
                sql.append("create table T ( \n");
                sql.append("    FCostObjectID varchar(44) \n");
                sql.append(") \n");
                T_TMP_CostObject = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
                sql.setLength(0);
                sql.append("insert into " + T_TMP_CostObject + " ( \n");
                sql.append("    FCostObjectID \n");
                sql.append(") \n");
                sql.append("select \n");
                sql.append("    FCostObjectID \n");
                sql.append("from ( \n");
                sql.append("    SELECT inputbe.FCostObjectID, inputbe.FQty FQty \n");
                sql.append("    from T_NCM_InputQtyBill inputb \n");
                sql.append("    join T_NCM_InputQtyBillEntry inputbe ON inputbe.FParentID = inputb.FID  \n");
                sql.append("    WHERE inputb.FCompanyOrg = '" + companyId + "' AND inputb.FCalculatePeriod = '" + periodId + "' \n");
                sql.append("    and inputb.FBillStatus=4 \n");
                sql.append("    union All \n");
                sql.append("    SELECT bal.FCostObjectID, bal.FBopWIPQty FQty \n");
                sql.append("    from " + tblBalance + " bal \n");
                sql.append("    where bal.FCompanyOrg = '" + companyId + "' AND bal.FCalculatePeriodID = '" + periodId + "' \n");
                sql.append(") a group by FCostObjectID \n");
                sql.append("having sum(FQty) <> 0 \n");
                sql.append("; \n");
                NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sql.toString());
                TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_CostObject, "FCostObjectID", false, false);
                sql.setLength(0);
                sql.append("update " + this.sql_TMP_Uion + " \n");
                sql.append("set FCO2 = null \n");
                sql.append("where FCO2 is not null \n");
                sql.append("and not exists ( \n");
                sql.append("    select 1 from " + T_TMP_CostObject + " co \n");
                sql.append("    where co.FCostObjectID = " + this.sql_TMP_Uion + ".FCO2 \n");
                sql.append("); \n");
                NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("SELECT distinct * FROM " + this.sql_TMP_Uion);
                IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs.size() == 0) {
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"112_CostObjectRankControllerBean", (Locale)ctx.getLocale())});
                }
                iRowSet = rs;
                if (T_TMP_CostObject == null) break block8;
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                    catch (Exception e2) {
                        throw new BOSException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (T_TMP_CostObject != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_CostObject);
                    }
                    throw throwable;
                }
            }
            TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_CostObject);
        }
        return iRowSet;
    }

    private void buildNormalCORefDataMatReqAlloc(Context ctx, Map param, String t_MatAllocResult) throws BOSException, EASBizException {
        int CLF = 10;
        String comId = (String)param.get("companyId");
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        String T_TMP_MatReq = costDataCache.getMatReqTable();
        String T_TMP_RecBillCostObject = costDataCache.getRecBillCostObjectTable();
        StringBuffer query = new StringBuffer();
        query.setLength(0);
        query.append("Insert Into " + this.sql_TMP_Uion + " ( \n");
        query.append("    FCO1, FCO2, FBillNumber \n");
        query.append(") \n");
        query.append("SELECT distinct ").append('\n');
        query.append("    r.FCostObjectID,").append('\n');
        query.append("    case when ( \n");
        query.append("            t.FIsReWork is null \n");
        query.append("            or t.FIsReWork = 0 \n");
        query.append("        ) then CO.FID \n");
        query.append("        else null \n");
        query.append("    end as CO2,  \n");
        query.append("    t.FNumber ").append('\n');
        query.append("FROM " + t_MatAllocResult + " r \n");
        query.append("JOIN " + T_TMP_MatReq + " t ").append('\n');
        query.append("    on t.FSourceBillID = r.FSourceBillID ").append('\n');
        query.append("    and t.FSourceBillEntryID = r.FSourceBillEntryID ").append('\n');
        query.append("INNER JOIN T_BD_CostObject COREF ").append('\n');
        query.append("    ON r.FCostObjectID = COREF.fid ").append('\n');
        query.append("    and r.AllocBillType = 'MF' \n");
        query.append("INNER JOIN T_BD_CostObject CO ").append('\n');
        query.append("    ON co.FStdProductIDID = r.FMaterialID ").append('\n');
        query.append("    and co.FCompanyID = '" + comId + "' ").append('\n');
        query.append("WHERE COREF.FRelatedType=0 and COREF.FIsForbiden = 0 \n");
        query.append("and co.FRelatedType=0 and co.FIsForbiden = 0 \n");
        query.append("and ( \n");
        query.append("    (CO.FCalculateMode = 4 and Isnull(r.FLot,' ') = Isnull(CO.FBatchNumber,' ')) \n");
        query.append("    or \n");
        query.append("    (CO.FCalculateMode = 1) \n");
        query.append(") \n");
        query.append("AND (r.FCostObjectID is not null or CO.FID is not null) \n");
        query.append("union \n");
        query.append("SELECT distinct ").append('\n');
        query.append("    r.FCostObjectID,").append('\n');
        query.append("    case when ( \n");
        query.append("            t.FIsReWork is null \n");
        query.append("            or t.FIsReWork = 0 \n");
        query.append("        ) then CO.FID \n");
        query.append("        else null \n");
        query.append("    end as CO2,  \n");
        query.append("    t.FNumber ").append('\n');
        query.append("FROM " + t_MatAllocResult + " r \n");
        query.append("JOIN " + T_TMP_MatReq + " t ").append('\n');
        query.append("    on t.FSourceBillID = r.FSourceBillID ").append('\n');
        query.append("    and t.FSourceBillEntryID = r.FSourceBillEntryID ").append('\n');
        query.append("INNER JOIN T_BD_CostObject COREF ").append('\n');
        query.append("    ON r.FCostObjectID = COREF.fid ").append('\n');
        query.append("    and r.AllocBillType = 'MF' \n");
        query.append("INNER JOIN T_BD_CostObject CO ").append('\n');
        query.append("    ON co.FStdProductIDID = r.FMaterialID ").append('\n');
        query.append("    and co.FCompanyID = '" + comId + "' ").append('\n');
        query.append("join ( ").append('\n');
        query.append("    select distinct rb.FCostObjectID, rb.FLot ").append('\n');
        query.append("    from " + T_TMP_RecBillCostObject + " rb ").append('\n');
        query.append(") rbo ").append('\n');
        query.append("on rbo.FCostObjectID = co.FID ").append('\n');
        query.append("    and Isnull(r.FLot,' ') = Isnull(rbo.FLot,' ') \n");
        query.append("WHERE COREF.FRelatedType=0 and COREF.FIsForbiden = 0 \n");
        query.append(" and co.FRelatedType=0 and co.FIsForbiden = 0 \n");
        query.append(" and CO.FCalculateMode = 7 \n");
        query.append("AND (r.FCostObjectID is not null or CO.FID is not null) \n");
        query.append("union \n");
        query.append("SELECT distinct ").append('\n');
        query.append("    r.FCostObjectID,").append('\n');
        query.append("    case when ( \n");
        query.append("            t.FIsReWork is null \n");
        query.append("            or t.FIsReWork = 0 \n");
        query.append("        ) then CO.FID \n");
        query.append("        else null \n");
        query.append("    end as CO2,  \n");
        query.append("    t.FNumber ").append('\n');
        query.append("FROM " + t_MatAllocResult + " r \n");
        query.append("JOIN " + T_TMP_MatReq + " t ").append('\n');
        query.append("    on t.FSourceBillID = r.FSourceBillID ").append('\n');
        query.append("    and t.FSourceBillEntryID = r.FSourceBillEntryID ").append('\n');
        query.append("INNER JOIN T_BD_CostObject COREF ").append('\n');
        query.append("    ON r.FCostObjectID = COREF.fid ").append('\n');
        query.append("    and r.AllocBillType = 'MF' \n");
        query.append("INNER JOIN T_BD_CostObject CO ").append('\n');
        query.append("    ON co.FStdProductIDID = r.FMaterialID ").append('\n');
        query.append("    and co.FCompanyID = '" + comId + "' ").append('\n');
        query.append("WHERE COREF.FRelatedType=0 and COREF.FIsForbiden = 0 \n");
        query.append("and co.FRelatedType=0 and co.FIsForbiden = 0 \n");
        query.append("and ( \n");
        query.append("    CO.FCalculateMode = 3 \n");
        query.append(") \n");
        query.append("AND (r.FCostObjectID is not null or CO.FID is not null) \n");
        NCMDbUtil.execute((Context)ctx, (String)query.toString());
    }

    private void buildNormalCORefDataCostAdjustAlloc(Context ctx, Map param, String t_MatAllocResult) throws BOSException, EASBizException {
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        String T_TMP_RecBillCostObject = costDataCache.getRecBillCostObjectTable();
        StringBuffer query = new StringBuffer();
        query.setLength(0);
        query.append("Insert Into " + this.sql_TMP_Uion + " ( \n");
        query.append("    FCO1, FCO2, FBillNumber \n");
        query.append(") \n");
        query.append("\n");
        query.append("SELECT \n");
        query.append("    r.FCostObjectID, \n");
        query.append("    CO.FID as CO2,  \n");
        query.append("    MATREQ.FNumber \n");
        query.append("FROM " + t_MatAllocResult + " AS r \n");
        query.append("INNER JOIN T_BD_CostObject COREF \n");
        query.append("    ON r.FCostObjectID = COREF.FID \n");
        query.append("    and r.AllocBillType = 'CA'\n");
        query.append("INNER JOIN T_BD_COstObjectEntry coe \n");
        query.append("    on coe.FRelatedID = r.FMaterialID \n");
        query.append("INNER JOIN T_BD_CostObject CO \n");
        query.append("    ON coe.fparentId = co.fid and co.FCompanyID = r.FCompanyID \n");
        query.append("left join T_CL_CostAdjustBill AS MATREQ \n");
        query.append("    ON r.FSourceBillID = MATREQ.FID \n");
        query.append("left join T_CL_CostAdjustBillEntry matReqEntry \n");
        query.append("    on matReqEntry.FParentID = MATREQ.FID  \n");
        query.append("    and r.FSourceBillEntryId = matReqEntry.FID \n");
        query.append("    and matReqEntry.FMaterialId = r.FMaterialID \n");
        query.append("WHERE co.FRelatedType=0 and co.FIsForbiden = 0 AND coe.FIsByProduct <> 1 \n");
        query.append("AND r.FCompanyID = " + this.comId2 + " \n");
        query.append("AND r.FCalculatePeriodID = " + this.periodId2 + " \n");
        query.append("and COREF.FRelatedType=0 and COREF.FIsForbiden = 0 \n");
        query.append("and ( \n");
        query.append("    (CO.FCalculateMode = 4 and Isnull(r.FLot,' ') = Isnull(CO.FBatchNumber,' ')) \n");
        query.append("    or \n");
        query.append("    ( \n");
        query.append("        CO.FCalculateMode = 7 \n");
        query.append("        and \n");
        query.append("            ( \n");
        query.append("                CO.FOrderID is not null \n");
        query.append("                and \n");
        query.append("                exists ( \n");
        query.append("                    select top 1 1 from " + T_TMP_RecBillCostObject + " rc \n");
        query.append("                    where rc.FCostObjectID = CO.FID \n");
        query.append("                        and Isnull(r.FLot,' ') = Isnull(rc.FLot,' ') \n");
        query.append("                ) \n");
        query.append("            ) \n");
        query.append("    ) \n");
        query.append("    or \n");
        query.append("    (CO.FCalculateMode in (1, 3)) \n");
        query.append(") \n");
        query.append("AND (r.FCostObjectID is not null or CO.FID is not null) \n");
        NCMDbUtil.execute((Context)ctx, (String)query.toString());
    }

    private void buildNormalCORefDataOtherInWarehsAlloc(Context ctx, Map param, String t_MatAllocResult) throws BOSException, EASBizException {
    }

    private void buildNormalCORefDataMatReq(Context ctx, Map param) throws BOSException, EASBizException {
        char CLF = '\n';
        String comId = (String)param.get("companyId");
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        String T_TMP_MatReq = costDataCache.getMatReqTable();
        String T_TMP_RecBillCostObject = costDataCache.getRecBillCostObjectTable();
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + this.sql_TMP_Uion + " ( \n");
        sql.append("    FCO1, FCO2, FBillNumber \n");
        sql.append(") \n");
        sql.append("SELECT \n");
        sql.append("    t.FCostObjectID, \n");
        sql.append("    case \n");
        sql.append("        when ( \n");
        sql.append("            t.FIsReWork is null \n");
        sql.append("            or t.FIsReWork = 0 \n");
        sql.append("        ) then CO.FID \n");
        sql.append("        else null \n");
        sql.append("    end CO2, \n");
        sql.append("    isnull(t.FNumber, 'CA2012000034') \n");
        sql.append("FROM " + T_TMP_MatReq + " t \n");
        sql.append("INNER JOIN T_BD_CostObject COREF ON t.FCostObjectID = COREF.fid ").append(CLF);
        sql.append("INNER JOIN T_BD_COstObjectEntry coe on  coe.FRelatedID =  t.FMaterialID ").append(CLF);
        sql.append("INNER JOIN T_BD_CostObject CO ON coe.fparentId = co.fid and co.FCompanyID = '" + comId + "'  ").append(CLF);
        sql.append("WHERE co.FRelatedType=0 and co.FIsForbiden = 0 AND coe.FIsByProduct <> 1 \n");
        sql.append("    and COREF.FRelatedType=0 and COREF.FIsForbiden = 0 \n");
        sql.append("    and ").append(CLF);
        sql.append("    ( ").append(CLF);
        sql.append("        (CO.FCalculateMode = 4 and isnull(t.FLot,' ') = isnull(CO.FBatchNumber,' ')) ").append(CLF);
        sql.append("        or ").append(CLF);
        sql.append("        ( ").append(CLF);
        sql.append("            CO.FCalculateMode = 7 ").append(CLF);
        sql.append("            and ").append(CLF);
        sql.append("            ( ").append(CLF);
        sql.append("                  CO.FOrderID is not null ").append(CLF);
        sql.append("                  and ").append(CLF);
        sql.append("                  exists ( ").append(CLF);
        sql.append("                    select top 1 1 from " + T_TMP_RecBillCostObject + " rc \n");
        sql.append("                    where rc.FCostObjectID = CO.FID \n");
        sql.append("                        and Isnull(t.FLot,' ') = Isnull(rc.FLot,' ') \n");
        sql.append("                  ) ").append(CLF);
        sql.append("            ) ").append(CLF);
        sql.append("        ) ").append(CLF);
        sql.append("        or ").append(CLF);
        sql.append("        (CO.FCalculateMode in (1, 3)) ").append(CLF);
        sql.append("    )").append(CLF);
        sql.append("    AND  (t.FCostObjectID is not null or CO.FID is not null) \n");
        sql.append("    and t.FISAdmeasure = 0 \n");
        NCMDbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void buildNormalCORefDataInputQty(Context ctx, Map param) throws BOSException, EASBizException, SQLException {
        char CLF = '\n';
        String comId = (String)param.get("companyId");
        StringBuffer query = new StringBuffer();
        String tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)comId, (String)"T_NCM_Balance");
        String tblBalanceEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)comId, (String)"T_NCM_BalanceEntry");
        String tblBalanceDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)comId, (String)"T_NCM_BalanceMatDetail");
        query.setLength(0);
        query.append("Insert Into " + this.sql_TMP_Uion + " ( \n");
        query.append("    FCO1, FCO2, FBillNumber \n");
        query.append(") \n");
        query.append("SELECT null as co2,E.FCostObjectID ,null as FNumber").append(CLF).append("FROM T_NCM_InputQtyBill B ").append(CLF).append("LEFT OUTER JOIN T_NCM_InputQtyBillEntry E ON B.FID = E.FParentID ").append(CLF).append("WHERE B.FBillStatus=4 AND B.FCompanyOrg = " + this.comId2 + " AND B.FCalculatePeriod = " + this.periodId2).append(CLF).append("GROUP BY B.FCompanyOrg,B.FCalculatePeriod, E.FCostObjectID ").append(CLF).append("HAVING SUM(E.FQty) <>0 ").append(CLF);
        query.append("UNION ").append(CLF).append("SELECT BB.FCostObjectID ,").append(CLF).append("       case when ( \n").append("                    DT.FIsReWork = 1 -- \u8fd4\u5de5 \n").append("                  ) then null \n").append("            else CO.FID  -- \u975e\u8fd4\u5de5 \n").append("        end as CO2,  \n").append("init.fnumber as FNumber").append(CLF).append("FROM ").append(tblBalance).append(" BB ").append(CLF).append("LEFT JOIN ").append(tblBalanceEntry).append(" BE ON BE.FParentID=BB.FID").append(CLF).append("LEFT JOIN T_NCM_InitBalance init on init.fid = BB.Fid \n").append("LEFT JOIN ").append(tblBalanceDetail).append(" DT ON DT.FParentID=BE.FID ").append(CLF).append("LEFT JOIN T_BD_COstObjectEntry coe on coe.FRelatedID = DT.FMaterialID AND coe.FIsByProduct = 0 ").append(CLF).append("LEFT JOIN T_BD_CostObject CO ON coe.fparentId = co.fid ").append(CLF).append("\tand CO.FCompanyID = BB.FCompanyOrg  ").append(CLF).append("\tAND Isnull(CO.FBatchNumber,' ')=Isnull(DT.FBatchNo,' ') and co.FRelatedType=0 and co.FIsForbiden = 0 ").append(CLF).append("WHERE BB.FCompanyOrg = " + this.comId2 + " AND BB.FCalculatePeriodID = " + this.periodId2).append(CLF).append("GROUP BY BB.FCompanyOrg,BB.FCalculatePeriodID,BB.FCostObjectID,CO.FID, DT.FIsReWork, init.fnumber ");
        NCMDbUtil.execute((Context)ctx, (String)query.toString());
    }

    private String getDynamicCostSQL(String companyId, String bizPeriodId) throws BOSException, EASBizException {
        int CLF = 10;
        String t_DynMatAllocResult = null;
        try {
            t_DynMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.ctx, (String)companyId, (String)"T_NCM_DynMatAllocResult");
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SQLDataException(e);
        }
        if (StringUtils.isEmpty((String)t_DynMatAllocResult)) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"105_CostObjectRankControllerBean", (Locale)this.ctx.getLocale())});
        }
        PeriodInfo periodInfo = null;
        try {
            periodInfo = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectStringPK(bizPeriodId));
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        if (periodInfo == null) {
            return "";
        }
        Date beginDate = new Date(periodInfo.getBeginDate().getTime());
        Date endDate = new Date(periodInfo.getEndDate().getTime());
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer query = new StringBuffer();
        query.append("SELECT distinct PARENT.FCostObjectID ,").append('\n').append("       case when ( \n").append("                   matReqEntry.FIsReWork is null -- \u65e0\u6e90\u5355\u636e \n").append("                   or matReqEntry.FIsReWork = 0 -- \u6709\u6e90\u5355\u636e,\u4f46\u662f\u975e\u8fd4\u5de5 \n").append("                   or PARENT.FCostObjectID <> CO.FID -- \u8fd4\u5de5,\u4f46\u6210\u672c\u5bf9\u8c61\u4e0d\u662f\u9886\u7528\u81ea\u5df1 \n").append("                  ) then CO.FID \n").append("            else null  -- \u8fd4\u5de5,\u81ea\u5df1\u9886\u7528\u81ea\u5df1 \n").append("        end as CO2,  \n").append("        MATREQ.FNumber ").append('\n').append(" FROM ").append(t_DynMatAllocResult).append(" AS PARENT").append('\n').append(" INNER JOIN T_BD_CostObject COREF ON PARENT.FCostObjectID = COREF.fid ").append('\n').append(" Left outer JOIN T_BD_COstObjectEntry coe on  coe.FRelatedID =  PARENT.FMaterialID ").append('\n').append(" Left outer JOIN T_BD_CostObject CO ON coe.fparentId = co.fid and co.FCompanyID = PARENT.FCompanyID  ").append('\n').append(" LEFT JOIN T_IM_MaterialReqBill AS MATREQ ON PARENT.FSourceBillID = MATREQ.FID").append('\n').append(" left outer join T_IM_MaterialReqBillEntry matReqEntry \n").append("         on matReqEntry.FParentID = MATREQ.FID  \n").append("            and PARENT.FSourceBillEntryId = matReqEntry.FID \n").append("           and matReqEntry.FMaterialId = PARENT.FMaterialID \n").append(" WHERE   PARENT .FCompanyID =" + this.comId2).append(" and COREF.FRelatedType=0 and COREF.FIsForbiden = 0 ").append("                                  AND (coe.fid is null or coe.FIsByProduct <> 1)").append("                                   and (co.fid is null or (co.FRelatedType=0 and co.FIsForbiden = 0)) ").append("  and matreq.fbasestatus=4 ").append("              and matreq.FBizDate >= TO_DATE('" + dateFormate.format(beginDate) + "') ").append("              and matreq.FBizDate <= TO_DATE('" + dateFormate.format(endDate) + "') ").append(" AND  (PARENT.FCostObjectID is not null or CO.FID is not null) ");
        query.append(" and PARENT.fcalculateperiodid = '" + bizPeriodId + "' ");
        query.append('\n').append("UNION ").append('\n');
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select null as co2, CO.FID as FCostObjectID ,null as FNumber ").append('\n');
        kSql.append("\tfrom T_IM_ManufactureRecBill as recBill ").append('\n');
        kSql.append("\t\t inner join T_SCM_TransactionType as transType  ").append('\n');
        kSql.append(" \t   \t\ton recBill.FTransactionTypeID = transType.FID ").append('\n');
        kSql.append("      \t\t\tand transType.FIsManuCostCalculate = 1").append('\n');
        kSql.append("\t\t left outer join T_IM_ManufactureRecBillEntry as recBillEntry ").append('\n');
        kSql.append(" \t\t\ton recBill.FID =  recBillEntry.FParentID").append('\n');
        kSql.append("\t \tinner join T_IM_InvUpdateType ut on recBillEntry.FINVUPDATETYPEID = ut.fid ").append('\n');
        kSql.append("\t \tinner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n');
        kSql.append("\t\t left outer join T_BD_CostObjectEntry as COEntry ").append('\n');
        kSql.append("\t\t\ton COEntry.FRelatedID = recBillEntry.FMaterialID ").append('\n');
        kSql.append("\t\t left outer join T_BD_CostObject as CO ").append('\n');
        kSql.append("\t\t\ton CO.FID = COEntry.FParentID ").append('\n');
        kSql.append("\t\t\t  and CO.FCompanyID = recBillEntry.FCompanyOrgUnitID ").append('\n');
        kSql.append("  \t\t inner join t_org_costcenter cc on cc.fid = recBillEntry.FCostCenterOrgUnitID").append('\n');
        kSql.append("  \t\t\t\t\t       and cc.FCostCenterType = 0 ").append('\n');
        kSql.append("  where CO.FRelatedType = 0 and CO.FIsForbiden=0 ").append('\n');
        kSql.append("\t\t\t   and ").append('\n');
        kSql.append("\t\t\t   ( ").append('\n');
        kSql.append("\t\t\t       (CO.FCalculateMode = 4 and Isnull(recBillEntry.FLot,' ') = Isnull(CO.FBatchNumber,' ')) ").append('\n');
        kSql.append("\t\t\t\t   or ").append('\n');
        kSql.append("\t\t\t\t   (CO.FCalculateMode = 7 and CO.FOrderID = recBillEntry.FManuBillID) ").append('\n');
        kSql.append("\t\t\t\t   or ").append('\n');
        kSql.append("\t\t\t\t   (CO.FCalculateMode in (1, 3)) ").append('\n');
        kSql.append("\t\t\t   )").append('\n');
        kSql.append("    and recBill.FBASESTATUS = 4  ").append('\n');
        kSql.append("    and recBillEntry.FCompanyOrgUnitID = '" + companyId + "'  ").append('\n');
        kSql.append("    and recBill.FBizDate >= TO_DATE('" + dateFormate.format(beginDate) + "') ");
        kSql.append("    and recBill.FBizDate <= TO_DATE('" + dateFormate.format(endDate) + "') ");
        kSql.append("  group by recBillEntry.FCompanyOrgUnitID,CO.FID ").append('\n');
        return query.append(kSql.toString()).toString();
    }

    private String getCostRecoSQL(String comId, String periodId) {
        int CLF = 10;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT BB.FCostObjectID ,null AS co2, BB.FNumber as FNumber").append('\n').append("FROM T_NCM_BoPInvSFPCost ").append(" BB ").append('\n').append("INNER JOIN T_NCM_BoPInvSFPCostEntry ").append(" BE ON BE.FParentID=BB.FID").append('\n').append("LEFT  JOIN T_NCM_BoPInvSFPCostMatDetail ").append(" DT ON DT.FParentID=BE.FID ").append('\n').append("WHERE BB.FBillStatus = 4 and BB.FCompanyOrg = " + this.comId2 + " AND BB.FCalculatePeriod = " + this.periodId2).append('\n').append("GROUP BY BB.FCompanyOrg,BB.FCalculatePeriod,BB.FCostObjectID,BB.FNumber ").append("HAVING SUM(BB.FQty) <>0 ").append("UNION ").append("SELECT BB.FCostObjectID ,CO.FID AS co2,BB.FNumber as FNumber").append('\n').append("FROM T_NCM_BoPInvSFPCost ").append(" BB ").append('\n').append("INNER JOIN T_NCM_BoPInvSFPCostEntry ").append(" BE ON BE.FParentID=BB.FID").append('\n').append("LEFT  JOIN T_NCM_BoPInvSFPCostMatDetail ").append(" DT ON DT.FParentID=BE.FID ").append('\n').append("LEFT JOIN T_BD_CostObject CO ON CO.FCompanyID = BB.FCompanyOrg  AND Isnull(CO.FBatchNumber,' ')=Isnull(DT.FBatchNo,' ') ").append('\n').append("INNER JOIN T_BD_COstObjectEntry coe on coe.fparentId = co.fid and  coe.FRelatedID = DT.FMaterialID").append('\n').append("WHERE co.FIsForbiden = 0 AND coe.FIsByProduct <> 1 and BB.FBillStatus = 4 and BB.FCompanyOrg = " + this.comId2 + " AND BB.FCalculatePeriod = " + this.periodId2).append('\n').append("GROUP BY BB.FCompanyOrg,BB.FCalculatePeriod,BB.FCostObjectID,CO.FID,BB.FNumber ").append("HAVING SUM(BB.FQty) <>0 ");
        return sb.toString();
    }

    private IRowSet executeInsert(String sql) throws BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("Insert Into ").append(this.sql_TMP_Uion).append(" SELECT * FROM ( ").append(sql).append(" ) AS U ");
        Statement statement = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            statement = conn.createStatement();
            statement.executeUpdate(updateSql.toString());
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
        String query = "SELECT * FROM " + this.sql_TMP_Uion;
        IRowSet rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)query);
        if (rs.size() == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"112_CostObjectRankControllerBean", (Locale)this.ctx.getLocale())});
        }
        return rs;
    }

    private IObjectCollection buildBillResults(Map computedResults) throws EASBizException, BOSException {
        if (computedResults.isEmpty()) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"113_CostObjectRankControllerBean", (Locale)this.ctx.getLocale())});
        }
        CostObjectRankEntryCollection entries = new CostObjectRankEntryCollection();
        CostObjectInfo co = null;
        String coid = null;
        int rank = -1;
        Iterator ite = computedResults.entrySet().iterator();
        CostObjectRankEntryInfo entry = null;
        while (ite.hasNext()) {
            Map.Entry me = ite.next();
            coid = (String)me.getKey();
            if (me.getValue() == null) continue;
            co = new CostObjectInfo();
            co.setId(BOSUuid.read((String)coid));
            entry = new CostObjectRankEntryInfo();
            entry.setCostObject(co);
            rank = (Integer)me.getValue();
            entry.setRank(rank);
            entries.add(entry);
        }
        return entries;
    }

    private void throwErrorTip(String coID) throws BOSException, EASBizException, UuidException {
        ICostObject ico = CostObjectFactory.getLocalInstance((Context)this.ctx);
        CostObjectInfo co = ico.getCostObjectInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)coID)));
        String number = co.getNumber();
        throw new EASBizException(EASBizException.CHECKDUPLICATED, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"114_CostObjectRankControllerBean", (Locale)this.ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"115_CostObjectRankControllerBean", (Locale)this.ctx.getLocale())});
    }

    public void checkDuplication(Context ctx, IObjectValue model, boolean checkSelf) throws BOSException, EASBizException {
        CostObjectRankInfo corInfo = (CostObjectRankInfo)model;
        String comId = "'" + corInfo.getCompanyOrg().getId().toString() + "'";
        String periodId = "'" + corInfo.getCalculatePeriod().getId().toString() + "'";
        CostObjectRankEntryCollection entrys = corInfo.getEntrys();
        int n = entrys.size();
        Object[] pks = new String[n];
        CostObjectRankEntryInfo entry = null;
        for (int i = 0; i < n; ++i) {
            entry = entrys.get(i);
            pks[i] = entry.getCostObject().getId().toString();
        }
        StringBuffer corEntryIDs = BDCMUtils.splitPK((Object[])pks);
        StringBuffer query = new StringBuffer();
        query.append("SELECT B.FID FROM T_CAL_CostObjectRank A LEFT OUTER JOIN ").append(" T_CAL_CostObjectRankENTRY B ON A.FID = B.FPARENTID").append(" WHERE A.FCOMPANYORG =").append(comId).append(" AND A.FCalculatePeriod =").append(periodId).append(" AND (FBillStatus = 4 OR FBillStatus = 2)").append(checkSelf ? " " : " AND A.FID <> '" + corInfo.getId().toString() + "'").append(" AND B.FCostObjectID in (").append(corEntryIDs.toString()).append(")");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)query.toString());
        if (rs.size() > 0) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"116_CostObjectRankControllerBean", (Locale)ctx.getLocale())});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _checkCycleReference(Context ctx, String comId, String periodId, LowLevelCodeTypeEnum llcType) throws BOSException, EASBizException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("companyId", comId);
            param.put("periodId", periodId);
            param.put("llcType", (Object)llcType);
            param.put("ctx", ctx);
            Object[] obj = this.calculateLLC(ctx, param);
            List cycledCO = (List)obj[0];
            Map objReferObjMap = (Map)obj[3];
            Map map = this.buildResults(cycledCO, objReferObjMap);
            return map;
        }
        finally {
            this.dropTable();
        }
    }

    private Map buildResults(List cycledCO1, Map objReferobjMap) throws BOSException {
        if (cycledCO1.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap co_billNumbers = new HashMap(cycledCO1.size());
        for (int i = 0; i < cycledCO1.size(); ++i) {
            StringBuffer coNumber = new StringBuffer();
            HashSet<String> billNumber = new HashSet<String>();
            String cycledCoID = (String)cycledCO1.get(i);
            List cycledCoReferCo = (List)objReferobjMap.get(cycledCoID);
            try {
                if (cycledCoReferCo == null) {
                    StringBuffer getNumberSQL = new StringBuffer();
                    getNumberSQL.append("SELECT co.FNumber,entry.FBillNumber FROM T_BD_CostObject co ").append(" LEFT JOIN " + this.sql_TMP_Uion + " AS entry ON co.fid = entry.FCO1").append(" WHERE co.FID ='").append(cycledCoID).append("' and FCO2 = '").append(cycledCoID).append("'");
                    IRowSet rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)getNumberSQL.toString());
                    while (rs.next()) {
                        if (rs.getString(1) != null && coNumber.indexOf(rs.getString(1)) == -1) {
                            coNumber.append(",");
                            coNumber.append(rs.getString(1));
                        }
                        if (rs.getString(2) == null || billNumber.contains(rs.getString(2))) continue;
                        billNumber.add(rs.getString(2));
                    }
                    co_billNumbers.put(coNumber.substring(1), billNumber);
                    continue;
                }
                for (int j = 0; j < cycledCoReferCo.size() - 1; ++j) {
                    StringBuffer querySQL = new StringBuffer();
                    querySQL.append("SELECT co.FNumber,entry.FBillNumber FROM T_BD_CostObject co ").append(" LEFT JOIN " + this.sql_TMP_Uion + " AS entry ON co.fid = entry.FCO1").append(" WHERE co.FID ='").append(cycledCoReferCo.get(j + 1)).append("' and FCO2 = '").append(cycledCoReferCo.get(j)).append("'");
                    IRowSet rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)querySQL.toString());
                    while (rs.next()) {
                        if (rs.getString(1) != null && coNumber.indexOf(rs.getString(1)) == -1) {
                            coNumber.append(",");
                            coNumber.append(rs.getString(1));
                        }
                        if (rs.getString(2) == null || billNumber.contains(rs.getString(2))) continue;
                        billNumber.add(rs.getString(2));
                    }
                }
                co_billNumbers.put(coNumber.substring(1), billNumber);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return co_billNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _checkAndMakeBill(Context ctx, Map param) throws BOSException, EASBizException {
        String comId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        LowLevelCodeTypeEnum llcType = (LowLevelCodeTypeEnum)((Object)param.get("llcType"));
        if (!param.containsKey("ctx")) {
            param.put("ctx", ctx);
        }
        try {
            Object[] obj = this.calculateLLC(ctx, param);
            List cycledCO = (List)obj[0];
            Map objMap = (Map)obj[1];
            Map objReferObjMap = (Map)obj[3];
            Map co_billNumbers = this.buildResults(cycledCO, objReferObjMap);
            if (!cycledCO.isEmpty()) {
                Map map = co_billNumbers;
                return map;
            }
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("companyOrg", (Object)comId);
            filter.appendFilterItem("calculatePeriod", (Object)periodId);
            filter.appendFilterItem("llcType", (Object)llcType.getValue());
            ICostObjectRank ibiz = CostObjectRankFactory.getLocalInstance(ctx);
            ibiz.delete(filter);
            CostObjectRankCollection colls = new CostObjectRankCollection();
            CostObjectRankInfo corInfo = new CostObjectRankInfo();
            corInfo.setNumber("sun" + System.currentTimeMillis());
            corInfo.setLlcType(llcType);
            corInfo.put("entrys", this.buildBillResults(objMap));
            colls.add(corInfo);
            NCMServerUtils.makeBills((Context)ctx, (String)comId, (String)periodId, (ICMBillBase)ibiz, (IObjectCollection)colls, (boolean)false);
            Map map = co_billNumbers;
            return map;
        }
        catch (Exception e) {
            logger.fatal((Object)"", (Throwable)e);
        }
        finally {
            this.dropTable();
        }
        return null;
    }

    private Object[] calculateLLC(Context ctx, Map param) throws BOSException, EASBizException {
        String comId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        LowLevelCodeTypeEnum llcType = (LowLevelCodeTypeEnum)((Object)param.get("llcType"));
        this.ctx = ctx;
        this.comId2 = "'" + comId + "'";
        this.periodId2 = "'" + periodId + "'";
        this.createTable();
        String query = null;
        IRowSet rs = null;
        if (0 == llcType.getValue()) {
            rs = this.buildNormalCORefData(ctx, param);
        } else if (1 == llcType.getValue()) {
            query = this.getCostRecoSQL(comId, periodId);
            rs = this.executeInsert(query);
        } else if (2 == llcType.getValue()) {
            query = this.getDynamicCostSQL(comId, periodId);
            rs = this.executeInsert(query);
        } else {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"117_CostObjectRankControllerBean", (Locale)ctx.getLocale()));
        }
        Object[] obj = LowLevelCode.calculateAll((boolean)this.isCostObjectRankByLow(ctx, comId), (IRowSet)rs);
        return obj;
    }

    private boolean isCostObjectRankByLow(Context ctx, String companyId) throws BOSException {
        IParamControl ipctr = null;
        ipctr = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        try {
            ObjectUuidPK com = new ObjectUuidPK(companyId);
            String st = ipctr.getParamValue((IObjectPK)com, "CM007");
            return st.compareTo("1") == 0;
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object[] _calcLLCForTrees(Context ctx, String comId, String periodId, LowLevelCodeTypeEnum llcType) throws BOSException, EASBizException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("companyId", comId);
            param.put("periodId", periodId);
            param.put("llcType", (Object)llcType);
            param.put("ctx", ctx);
            Object[] obj = this.calculateLLC(ctx, param);
            List cycledCO = (List)obj[0];
            if (!cycledCO.isEmpty()) {
                this.throwErrorTip((String)cycledCO.get(0));
            }
            Object[] objectArray = obj;
            return objectArray;
        }
        finally {
            this.dropTable();
        }
    }
}

