/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.ncm.cal.app.FindCycle;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LLCCalculator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.app.LLCCalculator");
    private Context ctx;
    private String T_TMP_CORef;
    private String T_TMP_CORank;
    private String companyId;

    public LLCCalculator(Context ctx, String T_TMP_CORef, String companyId) {
        this.ctx = ctx;
        this.T_TMP_CORef = T_TMP_CORef;
        this.companyId = companyId;
    }

    public Map calc() throws Exception {
        if (this.T_TMP_CORank != null) {
            throw new Exception("\u4e0d\u5141\u8bb8\u53cd\u590d\u8c03\u7528\u3002");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.init()) {
            return result;
        }
        result.put("T_TMP_CORank", this.T_TMP_CORank);
        List<String> cycResult = this.rank();
        result.put("cycResult", cycResult);
        return result;
    }

    public void release() {
        if (this.T_TMP_CORank != null) {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(this.T_TMP_CORank);
        }
    }

    private boolean init() throws Exception {
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T (");
        ksql.append("    FCostObjectID VARCHAR(44), \n");
        ksql.append("    FRank int \n");
        ksql.append(") \n");
        this.T_TMP_CORank = TempTablePool.getInstance((Context)this.ctx).createTempTable(ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into " + this.T_TMP_CORank + " (FCostObjectID, FRank) \n");
        ksql.append("select FCO1, -1 \n");
        ksql.append("from " + this.T_TMP_CORef + " \n");
        ksql.append("where FCO1 is not null \n");
        ksql.append("union \n");
        ksql.append("select FCO2, -1 \n");
        ksql.append("from " + this.T_TMP_CORef + " \n");
        ksql.append("where FCO2 is not null \n");
        NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        TempTablePool.getInstance((Context)this.ctx).createIndex(this.T_TMP_CORank, "FCostObjectID", true, false);
        return this.isRankExists(-1);
    }

    private List<String> rank() throws Exception {
        block6: {
            StringBuffer ksql = new StringBuffer();
            ksql.setLength(0);
            ksql.append("update " + this.T_TMP_CORank + " set FRank = 0 \n");
            ksql.append("where not exists ( \n");
            ksql.append("    select 1 from " + this.T_TMP_CORef + " d \n");
            ksql.append("    where d.FCO2 = " + this.T_TMP_CORank + ".FCostObjectID \n");
            ksql.append("    and d.FCO1 is not null \n");
            ksql.append(") \n");
            NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
            if (this.isRankExists(0)) {
                int rank = 1;
                while (true) {
                    ksql.setLength(0);
                    ksql.append("update " + this.T_TMP_CORank + " set FRank = " + rank + " \n");
                    ksql.append("where FCostObjectID in ( \n");
                    ksql.append("    select d.FCO2  \n");
                    ksql.append("    from " + this.T_TMP_CORef + " d  \n");
                    ksql.append("    join " + this.T_TMP_CORank + " r on r.FCostObjectID = d.FCO1 \n");
                    ksql.append("    where r.FRank = " + (rank - 1) + "  \n");
                    ksql.append(") \n");
                    NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
                    if (!this.isRankExists(rank)) {
                        if (this.isRankExists(-1)) {
                            List<String> result = this.findCycleByMemory(-1);
                            return result;
                        }
                        break block6;
                    }
                    if (rank >= 25) {
                        List<String> result = this.findCycleByMemory(rank);
                        return result;
                    }
                    ++rank;
                }
            }
            List<String> result = this.findCycleByMemory(-1);
            return result;
        }
        if (this.ctx != null) {
            List<String> result = this.findCycleByMemory(-1);
            return result;
        }
        return new ArrayList<String>();
    }

    private List<String> findCycleByMemory(int rank) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> matNums = new ArrayList<String>();
        byte[][] matrix = this.structureMatrix(rank, matNums);
        FindCycle tc = new FindCycle(matrix.length, matrix);
        Set<String> cycles = tc.getCycleNodes();
        for (int i = 0; i < matrix.length; ++i) {
            if (cycles.contains(String.valueOf(i))) continue;
            tc.findCycle(i);
        }
        List<List<String>> cycleLists = tc.getCycleLists();
        for (int index = 0; index < cycleLists.size(); ++index) {
            List<String> cycleList = cycleLists.get(index);
            StringBuffer cycleResult = new StringBuffer();
            for (int nodeIndex = 0; nodeIndex < cycleList.size(); ++nodeIndex) {
                int node = Integer.parseInt(cycleList.get(nodeIndex));
                cycleResult.append((String)matNums.get(node)).append("-->");
            }
            cycleResult.append((String)matNums.get(Integer.parseInt(cycleList.get(0))));
            result.add(cycleResult.toString());
        }
        return result;
    }

    private byte[][] structureMatrix(int rank, List<String> matNums) {
        byte[][] matrix = null;
        try {
            boolean isOutsourcCalc = NCMUtils.isDoOutSourcCalc((Context)this.ctx, (String)this.companyId);
            int matNum = 0;
            StringBuffer ksql = new StringBuffer();
            ksql.append(" select distinct FcostObjectID,co.FNumber from ").append(this.T_TMP_CORank).append(" rank \n");
            if (isOutsourcCalc) {
                ksql.append("  inner join t_bd_material co on co.fid = rank.FCostObjectID \n");
            } else {
                ksql.append("  inner join t_bd_costObject co on co.fid = rank.FCostObjectID \n");
            }
            IRowSet rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)ksql.toString());
            ksql.setLength(0);
            ArrayList<String> mats = new ArrayList<String>();
            while (rs.next()) {
                mats.add(rs.getString(1));
                matNums.add(rs.getString(2));
            }
            matNum = mats.size();
            matrix = new byte[matNum][matNum];
            ksql.append("select distinct Fco1,Fco2 from ").append(this.T_TMP_CORef).append(" \n");
            ksql.append("Where Fco1 in (\n");
            ksql.append("  select FcostObjectID from ").append(this.T_TMP_CORank);
            ksql.append(") and FCO1 is not null and Fco2 is not null \n");
            IRowSet matRef = NCMDbUtil.executeQuery((Context)this.ctx, (String)ksql.toString());
            while (matRef.next()) {
                String co1ID = matRef.getString(1);
                String co2ID = matRef.getString(2);
                int co1Index = mats.indexOf(co1ID);
                int co2Index = mats.indexOf(co2ID);
                if (co1Index < 0 || co1Index > matNum || co2Index < 0 || co2Index > matNum) continue;
                matrix[co1Index][co2Index] = 1;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return matrix;
    }

    private Cycle findCycle(int rank) throws Exception {
        block6: {
            String costObjectId;
            IRowSet rs;
            StringBuffer ksql;
            String T_TMP_Cycle;
            block5: {
                Cycle cycle;
                T_TMP_Cycle = null;
                try {
                    Cycle cycle2;
                    ksql = new StringBuffer();
                    ksql.setLength(0);
                    ksql.append("select top 1 FCostObjectID from " + this.T_TMP_CORank + " \n");
                    ksql.append("where FRank = " + rank + " \n");
                    rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)ksql.toString());
                    costObjectId = null;
                    if (!rs.next()) {
                        throw new Exception("\u65e0\u6548\u6570\u636e\u3002");
                    }
                    costObjectId = rs.getString(1);
                    ksql.setLength(0);
                    ksql.append("create table T ( \n");
                    ksql.append("    FCO1 VARCHAR(44), \n");
                    ksql.append("    FCO2 VARCHAR(44), \n");
                    ksql.append("    FBillNumber NVARCHAR(80) \n");
                    ksql.append(") \n");
                    T_TMP_Cycle = TempTablePool.getInstance((Context)this.ctx).createTempTable(ksql.toString());
                    ksql.setLength(0);
                    ksql.append("insert into " + T_TMP_Cycle + " \n");
                    ksql.append("(FCO1, FCO2, FBillNumber) \n");
                    ksql.append("select FCO1, FCO2, FBillNumber \n");
                    ksql.append("from " + this.T_TMP_CORef + " \n");
                    ksql.append("where FCO1 = '" + costObjectId + "' \n");
                    NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
                    TempTablePool.getInstance((Context)this.ctx).createIndex(T_TMP_Cycle, "FCO1", false, false);
                    TempTablePool.getInstance((Context)this.ctx).createIndex(T_TMP_Cycle, "FCO2", false, false);
                    ksql.setLength(0);
                    ksql.append("select top 1 FCO1, FCO2, FBillNumber \n");
                    ksql.append("from " + T_TMP_Cycle + " \n");
                    ksql.append("where FCO2 = '" + costObjectId + "' \n");
                    rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)ksql.toString());
                    if (!rs.next()) break block5;
                    cycle = cycle2 = new Cycle(rs.getString("FCO1"), rs.getString("FCO2"), rs.getString("FBillNumber"));
                }
                catch (Throwable throwable) {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable(T_TMP_Cycle);
                    throw throwable;
                }
                TempTablePool.getInstance((Context)this.ctx).releaseTable(T_TMP_Cycle);
                return cycle;
            }
            Cycle nextCycle = this.findCycle(T_TMP_Cycle, costObjectId);
            ksql.setLength(0);
            ksql.append("select top 1 FCO1, FCO2, FBillNumber \n");
            ksql.append("from " + T_TMP_Cycle + " \n");
            ksql.append("where FCO2 = '" + nextCycle.co1 + "' \n");
            rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)ksql.toString());
            if (!rs.next()) break block6;
            Cycle cycle = new Cycle(rs.getString("FCO1"), rs.getString("FCO2"), rs.getString("FBillNumber"));
            cycle.next = nextCycle;
            Cycle cycle3 = cycle;
            TempTablePool.getInstance((Context)this.ctx).releaseTable(T_TMP_Cycle);
            return cycle3;
        }
        throw new Exception("\u65e0\u6548\u6570\u636e\u3002");
    }

    private Cycle findCycle(String T_TMP_CyclePre, String costObjectId) throws Exception {
        block5: {
            IRowSet rs;
            StringBuffer ksql;
            String T_TMP_Cycle;
            block4: {
                Cycle cycle;
                T_TMP_Cycle = null;
                try {
                    Cycle cycle2;
                    ksql = new StringBuffer();
                    ksql.setLength(0);
                    ksql.append("create table T ( \n");
                    ksql.append("    FCO1 VARCHAR(44), \n");
                    ksql.append("    FCO2 VARCHAR(44), \n");
                    ksql.append("    FBillNumber NVARCHAR(80) \n");
                    ksql.append(") \n");
                    T_TMP_Cycle = TempTablePool.getInstance((Context)this.ctx).createTempTable(ksql.toString());
                    ksql.setLength(0);
                    ksql.append("insert into " + T_TMP_Cycle + " \n");
                    ksql.append("(FCO1, FCO2, FBillNumber) \n");
                    ksql.append("select ref.FCO1, ref.FCO2, ref.FBillNumber \n");
                    ksql.append("from " + this.T_TMP_CORef + " ref \n");
                    ksql.append("join " + T_TMP_CyclePre + " pre on pre.FCO2 = ref.FCO1 ");
                    NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
                    TempTablePool.getInstance((Context)this.ctx).createIndex(T_TMP_Cycle, "FCO1", false, false);
                    TempTablePool.getInstance((Context)this.ctx).createIndex(T_TMP_Cycle, "FCO2", false, false);
                    ksql.setLength(0);
                    ksql.append("select top 1 FCO1, FCO2, FBillNumber \n");
                    ksql.append("from " + T_TMP_Cycle + " \n");
                    ksql.append("where FCO2 = '" + costObjectId + "' \n");
                    rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)ksql.toString());
                    if (!rs.next()) break block4;
                    cycle = cycle2 = new Cycle(rs.getString("FCO1"), rs.getString("FCO2"), rs.getString("FBillNumber"));
                }
                catch (Throwable throwable) {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable(T_TMP_Cycle);
                    throw throwable;
                }
                TempTablePool.getInstance((Context)this.ctx).releaseTable(T_TMP_Cycle);
                return cycle;
            }
            Cycle nextCycle = this.findCycle(T_TMP_Cycle, costObjectId);
            ksql.setLength(0);
            ksql.append("select top 1 FCO1, FCO2, FBillNumber \n");
            ksql.append("from " + T_TMP_Cycle + " \n");
            ksql.append("where FCO2 = '" + nextCycle.co1 + "' \n");
            rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)ksql.toString());
            if (!rs.next()) break block5;
            Cycle cycle = new Cycle(rs.getString("FCO1"), rs.getString("FCO2"), rs.getString("FBillNumber"));
            cycle.next = nextCycle;
            Cycle cycle3 = cycle;
            TempTablePool.getInstance((Context)this.ctx).releaseTable(T_TMP_Cycle);
            return cycle3;
        }
        throw new Exception("\u65e0\u6548\u6570\u636e\u3002");
    }

    private boolean isRankExists(int rank) throws Exception {
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 1 1 from " + this.T_TMP_CORank + " \n");
        ksql.append("where FRank = " + rank + " \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)ksql.toString());
        return rs.next();
    }

    public static class Cycle {
        String co1;
        String co2;
        String billNumber;
        Cycle next;

        public Cycle() {
        }

        public Cycle(String co1, String co2, String billNumber) {
            this.co1 = co1;
            this.co2 = co2;
            this.billNumber = billNumber;
        }
    }
}

