/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CostObjectRankCollection;
import com.kingdee.eas.ncm.cal.CostObjectRankEntryCollection;
import com.kingdee.eas.ncm.cal.CostObjectRankEntryInfo;
import com.kingdee.eas.ncm.cal.CostObjectRankFactory;
import com.kingdee.eas.ncm.cal.CostObjectRankInfo;
import com.kingdee.eas.ncm.cal.ICostObjectRank;
import com.kingdee.eas.ncm.cal.LowLevelCodeTypeEnum;
import com.kingdee.eas.ncm.cal.app.LLCCalculator;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.ICMBillBase;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.algorithm.LowLevelCode;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.scm.cal.app.DevolveWriteOffFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LowLevelCodeBuilderByMat {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.app.LowLevelCodeBuilder");
    private Map param;
    private Context ctx;
    private String companyId;
    private String periodId;
    private LowLevelCodeTypeEnum llcType;
    private TempTablePool pool;
    private String T_TMP_CORef;

    public LowLevelCodeBuilderByMat(Map param) {
        this.param = param;
        this.ctx = (Context)param.get("ctx");
        this.companyId = (String)param.get("companyId");
        this.periodId = (String)param.get("periodId");
        this.llcType = (LowLevelCodeTypeEnum)((Object)param.get("llcType"));
        this.pool = TempTablePool.getInstance((Context)this.ctx);
    }

    private void init() throws Exception {
        StringBuffer ksql = new StringBuffer();
        ksql.append("Create Table T \n");
        ksql.append("( \n");
        ksql.append("    FCO1 VARCHAR(44),FCO2 VARCHAR(44), \n");
        ksql.append("    FBillNumber NVARCHAR(80), FSeq int \n");
        ksql.append(") \n");
        this.T_TMP_CORef = this.pool.createTempTable(ksql.toString());
    }

    private void release() throws Exception {
        if (this.T_TMP_CORef != null) {
            this.pool.releaseTable(this.T_TMP_CORef);
        }
    }

    public Map build2() throws Exception {
        LLCCalculator calculator = null;
        try {
            String cuId;
            String userId;
            PeriodInfo period;
            List costObjectIds;
            this.init();
            if (this.isDirectChecker()) {
                this.buildNormalDirectCORefData(this.ctx, this.param);
            } else {
                this.buildNormalCORefData(this.ctx, this.param);
            }
            calculator = new LLCCalculator(this.ctx, this.T_TMP_CORef, this.companyId);
            Map result = calculator.calc();
            if (result.containsKey("cycResult") && (costObjectIds = (List)result.get("cycResult")).size() > 0) {
                Map map = result;
                return map;
            }
            if (this.isDirectChecker()) {
                costObjectIds = null;
                return costObjectIds;
            }
            StringBuffer ksql = new StringBuffer();
            ksql.append("delete from T_Cal_CostObjectRankEntry \n");
            ksql.append("where FParentID in ( \n");
            ksql.append("    select FID from T_Cal_CostObjectRank \n");
            ksql.append("    where FCompanyOrg = '" + this.companyId + "' \n");
            ksql.append("    and FCalculatePeriod = '" + this.periodId + "' \n");
            ksql.append("    and FllcType = " + this.llcType.getValue() + " \n");
            ksql.append(") \n");
            ksql.append("; \n");
            ksql.append("delete from T_Cal_CostObjectRank \n");
            ksql.append("where FCompanyOrg = '" + this.companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + this.periodId + "' \n");
            ksql.append("and FllcType = " + this.llcType.getValue() + " \n");
            ksql.append("; \n");
            NCMDbUtil.BatchSqlExecute((Context)this.ctx, (String)ksql.toString());
            String T_TMP_CORank = (String)result.get("T_TMP_CORank");
            if (T_TMP_CORank == null) {
                Map map = null;
                return map;
            }
            String rankId = BOSUuid.create((BOSObjectType)new BOSObjectType("C8E0EBC4")).toString();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.param.get("company");
            if (company == null) {
                company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.companyId));
            }
            if ((period = (PeriodInfo)this.param.get("period")) == null) {
                period = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(this.periodId));
            }
            if ((userId = (String)this.param.get("userId")) == null) {
                userId = "";
            }
            if ((cuId = (String)this.param.get("cuId")) == null && ContextUtil.getCurrentCtrlUnit((Context)this.ctx) != null) {
                cuId = ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId().toString();
            }
            if (cuId == null) {
                cuId = "";
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String endDate = format.format(period.getEndDate());
            ksql.setLength(0);
            ksql.append("insert into T_Cal_CostObjectRank \n");
            ksql.append("( \n");
            ksql.append("    FID, FNumber, \n");
            ksql.append("    FCompanyOrg, FCalculatePeriod, FControlUnitID, \n");
            ksql.append("    FIsAuto, FllcType, FBillStatus, \n");
            ksql.append("    FBizDate, \n");
            ksql.append("    FCreatorID, FCreateTime, \n");
            ksql.append("    FLastUpdateUserID, FLastUpdateTime, \n");
            ksql.append("    FAuditorID, FAuditTime \n");
            ksql.append(") \n");
            ksql.append("values \n");
            ksql.append("( \n");
            ksql.append("    '" + rankId + "', '" + company.getNumber() + "-" + period.getNumber() + "', \n");
            ksql.append("    '" + this.companyId + "', '" + this.periodId + "', '" + cuId + "', \n");
            ksql.append("    1, " + this.llcType.getValue() + ", 4, \n");
            ksql.append("    {TS '" + endDate + "'}, \n");
            ksql.append("    '" + userId + "', getdate(), \n");
            ksql.append("    '" + userId + "', getdate(), \n");
            ksql.append("    '" + userId + "', getdate() \n");
            ksql.append(") \n");
            ksql.append("; \n");
            CostDataCache costDataCache = (CostDataCache)this.param.get("CostDataCache");
            String T_TMP_CostObject = costDataCache.getCostObjectTable();
            ksql.append("insert into T_Cal_CostObjectRankEntry \n");
            ksql.append("( \n");
            ksql.append("    FID, FSeq, FParentID, \n");
            ksql.append("    FCostObjectID, FRank \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    newbosid('186FE70E'), 1, '" + rankId + "', \n");
            ksql.append("    FCostObjectID, FRank \n");
            ksql.append("from " + T_TMP_CORank + " \n");
            ksql.append("; \n");
            NCMDbUtil.BatchSqlExecute((Context)this.ctx, (String)ksql.toString());
            Map map = result;
            return map;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (calculator != null) {
                calculator.release();
            }
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map build() throws Exception {
        try {
            this.init();
            Object[] obj = this.calculateLLC(this.ctx, this.param);
            List cycledCO = (List)obj[0];
            Map objMap = (Map)obj[1];
            Map objReferObjMap = (Map)obj[3];
            Map co_billNumbers = this.buildResults(cycledCO, objReferObjMap);
            if (!cycledCO.isEmpty()) {
                Map map = co_billNumbers;
                return map;
            }
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("companyOrg", (Object)this.companyId);
            filter.appendFilterItem("calculatePeriod", (Object)this.periodId);
            filter.appendFilterItem("llcType", (Object)this.llcType.getValue());
            ICostObjectRank ibiz = CostObjectRankFactory.getLocalInstance(this.ctx);
            ibiz.delete(filter);
            CostObjectRankCollection colls = new CostObjectRankCollection();
            CostObjectRankInfo corInfo = new CostObjectRankInfo();
            corInfo.setNumber("sun" + System.currentTimeMillis());
            corInfo.setLlcType(this.llcType);
            corInfo.put("entrys", this.buildBillResults(objMap));
            colls.add(corInfo);
            NCMServerUtils.makeBills((Context)this.ctx, (String)this.companyId, (String)this.periodId, (ICMBillBase)ibiz, (IObjectCollection)colls, (boolean)false);
            Map map = co_billNumbers;
            return map;
        }
        finally {
            this.release();
        }
    }

    private void buildNormalDirectCORefData(Context ctx, Map param) throws Exception {
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        String T_TMP_MatReq = costDataCache.getMatReqTable();
        String T_TMP_CostAdjust = costDataCache.getCostAdjustTable();
        String T_TMP_CostObject = costDataCache.getCostObjectTable();
        StringBuffer ksql = new StringBuffer();
        ksql.append("Insert Into " + this.T_TMP_CORef + " ( \n");
        ksql.append("    FCO1, FCO2, FBillNumber, FSeq \n");
        ksql.append(") \n");
        ksql.append("SELECT distinct \n");
        ksql.append("    t.FCostObjectID, \n");
        ksql.append("    case when ( \n");
        ksql.append("            t.FIsReWork is null \n");
        ksql.append("            or t.FIsReWork = 0 \n");
        ksql.append("        ) then co.FCostObjectID \n");
        ksql.append("        else null \n");
        ksql.append("    end as CO2,  \n");
        ksql.append("    t.FNumber, \n");
        ksql.append("    t.FSeq \n");
        ksql.append("from " + T_TMP_MatReq + " t \n");
        ksql.append("INNER JOIN " + T_TMP_CostObject + " COREF \n");
        ksql.append("    on COREF.FCostObjectID = t.FCostObjectID \n");
        ksql.append("left JOIN " + T_TMP_CostObject + " co \n");
        ksql.append("    on co.FMaterialID = t.FMaterialID \n");
        ksql.append("WHERE ( \n");
        ksql.append("    (co.FCalculateMode = 1) \n");
        ksql.append("    or \n");
        ksql.append("    co.FCalculateMode = 3 \n");
        ksql.append("    or \n");
        ksql.append("    (co.FCalculateMode = 4 and isnull(t.FLot,' ') = isnull(co.FBatchNumber,' ')) \n");
        ksql.append("    or \n");
        ksql.append("    (co.FCalculateMode = 7 and isnull(t.FLot,' ') = isnull(co.FBatchNumber,' ')) \n");
        ksql.append(") \n");
        ksql.append("and (t.FCostObjectID is not null or co.FCostObjectID is not null) \n");
        ksql.append("; \n");
        ksql.append("Insert Into " + this.T_TMP_CORef + " ( \n");
        ksql.append("    FCO1, FCO2, FBillNumber, FSeq \n");
        ksql.append(") \n");
        ksql.append("SELECT distinct \n");
        ksql.append("    t.FCostObjectID, \n");
        ksql.append("    CO.FCostObjectID CO2,  \n");
        ksql.append("    t.FNumber, \n");
        ksql.append("    t.FSeq \n");
        ksql.append("from " + T_TMP_CostAdjust + " t \n");
        ksql.append("INNER JOIN " + T_TMP_CostObject + " COREF \n");
        ksql.append("    on COREF.FCostObjectID = t.FCostObjectID \n");
        ksql.append("left JOIN " + T_TMP_CostObject + " co \n");
        ksql.append("    on co.FMaterialID = t.FMaterialID \n");
        ksql.append("WHERE ( \n");
        ksql.append("    (co.FCalculateMode = 1) \n");
        ksql.append("    or \n");
        ksql.append("    co.FCalculateMode = 3 \n");
        ksql.append("    or \n");
        ksql.append("    (co.FCalculateMode = 4 and isnull(t.FLot,' ') = isnull(co.FBatchNumber,' ')) \n");
        ksql.append("    or \n");
        ksql.append("    (co.FCalculateMode = 7 and isnull(t.FLot,' ') = isnull(co.FBatchNumber,' ')) \n");
        ksql.append(") \n");
        ksql.append("and (t.FCostObjectID is not null or co.FCostObjectID is not null) \n");
        ksql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)ksql.toString());
        TempTablePool.getInstance((Context)ctx).createIndex(this.T_TMP_CORef, "FCO1", false, false);
        TempTablePool.getInstance((Context)ctx).createIndex(this.T_TMP_CORef, "FCO2", false, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRowSet buildNormalCORefData(Context ctx, Map param) throws BOSException, EASBizException {
        IRowSet iRowSet;
        block7: {
            CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
            String t_MatAllocResult = null;
            String T_TMP_COID = null;
            try {
                CalSeverUtils.ClearInvalidAllocResult(param);
                t_MatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)this.companyId, (String)"T_NCM_MatAllocResult");
                if (StringUtils.isEmpty((String)t_MatAllocResult)) {
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"105_CostObjectRankControllerBean", (Locale)ctx.getLocale())});
                }
                StringBuffer sql = new StringBuffer();
                this.buildNormalCORefDataMatReqAlloc(ctx, param, t_MatAllocResult);
                this.buildNormalCORefDataCostAdjustAlloc(ctx, param, t_MatAllocResult);
                this.buildNormalCORefDataOtherInWarehsAlloc(ctx, param, t_MatAllocResult);
                this.buildNormalCORefDataInputQty(ctx, param);
                this.buildOutSourcMat(ctx, param);
                sql.setLength(0);
                sql.append("create table T ( \n");
                sql.append("    FCostObjectID varchar(44) \n");
                sql.append(") \n");
                T_TMP_COID = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
                String T_TMP_InputQty = costDataCache.getInputQtyTable();
                sql.setLength(0);
                sql.append("insert into " + T_TMP_COID + " ( \n");
                sql.append("    FCostObjectID \n");
                sql.append(") \n");
                sql.append("select \n");
                sql.append("    FCostObjectID \n");
                sql.append("from " + T_TMP_InputQty + " \n");
                sql.append("group by FCostObjectID \n");
                sql.append("having sum(FQty) <> 0 \n");
                sql.append("; \n");
                NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sql.toString());
                TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_COID, "FCostObjectID", true, false);
                sql.setLength(0);
                sql.append("update " + this.T_TMP_CORef + " \n");
                sql.append("set FCO2 = null \n");
                sql.append("where FCO2 is not null \n");
                sql.append("and not exists ( \n");
                sql.append("    select 1 from " + T_TMP_COID + " co \n");
                sql.append("    where co.FCostObjectID = " + this.T_TMP_CORef + ".FCO2 \n");
                sql.append("); \n");
                sql.setLength(0);
                sql.append("update " + this.T_TMP_CORef + " \n");
                sql.append("set FCO2 = null \n");
                sql.append("where exists ( \n");
                sql.append("    select 1 from T_BD_MaterialCompanyInfo matcom \n");
                sql.append("    where matcom.FMaterialID = " + this.T_TMP_CORef + ".FCO2 and matCom.FcalculateType = " + 0);
                sql.append(" and matcom.FCOMPANYID = '").append(this.companyId).append("'");
                sql.append("); \n");
                NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sql.toString());
                TempTablePool.getInstance((Context)ctx).createIndex(this.T_TMP_CORef, "FCO1", false, false);
                TempTablePool.getInstance((Context)ctx).createIndex(this.T_TMP_CORef, "FCO2", false, false);
                iRowSet = null;
                if (T_TMP_COID == null) break block7;
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                    catch (Exception e2) {
                        throw new BOSException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (T_TMP_COID != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_COID);
                    }
                    throw throwable;
                }
            }
            TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_COID);
        }
        return iRowSet;
    }

    private void buildNormalCORefDataMatReqAlloc(Context ctx, Map param, String t_MatAllocResult) throws Exception {
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        String T_TMP_MatReq = costDataCache.getMatReqTable();
        String T_TMP_CostObject = costDataCache.getCostObjectTable();
        StringBuffer query = new StringBuffer();
        query.setLength(0);
        query.append("Insert Into " + this.T_TMP_CORef + " ( \n");
        query.append("    FCO1, FCO2, FBillNumber \n");
        query.append(") \n");
        query.append("SELECT distinct \n");
        query.append("    COREF.FMaterialID, \n");
        query.append("    case when ( \n");
        query.append("            t.FIsReWork is null \n");
        query.append("            or t.FIsReWork = 0 \n");
        query.append("        ) then r.FMaterialID \n");
        query.append("        else null \n");
        query.append("    end as CO2,  \n");
        query.append("    t.FNumber \n");
        query.append("FROM " + t_MatAllocResult + " r \n");
        query.append("JOIN " + T_TMP_MatReq + " t \n");
        query.append("    on t.FSourceBillEntryID = r.FSourceBillEntryID \n");
        query.append("    and r.AllocBillType = 'MF' \n");
        query.append("INNER JOIN " + T_TMP_CostObject + " COREF \n");
        query.append("    on r.FCostObjectID = COREF.FCostObjectID \n");
        query.append("       AND COREF.FIsMainProduct = 1 \n");
        NCMDbUtil.execute((Context)ctx, (String)query.toString());
    }

    private void buildNormalCORefDataCostAdjustAlloc(Context ctx, Map param, String t_MatAllocResult) throws Exception {
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        String T_TMP_CostAdjust = costDataCache.getCostAdjustTable();
        String T_TMP_CostObject = costDataCache.getCostObjectTable();
        StringBuffer query = new StringBuffer();
        query.setLength(0);
        query.append("Insert Into " + this.T_TMP_CORef + " ( \n");
        query.append("    FCO1, FCO2, FBillNumber \n");
        query.append(") \n");
        query.append("\n");
        query.append("SELECT \n");
        query.append("    COREF.FMaterialID, \n");
        query.append("    r.FMaterialID,  \n");
        query.append("    t.FNumber \n");
        query.append("FROM " + t_MatAllocResult + " r \n");
        query.append("JOIN " + T_TMP_CostAdjust + " t \n");
        query.append("    on t.FSourceBillEntryID = r.FSourceBillEntryID \n");
        query.append("    and r.AllocBillType = 'CA' \n");
        query.append("INNER JOIN " + T_TMP_CostObject + " COREF \n");
        query.append("    on r.FCostObjectID = COREF.FCostObjectID \n");
        query.append("       AND COREF.FIsMainProduct = 1 \n");
        NCMDbUtil.execute((Context)ctx, (String)query.toString());
    }

    private void buildNormalCORefDataOtherInWarehsAlloc(Context ctx, Map param, String t_MatAllocResult) throws Exception {
    }

    private void buildNormalCORefDataInputQty(Context ctx, Map param) throws Exception {
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        String T_TMP_CostObject = costDataCache.getCostObjectTable();
        StringBuffer query = new StringBuffer();
        String initbalanceName = ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.CalResource", (String)"Initbalance", (Locale)ctx.getLocale());
        String tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)this.companyId, (String)"T_NCM_Balance");
        String tblBalanceEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)this.companyId, (String)"T_NCM_BalanceEntry");
        String tblBalanceDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)this.companyId, (String)"T_NCM_BalanceMatDetail");
        query.setLength(0);
        query.append("Insert Into " + this.T_TMP_CORef + " ( \n");
        query.append("    FCO1, FCO2, FBillNumber \n");
        query.append(") \n");
        query.append("SELECT \n");
        query.append("    null co2, co.FMaterialID, \n");
        query.append("    null FNumber \n");
        query.append("FROM T_NCM_InputQtyBill B \n");
        query.append("LEFT OUTER JOIN T_NCM_InputQtyBillEntry E ON B.FID = E.FParentID \n");
        query.append("INNER JOIN ").append(T_TMP_CostObject).append(" co ON co.FCostObjectID = E.FCostObjectID \n");
        query.append("WHERE B.FCompanyOrg = '" + this.companyId + "' \n");
        query.append("    AND B.FCalculatePeriod = '" + this.periodId + "' \n");
        query.append("    and B.FBillStatus = 4 \n");
        query.append("    AND co.FIsMainProduct = 1 \n");
        query.append("GROUP BY B.FCompanyOrg, B.FCalculatePeriod, co.FMaterialID \n");
        query.append("HAVING SUM(E.FQty) <> 0 \n");
        query.append("UNION \n");
        query.append("SELECT co.FMaterialID, \n");
        query.append("    case when ( \n");
        query.append("            DT.FIsReWork = 1 \n");
        query.append("        ) then null \n");
        query.append("        else DT.FMaterialID \n");
        query.append("    end CO2, \n");
        query.append("    case when co.FCostObjectID is null then null \n");
        query.append("    else '" + initbalanceName + "' end FNumber \n");
        query.append("FROM ").append(tblBalance).append(" BB \n");
        query.append("LEFT JOIN ").append(tblBalanceEntry).append(" BE ON BE.FParentID = BB.FID \n");
        query.append("LEFT JOIN ").append(tblBalanceDetail).append(" DT ON DT.FParentID=BE.FID \n");
        query.append("LEFT JOIN " + T_TMP_CostObject + " co \n");
        query.append("    on co.FCostObjectID = BB.FCostObjectID \n");
        query.append("       and co.FIsMainProduct = 1 \n");
        NCMDbUtil.execute((Context)ctx, (String)query.toString());
    }

    private void buildOutSourcMat(Context ctx, Map param) throws Exception {
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        String T_TMP_CostObject = costDataCache.getCostObjectTable();
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Create Table T_NCM_TempMatRef ( \n");
        sql.append(" FOutsourcMatID VARCHAR(44), \n");
        sql.append(" FMatID VARCHAR(44) \n");
        sql.append(" ) \n");
        String T_NCM_TempOutSourcMat = NCMDbUtil.createTempTable((Context)this.ctx, (String)sql.toString());
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)this.companyId));
        PeriodInfo periodInfo = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.companyId);
        DevolveWriteOffFacadeControllerBean ctrl = new DevolveWriteOffFacadeControllerBean();
        IRowSet materialsRs = ctrl.getMaterialRowSet(ctx, companyInfo, periodInfo);
        if (materialsRs == null || materialsRs.size() < 1) {
            return;
        }
        sql.setLength(0);
        sql.append(" Insert Into ").append(T_NCM_TempOutSourcMat).append("(FOutsourcMatID,FMatID)  values (?,?) \n");
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e1) {
            logger.error((Object)"", (Throwable)e1);
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            while (materialsRs.next()) {
                pstmt.setString(1, materialsRs.getString(2));
                pstmt.setString(2, materialsRs.getString(3));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        sql.setLength(0);
        sql.append(" Insert Into " + this.T_TMP_CORef + " ( \n");
        sql.append("    FCO1, FCO2, FBillNumber \n");
        sql.append(" ) \n");
        sql.append(" Select outMat.FOutsourcMatID FMatID,outMat.FMatID FSubMatID,null \n");
        sql.append("   From ").append(T_NCM_TempOutSourcMat).append(" outMat \n");
        NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" Update ").append(this.T_TMP_CORef).append(" t1 set FCO2 = null \n");
        sql.append(" where not exists (select 1 from ").append(this.T_TMP_CORef).append(" t2 where t1.FCO2 = T2.FCO1 ); \n");
        NCMDbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getDynamicCostSQL(String companyId, String bizPeriodId) throws BOSException, EASBizException {
        int CLF = 10;
        String t_DynMatAllocResult = null;
        try {
            t_DynMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.ctx, (String)companyId, (String)"T_NCM_DynMatAllocResult");
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SQLDataException(e);
        }
        if (StringUtils.isEmpty((String)t_DynMatAllocResult)) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"105_CostObjectRankControllerBean", (Locale)this.ctx.getLocale())});
        }
        com.kingdee.eas.basedata.ncm.PeriodInfo periodInfo = null;
        try {
            periodInfo = com.kingdee.eas.basedata.ncm.PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectStringPK(bizPeriodId));
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        if (periodInfo == null) {
            return "";
        }
        Date beginDate = new Date(periodInfo.getBeginDate().getTime());
        Date endDate = new Date(periodInfo.getEndDate().getTime());
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer query = new StringBuffer();
        query.append("SELECT distinct PARENT.FCostObjectID ,").append('\n').append("       case when ( \n").append("                   matReqEntry.FIsReWork is null -- \u65e0\u6e90\u5355\u636e \n").append("                   or matReqEntry.FIsReWork = 0 -- \u6709\u6e90\u5355\u636e,\u4f46\u662f\u975e\u8fd4\u5de5 \n").append("                   or PARENT.FCostObjectID <> CO.FID -- \u8fd4\u5de5,\u4f46\u6210\u672c\u5bf9\u8c61\u4e0d\u662f\u9886\u7528\u81ea\u5df1 \n").append("                  ) then CO.FID \n").append("            else null  -- \u8fd4\u5de5,\u81ea\u5df1\u9886\u7528\u81ea\u5df1 \n").append("        end as CO2,  \n").append("        MATREQ.FNumber ").append('\n').append(" FROM ").append(t_DynMatAllocResult).append(" AS PARENT").append('\n').append(" INNER JOIN T_BD_CostObject COREF ON PARENT.FCostObjectID = COREF.fid ").append('\n').append(" Left outer JOIN T_BD_COstObjectEntry coe on  coe.FRelatedID =  PARENT.FMaterialID ").append('\n').append(" Left outer JOIN T_BD_CostObject CO ON coe.fparentId = co.fid and co.FCompanyID = PARENT.FCompanyID  ").append('\n').append(" LEFT JOIN T_IM_MaterialReqBill AS MATREQ ON PARENT.FSourceBillID = MATREQ.FID").append('\n').append(" left outer join T_IM_MaterialReqBillEntry matReqEntry \n").append("         on matReqEntry.FParentID = MATREQ.FID  \n").append("            and PARENT.FSourceBillEntryId = matReqEntry.FID \n").append("           and matReqEntry.FMaterialId = PARENT.FMaterialID \n").append(" WHERE   PARENT .FCompanyID = '" + companyId + "' ").append(" and COREF.FRelatedType=0 and COREF.FIsForbiden = 0 ").append("                                  AND (coe.fid is null or coe.FIsByProduct <> 1)").append("                                   and (co.fid is null or (co.FRelatedType=0 and co.FIsForbiden = 0)) ").append("  and matreq.fbasestatus=4 ").append("              and matreq.FBizDate >= TO_DATE('" + dateFormate.format(beginDate) + "') ").append("              and matreq.FBizDate <= TO_DATE('" + dateFormate.format(endDate) + "') ").append(" AND  (PARENT.FCostObjectID is not null or CO.FID is not null) ");
        query.append(" and PARENT.fcalculateperiodid = '" + bizPeriodId + "' ");
        query.append('\n').append("UNION ").append('\n');
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select null as co2, CO.FID as FCostObjectID ,null as FNumber ").append('\n');
        kSql.append("\tfrom T_IM_ManufactureRecBill as recBill ").append('\n');
        kSql.append("\t\t inner join T_SCM_TransactionType as transType  ").append('\n');
        kSql.append(" \t   \t\ton recBill.FTransactionTypeID = transType.FID ").append('\n');
        kSql.append("      \t\t\tand transType.FIsManuCostCalculate = 1").append('\n');
        kSql.append("\t\t left outer join T_IM_ManufactureRecBillEntry as recBillEntry ").append('\n');
        kSql.append(" \t\t\ton recBill.FID =  recBillEntry.FParentID").append('\n');
        kSql.append("\t \tinner join T_IM_InvUpdateType ut on recBillEntry.FINVUPDATETYPEID = ut.fid ").append('\n');
        kSql.append("\t \tinner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n');
        kSql.append("\t\t left outer join T_BD_CostObjectEntry as COEntry ").append('\n');
        kSql.append("\t\t\ton COEntry.FRelatedID = recBillEntry.FMaterialID ").append('\n');
        kSql.append("\t\t left outer join T_BD_CostObject as CO ").append('\n');
        kSql.append("\t\t\ton CO.FID = COEntry.FParentID ").append('\n');
        kSql.append("\t\t\t  and CO.FCompanyID = recBillEntry.FCompanyOrgUnitID ").append('\n');
        kSql.append("  \t\t inner join t_org_costcenter cc on cc.fid = recBillEntry.FCostCenterOrgUnitID").append('\n');
        kSql.append("  \t\t\t\t\t       and cc.FCostCenterType = 0 ").append('\n');
        kSql.append("  where CO.FRelatedType = 0 and CO.FIsForbiden=0 ").append('\n');
        kSql.append("\t\t\t   and ").append('\n');
        kSql.append("\t\t\t   ( ").append('\n');
        kSql.append("\t\t\t       (CO.FCalculateMode = 4 and Isnull(recBillEntry.FLot,' ') = Isnull(CO.FBatchNumber,' ')) ").append('\n');
        kSql.append("\t\t\t\t   or ").append('\n');
        kSql.append("\t\t\t\t   (CO.FCalculateMode = 7 and CO.FOrderID = recBillEntry.FManuBillID) ").append('\n');
        kSql.append("\t\t\t\t   or ").append('\n');
        kSql.append("\t\t\t\t   (CO.FCalculateMode in (1, 3)) ").append('\n');
        kSql.append("\t\t\t   )").append('\n');
        kSql.append("    and recBill.FBASESTATUS = 4  ").append('\n');
        kSql.append("    and recBillEntry.FCompanyOrgUnitID = '" + companyId + "'  ").append('\n');
        kSql.append("    and recBill.FBizDate >= TO_DATE('" + dateFormate.format(beginDate) + "') ");
        kSql.append("    and recBill.FBizDate <= TO_DATE('" + dateFormate.format(endDate) + "') ");
        kSql.append("  group by recBillEntry.FCompanyOrgUnitID,CO.FID ").append('\n');
        return query.append(kSql.toString()).toString();
    }

    private String getCostRecoSQL(String companyId, String periodId) {
        int CLF = 10;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT BB.FCostObjectID ,null AS co2, BB.FNumber as FNumber").append('\n').append("FROM T_NCM_BoPInvSFPCost ").append(" BB ").append('\n').append("INNER JOIN T_NCM_BoPInvSFPCostEntry ").append(" BE ON BE.FParentID=BB.FID").append('\n').append("LEFT  JOIN T_NCM_BoPInvSFPCostMatDetail ").append(" DT ON DT.FParentID=BE.FID ").append('\n').append("WHERE BB.FBillStatus = 4 and BB.FCompanyOrg = '" + companyId + "' AND BB.FCalculatePeriod = '" + periodId).append("' \n").append("GROUP BY BB.FCompanyOrg,BB.FCalculatePeriod,BB.FCostObjectID,BB.FNumber ").append("HAVING SUM(BB.FQty) <>0 ").append("UNION ").append("SELECT BB.FCostObjectID ,CO.FID AS co2,BB.FNumber as FNumber").append('\n').append("FROM T_NCM_BoPInvSFPCost ").append(" BB ").append('\n').append("INNER JOIN T_NCM_BoPInvSFPCostEntry ").append(" BE ON BE.FParentID=BB.FID").append('\n').append("LEFT  JOIN T_NCM_BoPInvSFPCostMatDetail ").append(" DT ON DT.FParentID=BE.FID ").append('\n').append("LEFT JOIN T_BD_CostObject CO ON CO.FCompanyID = BB.FCompanyOrg  AND Isnull(CO.FBatchNumber,' ')=Isnull(DT.FBatchNo,' ') ").append('\n').append("INNER JOIN T_BD_COstObjectEntry coe on coe.fparentId = co.fid and  coe.FRelatedID = DT.FMaterialID").append('\n').append("WHERE co.FIsForbiden = 0 AND coe.FIsByProduct <> 1 and BB.FBillStatus = 4 and BB.FCompanyOrg = '" + companyId + "' AND BB.FCalculatePeriod = '" + periodId).append("' \n").append("GROUP BY BB.FCompanyOrg,BB.FCalculatePeriod,BB.FCostObjectID,CO.FID,BB.FNumber ").append("HAVING SUM(BB.FQty) <>0 ");
        return sb.toString();
    }

    private IRowSet executeInsert(String sql) throws BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("Insert Into ").append(this.T_TMP_CORef).append(" SELECT * FROM ( ").append(sql).append(" ) AS U ");
        Statement statement = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            statement = conn.createStatement();
            statement.executeUpdate(updateSql.toString());
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
        String query = "SELECT * FROM " + this.T_TMP_CORef;
        IRowSet rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)query);
        if (rs.size() == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"112_CostObjectRankControllerBean", (Locale)this.ctx.getLocale())});
        }
        return rs;
    }

    private IObjectCollection buildBillResults(Map computedResults) throws EASBizException, BOSException {
        if (computedResults.isEmpty()) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"113_CostObjectRankControllerBean", (Locale)this.ctx.getLocale())});
        }
        CostObjectRankEntryCollection entries = new CostObjectRankEntryCollection();
        CostObjectInfo co = null;
        String coid = null;
        int rank = -1;
        Iterator ite = computedResults.entrySet().iterator();
        CostObjectRankEntryInfo entry = null;
        while (ite.hasNext()) {
            Map.Entry me = ite.next();
            coid = (String)me.getKey();
            if (me.getValue() == null) continue;
            co = new CostObjectInfo();
            co.setId(BOSUuid.read((String)coid));
            entry = new CostObjectRankEntryInfo();
            entry.setCostObject(co);
            rank = (Integer)me.getValue();
            entry.setRank(rank);
            entries.add(entry);
        }
        return entries;
    }

    private Map buildResults(List cycledCO1, Map objReferobjMap) throws BOSException {
        if (cycledCO1.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap co_billNumbers = new HashMap(cycledCO1.size());
        for (int i = 0; i < cycledCO1.size(); ++i) {
            StringBuffer coNumber = new StringBuffer();
            HashSet<String> billNumber = new HashSet<String>();
            String cycledCoID = (String)cycledCO1.get(i);
            List cycledCoReferCo = (List)objReferobjMap.get(cycledCoID);
            try {
                if (cycledCoReferCo == null) {
                    StringBuffer getNumberSQL = new StringBuffer();
                    getNumberSQL.append("SELECT co.FNumber,entry.FBillNumber FROM T_BD_CostObject co ").append(" LEFT JOIN " + this.T_TMP_CORef + " AS entry ON co.fid = entry.FCO1").append(" WHERE co.FID ='").append(cycledCoID).append("' and FCO2 = '").append(cycledCoID).append("'");
                    IRowSet rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)getNumberSQL.toString());
                    while (rs.next()) {
                        if (rs.getString(1) != null && coNumber.indexOf(rs.getString(1)) == -1) {
                            coNumber.append(",");
                            coNumber.append(rs.getString(1));
                        }
                        if (rs.getString(2) == null || billNumber.contains(rs.getString(2))) continue;
                        billNumber.add(rs.getString(2));
                    }
                    co_billNumbers.put(coNumber.substring(1), billNumber);
                    continue;
                }
                for (int j = 0; j < cycledCoReferCo.size() - 1; ++j) {
                    StringBuffer querySQL = new StringBuffer();
                    querySQL.append("SELECT co.FNumber,entry.FBillNumber FROM T_BD_CostObject co ").append(" LEFT JOIN " + this.T_TMP_CORef + " AS entry ON co.fid = entry.FCO1").append(" WHERE co.FID ='").append(cycledCoReferCo.get(j + 1)).append("' and FCO2 = '").append(cycledCoReferCo.get(j)).append("'");
                    IRowSet rs = NCMDbUtil.executeQuery((Context)this.ctx, (String)querySQL.toString());
                    while (rs.next()) {
                        if (rs.getString(1) != null && coNumber.indexOf(rs.getString(1)) == -1) {
                            coNumber.append(",");
                            coNumber.append(rs.getString(1));
                        }
                        if (rs.getString(2) == null || billNumber.contains(rs.getString(2))) continue;
                        billNumber.add(rs.getString(2));
                    }
                }
                co_billNumbers.put(coNumber.substring(1), billNumber);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return co_billNumbers;
    }

    private Object[] calculateLLC(Context ctx, Map param) throws BOSException, EASBizException {
        String query = null;
        IRowSet rs = null;
        Object[] obj = null;
        if (0 == this.llcType.getValue()) {
            this.buildNormalCORefData(ctx, param);
            query = "select FCO1, FCO2 from " + this.T_TMP_CORef;
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)query);
            obj = LowLevelCode.calculateAll((boolean)this.isCostObjectRankByLow(ctx, this.companyId), (IRowSet)rs);
        } else if (1 == this.llcType.getValue()) {
            query = this.getCostRecoSQL(this.companyId, this.periodId);
            rs = this.executeInsert(query);
            obj = LowLevelCode.calculateAll((boolean)this.isCostObjectRankByLow(ctx, this.companyId), (IRowSet)rs);
        } else if (2 == this.llcType.getValue()) {
            query = this.getDynamicCostSQL(this.companyId, this.periodId);
            rs = this.executeInsert(query);
            obj = LowLevelCode.calculateAll((boolean)this.isCostObjectRankByLow(ctx, this.companyId), (IRowSet)rs);
        } else {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"117_CostObjectRankControllerBean", (Locale)ctx.getLocale()));
        }
        return obj;
    }

    private boolean isCostObjectRankByLow(Context ctx, String companyId) throws BOSException {
        IParamControl ipctr = null;
        ipctr = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        try {
            ObjectUuidPK com = new ObjectUuidPK(companyId);
            String st = ipctr.getParamValue((IObjectPK)com, "CM007");
            return st.compareTo("1") == 0;
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean isDirectChecker() {
        return this.param != null && this.param.containsKey("isDirectRankChecker") && "true".equals(this.param.get("isDirectRankChecker"));
    }
}

