/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.cal.app.AbstractMatAllocResultVoucheredControllerBean;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMGenVoucherHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class MatAllocResultVoucheredControllerBean
extends AbstractMatAllocResultVoucheredControllerBean {
    private static Logger logger = Logger.getLogger((String)MatAllocResultVoucheredControllerBean.class.getName());

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_CAL_MatAllocResultVoucher";
    }

    protected void generbyArrayList(Context ctx, List tempTblIdList, Set srcBillIdSet, String botMappingId, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        if (tempTblIdList.isEmpty()) {
            return;
        }
        IObjectPK[] srcBillPks = new IObjectPK[tempTblIdList.size()];
        for (int i = 0; i < tempTblIdList.size(); ++i) {
            srcBillPks[i] = new ObjectUuidPK(tempTblIdList.get(i).toString());
        }
        DAPTransformResult dapResult = NCMGenVoucherHelper.generateVoucher((Context)ctx, (IObjectPK[])srcBillPks, (IObjectPK)botMappingPK, (SelectorItemCollection)botpSelectors);
        if (dapResult == null || dapResult.getVoucherCollection() == null || dapResult.getVoucherCollection().isEmpty()) {
            return;
        }
        VoucherCollection voucherColl = (VoucherCollection)dapResult.getVoucherCollection();
        String voucherId = voucherColl.get(0).getId().toString();
        HashMap<String, String> botpRelationMap = new HashMap<String, String>();
        Iterator iterator = srcBillIdSet.iterator();
        while (iterator.hasNext()) {
            botpRelationMap.put(iterator.next().toString(), voucherId);
        }
        NCMUtils.saveBOTRelation((Context)ctx, botpRelationMap, (String)botMappingId);
        StringBuffer sql = new StringBuffer();
        sql.append("update T_IM_MaterialReqBill set FFivouchered=1 , fvoucherid='").append(voucherId).append("' where 1=1 and FID = ? ");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            Iterator it = srcBillIdSet.iterator();
            while (it.hasNext()) {
                pstmt.setString(1, it.next().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        tempTblIdList.clear();
        srcBillIdSet.clear();
    }

    public static String getMappingIdByCU(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys) throws BOSException, EASBizException {
        String boMappId = null;
        try {
            IRowSet mapRs = NCMUtils.getMappingByCU((Context)ctx, (String)sourceBillType, (String)targetBillType, (DefineSysEnum)defineSys);
            if (mapRs == null || mapRs.size() < 1) {
                throw new CMBillException(CMBillException.NO_MATERIALREQ_VOUCHER);
            }
            while (mapRs.next()) {
                boMappId = mapRs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return boMappId;
    }

    @Override
    protected void _addVoucherByAll(Context ctx, List idList, String companyId, String periodId, BOTMappingInfo botpInfo) throws BOSException, EASBizException {
        String matAllocResultTblName;
        if (idList == null || idList.isEmpty()) {
            return;
        }
        try {
            matAllocResultTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.genTempVoucherData(ctx, matAllocResultTblName, companyId, periodId, idList, true);
        String boMappId = MatAllocResultVoucheredControllerBean.getMappingIdByCU(ctx, "500AB75E", "2652E01E", DefineSysEnum.DAP);
        SelectorItemCollection botSelectors = null;
        ObjectUuidPK botpID = new ObjectUuidPK(botpInfo.getId());
        try {
            botSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botpInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        List tempTableIdList = this.getTempTblIdList(ctx, companyId, periodId);
        Set srcBillIdSet = this.getSrcBillIdSet(ctx, matAllocResultTblName, companyId, periodId, idList);
        if (srcBillIdSet.size() == 0) {
            throw new NcmBillException(NcmBillException.CHECK_FIVOUCHERED);
        }
        this.generbyArrayList(ctx, tempTableIdList, srcBillIdSet, boMappId, (IObjectPK)botpID, botSelectors);
        this.delTempVoucherData(ctx, idList);
    }

    private List getTempTblIdList(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid from T_CAL_MatAllocResultVoucher ").append(" where FCompanyorg= ? AND FCalculatePeriod = ? ");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodId});
        ArrayList<String> tempTblIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                String Id = rs.getString(1);
                tempTblIdList.add(Id);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"122_MatAllocResultVoucheredControllerBean", (Locale)ctx.getLocale()) + tempTblIdList.size()));
        return tempTblIdList;
    }

    private Set getSrcBillIdSet(Context ctx, String matAllocResultTblName, String companyId, String periodId, List idList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.FSourceBillID from ").append(matAllocResultTblName).append(" as a , T_IM_MaterialReqBill as b").append(" where  a.FSourceBillID = b.fid and b.ffivouchered = 0 and b.FBaseStatus = 4  ").append(" and ").append(StringUtil.buildIn((String)" b.FID ", (Object[])idList.toArray()));
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> srcBillSet = new HashSet<String>();
        try {
            while (rs.next()) {
                srcBillSet.add(rs.getString("FSourceBillID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"123_MatAllocResultVoucheredControllerBean", (Locale)ctx.getLocale()) + srcBillSet.size()));
        return srcBillSet;
    }

    @Override
    protected void _addVoucherByBill(Context ctx, List idList, String companyId, String periodId, BOTMappingInfo botpInfo) throws BOSException, EASBizException {
        String matAllocResultTblName;
        if (idList == null || idList.isEmpty()) {
            return;
        }
        try {
            matAllocResultTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.genTempVoucherData(ctx, matAllocResultTblName, companyId, periodId, idList, false);
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid,FSourceBillID from T_CAL_MatAllocResultVoucher where").append(" FCompanyorg='").append(companyId).append("' AND FCalculatePeriod='").append(periodId).append("' and ").append(StringUtil.buildIn((String)" FSourceBillID ", (Object[])idList.toArray())).append("order by FSourceBillID");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String boMappId = MatAllocResultVoucheredControllerBean.getMappingIdByCU(ctx, "500AB75E", "2652E01E", DefineSysEnum.DAP);
        SelectorItemCollection botSelectors = null;
        ObjectUuidPK botpID = new ObjectUuidPK(botpInfo.getId());
        try {
            botSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botpInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashSet<String> srcBillIdSet = new HashSet<String>();
        ArrayList<String> tempTableIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                String Id = rs.getString(1);
                String sourceBillID = rs.getString(2);
                if (srcBillIdSet.contains(sourceBillID)) {
                    tempTableIdList.add(Id);
                    continue;
                }
                this.generbyArrayList(ctx, tempTableIdList, srcBillIdSet, boMappId, (IObjectPK)botpID, botSelectors);
                srcBillIdSet.add(sourceBillID);
                tempTableIdList.add(Id);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (srcBillIdSet.size() == 0) {
            throw new NcmBillException(NcmBillException.CHECK_FIVOUCHERED);
        }
        this.generbyArrayList(ctx, tempTableIdList, srcBillIdSet, boMappId, (IObjectPK)botpID, botSelectors);
        this.delTempVoucherData(ctx, idList);
    }

    private void genTempVoucherData(Context ctx, String matAllocResultTblName, String companyId, String periodId, List idList, boolean isByAll) throws BOSException, EASBizException {
        NCMDbUtil.execute((Context)ctx, (String)"DELETE FROM T_CAL_MatAllocResultVoucher");
        String sql = "";
        sql = isByAll ? this.buildTempVoucherDataByAll(ctx, companyId, periodId, idList, matAllocResultTblName) : this.buildTempVoucherDataByBill(ctx, companyId, periodId, idList, matAllocResultTblName);
        NCMDbUtil.execute((Context)ctx, (String)sql);
    }

    private String buildTempVoucherDataByBill(Context ctx, String companyId, String periodId, List idList, String matAllocResultTblName) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_CAL_MatAllocResultVoucher(").append("FID,FCostCenterID,FSourceBillID,FCostObjectID,FCostItemID,FAmount,FCreatorID,").append("FWarehouseID,FAdminOrgUnitID,").append("FCreateTime,FIsDirect,FNumber,").append("FbizDate,FExpenseID,FCompanyOrg,FCalculatePeriod,FMaterialID,FQty,FPrice) ").append("select a.FID ,a.FCostCenterID,a.FSourceBillID ,a.FCostObjectID ,a.FCostItemID,").append("\ta.FAmount,a.FCreatorID ,c.FWarehouseID, b.FAdminOrgUnitID,a.FCreateTime ,a.FIsDirect,b.FNumber,b.fbizdate,'").append("ml7t5QEaEADgAAwawKgRe0olWCc=").append("','").append(companyId).append("','").append(periodId).append("',a.FMaterialID,a.FQty,a.FPrice  from ").append(matAllocResultTblName).append(" as a , T_IM_MaterialReqBill as b,").append(" T_IM_MaterialReqBillEntry as c").append(" where  a.FSourceBillID=b.fid and a.FSourceBillEntryID = c.fid and b.ffivouchered=0 and b.FBaseStatus=4  ").append(" and ").append(StringUtil.buildIn((String)" b.FID ", (Object[])idList.toArray()));
        return sql.toString();
    }

    private String buildTempVoucherDataByAll(Context ctx, String companyId, String periodId, List idList, String matAllocResultTblName) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_CAL_MatAllocResultVoucher(").append("FID,FCostCenterID,FSourceBillID,FCostObjectID,FCostItemID,FAmount,FCreatorID,").append("FWarehouseID,FAdminOrgUnitID,").append("FCreateTime,FIsDirect,FNumber,").append("FbizDate,FExpenseID,FCompanyOrg,FCalculatePeriod,FMaterialID,FQty,FPrice) ").append("select newbosid('ADC37CB3'), a.FCostCenterID, max(a.FSourceBillID) ,a.FCostObjectID ,a.FCostItemID,").append("\tsum(a.FAmount), max(a.FCreatorID) ,c.FWarehouseID, b.FAdminOrgUnitID,max(a.FCreateTime) ,1, max(b.FNumber),max(b.fbizdate),'").append("ml7t5QEaEADgAAwawKgRe0olWCc=").append("','").append(companyId).append("','").append(periodId).append("',a.FMaterialID,sum(a.FQty), case when sum(to_decimal(a.fqty,24,12)) = 0 then 0 else sum(to_decimal(a.famount,24,12))/sum(to_decimal(a.fqty,24,12)) end FPrice  from ").append(matAllocResultTblName).append(" as a , T_IM_MaterialReqBill as b,").append(" T_IM_MaterialReqBillEntry as c").append(" where  a.FSourceBillID=b.fid and a.FSourceBillEntryID = c.fid and b.ffivouchered=0 and b.FBaseStatus=4  ").append(" and ").append(StringUtil.buildIn((String)" b.FID ", (Object[])idList.toArray())).append(" GROUP BY a.FCostCenterID, a.FCostObjectID, a.FCostItemID, a.FMaterialID,c.FWarehouseID, b.FAdminOrgUnitID");
        return sql.toString();
    }

    public void delTempVoucherData(Context ctx, List idList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete T_CAL_MatAllocResultVoucher where").append(" 1=1 and ").append(StringUtil.buildIn((String)" FSourceBillID ", (Object[])idList.toArray()));
        NCMDbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnum, IObjectValue relationInfo) throws BOSException, EASBizException {
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    public void checkStart(Context ctx, IObjectValue model) throws EASBizException, BOSException {
    }

    protected boolean _checkNumberDup(Context arg0, IObjectPK arg1, IObjectValue arg2) throws EASBizException, BOSException {
        return false;
    }

    protected boolean _checkNumberBlank(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        return false;
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] pks, IObjectCollection srcBillColl, BOTBillOperStateEnum billOperStateEnum, IObjectCollection botRelationColl) throws BOSException {
        if (billOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_IM_MaterialReqBill set FFivouchered=0 , fvoucherid=''").append(" where not EXISTS (select 1 from T_GL_Voucher vo where vo.fid = T_IM_MaterialReqBill.fvoucherid)");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }
}

