/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Recovery.Calc.BatchRecoveryIterator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.BatchRecoveryIterator.IBatchRecoveryIterator;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.CalcParam;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.IRecoveryCalc;
import com.kingdee.eas.ncm.common.log.app.NCMLogger;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BatchRecoveryByHardcodeIterator
implements IBatchRecoveryIterator {
    private static Logger logger = Logger.getLogger((String)BatchRecoveryByHardcodeIterator.class.getName());
    private CalcParam _calcParam;
    private IRecoveryCalc _calculator;
    private boolean isFirstBatch = false;
    protected IRowSet _data = null;
    public int _dataCount = -1;
    public int iBatchCount = 0;
    private int iBatchIndex = 0;
    private boolean isDone = false;
    private ArrayList theBatch;

    public BatchRecoveryByHardcodeIterator(CalcParam calcParam, IRecoveryCalc calculator) throws EASBizException, BOSException {
        this._calcParam = calcParam;
        this._calculator = calculator;
        this._data = this.GetCostObjListByLevel(this._calcParam.rank);
    }

    @Override
    public void FirstBatch() throws EASBizException, BOSException {
        try {
            this._data.last();
            this._dataCount = this._data.getRow();
            this._data.first();
            this.iBatchCount = 0;
            this.iBatchIndex = 0;
            this.isDone = false;
            this.theBatch = new ArrayList();
            this.isFirstBatch = true;
            this.isDone = this.GetInnerGetBatch(this._calcParam.dispRank);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public boolean IsDone() throws EASBizException, BOSException {
        return this.isDone && !this.isFirstBatch;
    }

    @Override
    public void NextBatch() throws EASBizException, BOSException {
        this.isFirstBatch = false;
        this.isDone = this.GetInnerGetBatch(this._calcParam.dispRank);
    }

    @Override
    public void RecoveryCurrBatch() throws EASBizException, BOSException {
        if (this.theBatch.size() > 0) {
            this._calculator.DoRecovery(this.theBatch.toArray());
        }
    }

    private IRowSet GetCostObjListByLevel(String rank) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        try {
            String tblCostCalResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._calcParam.ctx, (String)this._calcParam.companyId, (String)"T_NCM_CostCalResult");
            sb.append("Select DISTINCT FCostObjectID ").append('\n').append("FROM ").append(tblCostCalResult).append('\n').append("WHERE FCompanyID='").append(this._calcParam.companyId).append("' AND FCalculatePeriodID='").append(this._calcParam.periodId).append("' AND FCalcLevel=").append(rank).append('\n').append("").append('\n');
            IRowSet rs = NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)sb.toString());
            return rs;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private boolean GetInnerGetBatch(String dispRank) throws BOSException {
        Logger logger = NCMLogger.getLogger();
        logger.info((Object)("++++++++++\u7b2c" + dispRank + "\u5c42\u6210\u672c\u5bf9\u8c61\u4e2a\u6570\u4e3a\uff1a" + this._dataCount + "+++++++++++++++++++++"));
        try {
            int iBatchCountPerGet = Integer.valueOf(dispRank).compareTo(Integer.valueOf("3")) <= 0 ? 500 : 300;
            if (this.iBatchCount <= 0) {
                double cnt = BigDecimal.valueOf(this._dataCount).divide(BigDecimal.valueOf(iBatchCountPerGet), 4, 4).doubleValue();
                this.iBatchCount = cnt - Math.floor(cnt) > 0.0 ? (int)Math.floor(cnt) + 1 : (int)Math.floor(cnt);
            }
            if (this.iBatchCount <= 0) {
                return true;
            }
            int i = 0;
            this.theBatch.clear();
            if (this.isFirstBatch) {
                this.theBatch.add(this._data.getString(1));
                ++i;
            }
            while (this._data.next()) {
                this.theBatch.add(this._data.getString(1));
                if (++i != iBatchCountPerGet) continue;
                ++this.iBatchIndex;
                return false;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return this.theBatch.size() == 0;
    }
}

