/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Recovery.Calc.PreProcess.InitStrategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.CalcParam;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.PreProcess.InitStrategy.IBopInitRecoveryStrategy;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.NumberFormat;
import org.apache.log4j.Logger;

public class BopInitRecoveryByStepStrategy
implements IBopInitRecoveryStrategy {
    private static Logger logger = Logger.getLogger((String)BopInitRecoveryByStepStrategy.class.getName());
    private CalcParam _calcParam;

    public BopInitRecoveryByStepStrategy(CalcParam calcParam) {
        this._calcParam = calcParam;
    }

    @Override
    public void Revert() throws EASBizException, BOSException {
        int lowest;
        int dispRank = 0;
        for (int rank = lowest = CalSeverUtils.getLowestRankByCostRecovery(this._calcParam.ctx, this._calcParam.companyId, this._calcParam.periodId); rank >= 0; --rank) {
            ++dispRank;
            this.RankRevert(rank);
        }
    }

    private void RankRevert(int rank) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        String tblInitSemifinishedProdCoef = this._calcParam.GetTBL_InitSemifinishedProdCoef();
        String tblBranchNode = this._calcParam.GetTBL_RecoveryTreeBranchNode();
        sb.append("SELECT ").append('\n').append("\tB.FCompanyOrg As FCompanyID,B.FCalculatePeriod As FCalculatePeriodID,").append('\n').append("\tB.FCostObjectID,B.FProductID,Isnull(B.FLot,N' ') As FProdBatchNo,E.FCostItemID,M.FMaterialID,Isnull(M.FBatchNo,N' ') As FMatBatchNo,").append('\n').append("\tB.FQty,B.FAmount,E.FQty As FCostItemQty,E.FAmount As FCostItemAmount,M.FQty As FMatQty,M.FAmount As FMatAmount, ").append('\n').append("\tIsnull(F.FHasCoef,0)As FHasCoef, ").append('\n').append("\tISNULL(bnPrd.FNodeID,0)AS FPrdBatchNodeID,ISNULL(bnCI.FNodeID,0)AS FCostItemNodeID ").append('\n').append("FROM T_NCM_BoPInvSFPCost B ").append('\n').append("INNER JOIN T_NCM_BoPInvSFPCostEntry E ON E.FParentID=B.FID ").append('\n').append("LEFT JOIN T_NCM_BoPInvSFPCostMatDetail M ON M.FParentID=E.FID ").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append("INNER JOIN T_BD_MaterialCost mcst ON mcst.FOrgUnit=B.FCompanyOrg AND mcst.FMaterialID = B.FProductID AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("INNER JOIN T_CAL_CostObjectRankEntry RE ON RE.FCostObjectID=B.FCostObjectID ").append('\n').append("INNER JOIN T_CAL_CostObjectRank R ON RE.FParentID= R.FID ").append('\n').append("\tAND R.FCompanyOrg=B.FCompanyOrg AND R.FCalculatePeriod=B.FCalculatePeriod ").append('\n').append("\tAND R.FLlcType=1 AND RE.FRank=").append(rank).append('\n').append("LEFT JOIN T_NCM_CostItem CI ON CI.FID=E.FCostItemID ").append('\n').append("LEFT JOIN T_BD_Material Mat ON Mat.FID=M.FMaterialID ").append('\n').append("LEFT JOIN ").append(tblBranchNode).append(" bnPrd ON bnPrd.FNodeStr=(B.FProductID || CASE WHEN B.FLot<>N' 'THEN '").append("#@").append("'||B.FLot ELSE N' ' END) ").append('\n').append("LEFT JOIN ").append(tblBranchNode).append(" bnCI ON bnCI.FNodeStr=E.FCostItemID ").append('\n').append("LEFT JOIN (").append('\n').append("\tSELECT DISTINCT W.FProductID,W.FProdBatchNo,1 As FHasCoef ").append('\n').append("\tFROM ").append(tblInitSemifinishedProdCoef).append(" W ").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append("\tINNER JOIN T_BD_MaterialCost mcst ON mcst.FOrgUnit=W.FCompanyID AND mcst.FMaterialID = W.FProductId AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("\tWHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append(")F ON F.FProductID=M.FMaterialID AND F.FProdBatchNo=Isnull(M.FBatchNo,N' ') ").append('\n').append(" ").append('\n').append("WHERE B.FBillStatus=4 AND B.FCompanyOrg='").append(this._calcParam.companyId).append("' AND B.FCalculatePeriod='").append(this._calcParam.periodId).append("' ").append('\n').append("ORDER BY B.FProductID,FProdBatchNo,CI.FNumber,Mat.FNumber,M.FBatchNo ").append('\n').append(";").append('\n');
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)sb.toString());
        sb.delete(0, sb.length());
        try {
            int sort = 0;
            String lastCostObjectID = "";
            String lastCostItemID = "";
            String sBranch = "";
            String sSubBranch = "";
            String sIsLeaf = "";
            while (rs.next()) {
                if (lastCostObjectID.compareTo(rs.getString("FCostobjectId")) != 0 || lastCostItemID.compareTo(rs.getString("FCostItemID")) != 0) {
                    ++sort;
                    fm.setMaximumFractionDigits(12);
                    String costItemQtyCoef = fm.format(BigDecimal.valueOf(0L));
                    BigDecimal costItemQty = BigDecimal.valueOf(0L);
                    if (rs.getBigDecimal("FCostItemQty") != null) {
                        costItemQty = rs.getBigDecimal("FCostItemQty");
                    }
                    if (!BigDecimal.valueOf(0L).equals(rs.getBigDecimal("FQty"))) {
                        costItemQtyCoef = fm.format(costItemQty.divide(rs.getBigDecimal("FQty"), 12, 4));
                    }
                    fm.setMaximumFractionDigits(12);
                    String costItemAoumtCoef = fm.format(BigDecimal.valueOf(0L));
                    if (!rs.getBigDecimal("FAmount").equals(BigDecimal.valueOf(0L))) {
                        costItemAoumtCoef = fm.format(rs.getBigDecimal("FCostItemAmount").divide(rs.getBigDecimal("FAmount"), 12, 4));
                    }
                    sBranch = rs.getString("FPrdBatchNodeID");
                    sIsLeaf = rs.getString("FMaterialID") != null && rs.getString("FMaterialID").length() > 0 ? "0" : "1";
                    sb.append("INSERT INTO ").append(tblInitSemifinishedProdCoef).append(" \t(FID,FCompanyID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FQtyCoef,FAmtCoef,").append('\n').append(" \tFLayer,FDispLayer,FIsLeaf,FBranch)").append('\n').append("Values(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductID")).append("','").append(rs.getString("FProdBatchNo")).append("','").append(rs.getString("FCostItemID")).append("',").append(costItemQtyCoef).append(",").append(costItemAoumtCoef).append(",").append("0,1,").append(sIsLeaf).append(",'").append(sBranch).append("'").append(");").append('\n');
                    lastCostObjectID = rs.getString("FCostobjectId");
                    lastCostItemID = rs.getString("FCostItemID");
                }
                if (rs.getString("FMaterialID") == null || rs.getString("FMaterialID").length() <= 0) continue;
                ++sort;
                fm.setMaximumFractionDigits(12);
                String matQtyCoef = fm.format(BigDecimal.valueOf(0L));
                if (!rs.getBigDecimal("FQty").equals(BigDecimal.valueOf(0L))) {
                    matQtyCoef = fm.format(rs.getBigDecimal("FMatQty").divide(rs.getBigDecimal("FQty"), 12, 4));
                }
                fm.setMaximumFractionDigits(12);
                String matAoumtCoef = fm.format(BigDecimal.valueOf(0L));
                if (!rs.getBigDecimal("FAmount").equals(BigDecimal.valueOf(0L))) {
                    matAoumtCoef = fm.format(rs.getBigDecimal("FMatAmount").divide(rs.getBigDecimal("FAmount"), 12, 4));
                }
                sSubBranch = sBranch + "." + rs.getString("FCostItemNodeID");
                sIsLeaf = rs.getInt("FHasCoef") == 1 ? "0" : "1";
                sb.append("INSERT INTO ").append(tblInitSemifinishedProdCoef).append(" \t(FID,FCompanyID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo,FQtyCoef,FAmtCoef,").append('\n').append(" \tFLayer,FDispLayer,FIsLeaf,FBranch)").append('\n').append("Values(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductID")).append("','").append(rs.getString("FProdBatchNo")).append("','").append(rs.getString("FCostItemID")).append("','").append(rs.getString("FMaterialID")).append("','").append(rs.getString("FMatBatchNo")).append("',").append(matQtyCoef).append(",").append(matAoumtCoef).append(",").append("1,1,").append(sIsLeaf).append(",'").append(sSubBranch).append("'").append(");").append('\n');
                if (rs.getInt("FHasCoef") != 1) continue;
                fm.setMaximumFractionDigits(12);
                String amount = fm.format(BigDecimal.valueOf(0L));
                if (rs.getBigDecimal("FMatAmount") != null) {
                    amount = fm.format(rs.getBigDecimal("FMatAmount"));
                }
                String qty = fm.format(BigDecimal.valueOf(0L));
                if (rs.getBigDecimal("FMatQty") != null) {
                    qty = fm.format(rs.getBigDecimal("FMatQty"));
                }
                sb.append("INSERT INTO ").append(tblInitSemifinishedProdCoef).append(" \t(FID,FCompanyID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo,FQtyCoef,FAmtCoef,").append('\n').append(" \tFLayer,FDispLayer,FIsLeaf,FBranch)").append('\n').append("SELECT newbosid('DFA50FD9')As FID,'").append(this._calcParam.companyId).append("'As FCompanyID,'").append(this._calcParam.periodId).append("'As FCalculatePeriodID,").append('\n').append("\t'").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductID")).append("','").append(rs.getString("FProdBatchNo")).append("',").append("\tW.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("\tW.FQtyCoef * ").append(qty).append("/" + rs.getBigDecimal("FQty").toString() + " As FQtyCoef,W.FAmtCoef * ").append(amount).append("/" + rs.getBigDecimal("FAmount").toString() + " As FAmtCoef, ").append('\n').append("\t(W.FLayer + 2) As FLayer,(W.FDispLayer + 1) As FDispLayer,FIsLeaf,'").append(sSubBranch).append("'||'.'||W.FBranch ").append('\n').append("FROM ").append(tblInitSemifinishedProdCoef).append(" W ").append('\n').append("WHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\tAND W.FProductID = '").append(rs.getString("FMaterialID")).append("' AND W.FProdBatchNo='").append(rs.getString("FMatBatchNo")).append("'").append('\n').append(";").append('\n');
            }
            NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }
}

