/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Recovery.Calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.CalcParam;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.IRecoveryCalc;
import com.kingdee.eas.ncm.cal.app.Recovery.RecoveryDataCache;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.RecoveryModelEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class RecoveryCalcBase
implements IRecoveryCalc {
    private static Logger logger = Logger.getLogger((String)RecoveryCalcBase.class.getName());
    protected CalcParam _calcParam;
    protected Object[] _costObjList;
    protected RecoveryDataCache dataCache;

    public RecoveryCalcBase(CalcParam calcParam) {
        this._calcParam = calcParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void DoRecovery(Object[] costObjList) throws EASBizException, BOSException {
        long t2;
        long t1;
        Assert.that((costObjList.length > 0 ? 1 : 0) != 0);
        this._costObjList = costObjList;
        Calendar c = Calendar.getInstance();
        try {
            Log.info((Object)("@#-:\u8ba1\u7b97\u6b65\u9aa4 " + this._calcParam.dispRank));
            t1 = System.currentTimeMillis();
            this.PreProcess();
            t2 = System.currentTimeMillis();
            c.setTimeInMillis(t2 - t1);
            Log.info((Object)("@#--PreProcess \u8017\u65f6: " + c.get(12) + "\u5206 " + c.get(13) + "\u79d2 "));
            t1 = System.currentTimeMillis();
            this.ProdRecovery();
            t2 = System.currentTimeMillis();
            c.setTimeInMillis(t2 - t1);
            Log.info((Object)("@#--ProdRecovery \u8017\u65f6: " + c.get(12) + "\u5206 " + c.get(13) + "\u79d2 "));
            t1 = System.currentTimeMillis();
            this.InventoryRecovery();
            t2 = System.currentTimeMillis();
            c.setTimeInMillis(t2 - t1);
            Log.info((Object)("@#--InventoryRecovery \u8017\u65f6: " + c.get(12) + "\u5206 " + c.get(13) + "\u79d2 "));
            if (this._calcParam.isGenReportData) {
                t1 = System.currentTimeMillis();
                this.GenerateRecoveryReport();
                t2 = System.currentTimeMillis();
                c.setTimeInMillis(t2 - t1);
                Log.info((Object)("@#--GenerateRecoveryReport \u8017\u65f6: " + c.get(12) + "\u5206 " + c.get(13) + "\u79d2 "));
                this._calcParam.clearTempTblCostRecoveryReport();
            }
            if (this._calcParam.isGenVoucherData) {
                t1 = System.currentTimeMillis();
                if (this._calcParam.recoveryModel.equals((Object)RecoveryModelEnum.ByEnd)) {
                    this.GenerateRecoveryVourchData();
                }
                t2 = System.currentTimeMillis();
                c.setTimeInMillis(t2 - t1);
                Log.info((Object)("@#--GenerateRecoveryVourchData \u8017\u65f6: " + c.get(12) + "\u5206 " + c.get(13) + "\u79d2 "));
                this._calcParam.clearTempTblCostRecoveryReport();
            }
        }
        finally {
            t1 = System.currentTimeMillis();
            this._calcParam.ReleaseResourceAllTable();
            this._calcParam.getAllTempTables();
            if (!"0".equals(this._calcParam.rank)) {
                this.EndProcess();
            }
            t2 = System.currentTimeMillis();
            c.setTimeInMillis(t2 - t1);
            Log.info((Object)("@#--EndProcess \u8017\u65f6: " + c.get(12) + "\u5206 " + c.get(13) + "\u79d2 "));
            this.dataCache.release();
        }
    }

    @Override
    public void PreProcess() throws EASBizException, BOSException {
        block10: {
            PreparedStatement pstmt;
            block9: {
                Connection conn = null;
                pstmt = null;
                boolean isNewConn = false;
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append("truncate Table ").append(this._calcParam.GetTempTBL_CostObjList()).append('\n');
                    NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
                    sb.delete(0, sb.length());
                    sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostObjList()).append("(FCostObjectID)Values(?)");
                    if (this._calcParam.get_conn() == null) {
                        conn = EJBFactory.getConnection((Context)this._calcParam.ctx);
                        isNewConn = true;
                    } else {
                        conn = this._calcParam.get_conn();
                    }
                    pstmt = conn.prepareStatement(sb.toString());
                    for (int i = 0; i < this._costObjList.length; ++i) {
                        pstmt.setString(1, (String)this._costObjList[i]);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_CostObjList());
                    sb.delete(0, sb.length());
                    HashMap<String, CalcParam> param = new HashMap<String, CalcParam>();
                    param.put("calcParam", this._calcParam);
                    this.dataCache = new RecoveryDataCache(param);
                    this.dataCache.initData();
                    if (!isNewConn) break block9;
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)"", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (isNewConn) {
                            SQLUtils.cleanup(pstmt, conn);
                        } else {
                            SQLUtils.cleanup(pstmt);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                break block10;
            }
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    @Override
    public void ProdRecovery() throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        this.InsertBoPWipPart(sb);
        this.InsertInputPart(sb);
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopWIPCoef());
        this.MergeProdCoef(sb);
        this.CalcProdCoef(sb);
        this.CommitProdCoef(sb);
    }

    @Override
    public void InventoryRecovery() throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        this.InsertBoPInvPart(sb);
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        if (this._calcParam.CurrentDataBaseType == 2 || this._calcParam.CurrentDataBaseType == 7 || this._calcParam.CurrentDataBaseType == 8) {
            this.InsertStockInPart_Oracle(sb);
        } else {
            this.InsertStockInPart(sb);
        }
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopInvCoef());
        this.MergeInventoryCoef(sb);
        this.CalcInventoryCoef(sb);
        this.CommitInventoryCoef(sb);
    }

    @Override
    public void EndProcess() throws EASBizException, BOSException {
        this.WriteRecoveryCalcLog();
    }

    protected abstract void InsertBoPWipPart(StringBuffer var1) throws EASBizException, BOSException;

    protected abstract void InsertInputPart(StringBuffer var1) throws EASBizException, BOSException;

    protected abstract void MergeProdCoef(StringBuffer var1) throws EASBizException, BOSException;

    protected abstract void CalcProdCoef(StringBuffer var1) throws EASBizException, BOSException;

    protected abstract void CommitProdCoef(StringBuffer var1) throws EASBizException, BOSException;

    protected abstract void InsertBoPInvPart(StringBuffer var1) throws EASBizException, BOSException;

    protected abstract void InsertStockInPart(StringBuffer var1) throws EASBizException, BOSException;

    protected abstract void InsertStockInPart_Oracle(StringBuffer var1) throws EASBizException, BOSException;

    protected abstract void MergeInventoryCoef(StringBuffer var1) throws EASBizException, BOSException;

    protected abstract void CalcInventoryCoef(StringBuffer var1) throws EASBizException, BOSException;

    protected abstract void CommitInventoryCoef(StringBuffer var1) throws EASBizException, BOSException;

    protected abstract IRowSet GetStockInData(boolean var1) throws EASBizException, BOSException;

    protected abstract StringBuffer GetStockInDataSelectSql(boolean var1) throws EASBizException, BOSException;

    protected void WriteRecoveryCalcLog() throws EASBizException, BOSException {
        this.Check_NoCoef();
    }

    protected boolean Check_NoCoef() throws BOSException, EASBizException {
        boolean ret = false;
        StringBuffer sb = new StringBuffer();
        String level = MessageFormat.format(CalculateUtil.getSrvCalResource(this._calcParam.ctx, "Recovery_Calc_CheckCoef_Level"), this._calcParam.dispRank);
        String reportItem_1 = CalculateUtil.getSrvCalResource(this._calcParam.ctx, "Recovery_Calc_CheckCoef_BothNo");
        String reportItem_2 = CalculateUtil.getSrvCalResource(this._calcParam.ctx, "Recovery_Calc_CheckCoef_NoBoP");
        try {
            String tblBopInvCoef = this._calcParam.GetTBL_BopInvCoef();
            sb.append("Select distinct Mat.FNumber As FProductNumber, Mat.FName as FProductName,O.FCostObjBatchNo as FProdBatchNo, ").append('\n').append("\tCASE WHEN WIP.FID IS NULL THEN 1 ELSE 0 END As FCanntRevert ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_CostObjList()).append(" M ").append('\n').append("LEFT JOIN ").append(this._calcParam.GetTempTblCostObjectBase()).append(" O ON O.FCostObjectID=M.FCostObjectID ").append('\n');
            if (!this._calcParam.isRevertAllProduct) {
                sb.append("INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON  mcst.FMaterialID = O.FProductID AND mcst.FIsParticipateReduct=1").append('\n');
            }
            sb.append("INNER JOIN (").append('\n').append("\tSELECT bal.FMaterialID as FProductID, ISNULL(bal.FLot,' ')As FProdBatchNo ").append('\n').append("\tFROM T_IM_InventoryBalance bal ").append('\n').append("\tINNER JOIN ").append(this._calcParam.GetTempTblMaterialComp()).append(" mat ON  mat.FMaterialID = bal.FMaterialID AND mat.FCalculateType=2 ").append('\n').append("\tWHERE bal.FYear=").append(this._calcParam.periodYear).append(" AND bal.FPeriod=").append(this._calcParam.periodNumber).append('\n').append("\t\tAND bal.FCompanyOrgUnitID='").append(this._calcParam.companyId).append("' ").append('\n').append("\tGROUP BY bal.FMaterialID, bal.FLot ").append('\n').append("\tHAVING SUM(bal.FPeriodBeginQty) <>0 ").append('\n').append(")B ON O.FProductId=B.FProductId AND isnull(O.FCostObjBatchNo,' ')=isnull(B.FProdBatchNo,' ') ").append('\n').append("LEFT JOIN ").append(tblBopInvCoef).append(" Inv ON Inv.FProductID=O.FProductID AND isnull(Inv.FProdBatchNo,' ')=isnull(O.FCostObjBatchNo,' ') ").append('\n').append("\tAND Inv.FCompanyID='").append(this._calcParam.companyId).append("' AND Inv.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("LEFT JOIN ").append(tblBopInvCoef).append(" WIP ON WIP.FProductID=O.FProductID AND isnull(WIP.FProdBatchNo,' ')=isnull(O.FCostObjBatchNo,' ') ").append('\n').append("\tAND WIP.FCompanyID='").append(this._calcParam.companyId).append("' AND WIP.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("LEFT OUTER JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Mat ON Mat.FMaterialID=O.FProductID ").append('\n').append("WHERE Inv.FID IS NULL ").append('\n').append("ORDER BY FCanntRevert,FProductNumber,FProductName,FProdBatchNo").append('\n').append(";").append('\n');
            IRowSet rs = NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            while (rs.next()) {
                ret = true;
                if (rs.getInt("FCanntRevert") == 1) {
                    this._calcParam.calcLog.AddCalcLog(sb, level, reportItem_1, "[" + rs.getString("FProductNumber") + "]" + rs.getString("FProductName"));
                    continue;
                }
                this._calcParam.calcLog.AddCalcLog(sb, level, reportItem_2, "[" + rs.getString("FProductNumber") + "]" + rs.getString("FProductName"));
            }
            if (sb.length() > 0) {
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
            }
            return ret;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void ProcessReportDataForByEnd(StringBuffer sb, String tempTBL_CostRecoveryReport, String tempTBL_CostRecoveryReportSum, boolean isByCostCenter) throws EASBizException, BOSException {
        if (sb.length() > 0) {
            NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
            sb.setLength(0);
        }
        sb.append("delete from " + this._calcParam.GetTempTblCostRecoveryReportTempData());
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        sb.append("Insert into " + this._calcParam.GetTempTblCostRecoveryReportTempData()).append('\n');
        sb.append(" (FID ,FCostCenterID,FProductID,FProdBatchNo,FCostItemID,FAfterAmount)").append('\n');
        sb.append(" select newbosid('DFA50FD9') FID,S.FCostCenterID,S.FProductID,S.FProdBatchNo,S.FCostItemID,SUM(FAfterAmount)As FAfterAmount").append('\n');
        sb.append("\tFROM ").append(tempTBL_CostRecoveryReportSum).append(" S ").append('\n');
        sb.append(" WHERE S.FType=99 AND S.FCostItemID is not null AND S.FMaterialID is not null ").append('\n');
        sb.append(" GROUP BY S.FCostCenterID,S.FProductID,S.FProdBatchNo,S.FCostItemID ").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblCostRecoveryReportTempData());
        sb.append("UPDATE ").append(tempTBL_CostRecoveryReportSum).append(" As D SET FAfterAmount=isnull((").append('\n').append("\tSelect FAfterAmount As FAfterAmount ").append('\n').append("\tFROM " + this._calcParam.GetTempTblCostRecoveryReportTempData()).append(" S ").append('\n').append("\tWhere S.FCostCenterID=D.FCostCenterID AND S.FProductID=D.FProductID AND isnull(S.FProdBatchNo,' ')=isnull(D.FProdBatchNo,' ')").append('\n').append("\t  AND S.FCostItemID=D.FCostItemID").append('\n').append("),D.FAfterAmount) ").append('\n').append("WHERE D.FType=99 AND D.FCostItemID is not null AND D.FMaterialID is null ").append('\n').append(" AND EXISTS(").append('\n').append("\tSelect 1").append('\n').append("\tFROM t_NCM_CostItem CI ").append('\n').append("\tWHERE D.FCostItemID=CI.FID AND CI.FItemType='1'").append('\n').append(")").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        sb.append("delete from " + this._calcParam.GetTempTblCostRecoveryReportTempData());
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        sb.append("Insert into " + this._calcParam.GetTempTblCostRecoveryReportTempData()).append('\n');
        sb.append(" (FID ,FCostCenterID, FProductID, FProdBatchNo, FCostItemID, FMaterialID,FMatBatchNo,").append('\n');
        sb.append(" FAfterAmount,FAfterQty,FProcessQty,FProcessAmount)").append('\n');
        sb.append(" select newbosid('DFA50FD9') FID,FCostCenterID, FProductID, FProdBatchNo, FCostItemID, FMaterialID,FMatBatchNo,").append('\n');
        sb.append("   SUM(FBeforeAmount) As FAfterAmount,SUM(FBeforeQty) As FAfterQty, ").append('\n');
        sb.append("\t  SUM(FBeforeQty) As FProcessQty, SUM(FBeforeAmount) As FProcessAmount ").append('\n');
        sb.append("\tFROM ").append(tempTBL_CostRecoveryReport).append(" S ").append('\n');
        sb.append(" WHERE FType=2 AND FLayer=1 AND FIsLeaf=1 ").append('\n');
        sb.append("   AND FCostItemID is not null ").append('\n');
        sb.append("   AND FMaterialID is not null ").append('\n');
        sb.append(" GROUP BY FCostCenterID, FProductID, FProdBatchNo, FCostItemID, FMaterialID,FMatBatchNo ").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblCostRecoveryReportTempData());
        sb.append("UPDATE ").append(tempTBL_CostRecoveryReportSum).append(" AS D ").append('\n').append("SET (FAfterAmount,FAfterQty,FProcessQty,FProcessAmount) = (").append('\n').append("    select ").append("        D.FAfterAmount+S.FAfterAmount, D.FAfterQty+S.FAfterQty, S.FProcessQty, S.FProcessAmount ").append('\n').append("\t from ").append(this._calcParam.GetTempTblCostRecoveryReportTempData()).append(" S").append('\n').append("    where S.FCostCenterID = D.FCostCenterID ").append("        AND S.FProductID = D.FProductID ").append("        AND isnull(S.FProdBatchNo,' ') = isnull(D.FProdBatchNo,' ') ").append('\n').append("\t\t AND S.FCostItemID = D.FCostItemID").append('\n').append("\t\t AND S.FMaterialID = D.FMaterialID").append('\n').append("\t\t AND isnull(S.FMatBatchNo,' ') = isnull(D.FMatBatchNo,' ')").append('\n').append(") ").append('\n').append("WHERE D.FType=99 AND D.FCostItemID is not null AND D.FMaterialID is not null ").append('\n').append(";").append('\n');
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)tempTBL_CostRecoveryReport);
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        sb.setLength(0);
        sb.append("Create Table _tempTblMaterialCost (").append('\n');
        sb.append("FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FProdBatchNo VARCHAR(80),FCostItemID VARCHAR(44),").append('\n');
        sb.append("FAfterAmount NUMERIC(21,8),FAfterQty NUMERIC(21,8),FProcessQty NUMERIC(21,8),FProcessAmount NUMERIC(21,8))").append('\n');
        String temptable = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" insert into ").append(temptable).append(" (FCostCenterID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID, ").append('\n');
        sb.append(" FAfterAmount,FAfterQty,FProcessQty,FProcessAmount)").append('\n');
        sb.append("  select FCostCenterID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID, ").append('\n');
        sb.append("\t   S.FBeforeAmount As FAfterAmount, ").append('\n');
        sb.append("\t   S.FBeforeQty As FAfterQty, ").append('\n');
        sb.append("\t   S.FBeforeQty As FProcessQty, ").append('\n');
        sb.append("\t   S.FBeforeAmount As FProcessAmount ").append('\n');
        sb.append("\tFROM ").append(tempTBL_CostRecoveryReport).append(" S ").append('\n');
        sb.append(" WHERE S.FType=2 AND S.FLayer=0 AND S.FIsLeaf=1 AND S.FCostItemID is not null AND S.FMaterialID is null ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)temptable, (String)"FCostCenterID,FCostObjectID,FProductID,FProdBatchNo", (boolean)false, (boolean)false);
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)temptable);
        sb.setLength(0);
        sb.append("UPDATE ").append(tempTBL_CostRecoveryReportSum).append(" AS D SET (FAfterAmount,FAfterQty,FProcessQty,FProcessAmount)=(").append('\n').append("\tSelect D.FAfterAmount+S.FAfterAmount, ").append('\n').append("\t\tD.FAfterQty+S.FAfterQty, ").append('\n').append("\t\tS.FProcessQty, ").append('\n').append("\t\tS.FProcessAmount ").append('\n').append("\tFROM ").append(temptable).append(" S ").append('\n').append(" \tWHERE ").append('\n').append("\t\tS.FCostCenterID=D.FCostCenterID AND S.FCostObjectID=D.FCostObjectID AND S.FProductID=D.FProductID AND isnull(S.FProdBatchNo,' ')=isnull(D.FProdBatchNo,' ')").append('\n').append("\t\tAND S.FCostItemID=D.FCostItemID").append('\n').append(") ").append('\n').append("WHERE D.FType=99 AND D.FItemType<>1 AND D.FCostItemID is not null AND D.FMaterialID is null ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)temptable);
        sb.append("delete from " + this._calcParam.GetTempTblCostRecoveryReportTempData());
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        sb.append("Insert into " + this._calcParam.GetTempTblCostRecoveryReportTempData()).append('\n');
        sb.append(" (FID ,FCostCenterID, FProductID, FProdBatchNo, FCostItemID,").append('\n');
        sb.append(" FAfterAmount,FAfterQty)").append('\n');
        sb.append(" select newbosid('DFA50FD9') FID,FCostCenterID, FProductID, FProdBatchNo, FCostItemID,").append('\n');
        sb.append("   SUM(FBeforeAmount) As FAfterAmount,SUM(FBeforeQty) As FAfterQty ").append('\n');
        sb.append("\tFROM ").append(tempTBL_CostRecoveryReport).append(" S1 ").append('\n');
        sb.append(" \tWHERE S1.FType=2 AND S1.FLayer=1 AND S1.FIsLeaf=1 AND S1.FCostItemID is not null AND S1.FMaterialID is not null ").append('\n');
        sb.append("   GROUP BY S1.FCostCenterID,S1.FProductID,S1.FProdBatchNo,S1.FCostItemID ").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblCostRecoveryReportTempData());
        sb.append("UPDATE ").append(tempTBL_CostRecoveryReportSum).append(" As D SET (FAfterAmount,FAfterQty,FProcessQty,FProcessAmount)=(").append('\n').append("\tSelect top 1 D.FAfterAmount+Case when Isnull(SS.FAfterAmount,0)<>0 then SS.FAfterAmount else S.FBeforeAmount end As FAfterAmount, ").append('\n').append("\t\tD.FAfterQty+Case when Isnull(SS.FAfterQty,0)<>0 then SS.FAfterQty else S.FBeforeQty end As FAfterQty, ").append('\n').append("\t\tCase when Isnull(SS.FAfterQty,0)<>0 then SS.FAfterQty else S.FBeforeQty end As FProcessQty, ").append('\n').append("\t\tCase when Isnull(SS.FAfterAmount,0)<>0 then SS.FAfterAmount else S.FBeforeAmount end As FProcessAmount ").append('\n').append("\tFROM ").append(tempTBL_CostRecoveryReport).append(" S ").append('\n').append("\tLEFT JOIN ").append(this._calcParam.GetTempTblCostRecoveryReportTempData()).append('\n').append("\t SS ON SS.FCostCenterID=S.FCostCenterID AND SS.FProductID=S.FProductID AND isnull(SS.FProdBatchNo,' ')=isnull(S.FProdBatchNo,' ') AND SS.FCostItemID=S.FCostItemID ").append('\n').append(" \tWHERE S.FType=2 AND S.FLayer=1 AND S.FIsLeaf=1 AND S.FCostItemID is not null AND S.FMaterialID is not null ").append('\n').append("\t\tAND S.FCostCenterID=D.FCostCenterID AND S.FProductID=D.FProductID AND isnull(S.FProdBatchNo,' ')=isnull(D.FProdBatchNo,' ')").append('\n').append("\t\tAND S.FCostItemID=D.FCostItemID").append('\n').append(") ").append('\n').append("WHERE D.FType=99 AND D.FItemType=1 AND D.FCostItemID is not null AND D.FMaterialID is null ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        if (this._calcParam.recoveryModel.getValue().compareTo("0") == 0) {
            this._calcParam.replaceTempTBLCostRecoveryReport();
            tempTBL_CostRecoveryReport = tempTBL_CostRecoveryReportSum;
        } else {
            sb.append("DELETE FROM ").append(tempTBL_CostRecoveryReport).append(" WHERE FType<>99 ").append('\n').append(";").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
        }
        sb.append("UPDATE ").append(tempTBL_CostRecoveryReport).append(" As D SET FAfterQty=0 ").append('\n').append("WHERE D.FType=99 AND D.FItemType=1 AND D.FCostItemID is not null AND D.FMaterialID is null AND D.FAfterAmount=0 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        if (isByCostCenter) {
            return;
        }
        sb.append("UPDATE ").append(tempTBL_CostRecoveryReport).append(" SET FSFPQty=ROUND(FAfterQty-FProcessQty,FQtyDecimal) where FType=99 AND FCostItemID is not null ").append('\n').append(";").append('\n').append("UPDATE ").append(tempTBL_CostRecoveryReport).append(" SET FSFPAmount=ROUND(FAfterAmount-FProcessAmount,FAmountDecimal) where FType=99 AND FCostItemID is not null ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        sb.append("delete from " + this._calcParam.GetTempTblCostRecoveryReportTempData());
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        sb.append("Insert into " + this._calcParam.GetTempTblCostRecoveryReportTempData()).append('\n');
        sb.append(" (FID ,FCostCenterID, FProductID, FProdBatchNo, ").append('\n');
        sb.append(" FProcessAmount)").append('\n');
        sb.append(" select newbosid('DFA50FD9') FID,FCostCenterID, FProductID, FProdBatchNo,").append('\n');
        sb.append("   SUM(FProcessAmount) As FProcessAmount").append('\n');
        sb.append("\tFROM ").append(tempTBL_CostRecoveryReport).append(" S ").append('\n');
        sb.append(" WHERE S.FType=99 AND S.FCostItemID is not null AND S.FMaterialID is null ").append('\n');
        sb.append(" GROUP BY S.FCostCenterID,S.FProductID,S.FProdBatchNo ").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblCostRecoveryReportTempData());
        sb.append("UPDATE ").append(tempTBL_CostRecoveryReport).append(" As D SET FProcessAmount=isnull((").append('\n').append("\tSelect S.FProcessAmount As FProcessAmount ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTblCostRecoveryReportTempData()).append(" S ").append('\n').append("\tWhere S.FCostCenterID=D.FCostCenterID AND S.FProductID=D.FProductID AND isnull(S.FProdBatchNo,' ')=isnull(D.FProdBatchNo,' ')").append('\n').append("),0) ").append('\n').append("WHERE D.FType=99 AND D.FCostItemID is null AND D.FMaterialID is null ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        sb.append("delete from " + this._calcParam.GetTempTblCostRecoveryReportTempData());
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        sb.append("Insert into " + this._calcParam.GetTempTblCostRecoveryReportTempData()).append('\n');
        sb.append(" (FID ,FCostCenterID, FProductID, FProdBatchNo,").append('\n');
        sb.append(" FProcessAmount)").append('\n');
        sb.append(" select newbosid('DFA50FD9') FID,FCostCenterID, FProductID, FProdBatchNo,").append('\n');
        sb.append("   SUM(FSFPAmount) As FProcessAmount").append('\n');
        sb.append("\tFROM ").append(tempTBL_CostRecoveryReport).append(" S ").append('\n');
        sb.append(" WHERE S.FType=99 AND S.FCostItemID is not null AND S.FMaterialID is null ").append('\n');
        sb.append(" GROUP BY S.FCostCenterID,S.FProductID,S.FProdBatchNo ").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblCostRecoveryReportTempData());
        sb.append("UPDATE ").append(tempTBL_CostRecoveryReport).append(" As D SET FSFPAmount=isnull((").append('\n').append("\tSelect FProcessAmount As FSFPAmount ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTblCostRecoveryReportTempData()).append(" S ").append('\n').append("\tWhere S.FCostCenterID=D.FCostCenterID AND S.FProductID=D.FProductID AND isnull(S.FProdBatchNo,' ')=isnull(D.FProdBatchNo,' ')").append('\n').append("),0) ").append('\n').append("WHERE D.FType=99 AND D.FCostItemID is null AND D.FMaterialID is null ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
    }

    protected void SaveReportDataForByEnd(StringBuffer sb, String tempTBL_CostRecoveryReport, String TBL_CostRecoveryReport) throws EASBizException, BOSException {
        NCMDynamicTableManager.clearIndexsOfBusiTbl((Context)this._calcParam.ctx, (String)this._calcParam.companyId, (String)"T_NCM_CostRecoveryReportByEnd");
        sb.append("INSERT INTO ").append(TBL_CostRecoveryReport).append("(KSQL_SEQ, FID ,FCompanyID ,FCalculatePeriodID,FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID, ").append('\n').append("FPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,").append('\n').append("FCostItemGroupNumber,FCostItemGroupName,").append('\n').append("FCostItemNumber,FCostItemName,").append('\n').append("FMaterialNumber,FMaterialName,FMatBatchNo,FMaterielModel,FMaterielUnitName,").append('\n').append("FBeforeQty,FBeforeAmount,").append('\n').append("FSFPQty,FSFPAmount,").append('\n').append("FProcessQty,FProcessAmount,").append('\n').append("FAfterQty,FAfterAmount,").append('\n').append("FAfterUnitQty,FAfterUnitAmount,FAfterUnitRatio,").append('\n').append("FQtyDecimal,FPriceDecimal,FAmountDecimal)").append('\n').append("SELECT newbosid('DFA50FD9')As FID, ").append('\n').append("\tT.FCompanyID ,T.FCalculatePeriodID,T.FCostObjectID , T.FProductID, T.FCostItemGroupID, T.FCostItemID,FMaterialID, ").append('\n').append("\tT.FPeriodDispNumber,T.FProductNumber,T.FProductName,T.FProdBatchNo,T.FProductModel,T.FProductUnitName,").append('\n').append("\tisnull(T.FCostItemGroupNumber,' ')As FCostItemGroupNumber,isnull(T.FCostItemGroupName,' ')As FCostItemGroupName,").append('\n').append("\tisnull(T.FCostItemNumber,' ')As FCostItemNumber,isnull(T.FCostItemName,' ')As FCostItemName,").append('\n').append("\tisnull(T.FMaterialNumber,' ')As FMaterialNumber,isnull(T.FMaterialName,' ')As FMaterialName,isnull(T.FMatBatchNo,' ')As FMatBatchNo,isnull(T.FMaterielModel,' ')As FMaterielModel,isnull(T.FMaterielUnitName,N' ')As FMaterielUnitName,").append('\n').append("\tsum(T.FBeforeQty),sum(isnull(T.FBeforeAmount,0)),").append('\n').append("\tsum(T.FSFPQty),sum(isnull(T.FSFPAmount,0)),").append('\n').append("\tsum(T.FProcessQty),sum(T.FProcessAmount),").append('\n').append("\tsum(T.FAfterQty),sum(isnull(T.FAfterAmount,0)),").append('\n').append("\tRound(case when MAX(T1.FTotalFinishedQty) =0 then 0 else sum(T.FAfterQty)/MAX(T1.FTotalFinishedQty) end, max(T.FQtyDecimal)) FAfterUnitQty,").append('\n').append("   Round(case when MAX(T1.FTotalFinishedQty) =0 then 0 else sum(isnull(T.FAfterAmount,0))/MAX(T1.FTotalFinishedQty) end , max(T.FPriceDecimal)) FAfterUnitAmount,").append('\n').append("   Round(case when MAX(T1.FTotalFinishedQty) =0 or sum(T.FAfterAmountEx) = 0  then 0 else Round(sum(isnull(T.FAfterAmount,0))/MAX(T1.FTotalFinishedQty), max(T.FPriceDecimal))/(sum(T.FAfterAmountEx)/MAX(T1.FTotalFinishedQty))*100 end , max(T.FAmountDecimal)) FAfterUnitRatio, ").append('\n').append("\tmax(T.FQtyDecimal),max(T.FPriceDecimal),max(T.FAmountDecimal) ").append('\n').append("FROM ").append(tempTBL_CostRecoveryReport).append(" T ").append('\n').append(" inner join (SELECT P.FCostObjectID,P.FProductID,Isnull(P.FLot,N' ') As FProdBatchNo,SUM(P.FFinishedQty)As FTotalFinishedQty ").append('\n').append("   FROM ").append(this._calcParam.GetTBL_DataByProduct()).append(" P ").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append(" INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON  mcst.FMaterialID = P.FProductID AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("   GROUP BY P.FCostObjectID,P.FProductID,P.FLot ) T1 on T1.FCostObjectID=T.FCostObjectID and T1.FProductID=T.FProductID and T1.FProdBatchNo=T.FProdBatchNo ").append('\n').append("   Group by T.FCompanyID ,T.FCalculatePeriodID,T.FCostObjectID , T.FProductID, T.FCostItemGroupID, T.FCostItemID,T.FMaterialID,T.FMatBatchNo, ").append('\n').append("            T.FPeriodDispNumber,T.FProductNumber,T.FProductName,T.FProdBatchNo,T.FProductModel,T.FProductUnitName,").append("\t         T.FCostItemGroupNumber,T.FCostItemGroupName,T.FCostItemNumber,T.FCostItemName,").append('\n').append("\t         T.FMaterialNumber,T.FMaterialName,T.FMaterielModel,T.FMaterielUnitName").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
    }

    protected void SaveVourchDataFromByEndReport(StringBuffer sb, String tempTBL_CostRecoveryReport, String TBL_CostRecoveryVourchData) throws EASBizException, BOSException {
        sb.append("Create Table costcaldata (").append('\n').append("FCostCenterID VARCHAR(44),FCostObjectID  VARCHAR(44),FFinishedAmount NUMERIC(21,4))").append('\n');
        String temptable = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" insert into ").append(temptable).append(" (FCostCenterID ,FCostObjectID ,FFinishedAmount)").append('\n');
        sb.append("   select FCostCenterID ,FCostObjectID ,sum(FFinishedAmount) from ").append('\n');
        sb.append("       " + this.dataCache.getCostCalResultTable() + " t1 ").append('\n');
        sb.append("       group by  FCostCenterID ,FCostObjectID ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)temptable, (String)"FCostCenterID,FCostObjectID", (boolean)false, (boolean)false);
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)temptable);
        sb.setLength(0);
        sb.append("Create Table recoverydata (").append('\n').append("FCostCenterID VARCHAR(44),FCostObjectID  VARCHAR(44),FRecAmount NUMERIC(21,4))").append('\n');
        String temptable2 = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" insert into ").append(temptable2).append(" (FCostCenterID ,FCostObjectID ,FRecAmount)").append('\n');
        sb.append("   select FCostCenterID ,FCostObjectID ,sum(FAfterAmount) from ").append('\n');
        sb.append("       " + tempTBL_CostRecoveryReport + " t1 ").append('\n');
        sb.append("       where FCostItemID is not null AND FMaterialID is null AND (FAfterQty<>0 or FAfterAmount<>0) ").append('\n');
        sb.append("       group by  FCostCenterID ,FCostObjectID ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)temptable2, (String)"FCostCenterID,FCostObjectID", (boolean)false, (boolean)false);
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)temptable2);
        sb.setLength(0);
        sb.append(" select caldata.FCostCenterID FCostCenterID ,caldata.FCostObjectID FCostObjectID, FFinishedAmount-FRecAmount as FDiffAmount ").append('\n');
        sb.append(" from ").append(temptable).append(" caldata ").append('\n');
        sb.append("   INNER join ").append(temptable2).append(" recdata on caldata.FCostobjectID = recdata.FCostObjectID and caldata.FCostCenterID = recdata.FCostCenterID").append('\n');
        sb.append(" where FFinishedAmount-FRecAmount <> 0 ");
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)temptable);
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)temptable2);
        if (rs != null && rs.size() > 0) {
            sb.append("UPDATE ").append(tempTBL_CostRecoveryReport).append(" SET FAfterAmount=(FAfterAmount + ?)").append('\n');
            sb.append("WHERE FID =(").append('\n');
            sb.append("   Select top 1 FID ").append('\n');
            sb.append("   From ").append(tempTBL_CostRecoveryReport).append('\n');
            sb.append("   WHERE FCostCenterID = ? and  FCostObjectID = ? ").append('\n');
            sb.append("     AND FCostItemID is not null AND FMaterialID is null AND FAfterAmount<>0 ").append('\n');
            sb.append("   ORDER BY FAfterAmount DESC ").append('\n');
            sb.append(")");
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = this._calcParam.get_conn();
                pstmt = conn.prepareStatement(sb.toString());
                while (rs.next()) {
                    pstmt.setBigDecimal(1, rs.getBigDecimal("FDiffAmount"));
                    pstmt.setString(2, rs.getString("FCostCenterID"));
                    pstmt.setString(3, rs.getString("FCostObjectID"));
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup((ResultSet)rs, pstmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        }
        NCMDynamicTableManager.clearIndexsOfBusiTbl((Context)this._calcParam.ctx, (String)this._calcParam.companyId, (String)"T_NCM_CostRecoveryVourchData");
        sb.setLength(0);
        sb.append("INSERT INTO ").append(TBL_CostRecoveryVourchData).append("(FID ,FCompanyID ,FCalculatePeriodID,FCostCenterID,FCostObjectID, FProductID, FLot, FCostItemID, ").append('\n').append("FRecvQty,FRecvAmount)").append('\n').append("SELECT newbosid('C4774737')As FID, ").append('\n').append("\tFCompanyID ,FCalculatePeriodID,FCostCenterID,FCostObjectID , FProductID, FProdBatchNo As FLot, FCostItemID, ").append('\n').append("\tFAfterQty,FAfterAmount ").append('\n').append("FROM ").append(tempTBL_CostRecoveryReport).append('\n').append("WHERE FCostItemID is not null AND FMaterialID is null AND (FAfterQty<>0 or FAfterAmount<>0) ").append('\n').append("ORDER BY FCompanyID,FPeriodDispNumber,FCostCenterID,FProductNumber, isnull(FCostItemNumber,N' '),isnull(FMaterialNumber,N' ') ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
    }
}

