/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Recovery.Calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.CalcParam;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.RecoveryCalcBase;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class RecoveryCalcByEnd
extends RecoveryCalcBase {
    private static Logger logger = Logger.getLogger((String)RecoveryCalcByEnd.class.getName());
    BOSException multiExcetion = null;
    private CountDownLatch countDown;
    private final int MULTI_EXECUTE_SIZE = 100;
    private static final int MAX_THREAD = 10;

    public RecoveryCalcByEnd(CalcParam calcParam) {
        super(calcParam);
    }

    protected void InsertInputPartNew(StringBuffer sb) throws EASBizException, BOSException {
    }

    @Override
    public void PreProcess() throws EASBizException, BOSException {
        super.PreProcess();
    }

    @Override
    public void ProdRecovery() throws EASBizException, BOSException {
        super.ProdRecovery();
    }

    @Override
    public void InventoryRecovery() throws EASBizException, BOSException {
        super.InventoryRecovery();
    }

    @Override
    public void GenerateRecoveryReport() throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("truncate table ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(";").append('\n');
        sb.append("truncate table ").append(this._calcParam.GetTempTBL_CostRecoveryReportSum()).append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        this.RecoveryStockIn(false);
        this.GroupToByEnd(sb);
        this.ProcessReportDataForByEnd(sb, this._calcParam.GetTempTBL_CostRecoveryReport(), this._calcParam.GetTempTBL_CostRecoveryReportSum(), false);
        this.SaveReportDataForByEnd(sb, this._calcParam.GetTempTBL_CostRecoveryReportSum(), this._calcParam.GetTBL_CostRecoveryReport());
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RecoveryStockIn(boolean byCostCenter) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> AmtDiffAdjust = new HashMap<String, String>();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            NumberFormat fm = NumberFormat.getInstance();
            fm.setGroupingUsed(false);
            IRowSet rs = this.GetStockInData(byCostCenter);
            String lastCostCenterID = "";
            String lastCostObjectID = "";
            String lastProductId = "";
            String lastProdBatchNo = "";
            String lastCostItemID = "";
            int iDiffAdjustID = 0;
            int countDownSize = 0;
            countDownSize = rs.size() % 100 == 0 ? rs.size() / 100 : rs.size() / 100 + 1;
            this.countDown = new CountDownLatch(countDownSize);
            CtrlExecNum ctrlExecNum = new CtrlExecNum();
            int execCount = 0;
            while (rs.next()) {
                String isLeaf;
                ++execCount;
                boolean isTop = false;
                if (lastCostCenterID.compareTo(rs.getString("FCostCenterID")) != 0 || lastCostObjectID.compareTo(rs.getString("FCostobjectId")) != 0 || lastProductId.compareTo(rs.getString("FProductId")) != 0 || lastProdBatchNo.compareTo(rs.getString("FProdBatchNo")) != 0) {
                    fm.setMaximumFractionDigits(12);
                    String totalFinishedAmount = fm.format(BigDecimal.valueOf(0L));
                    if (rs.getBigDecimal("FTotalFinishedAmount") != null) {
                        totalFinishedAmount = fm.format(rs.getBigDecimal("FTotalFinishedAmount"));
                    }
                    String totalFinishedQty = fm.format(BigDecimal.valueOf(0L));
                    if (rs.getBigDecimal("FTotalFinishedQty") != null) {
                        totalFinishedQty = fm.format(rs.getBigDecimal("FTotalFinishedQty"));
                    }
                    sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FBeforeQty,FBeforeAmount,FAfterQty,FAfterAmount,FLayer,FIsLeaf,FType)").append('\n').append("Values(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostCenterID")).append("',").append("'").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductId")).append("','").append(rs.getString("FProdBatchNo")).append("',").append(totalFinishedQty).append(",").append(totalFinishedAmount).append(",").append(totalFinishedQty).append(",").append(totalFinishedAmount).append(",").append("-1,-1,1").append(")");
                    lastCostCenterID = rs.getString("FCostCenterID");
                    lastCostObjectID = rs.getString("FCostobjectId");
                    lastProductId = rs.getString("FProductId");
                    lastProdBatchNo = rs.getString("FProdBatchNo");
                    isTop = true;
                }
                if (lastCostItemID.compareTo(rs.getString("FCostItemID")) != 0 || isTop) {
                    fm.setMaximumFractionDigits(12);
                    String costItemAmount = fm.format(BigDecimal.valueOf(0L));
                    if (rs.getBigDecimal("FCostItemAmount") != null) {
                        costItemAmount = fm.format(rs.getBigDecimal("FCostItemAmount"));
                    }
                    String costItemQty = fm.format(BigDecimal.valueOf(0L));
                    if (rs.getBigDecimal("FCostItemQty") != null) {
                        costItemQty = fm.format(rs.getBigDecimal("FCostItemQty"));
                    }
                    isLeaf = "1";
                    if (rs.getString("FMaterialID") != null && rs.getString("FMaterialID").length() > 0) {
                        isLeaf = "0";
                    }
                    sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo,FCostItemID, ").append('\n').append(" FBeforeQty,FBeforeAmount,FLayer,FIsLeaf,FType)").append('\n').append("Values(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostCenterID")).append("',").append("'").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductId")).append("','").append(rs.getString("FProdBatchNo")).append("','").append(rs.getString("FCostItemID")).append("',").append(costItemQty).append(",").append(costItemAmount).append(",").append("0,").append(isLeaf).append(",2").append(")");
                    lastCostItemID = rs.getString("FCostItemID");
                }
                if (rs.getString("FMaterialID") != null && rs.getString("FMaterialID").length() > 0) {
                    fm.setMaximumFractionDigits(12);
                    String matAmount = fm.format(BigDecimal.valueOf(0L));
                    if (rs.getBigDecimal("FMatAmount") != null) {
                        matAmount = fm.format(rs.getBigDecimal("FMatAmount"));
                    }
                    String matQty = fm.format(BigDecimal.valueOf(0L));
                    if (rs.getBigDecimal("FMatQty") != null) {
                        matQty = fm.format(rs.getBigDecimal("FMatQty"));
                    }
                    isLeaf = "1";
                    if (rs.getInt("FHasCoef") == 1 || rs.getInt("FHasCoef2") == 1) {
                        isLeaf = "0";
                    }
                    sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FBeforeQty,FBeforeAmount,FLayer,FIsLeaf,FType)").append('\n').append("Values(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostCenterID")).append("',").append("'").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductId")).append("','").append(rs.getString("FProdBatchNo")).append("','").append(rs.getString("FCostItemID")).append("','").append(rs.getString("FMaterialID")).append("','").append(rs.getString("FMatBatchNo")).append("',").append(matQty).append(",").append(matAmount).append(",").append("1,").append(isLeaf).append(",2").append(")");
                    if (rs.getInt("FHasCoef") == 1) {
                        AmtDiffAdjust.put(String.valueOf(++iDiffAdjustID), matAmount);
                        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAfterAmount,FAfterQty,FLayer,FIsLeaf,FType,FDiffAdjustID)").append('\n').append("SELECT newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostCenterID")).append("',").append("\tW.FCostObjectID,W.FProductID,W.FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("    Round(W.FAmtCoef * ").append(matAmount).append(",CY.FPrecision) As FAmtCoef, Round(W.FQtyCoef * ").append(matQty).append(",Isnull(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FQtyCoef,-2 As FLayer,-2 As FIsLeaf,2,").append(iDiffAdjustID).append('\n').append("FROM ").append(this._calcParam.GetTBL_BopWIPCoef()).append(" W ").append('\n').append("LEFT JOIN T_ORG_Company CMP ON CMP.FID=W.FCompanyID ").append('\n').append("LEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append("LEFT JOIN T_BD_Material Prd ON Prd.FID=W.FProductID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MU ON Prd.FBaseUnit=MU.FID").append('\n').append("LEFT JOIN T_BD_Material Mat ON Mat.FID=W.FMaterialID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MatMU ON Mat.FBaseUnit=MatMU.FID").append('\n').append("WHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\tAND W.FProductID = '").append(rs.getString("FProductID")).append("' AND W.FProdBatchNo='").append(rs.getString("FProdBatchNo")).append("'").append('\n').append("\tAND W.FSubCostItemID = '").append(rs.getString("FCostItemID")).append("' AND W.FSubProductID='").append(rs.getString("FMaterialID")).append("'").append('\n').append("\tAND W.FSubProdBatchNo = '").append(rs.getString("FMatBatchNo")).append("'");
                    } else if (rs.getInt("FHasCoef2") == 1 && rs.getInt("FHasCoef") == 0) {
                        AmtDiffAdjust.put(String.valueOf(++iDiffAdjustID), matAmount);
                        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAfterAmount,FAfterQty,FLayer,FIsLeaf,FType,FDiffAdjustID)").append('\n').append("SELECT newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostCenterID")).append("','").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductID")).append("','").append(rs.getString("FProdBatchNo")).append("'").append("\t,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("    Round(W.FAmtCoef * ").append(matAmount).append(",CY.FPrecision) As FAmtCoef, Round(W.FQtyCoef * ").append(matQty).append(",Isnull(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FQtyCoef,-2 As FLayer,-2 As FIsLeaf,2,").append(iDiffAdjustID).append('\n').append("FROM ").append(this._calcParam.GetTBL_BopInvCoef()).append(" W ").append('\n').append("LEFT JOIN T_ORG_Company CMP ON CMP.FID=W.FCompanyID ").append('\n').append("LEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append("LEFT JOIN T_BD_Material Prd ON Prd.FID=W.FProductID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MU ON Prd.FBaseUnit=MU.FID").append('\n').append("LEFT JOIN T_BD_Material Mat ON Mat.FID=W.FMaterialID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MatMU ON Mat.FBaseUnit=MatMU.FID").append('\n').append("WHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("\tAND W.FProductID = '").append(rs.getString("FMaterialID")).append("' AND W.FProdBatchNo='").append(rs.getString("FMatBatchNo")).append("'");
                    }
                }
                if (execCount != 100) continue;
                ctrlExecNum.add();
                MultiExecuteSql multiExecuteSql = new MultiExecuteSql(this._calcParam.ctx, sb.toString(), ctrlExecNum);
                executor.execute(multiExecuteSql);
                sb.setLength(0);
                execCount = 0;
            }
            if (sb.length() > 0) {
                try {
                    NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
                    sb.setLength(0);
                }
                finally {
                    this.countDown.countDown();
                }
            }
            try {
                this.countDown.await();
            }
            finally {
                executor.shutdown();
            }
            if (this.multiExcetion != null) {
                throw this.multiExcetion;
            }
            if (!AmtDiffAdjust.isEmpty()) {
                ArrayList<String> sDiffAdjustIDs = new ArrayList<String>();
                Iterator itAmt = AmtDiffAdjust.entrySet().iterator();
                int count = 0;
                while (itAmt.hasNext()) {
                    ++count;
                    Map.Entry entry = itAmt.next();
                    String sDiffAdjustID = (String)entry.getKey();
                    String sMatAmount = (String)entry.getValue();
                    sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" SET FAfterAmount=(FAfterAmount + ").append(sMatAmount).append(" - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAfterAmount),0.00) ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S").append('\n').append("\tWHERE S.FMaterialID is null AND S.FDiffAdjustID=").append(sDiffAdjustID).append(" )").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 SS.FID ").append('\n').append("\tFrom ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" SS ").append('\n').append("\tWHERE SS.FMaterialID is null AND SS.FDiffAdjustID=").append(sDiffAdjustID).append('\n').append("\tORDER BY SS.FAfterAmount DESC ").append('\n').append(");");
                    sDiffAdjustIDs.add(sDiffAdjustID);
                    if (count != 500) continue;
                    count = 0;
                    NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
                    sb.setLength(0);
                }
                if (sb.length() > 0) {
                    NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
                    sb.setLength(0);
                }
                if (sDiffAdjustIDs.size() > 0) {
                    StringBuilder inSql = new StringBuilder("(");
                    for (String s : sDiffAdjustIDs) {
                        inSql.append("'").append(s).append("',");
                    }
                    inSql.setLength(inSql.length() - 1);
                    inSql.append(")");
                    this.adjustDiff_Mat(inSql.toString());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public void RecoveryStockIn_Oracle(boolean byCostCenter) throws EASBizException, BOSException {
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        StringBuffer sb = new StringBuffer();
        StringBuffer sbStockInDataSelectSql = new StringBuffer();
        sb.append("/*dialect*/");
        sbStockInDataSelectSql = this.GetStockInDataSelectSql(byCostCenter);
        String SelDefine = null;
        try {
            SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)this._calcParam.CurrentDataBaseType);
            if (SelDefine.indexOf("(+)") != -1) {
                SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)7);
            }
        }
        catch (SqlTranslateException e) {
            try {
                SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)8);
            }
            catch (SqlTranslateException e2) {
                e2.printStackTrace();
                throw new BOSException(e2.getMessage());
            }
        }
        sb.append(" declare CURSOR cur IS ").append(SelDefine).append(";").append('\n').append("\tcurrInfo cur%rowtype; ").append('\n').append("\tsort NUMBER := 0; ").append('\n').append("\tlastCostCenterID VARCHAR2 (44) := ' '; ").append('\n').append("\tlastCostObjectID VARCHAR2 (44) := ' '; ").append('\n').append("\tlastProductId VARCHAR2 (44) := ' '; ").append('\n').append("\tlastProdBatchNo VARCHAR2 (80) := ' '; ").append('\n').append("\tlastCostItemID VARCHAR2 (44) := ' '; ").append('\n').append("\tisLeaf NUMBER := 0; ").append('\n').append("\tiDiffAdjustID NUMBER := 0; ").append('\n').append("\tisTop Boolean := false; ").append('\n').append(" BEGIN ").append('\n').append("\topen cur; ").append('\n').append("\tloop ").append('\n').append("\t   fetch cur into currInfo; ").append('\n').append("\t   exit when cur%notfound; ").append('\n').append("\t\t isTop := false;").append('\n').append("\t\t --A.1,\u4ea7\u54c1\u672c\u5c42").append('\n').append("\t\t if ((lastCostCenterID <> currInfo.FCostCenterID)OR (lastCostObjectID <> currInfo.FCostobjectId) OR (lastProductId <> currInfo.FProductId)OR (lastProdBatchNo <> currInfo.FProdBatchNo))then ").append('\n').append("\t\t \tINSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("\t\t \t(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append("\t\t \t FBeforeQty,FBeforeAmount,FAfterQty,FAfterAmount,FLayer,FIsLeaf,FType)").append('\n').append("\t\t \tValues(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',currInfo.FCostCenterID,currInfo.FCostObjectID,currInfo.FProductId,currInfo.FProdBatchNo,").append("\t\t \t currInfo.FTotalFinishedQty,currInfo.FTotalFinishedAmount,currInfo.FTotalFinishedQty,currInfo.FTotalFinishedAmount,-1,-1,1);").append('\n').append("\t\t \tlastCostCenterID := currInfo.FCostCenterID;").append('\n').append("\t\t \tlastCostObjectID := currInfo.FCostobjectId;").append('\n').append("\t\t \tlastProductId := currInfo.FProductId;").append('\n').append("\t\t \tlastProdBatchNo := currInfo.FProdBatchNo;").append('\n').append("\t\t \tisTop := true;").append('\n').append("\t\t end if; --end of A.1,\u4ea7\u54c1\u672c\u5c42").append('\n').append("\t\t --A.2,\u63d2\u5165\u6210\u672c\u9879\u76ee\u6c47\u603b\u4fe1\u606f").append('\n').append("\t\t if (lastCostItemID <> currInfo.FCostItemID OR isTop )then").append('\n').append("\t\t \tif (currInfo.FMaterialID IS NOT NULL)then").append('\n').append("\t\t \t\tisLeaf := 0;").append('\n').append("\t\t \telse ").append('\n').append("\t\t \t\tisLeaf := 1;").append('\n').append("\t\t \tend if;").append('\n').append("\t\t \tINSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("\t\t \t(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo,FCostItemID, ").append('\n').append("\t\t \t FBeforeQty,FBeforeAmount,FLayer,FIsLeaf,FType)").append('\n').append("\t\t \tValues(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',currInfo.FCostCenterID,currInfo.FCostObjectID,currInfo.FProductId,currInfo.FProdBatchNo,currInfo.FCostItemID,").append("\t\t \t currInfo.FCostItemQty,currInfo.FCostItemAmount,0,isLeaf,2);").append('\n').append("\t\t \tlastCostItemID := currInfo.FCostItemID;").append('\n').append("\t\t end if; --end of A.2,\u63d2\u5165\u6210\u672c\u9879\u76ee\u6c47\u603b\u4fe1\u606f").append('\n').append("\t\t --A.3,\u63d2\u5165\u672c\u5c42\u6750\u6599\u660e\u7ec6(\u5982\u679c\u6709\u65f6)").append('\n').append("\t\t if (currInfo.FMaterialID IS NOT NULL)then").append('\n').append("\t\t \tif (currInfo.FHasCoef = 1)then").append('\n').append("\t\t \t\tisLeaf := 0;").append('\n').append("\t\t \telse ").append('\n').append("\t\t \t\tisLeaf := 1;").append('\n').append("\t\t \tend if;").append('\n').append("\t\t \tINSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("\t\t \t(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append("\t\t \t FCostItemID,FMaterialID,FMatBatchNo,FBeforeQty,FBeforeAmount,FLayer,FIsLeaf,FType)").append('\n').append("\t\t \tValues(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',currInfo.FCostCenterID,currInfo.FCostObjectID,currInfo.FProductId,currInfo.FProdBatchNo,currInfo.FCostItemID,currInfo.FMaterialID,currInfo.FMatBatchNo,").append("\t\t \t currInfo.FMatQty,currInfo.FMatAmount,1,isLeaf,2);").append('\n').append("\t\t \t--A.4\u81ea\u5236\u5b50\u9879\u65f6\u5c55\u5f00\u4e0b\u5c42\u7ed3\u6784").append('\n').append("\t\t \tif (currInfo.FHasCoef = 1)then").append('\n').append("\t\t \t\tiDiffAdjustID := (iDiffAdjustID + 1);").append('\n').append("\t\t \t\tINSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("\t\t \t\t(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append("\t\t \t\t FCostItemID,FMaterialID,FMatBatchNo,FAfterAmount,FAfterQty,FLayer,FIsLeaf,FType,FDiffAdjustID)").append('\n').append("\t\t \t\tSELECT newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',currInfo.FCostCenterID,").append('\n').append("\t\t \t\t\tW.FCostObjectID,W.FProductID,W.FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("\t\t \t\t    Round(W.FAmtCoef * currInfo.FMatAmount,CY.FPrecision) As FAmtCoef, Round(W.FQtyCoef * currInfo.FMatQty,NVL(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FQtyCoef,-2 As FLayer,-2 As FIsLeaf,2,iDiffAdjustID ").append('\n').append("\t\t \t\tFROM ").append(this._calcParam.GetTBL_BopWIPCoef()).append(" W ").append('\n').append("\t\t \t\tLEFT JOIN T_ORG_Company CMP ON CMP.FID=W.FCompanyID ").append('\n').append("\t\t \t\tLEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append("\t\t \t\tLEFT JOIN T_BD_Material Prd ON Prd.FID=W.FProductID ").append('\n').append("\t\t \t\tLEFT JOIN T_BD_MeasureUnit MU ON Prd.FBaseUnit=MU.FID").append('\n').append("\t\t \t\tLEFT JOIN T_BD_Material Mat ON Mat.FID=W.FMaterialID ").append('\n').append("\t\t \t\tLEFT JOIN T_BD_MeasureUnit MatMU ON Mat.FBaseUnit=MatMU.FID").append('\n').append("\t\t \t\tWHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\t\t \t\t\tAND W.FProductID = currInfo.FProductID AND W.FProdBatchNo=currInfo.FProdBatchNo").append('\n').append("\t\t \t\t\tAND W.FSubCostItemID = currInfo.FCostItemID AND W.FSubProductID=currInfo.FMaterialID").append('\n').append("\t\t \t\t\tAND W.FSubProdBatchNo = currInfo.FMatBatchNo;").append('\n').append("\t\t \t\t--\u7b2c\u4e00\u5c42\u8c03\u5dee").append('\n').append("\t\t\t\tUPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" SET FAfterAmount=((FAfterAmount + currInfo.FMatAmount - ").append('\n').append("\t\t\t\t\t(SELECT NVL(SUM(S.FAfterAmount),0.00) ").append('\n').append("\t\t\t\t\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S").append('\n').append("\t\t\t\t\tWHERE S.FMaterialID is null AND S.FDiffAdjustID=iDiffAdjustID )))").append('\n').append("\t\t\t\tWHERE FID =(").append('\n').append("\t\t\t\t\tSelect * FROM ( ").append('\n').append("\t\t\t\t\t\tSelect FID ").append('\n').append("\t\t\t\t\t\tFrom ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n').append("\t\t\t\t\t\tWHERE FMaterialID is null AND FDiffAdjustID=iDiffAdjustID").append('\n').append("\t\t\t\t\t\tORDER BY FAfterAmount DESC ").append('\n').append("\t\t\t\t\t) ").append('\n').append("\t\t\t\t\tWHERE ROWNUM <= 1 ").append('\n').append("\t\t\t\t);").append("\t\t \t\t--\u7b2c\u4e8c\u5c42\u53ca\u4ee5\u4e0b\u5c42\u8c03\u5dee").append('\n').append("\t\t \t\tP_NCMRecoveryAdjustDiff_ByEnd(iDiffAdjustID);").append('\n').append("\t\t \tend if; --end of A.4\u81ea\u5236\u5b50\u9879\u65f6\u5c55\u5f00\u4e0b\u5c42\u7ed3\u6784").append('\n').append("\t\t end if; --end of A.3,\u63d2\u5165\u672c\u5c42\u6750\u6599\u660e\u7ec6(\u5982\u679c\u6709\u65f6)").append('\n').append("\tend loop; ").append('\n').append("\tclose cur; ").append('\n').append("end; ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private void adjustDiff_Mat(String sDiffAdjustIDs) throws BOSException, EASBizException {
        block11: {
            PreparedStatement pstmt;
            block10: {
                String tblSrc = this._calcParam.GetTempTBL_CostRecoveryReport();
                String tblDest = this._calcParam.GetTempTBL_CostRecoveryReport();
                StringBuffer sb = new StringBuffer();
                sb.append("Select D.FDiffAdjustID,D.FCostCenterID,D.FCostObjectID,D.FCostItemID, ").append('\n').append("\t(S.FSrcAfterAmount - D.FDestAfterAmount) As FAmountDiff ").append('\n').append("FROM (").append('\n').append("\tSelect FDiffAdjustID,FCostCenterID,FCostObjectID,FCostItemID,Sum(FAfterAmount)As FDestAfterAmount ").append('\n').append("\tFrom ").append(tblDest).append(" DD ").append('\n').append("\tINNER JOIN t_NCM_CostItem CI ON CI.FID=DD.FCostItemID AND CI.FItemType= '1' ").append('\n').append("\tWHERE DD.FMaterialID is not null AND DD.FDiffAdjustID in ").append(sDiffAdjustIDs).append('\n').append("\tGroup by FDiffAdjustID,FCostCenterID,FCostObjectID,FCostItemID ").append('\n').append(")D").append('\n').append("Inner join (").append('\n').append("\tSelect FDiffAdjustID,FCostCenterID,FCostObjectID, FCostItemID,Sum(FAfterAmount)As FSrcAfterAmount ").append('\n').append("\tFrom ").append(tblSrc).append(" SS ").append('\n').append("\tINNER JOIN t_NCM_CostItem CI ON CI.FID=SS.FCostItemID AND CI.FItemType= '1' ").append('\n').append("\tWHERE SS.FMaterialID is null AND SS.FDiffAdjustID in ").append(sDiffAdjustIDs).append('\n').append("\tGroup by FDiffAdjustID,FCostCenterID,FCostObjectID,FCostItemID ").append('\n').append(")S On D.FDiffAdjustID = S.FDiffAdjustID AND D.FCostCenterID=S.FCostCenterID AND D.FCostObjectID=S.FCostObjectID AND D.FCostItemID=S.FCostItemID ").append('\n').append("Where S.FSrcAfterAmount<>D.FDestAfterAmount ").append('\n').append("\tAND (S.FSrcAfterAmount - D.FDestAfterAmount)>-0.50 AND (S.FSrcAfterAmount - D.FDestAfterAmount)<0.50 ").append('\n').append("").append('\n');
                IRowSet rs = null;
                rs = NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)sb.toString());
                Connection conn = null;
                pstmt = null;
                boolean isNewConn = false;
                try {
                    sb.delete(0, sb.length());
                    sb.append("UPDATE ").append(tblDest).append(" SET FAfterAmount=(FAfterAmount + ? ) ").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(tblDest).append('\n').append("\tWHERE FCostCenterID=? AND FCostObjectID=? AND FCostItemID=? AND FMaterialID is not null AND FDiffAdjustID=?").append('\n').append("\tORDER BY FAfterAmount DESC )");
                    if (this._calcParam.get_conn() == null) {
                        conn = EJBFactory.getConnection((Context)this._calcParam.ctx);
                        isNewConn = true;
                    } else {
                        conn = this._calcParam.get_conn();
                    }
                    pstmt = conn.prepareStatement(sb.toString());
                    int executeCount = 0;
                    while (rs.next()) {
                        ++executeCount;
                        pstmt.setDouble(1, rs.getDouble("FAmountDiff"));
                        pstmt.setString(2, rs.getString("FCostCenterID"));
                        pstmt.setString(3, rs.getString("FCostObjectID"));
                        pstmt.setString(4, rs.getString("FCostItemID"));
                        pstmt.setString(5, rs.getString("FDiffAdjustID"));
                        pstmt.addBatch();
                        if (executeCount != 500) continue;
                        pstmt.executeBatch();
                        pstmt.clearBatch();
                        executeCount = 0;
                    }
                    if (executeCount > 0) {
                        pstmt.executeBatch();
                    }
                    if (!isNewConn) break block10;
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (isNewConn) {
                            SQLUtils.cleanup(pstmt, conn);
                        } else {
                            SQLUtils.cleanup(pstmt);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                break block11;
            }
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    private void GroupToByEnd(StringBuffer sb) throws EASBizException, BOSException {
        sb.append("update " + this._calcParam.GetTempTBL_CostRecoveryReport() + " As D \n");
        sb.append("set (FBeforeQtyEx, FAfterAmountEx) = ( \n");
        sb.append("    select FBeforeQty, FAfterAmount \n");
        sb.append("    from " + this._calcParam.GetTempTBL_CostRecoveryReport() + " t \n");
        sb.append("    where t.FCostCenterID = D.FCostCenterID and t.FProductID = D.FProductID AND t.FProdBatchNo = d.FProdBatchNo \n");
        sb.append("        AND t.FCostItemID is null AND t.FMaterialID is null ");
        sb.append("); \n");
        sb.append(" \n");
        sb.append("update " + this._calcParam.GetTempTBL_CostRecoveryReport() + " As D \n");
        sb.append("set (FQtyDecimal,FPriceDecimal,FAmountDecimal) = ( \n");
        sb.append("    select mu.FQtyPrecision, 6,CY.FPrecision \n");
        sb.append("    from " + this._calcParam.GetTempTBL_CostRecoveryReport() + " t \n");
        sb.append("    LEFT JOIN T_NCM_CostItem ci ON t.FCostItemID = ci.FID \n");
        sb.append("    LEFT JOIN T_BD_MeasureUnit mu ON mu.FID = ci.FUnitID \n");
        sb.append("    LEFT JOIN T_ORG_Company CMP ON CMP.FID=t.FCompanyID ").append('\n');
        sb.append("    LEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n');
        sb.append("    where t.FID = D.FID \n");
        sb.append("); \n");
        sb.append(" \n");
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_CostRecoveryReport());
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_CostRecoveryReport(), (String)"fid", (boolean)true, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_CostRecoveryReport(), (String)"FCOSTCENTERID,FPRODUCTID,FCOSTITEMID,FMATERIALID,FPRODBATCHNO", (boolean)false, (boolean)false);
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        StringBuffer unionTbl = new StringBuffer(128);
        unionTbl.append("SELECT FQtyDecimal,FPriceDecimal,FProductID,FCostItemID FROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n');
        unionTbl.append("UNION ALL").append('\n');
        unionTbl.append("SELECT FQtyDecimal,FPriceDecimal,FProductID,FCostItemID FROM ").append(this._calcParam.GetTempTBL_CostRecoveryReportSum()).append('\n');
        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReportSum()).append("(FID ,FCompanyID ,FCalculatePeriodID,FCostCenterID,FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID, ").append('\n').append("FPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,").append('\n').append("FCostItemGroupNumber,FCostItemGroupName,").append('\n').append("FCostItemNumber,FCostItemName,").append('\n').append("FMaterialNumber,FMaterialName,FMatBatchNo,FMaterielModel,FMaterielUnitName,").append('\n').append("FBeforeQty,FBeforeAmount,").append('\n').append("FAfterQty,FAfterAmount,").append('\n').append("FBeforeQtyEx, FAfterAmountEx,").append('\n').append("FQtyDecimal,FPriceDecimal,FAmountDecimal,FItemType,FType)").append('\n').append("SELECT newbosid('DFA50FD9')As FID,D.FCompanyID,D.FCalculatePeriodID,D.FCostCenterID,D.FCostObjectID,D.FProductID, ").append('\n').append("\tCIT.FID As FCostItemGroupID,D.FCostItemID,D.FMaterialID,").append('\n').append("\t").append(this._calcParam.periodDispNumber).append(" As FPeriodDispNumber,").append("\tPrd.FNumber As FProductNumber,Prd.FName_").append(this._calcParam.locale).append(" As FProductName,D.FProdBatchNo,Prd.FModel As FProductModel,MU.FName_").append(this._calcParam.locale).append(" As FProductUnitName,").append('\n').append("\tCIT.FNumber As FCostItemGroupNumber,CIT.FName_").append(this._calcParam.locale).append(" As FCostItemGroupName,").append('\n').append("\tCI.FNumber As FCostItemNumber,CI.FName_").append(this._calcParam.locale).append(" As FCostItemName,").append('\n').append("\tMat.FNumber As FMaterialNumber,Mat.FName_").append(this._calcParam.locale).append(" As FMaterialName,D.FMatBatchNo,Mat.FModel As FMaterielModel,MatMU.FName_").append(this._calcParam.locale).append(" As FMaterielUnitName,").append('\n').append("\tSUM(D.FBeforeQty)As FBeforeQty, SUM(D.FBeforeAmount)As FBeforeAmount,").append('\n').append("\tSUM(D.FAfterQty)As FAfterQty,SUM(D.FAfterAmount)As FAfterAmount,").append('\n').append("   MAX(D.FBeforeQtyEx) AS\u3000FBeforeQtyEx, MAX(D.FAfterAmountEx) AS FAfterAmountEx,").append('\n').append("\tMax(isnull(MUltMU.FQtyPrecision,0)) As FQtyDecimal,Max(isnull(Mat.FPricePrecision,0)) As FPriceDecimal,Max(CY.FPrecision) As FAmountDecimal,to_int(Max(CI.FItemType))As FItemType,99 As FType ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" D ").append('\n').append("LEFT JOIN T_BD_Material Prd ON Prd.FID=D.FProductID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MU ON Prd.FBaseUnit=MU.FID").append('\n').append("LEFT JOIN T_NCM_CostItem CI ON CI.FID=D.FCostItemID ").append('\n').append("LEFT JOIN t_Ncm_Costitemtypetree CIT ON CIT.FID=CI.FTypeTreeID ").append('\n').append("LEFT JOIN T_BD_Material Mat ON Mat.FID=D.FMaterialID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MatMU ON Mat.FBaseUnit=MatMU.FID").append('\n').append("LEFT JOIN T_BD_MultiMeasureUnit MUltMU ON MUltMU.FMeasureUnitID=MatMU.FID and MUltMU.FMaterialID = Mat.FID ").append('\n').append("LEFT JOIN T_ORG_Company CMP ON CMP.FID=D.FCompanyID ").append('\n').append("LEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append("WHERE D.FType<>99 ").append('\n').append("GROUP BY D.FCompanyID,D.FCalculatePeriodID,D.FCostCenterID,D.FCostObjectID,D.FProductID,").append('\n').append("\tPrd.FNumber,Prd.FName_").append(this._calcParam.locale).append(",D.FProdBatchNo,Prd.FModel,MU.FName_").append(this._calcParam.locale).append(",").append('\n').append("\tCIT.FID,CIT.FNumber,CIT.FName_").append(this._calcParam.locale).append(",").append('\n').append("\tD.FCostItemID,CI.FNumber,CI.FName_").append(this._calcParam.locale).append(",").append('\n').append("\tD.FMaterialID,Mat.FNumber,Mat.FName_").append(this._calcParam.locale).append(",D.FMatBatchNo,Mat.FModel,MatMU.FName_").append(this._calcParam.locale).append('\n').append("ORDER BY D.FCompanyID,D.FCalculatePeriodID,D.FCostCenterID,Prd.FNumber,CIT.FNumber,CI.FNumber,Mat.FNumber ").append('\n').append(";").append('\n').append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReportSum()).append(" As D SET FQtyDecimal=(").append('\n').append("\tSelect max(FQtyDecimal) ").append('\n').append("\tFROM (").append(unionTbl).append(") S ").append('\n').append("\tWHERE D.FProductID = S.FProductID and D.FCostItemID = S.FCostItemID").append('\n').append(") ").append('\n').append("WHERE D.FType=99 AND D.FMaterialID is null ").append('\n').append(";").append('\n').append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReportSum()).append(" As D SET FQtyDecimal=(").append('\n').append("\tSelect max(FQtyDecimal) ").append('\n').append("\tFROM (").append(unionTbl).append(") S ").append('\n').append("\tWHERE D.FProductID = S.FProductID ").append('\n').append(") ").append('\n').append("WHERE D.FType=99 AND D.FCostItemID is null ").append('\n').append(";").append('\n').append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReportSum()).append(" As D SET FPriceDecimal=(").append('\n').append("\tSelect Max(FPriceDecimal) ").append('\n').append("\tFROM (").append(unionTbl).append(") S ").append('\n').append("\tLEFT JOIN T_BD_Material Prd ON Prd.FID=S.FProductID ").append('\n').append("\tWHERE D.FProductID = S.FProductID and D.FCostItemID = S.FCostItemID ").append('\n').append(") ").append('\n').append("WHERE D.FType=99 AND D.FMaterialID is null ").append('\n').append(";").append('\n').append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReportSum()).append(" As D SET FPriceDecimal=(").append('\n').append("\tSelect Max(FPriceDecimal) ").append('\n').append("\tFROM (").append(unionTbl).append(") S ").append('\n').append("\tLEFT JOIN T_BD_Material Prd ON Prd.FID=S.FProductID ").append('\n').append("\tWHERE D.FProductID = S.FProductID ").append('\n').append(") ").append('\n').append("WHERE D.FType=99 AND D.FCostItemID is null ").append('\n').append(";").append('\n').append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReportSum()).append(" SET FAfterQty=ROUND(FAfterQty,FQtyDecimal) where FType=99 AND FMaterialID is not null ").append('\n').append(";").append('\n').append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReportSum()).append(" SET FAfterAmount=ROUND(FAfterAmount,FAmountDecimal) where FType=99 AND FCostItemID is not null AND FAfterAmount<>0 ").append('\n').append(";").append('\n');
    }

    @Override
    public void GenerateRecoveryVourchData() throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("truncate table ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(";").append('\n');
        sb.append("truncate table ").append(this._calcParam.GetTempTBL_CostRecoveryReportSum()).append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        this.RecoveryStockIn(true);
        this.GroupToByEnd(sb);
        this.ProcessReportDataForByEnd(sb, this._calcParam.GetTempTBL_CostRecoveryReport(), this._calcParam.GetTempTBL_CostRecoveryReportSum(), false);
        this.SaveVourchDataFromByEndReport(sb, this._calcParam.GetTempTBL_CostRecoveryReportSum(), this._calcParam.GetTBL_CostRecoveryVourchData());
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
    }

    @Override
    public void EndProcess() throws EASBizException, BOSException {
        super.EndProcess();
    }

    @Override
    protected void InsertBoPWipPart(StringBuffer sb) throws EASBizException, BOSException {
        String tblBalance = this._calcParam.GetTBL_Balance();
        String tblBalanceEntry = this._calcParam.GetTBL_BalanceEntry();
        String tblBalanceMatDetail = this._calcParam.GetTBL_BalanceMatDetail();
        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo,FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FSubProdQty,FAmtCoef,FQtyCoef,FType)").append('\n').append("Select newbosid('DFA50FD9')As FID,M.FCostObjectID,M.FProductID,M.FProdBatchNo,M.FCostItemID As FSubCostItemID,S.FSubCostObjID, S.FSubProductID, S.FSubProdBatchNo,").append('\n').append("\tS.FCostItemID, S.FMaterialID,S.FMatBatchNo,").append('\n').append("\tM.FQty As FSubProdQty,to_decimal(M.FAmount * S.FAmtCoef,24,12) As FAmtCoef,to_decimal(M.FQty * S.FQtyCoef,24,12)As FQtyCoef,11 As FType ").append('\n').append("FROM (").append('\n').append("\tSELECT DISTINCT bal.FCostObjectID,OBJ.FStdProductIDID As FProductID,ISNULL(OBJ.FBatchNumber,N' ')As FProdBatchNo,balMat.FCostItemID,balMatDetail.FMaterialID, ISNULL(O.FCostObjBatchNo,N' ')As FMatBatchNo, ").append('\n').append("\t\tSUM(balMatDetail.FQty)As FQty,SUM(balMatDetail.FAmount)As FAmount").append('\n').append("\tFROM ").append(tblBalanceMatDetail).append(" balMatDetail ").append('\n').append("\tINNER JOIN ").append(tblBalanceEntry).append(" balMat ON balMat.FID=balMatDetail.FParentID ").append('\n').append("\tINNER JOIN ").append(tblBalance).append(" bal ON bal.FID=balMat.FParentID ").append('\n').append("\tINNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ON CO.FCostObjectID=bal.FCostObjectID").append('\n').append("\tINNER JOIN T_BD_MaterialCompanyInfo mat ON mat.FCompanyID=bal.FCompanyOrg AND mat.FMaterialID = balMatDetail.FMaterialID AND mat.FStatus=1 AND mat.FCalculateType=2 ").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append("\tINNER JOIN T_BD_MaterialCost mcst ON mcst.FOrgUnit=bal.FCompanyOrg AND mcst.FMaterialID = balMatDetail.FMaterialID AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("\tLEFT OUTER JOIN T_BD_CostObject OBJ ON OBJ.FID=bal.FCostObjectID ").append('\n').append("\tLEFT JOIN (").append('\n').append("\t\tSELECT distinct COE.FRelatedID As FProductId,Isnull(CO.FBatchNumber,N' ') As FProdBatchNo ,Isnull(CO.FBatchNumber,N' ') As FCostObjBatchNo").append('\n').append("\t\tFROM T_BD_CostObject CO ").append('\n').append("\t\tLEFT JOIN T_BD_COstObjectEntry COE on COE.FParentId = CO.Fid ").append('\n').append("\t\tWHERE CO.FIsForbiden = 0 AND CO.FCalculateMode=4 AND CO.FCompanyID = '").append(this._calcParam.companyId).append("' ").append('\n').append("\t\tUNION ").append('\n').append("\t\tSELECT FMaterialID As FProductId,FLot As FProdBatchNo,FCostObjBatchNo ").append('\n').append("\t\tFROM ").append(this._calcParam.GetTBL_LotMapping()).append("  ").append('\n').append("\t)O ON O.FProductId=balMatDetail.FMaterialID AND O.FProdBatchNo=balMatDetail.FBatchNo ").append('\n').append("\tWHERE bal.FCompanyOrg='").append(this._calcParam.companyId).append("' AND bal.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\tGROUP BY bal.FCostObjectID,OBJ.FStdProductIDID,OBJ.FBatchNumber,balMat.FCostItemID,balMatDetail.FMaterialID, O.FProdBatchNo,O.FCostObjBatchNo ").append('\n').append("\tHAVING SUM(balMatDetail.FQty) <>0 ").append('\n').append(")M ").append('\n').append("INNER JOIN ").append(this._calcParam.GetTBL_BopWIPCoef()).append(" S ON S.FProductID=M.FProductID AND S.FProdBatchNo=M.FProdBatchNo AND S.FSubCostItemID =M.FCostItemID ").append('\n').append("\tAND S.FSubProductID=M.FMaterialID AND S.FSubProdBatchNo=M.FMatBatchNo").append('\n').append("\tAND S.FCompanyID='").append(this._calcParam.companyId).append("' AND S.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append("INNER JOIN T_BD_MaterialCost mcst ON mcst.FOrgUnit=S.FCompanyID AND mcst.FMaterialID = M.FProductID AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("ORDER BY M.FProductID").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void InsertInputPart(StringBuffer sql) throws EASBizException, BOSException {
        String costObjTmpTblName = null;
        String costObjLotMapTempTbl = null;
        String costCalTmpTblName = null;
        String balanceTmpTblName = null;
        try {
            costObjTmpTblName = this.getCostObjTemp();
            costObjLotMapTempTbl = this.getCostObjLotMapTempTbl();
            costCalTmpTblName = this.getCostCalTemp(costObjLotMapTempTbl);
            balanceTmpTblName = this.getBalanceTemp(costObjLotMapTempTbl);
            sql.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append('\n').append("    (FID, FCostObjectID, FProductID, FProdBatchNo, ").append('\n').append("    FSubCostItemID, FSubCostObjID, ").append('\n').append("    FSubProductID, FSubProdBatchNo, ").append('\n').append("    FCostItemID, FMaterialID, FMatBatchNo, ").append('\n').append("    FSubProdQty, FAmtCoef, FQtyCoef, FType)").append('\n').append("Select ").append('\n').append("    newbosid('DFA50FD9') As FID, cost_obj.FCostObjectID, cost_obj.FProductID, cost_obj.FProdBatchNo, ").append('\n').append("    cost_cal_res.FSubCostItemID, bop_inv_coef.FCostObjectID As FSubCostObjID, ").append('\n').append("    bop_inv_coef.FProductID As FSubProductID, bop_inv_coef.FProdBatchNo As FSubProdBatchNo, ").append('\n').append("    bop_inv_coef.FCostItemID, bop_inv_coef.FMaterialID, bop_inv_coef.FMatBatchNo, ").append('\n').append("    (cost_cal_res.FQty - ISNULL(bal.FQty,0)) As FSubProdQty, ").append('\n').append("    to_decimal((cost_cal_res.FAmount - ISNULL(bal.FAmount,0)) * bop_inv_coef.FAmtCoef,24,12) As FAmtCoef, ").append('\n').append("    to_decimal((cost_cal_res.FQty - ISNULL(bal.FQty,0)) * bop_inv_coef.FQtyCoef,24,12) As FQtyCoef, ").append('\n').append("    22 As FType ").append('\n').append("FROM ").append(costCalTmpTblName).append(" cost_cal_res ").append('\n').append("LEFT JOIN ").append(balanceTmpTblName).append(" bal ").append('\n').append("    ON cost_cal_res.FCostObjectID = bal.FCostObjectID AND cost_cal_res.FSubCostItemID = bal.FSubCostItemID ").append('\n').append("    AND cost_cal_res.FSubProductID = bal.FSubProductID AND cost_cal_res.FSubProdBatchNo = bal.FSubProdBatchNo").append('\n').append("LEFT JOIN ").append(costObjTmpTblName).append(" cost_obj ").append('\n').append("    ON cost_obj.FCostObjectID = cost_cal_res.FCostObjectID ").append('\n').append("INNER JOIN ").append(this._calcParam.GetTBL_BopInvCoef()).append(" bop_inv_coef ").append('\n').append("    ON bop_inv_coef.FProductID = cost_cal_res.FSubProductID AND bop_inv_coef.FProdBatchNo = cost_cal_res.FSubProdBatchNo").append('\n').append("    AND bop_inv_coef.FCompanyID = '").append(this._calcParam.companyId).append("'").append('\n').append("    AND bop_inv_coef.FCalculatePeriodID = '").append(this._calcParam.periodId).append("'").append('\n');
            if (!this._calcParam.isRevertAllProduct) {
                sql.append("INNER JOIN T_BD_MaterialCost material_cost ").append('\n').append("    ON material_cost.FOrgUnit = bop_inv_coef.FCompanyID AND material_cost.FMaterialID = cost_obj.FProductID ").append('\n').append("    AND material_cost.FStatus = 1 AND material_cost.FIsParticipateReduct = 1 ").append('\n');
            }
            sql.append("WHERE (cost_cal_res.FAmount - ISNULL(bal.FAmount,0)) <> 0 AND (cost_cal_res.FQty - ISNULL(bal.FQty,0)) <> 0;").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sql.toString(), (String)";");
            sql.setLength(0);
        }
        catch (Throwable throwable) {
            NCMDbUtil.releaseTempTables((Context)this._calcParam.ctx, (String[])new String[]{costObjTmpTblName, costObjLotMapTempTbl, costCalTmpTblName, balanceTmpTblName});
            throw throwable;
        }
        NCMDbUtil.releaseTempTables((Context)this._calcParam.ctx, (String[])new String[]{costObjTmpTblName, costObjLotMapTempTbl, costCalTmpTblName, balanceTmpTblName});
    }

    @Override
    protected void MergeProdCoef(StringBuffer sb) throws EASBizException, BOSException {
        String finalTempTblBopWIPCoef = this._calcParam.getTempMergeTblBopWIPCoef();
        try {
            NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopWIPCoef(), (String)"FCostObjectID,FProductID,FProdBatchNo,FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo", (boolean)false, (boolean)false);
            sb.append("INSERT INTO ").append(finalTempTblBopWIPCoef).append("(FID,FCostObjectID,FProductID,FProdBatchNo,FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FSubProdQty,FAmtCoef,FQtyCoef,FSort,FType)").append('\n').append("SELECT newbosid('DFA50FD9')As FID,D.FCostObjectID,D.FProductID,D.FProdBatchNo,D.FSubCostItemID,D.FSubCostObjID,D.FSubProductID,D.FSubProdBatchNo, ").append('\n').append("       D.FCostItemID,D.FMaterialID,D.FMatBatchNo,SUM(D.FSubProdQty)As FSubProdQty,SUM(D.FAmtCoef)As FAmtCoef, SUM(D.FQtyCoef)As FQtyCoef, ").append('\n').append("       0 As FSort,1 As FType").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append(" D ").append('\n').append("WHERE D.FType<>1 ").append('\n').append("GROUP BY D.FCostObjectID,D.FProductID,D.FProdBatchNo,D.FSubCostItemID,D.FSubCostObjID,D.FSubProductID,D.FSubProdBatchNo, ").append('\n').append("       D.FCostItemID,D.FMaterialID,D.FMatBatchNo ").append('\n').append(";").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
            sb.setLength(0);
            NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)finalTempTblBopWIPCoef, (String)"FProductID,FProdBatchNo,FSubCostItemID,FSubProductID,FSubProdBatchNo", (boolean)false, (boolean)false);
        }
        finally {
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopWIPCoef());
            this._calcParam.setTempTblBopWipCoef(finalTempTblBopWIPCoef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void CalcProdCoef(StringBuffer sb) throws EASBizException, BOSException {
        String tempUpdateTable;
        String sumCostItemData;
        block6: {
            sumCostItemData = null;
            tempUpdateTable = null;
            try {
                sb.append("create table tempTbl (FProductID varchar(44),FProdBatchNo nvarchar(80),FSubCostItemID varchar(44),FSubProductID varchar(44),FSubProdBatchNo nvarchar(80)");
                sb.append(",FAmtCoef NUMERIC(24,12) DEFAULT 0,FQtyCoef NUMERIC(24,12) DEFAULT 0 )");
                sumCostItemData = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopWIPCoef(), (String)"FProductID,FProdBatchNo,FSubCostItemID , FSubProductID, FSubProdBatchNo", (boolean)false, (boolean)false);
                sb.setLength(0);
                sb.append("insert into ").append(sumCostItemData);
                sb.append(" select S.FProductID,S.FProdBatchNo,S.FSubCostItemID , S.FSubProductID, S.FSubProdBatchNo,SUM(isnull(S.FAmtCoef,0)) FAmtCoef,MAX(isnull(FSubProdQty,0)) FQtyCoef");
                sb.append(" from ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append(" s where S.FMaterialID is null ");
                sb.append(" group by  S.FProductID,S.FProdBatchNo,S.FSubCostItemID , S.FSubProductID, S.FSubProdBatchNo");
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)sumCostItemData, (String)"FProductID,FProdBatchNo,FSubCostItemID,FSubProductID,FSubProdBatchNo", (boolean)true, (boolean)false);
                IRowSet rsCount = NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)("select count(1) from " + this._calcParam.GetTempTBL_BopWIPCoef()));
                int rowCount = 0;
                try {
                    while (rsCount.next()) {
                        rowCount = rsCount.getInt(1);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (rowCount < 10000) {
                    sb.setLength(0);
                    sb.append("UPDATE ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append(" AS D SET (FAmtCoef,FQtyCoef) = ").append('\n');
                    sb.append("(select case when s.FAmtCoef <> 0 then to_decimal(d.FAmtCoef/s.FAmtCoef,24,12) else 0 end ,").append('\n');
                    sb.append(" case when s.FQtyCoef <> 0 then to_decimal(d.FQtyCoef/s.FQtyCoef,24,12) else 0 end ").append('\n');
                    sb.append(" from ").append(sumCostItemData).append(" s where S.FProductID=D.FProductID AND S.FProdBatchNo=D.FProdBatchNo");
                    sb.append(" AND S.FSubCostItemID=D.FSubCostItemID AND S.FSubProductID=D.FSubProductID AND S.FSubProdBatchNo=D.FSubProdBatchNo )");
                    NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
                    sb.setLength(0);
                    break block6;
                }
                sb.setLength(0);
                sb.append("create table tempTbl (fid varchar(44),FAmtCoef NUMERIC(24,12) DEFAULT 0,FQtyCoef NUMERIC(24,12) DEFAULT 0)");
                tempUpdateTable = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempUpdateTable, (String)"fid", (boolean)true, (boolean)false);
                sb.setLength(0);
                sb.append("insert into ").append(tempUpdateTable).append(" (fid,FAmtCoef,FQtyCoef) ");
                sb.append("SELECT D.FID,case when s.FAmtCoef <> 0 then to_decimal(d.FAmtCoef/s.FAmtCoef,24,12) else 0 end AS FAmtCoef,");
                sb.append(" case when s.FQtyCoef <> 0 then to_decimal(d.FQtyCoef/s.FQtyCoef,24,12) else 0 end AS FQtyCoef ");
                sb.append(" from ").append(sumCostItemData).append(" s INNER JOIN ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append(" D");
                sb.append(" ON S.FProductID=D.FProductID AND S.FProdBatchNo=D.FProdBatchNo");
                sb.append(" AND S.FSubCostItemID=D.FSubCostItemID AND S.FSubProductID=D.FSubProductID AND S.FSubProdBatchNo=D.FSubProdBatchNo ");
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
                sb.setLength(0);
                sb.append("UPDATE ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append(" D SET (FAmtCoef,FQtyCoef) = ").append('\n');
                sb.append(" (select s.FAmtCoef,s.FQtyCoef from ").append(tempUpdateTable).append(" s where s.fid = d.fid)");
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
                sb.setLength(0);
            }
            catch (Throwable throwable) {
                NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, tempUpdateTable);
                NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, sumCostItemData);
                throw throwable;
            }
        }
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)tempUpdateTable);
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)sumCostItemData);
    }

    @Override
    protected void CommitProdCoef(StringBuffer sb) throws EASBizException, BOSException {
        sb.append("INSERT INTO ").append(this._calcParam.GetTBL_BopWIPCoef()).append("(FID,FCompanyID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef) ").append('\n').append("SELECT FID,'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',FCostObjectID,FProductID,FProdBatchNo,FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append("\tFCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append('\n').append("ORDER BY FProductID,FProdBatchNo,FSubProductID,FSubProdBatchNo ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void InsertBoPInvPart(StringBuffer sb) throws EASBizException, BOSException {
        String tblProduct = null;
        String tblBal = null;
        try {
            sb.append("create table tbl (FProductId varchar(44),FProdBatchNo NVARCHAR(80))");
            tblProduct = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
            NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tblProduct, (String)"FPRODUCTID", (boolean)false, (boolean)false);
            sb.setLength(0);
            sb.append("insert into ").append(tblProduct).append(" (FProductId,FProdBatchNo) \n");
            sb.append("SELECT distinct COE.FRelatedID As FProductId,Isnull(CO.FBatchNumber,N' ') As FProdBatchNo \n");
            sb.append("FROM T_BD_CostObject CO LEFT JOIN T_BD_COstObjectEntry COE on COE.FParentId = CO.Fid \n");
            sb.append("WHERE CO.FIsForbiden = 0 AND CO.FCalculateMode=4 AND CO.FCompanyID = '").append(this._calcParam.companyId).append("'");
            NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append("create table tbl (FProductID varchar(44),FProdBatchNo NVARCHAR(80),FQty NUMERIC(21,8),FAmount NUMERIC(17,4))");
            tblBal = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
            NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tblBal, (String)"FProductId,FProdBatchNo", (boolean)false, (boolean)false);
            sb.setLength(0);
            sb.append("insert into ").append(tblBal).append(" (FProductID,FProdBatchNo,FQty,FAmount) \n");
            sb.append("SELECT bal.FMaterialID as FProductID, ISNULL(O.FProdBatchNo,N' ')As FProdBatchNo, \n");
            sb.append("SUM(bal.FPeriodBeginQty)As FQty,SUM(bal.FPeriodBeginBalance)As FAmount \n");
            sb.append("FROM T_IM_InventoryBalance bal  \n");
            sb.append("INNER JOIN T_BD_MaterialCompanyInfo mat ON mat.FCompanyID=bal.FCompanyOrgUnitID AND mat.FMaterialID = bal.FMaterialID AND mat.FStatus=1 AND mat.FCalculateType=2 \n");
            if (!this._calcParam.isRevertAllProduct) {
                sb.append("\tINNER JOIN T_BD_MaterialCost mcst ON mcst.FOrgUnit=bal.FCompanyOrgUnitID AND mcst.FMaterialID = bal.FMaterialID AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 \n");
            }
            sb.append("LEFT JOIN ").append(tblProduct).append(" O ON O.FProductId=bal.FMaterialID and bal.flot = O.FProdBatchNo \n");
            sb.append("WHERE bal.FYear=").append(this._calcParam.periodYear).append(" AND bal.FPeriod=").append(this._calcParam.periodNumber).append('\n');
            sb.append("AND bal.FCompanyOrgUnitID='").append(this._calcParam.companyId).append("' \n");
            sb.append("GROUP BY bal.FMaterialID, O.FProdBatchNo \n");
            sb.append("HAVING SUM(bal.FPeriodBeginQty) <>0 ");
            NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FProdQty,FAmtCoef,FQtyCoef,FType)").append('\n').append("SELECT newbosid('DFA50FD9'),").append('\n').append("\tS.FCostObjectID,S.FProductID,S.FProdBatchNo,S.FCostItemID,S.FMaterialID,S.FMatBatchNo, ").append('\n').append("   M.FQty As FProdQty,to_decimal(M.FAmount * S.FAmtCoef,24,12) AS FAmtCoef,to_decimal(M.FQty * S.FQtyCoef,24,12) AS FQtyCoef,11 As FType ").append('\n').append("FROM ").append(tblBal).append(" M ").append('\n').append("INNER JOIN ").append(this._calcParam.GetTBL_BopInvCoef()).append(" S ON S.FProductID=M.FProductID AND S.FProdBatchNo=M.FProdBatchNo ").append('\n').append("\tAND S.FCompanyID='").append(this._calcParam.companyId).append("' AND S.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("INNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ON CO.FCostObjectID=S.FCostObjectID").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
            sb.setLength(0);
        }
        catch (Throwable throwable) {
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, tblProduct);
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, tblBal);
            throw throwable;
        }
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)tblProduct);
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)tblBal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void InsertStockInPart(StringBuffer sb) throws EASBizException, BOSException {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            IRowSet rs = this.GetStockInData(false);
            NumberFormat fm = NumberFormat.getInstance();
            fm.setGroupingUsed(false);
            String lastCostObjectID = "";
            String lastProductId = "";
            String lastProdBatchNo = "";
            String lastCostItemID = "";
            BigDecimal dMatAmount = BigDecimal.valueOf(0L);
            BigDecimal dMatQty = BigDecimal.valueOf(0L);
            BigDecimal dMatAmount_ToSubtract = BigDecimal.valueOf(0L);
            BigDecimal dMatQty_ToSubtract = BigDecimal.valueOf(0L);
            StringBuffer sbLastInsertSql_CostItem = new StringBuffer();
            while (rs.next()) {
                if (lastCostObjectID.compareTo("") != 0 && (lastCostObjectID.compareTo(rs.getString("FCostobjectId")) != 0 || lastProductId.compareTo(rs.getString("FProductId")) != 0 || lastProdBatchNo.compareTo(rs.getString("FProdBatchNo")) != 0 || lastCostItemID.compareTo(rs.getString("FCostItemID")) != 0)) {
                    sb.append(sbLastInsertSql_CostItem.toString());
                    dMatAmount_ToSubtract = BigDecimal.valueOf(0L);
                    dMatQty_ToSubtract = BigDecimal.valueOf(0L);
                }
                lastCostObjectID = rs.getString("FCostobjectId");
                lastProductId = rs.getString("FProductId");
                lastProdBatchNo = rs.getString("FProdBatchNo");
                lastCostItemID = rs.getString("FCostItemID");
                if (rs.getString("FMaterialID") != null && rs.getString("FMaterialID").length() > 0) {
                    String matQty;
                    String matAmount;
                    dMatAmount = BigDecimal.valueOf(0L);
                    if (rs.getBigDecimal("FMatAmount") != null) {
                        dMatAmount = rs.getBigDecimal("FMatAmount");
                    }
                    dMatQty = BigDecimal.valueOf(0L);
                    if (rs.getBigDecimal("FMatQty") != null) {
                        dMatQty = rs.getBigDecimal("FMatQty");
                    }
                    if (rs.getInt("FHasCoef") == 1) {
                        matAmount = fm.format(dMatAmount);
                        matQty = fm.format(dMatQty);
                        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,FType)").append('\n').append("SELECT newbosid('DFA50FD9'),W.FCostObjectID,W.FProductID,W.FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("    W.FAmtCoef * ").append(matAmount).append(" As FAmtCoef, W.FQtyCoef * ").append(matQty).append(" As FQtyCoef,22 ").append('\n').append("FROM ").append(this._calcParam.GetTBL_BopWIPCoef()).append(" W ").append('\n').append("WHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\tAND W.FProductID = '").append(rs.getString("FProductID")).append("' AND W.FProdBatchNo='").append(rs.getString("FProdBatchNo")).append("'").append('\n').append("\tAND W.FSubCostItemID = '").append(rs.getString("FCostItemID")).append("' AND W.FSubProductID='").append(rs.getString("FMaterialID")).append("'").append('\n').append("\tAND W.FSubProdBatchNo = '").append(rs.getString("FMatBatchNo")).append("'").append('\n').append("; ").append('\n');
                        dMatAmount_ToSubtract = dMatAmount_ToSubtract.add(dMatAmount);
                        dMatQty_ToSubtract = dMatQty_ToSubtract.add(dMatQty);
                        dMatAmount = BigDecimal.valueOf(0L);
                        dMatQty = BigDecimal.valueOf(0L);
                    } else if (rs.getInt("FHasCoef2") == 1 && rs.getInt("FHasCoef") == 0) {
                        matAmount = fm.format(dMatAmount);
                        matQty = fm.format(dMatQty);
                        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,FType)").append('\n').append("SELECT newbosid('DFA50FD9'),'" + rs.getString("FCostObjectID") + "','" + rs.getString("FProductID") + "','" + rs.getString("FProdBatchNo") + "',W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("    W.FAmtCoef * ").append(matAmount).append(" As FAmtCoef, W.FQtyCoef * ").append(matQty).append(" As FQtyCoef,22 ").append('\n').append("FROM ").append(this._calcParam.GetTBL_BopInvCoef()).append(" W ").append('\n').append("WHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("\tAND W.FProductID = '").append(rs.getString("FMaterialID")).append("' AND W.FProdBatchNo='").append(rs.getString("FMatBatchNo")).append("'").append('\n').append("; ").append('\n');
                        dMatAmount_ToSubtract = dMatAmount_ToSubtract.add(dMatAmount);
                        dMatQty_ToSubtract = dMatQty_ToSubtract.add(dMatQty);
                        dMatAmount = BigDecimal.valueOf(0L);
                        dMatQty = BigDecimal.valueOf(0L);
                    }
                    if (dMatAmount.compareTo(BigDecimal.valueOf(0L)) != 0 || dMatQty.compareTo(BigDecimal.valueOf(0L)) != 0) {
                        matAmount = fm.format(dMatAmount);
                        matQty = fm.format(dMatQty);
                        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,FType)").append('\n').append("Values(newbosid('DFA50FD9'),'").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductId")).append("','").append(rs.getString("FProdBatchNo")).append("','").append(rs.getString("FCostItemID")).append("','").append(rs.getString("FMaterialID")).append("','").append(rs.getString("FMatBatchNo")).append("',").append(matAmount).append(",").append(matQty).append(",22").append(");").append('\n');
                    }
                }
                fm.setMaximumFractionDigits(12);
                String prodQty = fm.format(BigDecimal.valueOf(0L));
                if (rs.getBigDecimal("FTotalFinishedQty") != null) {
                    prodQty = fm.format(rs.getBigDecimal("FTotalFinishedQty"));
                }
                BigDecimal dCostItemAmount = BigDecimal.valueOf(0L);
                if (rs.getBigDecimal("FCostItemAmount") != null) {
                    dCostItemAmount = rs.getBigDecimal("FCostItemAmount");
                }
                dCostItemAmount = dCostItemAmount.subtract(dMatAmount_ToSubtract);
                BigDecimal dCostItemQty = BigDecimal.valueOf(0L);
                if (rs.getBigDecimal("FCostItemQty") != null) {
                    dCostItemQty = rs.getBigDecimal("FCostItemQty");
                }
                dCostItemQty = dCostItemQty.subtract(dMatQty_ToSubtract);
                String costItemAmount = fm.format(dCostItemAmount);
                String costItemQty = fm.format(dCostItemQty);
                sbLastInsertSql_CostItem.delete(0, sbLastInsertSql_CostItem.length());
                sbLastInsertSql_CostItem.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FProdQty,FAmtCoef,FQtyCoef,FType)").append('\n').append("Values(newbosid('DFA50FD9'),'").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductId")).append("','").append(rs.getString("FProdBatchNo")).append("','").append(rs.getString("FCostItemID")).append("',").append(prodQty).append(",").append(costItemAmount).append(",").append(costItemQty).append(",22").append(");").append('\n');
            }
            if (sbLastInsertSql_CostItem.length() > 0) {
                sb.append(sbLastInsertSql_CostItem.toString());
            }
            int CURR_MULTI_EXECUTE_SIZE = 500;
            if (StringUtil.isEmpty((String)sb.toString())) {
                return;
            }
            String[] sqls = sb.toString().split(";");
            int sqlLength = sqls.length;
            int countDownSize = 0;
            countDownSize = sqlLength % CURR_MULTI_EXECUTE_SIZE == 0 ? sqlLength / CURR_MULTI_EXECUTE_SIZE : sqlLength / CURR_MULTI_EXECUTE_SIZE + 1;
            this.countDown = new CountDownLatch(countDownSize);
            CtrlExecNum ctrlExecNum = new CtrlExecNum();
            sb.setLength(0);
            int execCount = 0;
            for (int i = 0; i < sqlLength; ++i) {
                sb.append(sqls[i]);
                if (++execCount != CURR_MULTI_EXECUTE_SIZE) continue;
                ctrlExecNum.add();
                MultiExecuteSql multiExecuteSql = new MultiExecuteSql(this._calcParam.ctx, sb.toString(), ctrlExecNum);
                executor.execute(multiExecuteSql);
                sb.setLength(0);
                execCount = 0;
            }
            if (sb.length() > 0) {
                try {
                    NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
                    sb.setLength(0);
                }
                finally {
                    this.countDown.countDown();
                }
            }
            this.countDown.await();
            if (this.multiExcetion != null) {
                throw this.multiExcetion;
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    protected void InsertStockInPart_Oracle(StringBuffer sb) throws EASBizException, BOSException {
        StringBuffer sbStockInDataSelectSql = new StringBuffer();
        sb.append("/*dialect*/");
        sbStockInDataSelectSql = this.GetStockInDataSelectSql(false);
        String SelDefine = null;
        try {
            SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)this._calcParam.CurrentDataBaseType);
            if (SelDefine.indexOf("(+)") != -1) {
                SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)7);
            }
        }
        catch (SqlTranslateException e) {
            try {
                SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)8);
            }
            catch (SqlTranslateException e2) {
                e2.printStackTrace();
                throw new BOSException(e2.getMessage());
            }
        }
        sb.append(" declare CURSOR cur IS ").append(SelDefine).append(";").append('\n').append("\tcurrInfo cur%rowtype; ").append('\n').append("\tlastCostObjectID VARCHAR2 (44) := ' '; ").append('\n').append("\tlastProductId VARCHAR2 (44) := ' '; ").append('\n').append("\tlastProdBatchNo VARCHAR2 (80) := ' '; ").append('\n').append("\tlastCostItemID VARCHAR2 (44) := ' '; ").append('\n').append("\tdCostItemAmount NUMBER(28,12) := 0;").append('\n').append("\tdCostItemQty NUMBER(28,12) := 0;").append('\n').append("\tdMatAmount NUMBER(28,12) := 0; ").append('\n').append("\tdMatQty NUMBER(28,12) := 0; ").append('\n').append("\tdMatAmount_ToSubtract NUMBER(28,12) := 0; ").append('\n').append("\tdMatQty_ToSubtract NUMBER(28,12) := 0;").append('\n').append("\tdTotalFinishedQty NUMBER(28,12) := 0;").append('\n').append("\tsbLastInsertSql_CostItem VARCHAR2 (1000) := ' '; ").append('\n').append("\tisLeaf NUMBER := 0; ").append('\n').append(" BEGIN ").append('\n').append("\topen cur; ").append('\n').append("\tloop ").append('\n').append("\t   fetch cur into currInfo; ").append('\n').append("\t   exit when cur%notfound; ").append('\n').append("\t\t ").append('\n').append("\t\t --A.2,\u5b9e\u9645\uff0d\u63d2\u5165\u6210\u672c\u9879\u76ee\u6c47\u603b\u4fe1\u606f(\u6210\u672c\u9879\u76ee\u6700\u540e\u4e00\u6761\u65f6\u6c47\u603b)").append('\n').append("\t\t if ((lastCostObjectID <> currInfo.FCostobjectId) OR (lastProductId <> currInfo.FProductId)OR (lastProdBatchNo <> NVL(currInfo.FProdBatchNo,' '))OR (lastCostItemID <> currInfo.FCostItemID))then ").append('\n').append("\t\t \tif (sbLastInsertSql_CostItem <> ' ')then").append('\n').append("\t\t \t\texecute immediate sbLastInsertSql_CostItem;").append('\n').append("\t\t \t\tdMatAmount_ToSubtract := 0;").append('\n').append("\t\t \t\tdMatQty_ToSubtract := 0;").append('\n').append("\t\t \tend if;").append('\n').append("\t\t end if; --end of A.2,\u5b9e\u9645\uff0d\u63d2\u5165\u6210\u672c\u9879\u76ee\u6c47\u603b\u4fe1\u606f(\u6210\u672c\u9879\u76ee\u6700\u540e\u4e00\u6761\u65f6\u6c47\u603b)").append('\n').append("\t\t lastCostObjectID := currInfo.FCostobjectId;").append('\n').append("\t\t lastProductId := currInfo.FProductId;").append('\n').append("\t\t lastProdBatchNo := NVL(currInfo.FProdBatchNo,' ');").append('\n').append("\t\t lastCostItemID := currInfo.FCostItemID;").append('\n').append("\t\t --B,\u63d2\u5165\u672c\u5c42\u6750\u6599\u660e\u7ec6(\u5982\u679c\u6709\u65f6)").append('\n').append("\t\t if (currInfo.FMaterialID IS NOT NULL)then").append('\n').append("\t\t \tdMatAmount := currInfo.FMatAmount ;").append('\n').append("\t\t \tdMatQty := currInfo.FMatQty ;").append('\n').append("\t\t \t--\u81ea\u5236\u5b50\u9879\u65f6\u5c55\u5f00\u4e0b\u5c42\u7ed3\u6784").append('\n').append("\t\t \tif (currInfo.FHasCoef = 1)then").append('\n').append("\t\t \t\tINSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("\t\t \t\t(FID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,FType)").append('\n').append("\t\t \t\tSELECT newbosid('DFA50FD9'),W.FCostObjectID,W.FProductID,W.FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("\t\t \t\t    W.FAmtCoef * dMatAmount As FAmtCoef, W.FQtyCoef * dMatQty As FQtyCoef,22 ").append('\n').append("\t\t \t\tFROM ").append(this._calcParam.GetTBL_BopWIPCoef()).append(" W ").append('\n').append("\t\t \t\tWHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\t\t \t\t\tAND W.FProductID = currInfo.FProductID AND W.FProdBatchNo=NVL(currInfo.FProdBatchNo,' ')").append('\n').append("\t\t \t\t\tAND W.FSubCostItemID = currInfo.FCostItemID AND W.FSubProductID=currInfo.FMaterialID").append('\n').append("\t\t \t\t\tAND W.FSubProdBatchNo = NVL(currInfo.FMatBatchNo, ' '); ").append('\n').append("\t\t \t\tdMatAmount_ToSubtract := (dMatAmount_ToSubtract + dMatAmount);").append('\n').append("\t\t \t\tdMatQty_ToSubtract := (dMatQty_ToSubtract + dMatQty);").append('\n').append("\t\t \t\tdMatAmount := 0;").append('\n').append("\t\t \t\tdMatQty := 0;").append('\n').append("\t\t \telsif (currInfo.FHasCoef2 = 1 and currInfo.FHasCoef = 0)then").append('\n').append("\t\t \t\tINSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("\t\t \t\t(FID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,FType)").append('\n').append("\t\t \t\tSELECT newbosid('DFA50FD9'),currInfo.FCostObjectID,currInfo.FProductID,currInfo.FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("\t\t \t\t    W.FAmtCoef * dMatAmount As FAmtCoef, W.FQtyCoef * dMatQty As FQtyCoef,22 ").append('\n').append("\t\t \t\tFROM ").append(this._calcParam.GetTBL_BopInvCoef()).append(" W ").append('\n').append("\t\t \t\tWHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("\t\t \t\t\tAND W.FProductID = currInfo.FMaterialID AND NVL(W.FProdBatchNo,'null')=NVL(currInfo.FMatBatchNo,'null');").append('\n').append("\t\t \t\tdMatAmount_ToSubtract := (dMatAmount_ToSubtract + dMatAmount);").append('\n').append("\t\t \t\tdMatQty_ToSubtract := (dMatQty_ToSubtract + dMatQty);").append('\n').append("\t\t \t\tdMatAmount := 0;").append('\n').append("\t\t \t\tdMatQty := 0;").append('\n').append("\t\t \tend if; --end of \u81ea\u5236\u5b50\u9879\u65f6\u5c55\u5f00\u4e0b\u5c42\u7ed3\u6784").append('\n').append("\t\t \t--02,\u672c\u5c42\u6750\u6599\u660e\u7ec6").append('\n').append("\t\t \tif (dMatAmount <> 0 Or dMatQty <> 0)then").append('\n').append("\t\t \t\tINSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("\t\t \t\t(FID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,FType)").append('\n').append("\t\t \t\tValues(newbosid('DFA50FD9'),currInfo.FCostObjectID,currInfo.FProductId,NVL(currInfo.FProdBatchNo,' '),currInfo.FCostItemID,currInfo.FMaterialID,NVL(currInfo.FMatBatchNo, ' '),").append("\t\t \t\t    currInfo.FMatAmount, currInfo.FMatQty,22); ").append('\n').append("\t\t \tend if; --end of 02,\u672c\u5c42\u6750\u6599\u660e\u7ec6").append('\n').append("\t\t end if; --end of B,\u63d2\u5165\u672c\u5c42\u6750\u6599\u660e\u7ec6(\u5982\u679c\u6709\u65f6)").append('\n').append("\t\t --A.2,\u5b9e\u9645\uff0d\u63d2\u5165\u6210\u672c\u9879\u76ee\u6c47\u603b\u4fe1\u606f(\u6210\u672c\u9879\u76ee\u6700\u540e\u4e00\u6761\u65f6\u6c47\u603b)").append('\n').append("\t\t dCostItemAmount := (currInfo.FCostItemAmount - dMatAmount_ToSubtract);").append('\n').append("\t\t dCostItemQty := (currInfo.FCostItemQty - dMatQty_ToSubtract);").append('\n').append("\t\t if currInfo.FTotalFinishedQty is null then ").append('\n').append("\t\t     dTotalFinishedQty := 0;").append('\n').append("\t\t else ").append('\n').append("\t\t     dTotalFinishedQty := (currInfo.FTotalFinishedQty);").append('\n').append("\t\t end if ;").append('\n').append("\t\t ").append('\n').append("\t\t sbLastInsertSql_CostItem := 'INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("\t\t \t(FID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FProdQty,FAmtCoef,FQtyCoef,FType)").append("\t\t \tValues(newbosid(''' || 'DFA50FD9' || '''),''' || currInfo.FCostObjectID || ''',''' || currInfo.FProductId || ''',''' || NVL(currInfo.FProdBatchNo,' ') || ''',''' || currInfo.FCostItemID || ''','").append("\t\t\t|| dTotalFinishedQty || ',' || dCostItemAmount || ',' || dCostItemQty || ',22)';").append('\n').append("\tend loop; ").append('\n').append("\tif (sbLastInsertSql_CostItem <> ' ')then").append('\n').append("\t\texecute immediate sbLastInsertSql_CostItem;").append('\n').append("\tend if;").append('\n').append("\tclose cur; ").append('\n').append(" END;").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    @Override
    protected void MergeInventoryCoef(StringBuffer sb) throws EASBizException, BOSException {
        String finalTempTblBopInvCoef = this._calcParam.getTempMergeTblBopInvCoef();
        try {
            NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopInvCoef(), (String)"FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo", (boolean)false, (boolean)false);
            sb.append("INSERT INTO ").append(finalTempTblBopInvCoef).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FProdQty,FAmtCoef,FQtyCoef,FType)").append('\n').append("SELECT newbosid('DFA50FD9')As FID,D.FCostObjectID,D.FProductID,D.FProdBatchNo, ").append('\n').append("       D.FCostItemID,D.FMaterialID,D.FMatBatchNo,SUM(D.FProdQty)As FProdQty,SUM(D.FAmtCoef)As FAmtCoef, SUM(D.FQtyCoef)As FQtyCoef, ").append('\n').append("       1 As FType").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_BopInvCoef()).append(" D ").append('\n').append("WHERE D.FType<>1 ").append('\n').append("GROUP BY D.FCostObjectID,D.FProductID,D.FProdBatchNo, ").append('\n').append("       D.FCostItemID,D.FMaterialID,D.FMatBatchNo ").append('\n').append(";").append('\n');
            NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
            sb.setLength(0);
            NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)finalTempTblBopInvCoef, (String)"FProductID,FProdBatchNo", (boolean)false, (boolean)false);
        }
        finally {
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopInvCoef());
            this._calcParam.setTempTblBopInvCoef(finalTempTblBopInvCoef);
        }
    }

    @Override
    protected void CalcInventoryCoef(StringBuffer sb) throws EASBizException, BOSException {
        String sumCostItemData = null;
        try {
            sb.append("create table tempTbl (FProductID varchar(44),FProdBatchNo nvarchar(80)");
            sb.append(",FAmtCoef NUMERIC(24,12) DEFAULT 0,FQtyCoef NUMERIC(24,12) DEFAULT 0 )");
            sumCostItemData = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
            NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopInvCoef(), (String)"FProductID,FProdBatchNo", (boolean)false, (boolean)false);
            sb.setLength(0);
            sb.append("insert into ").append(sumCostItemData);
            sb.append(" select S.FProductID,S.FProdBatchNo,SUM(isnull(S.FAmtCoef,0)) FAmtCoef,MAX(isnull(FProdQty,0)) FQtyCoef");
            sb.append(" from ").append(this._calcParam.GetTempTBL_BopInvCoef()).append(" s where S.FMaterialID is null ");
            sb.append(" group by  S.FProductID,S.FProdBatchNo");
            NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
            NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)sumCostItemData, (String)"FProductID,FProdBatchNo", (boolean)false, (boolean)false);
            sb.setLength(0);
            sb.append("UPDATE ").append(this._calcParam.GetTempTBL_BopInvCoef()).append(" AS D SET (FAmtCoef,FQtyCoef) = ").append('\n');
            sb.append("(select case when s.FAmtCoef <> 0 then to_decimal(d.FAmtCoef/s.FAmtCoef,24,12) else 0 end ,").append('\n');
            sb.append(" case when s.FQtyCoef <> 0 then to_decimal(d.FQtyCoef/s.FQtyCoef,24,12) else 0 end ").append('\n');
            sb.append(" from ").append(sumCostItemData).append(" s where S.FProductID=D.FProductID AND S.FProdBatchNo=D.FProdBatchNo)");
            NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
            sb.setLength(0);
        }
        catch (Throwable throwable) {
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, sumCostItemData);
            throw throwable;
        }
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)sumCostItemData);
    }

    @Override
    protected void CommitInventoryCoef(StringBuffer sb) throws EASBizException, BOSException {
        sb.append("INSERT INTO ").append(this._calcParam.GetTBL_BopInvCoef()).append("(FID,FCompanyID,FCalculatePeriodID,FCostObjectID,FProductID,").append('\n').append(" FProdBatchNo,FCostItemID,FMaterialID, FMatBatchNo,FAmtCoef,FQtyCoef)").append('\n').append("SELECT FID,'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append("\tFCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_BopInvCoef()).append('\n').append("ORDER BY FProductID,FProdBatchNo ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
    }

    @Override
    protected IRowSet GetStockInData(boolean byCostCenter) throws EASBizException, BOSException {
        return NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)this.GetStockInDataSelectSql(byCostCenter).toString());
    }

    @Override
    protected StringBuffer GetStockInDataSelectSql(boolean byCostCenter) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        String tblCostCalResult = this._calcParam.GetTBL_CostCalResult();
        String tblCostCalMatDetailResult = this._calcParam.GetTBL_CostCalMatDetailResult();
        String tblCostCostCalPrdDetailResult = this._calcParam.GetTBL_CostCalPrdDetailResult();
        String sCostCenter_CP = "";
        String sCostCenter_CP_G = "";
        String sCostCenter_CT_C = "";
        String sCostCenter_PP = "";
        String sCostCenter_PP_G = "";
        String sCostCenter_PP_C = "";
        String sCostCenter_CCMat = "";
        String sCostCenter_CCMat_G = "";
        String sCostCenter_M_C = "";
        String sCostCenter_CI = "";
        String sCostCenter_CI_G = "";
        String sCostCenter_R_C = "";
        String sCostCenter_C = "";
        if (byCostCenter) {
            sCostCenter_CP = " CP.FCostCenterID,";
            sCostCenter_CP_G = " CP.FCostCenterID,";
            sCostCenter_CT_C = " CT.FCostCenterID=C.FCostCenterID AND ";
            sCostCenter_PP = " P.FCostCenterID,";
            sCostCenter_PP_G = " P.FCostCenterID,";
            sCostCenter_PP_C = " PP.FCostCenterID=C.FCostCenterID AND ";
            sCostCenter_CCMat = " CCMat.FCostCenterID,";
            sCostCenter_CCMat_G = " CCMat.FCostCenterID,";
            sCostCenter_M_C = " M.FCostCenterID=C.FCostCenterID AND ";
            sCostCenter_CI = " CI.FCostCenterID,";
            sCostCenter_CI_G = " CI.FCostCenterID,";
            sCostCenter_R_C = " R.FCostCenterID=C.FCostCenterID AND ";
            sCostCenter_C = " C.FCostCenterID, ";
        } else {
            sCostCenter_CP = " ' ' As FCostCenterID,";
            sCostCenter_CP_G = "";
            sCostCenter_CT_C = " CT.FCostCenterID=C.FCostCenterID AND ";
            sCostCenter_PP = " ' ' As FCostCenterID,";
            sCostCenter_PP_G = " ";
            sCostCenter_PP_C = " PP.FCostCenterID=C.FCostCenterID AND ";
            sCostCenter_CCMat = " ' ' As FCostCenterID,";
            sCostCenter_CCMat_G = "";
            sCostCenter_M_C = " M.FCostCenterID=C.FCostCenterID AND ";
            sCostCenter_CI = " ' ' As FCostCenterID,";
            sCostCenter_CI_G = "";
            sCostCenter_R_C = " R.FCostCenterID=C.FCostCenterID AND ";
            sCostCenter_C = " C.FCostCenterID, ";
        }
        sb.append("Select ").append(sCostCenter_C).append(" C.FCostObjectID,C.FProductId,C.FProdBatchNo,C.FCostItemID,PP.FTotalFinishedQty,CT.FTotalFinishedAmount,").append('\n').append("\tC.FCostItemQty*Isnull(R.FRate,1) As FCostItemQty,Isnull(C.FCostItemAmount,0) FCostItemAmount,").append('\n').append("\tM.FMaterialID,M.FMatBatchNo,").append('\n').append("\tM.FQty*Isnull(R.FRate,1) As FMatQty,Round(M.FAmount*Isnull(R.FRate,1),CY.FPrecision) As FMatAmount,Isnull(F.FHasCoef,0)As FHasCoef,Isnull(F2.FHasCoef2,0)As FHasCoef2 ").append('\n').append("").append('\n').append("FROM (").append('\n').append("\tSELECT ").append(sCostCenter_CP).append(" CP.FCompanyID as FCompanyID, CP.FCostObjectID,CP.FProductID,Isnull(CP.FLot,' ') As FProdBatchNo,CP.FCostItemID, ").append('\n').append("\t\tSUM(CP.FFinishedQty)As FCostItemQty,SUM(CP.FFinishedAmount)As FCostItemAmount ").append('\n').append("\tFROM ").append(tblCostCostCalPrdDetailResult).append(" CP ").append('\n').append("\tINNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ON CO.FCostObjectID=CP.FCostObjectID").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append("\tINNER JOIN T_BD_MaterialCost mcst ON mcst.FOrgUnit=CP.FCompanyID AND mcst.FMaterialID = CP.FProductID AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("\tWHERE CP.FCompanyID='").append(this._calcParam.companyId).append("' AND CP.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\tGROUP BY ").append(sCostCenter_CP_G).append(" CP.FCompanyID,CP.FCostObjectID,CP.FProductID,CP.FLot,CP.FCostItemID ").append('\n').append("\tHAVING SUM(CP.FFinishedQty)<>0 OR SUM(CP.FFinishedAmount)<>0 ").append('\n').append(")C ").append('\n').append("LEFT JOIN (").append('\n').append("\tSELECT ").append(sCostCenter_CP).append(" CP.FCostObjectID,CP.FProductID,Isnull(CP.FLot,' ') As FProdBatchNo,").append('\n').append("\t\tSUM(CP.FFinishedAmount)As FTotalFinishedAmount ").append('\n').append("\tFROM ").append(tblCostCostCalPrdDetailResult).append(" CP ").append('\n').append("\tINNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ON CO.FCostObjectID=CP.FCostObjectID").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append("\tINNER JOIN T_BD_MaterialCost mcst ON mcst.FOrgUnit=CP.FCompanyID AND mcst.FMaterialID = CP.FProductID AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("\tWHERE CP.FCompanyID='").append(this._calcParam.companyId).append("' AND CP.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\tGROUP BY ").append(sCostCenter_CP_G).append(" CP.FCostObjectID,CP.FProductID,CP.FLot ").append('\n').append(")CT ON ").append(sCostCenter_CT_C).append(" CT.FCostObjectID=C.FCostObjectID AND CT.FProductID=C.FProductID AND CT.FProdBatchNo=C.FProdBatchNo ").append('\n').append("LEFT JOIN (").append('\n').append("\tSELECT ").append(sCostCenter_PP).append(" P.FCostObjectID,P.FProductID,Isnull(P.FLot,N' ') As FProdBatchNo,SUM(P.FFinishedQty)As FTotalFinishedQty ").append('\n').append("\tFROM ").append(this._calcParam.GetTBL_DataByProduct()).append(" P ").append('\n').append("\tINNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ON CO.FCostObjectID=P.FCostObjectID").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append("\tINNER JOIN T_BD_MaterialCost mcst ON mcst.FOrgUnit=P.FCompanyID AND mcst.FMaterialID = P.FProductID AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("\tWHERE P.FCompanyID='").append(this._calcParam.companyId).append("' AND P.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\tGROUP BY ").append(sCostCenter_PP_G).append(" P.FCostObjectID,P.FProductID,P.FLot ").append('\n').append(")PP ON ").append(sCostCenter_PP_C).append(" PP.FCostObjectID=C.FCostObjectID AND PP.FProductID=C.FProductID AND PP.FProdBatchNo=C.FProdBatchNo ").append('\n').append("LEFT JOIN (").append('\n').append("\tSELECT ").append(sCostCenter_CCMat).append(" CCMat.FCostObjectID,CCMat.FCostItemID,CCMat.FMaterialID,ISNULL(O.FCostObjBatchNo,N' ') As FMatBatchNo, ").append('\n').append("\t\tSUM(CCMat.FFinishedQty)As FQty,SUM(CCMat.FFinishedAmount)As FAmount").append('\n').append("\tFROM ").append(tblCostCalMatDetailResult).append(" CCMat ").append('\n').append("\tINNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ON CO.FCostObjectID=CCMat.FCostObjectID").append('\n').append("\tINNER JOIN t_NCM_CostItem CI ON CI.FID=CCMat.FCostItemID AND CI.FItemType= '1' ").append('\n').append("\tLEFT JOIN (").append('\n').append("\t\tSELECT distinct COE.FRelatedID As FProductId,Isnull(CO.FBatchNumber,N' ') As FProdBatchNo ,Isnull(CO.FBatchNumber,N' ') As FCostObjBatchNo").append('\n').append("\t\tFROM T_BD_CostObject CO ").append('\n').append("\t\tLEFT JOIN T_BD_COstObjectEntry COE on COE.FParentId = CO.Fid ").append('\n').append("\t\tWHERE CO.FIsForbiden = 0 AND CO.FCalculateMode=4 AND CO.FCompanyID = '").append(this._calcParam.companyId).append("' ").append('\n').append("\t\tUNION ").append('\n').append("\t\tSELECT FMaterialID As FProductId,FLot As FProdBatchNo,FCostObjBatchNo ").append('\n').append("\t\tFROM ").append(this._calcParam.GetTBL_LotMapping()).append("  ").append('\n').append("\t)O ON O.FProductId=CCMat.FMaterialID AND O.FProdBatchNo=CCMat.FLot").append('\n').append("\tWHERE CCMat.FCompanyID='").append(this._calcParam.companyId).append("' AND CCMat.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\tGROUP BY ").append(sCostCenter_CCMat_G).append(" CCMat.FCostObjectID,CCMat.FCostItemID,CCMat.FMaterialID,O.FProdBatchNo,O.FCostObjBatchNo ").append('\n').append(")M ON ").append(sCostCenter_M_C).append(" M.FCostObjectID=C.FCostObjectID AND M.FCostItemID=C.FCostItemID").append('\n').append("LEFT JOIN ( ").append('\n').append("    SELECT ").append(sCostCenter_CI).append(" CI.FCostObjectID,CI.FProductID,isnull(CI.FLot,' ') As FProdBatchNo,CI.FCostItemID, ").append('\n').append("        SUM(CI.FFinishedAmount)/SUM(CF.FFinishedAmount)As FRate ").append('\n').append("    FROM ").append(tblCostCostCalPrdDetailResult).append(" CI ").append('\n').append("    INNER JOIN T_BD_CostObject O ON O.FID=CI.FCostObjectID AND O.FCalculateMode=3 AND O.FIsForbiden = 0 ").append('\n').append("    INNER JOIN ").append(tblCostCalResult).append(" CF ON CF.FCompanyID=CI.FCompanyID AND CF.FCalculatePeriodID=CI.FCalculatePeriodID ").append('\n').append("        AND CF.FCostCenterID=CI.FCostCenterID AND CF.FCostObjectID=CI.FCostObjectID AND CF.FCostItemID=CI.FCostItemID ").append('\n').append("    WHERE CI.FCompanyID='").append(this._calcParam.companyId).append("' AND CI.FCalculatePeriodID='").append(this._calcParam.periodId).append("' ").append('\n').append("    GROUP BY ").append(sCostCenter_CI_G).append(" CI.FCostObjectID,CI.FProductID,CI.FLot,CI.FCostItemID ").append('\n').append("    HAVING SUM(CF.FFinishedAmount)<>0 ").append('\n').append(")R ON ").append(sCostCenter_R_C).append(" R.FProductID=C.FProductID AND R.FProdBatchNo=isnull(C.FProdBatchNo,' ') AND R.FCostItemID=M.FCostItemID ").append('\n').append("INNER JOIN t_NCM_CostItem CI ON CI.FID=C.FCostItemID").append('\n').append("LEFT JOIN t_BD_Material IC ON IC.FID=M.FMaterialID").append('\n').append("LEFT JOIN (").append('\n').append("\tSELECT DISTINCT W.FCostObjectID,W.FProductID,isnull(W.FProdBatchNo,' ') FProdBatchNo,W.FSubCostItemID,W.FSubProductID,isnull(W.FSubProdBatchNo,' ') FSubProdBatchNo,1 As FHasCoef ").append('\n').append("\tFROM ").append(this._calcParam.GetTBL_BopWIPCoef()).append(" W ").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append("\tINNER JOIN T_BD_MaterialCost mcst ON mcst.FOrgUnit=W.FCompanyID AND mcst.FMaterialID = W.FProductId AND mcst.FStatus=1 AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("\tWHERE FCompanyID = '").append(this._calcParam.companyId).append("' AND FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append(")F ON F.FCostObjectID=C.FCostObjectID AND F.FProductID=C.FProductID AND F.FProdBatchNo=C.FProdBatchNo AND C.FCOSTITEMID = F.FSUBCOSTITEMID AND F.FSubProductID=M.FMaterialID AND F.FSubProdBatchNo=M.FMatBatchNo ").append('\n').append("LEFT JOIN (").append('\n').append("\tSELECT DISTINCT W.FProductID,W.FProdBatchNo,1 As FHasCoef2 ").append('\n').append("\tFROM ").append(this._calcParam.GetTBL_BopInvCoef()).append(" W ").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append("\tINNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON mcst.FMaterialID = W.FProductId AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("\tWHERE FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append(")F2 ON F2.FProductID=M.FMaterialID AND isnull(F2.FProdBatchNo,' ')= isnull(M.FMatBatchNo,' ') ").append('\n').append("LEFT JOIN T_ORG_Company CMP ON CMP.FID=C.FCompanyID ").append('\n').append("LEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append("WHERE PP.FTotalFinishedQty is not null ").append('\n').append("ORDER BY ").append(sCostCenter_C).append(" C.FCostObjectID,C.FProductID,C.FProdBatchNo,C.FCostItemID,CI.FNumber,IC.FNumber ").append('\n').append(";").append('\n');
        return sb;
    }

    private String getCostObjTemp() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table temp1 (").append('\n').append("    FCostObjectId varchar(44),").append('\n').append("    FProductId varchar(44),").append('\n').append("    FProdBatchNo nvarchar(80)").append('\n').append(")");
        String tempTableName = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("insert into ").append(tempTableName).append('\n').append("(FCostObjectId, FProductId, FProdBatchNo)").append('\n').append("SELECT distinct CO.FID As FCostObjectID, COE.FRelatedID As FProductId, Isnull(CO.FBatchNumber,N' ') As FProdBatchNo ").append('\n').append("FROM T_BD_CostObject CO ").append('\n').append("LEFT JOIN T_BD_CostObjectEntry COE on COE.FParentId = CO.Fid ").append('\n').append("WHERE CO.FIsForbiden = 0 AND COE.FIsByProduct = 0 AND CO.FCompanyID = '").append(this._calcParam.companyId).append("';").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sql.toString(), (String)";");
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempTableName, (String)"FCostObjectId", (boolean)false, (boolean)false);
        return tempTableName;
    }

    private String getCostObjLotMapTempTbl() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table temp1 (").append('\n').append("    FProductId varchar(44),").append('\n').append("    FProdBatchNo nvarchar(80),").append('\n').append("    FCostObjBatchNo nvarchar(80)").append('\n').append(")");
        String tempTableName = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("insert into ").append(tempTableName).append('\n').append("(FProductId, FProdBatchNo, FCostObjBatchNo)").append('\n').append("SELECT distinct COE.FRelatedID As FProductId, Isnull(CO.FBatchNumber,N' ') As FProdBatchNo, Isnull(CO.FBatchNumber,N' ') As FCostObjBatchNo ").append('\n').append("FROM T_BD_CostObject CO ").append('\n').append("LEFT JOIN T_BD_COstObjectEntry COE on COE.FParentId = CO.Fid ").append('\n').append("WHERE CO.FIsForbiden = 0 AND CO.FCalculateMode = 4 AND CO.FCompanyID = '").append(this._calcParam.companyId).append("';").append('\n');
        sql.append("insert into ").append(tempTableName).append('\n').append("(FProductId, FProdBatchNo, FCostObjBatchNo)").append('\n').append("SELECT FMaterialID As FProductId, FLot As FProdBatchNo, FCostObjBatchNo ").append('\n').append("FROM ").append(this._calcParam.GetTBL_LotMapping()).append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sql.toString(), (String)";");
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempTableName, (String)"FProductId, FProdBatchNo", (boolean)false, (boolean)false);
        return tempTableName;
    }

    private String getBalanceTemp(String costObjLotMapTempTbl) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table temp1 (").append('\n').append("    FCostObjectId varchar(44),").append('\n').append("    FSubCostItemID varchar(44),").append('\n').append("    FSubProductID varchar(44),").append('\n').append("    FSubProdBatchNo nvarchar(80),").append('\n').append("    FQty NUMERIC(24,12),").append('\n').append("    FAmount NUMERIC(24,12)").append('\n').append(")");
        String tempTableName = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("insert into ").append(tempTableName).append(" (").append('\n').append("FCostObjectId, FSubCostItemID, FSubProductID, FSubProdBatchNo, FQty, FAmount").append('\n').append(")").append('\n').append("SELECT ").append('\n').append("    bal.FCostObjectID, bal_entry.FCostItemID As FSubCostItemID, bal_mat.FMaterialID As FSubProductID, ").append('\n').append("    ISNULL(cost_obj_lot_map.FProdBatchNo, N' ')As FSubProdBatchNo, ").append('\n').append("    SUM(bal_mat.FQty) As FQty, SUM(bal_mat.FAmount) As FAmount").append('\n').append("FROM ").append(this._calcParam.GetTBL_BalanceMatDetail()).append(" bal_mat ").append('\n').append("INNER JOIN ").append(this._calcParam.GetTBL_BalanceEntry()).append(" bal_entry ON bal_entry.FID = bal_mat.FParentID ").append('\n').append("INNER JOIN ").append(this._calcParam.GetTBL_Balance()).append(" bal ON bal.FID = bal_entry.FParentID ").append('\n').append("INNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ON CO.FCostObjectID = bal.FCostObjectID").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sql.append("INNER JOIN T_BD_MaterialCost mat_cost ").append('\n').append("    ON mat_cost.FOrgUnit = bal.FCompanyOrg AND mat_cost.FMaterialID = bal_mat.FMaterialID ").append('\n').append("    AND mat_cost.FStatus = 1 AND mat_cost.FIsParticipateReduct = 1 ").append('\n');
        }
        sql.append("LEFT JOIN ").append(costObjLotMapTempTbl).append(" cost_obj_lot_map ").append('\n').append("    ON cost_obj_lot_map.FProductId = bal_mat.FMaterialID AND cost_obj_lot_map.FProdBatchNo = bal_mat.FBatchNo ").append('\n').append("WHERE bal.FCompanyOrg = '").append(this._calcParam.companyId).append("'").append('\n').append("    AND bal.FCalculatePeriodID = '").append(this._calcParam.periodId).append("'").append('\n').append("GROUP BY bal.FCostObjectID, bal_entry.FCostItemID, bal_mat.FMaterialID, cost_obj_lot_map.FProdBatchNo ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sql.toString());
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempTableName, (String)"FCostObjectID, FSubCostItemID, FSubProductID, FSubProdBatchNo", (boolean)false, (boolean)false);
        return tempTableName;
    }

    private String getCostCalTemp(String costObjLotMapTempTbl) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table temp (").append('\n').append("    FCostObjectId varchar(44),").append('\n').append("    FSubCostItemID varchar(44),").append('\n').append("    FSubProductID varchar(44),").append('\n').append("    FSubProdBatchNo nvarchar(80),").append('\n').append("    FQty NUMERIC(24,12),").append('\n').append("    FAmount NUMERIC(24,12)").append('\n').append(")");
        String tempTableName = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("insert into ").append(tempTableName).append(" (").append('\n').append("FCostObjectId, FSubCostItemID, FSubProductID, FSubProdBatchNo, FQty, FAmount").append('\n').append(")").append('\n').append("SELECT ").append('\n').append("    cost_cal_res.FCostObjectID, cost_cal_mat_res.FCostItemID As FSubCostItemID, cost_cal_mat_res.FMaterialID As FSubProductID, ").append('\n').append("    ISNULL(cost_obj_lot_map.FCostObjBatchNo, N' ') As FSubProdBatchNo, ").append('\n').append("    SUM(cost_cal_mat_res.FFinishedQty + cost_cal_mat_res.FEoPWIPQty) As FQty, ").append('\n').append("    SUM(cost_cal_mat_res.FFinishedAmount + cost_cal_mat_res.FEoPWIPAmount) As FAmount").append('\n').append("FROM ").append(this._calcParam.GetTBL_CostCalResult()).append(" cost_cal_res ").append('\n').append("INNER JOIN ").append(this._calcParam.GetTBL_CostCalMatDetailResult()).append(" cost_cal_mat_res ").append('\n').append("    ON cost_cal_res.FCompanyID = cost_cal_mat_res.FCompanyID ").append('\n').append("    AND cost_cal_res.FCalculatePeriodID = cost_cal_mat_res.FCalculatePeriodID ").append('\n').append("    AND cost_cal_res.FCostCenterID = cost_cal_mat_res.FCostCenterID ").append('\n').append("    AND cost_cal_res.FCostObjectID = cost_cal_mat_res.FCostObjectID ").append('\n').append("    AND cost_cal_res.FCostItemID = cost_cal_mat_res.FCostItemID ").append('\n').append("INNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ").append('\n').append("    ON CO.FCostObjectID = cost_cal_res.FCostObjectID").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sql.append("INNER JOIN T_BD_MaterialCost mat_cost ").append('\n').append("    ON mat_cost.FOrgUnit = cost_cal_res.FCompanyID AND mat_cost.FMaterialID = cost_cal_mat_res.FMaterialID ").append('\n').append("    AND mat_cost.FStatus = 1 AND mat_cost.FIsParticipateReduct = 1 ").append('\n');
        }
        sql.append("LEFT JOIN ").append(costObjLotMapTempTbl).append(" cost_obj_lot_map ").append('\n').append("    ON cost_obj_lot_map.FProductId = cost_cal_mat_res.FMaterialID AND cost_obj_lot_map.FProdBatchNo = cost_cal_mat_res.FLot ").append('\n').append("WHERE cost_cal_res.FCompanyID = '").append(this._calcParam.companyId).append("'").append('\n').append("    AND cost_cal_res.FCalculatePeriodID = '").append(this._calcParam.periodId).append("'").append('\n').append("GROUP BY cost_cal_res.FCostObjectID, cost_cal_mat_res.FCostItemID, cost_cal_mat_res.FMaterialID, ").append('\n').append("    cost_obj_lot_map.FProdBatchNo, cost_obj_lot_map.FCostObjBatchNo;").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sql.toString());
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempTableName, (String)"FCostObjectID, FSubCostItemID, FSubProductID, FSubProdBatchNo", (boolean)false, (boolean)false);
        return tempTableName;
    }

    static class CtrlExecNum {
        public int WORKING_JOB = 0;

        CtrlExecNum() {
        }

        public synchronized void add() throws InterruptedException {
            while (true) {
                if (this.WORKING_JOB < 10) {
                    ++this.WORKING_JOB;
                    break;
                }
                this.wait(1000L);
            }
        }

        public synchronized void desc() {
            --this.WORKING_JOB;
        }
    }

    class MultiExecuteSql
    implements Runnable {
        String sql;
        Context ctx;
        CtrlExecNum ctrlExecNum;

        public MultiExecuteSql(Context ctx, String sql, CtrlExecNum ctrlExecNum) {
            this.ctx = ctx;
            this.sql = sql;
            this.ctrlExecNum = ctrlExecNum;
        }

        @Override
        public void run() {
            try {
                DBUtil.execute((Context)this.ctx, (String[])this.sql.split(";"));
            }
            catch (BOSException e) {
                RecoveryCalcByEnd.this.multiExcetion = e;
            }
            finally {
                RecoveryCalcByEnd.this.countDown.countDown();
                this.ctrlExecNum.desc();
            }
        }
    }
}

