/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Recovery.Calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.CalcParam;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.RecoveryCalcBase;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecoveryCalcByStep
extends RecoveryCalcBase {
    private static Logger logger = Logger.getLogger((String)RecoveryCalcByStep.class.getName());
    private int sort;

    public RecoveryCalcByStep(CalcParam calcParam) {
        super(calcParam);
    }

    @Override
    public void PreProcess() throws EASBizException, BOSException {
        super.PreProcess();
    }

    @Override
    public void ProdRecovery() throws EASBizException, BOSException {
        super.ProdRecovery();
    }

    @Override
    public void InventoryRecovery() throws EASBizException, BOSException {
        super.InventoryRecovery();
    }

    @Override
    public void GenerateRecoveryReport() throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        String tempTBL_CostRecoveryReportByEnd = this._calcParam.GetTempTBL_CostRecoveryReport_BySpecified(true);
        String TBL_CostRecoveryReportByEnd = this._calcParam.GetTBL_CostRecoveryReport_BySpecified(true);
        sb.delete(0, sb.length());
        this.RecoveryStockInByAll(true);
        this.GroupToByEnd(sb, tempTBL_CostRecoveryReportByEnd);
        this.SaveReportDataForByStep(sb, this._calcParam.GetTempTBL_CostRecoveryReport(), this._calcParam.GetTBL_CostRecoveryReport());
        this.ProcessReportDataForByEnd(sb, tempTBL_CostRecoveryReportByEnd, tempTBL_CostRecoveryReportByEnd, false);
        this.SaveReportDataForByEnd(sb, tempTBL_CostRecoveryReportByEnd, TBL_CostRecoveryReportByEnd);
        this.SaveVourchDataFromByEndReport(sb, tempTBL_CostRecoveryReportByEnd, this._calcParam.GetTBL_CostRecoveryVourchData());
    }

    public void RecoveryStockInByAll(boolean byCostCenter) throws EASBizException, BOSException {
        this.GetStockInData(byCostCenter);
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO  ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n');
        sb.append("   (FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n');
        sb.append("    FFinishedQty,FFinishedAmount,").append('\n');
        sb.append("    FTotalFinishedQty,FTotalFinishedAmount,FBeforeQtyEx, FAfterAmountEx,").append('\n');
        sb.append("    FBeforeQty,FBeforeAmount,FAfterQty,FAfterAmount,").append('\n');
        sb.append("    FLayer,FDispLayer,FIsLeaf,FBranch,FSort,FType)").append('\n');
        sb.append("Select newbosid('DFA50FD9') FID, FCompanyID, FCalculatePeriodID ,").append('\n');
        sb.append("    FCostCenterID,FCostObjectID,FProductID,isnull(FProdBatchNo,' '),").append('\n');
        sb.append("    FFinishedQty, FFinishedAmount,").append('\n');
        sb.append("    FFinishedQty, FFinishedAmount,FFinishedQty, FFinishedAmount,").append('\n');
        sb.append("    FBeforeQty, FBeforeAmount,").append('\n');
        sb.append("    FAfterQty, FAfterAmount,").append('\n');
        sb.append("    FLayer, FDispLayer, FIsLeaf, FBranch, FSort, FType ").append('\n');
        sb.append("From ").append('\n');
        sb.append("    (Select distinct '").append(this._calcParam.companyId).append("' FCompanyID, '").append(this._calcParam.periodId).append("' FCalculatePeriodID ,").append('\n');
        sb.append("        FCostCenterID,FCostObjectID,FProductID,FProdBatchNo,").append('\n');
        sb.append("        FTotalFinishedQty FFinishedQty, FTotalFinishedAmount FFinishedAmount,").append('\n');
        sb.append("        FTotalFinishedQty FBeforeQty, FTotalFinishedAmount FBeforeAmount,").append('\n');
        sb.append("        FTotalFinishedQty FAfterQty, FTotalFinishedAmount FAfterAmount,").append('\n');
        sb.append("        -1 FLayer,0 FDispLayer,-1 FIsLeaf,'' FBranch,0 FSort,1 FType ").append('\n');
        sb.append("     From ").append(this._calcParam.GetTempTblStockInDataByStep()).append('\n');
        sb.append("    ) data ").append('\n');
        sb.append("; ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n');
        sb.append("   (FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo,FCostItemID, ").append('\n');
        sb.append("    FFinishedQty,FFinishedAmount,").append('\n');
        sb.append("    FTotalFinishedQty,FTotalFinishedAmount,FBeforeQtyEx, FAfterAmountEx,").append('\n');
        sb.append("    FBeforeQty,FBeforeAmount,").append('\n');
        sb.append("    FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n');
        sb.append("Select newbosid('DFA50FD9') FID, FCompanyID, FCalculatePeriodID ,").append('\n');
        sb.append("    FCostCenterID,FCostObjectID,FProductID,isnull(FProdBatchNo,' '),FCostItemID,").append('\n');
        sb.append("    FFinishedQty, FFinishedAmount,").append('\n');
        sb.append("    FTotalFinishedQty,FTotalFinishedAmount,FTotalFinishedQty,FTotalFinishedAmount,").append('\n');
        sb.append("    FBeforeQty, FBeforeAmount,").append('\n');
        sb.append("    FLayer, FDispLayer, FIsLeaf, FBranch, FType ").append('\n');
        sb.append("From ").append('\n');
        sb.append("    (Select distinct '").append(this._calcParam.companyId).append("' FCompanyID, '").append(this._calcParam.periodId).append("' FCalculatePeriodID ,").append('\n');
        sb.append("        FCostCenterID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,").append('\n');
        sb.append("        FCostItemQty FFinishedQty, FCostItemAmount FFinishedAmount,").append('\n');
        sb.append("        FTotalFinishedQty, FTotalFinishedAmount,").append('\n');
        sb.append("        FCostItemQty FBeforeQty, FCostItemAmount FBeforeAmount,").append('\n');
        sb.append("        0 FLayer,1 FDispLayer,case when FMaterialID is null then 1 else 0 end as FIsLeaf,FPrdBatchNodeID || '.' || FCostItemNodeID FBranch,2 FType ").append('\n');
        sb.append("    From ").append(this._calcParam.GetTempTblStockInDataByStep()).append('\n');
        sb.append("    Where FCostItemID is not null ").append('\n');
        sb.append(") data ").append('\n');
        sb.append("; ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n');
        sb.append("   (FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo, ").append('\n');
        sb.append("    FFinishedQty,FFinishedAmount,").append('\n');
        sb.append("    FTotalFinishedQty, FTotalFinishedAmount,FBeforeQtyEx, FAfterAmountEx,").append('\n');
        sb.append("    FBeforeQty,FBeforeAmount,").append('\n');
        sb.append("    FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n');
        sb.append("Select newbosid('DFA50FD9') FID, '").append(this._calcParam.companyId).append("' FCompanyID, '").append(this._calcParam.periodId).append("' FCalculatePeriodID ,").append('\n');
        sb.append("    FCostCenterID,FCostObjectID,FProductID,isnull(FProdBatchNo,' '),FCostItemID,FMaterialID,isnull(FMatBatchNo,' '),").append('\n');
        sb.append("    FMatQty FFinishedQty, FMatAmount FFinishedAmount,").append('\n');
        sb.append("    FTotalFinishedQty,FTotalFinishedAmount,FTotalFinishedQty,FTotalFinishedAmount,").append('\n');
        sb.append("    FMatQty FBeforeQty, FMatAmount FBeforeAmount,").append('\n');
        sb.append("    1 FLayer,1 FDispLayer,case when FHasCoef = 1 or FHasCoef2 = 1 then 0 else 1 end as FIsLeaf,FPrdBatchNodeID ||'.'|| FCostItemNodeID || '.' || FMaterialID FBranch,2 FType ").append('\n');
        sb.append("From ").append(this._calcParam.GetTempTblStockInDataByStep()).append('\n');
        sb.append("Where FCostItemID is not null  and FMaterialID is not null ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n');
        sb.append("   (FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n');
        sb.append("    FCostItemID,FMaterialID,FMatBatchNo,").append('\n');
        sb.append("    FFinishedQty,FFinishedAmount,").append('\n');
        sb.append("    FTotalFinishedQty,FTotalFinishedAmount,FBeforeQtyEx, FAfterAmountEx,").append('\n');
        sb.append("    FAfterQty,FAfterAmount,").append('\n');
        sb.append("    FLayer,FDispLayer,FIsLeaf,FBranch,FType,FParentForAdjID)").append('\n');
        sb.append("SELECT newbosid('DFA50FD9') FID,'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',").append('\n');
        sb.append("    D.FCostCenterID,").append('\n');
        sb.append("    W.FCostObjectID,W.FProductID,isnull(W.FProdBatchNo,' '),W.FCostItemID,W.FMaterialID,isnull(W.FMatBatchNo,' '), ").append('\n');
        sb.append("    Round(W.FQtyCoef * D.FMatQty,Isnull(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FFinishedQty,Round(W.FAmtCoef * D.FMatAmount").append(",CY.FPrecision) As FFinishedAmount, ").append('\n');
        sb.append("    FTotalFinishedQty,FTotalFinishedAmount,FTotalFinishedQty,FTotalFinishedAmount,").append('\n');
        sb.append("    Round(W.FQtyCoef * D.FMatQty,Isnull(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FAfterQty,Round(W.FAmtCoef * D.FMatAmount").append(",CY.FPrecision) As FAfterAmount, ").append('\n');
        sb.append("   (W.FLayer + 2) As FLayer,W.FDispLayer As FDispLayer,W.FIsLeaf,D.FPrdBatchNodeID ||'.'|| D.FCostItemNodeID ||'.'|| D.FMaterialID || '.' || W.FBranch,2,D.FID ").append('\n');
        sb.append("FROM ").append(this._calcParam.GetTempTblStockInDataByStep()).append(" D ").append('\n');
        sb.append("Inner Join ").append(this.dataCache.getBopWIPCoefTable()).append(" W ").append('\n');
        sb.append("    ON W.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n');
        sb.append("      AND W.FProductID = D.FProductID AND isnull(W.FProdBatchNo,' ')= isnull(D.FProdBatchNo,' ') ").append('\n');
        sb.append("      AND W.FSubCostItemID = D.FCostItemID AND W.FSubProductID= D.FMaterialID ").append('\n');
        sb.append("      AND isnull(W.FSubProdBatchNo,' ') = isnull(D.FMatBatchNo,' ') ").append('\n');
        sb.append("LEFT JOIN T_ORG_Company CMP ON CMP.FID='").append(this._calcParam.companyId).append("'").append('\n');
        sb.append("LEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n');
        sb.append("LEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Prd ON Prd.FMaterialID=W.FProductID ").append('\n');
        sb.append("LEFT JOIN T_BD_MeasureUnit MU ON Prd.FBaseUnit=MU.FID").append('\n');
        sb.append("LEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Mat ON Mat.FMaterialID=W.FMaterialID ").append('\n');
        sb.append("LEFT JOIN T_BD_MeasureUnit MatMU ON Mat.FBaseUnit=MatMU.FID").append('\n');
        sb.append("WHERE D.FHasCoef = 1 ").append('\n');
        sb.append("; ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,").append('\n').append(" FFinishedQty,FFinishedAmount,").append('\n').append("    FTotalFinishedQty,FTotalFinishedAmount,FBeforeQtyEx, FAfterAmountEx,").append('\n').append(" FAfterQty,FAfterAmount,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType,FParentForAdjID)").append('\n').append("SELECT newbosid('DFA50FD9') FID,'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',").append(" D.FCostCenterID As FCostCenterID,").append(" D.FCostObjectID As FCostObjectID, D.FProductID As FProductID,isnull(D.FProdBatchNo,' ') As FProdBatchNo,W.FCostItemID,W.FMaterialID,isnull(W.FMatBatchNo,' '), ").append('\n').append("    Round(W.FQtyCoef * D.FMatQty,Isnull(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FFinishedQty,Round(W.FAmtCoef * D.FMatAmount,CY.FPrecision) As FFinishedAmount, ").append('\n').append("    FTotalFinishedQty,FTotalFinishedAmount,FTotalFinishedQty,FTotalFinishedAmount,").append('\n').append("    Round(W.FQtyCoef * D.FMatQty,Isnull(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FAfterQty,Round(W.FAmtCoef * D.FMatAmount,CY.FPrecision) As FAfterAmount, ").append('\n').append("   (W.FLayer + 2) As FLayer,(W.FDispLayer+1) As FDispLayer,W.FIsLeaf,D.FPrdBatchNodeID ||'.'|| D.FCostItemNodeID ||'.'|| D.FMaterialID || '.' || W.FBranch,2, D.FID").append('\n').append("FROM ").append(this._calcParam.GetTempTblStockInDataByStep()).append(" D ").append('\n');
        sb.append("Inner Join ").append(this.dataCache.getBopInvCoefTable()).append(" W ").append('\n').append("   ON W.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("   AND W.FProductID = D.FMaterialID AND isnull(W.FProdBatchNo,' ')= isnull(D.FMatBatchNo,' ')").append('\n').append("LEFT JOIN T_ORG_Company CMP ON CMP.FID= '").append(this._calcParam.companyId).append("'").append('\n').append("LEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append("LEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Prd ON Prd.FMaterialID=W.FProductID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MU ON Prd.FBaseUnit=MU.FID").append('\n').append("LEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Mat ON Mat.FMaterialID=W.FMaterialID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MatMU ON Mat.FBaseUnit=MatMU.FID").append('\n').append("WHERE D.FHasCoef = 0 and D.FHasCoef2 = 1 ").append('\n').append("; ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_CostRecoveryReport(), (String)"FID", (boolean)true, (boolean)true);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_CostRecoveryReport(), (String)"FParentForAdjID,FLayer", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_CostRecoveryReport(), (String)"FCostCenterID,FCostObjectID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_CostRecoveryReport(), (String)"FProductID,FCostItemID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_CostRecoveryReport(), (String)"FMaterialID", (boolean)false, (boolean)false);
        sb.append("Create Table _tempTblMaterialCost (").append('\n').append("FParentForAdjID VARCHAR(44),FAfterAmount NUMERIC(21,8))").append('\n');
        String temptable = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" insert into ").append(temptable).append(" (FParentForAdjID,FAfterAmount)").append('\n');
        sb.append("   select FParentForAdjID, Sum(t1.FAfterAmount) FAfterAmount from ").append('\n');
        sb.append("       " + this._calcParam.GetTempTBL_CostRecoveryReport() + " t1 ").append('\n');
        sb.append("       where flayer = 2 ").append('\n');
        sb.append("       group by FParentForAdjID ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)temptable, (String)"FParentForAdjID", (boolean)false, (boolean)false);
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)temptable);
        sb.setLength(0);
        sb.append(" select sumData.FParentForAdjID FParentForAdjID,t1.FMatAmount - sumData.FAfterAmount FDiffAmount from ").append('\n');
        sb.append("    (select FParentForAdjID, Sum(t1.FAfterAmount) FAfterAmount from ").append('\n');
        sb.append("       " + this._calcParam.GetTempTBL_CostRecoveryReport() + " t1 ").append('\n');
        sb.append("       where flayer = 2 ").append('\n');
        sb.append("       group by FParentForAdjID ").append('\n');
        sb.append("    ) sumData ").append('\n');
        sb.append("    inner join ").append(this._calcParam.GetTempTblStockInDataByStep() + " t1 ").append('\n');
        sb.append("    on t1.FID = sumData.FParentForAdjID ").append('\n');
        sb.append("Where t1.FMatAmount - sumData.FAfterAmount <> 0 ").append('\n');
        sb.setLength(0);
        sb.append(" select sumData.FParentForAdjID FParentForAdjID,t1.FMatAmount - sumData.FAfterAmount FDiffAmount from ").append('\n');
        sb.append(temptable).append("  sumData ").append('\n');
        sb.append("    inner join ").append(this._calcParam.GetTempTblStockInDataByStep() + " t1 ").append('\n');
        sb.append("    on t1.FID = sumData.FParentForAdjID ").append('\n');
        sb.append("Where  t1.FMatAmount - sumData.FAfterAmount <> 0 ").append('\n');
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)temptable);
        if (rs != null && rs.size() > 0) {
            sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" SET FAfterAmount=(FAfterAmount + ?),FBeforAdjustFAmount = ?,FisAdjust = 1 ").append('\n');
            sb.append("WHERE FID =(").append('\n');
            sb.append("   Select top 1 FID ").append('\n');
            sb.append("   From ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n');
            sb.append("   WHERE FParentForAdjID = ? and  flayer = 2 ").append('\n');
            sb.append(" AND FCostItemID is not null AND FMaterialID is null ").append('\n');
            sb.append("   ORDER BY FAfterAmount DESC ").append('\n');
            sb.append(")");
            sb.append("AND FisAdjust = 0 ;");
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = this._calcParam.get_conn();
                pstmt = conn.prepareStatement(sb.toString());
                while (rs.next()) {
                    pstmt.setBigDecimal(1, rs.getBigDecimal("FDiffAmount"));
                    pstmt.setBigDecimal(2, rs.getBigDecimal("FDiffAmount"));
                    pstmt.setString(3, rs.getString("FParentForAdjID"));
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup((ResultSet)rs, pstmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        }
        sb.setLength(0);
        int disRank = Integer.parseInt(this._calcParam.dispRank);
        sb.append("Create Table _tempTblMaterialCost (").append('\n').append("FBranch varchar(1020),FCostCenterID VARCHAR(44),FProductID VARCHAR(44),FProdBatchNo VARCHAR(80),FLayer smallint DEFAULT 0,FIsLeaf smallint DEFAULT 0,FAfterAmount NUMERIC(21,8))").append('\n');
        temptable = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" insert into ").append(temptable).append(" (FBranch,FCostCenterID,FProductID,FProdBatchNo,FLayer,FIsLeaf,FAfterAmount)").append('\n');
        sb.append("   select FBranch,FCostCenterID,FProductID,FProdBatchNo,FLayer,FIsLeaf,sum(isnull(FAfterAmount,0)) from ").append('\n');
        sb.append("       " + this._calcParam.GetTempTBL_CostRecoveryReport() + " t1 ").append('\n');
        sb.append("       group by FCostCenterID,FProductID,FProdBatchNo,FBranch,FLayer,FIsLeaf").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)temptable, (String)"FBranch,FCostCenterID,FProductID,FProdBatchNo,FLayer", (boolean)false, (boolean)false);
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)temptable);
        sb.setLength(0);
        for (int layer = 3; layer <= disRank + 3; ++layer) {
            sb.append(" update ").append(this._calcParam.GetTempTBL_CostRecoveryReport() + " t1").append('\n');
            sb.append("    set FBeforAdjustFAmount = (select sum(t2.FAfterAmount) ").append('\n');
            sb.append("    from ").append(temptable + " t2").append('\n');
            sb.append("    where (t1.FBranch = t2.FBranch or charindex(t1.FBranch||'.',t2.FBranch) = 1) and t1.FCostCenterID = t2.FCostCenterID and t1.FProductID = t2.FProductID and isnull(t1.FProdBatchNo,' ') = isnull(t2.FProdBatchNo,' ') and t2.FLayer = " + layer + ")");
            sb.append("  where t1.FLayer = " + layer + "-1 and t1.FIsLeaf = 0").append('\n');
            sb.append(" ;").append('\n');
            sb.append(" update ").append(this._calcParam.GetTempTBL_CostRecoveryReport() + " t1").append('\n');
            sb.append("    set FBeforAdjustSumAmount = (select sum(t2.FAfterAmount) ").append('\n');
            sb.append("    from ").append(temptable + " t2").append('\n');
            sb.append("    where t1.FBranch=t2.FBranch and t1.FCostCenterID = t2.FCostCenterID and t1.FProductID = t2.FProductID and isnull(t1.FProdBatchNo,' ') = isnull(t2.FProdBatchNo,' ') and t2.FLayer = " + layer + "-1 and t2.FIsLeaf = 0)");
            sb.append("  where t1.FLayer = " + layer + "-1 and t1.FIsLeaf = 0").append('\n');
            sb.append(" ;").append('\n');
        }
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)temptable);
        sb.setLength(0);
        sb.append("Create Table _tempTblMaterialCost (").append('\n').append("FBranch varchar(1020),FCostCenterID VARCHAR(44),FProductID VARCHAR(44),FProdBatchNo VARCHAR(80),FLayer smallint DEFAULT 0,FIsLeaf smallint DEFAULT 0,FDiffAfterAmount NUMERIC(21,8))").append('\n');
        String temptable2 = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" insert into ").append(temptable2).append(" (FBranch,FCostCenterID,FProductID,FProdBatchNo,FLayer,FIsLeaf,FDiffAfterAmount)").append('\n');
        sb.append("   select FBranch,FCostCenterID,FProductID,FProdBatchNo,FLayer,0,max(FDiffAfterAmount)  from (").append('\n');
        sb.append("   select FBranch,FCostCenterID,FProductID,FProdBatchNo,FLayer,isnull(FBeforAdjustSumAmount,0) - isnull(FBeforAdjustFAmount,0) FDiffAfterAmount from ").append('\n');
        sb.append("       " + this._calcParam.GetTempTBL_CostRecoveryReport() + " t1").append('\n');
        sb.append(" where FIsLeaf = 0 ) data ").append('\n');
        sb.append(" group by FCostCenterID,FProductID,FProdBatchNo,FBranch,FLayer ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)temptable2, (String)"FBranch,FCostCenterID,FProductID,FProdBatchNo,FLayer", (boolean)false, (boolean)false);
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)temptable2);
        sb.setLength(0);
        sb.append("update ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" set FParentForAdjID = null where FisAdjust = 0");
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        for (int layer2 = 3; layer2 <= disRank + 3; ++layer2) {
            sb.append(" update ").append(this._calcParam.GetTempTBL_CostRecoveryReport() + " t1").append('\n');
            sb.append("    set (FBeforAdjustFAmount,FParentForAdjID) = (select top 1 t2.FDiffAfterAmount,t2.FBranch   ").append('\n');
            sb.append("          from " + temptable2 + " t2").append('\n');
            sb.append("          where (t1.FBranch = t2.FBranch or charindex(t2.FBranch||'.',t1.FBranch) = 1) and t1.FCostCenterID = t2.FCostCenterID and t1.FProductID = t2.FProductID and isnull(t1.FProdBatchNo,' ') = isnull(t2.FProdBatchNo,' ')  and t2.FLayer = " + layer2 + "-1 and t2.FIsLeaf = 0 )").append('\n');
            sb.append(" where t1.FLayer = " + layer2).append('\n');
            sb.append(" ;").append('\n');
            sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" t1 SET FAfterAmount=(FAfterAmount + FBeforAdjustFAmount),FisAdjust = 1").append('\n');
            sb.append("WHERE FID in (").append('\n');
            sb.append("   Select Max(t2.FID) ").append('\n');
            sb.append("   From ").append(this._calcParam.GetTempTBL_CostRecoveryReport() + " t2").append('\n');
            sb.append("   where t2.flayer =  " + layer2 + " AND t2.FisAdjust = 0 and t2.FISLEAF = 1 and t2.FParentForAdjID is not null ").append('\n');
            sb.append("   group by FParentForAdjID,FCostCenterID,FProductID,isnull(t2.FProdBatchNo,' ')) ;");
        }
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" set ffinishedamount = fafteramount where FisAdjust = 1");
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)temptable2);
        sb.setLength(0);
    }

    public void RecoveryStockIn(boolean byCostCenter) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> AmtDiffAdjust = new HashMap<String, String>();
        HashMap<String, String> QtyDiffAdjust = new HashMap<String, String>();
        try {
            NumberFormat fm = NumberFormat.getInstance();
            fm.setGroupingUsed(false);
            IRowSet rs = this.GetStockInData(byCostCenter);
            String lastCostCenterID = "";
            String lastCostObjectID = "";
            String lastProductId = "";
            String lastProdBatchNo = "";
            String lastCostItemID = "";
            String sBranch = "";
            String sSubBranch = "";
            String sIsLeaf = "";
            int iDiffAdjustID = 0;
            while (rs.next()) {
                boolean isTop = false;
                if (lastCostCenterID.compareTo(rs.getString("FCostCenterID")) != 0 || lastCostObjectID.compareTo(rs.getString("FCostobjectId")) != 0 || lastProductId.compareTo(rs.getString("FProductId")) != 0 || lastProdBatchNo.compareTo(rs.getString("FProdBatchNo")) != 0) {
                    fm.setMaximumFractionDigits(12);
                    String totalFinishedAmount = fm.format(BigDecimal.valueOf(0L));
                    if (rs.getBigDecimal("FTotalFinishedAmount") != null) {
                        totalFinishedAmount = fm.format(rs.getBigDecimal("FTotalFinishedAmount"));
                    }
                    String totalFinishedQty = fm.format(BigDecimal.valueOf(0L));
                    if (rs.getBigDecimal("FTotalFinishedQty") != null) {
                        totalFinishedQty = fm.format(rs.getBigDecimal("FTotalFinishedQty"));
                    }
                    sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FFinishedQty,FFinishedAmount,").append('\n').append(" FBeforeQty,FBeforeAmount,FAfterQty,FAfterAmount,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FSort,FType)").append('\n').append("Values(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostCenterID")).append("',").append("'").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductId")).append("','").append(rs.getString("FProdBatchNo")).append("',").append(totalFinishedQty).append(",").append(totalFinishedAmount).append(",").append(totalFinishedQty).append(",").append(totalFinishedAmount).append(",").append(totalFinishedQty).append(",").append(totalFinishedAmount).append(",").append("-1,0,-1,'',0,1").append(");").append('\n');
                    lastCostCenterID = rs.getString("FCostCenterID");
                    lastCostObjectID = rs.getString("FCostobjectId");
                    lastProductId = rs.getString("FProductId");
                    lastProdBatchNo = rs.getString("FProdBatchNo");
                    isTop = true;
                }
                if (lastCostItemID.compareTo(rs.getString("FCostItemID")) != 0 || isTop) {
                    fm.setMaximumFractionDigits(12);
                    String costItemAmount = fm.format(BigDecimal.valueOf(0L));
                    if (rs.getBigDecimal("FCostItemAmount") != null) {
                        costItemAmount = fm.format(rs.getBigDecimal("FCostItemAmount"));
                    }
                    String costItemQty = fm.format(BigDecimal.valueOf(0L));
                    if (rs.getBigDecimal("FCostItemQty") != null) {
                        costItemQty = fm.format(rs.getBigDecimal("FCostItemQty"));
                    }
                    sBranch = rs.getString("FPrdBatchNodeID");
                    sIsLeaf = rs.getString("FMaterialID") != null && rs.getString("FMaterialID").length() > 0 ? "0" : "1";
                    sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo,FCostItemID, ").append('\n').append(" FFinishedQty,FFinishedAmount,").append('\n').append(" FBeforeQty,FBeforeAmount,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("Values(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostCenterID")).append("',").append("'").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductId")).append("','").append(rs.getString("FProdBatchNo")).append("','").append(rs.getString("FCostItemID")).append("',").append(costItemQty).append(",").append(costItemAmount).append(",").append(costItemQty).append(",").append(costItemAmount).append(",").append("0,1,").append(sIsLeaf).append(",'").append(sBranch).append("',2").append(");").append('\n');
                    lastCostItemID = rs.getString("FCostItemID");
                }
                if (rs.getString("FMaterialID") == null || rs.getString("FMaterialID").length() <= 0) continue;
                fm.setMaximumFractionDigits(12);
                String matAmount = fm.format(BigDecimal.valueOf(0L));
                if (rs.getBigDecimal("FMatAmount") != null) {
                    matAmount = fm.format(rs.getBigDecimal("FMatAmount"));
                }
                String matQty = fm.format(BigDecimal.valueOf(0L));
                if (rs.getBigDecimal("FMatQty") != null) {
                    matQty = fm.format(rs.getBigDecimal("FMatQty"));
                }
                sSubBranch = sBranch + "." + rs.getString("FCostItemNodeID");
                sIsLeaf = rs.getInt("FHasCoef") == 1 || rs.getInt("FHasCoef2") == 1 ? "0" : "1";
                sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,").append('\n').append(" FFinishedQty,FFinishedAmount,").append('\n').append(" FBeforeQty,FBeforeAmount,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("Values(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostCenterID")).append("',").append("'").append(rs.getString("FCostObjectID")).append("','").append(rs.getString("FProductId")).append("','").append(rs.getString("FProdBatchNo")).append("','").append(rs.getString("FCostItemID")).append("','").append(rs.getString("FMaterialID")).append("','").append(rs.getString("FMatBatchNo")).append("',").append(matQty).append(",").append(matAmount).append(",").append(matQty).append(",").append(matAmount).append(",").append("1,1,").append(sIsLeaf).append(",'").append(sSubBranch).append("',2").append(");").append('\n');
                if (rs.getInt("FHasCoef") == 1) {
                    AmtDiffAdjust.put(String.valueOf(++iDiffAdjustID), matAmount);
                    QtyDiffAdjust.put(String.valueOf(iDiffAdjustID), matQty);
                    sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,").append('\n').append(" FFinishedQty,FFinishedAmount,").append('\n').append(" FAfterQty,FAfterAmount,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType,FDiffAdjustID)").append('\n').append("SELECT newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostCenterID")).append("',").append("\tW.FCostObjectID,W.FProductID,W.FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("    Round(W.FQtyCoef * ").append(matQty).append(",Isnull(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FFinishedQty,Round(W.FAmtCoef * ").append(matAmount).append(",CY.FPrecision) As FFinishedAmount, ").append('\n').append("    Round(W.FQtyCoef * ").append(matQty).append(",Isnull(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FAfterQty,Round(W.FAmtCoef * ").append(matAmount).append(",CY.FPrecision) As FAfterAmount, ").append('\n').append("\t(W.FLayer + 2) As FLayer,W.FDispLayer As FDispLayer,W.FIsLeaf,'").append(sSubBranch).append("'||'.'||W.FBranch,2,").append(iDiffAdjustID).append('\n').append("FROM ").append(this._calcParam.GetTBL_BopWIPCoef()).append(" W ").append('\n').append("LEFT JOIN T_ORG_Company CMP ON CMP.FID=W.FCompanyID ").append('\n').append("LEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append("LEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Prd ON Prd.FMateriaID=W.FProductID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MU ON Prd.FBaseUnit=MU.FID").append('\n').append("LEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" ON Mat.FMaterialID=W.FMaterialID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MatMU ON Mat.FBaseUnit=MatMU.FID").append('\n').append("WHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\tAND W.FProductID = '").append(rs.getString("FProductID")).append("' AND W.FProdBatchNo='").append(rs.getString("FProdBatchNo")).append("'").append('\n').append("\tAND W.FSubCostItemID = '").append(rs.getString("FCostItemID")).append("' AND W.FSubProductID='").append(rs.getString("FMaterialID")).append("'").append('\n').append("\tAND W.FSubProdBatchNo = '").append(rs.getString("FMatBatchNo")).append("'").append('\n').append("; ").append('\n');
                    continue;
                }
                if (rs.getInt("FHasCoef2") != 1) continue;
                AmtDiffAdjust.put(String.valueOf(++iDiffAdjustID), matAmount);
                QtyDiffAdjust.put(String.valueOf(iDiffAdjustID), matQty);
                sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,").append('\n').append(" FFinishedQty,FFinishedAmount,").append('\n').append(" FAfterQty,FAfterAmount,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType,FDiffAdjustID)").append('\n').append("SELECT newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("','").append(rs.getString("FCostCenterID")).append("',").append("\t'").append(rs.getString("FCostObjectID")).append("' As FCostObjectID,'").append(rs.getString("FProductID")).append("' As FProductID,'").append(rs.getString("FProdBatchNo")).append("' As FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("    Round(W.FQtyCoef * ").append(matQty).append(",Isnull(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FFinishedQty,Round(W.FAmtCoef * ").append(matAmount).append(",CY.FPrecision) As FFinishedAmount, ").append('\n').append("    Round(W.FQtyCoef * ").append(matQty).append(",Isnull(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FAfterQty,Round(W.FAmtCoef * ").append(matAmount).append(",CY.FPrecision) As FAfterAmount, ").append('\n').append("\t(W.FLayer + 2) As FLayer,(W.FDispLayer+1) As FDispLayer,W.FIsLeaf,'").append(sSubBranch).append("'||'.'||W.FBranch,2,").append(iDiffAdjustID).append('\n').append("FROM ").append(this._calcParam.GetTBL_BopInvCoef()).append(" W ").append('\n').append("LEFT JOIN T_ORG_Company CMP ON CMP.FID=W.FCompanyID ").append('\n').append("LEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append("LEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Prd ON Prd.FMateriaID=W.FProductID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MU ON Prd.FBaseUnit=MU.FID").append('\n').append("LEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Mat ON Mat.FMaterialID=W.FMaterialID ").append('\n').append("LEFT JOIN T_BD_MeasureUnit MatMU ON Mat.FBaseUnit=MatMU.FID").append('\n').append("WHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("\tAND W.FProductID = '").append(rs.getString("FMaterialID")).append("' AND W.FProdBatchNo='").append(rs.getString("FMatBatchNo")).append("'").append('\n').append("; ").append('\n');
            }
            if (sb.toString().length() > 0) {
                NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
                sb.delete(0, sb.length());
            }
            if (!AmtDiffAdjust.isEmpty()) {
                for (Map.Entry entry : AmtDiffAdjust.entrySet()) {
                    String sDiffAdjustID = (String)entry.getKey();
                    String sMatAmount = (String)entry.getValue();
                    sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" SET FAfterAmount=(FAfterAmount + ").append(sMatAmount).append(" - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAfterAmount),0.00) ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S").append('\n').append("\tWHERE S.FMaterialID is null AND FLayer=2 AND S.FDiffAdjustID=").append(sDiffAdjustID).append(" )").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n').append("\tWHERE FMaterialID is null AND FLayer=2 AND FDiffAdjustID=").append(sDiffAdjustID).append('\n').append("\tORDER BY FAfterAmount DESC ").append('\n').append(");");
                    sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" SET FFinishedAmount=(FFinishedAmount + ").append(sMatAmount).append(" - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FFinishedAmount),0.00) ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S").append('\n').append("\tWHERE S.FMaterialID is null AND FLayer=2 AND S.FDiffAdjustID=").append(sDiffAdjustID).append(" )").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n').append("\tWHERE FMaterialID is null AND FLayer=2 AND FDiffAdjustID=").append(sDiffAdjustID).append('\n').append("\tORDER BY FFinishedAmount DESC ").append('\n').append(");");
                    if (sb.toString().length() > 0) {
                        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
                        sb.delete(0, sb.length());
                    }
                    this.adjustDiff_Mat(sDiffAdjustID, null, null, null, null, 2, null);
                }
            }
            if (!QtyDiffAdjust.isEmpty()) {
                System.out.println("dd");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public void RecoveryStockIn_Oracle(boolean byCostCenter) throws EASBizException, BOSException {
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        StringBuffer sb = new StringBuffer();
        StringBuffer sbStockInDataSelectSql = new StringBuffer();
        sb.append("/*dialect*/");
        sbStockInDataSelectSql = this.GetStockInDataSelectSql(byCostCenter);
        String SelDefine = null;
        try {
            SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)this._calcParam.CurrentDataBaseType);
            if (SelDefine.indexOf("(+)") != -1) {
                SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)7);
            }
        }
        catch (SqlTranslateException e) {
            try {
                SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)8);
            }
            catch (SqlTranslateException e2) {
                logger.error((Object)e2);
                throw new BOSException(e2.getMessage());
            }
        }
        sb.append(" declare CURSOR cur IS ").append(SelDefine).append(";").append('\n').append("\tcurrInfo cur%rowtype; ").append('\n').append("\tsort NUMBER := 0; ").append('\n').append("\tlastCostCenterID VARCHAR2 (44) := ' '; ").append('\n').append("\tlastCostObjectID VARCHAR2 (44) := ' '; ").append('\n').append("\tlastProductId VARCHAR2 (44) := ' '; ").append('\n').append("\tlastProdBatchNo VARCHAR2 (80) := ' '; ").append('\n').append("\tlastCostItemID VARCHAR2 (44) := ' '; ").append('\n').append("\tsBranch VARCHAR2 (126) := ' '; ").append('\n').append("\tsSubBranch VARCHAR2 (252) := ' '; ").append('\n').append("\tisLeaf NUMBER := 0; ").append('\n').append("\tiDiffAdjustID NUMBER := 0; ").append('\n').append("\tisTop Boolean := false; ").append('\n').append(" BEGIN ").append('\n').append("\topen cur; ").append('\n').append("\tloop ").append('\n').append("\t   fetch cur into currInfo; ").append('\n').append("\t   exit when cur%notfound; ").append('\n').append("\t\t isTop := false;").append('\n').append("\t\t --A.1,\u4ea7\u54c1\u672c\u5c42").append('\n').append("\t\t if ((lastCostCenterID <> currInfo.FCostCenterID)OR (lastCostObjectID <> currInfo.FCostobjectId) OR (lastProductId <> currInfo.FProductId)OR (lastProdBatchNo <> NVL(currInfo.FProdBatchNo,' ')))then ").append('\n').append("\t\t \tINSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("\t\t \t(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append("\t\t \t FFinishedQty,FFinishedAmount,").append("\t\t \t FBeforeQty,FBeforeAmount,FAfterQty,FAfterAmount,").append("\t\t \t FLayer,FDispLayer,FIsLeaf,FBranch,FSort,FType)").append('\n').append("\t\t \tValues(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',currInfo.FCostCenterID,currInfo.FCostObjectID,currInfo.FProductId,currInfo.FProdBatchNo,").append("\t\t \t currInfo.FTotalFinishedQty,currInfo.FTotalFinishedAmount,currInfo.FTotalFinishedQty,currInfo.FTotalFinishedAmount,currInfo.FTotalFinishedQty,currInfo.FTotalFinishedAmount,-1,0,-1,'',0,1);").append("\t\t \tlastCostCenterID := currInfo.FCostCenterID;").append('\n').append("\t\t \tlastCostObjectID := currInfo.FCostobjectId;").append('\n').append("\t\t \tlastProductId := currInfo.FProductId;").append('\n').append("\t\t \tlastProdBatchNo := NVL(currInfo.FProdBatchNo,' ');").append('\n').append("\t\t \tisTop := true;").append('\n').append("\t\t end if; --end of A.1,\u4ea7\u54c1\u672c\u5c42").append('\n').append("\t\t --A.2,\u63d2\u5165\u6210\u672c\u9879\u76ee\u6c47\u603b\u4fe1\u606f").append('\n').append("\t\t if (lastCostItemID <> currInfo.FCostItemID OR isTop )then").append('\n').append("\t\t \tif (currInfo.FMaterialID IS NOT NULL)then").append('\n').append("\t\t \t\tisLeaf := 0;").append('\n').append("\t\t \telse ").append('\n').append("\t\t \t\tisLeaf := 1;").append('\n').append("\t\t \tend if;").append('\n').append("\t\t \tsBranch := currInfo.FPrdBatchNodeID;").append('\n').append("\t\t \tINSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("\t\t \t(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo,FCostItemID, ").append("\t\t \t FFinishedQty,FFinishedAmount,").append("\t\t \t FBeforeQty,FBeforeAmount,").append("\t\t \t FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("\t\t \tValues(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',currInfo.FCostCenterID,currInfo.FCostObjectID,currInfo.FProductId,NVL(currInfo.FProdBatchNo,' '),currInfo.FCostItemID,").append("\t\t \t currInfo.FCostItemQty,currInfo.FCostItemAmount,currInfo.FCostItemQty,currInfo.FCostItemAmount,0,1,isLeaf,sBranch,2);").append('\n').append("\t\t \tlastCostItemID := currInfo.FCostItemID;").append('\n').append("\t\t end if; --end of A.2,\u63d2\u5165\u6210\u672c\u9879\u76ee\u6c47\u603b\u4fe1\u606f").append('\n').append("\t\t --A.3,\u63d2\u5165\u672c\u5c42\u6750\u6599\u660e\u7ec6(\u5982\u679c\u6709\u65f6)").append('\n').append("\t\t if (currInfo.FMaterialID IS NOT NULL)then").append('\n').append("\t\t \tif (currInfo.FHasCoef = 1 OR currInfo.FHasCoef2 = 1)then").append('\n').append("\t\t \t\tisLeaf := 0;").append('\n').append("\t\t \telse ").append('\n').append("\t\t \t\tisLeaf := 1;").append('\n').append("\t\t \tend if;").append('\n').append("\t\t \tsSubBranch := sBranch || '.' || currInfo.FCostItemNodeID;").append('\n').append("\t\t \tINSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("\t\t \t(FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append("\t\t \t FCostItemID,FMaterialID,FMatBatchNo,").append('\n').append("\t\t \t FFinishedQty,FFinishedAmount,").append('\n').append("\t\t \t FBeforeQty,FBeforeAmount,").append('\n').append("\t\t \t FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("\t\t \tValues(newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',currInfo.FCostCenterID,currInfo.FCostObjectID,currInfo.FProductId,NVL(currInfo.FProdBatchNo,' '),currInfo.FCostItemID,currInfo.FMaterialID,NVL(currInfo.FMatBatchNo,' '),").append("\t\t \t currInfo.FMatQty,currInfo.FMatAmount,currInfo.FMatQty,currInfo.FMatAmount,1,1,isLeaf,sSubBranch,2);").append('\n').append("\t\t \t--A.4\u81ea\u5236\u5b50\u9879\u65f6\u5c55\u5f00\u4e0b\u5c42\u7ed3\u6784").append('\n').append("\t\t \tif (currInfo.FHasCoef = 1)then").append('\n').append("\t\t \t\tiDiffAdjustID := (iDiffAdjustID + 1);").append('\n').append("\t\t \t\tINSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("\t\t \t\t(\tFID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append("\t\t \t\t \tFCostItemID,FMaterialID,FMatBatchNo,").append("\t\t \t\t \tFFinishedQty,FFinishedAmount,").append("\t\t \t\t \tFAfterQty,FAfterAmount,").append("\t\t \t\t \tFLayer,FDispLayer,FIsLeaf,FBranch,FType,FDiffAdjustID)").append('\n').append("\t\t \t\tSELECT newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',currInfo.FCostCenterID,").append("\t\t \t\t\tW.FCostObjectID,W.FProductID,W.FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("\t\t \t\t\tRound(W.FQtyCoef * currInfo.FMatQty,NVL(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FFinishedQty,Round(W.FAmtCoef * currInfo.FMatAmount,CY.FPrecision) As FFinishedAmount, ").append('\n').append("\t\t \t\t\tRound(W.FQtyCoef * currInfo.FMatQty,NVL(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FAfterQty,Round(W.FAmtCoef * currInfo.FMatAmount,CY.FPrecision) As FAfterAmount, ").append('\n').append("\t\t \t\t\t(W.FLayer + 2) As FLayer,W.FDispLayer As FDispLayer,W.FIsLeaf,sSubBranch ||'.'||W.FBranch,2,iDiffAdjustID ").append('\n').append("\t\t \t\tFROM ").append(this._calcParam.GetTBL_BopWIPCoef()).append(" W ").append('\n').append("\t\t \t\tLEFT JOIN T_ORG_Company CMP ON CMP.FID=W.FCompanyID ").append('\n').append("\t\t \t\tLEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append("\t\t \t\tLEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Prd ON Prd.FmaterialID=W.FProductID ").append('\n').append("\t\t \t\tLEFT JOIN T_BD_MeasureUnit MU ON Prd.FBaseUnit=MU.FID").append('\n').append("\t\t \t\tLEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Mat ON Mat.FMaterialID=W.FMaterialID ").append('\n').append("\t\t \t\tLEFT JOIN T_BD_MeasureUnit MatMU ON Mat.FBaseUnit=MatMU.FID").append('\n').append("\t\t \t\tWHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\t\t\t\t\tAND W.FProductID = currInfo.FProductID AND W.FProdBatchNo=NVL(currInfo.FProdBatchNo,' ')").append('\n').append("\t\t\t\t\tAND W.FSubCostItemID = currInfo.FCostItemID AND W.FSubProductID=currInfo.FMaterialID").append('\n').append("\t\t\t\t\tAND W.FSubProdBatchNo = NVL(currInfo.FMatBatchNo,' '); ").append('\n').append("\t\t \tend if; --end of A.4\u81ea\u5236\u5b50\u9879\u65f6\u5c55\u5f00\u4e0b\u5c42\u7ed3\u6784").append('\n').append("\t\t \t--\u6ca1\u6709\u671f\u521d\u7cfb\u6570\u4e14\u662f\u53c2\u4e0e\u8fd8\u539f\u7684\u534a\u6210\u54c1\u65f6\uff0c\u53d6\u671f\u521d\u5e93\u5b58\u7cfb\u6570").append('\n').append("\t\t \tif (currInfo.FHasCoef2 = 1 and currInfo.FHasCoef <> 1)then").append('\n').append("\t\t \t\tiDiffAdjustID := (iDiffAdjustID + 1);").append('\n').append("               INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("               (    FID,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append("                    FCostItemID,FMaterialID,FMatBatchNo,").append('\n').append("                    FFinishedQty,FFinishedAmount,").append('\n').append("                    FAfterQty,FAfterAmount,").append('\n').append("                    FLayer,FDispLayer,FIsLeaf,FBranch,FType,FDiffAdjustID)").append('\n').append("               SELECT newbosid('DFA50FD9'),'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',").append("                    currInfo.FCostCenterID,").append("\t                 currInfo.FCostObjectID ,currInfo.FProductID,currInfo.FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("                    Round(W.FQtyCoef * currInfo.FMatQty,NVL(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FFinishedQty,Round(W.FAmtCoef * currInfo.FMatAmount,CY.FPrecision) As FFinishedAmount, ").append('\n').append("                    Round(W.FQtyCoef * currInfo.FMatQty,NVL(MatMU.FQtyPrecision,MU.FQtyPrecision)) As FAfterQty,Round(W.FAmtCoef * currInfo.FMatAmount,CY.FPrecision) As FAfterAmount, ").append('\n').append("\t                 (W.FLayer + 2) As FLayer,(W.FDispLayer+1) As FDispLayer,W.FIsLeaf,sSubBranch ||'.'||W.FBranch,2,iDiffAdjustID ").append('\n').append("               FROM ").append(this._calcParam.GetTBL_BopInvCoef()).append(" W ").append('\n').append("               LEFT JOIN T_ORG_Company CMP ON CMP.FID=W.FCompanyID ").append('\n').append("               LEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append("\t\t \t\tLEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Prd ON Prd.FmaterialID=W.FProductID ").append('\n').append("               LEFT JOIN T_BD_MeasureUnit MU ON Prd.FBaseUnit=MU.FID").append('\n').append("\t\t \t\tLEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Mat ON Mat.FMaterialID=W.FMaterialID ").append('\n').append("               LEFT JOIN T_BD_MeasureUnit MatMU ON Mat.FBaseUnit=MatMU.FID").append('\n').append("               WHERE W.FCompanyID = '").append(this._calcParam.companyId).append("' AND W.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("\t               AND W.FProductID = currInfo.FMaterialID AND W.FProdBatchNo = NVL(currInfo.FMatBatchNo,' ')").append('\n').append("               ; ").append('\n').append("\t\t \tend if; --end of \u6ca1\u6709\u671f\u521d\u7cfb\u6570\u4e14\u662f\u53c2\u4e0e\u8fd8\u539f\u7684\u534a\u6210\u54c1\u65f6\uff0c\u53d6\u671f\u521d\u5e93\u5b58\u7cfb\u6570").append('\n').append("\t\t \tif (currInfo.FHasCoef = 1 OR currInfo.FHasCoef2 = 1)then").append('\n').append("\t\t \t\t--\u7b2c\u4e00\u5c42\u8c03\u5dee").append('\n').append("\t\t\t\tUPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" SET FAfterAmount=((FAfterAmount + currInfo.FMatAmount - ").append('\n').append("\t\t\t\t\t(SELECT NVL(SUM(S.FAfterAmount),0.00) ").append('\n').append("\t\t\t\t\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S").append('\n').append("\t\t\t\t\tWHERE S.FMaterialID is null AND FLayer=2 AND S.FDiffAdjustID=iDiffAdjustID )))").append('\n').append("\t\t\t\tWHERE FID =(").append('\n').append("\t\t\t\t\tSelect * FROM ( ").append('\n').append("\t\t\t\t\t\tSelect FID ").append('\n').append("\t\t\t\t\t\tFrom ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n').append("\t\t\t\t\t\tWHERE FMaterialID is null AND FLayer=2 AND FDiffAdjustID=iDiffAdjustID").append('\n').append("\t\t\t\t\t\tORDER BY FAfterAmount DESC ").append('\n').append("\t\t\t\t\t) ").append('\n').append("\t\t\t\t\tWHERE ROWNUM <= 1 ").append('\n').append("\t\t\t\t);").append("\t\t \t\t--\u7b2c\u4e8c\u5c42\u53ca\u4ee5\u4e0b\u5c42\u8c03\u5dee").append('\n').append("\t\t \t\tP_NCMRecoveryAdjustDiff_ByStep(2,iDiffAdjustID);").append('\n').append("\t\t\t\tUPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" SET FFinishedAmount = FAfterAmount ").append('\n').append("\t\t\t\tWHERE FDiffAdjustID=iDiffAdjustID; ").append('\n').append("\t\t \tend if; --end of \u8c03\u5dee\u7ed3\u675f ").append('\n').append("\t\t end if; --end of A.3,\u63d2\u5165\u672c\u5c42\u6750\u6599\u660e\u7ec6(\u5982\u679c\u6709\u65f6)").append('\n').append("\tend loop; ").append('\n').append("\tclose cur; ").append('\n').append("end; ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    private void adjustDiff_Mat(String sDiffAdjustID, String costCenterID, String costObjectID, String productID, String prodBatchNo, int layer, String branch) throws EASBizException, BOSException {
        IRowSet rs = this.GetAdjustDataByLayer(sDiffAdjustID, costCenterID, costObjectID, productID, prodBatchNo, layer, branch);
        try {
            StringBuffer sb = new StringBuffer();
            NumberFormat fm = NumberFormat.getInstance();
            fm.setGroupingUsed(false);
            while (rs.next()) {
                fm.setMaximumFractionDigits(12);
                String afterAmount = fm.format(BigDecimal.valueOf(0L));
                if (rs.getBigDecimal("FAfterAmount") != null) {
                    afterAmount = fm.format(rs.getBigDecimal("FAfterAmount"));
                }
                String finishedAmount = fm.format(BigDecimal.valueOf(0L));
                if (rs.getBigDecimal("FFinishedAmount") != null) {
                    finishedAmount = fm.format(rs.getBigDecimal("FFinishedAmount"));
                }
                String sBranch = rs.getString("FBranch");
                sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" SET FAfterAmount=").append('\n').append("(\tFAfterAmount + ").append(afterAmount).append('\n').append(" \t- ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAfterAmount),0.00) ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S").append('\n').append("\tWHERE S.FLayer=").append(String.valueOf(layer + 1)).append(" AND S.FDiffAdjustID=").append(sDiffAdjustID).append('\n');
                if (sBranch != null) {
                    sb.append("\t\tAND S.FBranch like '").append(sBranch).append("%'").append('\n');
                }
                sb.append("\t)").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n').append("\tWHERE FLayer=").append(String.valueOf(layer + 1)).append(" AND FDiffAdjustID=").append(sDiffAdjustID).append('\n');
                if (sBranch != null) {
                    sb.append("\t\tAND FBranch like '").append(sBranch).append("%'").append('\n');
                }
                sb.append("\tORDER BY FAfterAmount DESC ").append('\n').append(");");
                sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" SET FFinishedAmount=").append('\n').append("(\tFFinishedAmount + ").append(finishedAmount).append('\n').append(" \t- ").append('\n').append("\t(SELECT ISNULL(SUM(S.FFinishedAmount),0.00) ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S").append('\n').append("\tWHERE S.FLayer=").append(String.valueOf(layer + 1)).append(" AND S.FDiffAdjustID=").append(sDiffAdjustID).append('\n');
                if (sBranch != null) {
                    sb.append("\t\tAND S.FBranch like '").append(sBranch).append("%'").append('\n');
                }
                sb.append("\t)").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append('\n').append("\tWHERE FLayer=").append(String.valueOf(layer + 1)).append(" AND FDiffAdjustID=").append(sDiffAdjustID).append('\n');
                if (sBranch != null) {
                    sb.append("\t\tAND FBranch like '").append(sBranch).append("%'").append('\n');
                }
                sb.append("\tORDER BY FFinishedAmount DESC ").append('\n').append(");");
                if (sb.toString().length() > 0) {
                    NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
                    sb.delete(0, sb.length());
                }
                if (rs.getInt("FIsLeaf") != 0) continue;
                this.adjustDiff_Mat(sDiffAdjustID, rs.getString("FCostCenterID"), rs.getString("FCostObjectID"), rs.getString("FProductID"), rs.getString("FProdBatchNo"), layer + 1, rs.getString("FBranch"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected IRowSet GetAdjustDataByLayer(String sDiffAdjustID, String costCenterID, String costObjectID, String productID, String prodBatchNo, int layer, String branch) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        String tblBranchNode = this._calcParam.GetTBL_RecoveryTreeBranchNode();
        sb.append("Select S.FID,S.FCostCenterID,S.FCostObjectID,S.FProductID, S.FProdBatchNo,S.FIsLeaf,S.FAfterAmount, S.FFinishedAmount, ").append('\n').append("").append('\n').append("\tCASE WHEN  S.FMaterialID is null THEN S.FBranch ||'.'|| to_char(bnCI.FNodeID) ELSE S.FBranch ||'.'||to_char(bnPrd.FNodeID)END As FBranch ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S ").append('\n').append("LEFT JOIN ").append(tblBranchNode).append(" bnPrd ON bnPrd.FNodeStr=(S.FMaterialID || CASE WHEN S.FMatBatchNo<>N''THEN '").append("#@").append("'||S.FMatBatchNo ELSE N' ' END) ").append('\n').append("LEFT JOIN ").append(tblBranchNode).append(" bnCI ON bnCI.FNodeStr=S.FCostItemID ").append('\n').append("WHERE S.FIsLeaf=0 AND S.FDiffAdjustID=").append(sDiffAdjustID).append(" AND S.FLayer=").append(layer).append('\n');
        if (costCenterID != null) {
            sb.append("\tAND S.FCostCenterID='").append(costCenterID).append("'").append('\n');
        }
        if (costObjectID != null) {
            sb.append("\tAND S.FCostObjectID='").append(costObjectID).append("'").append('\n');
        }
        if (productID != null) {
            sb.append("\tAND S.FProductID='").append(productID).append("'").append('\n');
        }
        if (prodBatchNo != null) {
            sb.append("\tAND S.FProdBatchNo='").append(prodBatchNo).append("'").append('\n');
        }
        if (branch != null) {
            sb.append("\tAND S.FBranch like '").append(branch).append("%'").append('\n');
        }
        sb.append(";").append('\n');
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)sb.toString());
        return rs;
    }

    private void InnerGenerateRecoveryReport_Common(StringBuffer sb) throws EASBizException, BOSException {
        sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" SET FPeriodDispNumber=").append(this._calcParam.periodDispNumber).append(" ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" As D SET (FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,FQtyDecimal,FPriceDecimal)=(").append('\n').append("\tSelect Prd.FNumber As FProductNumber,Prd.FName As FProductName,S.FProdBatchNo,Prd.FModel As FProductModel,MU.FName_").append(this._calcParam.locale).append(" As FProductUnitName,").append('\n').append("\t\tMUltMU.FQtyPrecision As FQtyDecimal,Prd.FPricePrecision As FPriceDecimal ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S ").append('\n').append("\tLEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Prd ON Prd.FmaterialID=S.FProductID ").append('\n').append("\tLEFT JOIN T_BD_MeasureUnit MU ON Prd.FBaseUnit=MU.FID").append('\n').append("   LEFT JOIN T_BD_MultiMeasureUnit MUltMU ON MUltMU.FMeasureUnitID=Prd.FBaseUnit and MUltMU.FMaterialID = Prd.FmaterialID ").append('\n').append("\tWHERE S.FID=D.FID ").append('\n').append(") ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" As D SET (FCostItemGroupID,FCostItemGroupNumber,FCostItemGroupName,FCostItemNumber,FCostItemName,FItemType)=(").append('\n').append("\tSelect CIT.FID As FCostItemGroupID,CIT.FNumber As FCostItemGroupNumber,CIT.FName_").append(this._calcParam.locale).append(" As FCostItemGroupName,").append('\n').append("\t\tCI.FNumber As FCostItemNumber,CI.FName_").append(this._calcParam.locale).append(" As FCostItemName,to_int(CI.FItemType) ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S ").append('\n').append("\tLEFT JOIN T_NCM_CostItem CI ON CI.FID=S.FCostItemID ").append('\n').append("\tLEFT JOIN t_Ncm_Costitemtypetree CIT ON CIT.FID=CI.FTypeTreeID ").append('\n').append("\tWHERE S.FID=D.FID ").append('\n').append(") ").append('\n').append("WHERE D.FCostItemID is not null ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" As D SET (FMaterialNumber,FMaterialName,FMatBatchNo,FMaterielModel,FMaterielUnitName,FQtyDecimal,FPriceDecimal)=(").append('\n').append("\tSelect Mat.FNumber As FMaterialNumber,Mat.FName As FMaterialName,S.FMatBatchNo,Mat.FModel As FMaterielModel,MatMU.FName_").append(this._calcParam.locale).append(" As FMaterielUnitName, ").append('\n').append("\t\tMUltMU.FQtyPrecision As FQtyDecimal,Mat.FPricePrecision As FPriceDecimal ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S ").append('\n').append("\tLEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" Mat ON Mat.FmaterialID=S.FMaterialID ").append('\n').append("\tLEFT JOIN T_BD_MeasureUnit MatMU ON Mat.FBaseUnit=MatMU.FID").append('\n').append("   LEFT JOIN T_BD_MultiMeasureUnit MUltMU ON MUltMU.FMeasureUnitID=Mat.FBaseUnit and MUltMU.FMaterialID = Mat.FmaterialID ").append('\n').append("\tWHERE S.FID=D.FID ").append('\n').append(") ").append('\n').append("WHERE D.FMaterialID is not null ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" As D SET FQtyDecimal=(").append('\n').append("\tSelect max(FQtyDecimal) ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S ").append('\n').append("\tWHERE D.FProductID = S.FProductID and D.FCostItemID = S.FCostItemID").append('\n').append(") ").append('\n').append("WHERE  D.FMaterialID is null ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" As D SET FQtyDecimal=(").append('\n').append("\tSelect max(FQtyDecimal) ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S ").append('\n').append("\tWHERE D.FProductID = S.FProductID ").append('\n').append(") ").append('\n').append("WHERE D.FCostItemID is null ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" As D SET (FAmountDecimal)=(").append('\n').append("\tSelect CY.FPrecision As FAmountDecimal ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S ").append('\n').append("\tLEFT JOIN T_ORG_Company CMP ON CMP.FID=S.FCompanyID ").append('\n').append("\tLEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append("\tWHERE S.FID=D.FID ").append('\n').append(") ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
    }

    private void InnerGenerateRecoveryReport_ToStep() throws EASBizException, BOSException {
        ArrayList<SortInfo> sortInfoForUpdate = new ArrayList<SortInfo>();
        StringBuffer sb = new StringBuffer();
        String lastCostCenterID = "";
        String lastCostObjectID = "";
        String lastProductID = "";
        String lastProdBatchNo = "";
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        IRowSet rs = this.GetInnerReportDataByLayer(null, null, null, null, 0, null);
        try {
            while (rs.next()) {
                if (lastCostCenterID.compareTo(rs.getString("FCostCenterID")) != 0 || lastCostObjectID.compareTo(rs.getString("FCostobjectId")) != 0 || lastProductID.compareTo(rs.getString("FProductID")) != 0 || lastProdBatchNo.compareTo(rs.getString("FProdBatchNo")) != 0) {
                    this.sort = 0;
                    lastCostCenterID = rs.getString("FCostCenterID");
                    lastCostObjectID = rs.getString("FCostobjectId");
                    lastProductID = rs.getString("FProductID");
                    lastProdBatchNo = rs.getString("FProdBatchNo");
                }
                ++this.sort;
                sortInfoForUpdate.add(new SortInfo(rs.getString("FID"), null, this.sort));
                if (rs.getInt("FIsLeaf") != 0) continue;
                this.CalcDisplaySort(rs.getString("FCostCenterID"), rs.getString("FCostObjectID"), rs.getString("FProductID"), rs.getString("FProdBatchNo"), 1, rs.getString("FBranch"), rs.getString("FID"), sortInfoForUpdate);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.UpdateSortInfo(sortInfoForUpdate);
        sb.append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" As D SET (FFinishedUnitQty,FFinishedUnitAmount)=(").append('\n').append("\tSelect Round(D.FFinishedQty/S.FFinishedQty, D.FQtyDecimal)As FFinishedUnitQty, ").append('\n').append("\tRound(D.FFinishedAmount/S.FFinishedQty, D.FPriceDecimal)As FFinishedUnitAmount ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S ").append('\n').append(" \tWHERE S.FCostItemID is null AND S.FMaterialID is null ").append('\n').append("\t\tAND S.FCostCenterID=D.FCostCenterID AND S.FCostObjectID = D.FCostObjectID AND S.FProductID=D.FProductID AND S.FProdBatchNo=D.FProdBatchNo AND S.FFinishedQty<>0 ").append('\n').append(") ").append('\n').append(";").append('\n').append("UPDATE ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" As D SET (FFinishedUnitRatio)=(").append('\n').append("\tSelect Round(D.FFinishedUnitAmount/S.FFinishedUnitAmount*100, D.FAmountDecimal)As FFinishedUnitRatio ").append('\n').append("\tFROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S ").append('\n').append(" \tWHERE S.FCostItemID is null AND S.FMaterialID is null ").append('\n').append("\t\tAND S.FCostCenterID=D.FCostCenterID AND S.FCostObjectID = D.FCostObjectID AND S.FProductID=D.FProductID AND S.FProdBatchNo=D.FProdBatchNo AND S.FFinishedUnitAmount<>0 ").append('\n').append(") ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
    }

    protected void SaveReportDataForByStep(StringBuffer sb, String tempTBL_CostRecoveryReport, String TBL_CostRecoveryReport) throws EASBizException, BOSException {
        sb.delete(0, sb.length());
        NCMDynamicTableManager.clearIndexsOfBusiTbl((Context)this._calcParam.ctx, (String)this._calcParam.companyId, (String)"T_NCM_CostRecoveryReportByStep");
        sb.append("INSERT INTO ").append(TBL_CostRecoveryReport).append("(FID ,FCompanyID ,FCalculatePeriodID,FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID, ").append('\n').append("FPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,").append('\n').append("FCostItemGroupNumber,FCostItemGroupName,").append('\n').append("FCostItemNumber,FCostItemName,").append('\n').append("FMaterialNumber,FMaterialName,FMatBatchNo,FMaterielModel,FMaterielUnitName,").append('\n').append("FFinishedQty,FFinishedAmount,").append('\n').append("FFinishedUnitQty,FFinishedUnitAmount,FFinishedUnitRatio,").append('\n').append("FQtyDecimal,FPriceDecimal,FAmountDecimal,FSort,").append('\n').append("FLayer, FDispLayer, FIsLeaf, FBranch, FParentID)").append('\n').append("SELECT newbosid('DFA50FD9')As FID, ").append('\n').append("\tFCompanyID ,FCalculatePeriodID,FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID, ").append('\n').append("\tFPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,").append('\n').append("\tisnull(FCostItemGroupNumber,' ')As FCostItemGroupNumber,isnull(FCostItemGroupName,' ')As FCostItemGroupName,").append('\n').append("\tisnull(FCostItemNumber, ' ')As FCostItemNumber,isnull(FCostItemName,' ')As FCostItemName,").append('\n').append("\tisnull(FMaterialNumber,' ')As FMaterialNumber,isnull(FMaterialName,' ')As FMaterialName,isnull(FMatBatchNo,' ')As FMatBatchNo,isnull(FMaterielModel,' ')As FMaterielModel,isnull(FMaterielUnitName,N' ')As FMaterielUnitName,").append('\n').append("\tsum(FFinishedQty),sum(FFinishedAmount),").append('\n').append("\tcase when sum(isnull(FTotalFinishedQty,0)) <> 0 then sum(FFinishedQty)/max(FTotalFinishedQty) else 0 end as  FFinishedUnitQty,").append('\n').append("   case when sum(isnull(FTotalFinishedQty,0)) <> 0 then sum(FFinishedAmount)/max(FTotalFinishedQty) else 0 end as FFinishedUnitAmount,0 FFinishedUnitRatio, ").append("\tmax(FQtyDecimal),max(FPriceDecimal),max(FAmountDecimal),max(FSort),").append('\n').append("\tFLayer, FDispLayer, FIsLeaf, Isnull(FBranch, ' '), FParentID ").append('\n').append("FROM  ").append(tempTBL_CostRecoveryReport).append('\n').append(" where FType <> 99").append('\n').append(" Group by FCompanyID ,FCalculatePeriodID,FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID,FMatBatchNo, ").append('\n').append("          FPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,").append('\n').append("\t       FCostItemGroupNumber,FCostItemGroupName,FCostItemNumber,FCostItemName,").append('\n').append("\t       FMaterialNumber,FMaterialName,FMaterielModel,FMaterielUnitName,").append('\n').append("          FLayer, FDispLayer, FIsLeaf, Isnull(FBranch, ' '), FParentID").append("\t       ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
    }

    private void CalcDisplaySort(String costCenterID, String costObjectID, String productID, String prodBatchNo, int layer, String branch, String parentID, ArrayList sortInfoForUpdate) throws EASBizException, BOSException {
        IRowSet rs = this.GetInnerReportDataByLayer(costCenterID, costObjectID, productID, prodBatchNo, layer, branch);
        try {
            while (rs.next()) {
                ++this.sort;
                sortInfoForUpdate.add(new SortInfo(rs.getString("FID"), parentID, this.sort));
                if (rs.getInt("FIsLeaf") != 0) continue;
                this.CalcDisplaySort(costCenterID, costObjectID, productID, prodBatchNo, layer + 1, rs.getString("FBranch"), rs.getString("FID"), sortInfoForUpdate);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void UpdateSortInfo(ArrayList sortInfoForUpdate) throws EASBizException, BOSException {
        block11: {
            PreparedStatement pstmt;
            block10: {
                if (sortInfoForUpdate.size() <= 0) {
                    return;
                }
                String sql = "UPDATE " + this._calcParam.GetTempTBL_CostRecoveryReport() + " SET FSort=?,FParentID=? WHERE FID=? ";
                Connection conn = null;
                pstmt = null;
                boolean isNewConn = false;
                try {
                    if (this._calcParam.get_conn() == null) {
                        conn = EJBFactory.getConnection((Context)this._calcParam.ctx);
                        isNewConn = true;
                    } else {
                        conn = this._calcParam.get_conn();
                    }
                    pstmt = conn.prepareStatement(sql);
                    for (int i = 0; i < sortInfoForUpdate.size(); ++i) {
                        SortInfo item = (SortInfo)sortInfoForUpdate.get(i);
                        pstmt.setInt(1, item.get_sort());
                        pstmt.setString(2, item.get_parentID());
                        pstmt.setString(3, item.get_id());
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    pstmt.close();
                    if (!isNewConn) break block10;
                }
                catch (SQLException e) {
                    try {
                        throw new SQLDataException(e);
                    }
                    catch (Throwable throwable) {
                        if (isNewConn) {
                            SQLUtils.cleanup(pstmt, conn);
                        } else {
                            SQLUtils.cleanup(pstmt);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                break block11;
            }
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    private void GroupToByEnd(StringBuffer sb, String tempTBL_CostRecoveryReportByEnd) throws EASBizException, BOSException {
        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append("(FID ,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID , FProductID, FProdBatchNo, FCostItemID,FMaterialID, FMatBatchNo,").append('\n').append("FBeforeQty,FBeforeAmount,").append('\n').append("FBeforeQtyEx,FBeforeAmountEx,").append('\n').append("FAfterQty,FAfterAmount,").append('\n').append("FAfterQtyEx,FAfterAmountEx,").append('\n').append("FIsLeaf,FType)").append('\n').append("SELECT newbosid('DFA50FD9')As FID,D.FCompanyID,D.FCalculatePeriodID,D.FCostCenterID,D.FCostObjectID,D.FProductID,D.FProdBatchNo, ").append('\n').append("\tD.FCostItemID,D.FMaterialID,D.FMatBatchNo,").append('\n').append("\tSUM(D.FBeforeQty)As FBeforeQty, SUM(D.FBeforeAmount)As FBeforeAmount,").append('\n').append("\tMAX(D.FBeforeQtyEx)As FBeforeQtyEx, SUM(D.FBeforeAmountEx)As FBeforeAmountEx,").append('\n').append("\tSUM(D.FAfterQty)As FAfterQty,SUM(D.FAfterAmount)As FAfterAmount,").append('\n').append("\tSUM(D.FAfterQtyEx)As FAfterQtyEx,MAX(D.FAfterAmountEx)As FAfterAmountEx,").append('\n').append("\tMIN(D.FIsLeaf)As FIsLeaf,99 As FType ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" D ").append('\n').append("LEFT JOIN T_NCM_CostItem CI ON CI.FID=D.FCostItemID ").append('\n').append("INNER JOIN (SELECT FCostObjectID,MAX(FDisplayer) MaxDisplayer from ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" group by FCostObjectID ) T on T.FCostObjectID = D.FCostObjectID").append('\n').append("LEFT JOIN (SELECT FCostObjectID,fcostitemid,MAX(fisleaf) Maxisleaf from ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" group by FCostObjectID,fcostitemid ) T1 on T1.FCostObjectID = D.FCostObjectID and D.fcostitemid = T1.fcostitemid").append('\n').append("WHERE D.FType<>99 AND ((D.FDispLayer in(0,1)) OR (D.FLayer>1 AND D.FIsLeaf=1) OR (D.FLayer>1 AND CI.FItemType='1' AND D.FMaterialID is null AND (T.MaxDisplayer =D.Fdisplayer OR T1.maxisleaf= 1 )))").append('\n').append("GROUP BY D.FCompanyID,D.FCalculatePeriodID,D.FCostCenterID,D.FCostObjectID,D.FProductID,D.FProdBatchNo,").append('\n').append("\tD.FCostItemID,D.FMaterialID,D.FMatBatchNo ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        this.InnerGenerateRecoveryReport_Common(sb);
        sb.append("INSERT INTO ").append(tempTBL_CostRecoveryReportByEnd).append("(FID ,FCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID, ").append('\n').append("FPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,").append('\n').append("FCostItemGroupNumber,FCostItemGroupName,").append('\n').append("FCostItemNumber,FCostItemName,").append('\n').append("FMaterialNumber,FMaterialName,FMatBatchNo,FMaterielModel,FMaterielUnitName,").append('\n').append("FBeforeQty,FBeforeAmount,").append('\n').append("FBeforeQtyEx,FBeforeAmountEx,").append('\n').append("FAfterQty,FAfterAmount,").append('\n').append("FAfterQtyEx,FAfterAmountEx,").append('\n').append("FQtyDecimal,FPriceDecimal,FAmountDecimal,FItemType,FLayer,FIsLeaf,FType)").append('\n').append("SELECT newbosid('DFA50FD9')As FID, ").append('\n').append("\tFCompanyID ,FCalculatePeriodID,FCostCenterID, FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID, ").append('\n').append("\tFPeriodDispNumber,FProductNumber,FProductName,isnull(FProdBatchNo,' '),FProductModel,FProductUnitName,").append('\n').append("\tisnull(FCostItemGroupNumber,' ')As FCostItemGroupNumber,isnull(FCostItemGroupName,' ')As FCostItemGroupName,").append('\n').append("\tisnull(FCostItemNumber,' ')As FCostItemNumber,isnull(FCostItemName,' ')As FCostItemName,").append('\n').append("\tisnull(FMaterialNumber,' ')As FMaterialNumber,isnull(FMaterialName,' ')As FMaterialName,isnull(FMatBatchNo,' ')As FMatBatchNo,isnull(FMaterielModel,' ')As FMaterielModel,isnull(FMaterielUnitName,N' ')As FMaterielUnitName,").append('\n').append("\tFBeforeQty,FBeforeAmount,").append('\n').append("\tFBeforeQtyEx,FBeforeAmountEx,").append('\n').append("\tFAfterQty,FAfterAmount,").append('\n').append("\tFAfterQtyEx,FAfterAmountEx,").append('\n').append("\tFQtyDecimal,FPriceDecimal,FAmountDecimal,FItemType,FLayer,FIsLeaf,FType ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempTBL_CostRecoveryReportByEnd, (String)"FID", (boolean)true, (boolean)true);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempTBL_CostRecoveryReportByEnd, (String)"FCostCenterID,FCostObjectID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempTBL_CostRecoveryReportByEnd, (String)"FProductID,FProdBatchNo", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempTBL_CostRecoveryReportByEnd, (String)"FCostItemGroupID,FCostItemID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempTBL_CostRecoveryReportByEnd, (String)"FMaterialID,FMatBatchNo", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempTBL_CostRecoveryReportByEnd, (String)"FDiffAdjustID,FLayer", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)tempTBL_CostRecoveryReportByEnd, (String)"FProductID,FProdBatchNo,FCostItemID,FMaterialID,FCostCenterID", (boolean)false, (boolean)false);
    }

    @Override
    public void GenerateRecoveryVourchData() throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        String tempTBL_CostRecoveryReportByEnd = this._calcParam.GetTempTBL_CostRecoveryReport_BySpecified(true);
        sb.append("truncate table ").append(tempTBL_CostRecoveryReportByEnd).append(";").append('\n').append("truncate table ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        this.RecoveryStockInByAll(true);
        this.GroupToByEnd(sb, tempTBL_CostRecoveryReportByEnd);
        this.ProcessReportDataForByEnd(sb, tempTBL_CostRecoveryReportByEnd, tempTBL_CostRecoveryReportByEnd, true);
        this.SaveVourchDataFromByEndReport(sb, tempTBL_CostRecoveryReportByEnd, this._calcParam.GetTBL_CostRecoveryVourchData());
    }

    @Override
    public void EndProcess() throws EASBizException, BOSException {
        super.EndProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void InsertBoPWipPart(StringBuffer sb) throws EASBizException, BOSException {
        String tblBalance = this.dataCache.getBalanceTable();
        String tblBalanceEntry = this.dataCache.getBalanceEntryTable();
        String tblBalanceMatDetail = this.dataCache.getBalanceMatDetailTable();
        String tblBopWIPCoef = this.dataCache.getBopWIPCoefTable();
        String T_NCM_balaData = null;
        StringBuffer ksql = new StringBuffer();
        try {
            ksql.setLength(0);
            ksql.append("create table T ( \n");
            ksql.append("    FCostObjectID VARCHAR(44), \n");
            ksql.append("    FProductID VARCHAR(44), \n");
            ksql.append("    FProdBatchNo VARCHAR(44), \n");
            ksql.append("    FCostItemID VARCHAR(44), \n");
            ksql.append("    FMaterialID VARCHAR(44), \n");
            ksql.append("    FMatBatchNo NVARCHAR(80), \n");
            ksql.append("    FQty NUMERIC(21,8), \n");
            ksql.append("    FAmount NUMERIC(17,4) \n");
            ksql.append(") \n");
            T_NCM_balaData = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append(" Insert Into ").append(T_NCM_balaData).append('\n');
            ksql.append("       (FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo,FQty,FAmount)").append('\n');
            ksql.append(" Select DISTINCT bal.FCostObjectID,OBJ.FProductID As FProductID,ISNULL(OBJ.FCostObjBatchNo,N' ')As FProdBatchNo,").append('\n');
            ksql.append("        balMat.FCostItemID,balMatDetail.FMaterialID, ISNULL(O.FCostObjBatchNo,N' ')As FMatBatchNo, ").append('\n');
            ksql.append("        SUM(balMatDetail.FQty)As FQty,SUM(balMatDetail.FAmount)As FAmount").append('\n');
            ksql.append("   FROM ").append(tblBalanceMatDetail).append(" balMatDetail ").append('\n');
            ksql.append("   INNER JOIN ").append(tblBalanceEntry).append(" balMat ON balMat.FID=balMatDetail.FParentID ").append('\n');
            ksql.append("   INNER JOIN ").append(tblBalance).append(" bal ON bal.FID=balMat.FParentID ").append('\n');
            ksql.append("   INNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ON CO.FCostObjectID=bal.FCostObjectID").append('\n');
            ksql.append("   INNER JOIN ").append(this._calcParam.GetTempTblMaterialComp()).append(" mat ON mat.FMaterialID = balMatDetail.FMaterialID AND mat.FCalculateType=2 ").append('\n');
            if (!this._calcParam.isRevertAllProduct) {
                ksql.append("   INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON mcst.FMaterialID = balMatDetail.FMaterialID AND mcst.FIsParticipateReduct=1 ").append('\n');
            }
            ksql.append("   LEFT JOIN ").append(this._calcParam.GetTempTblCostObjectBase()).append(" OBJ ON OBJ.FCostObjectID=bal.FCostObjectID ").append('\n');
            ksql.append("   LEFT JOIN ").append(this._calcParam.GetTempTblCostObjectLot()).append(" O ").append('\n');
            ksql.append("     ON O.FProductId=balMatDetail.FMaterialID AND isnull(O.FProdBatchNo,' ')=isnull(balMatDetail.FBatchNo,' ') ").append('\n');
            ksql.append("   GROUP BY bal.FCostObjectID,OBJ.FProductID,OBJ.FCostObjBatchNo,balMat.FCostItemID,balMatDetail.FMaterialID, O.FProdBatchNo,O.FCostObjBatchNo ").append('\n');
            ksql.append("   HAVING SUM(balMatDetail.FQty) <>0 ").append('\n');
            NCMDbUtil.execute((Context)this._calcParam.ctx, (String)ksql.toString());
            NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_balaData, (String)"FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo", (boolean)false, (boolean)false);
            sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo,FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FSubProdQty,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("Select newbosid('DFA50FD9')As FID,M.FCostObjectID,M.FProductID,M.FProdBatchNo,M.FCostItemID As FSubCostItemID,S.FSubCostObjID, S.FSubProductID, S.FSubProdBatchNo,").append('\n').append("\tS.FCostItemID, S.FMaterialID,S.FMatBatchNo,").append('\n').append("\tM.FQty As FSubProdQty,to_decimal(M.FAmount * S.FAmtCoef,24,12) As FAmtCoef,to_decimal(M.FQty * S.FQtyCoef,24,12)As FQtyCoef,").append('\n').append("\tS.FLayer,S.FDispLayer, S.FIsLeaf,S.FBranch,11 As FType ").append('\n').append("FROM ").append(T_NCM_balaData).append(" M ").append('\n').append("INNER JOIN ").append(tblBopWIPCoef).append(" S ").append('\n').append("   ON  S.FProductID=M.FProductID AND isnull(S.FProdBatchNo,' ')=isnull(M.FProdBatchNo,' ') AND S.FSubCostItemID =M.FCostItemID ").append('\n').append("\tAND S.FSubProductID=M.FMaterialID AND isnull(S.FSubProdBatchNo,' ')=isnull(M.FMatBatchNo,' ')").append('\n').append("\tAND S.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n');
            if (!this._calcParam.isRevertAllProduct) {
                sb.append("INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON  mcst.FMaterialID = M.FProductID AND mcst.FIsParticipateReduct=1").append('\n');
            }
            sb.append(";").append('\n');
            NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
            sb.setLength(0);
        }
        catch (Throwable throwable) {
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, T_NCM_balaData);
            throw throwable;
        }
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)T_NCM_balaData);
    }

    protected void InsertInputPartNew(StringBuffer sb) throws EASBizException, BOSException {
        String tblCostCalResult = this._calcParam.GetTBL_CostCalResult();
        String tblCostCalMatDetailResult = this._calcParam.GetTBL_CostCalMatDetailResult();
        String tblBalance = this._calcParam.GetTBL_Balance();
        String tblBalanceEntry = this._calcParam.GetTBL_BalanceEntry();
        String tblBalanceMatDetail = this._calcParam.GetTBL_BalanceMatDetail();
        sb.append("delete from " + this._calcParam.GetTempTblInputData());
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        sb.append("Insert into " + this._calcParam.GetTempTblInputData()).append('\n');
        sb.append(" (FID,FCostObjectID,FSubCostItemID,FSubProductID,FSubProdBatchNo,FQty,FAmount)").append('\n');
        sb.append("\tSELECT newbosid('DFA50FD9') FID,CC.FCostObjectID,CCMat.FCostItemID As FSubCostItemID,CCMat.FMaterialID As FSubProductID,ISNULL(O.FCostObjBatchNo,N' ') As FSubProdBatchNo, ").append('\n');
        sb.append("\t\tSUM(CCMat.FFinishedQty+CCMat.FEoPWIPQty)As FQty,SUM(CCMat.FFinishedAmount+CCMat.FEoPWIPAmount)As FAmount").append('\n');
        sb.append("\tFROM ").append(tblCostCalResult).append(" CC ").append('\n');
        sb.append("\tINNER JOIN ").append(tblCostCalMatDetailResult).append(" CCMat ").append('\n');
        sb.append("\t\t  ON  CC.FCostCenterID=CCMat.FCostCenterID AND CC.FCostObjectID=CCMat.FCostObjectID AND CC.FCostItemID=CCMat.FCostItemID ").append('\n');
        sb.append("\tINNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ON CO.FCostObjectID=CC.FCostObjectID").append('\n');
        sb.append(" INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON mcst.FOrgUnit=CC.FCompanyID AND mcst.FMaterialID = CCMat.FMaterialID ").append('\n');
        sb.append(" Left Join ").append(this._calcParam.GetTempTblCostObjectLot()).append(" O ").append('\n');
        sb.append("\t      ON O.FProductId=CCMat.FMaterialID AND isnull(O.FProdBatchNo,' ')=isnull(CCMat.FLot,' ')  ").append('\n');
        sb.append("\tGROUP BY CC.FCostObjectID,CCMat.FCostItemID,CCMat.FMaterialID,O.FProdBatchNo,O.FCostObjBatchNo ").append('\n');
        sb.append("").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblInputData());
        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo,FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FSubProdQty,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("Select newbosid('DFA50FD9')As FID,O.FCostObjectID,O.FProductID,O.FProdBatchNo,M.FSubCostItemID,S.FCostObjectID As FSubCostObjID, S.FProductID As FSubProductID, S.FProdBatchNo As FSubProdBatchNo,S.FCostItemID,S.FMaterialID,S.FMatBatchNo,").append('\n').append("\t(M.FQty-ISNULL(B.FQty,0))As FSubProdQty,to_decimal((M.FAmount-ISNULL(B.FAmount,0)) * S.FAmtCoef,24,12) As FAmtCoef,to_decimal((M.FQty-ISNULL(B.FQty,0)) * S.FQtyCoef,24,12)As FQtyCoef, ").append('\n').append("\tS.FLayer,(S.FDispLayer+1)As FDispLayer,S.FIsLeaf,S.FBranch,22 As FType ").append('\n').append("FROM ").append(this._calcParam.GetTempTblInputData()).append(" M ").append('\n').append("LEFT JOIN (").append('\n').append("\tSELECT bal.FCostObjectID,balMat.FCostItemID As FSubCostItemID,balMatDetail.FMaterialID As FSubProductID, ISNULL(O.FProdBatchNo,N' ')As FSubProdBatchNo, ").append('\n').append("\t\tSUM(balMatDetail.FQty)As FQty,SUM(balMatDetail.FAmount)As FAmount").append('\n').append("\tFROM ").append(tblBalanceMatDetail).append(" balMatDetail ").append('\n').append("\tINNER JOIN ").append(tblBalanceEntry).append(" balMat ON balMat.FID=balMatDetail.FParentID ").append('\n').append("\tINNER JOIN ").append(tblBalance).append(" bal ON bal.FID=balMat.FParentID ").append('\n').append("\tINNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ON CO.FCostObjectID=bal.FCostObjectID").append('\n').append("   INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON  mcst.FMaterialID = balMatDetail.FMaterialID ").append('\n').append("   Left Join ").append(this._calcParam.GetTempTblCostObjectLot()).append(" O ").append('\n').append("\t     ON O.FProductId=balMatDetail.FMaterialID AND isnull(O.FProdBatchNo,' ')=isnull(balMatDetail.FBatchNo,' ')  ").append('\n').append("\tGROUP BY bal.FCostObjectID,balMat.FCostItemID,balMatDetail.FMaterialID, O.FProdBatchNo ").append('\n').append(")B ON M.FCostObjectID=B.FCostObjectID AND M.FSubCostItemID=B.FSubCostItemID AND M.FSubProductID=B.FSubProductID AND isnull(M.FSubProdBatchNo,' ')=isnull(B.FSubProdBatchNo,' ') ").append('\n').append("LEFT JOIN ").append(this._calcParam.GetTempTblCostObjectLot()).append(" O ON O.FCostObjectID=M.FCostObjectID ").append('\n').append("INNER JOIN ").append(this._calcParam.GetTBL_BopInvCoef()).append(" S ON S.FProductID=M.FSubProductID AND isnull(S.FProdBatchNo,' ')=isnull(M.FSubProdBatchNo,' ')  ").append('\n').append("\tAND S.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append("INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON mcst.FMaterialID = O.FProductID ").append('\n');
        }
        sb.append("WHERE (M.FAmount-ISNULL(B.FAmount,0))<>0 AND (M.FQty-ISNULL(B.FQty,0))<>0 ").append('\n').append(";").append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void InsertInputPart(StringBuffer sb) throws EASBizException, BOSException {
        String T_NCM_TotalBalaData;
        block8: {
            String tblCostCalResult = this.dataCache.getCostCalResultTable();
            String tblCostCalMatDetailResult = this.dataCache.getCostCalMatDetailResultTable();
            String tblBalance = this.dataCache.getBalanceTable();
            String tblBalanceEntry = this.dataCache.getBalanceEntryTable();
            String tblBalanceMatDetail = this.dataCache.getBalanceMatDetailTable();
            String T_NCM_TotalInputData = null;
            T_NCM_TotalBalaData = null;
            try {
                StringBuffer ksql = new StringBuffer();
                ksql.setLength(0);
                ksql.append("create table T ( \n");
                ksql.append("    FCostObjectID VARCHAR(44), \n");
                ksql.append("    FSubCostItemID VARCHAR(44), \n");
                ksql.append("    FSubProductID VARCHAR(44), \n");
                ksql.append("    FSubProdBatchNo VARCHAR(80), \n");
                ksql.append("    FQty NUMERIC(28,10), \n");
                ksql.append("    FAmount NUMERIC(17,4) \n");
                ksql.append(") \n");
                T_NCM_TotalInputData = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)ksql.toString());
                ksql.setLength(0);
                ksql.append(" Insert Into ").append(T_NCM_TotalInputData).append('\n');
                ksql.append("       (FCostObjectID,FSubCostItemID,FSubProductID,FSubProdBatchNo,FQty,FAmount)").append('\n');
                ksql.append("   SELECT CC.FCostObjectID,CCMat.FCostItemID As FSubCostItemID,CCMat.FMaterialID As FSubProductID,ISNULL(O.FCostObjBatchNo,N' ') As FSubProdBatchNo, ").append('\n');
                ksql.append("       SUM(CCMat.FFinishedQty+CCMat.FEoPWIPQty)As FQty,SUM(CCMat.FFinishedAmount+CCMat.FEoPWIPAmount)As FAmount").append('\n');
                ksql.append("   FROM ").append(tblCostCalResult).append(" CC ").append('\n');
                ksql.append("   INNER JOIN ").append(tblCostCalMatDetailResult).append(" CCMat ").append('\n');
                ksql.append("        ON CC.FCostCenterID=CCMat.FCostCenterID AND CC.FCostObjectID=CCMat.FCostObjectID AND CC.FCostItemID=CCMat.FCostItemID ").append('\n');
                ksql.append("   Left Join ").append(this._calcParam.GetTempTblCostObjectLot()).append(" O ").append('\n');
                ksql.append("        ON O.FProductId=CCMat.FMaterialID AND isnull(O.FProdBatchNo,' ')=isnull(CCMat.FLot,' ')  ").append('\n');
                ksql.append("   WHERE exists (select 'x' from ").append(this._calcParam.GetTempTBL_CostObjList()).append(" co \n");
                ksql.append("                   where CO.FCostObjectID = CC.FCostObjectID) \n");
                if (!this._calcParam.isRevertAllProduct) {
                    ksql.append("     and exists(select 'x' from ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst \n");
                    ksql.append("                  where mcst.FMaterialID = CCMat.FMaterialID and mcst.FISPARTICIPATEREDUCT = 1) \n");
                }
                ksql.append("   GROUP BY CC.FCostObjectID,CCMat.FCostItemID,CCMat.FMaterialID,O.FProdBatchNo,O.FCostObjBatchNo ").append('\n');
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)ksql.toString());
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_TotalInputData, (String)"FCostObjectID,FSubCostItemID,FSubProductID,FSubProdBatchNo", (boolean)false, (boolean)false);
                ksql.setLength(0);
                ksql.append("create table T ( \n");
                ksql.append("    FCostObjectID VARCHAR(44), \n");
                ksql.append("    FSubCostItemID VARCHAR(44), \n");
                ksql.append("    FSubProductID VARCHAR(44), \n");
                ksql.append("    FSubProdBatchNo VARCHAR(80), \n");
                ksql.append("    FQty NUMERIC(28,10), \n");
                ksql.append("    FAmount NUMERIC(17,4) \n");
                ksql.append(") \n");
                T_NCM_TotalBalaData = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)ksql.toString());
                ksql.setLength(0);
                ksql.append(" Insert Into ").append(T_NCM_TotalBalaData).append('\n');
                ksql.append("       (FCostObjectID,FSubCostItemID,FSubProductID,FSubProdBatchNo,FQty,FAmount)").append('\n');
                ksql.append("   SELECT bal.FCostObjectID,balMat.FCostItemID As FSubCostItemID,balMatDetail.FMaterialID As FSubProductID, ISNULL(O.FProdBatchNo,N' ')As FSubProdBatchNo, ").append('\n');
                ksql.append("       SUM(balMatDetail.FQty)As FQty,SUM(balMatDetail.FAmount)As FAmount").append('\n');
                ksql.append("   FROM ").append(tblBalanceMatDetail).append(" balMatDetail ").append('\n');
                ksql.append("   INNER JOIN ").append(tblBalanceEntry).append(" balMat ON balMat.FID=balMatDetail.FParentID ").append('\n');
                ksql.append("   INNER JOIN ").append(tblBalance).append(" bal ON bal.FID=balMat.FParentID ").append('\n');
                ksql.append("   Left Join ").append(this._calcParam.GetTempTblCostObjectLot()).append(" O ").append('\n');
                ksql.append("        ON O.FProductId=balMatDetail.FMaterialID AND isnull(O.FProdBatchNo,' ')=isnull(balMatDetail.FBatchNo,' ')  ").append('\n');
                ksql.append("   WHERE exists (select 'x' from ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO \n");
                ksql.append("                   where CO.FCostObjectID = bal.FCostObjectID) \n");
                if (!this._calcParam.isRevertAllProduct) {
                    ksql.append("     and exists (select 'x' from T_BD_MaterialCost mcst \n");
                    ksql.append("                   where mcst.FMaterialID = balMatDetail.FMaterialID and mcst.FISPARTICIPATEREDUCT = 1) \n");
                }
                ksql.append("   GROUP BY bal.FCostObjectID,balMat.FCostItemID,balMatDetail.FMaterialID, O.FProdBatchNo ").append('\n');
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)ksql.toString());
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_TotalBalaData, (String)"FCostObjectID,FSubCostItemID,FSubProductID,FSubProdBatchNo", (boolean)false, (boolean)false);
                sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo,FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FSubProdQty,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("Select newbosid('DFA50FD9')As FID,O.FCostObjectID,O.FProductID,isnull(O.FCostObjBatchNo,' '),M.FSubCostItemID,S.FCostObjectID As FSubCostObjID, S.FProductID As FSubProductID, isnull(S.FProdBatchNo,' ') As FSubProdBatchNo,S.FCostItemID,S.FMaterialID,S.FMatBatchNo,").append('\n').append("\t(M.FQty-ISNULL(B.FQty,0))As FSubProdQty,to_decimal((M.FAmount-ISNULL(B.FAmount,0)) * S.FAmtCoef,24,12) As FAmtCoef,to_decimal((M.FQty-ISNULL(B.FQty,0)) * S.FQtyCoef,24,12)As FQtyCoef, ").append('\n').append("\tS.FLayer,(S.FDispLayer+1)As FDispLayer,S.FIsLeaf,S.FBranch,22 As FType ").append('\n').append("FROM ").append(T_NCM_TotalInputData).append(" M ").append('\n').append("LEFT JOIN ").append(T_NCM_TotalBalaData).append(" B ").append('\n').append("    ON M.FCostObjectID=B.FCostObjectID AND M.FSubCostItemID=B.FSubCostItemID ").append('\n').append("      AND M.FSubProductID=B.FSubProductID AND isnull(M.FSubProdBatchNo,' ')=isnull(B.FSubProdBatchNo,' ')").append('\n').append("LEFT JOIN ").append(this._calcParam.GetTempTblCostObjectBase()).append(" O ON O.FCostObjectID=M.FCostObjectID ").append('\n').append("INNER JOIN ").append(this.dataCache.getBopInvCoefTable()).append(" S ON S.FProductID=M.FSubProductID AND isnull(S.FProdBatchNo,' ')=isnull(M.FSubProdBatchNo,' ')  ").append('\n').append("\tAND S.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n');
                if (!this._calcParam.isRevertAllProduct) {
                    sb.append("INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON mcst.FMaterialID = O.FProductID AND mcst.FIsParticipateReduct=1 ").append('\n');
                }
                sb.append("WHERE (M.FAmount-ISNULL(B.FAmount,0))<>0 AND (M.FQty-ISNULL(B.FQty,0))<>0 ").append('\n').append(";").append('\n');
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
                sb.setLength(0);
                if (T_NCM_TotalInputData == null) break block8;
            }
            catch (Throwable throwable) {
                if (T_NCM_TotalInputData != null) {
                    NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, T_NCM_TotalInputData);
                }
                if (T_NCM_TotalBalaData != null) {
                    NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, T_NCM_TotalBalaData);
                }
                throw throwable;
            }
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)T_NCM_TotalInputData);
        }
        if (T_NCM_TotalBalaData != null) {
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)T_NCM_TotalBalaData);
        }
    }

    @Override
    protected void MergeProdCoef(StringBuffer sb) throws EASBizException, BOSException {
        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo,FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FSubProdQty,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("SELECT newbosid('DFA50FD9')As FID,D.FCostObjectID,D.FProductID,D.FProdBatchNo,D.FSubCostItemID,D.FSubCostObjID,D.FSubProductID,D.FSubProdBatchNo, ").append('\n').append("       D.FCostItemID,D.FMaterialID,D.FMatBatchNo,SUM(D.FSubProdQty)As FSubProdQty,SUM(D.FAmtCoef)As FAmtCoef, SUM(D.FQtyCoef)As FQtyCoef, ").append('\n').append("       D.FLayer,MAX(D.FDispLayer)As FDispLayer,MIN(FIsLeaf)As FIsLeaf,D.FBranch,1 As FType").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append(" D ").append('\n').append("WHERE D.FType<>1 ").append('\n').append("GROUP BY D.FCostObjectID,D.FProductID,D.FProdBatchNo,D.FSubCostItemID,D.FSubCostObjID,D.FSubProductID,D.FSubProdBatchNo, ").append('\n').append("       D.FLayer,D.FBranch,D.FCostItemID,D.FMaterialID,D.FMatBatchNo ").append('\n').append(";").append('\n').append("DELETE FROM ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append(" WHERE FType<>1 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopWIPCoef(), (String)"FID", (boolean)true, (boolean)true);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopWIPCoef(), (String)"FCostObjectID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopWIPCoef(), (String)"FProductID,FProdBatchNo", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopWIPCoef(), (String)"FSubCostObjID,FSubProductID,FSubProdBatchNo", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopWIPCoef(), (String)"FBranch", (boolean)false, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void CalcProdCoef(StringBuffer sb) throws EASBizException, BOSException {
        StringBuffer ksql = new StringBuffer();
        String T_NCM_TotalData = null;
        try {
            ksql.setLength(0);
            ksql.append("create table T ( \n");
            ksql.append("    FProductID VARCHAR(44), \n");
            ksql.append("    FProdBatchNo VARCHAR(80), \n");
            ksql.append("    FSubCostItemID VARCHAR(44), \n");
            ksql.append("    FSubProductID VARCHAR(44), \n");
            ksql.append("    FSubProdBatchNo VARCHAR(80), \n");
            ksql.append("    FAmtCoef NUMERIC(24,12), \n");
            ksql.append("    FQtyCoef NUMERIC(24,12) \n");
            ksql.append(") \n");
            T_NCM_TotalData = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append(" Insert Into ").append(T_NCM_TotalData).append('\n');
            ksql.append("       (FProductID,FProdBatchNo,FSubCostItemID,FSubProductID,FSubProdBatchNo,FAmtCoef,FQtyCoef)").append('\n');
            ksql.append(" Select FProductID,FProdBatchNo,FSubCostItemID,FSubProductID,FSubProdBatchNo,").append('\n');
            ksql.append("        to_decimal(SUM(S.FAmtCoef),24,12),to_decimal(Max(S.FSubProdQty),24,12)").append('\n');
            ksql.append(" FROM ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append(" S ").append('\n');
            ksql.append(" Where FMaterialID is null AND FLayer=0 ").append('\n');
            ksql.append(" Group by FProductID,FProdBatchNo,FSubCostItemID,FSubProductID,FSubProdBatchNo").append('\n');
            NCMDbUtil.execute((Context)this._calcParam.ctx, (String)ksql.toString());
            NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_TotalData, (String)"FProductID,FProdBatchNo,FSubCostItemID,FSubProductID,FSubProdBatchNo", (boolean)false, (boolean)false);
            sb.append("UPDATE ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append(" AS D SET FAmtCoef=(").append('\n').append("\tSelect  ").append('\n').append(" \t\tcase when to_decimal(S.FAmtCoef,24,12)<>0 ").append('\n').append(" \t\tthen to_decimal(D.FAmtCoef,24,12)/to_decimal(S.FAmtCoef,24,12) ").append('\n').append(" \t\telse 0 end As FRate ").append('\n').append("\tFROM ").append(T_NCM_TotalData).append(" S ").append('\n').append(" \tWHERE S.FProductID=D.FProductID AND isnull(S.FProdBatchNo,' ')=isnull(D.FProdBatchNo,' ')").append('\n').append(" \t\tAND S.FSubCostItemID=D.FSubCostItemID AND S.FSubProductID=D.FSubProductID").append('\n').append(" \t\tAND isnull(S.FSubProdBatchNo,' ')=isnull(D.FSubProdBatchNo,' ') ").append('\n').append(") ").append('\n').append(";").append('\n');
            NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append("UPDATE ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append(" AS D SET FQtyCoef=(").append('\n').append("\tSelect  ").append('\n').append(" \t\tcase when to_decimal(S.FQtyCoef,24,12)<>0 ").append('\n').append(" \t\tthen to_decimal(D.FQtyCoef,24,12)/to_decimal(S.FQtyCoef,24,12) ").append('\n').append(" \t\telse 0 end As FRate ").append('\n').append("\tFROM ").append(T_NCM_TotalData).append(" S ").append('\n').append(" \tWHERE S.FProductID=D.FProductID AND isnull(S.FProdBatchNo,' ')=isnull(D.FProdBatchNo,' ')").append('\n').append(" \t\tAND S.FSubCostItemID=D.FSubCostItemID AND S.FSubProductID=D.FSubProductID").append('\n').append(" \t\tAND isnull(S.FSubProdBatchNo,' ')=isnull(D.FSubProdBatchNo,' ') ").append('\n').append(") ").append('\n').append(";").append('\n');
            NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
            sb.setLength(0);
            if (T_NCM_TotalData == null) return;
        }
        catch (Throwable throwable) {
            if (T_NCM_TotalData == null) throw throwable;
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, T_NCM_TotalData);
            throw throwable;
        }
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)T_NCM_TotalData);
    }

    @Override
    protected void CommitProdCoef(StringBuffer sb) throws EASBizException, BOSException {
        sb.append("INSERT INTO ").append(this._calcParam.GetTBL_BopWIPCoef()).append("(FID,FCompanyID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef, ").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch)").append('\n').append("SELECT FID,'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',FCostObjectID,FProductID,FProdBatchNo,FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append("\tFCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef, ").append('\n').append("\tFLayer,FDispLayer,FIsLeaf,FBranch ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append('\n').append(";").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("INSERT INTO ").append(this.dataCache.getBopWIPCoefTable()).append("(FID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef, ").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch)").append('\n').append("SELECT FID,'").append(this._calcParam.periodId).append("',FCostObjectID,FProductID,FProdBatchNo,FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo, ").append('\n').append("   FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef, ").append('\n').append("   FLayer,FDispLayer,FIsLeaf,FBranch ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_BopWIPCoef()).append('\n').append(";").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
    }

    @Override
    protected void InsertBoPInvPart(StringBuffer sb) throws EASBizException, BOSException {
        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FProdQty,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("SELECT newbosid('DFA50FD9'),").append('\n').append("\tS.FCostObjectID,S.FProductID,S.FProdBatchNo,S.FCostItemID,S.FMaterialID,S.FMatBatchNo, ").append('\n').append("   M.FQty As FProdQty,to_decimal(M.FAmount * S.FAmtCoef,24,12) AS FAmtCoef,to_decimal(M.FQty * S.FQtyCoef,24,12) AS FQtyCoef, ").append('\n').append("\tS.FLayer,S.FDispLayer,S.FIsLeaf,S.FBranch,11 As FType ").append('\n').append("FROM (").append('\n').append("\tSELECT bal.FMaterialID as FProductID, ISNULL(O.FCostObjBatchNo,N' ')As FProdBatchNo,").append('\n').append("\t\tSUM(bal.FPeriodBeginQty)As FQty,SUM(bal.FPeriodBeginBalance)As FAmount ").append('\n').append("\tFROM T_IM_InventoryBalance bal ").append('\n').append("   INNER JOIN ").append(this._calcParam.GetTempTblMaterialComp()).append(" mat ON mat.FMaterialID = bal.FMaterialID AND mat.FCalculateType=2 ").append('\n');
        if (!this._calcParam.isRevertAllProduct) {
            sb.append(" INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON  mcst.FMaterialID = bal.FMaterialID AND mcst.FIsParticipateReduct=1 ").append('\n');
        }
        sb.append("   LEFT JOIN ").append(this._calcParam.GetTempTblCostObjectBase()).append(" O ON O.FProductId=bal.FMaterialID and bal.flot = O.FCOSTOBJBATCHNO and O.FCalculateMode=4 ").append('\n').append("\tWHERE bal.FYear=").append(this._calcParam.periodYear).append(" AND bal.FPeriod=").append(this._calcParam.periodNumber).append('\n').append("\t\tAND bal.FCompanyOrgUnitID='").append(this._calcParam.companyId).append("' ").append('\n').append("\tGROUP BY bal.FMaterialID, O.FCostObjBatchNo ").append('\n').append("\tHAVING SUM(bal.FPeriodBeginQty) <>0 ").append('\n').append(")M ").append('\n').append("INNER JOIN ").append(this.dataCache.getBopInvCoefTable()).append(" S ON S.FProductID=M.FProductID AND isnull(S.FProdBatchNo,' ')=isnull(M.FProdBatchNo,' ') ").append('\n').append("\tAND S.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("INNER JOIN ").append(this._calcParam.GetTempTBL_CostObjList()).append(" CO ON CO.FCostObjectID=S.FCostObjectID").append('\n').append(";").append('\n');
    }

    @Override
    protected void InsertStockInPart(StringBuffer sb) throws EASBizException, BOSException {
        block19: {
            PreparedStatement pstmtsbMatIsParticipateReduct;
            PreparedStatement pstmtsbManu;
            PreparedStatement pstmtsbMat;
            PreparedStatement pstmtsbCostItem;
            block18: {
                Connection conn = null;
                pstmtsbCostItem = null;
                pstmtsbMat = null;
                pstmtsbManu = null;
                pstmtsbMatIsParticipateReduct = null;
                boolean isNewConn = false;
                try {
                    IRowSet rs = this.GetStockInData(false);
                    NumberFormat fm = NumberFormat.getInstance();
                    fm.setGroupingUsed(false);
                    if (this._calcParam.get_conn() == null) {
                        conn = EJBFactory.getConnection((Context)this._calcParam.ctx);
                        isNewConn = true;
                    } else {
                        conn = this._calcParam.get_conn();
                    }
                    StringBuffer sbCostItem = new StringBuffer();
                    sbCostItem.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FProdQty,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("Values(newbosid('DFA50FD9'),?,?,?,?,?,?,?,0,1,?,?,22)").append('\n');
                    pstmtsbCostItem = conn.prepareStatement(sbCostItem.toString());
                    StringBuffer sbMat = new StringBuffer();
                    sbMat.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("Values(newbosid('DFA50FD9'),?,?,?,?,?,?,?,?,1,1,?,?,22").append(");").append('\n');
                    pstmtsbMat = conn.prepareStatement(sbMat.toString());
                    StringBuffer sbManu = new StringBuffer();
                    sbManu.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("SELECT newbosid('DFA50FD9'),W.FCostObjectID,W.FProductID,W.FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("    to_decimal(W.FAmtCoef * ?,24,12) As FAmtCoef, to_decimal(W.FQtyCoef * ?,24,12) As FQtyCoef,").append('\n').append("\t(W.FLayer + 2) As FLayer,(W.FDispLayer ) As FDispLayer,W.FIsLeaf,? ||'.'||W.FBranch,22 ").append('\n').append("FROM ").append(this.dataCache.getBopWIPCoefTable()).append(" W ").append('\n').append("WHERE W.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\tAND W.FProductID = ? AND W.FProdBatchNo= ? \n").append("\tAND W.FSubCostItemID = ? AND W.FSubProductID= ? \n").append("\tAND W.FSubProdBatchNo = ? ").append('\n').append(";").append('\n');
                    pstmtsbManu = conn.prepareStatement(sbManu.toString());
                    StringBuffer SbMatIsParticipateReduct = new StringBuffer();
                    SbMatIsParticipateReduct.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("SELECT newbosid('DFA50FD9'),? As FCostObjectID,? As FProductID,? As FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("    to_decimal(W.FAmtCoef * ?,24,12) As FAmtCoef, to_decimal(W.FQtyCoef * ?,24,12) As FQtyCoef,").append('\n').append("\t(W.FLayer + 2) As FLayer,(W.FDispLayer ) As FDispLayer,W.FIsLeaf,? ||'.'||W.FBranch,22 ").append('\n').append("FROM ").append(this.dataCache.getBopInvCoefTable()).append(" W ").append('\n').append("WHERE W.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("\tAND W.FProductID = ? AND W.FProdBatchNo= ?").append('\n').append(";").append('\n');
                    pstmtsbMatIsParticipateReduct = conn.prepareStatement(SbMatIsParticipateReduct.toString());
                    int sort = 0;
                    String lastCostObjectID = "";
                    String lastProductId = "";
                    String lastProdBatchNo = "";
                    String lastCostItemID = "";
                    String sBranch = "";
                    String sSubBranch = "";
                    String sIsLeaf = "";
                    while (rs.next()) {
                        if (lastCostObjectID.compareTo(rs.getString("FCostobjectId")) != 0 || lastProductId.compareTo(rs.getString("FProductId")) != 0 || lastProdBatchNo.compareTo(rs.getString("FProdBatchNo")) != 0 || lastCostItemID.compareTo(rs.getString("FCostItemID")) != 0) {
                            ++sort;
                            fm.setMaximumFractionDigits(12);
                            String prodQty = fm.format(BigDecimal.valueOf(0L));
                            if (rs.getBigDecimal("FTotalFinishedQty") != null) {
                                prodQty = fm.format(rs.getBigDecimal("FTotalFinishedQty"));
                            }
                            String costItemAmount = fm.format(BigDecimal.valueOf(0L));
                            if (rs.getBigDecimal("FCostItemAmount") != null) {
                                costItemAmount = fm.format(rs.getBigDecimal("FCostItemAmount"));
                            }
                            String costItemQty = fm.format(BigDecimal.valueOf(0L));
                            if (rs.getBigDecimal("FCostItemQty") != null) {
                                costItemQty = fm.format(rs.getBigDecimal("FCostItemQty"));
                            }
                            sBranch = rs.getString("FPrdBatchNodeID") + "." + rs.getString("FCostItemID");
                            sIsLeaf = rs.getString("FMaterialID") != null && rs.getString("FMaterialID").length() > 0 ? "0" : "1";
                            pstmtsbCostItem.setString(1, rs.getString("FCostObjectID"));
                            pstmtsbCostItem.setString(2, rs.getString("FProductId"));
                            pstmtsbCostItem.setString(3, rs.getString("FProdBatchNo"));
                            pstmtsbCostItem.setString(4, rs.getString("FCostItemID"));
                            pstmtsbCostItem.setString(5, prodQty);
                            pstmtsbCostItem.setString(6, costItemAmount);
                            pstmtsbCostItem.setString(7, costItemQty);
                            pstmtsbCostItem.setString(8, sIsLeaf);
                            pstmtsbCostItem.setString(9, sBranch);
                            pstmtsbCostItem.addBatch();
                            lastCostObjectID = rs.getString("FCostobjectId");
                            lastProductId = rs.getString("FProductId");
                            lastProdBatchNo = rs.getString("FProdBatchNo");
                            lastCostItemID = rs.getString("FCostItemID");
                        }
                        if (rs.getString("FMaterialID") == null || rs.getString("FMaterialID").length() <= 0) continue;
                        ++sort;
                        fm.setMaximumFractionDigits(12);
                        String matAmount = fm.format(BigDecimal.valueOf(0L));
                        if (rs.getBigDecimal("FMatAmount") != null) {
                            matAmount = fm.format(rs.getBigDecimal("FMatAmount"));
                        }
                        String matQty = fm.format(BigDecimal.valueOf(0L));
                        if (rs.getBigDecimal("FMatQty") != null) {
                            matQty = fm.format(rs.getBigDecimal("FMatQty"));
                        }
                        sSubBranch = sBranch + "." + rs.getString("FCostItemNodeID");
                        sIsLeaf = rs.getInt("FHasCoef") == 1 || rs.getInt("FHasCoef2") == 1 ? "0" : "1";
                        pstmtsbMat.setString(1, rs.getString("FCostObjectID"));
                        pstmtsbMat.setString(2, rs.getString("FProductId"));
                        pstmtsbMat.setString(3, rs.getString("FProdBatchNo"));
                        pstmtsbMat.setString(4, rs.getString("FCostItemID"));
                        pstmtsbMat.setString(5, rs.getString("FMaterialID"));
                        pstmtsbMat.setString(6, rs.getString("FMatBatchNo"));
                        pstmtsbMat.setString(7, matAmount);
                        pstmtsbMat.setString(8, matQty);
                        pstmtsbMat.setString(9, sIsLeaf);
                        pstmtsbMat.setString(10, sSubBranch);
                        pstmtsbMat.addBatch();
                        fm.setMaximumFractionDigits(12);
                        String amount = fm.format(BigDecimal.valueOf(0L));
                        if (rs.getBigDecimal("FMatAmount") != null) {
                            amount = fm.format(rs.getBigDecimal("FMatAmount"));
                        }
                        String qty = fm.format(BigDecimal.valueOf(0L));
                        if (rs.getBigDecimal("FMatQty") != null) {
                            qty = fm.format(rs.getBigDecimal("FMatQty"));
                        }
                        if (rs.getInt("FHasCoef") == 1) {
                            pstmtsbManu.setString(1, amount);
                            pstmtsbManu.setString(2, qty);
                            pstmtsbManu.setString(3, sSubBranch);
                            pstmtsbManu.setString(4, rs.getString("FProductID"));
                            pstmtsbManu.setString(5, rs.getString("FProdBatchNo"));
                            pstmtsbManu.setString(6, rs.getString("FCostItemID"));
                            pstmtsbManu.setString(7, rs.getString("FMaterialID"));
                            pstmtsbManu.setString(8, rs.getString("FMatBatchNo"));
                            pstmtsbManu.addBatch();
                            continue;
                        }
                        if (rs.getInt("FHasCoef2") != 1) continue;
                        SbMatIsParticipateReduct.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("SELECT newbosid('DFA50FD9'),? As FCostObjectID,? As FProductID,? As FProdBatchNo,W.FCostItemID,W.FMaterialID,W.FMatBatchNo, ").append('\n').append("    to_decimal(W.FAmtCoef * ?,24,12) As FAmtCoef, to_decimal(W.FQtyCoef * ?,24,12) As FQtyCoef,").append('\n').append("\t(W.FLayer + 2) As FLayer,(W.FDispLayer +1) As FDispLayer,W.FIsLeaf,? ||'.'||W.FBranch,22 ").append('\n').append("FROM ").append(this.dataCache.getBopInvCoefTable()).append(" W ").append('\n').append("WHERE W.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("\tAND W.FProductID = ? AND W.FProdBatchNo= ?").append('\n').append(";").append('\n');
                        pstmtsbMatIsParticipateReduct.setString(1, rs.getString("FCostObjectID"));
                        pstmtsbMatIsParticipateReduct.setString(2, rs.getString("FProductID"));
                        pstmtsbMatIsParticipateReduct.setString(3, rs.getString("FProdBatchNo"));
                        pstmtsbMatIsParticipateReduct.setString(4, amount);
                        pstmtsbMatIsParticipateReduct.setString(5, qty);
                        pstmtsbMatIsParticipateReduct.setString(6, sSubBranch);
                        pstmtsbMatIsParticipateReduct.setString(7, rs.getString("FMaterialID"));
                        pstmtsbMatIsParticipateReduct.setString(8, rs.getString("FMatBatchNo"));
                        pstmtsbMatIsParticipateReduct.addBatch();
                    }
                    pstmtsbCostItem.executeBatch();
                    pstmtsbMat.executeBatch();
                    pstmtsbManu.executeBatch();
                    pstmtsbMatIsParticipateReduct.executeBatch();
                    if (!isNewConn) break block18;
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)"", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (isNewConn) {
                            SQLUtils.cleanup(pstmtsbCostItem, conn);
                            SQLUtils.cleanup(pstmtsbMat, conn);
                            SQLUtils.cleanup(pstmtsbManu, conn);
                            SQLUtils.cleanup(pstmtsbMatIsParticipateReduct, conn);
                        } else {
                            SQLUtils.cleanup(pstmtsbCostItem);
                            SQLUtils.cleanup(pstmtsbMat);
                            SQLUtils.cleanup(pstmtsbManu);
                            SQLUtils.cleanup(pstmtsbMatIsParticipateReduct);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmtsbCostItem, (Connection)conn);
                SQLUtils.cleanup((Statement)pstmtsbMat, (Connection)conn);
                SQLUtils.cleanup((Statement)pstmtsbManu, (Connection)conn);
                SQLUtils.cleanup((Statement)pstmtsbMatIsParticipateReduct, (Connection)conn);
                break block19;
            }
            SQLUtils.cleanup((Statement)pstmtsbCostItem);
            SQLUtils.cleanup((Statement)pstmtsbMat);
            SQLUtils.cleanup((Statement)pstmtsbManu);
            SQLUtils.cleanup((Statement)pstmtsbMatIsParticipateReduct);
        }
    }

    @Override
    protected void InsertStockInPart_Oracle(StringBuffer sb) throws EASBizException, BOSException {
        StringBuffer sbStockInDataSelectSql = new StringBuffer();
        sb.append("/*dialect*/");
        sbStockInDataSelectSql = this.GetStockInDataSelectSql(false);
        String SelDefine = null;
        try {
            SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)this._calcParam.CurrentDataBaseType);
            if (SelDefine.indexOf("(+)") != -1) {
                SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)7);
            }
        }
        catch (SqlTranslateException e) {
            try {
                SelDefine = TransUtil.Translate((String)sbStockInDataSelectSql.toString(), (int)8);
            }
            catch (SqlTranslateException e2) {
                logger.error((Object)e2);
                throw new BOSException(e2.getMessage());
            }
        }
        sb.append(" declare CURSOR cur IS ").append(SelDefine).append(";").append('\n').append("\tcurrInfo cur%rowtype; ").append('\n').append("\tsort NUMBER := 0; ").append('\n').append("\tlastCostObjectID VARCHAR2 (44) := ' '; ").append('\n').append("\tlastProductId VARCHAR2 (44) := ' '; ").append('\n').append("\tlastProdBatchNo VARCHAR2 (80) := ' '; ").append('\n').append("\tlastCostItemID VARCHAR2 (44) := ' '; ").append('\n').append("\tsBranch VARCHAR2 (126) := ' '; ").append('\n').append("\tsSubBranch VARCHAR2 (252) := ' '; ").append('\n').append("\tisLeaf NUMBER := 0; ").append('\n').append(" BEGIN ").append('\n').append("\topen cur; ").append('\n').append("\tloop ").append('\n').append("\t   fetch cur into currInfo; ").append('\n').append("\t   exit when cur%notfound; ").append('\n').append("\t\t ").append('\n').append("\t\t --A,\u63d2\u5165\u6210\u672c\u9879\u76ee\u6c47\u603b\u4fe1\u606f").append('\n').append("\t\t if ((lastCostObjectID <> currInfo.FCostobjectId) OR (lastProductId <> currInfo.FProductId)OR (lastProdBatchNo <> currInfo.FProdBatchNo)OR (lastCostItemID <> currInfo.FCostItemID))then ").append('\n').append("\t\t \tsort := (sort + 1);").append('\n').append("\t\t \tif (currInfo.FMaterialID IS NOT NULL)then").append('\n').append("\t\t \t\tisLeaf := 0;").append('\n').append("\t\t \telse ").append('\n').append("\t\t \t\tisLeaf := 1;").append('\n').append("\t\t \tend if;").append('\n').append("\t\t \tsBranch := currInfo.FPrdBatchNodeID;").append('\n').append("\t\t \tINSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("\t\t \t(FID,FCostObjectID,FProductID,FProdBatchNo, ").append("\t\t \t FCostItemID,FProdQty,FAmtCoef,FQtyCoef,").append("\t\t \t FLayer,FDispLayer,FIsLeaf,FBranch,FType,FMatBatchNo)").append('\n').append("\t\t \tValues(newbosid('DFA50FD9'),currInfo.FCostObjectID,currInfo.FProductId,currInfo.FProdBatchNo,currInfo.FCostItemID,currInfo.FTotalFinishedQty,currInfo.FCostItemAmount,currInfo.FCostItemQty,").append("0,1,isLeaf,sBranch,22,' ');").append("\t\t \tlastCostObjectID := currInfo.FCostobjectId;").append('\n').append("\t\t \tlastProductId := currInfo.FProductId;").append('\n').append("\t\t \tlastProdBatchNo := NVL(currInfo.FProdBatchNo,' ');").append('\n').append("\t\t \tlastCostItemID := currInfo.FCostItemID;").append('\n').append("\t\t end if; --end of A,\u63d2\u5165\u6210\u672c\u9879\u76ee\u6c47\u603b\u4fe1\u606f").append('\n').append("\t\t --B,\u63d2\u5165\u672c\u5c42\u6750\u6599\u660e\u7ec6(\u5982\u679c\u6709\u65f6)").append('\n').append("\t\t if (currInfo.FMaterialID IS NOT NULL)then").append('\n').append("\t\t \tif (currInfo.FHasCoef = 1 or currInfo.FHasCoef2 = 1)then").append('\n').append("\t\t \t\tisLeaf := 0;").append('\n').append("\t\t \telse ").append('\n').append("\t\t \t\tisLeaf := 1;").append('\n').append("\t\t \tend if;").append('\n').append("\t\t \tsSubBranch := sBranch || '.' || currInfo.FCostItemNodeID;").append('\n').append("\t\t\tINSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("\t\t\t(FID,FCostObjectID,FProductID,FProdBatchNo, ").append("\t\t\t FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,").append("\t\t\t FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("\t\t\tValues(newbosid('DFA50FD9'),currInfo.FCostObjectID,currInfo.FProductId,currInfo.FProdBatchNo,currInfo.FCostItemID,currInfo.FMaterialID,currInfo.FMatBatchNo,").append('\n').append("\t\t\t currInfo.FMatAmount,currInfo.FMatQty,1,1,isLeaf,sSubBranch,22);").append('\n').append("\t\t \t--\u81ea\u5236\u5b50\u9879\u65f6\u5c55\u5f00\u4e0b\u5c42\u7ed3\u6784").append('\n').append("\t\t \tif (currInfo.FHasCoef = 1)then").append('\n').append("\t\t \t\tINSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("\t\t \t\t(FID,FCostObjectID,FProductID,FProdBatchNo, ").append("\t\t \t\t FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,").append("\t\t \t\t FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("\t\t \t\tSELECT newbosid('DFA50FD9'),W.FCostObjectID,W.FProductID,W.FProdBatchNo,W.FCostItemID,W.FMaterialID,NVL(W.FMatBatchNo,' '), ").append('\n').append("\t\t \t\t    W.FAmtCoef * currInfo.FMatAmount As FAmtCoef, W.FQtyCoef * currInfo.FMatQty As FQtyCoef,").append('\n').append("\t\t \t\t\t(W.FLayer + 2) As FLayer,(W.FDispLayer ) As FDispLayer,W.FIsLeaf,sSubBranch ||'.' || W.FBranch,22 ").append('\n').append("\t\t \t\tFROM ").append(this.dataCache.getBopWIPCoefTable()).append(" W ").append('\n').append("\t\t \t\tWHERE W.FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append("\t\t \t\t\tAND W.FProductID = currInfo.FProductID AND NVL(W.FProdBatchNo,' ') = NVL(currInfo.FProdBatchNo,' ') ").append('\n').append("\t\t \t\t\tAND W.FSubCostItemID = currInfo.FCostItemID AND W.FSubProductID = currInfo.FMaterialID ").append('\n').append("\t\t \t\t\tAND NVL(W.FSubProdBatchNo,' ') = NVL(currInfo.FMatBatchNo,' ') ;").append('\n').append("\t\t \tend if; --end of \u81ea\u5236\u5b50\u9879\u65f6\u5c55\u5f00\u4e0b\u5c42\u7ed3\u6784").append('\n').append("           if(currInfo.FHasCoef2 = 1 AND currInfo.FHasCoef <> 1) then").append('\n').append("\t\t \t\tINSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("\t\t \t\t(FID,FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append("\t\t \t\t FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef,").append('\n').append("\t\t \t\t FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("\t\t \t\tSELECT newbosid('DFA50FD9'),currInfo.FCostObjectID, currInfo.FProductID,currInfo.FProdBatchNo,W.FCostItemID,W.FMaterialID,NVL(W.FMatBatchNo,' '), ").append('\n').append("\t\t \t\t    W.FAmtCoef * currInfo.FMatAmount As FAmtCoef, W.FQtyCoef * currInfo.FMatQty As FQtyCoef,").append('\n').append("\t\t \t\t\t(W.FLayer + 2) As FLayer,(W.FDispLayer +1) As FDispLayer,W.FIsLeaf,sSubBranch ||'.' || W.FBranch,22 ").append('\n').append("\t\t \t\tFROM ").append(this.dataCache.getBopInvCoefTable()).append(" W ").append('\n').append("\t\t \t\tWHERE W.FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append("\t\t \t\t\tAND W.FProductID = currInfo.FMaterialID AND NVL(W.FProdBatchNo,' ')=NVL(currInfo.FMatBatchNo,' '); ").append('\n').append("\t\t \tend if; --end of \u81ea\u5236\u5b50\u9879\u65f6\u5c55\u5f00\u4e0b\u5c42\u7ed3\u6784").append('\n').append("\t\t end if; --end of B,\u63d2\u5165\u672c\u5c42\u6750\u6599\u660e\u7ec6(\u5982\u679c\u6709\u65f6)").append('\n').append("\tend loop; ").append('\n').append("\tclose cur; ").append('\n').append(" END;").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.delete(0, sb.length());
    }

    @Override
    protected void MergeInventoryCoef(StringBuffer sb) throws EASBizException, BOSException {
        sb.append("INSERT INTO ").append(this._calcParam.GetTempTBL_BopInvCoef()).append("(FID,FCostObjectID,FProductID,FProdBatchNo,").append('\n').append(" FCostItemID,FMaterialID,FMatBatchNo,FProdQty,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch,FType)").append('\n').append("SELECT newbosid('DFA50FD9')As FID,D.FCostObjectID,D.FProductID,D.FProdBatchNo,").append('\n').append("       D.FCostItemID,D.FMaterialID,D.FMatBatchNo,SUM(D.FProdQty)As FProdQty,SUM(D.FAmtCoef)As FAmtCoef, SUM(D.FQtyCoef)As FQtyCoef, ").append('\n').append("       D.FLayer,D.FDispLayer,MIN(FIsLeaf)As FIsLeaf, D.FBranch,1 As FType").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_BopInvCoef()).append(" D ").append('\n').append("WHERE D.FType<>1 ").append('\n').append("GROUP BY D.FCostObjectID,D.FProductID,D.FProdBatchNo,").append('\n').append("       D.FLayer,D.FDispLayer,D.FBranch,D.FCostItemID,D.FMaterialID,D.FMatBatchNo ").append('\n').append(";").append('\n').append("DELETE FROM ").append(this._calcParam.GetTempTBL_BopInvCoef()).append(" WHERE FType<>1 ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopInvCoef(), (String)"FID", (boolean)true, (boolean)true);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopInvCoef(), (String)"FCostObjectID", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopInvCoef(), (String)"FProductID,FProdBatchNo", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTBL_BopInvCoef(), (String)"FBranch", (boolean)false, (boolean)false);
    }

    @Override
    protected void CalcInventoryCoef(StringBuffer sb) throws EASBizException, BOSException {
        sb.setLength(0);
        sb.append("Create Table _tempTblMaterialCost (").append('\n');
        sb.append("FProductID VARCHAR(44),FProdBatchNo VARCHAR(80),").append('\n');
        sb.append("FAmtCoef NUMERIC(28,12),FProdQtyCoef NUMERIC(28,12))").append('\n');
        String temptable = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)sb.toString());
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)temptable, (String)"FProductID,FProdBatchNo", (boolean)false, (boolean)false);
        sb.setLength(0);
        sb.append(" insert into ").append(temptable).append(" (FProductID,FProdBatchNo,FAmtCoef,FProdQtyCoef) ").append('\n');
        sb.append("  select FProductID,FProdBatchNo,to_decimal(SUM(S.FAmtCoef),28,12),to_decimal(Max(S.FProdQty),28,12) ").append('\n');
        sb.append("\tFROM ").append(this._calcParam.GetTempTBL_BopInvCoef()).append(" S ").append('\n');
        sb.append(" WHERE S.FMaterialID is null AND S.FLayer=0 ").append('\n');
        sb.append(" group by FProductID,FProdBatchNo ").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)temptable, (String)"FProductID,FProdBatchNo", (boolean)false, (boolean)false);
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)temptable);
        sb.setLength(0);
        sb.append("UPDATE ").append(this._calcParam.GetTempTBL_BopInvCoef()).append(" As D SET FAmtCoef=(").append('\n').append("\tSelect  ").append('\n').append(" \t\tcase when S.FAmtCoef<>0 ").append('\n').append(" \t\tthen to_decimal(D.FAmtCoef,24,12)/S.FAmtCoef ").append('\n').append(" \t\telse 0 end As FRate ").append('\n').append("\tFROM ").append(temptable).append(" S ").append('\n').append(" \tWHERE S.FProductID=D.FProductID AND isnull(S.FProdBatchNo,' ')=isnull(D.FProdBatchNo,' ')").append('\n').append(") ").append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(this._calcParam.GetTempTBL_BopInvCoef()).append(" As D SET FQtyCoef=(").append('\n').append("\tSelect  ").append('\n').append(" \t\tcase when S.FProdQtyCoef<>0 ").append('\n').append(" \t\tthen to_decimal(D.FQtyCoef,24,12)/S.FProdQtyCoef ").append('\n').append(" \t\telse 0 end As FRate ").append('\n').append("\tFROM ").append(temptable).append(" S ").append('\n').append(" \tWHERE S.FProductID=D.FProductID AND isnull(S.FProdBatchNo,' ')=isnull(D.FProdBatchNo,' ')").append('\n').append(") ").append('\n').append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.setLength(0);
        NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)temptable);
    }

    @Override
    protected void CommitInventoryCoef(StringBuffer sb) throws EASBizException, BOSException {
        NCMDynamicTableManager.clearIndexsOfBusiTbl((Context)this._calcParam.ctx, (String)this._calcParam.companyId, (String)"T_NCM_BopInvCoefByStep");
        sb.append("INSERT INTO ").append(this._calcParam.GetTBL_BopInvCoef()).append("(FID,FCompanyID,FCalculatePeriodID,FCostObjectID,FProductID,").append('\n').append(" FProdBatchNo,FCostItemID,FMaterialID, FMatBatchNo,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch)").append('\n').append("SELECT FID,'").append(this._calcParam.companyId).append("','").append(this._calcParam.periodId).append("',FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append("\tFCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef, ").append('\n').append("\tFLayer,FDispLayer,FIsLeaf,FBranch ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_BopInvCoef()).append('\n').append(";").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("INSERT INTO ").append(this.dataCache.getBopInvCoefTable()).append("(FID,FCalculatePeriodID,FCostObjectID,FProductID,").append('\n').append(" FProdBatchNo,FCostItemID,FMaterialID, FMatBatchNo,FAmtCoef,FQtyCoef,").append('\n').append(" FLayer,FDispLayer,FIsLeaf,FBranch)").append('\n').append("SELECT FID,'").append(this._calcParam.periodId).append("',FCostObjectID,FProductID,FProdBatchNo, ").append('\n').append("   FCostItemID,FMaterialID,FMatBatchNo,FAmtCoef,FQtyCoef, ").append('\n').append("   FLayer,FDispLayer,FIsLeaf,FBranch ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_BopInvCoef()).append('\n').append(";").append('\n');
        NCMDbUtil.execute((Context)this._calcParam.ctx, (String)sb.toString());
        sb.setLength(0);
    }

    @Override
    protected IRowSet GetStockInData(boolean byCostCenter) throws EASBizException, BOSException {
        return NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)this.GetStockInDataSelectSql(byCostCenter).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StringBuffer GetStockInDataSelectSql(boolean byCostCenter) throws EASBizException, BOSException {
        String T_NCM_CalPrdByClassTotalTbl;
        String T_NCM_CalMatDetailTbl;
        String T_NCM_CalPrdTotalQtyTbl;
        String T_NCM_CalPrdTotalAmtTbl;
        block18: {
            StringBuffer sb = new StringBuffer();
            String tblCostCalResult = this.dataCache.getCostCalResultTable();
            String tblCostCalMatDetailResult = this.dataCache.getCostCalMatDetailResultTable();
            String tblCostCostCalPrdDetailResult = this.dataCache.getCostCalPrdResultTable();
            String tblBranchNode = this._calcParam.GetTBL_RecoveryTreeBranchNode();
            String T_NCM_CalPrdDetailTbl = null;
            T_NCM_CalPrdTotalAmtTbl = null;
            T_NCM_CalPrdTotalQtyTbl = null;
            T_NCM_CalMatDetailTbl = null;
            T_NCM_CalPrdByClassTotalTbl = null;
            String sCostCenter_CP = "";
            String sCostCenter_CP_G = "";
            String sCostCenter_CT_C = "";
            String sCostCenter_PP = "";
            String sCostCenter_PP_G = "";
            String sCostCenter_PP_C = "";
            String sCostCenter_CCMat = "";
            String sCostCenter_CCMat_G = "";
            String sCostCenter_M_C = "";
            String sCostCenter_CI = "";
            String sCostCenter_CI_G = "";
            String sCostCenter_R_C = "";
            String sCostCenter_C = "";
            if (byCostCenter) {
                sCostCenter_CP = " CP.FCostCenterID,";
                sCostCenter_CP_G = " CP.FCostCenterID,";
                sCostCenter_CT_C = " CT.FCostCenterID=C.FCostCenterID AND ";
                sCostCenter_PP = " P.FCostCenterID,";
                sCostCenter_PP_G = " P.FCostCenterID,";
                sCostCenter_PP_C = " PP.FCostCenterID=C.FCostCenterID AND ";
                sCostCenter_CCMat = " CCMat.FCostCenterID,";
                sCostCenter_CCMat_G = " CCMat.FCostCenterID,";
                sCostCenter_M_C = " M.FCostCenterID=C.FCostCenterID AND ";
                sCostCenter_CI = " CI.FCostCenterID,";
                sCostCenter_CI_G = " CI.FCostCenterID,";
                sCostCenter_R_C = " R.FCostCenterID=C.FCostCenterID AND ";
                sCostCenter_C = " C.FCostCenterID, ";
            } else {
                sCostCenter_CP = " ' ' As FCostCenterID,";
                sCostCenter_CP_G = "";
                sCostCenter_CT_C = " CT.FCostCenterID=C.FCostCenterID AND ";
                sCostCenter_PP = " ' ' As FCostCenterID,";
                sCostCenter_PP_G = " ";
                sCostCenter_PP_C = " PP.FCostCenterID=C.FCostCenterID AND ";
                sCostCenter_CCMat = " ' ' As FCostCenterID,";
                sCostCenter_CCMat_G = "";
                sCostCenter_M_C = " M.FCostCenterID=C.FCostCenterID AND ";
                sCostCenter_CI = " ' ' As FCostCenterID,";
                sCostCenter_CI_G = "";
                sCostCenter_R_C = " R.FCostCenterID=C.FCostCenterID AND ";
                sCostCenter_C = " C.FCostCenterID, ";
            }
            try {
                StringBuffer ksql = new StringBuffer();
                ksql.append("create table T ( \n");
                ksql.append("    FCostCenterID VARCHAR(44), \n");
                ksql.append("    FCostObjectID VARCHAR(44), \n");
                ksql.append("    FProductID VARCHAR(44), \n");
                ksql.append("    FProdBatchNo NVARCHAR(80), \n");
                ksql.append("    FCostItemID VARCHAR(44), \n");
                ksql.append("    FCostItemQty NUMERIC(28,10), \n");
                ksql.append("    FCostItemAmount NUMERIC(17,4) \n");
                ksql.append(") \n");
                T_NCM_CalPrdDetailTbl = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)ksql.toString());
                ksql.setLength(0);
                ksql.append(" Insert Into ").append(T_NCM_CalPrdDetailTbl).append('\n');
                ksql.append("       (FCostCenterID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FCostItemQty,FCostItemAmount)").append('\n');
                ksql.append(" SELECT ").append(sCostCenter_CP).append(" CP.FCostObjectID,CP.FProductID,Isnull(CP.FLot,' ') As FProdBatchNo,CP.FCostItemID, ").append('\n');
                ksql.append("       SUM(CP.FFinishedQty)As FCostItemQty,SUM(CP.FFinishedAmount)As FCostItemAmount ").append('\n');
                ksql.append("   FROM ").append(tblCostCostCalPrdDetailResult).append(" CP ").append('\n');
                if (!this._calcParam.isRevertAllProduct) {
                    ksql.append(" INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON  mcst.FMaterialID = CP.FProductID AND mcst.FIsParticipateReduct=1 ").append('\n');
                }
                ksql.append("   GROUP BY ").append(sCostCenter_CP_G).append("CP.FCostObjectID,CP.FProductID,CP.FLot,CP.FCostItemID ").append('\n');
                ksql.append("   HAVING SUM(CP.FFinishedQty)<>0 OR SUM(CP.FFinishedAmount)<>0 ").append('\n');
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)ksql.toString());
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_CalPrdDetailTbl, (String)"FCostCenterID", (boolean)false, (boolean)false);
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_CalPrdDetailTbl, (String)"FCostObjectID,FProductID,FProdBatchNo,FCostItemID", (boolean)false, (boolean)false);
                ksql.setLength(0);
                ksql.append("create table T ( \n");
                ksql.append("    FCostCenterID VARCHAR(44), \n");
                ksql.append("    FCostObjectID VARCHAR(44), \n");
                ksql.append("    FProductID VARCHAR(44), \n");
                ksql.append("    FProdBatchNo VARCHAR(80), \n");
                ksql.append("    FTotalFinishedAmount NUMERIC(17,4) \n");
                ksql.append(") \n");
                T_NCM_CalPrdTotalAmtTbl = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)ksql.toString());
                ksql.setLength(0);
                ksql.append(" Insert Into ").append(T_NCM_CalPrdTotalAmtTbl).append('\n');
                ksql.append("       (FCostCenterID,FCostObjectID,FProductID,FProdBatchNo,FTotalFinishedAmount)").append('\n');
                ksql.append(" SELECT ").append(sCostCenter_CP).append(" CP.FCostObjectID,CP.FProductID,Isnull(CP.FLot,' ') As FProdBatchNo,").append('\n');
                ksql.append("       SUM(CP.FFinishedAmount)As FTotalFinishedAmount ").append('\n');
                ksql.append(" FROM ").append(tblCostCostCalPrdDetailResult).append(" CP ").append('\n');
                if (!this._calcParam.isRevertAllProduct) {
                    ksql.append(" INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON  mcst.FMaterialID = CP.FProductID AND mcst.FIsParticipateReduct=1 ").append('\n');
                }
                ksql.append("   GROUP BY ").append(sCostCenter_CP_G).append(" CP.FCostObjectID,CP.FProductID,CP.FLot ").append('\n');
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)ksql.toString());
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_CalPrdTotalAmtTbl, (String)"FCostCenterID", (boolean)false, (boolean)false);
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_CalPrdTotalAmtTbl, (String)"FCostObjectID,FProductID,FProdBatchNo", (boolean)false, (boolean)false);
                ksql.setLength(0);
                ksql.append("create table T ( \n");
                ksql.append("    FCostCenterID VARCHAR(44), \n");
                ksql.append("    FCostObjectID VARCHAR(44), \n");
                ksql.append("    FProductID VARCHAR(44), \n");
                ksql.append("    FProdBatchNo VARCHAR(80), \n");
                ksql.append("    FTotalFinishedQty NUMERIC(17,4) \n");
                ksql.append(") \n");
                T_NCM_CalPrdTotalQtyTbl = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)ksql.toString());
                ksql.setLength(0);
                ksql.append(" Insert Into ").append(T_NCM_CalPrdTotalQtyTbl).append('\n');
                ksql.append("       (FCostCenterID,FCostObjectID,FProductID,FProdBatchNo,FTotalFinishedQty)").append('\n');
                ksql.append("   SELECT ").append(sCostCenter_PP).append(" P.FCostObjectID,P.FProductID,Isnull(P.FLot,N' ') As FProdBatchNo,SUM(P.FFinishedQty)As FTotalFinishedQty ").append('\n');
                ksql.append("   FROM ").append(this._calcParam.GetTBL_DataByProduct()).append(" P ").append('\n');
                if (!this._calcParam.isRevertAllProduct) {
                    ksql.append(" INNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON  mcst.FMaterialID = P.FProductID AND mcst.FIsParticipateReduct=1 ").append('\n');
                }
                ksql.append("   GROUP BY ").append(sCostCenter_PP_G).append(" P.FCostObjectID,P.FProductID,P.FLot ").append('\n');
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)ksql.toString());
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_CalPrdTotalQtyTbl, (String)"FCostCenterID", (boolean)false, (boolean)false);
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_CalPrdTotalQtyTbl, (String)"FCostObjectID,FProductID,FProdBatchNo", (boolean)false, (boolean)false);
                ksql.setLength(0);
                ksql.append("create table T ( \n");
                ksql.append("    FCostCenterID VARCHAR(44), \n");
                ksql.append("    FCostObjectID VARCHAR(44), \n");
                ksql.append("    FCostItemID VARCHAR(44), \n");
                ksql.append("    FMaterialID VARCHAR(44), \n");
                ksql.append("    FMatBatchNo VARCHAR(80), \n");
                ksql.append("    FQty NUMERIC(28,10), \n");
                ksql.append("    FAmount NUMERIC(17,4), \n");
                ksql.append("    FMatIsParticipateReduct INT \n");
                ksql.append(") \n");
                T_NCM_CalMatDetailTbl = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)ksql.toString());
                ksql.setLength(0);
                ksql.append(" Insert Into ").append(T_NCM_CalMatDetailTbl).append('\n');
                ksql.append("       (FCostCenterID,FCostObjectID,FCostItemID,FMaterialID,FMatBatchNo,FQty,FAmount,FMatIsParticipateReduct)").append('\n');
                ksql.append("   SELECT ").append(sCostCenter_CCMat).append(" CCMat.FCostObjectID,CCMat.FCostItemID,CCMat.FMaterialID,ISNULL(O.FCostObjBatchNo,N' ') As FMatBatchNo, ").append('\n');
                ksql.append("       SUM(CCMat.FFinishedQty)As FQty,SUM(CCMat.FFinishedAmount)As FAmount,Isnull(Max(mc.FIsParticipateReduct),0)As FMatIsParticipateReduct ").append('\n');
                ksql.append("   FROM ").append(tblCostCalMatDetailResult).append(" CCMat ").append('\n');
                ksql.append("   INNER JOIN t_NCM_CostItem CI ON CI.FID=CCMat.FCostItemID AND CI.FItemType='1' ").append('\n');
                ksql.append("   LEFT JOIN ").append(this._calcParam.GetTempTblCostObjectLot()).append(" O ").append('\n');
                ksql.append("     ON O.FProductId=CCMat.FMaterialID AND isnull(O.FProdBatchNo,' ')=isnull(CCMat.FLot,' ') ").append('\n');
                ksql.append("   LEFT JOIN  ").append(this._calcParam.GetTempTblMaterialCost()).append(" mc ON  mc.FMaterialID = CCMat.FMaterialID ").append('\n');
                ksql.append("   GROUP BY ").append(sCostCenter_CCMat_G).append(" CCMat.FCostObjectID,CCMat.FCostItemID,CCMat.FMaterialID,O.FProdBatchNo,O.FCostObjBatchNo ").append('\n');
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)ksql.toString());
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_CalMatDetailTbl, (String)"FCostCenterID", (boolean)false, (boolean)false);
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_CalMatDetailTbl, (String)"FCostObjectID,FCostItemID,FMaterialID,FMatBatchNo", (boolean)false, (boolean)false);
                ksql.setLength(0);
                ksql.append("create table T ( \n");
                ksql.append("    FCostCenterID VARCHAR(44), \n");
                ksql.append("    FCostObjectID VARCHAR(44), \n");
                ksql.append("    FProductID VARCHAR(44), \n");
                ksql.append("    FProdBatchNo VARCHAR(80), \n");
                ksql.append("    FCostItemID VARCHAR(44), \n");
                ksql.append("    FRate NUMERIC(24,11) \n");
                ksql.append(") \n");
                T_NCM_CalPrdByClassTotalTbl = NCMDbUtil.createTempTable((Context)this._calcParam.ctx, (String)ksql.toString());
                ksql.setLength(0);
                ksql.append(" Insert Into ").append(T_NCM_CalPrdByClassTotalTbl).append('\n');
                ksql.append("        (FCostCenterID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FRate)").append('\n');
                ksql.append("    SELECT ").append(sCostCenter_CI).append(" CI.FCostObjectID,CI.FProductID,isnull(CI.FLot, N' ') As FProdBatchNo,CI.FCostItemID, ").append('\n');
                ksql.append("        SUM(CI.FFinishedAmount)/SUM(CF.FFinishedAmount)As FRate ").append('\n');
                ksql.append("    FROM ").append(tblCostCostCalPrdDetailResult).append(" CI ").append('\n');
                ksql.append("    INNER JOIN ").append(this._calcParam.GetTempTblCostObjectBase()).append(" O ON O.FCostObjectID=CI.FCostObjectID AND O.FCalculateMode=3 ").append('\n');
                ksql.append("    INNER JOIN ").append(tblCostCalResult).append(" CF ").append('\n');
                ksql.append("          ON CF.FCostCenterID=CI.FCostCenterID AND CF.FCostObjectID=CI.FCostObjectID AND CF.FCostItemID=CI.FCostItemID ").append('\n');
                ksql.append("    GROUP BY ").append(sCostCenter_CI_G).append(" CI.FCostObjectID,CI.FProductID,CI.FLot,CI.FCostItemID ").append('\n');
                ksql.append("    HAVING SUM(CF.FFinishedAmount)<>0 ").append('\n');
                NCMDbUtil.execute((Context)this._calcParam.ctx, (String)ksql.toString());
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_CalPrdByClassTotalTbl, (String)"FCostCenterID", (boolean)false, (boolean)false);
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)T_NCM_CalPrdByClassTotalTbl, (String)"FCostObjectID,FProductID,FProdBatchNo,FCostItemID", (boolean)false, (boolean)false);
                sb.append("truncate table " + this._calcParam.GetTempTblStockInDataByStep() + ";\n");
                NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
                sb.setLength(0);
                sb.append("Insert Into ").append(this._calcParam.GetTempTblStockInDataByStep()).append(" \n").append("Select newbosid('12345678'), ").append(sCostCenter_C).append(" C.FCostObjectID,isnull(C.FProductId,N' ') as FProductId,C.FProdBatchNo,C.FCostItemID,PP.FTotalFinishedQty,CT.FTotalFinishedAmount,").append('\n').append("\tC.FCostItemQty,C.FCostItemAmount,").append('\n').append("\tM.FMaterialID,M.FMatBatchNo,IsNull(M.FMatIsParticipateReduct,0)AS FMatIsParticipateReduct,").append('\n').append("\tM.FQty*Isnull(R.FRate,1) As FMatQty,Round(M.FAmount*Isnull(R.FRate,1),CY.FPrecision) As FMatAmount,Isnull(F.FHasCoef,0)As FHasCoef,Isnull(F2.FHasCoef2,0)As FHasCoef2,").append('\n').append("\tISNULL(bnPrd.FNodeID,0)AS FPrdBatchNodeID,ISNULL(bnCI.FNodeID,0)AS FCostItemNodeID ").append('\n').append("").append('\n').append("FROM ").append(T_NCM_CalPrdDetailTbl).append(" C ").append('\n').append("LEFT JOIN ").append(T_NCM_CalPrdTotalAmtTbl).append(" CT ").append('\n').append("     ON ").append(sCostCenter_CT_C).append(" CT.FCostObjectID=C.FCostObjectID AND CT.FProductID=C.FProductID AND isnull(CT.FProdBatchNo,' ')=isnull(C.FProdBatchNo,' ') ").append('\n').append("LEFT JOIN ").append(T_NCM_CalPrdTotalQtyTbl).append(" PP").append('\n').append("     ON ").append(sCostCenter_PP_C).append(" PP.FCostObjectID=C.FCostObjectID AND PP.FProductID=C.FProductID AND isnull(PP.FProdBatchNo,' ')=isnull(C.FProdBatchNo,' ') ").append('\n').append("LEFT JOIN ").append(T_NCM_CalMatDetailTbl).append(" M").append('\n').append("     ON ").append(sCostCenter_M_C).append(" M.FCostObjectID=C.FCostObjectID AND M.FCostItemID=C.FCostItemID").append('\n').append("LEFT JOIN ").append(T_NCM_CalPrdByClassTotalTbl).append(" R ").append('\n').append("     ON ").append(sCostCenter_R_C).append(" R.FProductID=C.FProductID AND isnull(R.FProdBatchNo,' ')=isnull(C.FProdBatchNo, N' ') AND R.FCostItemID=M.FCostItemID ").append('\n').append("INNER JOIN t_NCM_CostItem CI ON CI.FID=C.FCostItemID").append('\n').append("LEFT JOIN ").append(this._calcParam.GetTempTblMaterialBase()).append(" IC ON IC.FMaterialID=M.FMaterialID").append('\n').append("LEFT JOIN ").append(tblBranchNode).append(" bnPrd ON bnPrd.FNodeStr=(C.FProductID || CASE WHEN C.FProdBatchNo<>N''THEN '").append("#@").append("'||C.FProdBatchNo ELSE N'' END) ").append('\n').append("LEFT JOIN ").append(tblBranchNode).append(" bnCI ON bnCI.FNodeStr=C.FCostItemID ").append('\n').append("LEFT JOIN (").append('\n').append("\tSELECT DISTINCT W.FCostObjectID,W.FProductID,W.FProdBatchNo,W.FSubCostItemID,W.FSubProductID,W.FSubProdBatchNo,1 As FHasCoef ").append('\n').append("\tFROM ").append(this.dataCache.getBopWIPCoefTable()).append(" W ").append('\n');
                if (!this._calcParam.isRevertAllProduct) {
                    sb.append("\tINNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON mcst.FMaterialID = W.FProductId AND mcst.FIsParticipateReduct=1 ").append('\n');
                }
                sb.append("\tWHERE FCalculatePeriodID='").append(this._calcParam.periodId).append("'").append('\n').append(")F ON F.FCostObjectID=C.FCostObjectID AND F.FProductID=C.FProductID AND isnull(F.FProdBatchNo,' ')=isnull(C.FProdBatchNo,' ') AND F.FSubProductID=M.FMaterialID AND isnull(F.FSubProdBatchNo,' ')=isnull(M.FMatBatchNo,' ') and F.FSubCostItemID=M.FCostItemID ").append('\n').append("LEFT JOIN (").append('\n').append("\tSELECT DISTINCT W.FProductID,W.FProdBatchNo,1 As FHasCoef2 ").append('\n').append("\tFROM ").append(this.dataCache.getBopInvCoefTable()).append(" W ").append('\n');
                if (!this._calcParam.isRevertAllProduct) {
                    sb.append("\tINNER JOIN ").append(this._calcParam.GetTempTblMaterialCost()).append(" mcst ON mcst.FMaterialID = W.FProductId AND mcst.FIsParticipateReduct=1 ").append('\n');
                }
                sb.append("\tWHERE FCalculatePeriodID='").append(this._calcParam.prePeriodId).append("'").append('\n').append(")F2 ON F2.FProductID=M.FMaterialID AND isnull(F2.FProdBatchNo,' ')= isnull(M.FMatBatchNo,' ') ").append('\n').append("LEFT JOIN T_ORG_Company CMP ON CMP.FID= '").append(this._calcParam.companyId).append("' ").append('\n').append("LEFT JOIN T_BD_Currency CY ON CY.FID=CMP.FBaseCurrencyID ").append('\n').append(";").append('\n');
                NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
                NCMDbUtil.createTempTableIndex((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblStockInDataByStep(), (String)"FCostCenterID,FCostObjectID,FProductID,FCostItemID,FMaterialID", (boolean)false, (boolean)false);
                if (T_NCM_CalPrdDetailTbl == null) break block18;
            }
            catch (Throwable throwable) {
                if (T_NCM_CalPrdDetailTbl != null) {
                    NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, T_NCM_CalPrdDetailTbl);
                }
                if (T_NCM_CalPrdTotalAmtTbl != null) {
                    NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, T_NCM_CalPrdTotalAmtTbl);
                }
                if (T_NCM_CalPrdTotalQtyTbl != null) {
                    NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, T_NCM_CalPrdTotalQtyTbl);
                }
                if (T_NCM_CalMatDetailTbl != null) {
                    NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, T_NCM_CalMatDetailTbl);
                }
                if (T_NCM_CalPrdByClassTotalTbl != null) {
                    NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, T_NCM_CalPrdByClassTotalTbl);
                }
                throw throwable;
            }
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)T_NCM_CalPrdDetailTbl);
        }
        if (T_NCM_CalPrdTotalAmtTbl != null) {
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)T_NCM_CalPrdTotalAmtTbl);
        }
        if (T_NCM_CalPrdTotalQtyTbl != null) {
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)T_NCM_CalPrdTotalQtyTbl);
        }
        if (T_NCM_CalMatDetailTbl != null) {
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)T_NCM_CalMatDetailTbl);
        }
        if (T_NCM_CalPrdByClassTotalTbl != null) {
            NCMDbUtil.releaseTempTable((Context)this._calcParam.ctx, (String)T_NCM_CalPrdByClassTotalTbl);
        }
        return new StringBuffer("select * from " + this._calcParam.GetTempTblStockInDataByStep() + " order by FCostobjectId,FProductId,FProdBatchNo,FCostItemID");
    }

    protected IRowSet GetInnerReportDataByLayer(String costCenterID, String costObjectID, String productID, String prodBatchNo, int layer, String branch) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        String tblBranchNode = this._calcParam.GetTBL_RecoveryTreeBranchNode();
        sb.append("Select S.FID,S.FCostCenterID,S.FCostObjectID,S.FProductID,S.FProdBatchNo,S.FIsLeaf, ").append('\n').append("\tCASE WHEN  S.FMaterialID is null THEN S.FBranch ||'.'|| to_char(bnCI.FNodeID) ELSE S.FBranch ||'.'||to_char(bnPrd.FNodeID)END As FBranch ").append('\n').append("FROM ").append(this._calcParam.GetTempTBL_CostRecoveryReport()).append(" S ").append('\n').append("LEFT JOIN ").append(tblBranchNode).append(" bnPrd ON bnPrd.FNodeStr=(S.FMaterialID || CASE WHEN S.FMatBatchNo<>N''THEN '").append("#@").append("'||S.FMatBatchNo ELSE N'' END) ").append('\n').append("LEFT JOIN ").append(tblBranchNode).append(" bnCI ON bnCI.FNodeStr=S.FCostItemID ").append('\n').append("WHERE S.FLayer=").append(layer).append('\n');
        if (costCenterID != null) {
            sb.append("\tAND S.FCostCenterID='").append(costCenterID).append("'").append('\n');
        }
        if (costObjectID != null) {
            sb.append("\tAND S.FCostObjectID='").append(costObjectID).append("'").append('\n');
        }
        if (productID != null) {
            sb.append("\tAND S.FProductID='").append(productID).append("'").append('\n');
        }
        if (prodBatchNo != null) {
            sb.append("\tAND S.FProdBatchNo='").append(prodBatchNo).append("'").append('\n');
        }
        if (branch != null) {
            sb.append("\tAND S.FBranch like '").append(branch).append("%'").append('\n');
        }
        sb.append("ORDER BY S.FCostCenterID,S.FCostObjectID,S.FProductID,S.FProdBatchNo,isnull(S.FCostItemNumber,N' '),isnull(S.FMaterialNumber,N' ') ").append('\n').append(";").append('\n');
        IRowSet rs = NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)sb.toString());
        return rs;
    }

    class SortInfo {
        private String _id;
        private String _parentID;
        private int _sort;

        public SortInfo(String id, String parentID, int sort) {
            this._id = id;
            this._parentID = parentID;
            this._sort = sort;
        }

        public String get_id() {
            return this._id;
        }

        public void set_id(String _id) {
            this._id = _id;
        }

        public String get_parentID() {
            return this._parentID;
        }

        public void set_parentID(String _parentid) {
            this._parentID = _parentid;
        }

        public int get_sort() {
            return this._sort;
        }

        public void set_sort(int _sort) {
            this._sort = _sort;
        }
    }
}

