/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Recovery.Calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.RecoveryCalcLogCollection;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.BatchRecoveryIterator.BatchRecoveryByHardcodeIterator;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.BatchRecoveryIterator.IBatchRecoveryIterator;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.CalcParam;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.IRecoveryCalc;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.RecoveryCalcByEnd;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.RecoveryCalcByStep;
import com.kingdee.eas.ncm.common.log.app.NCMLogger;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.task.CostTaskStatusEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.app.CostTaskExecutor;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RecoveryCalcDispatch {
    private CalcParam _calcParam;
    private IRecoveryCalc _calculator;
    private IBatchRecoveryIterator _iterator;
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.app.Recovery.Calc.RecoveryCalcDispatch");

    public RecoveryCalcDispatch(CalcParam calcParam) throws BOSException, EASBizException {
        Assert.that((calcParam != null ? 1 : 0) != 0);
        this._calcParam = calcParam;
        this._calculator = this._calcParam.recoveryModel.getValue().compareTo("0") == 0 ? new RecoveryCalcByEnd(this._calcParam) : new RecoveryCalcByStep(this._calcParam);
        this._iterator = new BatchRecoveryByHardcodeIterator(this._calcParam, this._calculator);
    }

    public HashMap DoCalc(Context ctx) throws BOSException, EASBizException {
        boolean isCalcSuccess = false;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        try {
            HashSet<String> busiTblNames;
            Logger logger = NCMLogger.getLogger();
            this.genCostObjectByPurInWarehsBill();
            this.initTempTBLCostObjectLot(ctx);
            this.initTempTBLCostObjectBase(ctx);
            this.initTempTBLMaterialCost(ctx);
            this.initTempTBLMaterialBase(ctx);
            this.initTempTBLMaterialComp(ctx);
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"31_CalcDispatch", (Locale)ctx.getLocale()));
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"125_RecoveryCalcDispatch", (Locale)ctx.getLocale()));
            int i = 1;
            int iBatch = 0;
            this._iterator.FirstBatch();
            while (!this._iterator.IsDone()) {
                CostTaskEntryInfo entry;
                logger.info((Object)("+++++++++++\u7b2c" + i + "\u6279\u5f00\u59cb+++++++++++"));
                if (iBatch == 0) {
                    entry = (CostTaskEntryInfo)this._calcParam.costTaskEntriesMap.get("recoveryStepRank" + this._calcParam.dispRank);
                    if (entry != null) {
                        entry.setProgressInfo(iBatch + "/" + ((BatchRecoveryByHardcodeIterator)this._iterator).iBatchCount);
                    }
                    this.updateCostCalEntry(this._calcParam.ctx, "recoveryStepRank" + this._calcParam.dispRank, null, null, -1L, -1L);
                }
                this._iterator.RecoveryCurrBatch();
                ++iBatch;
                logger.info((Object)("+++++++++++\u7b2c" + i++ + "\u6279\u7ed3\u675f+++++++++++"));
                entry = (CostTaskEntryInfo)this._calcParam.costTaskEntriesMap.get("recoveryStepRank" + this._calcParam.dispRank);
                if (entry != null) {
                    entry.setProgressInfo(iBatch + "/" + ((BatchRecoveryByHardcodeIterator)this._iterator).iBatchCount);
                }
                this.updateCostCalEntry(this._calcParam.ctx, "recoveryStepRank" + this._calcParam.dispRank, null, null, -1L, -1L);
                this._iterator.NextBatch();
            }
            isCalcSuccess = true;
            if (this._calcParam.recoveryModel.getValue().compareTo("0") == 0) {
                busiTblNames = new HashSet<String>();
                busiTblNames.add("T_NCM_CostRecoveryReportByEnd");
                busiTblNames.add("T_NCM_CostRecoveryVourchData");
                busiTblNames.add("T_NCM_BopInvCoefByEnd");
                busiTblNames.add("T_NCM_BopWIPCoefByEnd");
                NCMDynamicTableManager.buildIndexsOfBusiTbls((Context)this._calcParam.ctx, (String)this._calcParam.companyId, busiTblNames);
            } else {
                busiTblNames = new HashSet();
                busiTblNames.add("T_NCM_CostRecoveryReportByEnd");
                busiTblNames.add("T_NCM_CostRecoveryReportByStep");
                busiTblNames.add("T_NCM_CostRecoveryVourchData");
                busiTblNames.add("T_NCM_BopInvCoefByStep");
                busiTblNames.add("T_NCM_BopWIPCoefByStep");
                NCMDynamicTableManager.buildIndexsOfBusiTbls((Context)this._calcParam.ctx, (String)this._calcParam.companyId, busiTblNames);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"126_RecoveryCalcDispatch", (Locale)ctx.getLocale()));
            RecoveryCalcLogCollection logData = this._calcParam.calcLog.GetCalcLogData();
            ret.put("logData", (Object)logData);
            if (logData != null && logData.size() > 0) {
                isCalcSuccess = false;
            }
        }
        ret.put("HasError", String.valueOf(!isCalcSuccess));
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"46_CalcDispatch", (Locale)ctx.getLocale()));
        return ret;
    }

    private void updateCostCalEntry(Context ctx, String entryKey, CostTaskStatusEnum status, CostTaskResultEnum result, long beginTime, long endTime) throws BOSException, EASBizException {
        CostTaskEntryInfo entry = (CostTaskEntryInfo)this._calcParam.costTaskEntriesMap.get(entryKey);
        CostTaskExecutor executor = this.getCostTaskExecutor();
        if (entry != null && executor != null) {
            if (status != null) {
                entry.setStatus(status);
            }
            if (result != null) {
                entry.setResult(result);
            }
            if (beginTime > 0L) {
                entry.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)ctx)));
            }
            if (endTime > 0L) {
                entry.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)ctx)));
            }
            executor.updateCostTaskEntry(entry);
        }
    }

    private CostTaskExecutor getCostTaskExecutor() {
        return this._calcParam.costTask;
    }

    public void genCostObjectByPurInWarehsBill() throws BOSException, EASBizException {
        if (!this._calcParam.isGenCOByPurInWarehsBill) {
            return;
        }
        String companyID = this._calcParam.companyId;
        String periodNumber = this._calcParam.periodDispNumber;
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct entry.fmaterialID,entry.FLot from t_im_PurInWarehsBill bill \n").append(" inner join T_IM_PurInWarehsEntry entry on bill.fid = entry.fparentID \n").append(" inner join t_org_Storage stor on stor.fid = bill.FStorageOrgUnitID \n").append(" inner join T_ORG_UnitRelation unitRela on unitRela.FFromUnitID = stor.fid \n").append(" inner join t_bd_MaterialCompanyInfo matComp on matComp.fMaterialID = entry.FMaterialID \n").append(" where bill.FMonth = ").append(periodNumber).append(" \n").append("   and bill.FBaseStatus = 4 \n").append("   and unitRela.FToUnitID = '").append(companyID).append("' \n").append("   and matComp.FCompanyID = '").append(companyID).append("' \n").append("   and matComp.FAccountType = 5 \n").append("   and matComp.FCalculateType = 2 \n").append("   and NOT EXISTS (select 1 from t_bd_costObject co where co.FStdProductIDID = entry.FMaterialID and co.FbatchNumber = entry.Flot and FCalculateMode = 4 ) \n");
        IRowSet matSet = NCMDbUtil.executeQuery((Context)this._calcParam.ctx, (String)sb.toString());
        CostObjectCollection costColl = new CostObjectCollection();
        try {
            while (matSet.next()) {
                String matID = matSet.getString(1);
                String batchNumber = matSet.getString(2);
                MaterialInfo matInfo = new MaterialInfo();
                matInfo.setId(BOSUuid.read((String)matID));
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)companyID));
                CostObjectInfo coInfo = new CostObjectInfo();
                coInfo.setStdProductID(matInfo);
                coInfo.setCompany(company);
                coInfo.setRelatedId(BOSUuid.read((String)matID));
                coInfo.setBatchNumber(batchNumber);
                costColl.add(coInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        CostObjectFactory.getLocalInstance((Context)this._calcParam.ctx).addnewBybatch((IObjectCollection)costColl);
    }

    private void initTempTBLCostObjectLot(Context ctx) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert into " + this._calcParam.GetTempTblCostObjectLot()).append('\n');
        sb.append(" (FID,FCostObjectID,FProductId,FProdBatchNo,FCostObjBatchNo)").append('\n');
        sb.append("\tSELECT  newbosid('DFA50FD9') FID,data.FCostObjectID,data.FProductId,data.FProdBatchNo,data.FCostObjBatchNo ").append('\n');
        sb.append(" From (").append('\n');
        sb.append("\t    SELECT  distinct CO.FID As FCostObjectID,COE.FRelatedID As FProductId,Isnull(CO.FBatchNumber,N' ') As FProdBatchNo,Isnull(CO.FBatchNumber,N' ') As FCostObjBatchNo ").append('\n');
        sb.append("\t    FROM T_BD_CostObject CO ").append('\n');
        sb.append("\t      LEFT JOIN T_BD_COstObjectEntry COE on COE.FParentId = CO.Fid ").append('\n');
        sb.append("\t    WHERE CO.FIsForbiden = 0 AND CO.FCalculateMode=4 AND CO.FCompanyID = '").append(this._calcParam.companyId).append("' ").append('\n');
        sb.append("\t    UNION ").append('\n');
        sb.append("\t    SELECT '' As FCostObjectID,FMaterialID As FProductId,FLot As FProdBatchNo,FCostObjBatchNo ").append('\n');
        sb.append("\t    FROM ").append(this._calcParam.GetTBL_LotMapping()).append(" ) data ").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblCostObjectLot());
    }

    private void initTempTBLCostObjectBase(Context ctx) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert into " + this._calcParam.GetTempTblCostObjectBase()).append('\n');
        sb.append(" (FID ,FCostObjectId,FProductId,FCostObjBatchNo,FCalculateMode,FName,FNumber)").append('\n');
        sb.append("\tSELECT  newbosid('DFA50FD9') FID,CO.FID,COE.FRelatedID,CO.FBatchNumber,CO.FCalculateMode,FName_" + ctx.getLocale() + ",FNumber ").append('\n');
        sb.append("\t    FROM T_BD_CostObject CO ").append('\n');
        sb.append("\t      LEFT JOIN T_BD_COstObjectEntry COE on COE.FParentId = CO.Fid ").append('\n');
        sb.append("\t    WHERE CO.FIsForbiden = 0 AND FIsMainProduct = 1 AND CO.FCompanyID = '").append(this._calcParam.companyId).append("' ").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblCostObjectBase());
    }

    private void initTempTBLMaterialCost(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert into " + this._calcParam.GetTempTblMaterialCost()).append('\n');
        sb.append(" (FID,FOrgUnit,FMaterialID,FISPARTICIPATEREDUCT)").append('\n');
        sb.append("\tSELECT  newbosid('DFA50FD9') FID,FOrgUnit,FMaterialID,FISPARTICIPATEREDUCT ").append('\n');
        sb.append(" From T_BD_MaterialCost ").append('\n');
        sb.append("\tWhere FOrgUnit = '").append(this._calcParam.companyId).append("'").append('\n');
        sb.append("\tAND  FStatus=1 ").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblMaterialCost());
    }

    private void initTempTBLMaterialBase(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert into " + this._calcParam.GetTempTblMaterialBase()).append('\n');
        sb.append(" (FMaterialID,FBaseUnit,FName,FNumber,FModel,FPricePrecision )").append('\n');
        sb.append("\tSELECT mat.FID,mat.FBaseUnit,FName_" + ctx.getLocale() + ",FNumber,FModel,FPricePrecision ").append('\n');
        sb.append(" From T_BD_Material mat").append('\n');
        sb.append(" where EXISTS ( select 1 from T_BD_MaterialCompanyInfo matCo ").append('\n');
        sb.append("\t                 Where mat.FID = matCo.FMaterialID AND FCompanyID = '").append(this._calcParam.companyId).append("'").append('\n');
        sb.append("\t                   AND  FStatus=1 );").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblMaterialBase());
    }

    private void initTempTBLMaterialComp(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert into " + this._calcParam.GetTempTblMaterialComp()).append('\n');
        sb.append(" (FID,FMaterialID,FCalculateType)").append('\n');
        sb.append("\tSELECT  newbosid('DFA50FD9') FID,FMaterialID,FCalculateType ").append('\n');
        sb.append(" From t_bd_materialcompanyinfo").append('\n');
        sb.append("\tWhere FCompanyID = '").append(this._calcParam.companyId).append("'").append('\n');
        sb.append("\tAND  FStatus=1 ").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.ctx, (String)sb.toString(), (String)";");
        sb.delete(0, sb.length());
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.ctx, (String)this._calcParam.GetTempTblMaterialComp());
    }
}

