/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Recovery.Check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CostObjectRankFactory;
import com.kingdee.eas.ncm.cal.ICostObjectRank;
import com.kingdee.eas.ncm.cal.LowLevelCodeTypeEnum;
import com.kingdee.eas.ncm.cal.RecoveryCheckLogCollection;
import com.kingdee.eas.ncm.cal.app.Recovery.Check.CheckParam;
import com.kingdee.eas.ncm.cal.app.Recovery.Check.RecoveryCheckLog;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class CheckBase {
    protected CheckParam _checkParam;
    protected boolean bCanContinueRecovery = true;
    protected RecoveryCheckLog _log;
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.app.Recovery.Check.CheckBase");

    public CheckBase(CheckParam checkParam) throws BOSException {
        Assert.that((checkParam != null ? 1 : 0) != 0);
        this._checkParam = checkParam;
        this._log = new RecoveryCheckLog(checkParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap DoCheck(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        boolean hasError = false;
        try {
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"127_CheckBase", (Locale)ctx.getLocale()));
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"128_CheckBase", (Locale)ctx.getLocale()));
            this._log.ClearPreCheckLog();
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"129_CheckBase", (Locale)ctx.getLocale()));
            this._log.AddCheck_HeadPreSet();
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"130_CheckBase", (Locale)ctx.getLocale()));
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"131_CheckBase", (Locale)ctx.getLocale()));
            if (this.ItemCheck_BoPInvSFPCost()) {
                hasError = true;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"132_CheckBase", (Locale)ctx.getLocale()));
            if (this.ItemCheck_Nested_BoPInvSFPCost()) {
                hasError = true;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"133_CheckBase", (Locale)ctx.getLocale()));
            if (this.ItemCheck_HasRealCostResult()) {
                hasError = true;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"134_CheckBase", (Locale)ctx.getLocale()));
            if (this.ItemCheck_ContinuousRecovery()) {
                hasError = true;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"135_CheckBase", (Locale)ctx.getLocale()));
            if (this.ItemCheck_HasVourch()) {
                hasError = true;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"136_CheckBase", (Locale)ctx.getLocale()));
            this._log.UpdateHeadPreSetLog();
        }
        finally {
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"126_RecoveryCalcDispatch", (Locale)ctx.getLocale()));
            RecoveryCheckLogCollection logData = this._log.GetCheckLogData();
            ret.put("logData", (Object)logData);
        }
        ret.put("HasError", String.valueOf(hasError));
        ret.put("CanContinueRecovery", String.valueOf(this.bCanContinueRecovery));
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"137_CheckBase", (Locale)ctx.getLocale()));
        return ret;
    }

    protected boolean ItemCheck_BoPInvSFPCost() throws BOSException, EASBizException {
        boolean ret = false;
        StringBuffer sb = new StringBuffer();
        String checkItem = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_ItemCheck_BoPInvSFPCost");
        String adviceHandle = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item1_adviceHandle");
        String errorDetail1 = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item1_errorDetail_1");
        String errorDetail2 = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item1_errorDetail_2");
        try {
            String tblBopInvCoef = this._checkParam.GetTBL_BopInvCoef();
            sb.append("Create Table _tempTblMaterialCost (").append('\n').append("FProductID VARCHAR(44),FProdBatchNo VARCHAR(80),FMaterialNumber VARCHAR(80),FMaterialName VARCHAR(256))").append('\n');
            String temptable = NCMDbUtil.createTempTable((Context)this._checkParam.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" insert into ").append(temptable).append(" (FProductID ,FProdBatchNo ,FMaterialNumber ,FMaterialName)").append('\n');
            sb.append("\t  SELECT bal.FMaterialID as FProductID, ISNULL(O.FCostObjBatchNo,N' ')As FProdBatchNo,M.FNumber As FMaterialNumber, M.FName").append(" as FMaterialName ").append('\n');
            sb.append("\t  FROM T_IM_InventoryBalance bal ").append('\n');
            sb.append("\t    INNER JOIN ").append(this._checkParam.GetTempTblMaterialComp()).append(" mat ON  mat.FMaterialID = bal.FMaterialID AND mat.FCalculateType=2 ").append('\n');
            sb.append("\t    LEFT OUTER JOIN ").append(this._checkParam.GetTempTblMaterialBase()).append(" M ON M.FMaterialID=bal.FMaterialID ").append('\n');
            sb.append("     LEFT JOIN ").append(this._checkParam.GetTempTblCostObjectLot()).append(" O ").append('\n');
            sb.append("       ON O.FProductId=bal.FMaterialID AND O.FProdBatchNo=Isnull(bal.FLot, N' ')").append('\n');
            sb.append("\t  WHERE bal.FYear=").append(this._checkParam.periodYear).append(" AND bal.FPeriod=").append(this._checkParam.periodNumber).append('\n');
            sb.append("\t\tAND bal.FCompanyOrgUnitID='").append(this._checkParam.companyId).append("' ").append('\n');
            sb.append("\t  GROUP BY bal.FMaterialID, O.FProdBatchNo,O.FCostObjBatchNo, M.FNumber, M.FName").append('\n');
            sb.append("\t  HAVING SUM(bal.FPeriodBeginQty) <>0 ").append('\n');
            NCMDbUtil.execute((Context)this._checkParam.ctx, (String)sb.toString());
            NCMDbUtil.createTempTableIndex((Context)this._checkParam.ctx, (String)temptable, (String)"FProductID", (boolean)false, (boolean)false);
            NCMDbUtil.analyzeTempTable((Context)this._checkParam.ctx, (String)temptable);
            sb.setLength(0);
            String errorInfo_Inv = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item1_errorInfo_Inv");
            sb.append("SELECT Distinct D.FMaterialNumber, D.FMaterialName , D.FProdBatchNo ").append('\n').append("From ").append(temptable).append(" D ").append("WHERE NOT EXISTS(").append("\tSELECT 1 ").append('\n').append("\tFROM T_NCM_BoPInvSFPCost I ").append('\n').append("\tWHERE I.FBillStatus=4 AND I.FCompanyOrg='").append(this._checkParam.companyId).append("' ").append('\n').append("\t\tAND I.FProductID=D.FProductID AND Isnull(I.FLot,N' ') =D.FProdBatchNo ").append('\n');
            if (!this._checkParam.isReInitBop && this._checkParam.lastestPeriodId != null) {
                sb.append(")AND NOT EXISTS(").append("\tSELECT 1 ").append('\n').append("\tFROM ").append(tblBopInvCoef).append(" S ").append('\n').append("\tWHERE S.FCompanyID='").append(this._checkParam.companyId).append("' AND S.FCalculatePeriodID='").append(this._checkParam.prePeriodId).append("' ").append('\n').append("\t\tAND S.FProductID=D.FProductID AND S.FProdBatchNo=D.FProdBatchNo ").append('\n');
            }
            sb.append(")").append('\n').append("  and not EXISTS ( Select 1 From T_CAL_CostObjectRank cor ").append('\n').append("                        INNER JOIN T_CAL_CostObjectRankEntry corEntry on cor.FID = corEntry.FParentID ").append('\n').append("                        INNER JOIN ").append(this._checkParam.GetTempTblCostObjectBase()).append(" co").append("                          ON corEntry.FCostObjectID = co.FCostObjectId ").append("                        Where co.FProductId = D.FProductID and cor.FCompanyOrg = '").append(this._checkParam.companyId).append("' and cor.FCalCulatePeriod = '").append(this._checkParam.periodId).append("'").append('\n').append("                          AND corEntry.FRank = 0 and cor.FLlcType = 0 \n").append('\n').append("              )").append('\n').append("ORDER BY D.FMaterialNumber, D.FMaterialName , D.FProdBatchNo").append('\n').append(";");
            IRowSet rs = NCMDbUtil.executeQuery((Context)this._checkParam.ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            while (rs.next()) {
                ret = true;
                if (rs.getString("FProdBatchNo").compareTo(" ") == 0) {
                    this._log.AddCheckLog_DetailLog(sb, checkItem, "1", errorInfo_Inv, adviceHandle, MessageFormat.format(errorDetail1, rs.getString("FMaterialNumber"), rs.getString("FMaterialName")));
                    continue;
                }
                this._log.AddCheckLog_DetailLog(sb, checkItem, "1", errorInfo_Inv, adviceHandle, MessageFormat.format(errorDetail2, rs.getString("FMaterialNumber"), rs.getString("FMaterialName"), rs.getString("FProdBatchNo")));
            }
            if (sb.length() > 0) {
                NCMDbUtil.BatchSqlExecute((Context)this._checkParam.ctx, (String)sb.toString(), (String)";");
            }
            NCMDbUtil.releaseTempTable((Context)this._checkParam.ctx, (String)temptable);
            String tblBopWIPCoef = this._checkParam.GetTBL_BopWIPCoef();
            String errorInfo_WIP = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item1_errorInfo_Bal");
            String tblBalance = this._checkParam.GetTBL_Balance();
            String tblBalanceEntry = this._checkParam.GetTBL_BalanceEntry();
            String tblBalanceMatDetail = this._checkParam.GetTBL_BalanceMatDetail();
            sb.delete(0, sb.length());
            sb.append("SELECT Distinct D.FMaterialNumber, D.FMaterialName, D.FMatBatchNo ").append('\n').append("FROM (").append('\n').append("\tSELECT OBJ.FProductId As FProductID,ISNULL(OBJ.FCostObjBatchNo,N' ')As FProdBatchNo,balMatDetail.FMaterialID, ISNULL(O.FCostObjBatchNo,N' ') As FMatBatchNo,M.FNumber As FMaterialNumber, M.FName").append(" as FMaterialName ").append('\n').append("\tFROM ").append(tblBalanceMatDetail).append(" balMatDetail ").append('\n').append("\tINNER JOIN ").append(tblBalanceEntry).append(" balMat ON balMat.FID=balMatDetail.FParentID ").append('\n').append("\tINNER JOIN ").append(tblBalance).append(" bal ON bal.FID=balMat.FParentID ").append('\n').append("\tINNER JOIN ").append(this._checkParam.GetTempTblMaterialComp()).append(" mat ON mat.FMaterialID = balMatDetail.FMaterialID AND mat.FCalculateType=2 ").append('\n').append("\tLEFT OUTER JOIN ").append(this._checkParam.GetTempTblMaterialBase()).append(" M ON M.FMaterialID=balMatDetail.FMaterialID ").append('\n').append("\tLEFT OUTER JOIN ").append(this._checkParam.GetTempTblCostObjectBase()).append(" OBJ ON OBJ.FCostobjectID=bal.FCostObjectID ").append('\n').append("   LEFT JOIN ").append(this._checkParam.GetTempTblCostObjectLot()).append(" O ").append('\n').append("     ON O.FProductId=balMatDetail.FMaterialID AND O.FProdBatchNo=balMatDetail.FBatchNo ").append('\n').append("\tWHERE bal.FCompanyOrg='").append(this._checkParam.companyId).append("' AND bal.FCalculatePeriodID='").append(this._checkParam.periodId).append("'").append('\n').append("\tGROUP BY OBJ.FProductId,OBJ.FCostObjBatchNo,balMatDetail.FMaterialID, O.FProdBatchNo,O.FCostObjBatchNo, M.FNumber, M.FName").append('\n').append("\tHAVING SUM(balMatDetail.FQty) <>0 ").append('\n').append(")D ").append('\n').append("WHERE NOT EXISTS(").append("\tSELECT 1 ").append('\n').append("\tFROM T_NCM_BoPInvSFPCost I ").append('\n').append("\tWHERE I.FBillStatus=4 AND I.FCompanyOrg='").append(this._checkParam.companyId).append("' ").append('\n').append("\t\tAND I.FProductID=D.FMaterialID AND Isnull(I.FLot,N' ') =D.FMatBatchNo ").append('\n');
            if (!this._checkParam.isReInitBop && this._checkParam.lastestPeriodId != null) {
                sb.append(")AND NOT EXISTS(").append("\tSELECT 1 ").append('\n').append("\tFROM ").append(tblBopWIPCoef).append(" S ").append('\n').append("\tWHERE S.FCompanyID='").append(this._checkParam.companyId).append("' AND S.FCalculatePeriodID='").append(this._checkParam.prePeriodId).append("' ").append('\n').append("\t\tAND S.FProductID=D.FProductID AND S.FProdBatchNo=D.FProdBatchNo AND S.FSubProductID=D.FMaterialID AND S.FSubProdBatchNo=D.FMatBatchNo ").append('\n');
            }
            sb.append(")").append('\n').append("  and not EXISTS ( Select 1 From T_CAL_CostObjectRank cor ").append('\n').append("                        INNER JOIN T_CAL_CostObjectRankEntry corEntry on cor.FID = corEntry.FParentID ").append('\n').append("                        INNER JOIN ").append(this._checkParam.GetTempTblCostObjectBase()).append(" co ON corEntry.FCostObjectID = co.FCostobjectID ").append('\n').append("                        Where co.FProductID = D.FMaterialID and cor.FCompanyOrg = '").append(this._checkParam.companyId).append("' and cor.FCalCulatePeriod = '").append(this._checkParam.periodId).append("'").append('\n').append("                          AND corEntry.FRank = 0 and cor.FLlcType = 0 \n").append('\n').append("              )").append('\n').append("ORDER BY D.FMaterialNumber, D.FMaterialName, D.FMatBatchNo").append('\n').append(";");
            IRowSet rs2 = NCMDbUtil.executeQuery((Context)this._checkParam.ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            while (rs2.next()) {
                ret = true;
                if (rs2.getString("FMatBatchNo").compareTo(" ") == 0) {
                    this._log.AddCheckLog_DetailLog(sb, checkItem, "2", errorInfo_WIP, adviceHandle, MessageFormat.format(errorDetail1, rs2.getString("FMaterialNumber"), rs2.getString("FMaterialName")));
                    continue;
                }
                this._log.AddCheckLog_DetailLog(sb, checkItem, "2", errorInfo_WIP, adviceHandle, MessageFormat.format(errorDetail2, rs2.getString("FMaterialNumber"), rs2.getString("FMaterialName"), rs2.getString("FMatBatchNo")));
            }
            if (sb.length() > 0) {
                NCMDbUtil.BatchSqlExecute((Context)this._checkParam.ctx, (String)sb.toString(), (String)";");
            }
            return ret;
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean ItemCheck_Nested_BoPInvSFPCost() throws BOSException, EASBizException {
        boolean ret = false;
        ICostObjectRank iRank = CostObjectRankFactory.getLocalInstance(this._checkParam.ctx);
        Map co_billNumbers = null;
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("companyId", this._checkParam.companyId);
            param.put("periodId", this._checkParam.periodId);
            param.put("llcType", (Object)LowLevelCodeTypeEnum.CostRecovery);
            co_billNumbers = iRank.checkAndMakeBill(param);
        }
        catch (EASBizException e) {
            if (e.getSubCode() == EASBizException.CHECKBLANK.getCode() || e.getSubCode() == EASBizException.CHECKDUPLICATED.getCode()) {
                return ret;
            }
            throw e;
        }
        if (co_billNumbers == null || co_billNumbers.size() == 0) {
            return ret;
        }
        String checkItem = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_ItemCheck_Nested_BoPInvSFPCost");
        String errorInfo = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item2_errorInfo");
        String adviceHandle = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item2_adviceHandle");
        String errorDetail = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item2_errorDetail");
        Set cos = co_billNumbers.keySet();
        Iterator coItr = cos.iterator();
        Iterator numberItr = null;
        String coNumber = null;
        String billNumber2 = null;
        Set billNumbers = null;
        StringBuffer billList = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        while (coItr.hasNext()) {
            ret = true;
            coNumber = (String)coItr.next();
            billNumbers = (Set)co_billNumbers.get(coNumber);
            for (String billNumber2 : billNumbers) {
                billList.append(",").append(billNumber2);
            }
            this._log.AddCheckLog_DetailLog(sb, checkItem, "1", errorInfo, adviceHandle, MessageFormat.format(errorDetail, coNumber, billList.toString().substring(1)));
            billList.delete(0, billList.length());
        }
        if (sb.length() > 0) {
            NCMDbUtil.execute((Context)this._checkParam.ctx, (String)sb.toString());
        }
        return ret;
    }

    protected boolean ItemCheck_HasRealCostResult() throws BOSException, EASBizException {
        boolean ret = false;
        StringBuffer sb = new StringBuffer();
        String tblCostCalResult = null;
        try {
            tblCostCalResult = this._checkParam.GetTBL_CostCalResult();
            sb.append("SELECT top 1 FID ").append('\n').append("FROM ").append(tblCostCalResult).append('\n').append("WHERE FCompanyID = ? AND FCalculatePeriodID = ? AND FFinishedAmount <>0 ").append('\n');
            Object[] params = new Object[]{this._checkParam.companyId, this._checkParam.periodId};
            IRowSet rs = NCMDbUtil.executeQuery((Context)this._checkParam.ctx, (String)sb.toString(), (Object[])params);
            boolean bl = ret = !rs.next();
            if (ret) {
                this.bCanContinueRecovery = false;
                String checkItem = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_ItemCheck_HasRealCostResult");
                String errorInfo = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item3_errorInfo");
                String adviceHandle = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item3_adviceHandle");
                String errorDetail = MessageFormat.format(CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item3_errorDetail"), this._checkParam.companyName, this._checkParam.periodDispNumber);
                sb.delete(0, sb.length());
                this._log.AddCheckLog_DetailLog(sb, checkItem, "1", errorInfo, adviceHandle, errorDetail);
                NCMDbUtil.execute((Context)this._checkParam.ctx, (String)sb.toString());
            }
            return ret;
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean ItemCheck_ContinuousRecovery() throws BOSException, EASBizException {
        PeriodInfo pre = CalSeverUtils.getPrePeriodInfo(this._checkParam.ctx, this._checkParam.periodId);
        StringBuffer sb = new StringBuffer();
        String tblBopInvCoefByEnd = null;
        try {
            tblBopInvCoefByEnd = this._checkParam.GetTBL_BopInvCoef_View();
            sb.append("SELECT count(1) ").append('\n').append("FROM ").append(tblBopInvCoefByEnd).append(" Inv ").append('\n').append("INNER JOIN t_bd_period PD ON PD.FID=Inv.FCalculatePeriodID ").append('\n').append("WHERE Inv.FCompanyId = ? AND PD.FNumber < ? ").append('\n');
            IRowSet rs = NCMDbUtil.executeQuery((Context)this._checkParam.ctx, (String)sb.toString(), (Object[])new Object[]{this._checkParam.companyId, Integer.valueOf(this._checkParam.periodDispNumber)});
            if (rs.next() && rs.getInt(1) == 0) {
                return false;
            }
            sb.delete(0, sb.length());
            sb.append("SELECT count(1) FID ").append('\n').append("FROM ").append(tblBopInvCoefByEnd).append('\n').append("WHERE FCompanyId = ? AND FCalculatePeriodID = ? ").append('\n');
            Object[] params = new Object[]{this._checkParam.companyId, pre.getId().toString()};
            IRowSet rs2 = NCMDbUtil.executeQuery((Context)this._checkParam.ctx, (String)sb.toString(), (Object[])params);
            if (rs2.next() && rs2.getInt(1) > 0) {
                return false;
            }
            String checkItem = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_ItemCheck_ContinuousRecovery");
            String errorInfo = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item4_errorInfo");
            String adviceHandle = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item4_adviceHandle");
            String errorDetail = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item4_errorDetail");
            sb.delete(0, sb.length());
            this._log.AddCheckLog_DetailLog(sb, checkItem, "1", errorInfo, adviceHandle, errorDetail);
            NCMDbUtil.execute((Context)this._checkParam.ctx, (String)sb.toString());
            return true;
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean ItemCheck_HasVourch() throws BOSException, EASBizException {
        boolean ret = false;
        StringBuffer sb = new StringBuffer();
        String tblCostRecoveryVourchData = null;
        try {
            tblCostRecoveryVourchData = this._checkParam.GetTBL_CostRecoveryVourchData();
            sb.append(" UPDATE\t\t\t\t\t\t\t\t\t\t\t\t\t ").append('\n').append(tblCostRecoveryVourchData).append(" AS RV SET FVoucherID = NULL \t\t\t\t\t\t\t\t ").append('\n').append(" WHERE FVoucherID IS NOT NULL AND NOT EXISTS (              ").append('\n').append("       select 1                                             ").append('\n').append("       from T_GL_Voucher VC                                 ").append('\n').append("       where RV.FVoucherID = VC.FID                         ").append('\n').append(" )                                                          ").append('\n');
            NCMDbUtil.execute((Context)this._checkParam.ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append("SELECT top 1 FID ").append('\n').append("FROM ").append(tblCostRecoveryVourchData).append('\n').append("WHERE FCompanyID = ? AND FCalculatePeriodID = ? AND FVoucherid is not null ").append('\n');
            Object[] params = new Object[]{this._checkParam.companyId, this._checkParam.periodId};
            IRowSet rs = NCMDbUtil.executeQuery((Context)this._checkParam.ctx, (String)sb.toString(), (Object[])params);
            ret = rs.next();
            if (ret) {
                this.bCanContinueRecovery = false;
                String checkItem = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_ItemCheck_HasVourch");
                String errorInfo = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item5_errorInfo");
                String adviceHandle = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item5_adviceHandle");
                String errorDetail = CalculateUtil.getSrvCalResource(this._checkParam.ctx, "Recovery_Check_Item5_errorDetail");
                sb.delete(0, sb.length());
                this._log.AddCheckLog_DetailLog(sb, checkItem, "1", errorInfo, adviceHandle, errorDetail);
                NCMDbUtil.execute((Context)this._checkParam.ctx, (String)sb.toString());
            }
            return ret;
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

