/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.Recovery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.app.Recovery.Calc.CalcParam;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.util.Assert;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecoveryDataCache {
    private static Logger logger = Logger.getLogger((String)RecoveryDataCache.class.getName());
    protected static final char CLF = '\n';
    protected Context ctx = null;
    protected TempTablePool pool = null;
    private CalcParam calcParam = null;
    private String T_NCM_CostCalResult = null;
    private String T_NCM_CostCalMatDetailResult = null;
    private String T_NCM_CostCalPrdResult = null;
    private String T_NCM_BopWIPCoef = null;
    private String T_NCM_BopInvCoef = null;
    private String T_NCM_Balance = null;
    private String T_NCM_BalanceEntry = null;
    private String T_NCM_BalanceMatDetail = null;

    public RecoveryDataCache(Map param) {
        Assert.that((boolean)param.containsKey("calcParam"));
        this.calcParam = (CalcParam)param.get("calcParam");
        this.getContext();
        this.getTempTablePool();
    }

    public Context getContext() {
        if (this.ctx == null) {
            this.ctx = this.calcParam.ctx;
        }
        return this.ctx;
    }

    public TempTablePool getTempTablePool() {
        if (this.pool == null) {
            this.pool = this.calcParam.tempTablePool;
        }
        if (this.pool == null) {
            this.pool = TempTablePool.getInstance((Context)this.getContext());
        }
        return this.pool;
    }

    public void release() {
        TempTablePool pool = this.getTempTablePool();
        if (this.T_NCM_Balance != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_NCM_Balance);
        }
        if (this.T_NCM_BalanceEntry != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_NCM_BalanceEntry);
        }
        if (this.T_NCM_BalanceMatDetail != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_NCM_BalanceMatDetail);
        }
        if (this.T_NCM_CostCalResult != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_NCM_CostCalResult);
        }
        if (this.T_NCM_CostCalMatDetailResult != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_NCM_CostCalMatDetailResult);
        }
        if (this.T_NCM_CostCalPrdResult != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_NCM_CostCalPrdResult);
        }
        if (this.T_NCM_BopWIPCoef != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_NCM_BopWIPCoef);
        }
        if (this.T_NCM_BopInvCoef != null) {
            NCMDbUtil.releaseTempTableByPool((TempTablePool)pool, (String)this.T_NCM_BopInvCoef);
        }
    }

    public String getBalanceTable() throws EASBizException, BOSException {
        if (this.T_NCM_Balance != null) {
            return this.T_NCM_Balance;
        }
        StringBuffer ksql = new StringBuffer();
        ksql.setLength(0);
        ksql.append("create table T ( \n");
        ksql.append("    FID VARCHAR(44) NOT NULL, \n");
        ksql.append("    FCostCenterID VARCHAR(44), \n");
        ksql.append("    FCostObjectID VARCHAR(44), \n");
        ksql.append("    FBopWIPQty VARCHAR(44) \n");
        ksql.append(") \n");
        this.T_NCM_Balance = NCMDbUtil.createTempTableByPool((TempTablePool)this.pool, (String)ksql.toString());
        String T_NCM_Allalance = this.calcParam.GetTBL_Balance();
        String T_NCM_CostObjectRange = this.calcParam.GetTempTBL_CostObjList();
        ksql.setLength(0);
        ksql.append(" Insert Into ").append(this.T_NCM_Balance).append(" \n");
        ksql.append("       (FID,FCostCenterID,FCostObjectID,FBopWIPQty) \n");
        ksql.append(" select FID,FCostCenterID,FCostObjectID,FBopWIPQty \n");
        ksql.append(" From ").append(T_NCM_Allalance).append(" cal \n");
        ksql.append(" Where exists (Select 1 From ").append(T_NCM_CostObjectRange).append(" co \n");
        ksql.append("                  Where co.FCostObjectID = cal.FCostObjectID) \n");
        NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_Balance, (String)"FCostCenterID ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_Balance, (String)"FCostObjectID ASC", (boolean)false, (boolean)false);
        return this.T_NCM_Balance;
    }

    public String getBalanceEntryTable() throws EASBizException, BOSException {
        if (this.T_NCM_BalanceEntry != null) {
            return this.T_NCM_BalanceEntry;
        }
        StringBuffer ksql = new StringBuffer();
        ksql.setLength(0);
        ksql.append("create table T ( \n");
        ksql.append("    FID VARCHAR(44) NOT NULL, \n");
        ksql.append("    FParentID VARCHAR(44), \n");
        ksql.append("    FCostItemID VARCHAR(44), \n");
        ksql.append("    FBoPWIPAmount NUMERIC(28,10), \n");
        ksql.append("    FBopWIPQty NUMERIC(28,10), \n");
        ksql.append("    FPrice NUMERIC(28,10) \n");
        ksql.append(") \n");
        this.T_NCM_BalanceEntry = NCMDbUtil.createTempTableByPool((TempTablePool)this.pool, (String)ksql.toString());
        String T_NCM_AllBalanceEntry = this.calcParam.GetTBL_BalanceEntry();
        ksql.setLength(0);
        ksql.append(" Insert Into ").append(this.T_NCM_BalanceEntry).append(" \n");
        ksql.append("       (FID,FParentID,FCostItemID,FBoPWIPAmount,FBopWIPQty,FPrice) \n");
        ksql.append(" select FID,FParentID,FCostItemID,FBoPWIPAmount,FBopWIPQty,FPrice \n");
        ksql.append(" From ").append(T_NCM_AllBalanceEntry).append(" balaEntry \n");
        ksql.append(" Where exists (Select 1 From ").append(this.getBalanceTable()).append(" bala \n");
        ksql.append("                  Where bala.FID = balaEntry.FParentID) \n");
        NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_BalanceEntry, (String)"FParentID ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_BalanceEntry, (String)"FCostItemID ASC", (boolean)false, (boolean)false);
        return this.T_NCM_BalanceEntry;
    }

    public String getBalanceMatDetailTable() throws EASBizException, BOSException {
        if (this.T_NCM_BalanceMatDetail != null) {
            return this.T_NCM_BalanceMatDetail;
        }
        StringBuffer ksql = new StringBuffer();
        ksql.setLength(0);
        ksql.append("create table T ( \n");
        ksql.append("    FID VARCHAR(44) NOT NULL, \n");
        ksql.append("    FParentID VARCHAR(44), \n");
        ksql.append("    FMaterialID VARCHAR(44), \n");
        ksql.append("    FBatchNo NVARCHAR(80), \n");
        ksql.append("    FUnitID VARCHAR(44), \n");
        ksql.append("    FQty NUMERIC(28,10), \n");
        ksql.append("    FAmount NUMERIC(28,10), \n");
        ksql.append("    FPrice NUMERIC(28,10) \n");
        ksql.append(") \n");
        this.T_NCM_BalanceMatDetail = NCMDbUtil.createTempTableByPool((TempTablePool)this.pool, (String)ksql.toString());
        String T_NCM_AllBalanceMatDetail = this.calcParam.GetTBL_BalanceMatDetail();
        ksql.setLength(0);
        ksql.append(" Insert Into ").append(this.T_NCM_BalanceMatDetail).append(" \n");
        ksql.append("       (FID,FParentID,FMaterialID,FBatchNo,FUnitID,FQty,FAmount,FPrice) \n");
        ksql.append(" select FID,FParentID,FMaterialID,isnull(FBatchNo,' '),FUnitID,FQty,FAmount,FPrice \n");
        ksql.append(" From ").append(T_NCM_AllBalanceMatDetail).append(" mat \n");
        ksql.append(" Where exists (Select 1 From ").append(this.getBalanceEntryTable()).append(" entry \n");
        ksql.append("                  Where entry.FID = mat.FParentID) \n");
        NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_BalanceMatDetail, (String)"FParentID ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_BalanceMatDetail, (String)"FMaterialID ASC,FBatchNo ASC", (boolean)false, (boolean)false);
        return this.T_NCM_BalanceMatDetail;
    }

    public String getCostCalResultTable() throws EASBizException, BOSException {
        if (this.T_NCM_CostCalResult != null) {
            return this.T_NCM_CostCalResult;
        }
        StringBuffer ksql = new StringBuffer();
        ksql.setLength(0);
        ksql.append("create table T ( \n");
        ksql.append("    FID VARCHAR(44) NOT NULL, \n");
        ksql.append("    FCostCenterID VARCHAR(44), \n");
        ksql.append("    FCostObjectID VARCHAR(44), \n");
        ksql.append("    FCostItemID VARCHAR(44), \n");
        ksql.append("    FFinishedAmount NUMERIC(17,4), \n");
        ksql.append("    FFinishedQty NUMERIC(21,8) DEFAULT 0, \n");
        ksql.append("    FCalcLevel INT \n");
        ksql.append(") \n");
        this.T_NCM_CostCalResult = NCMDbUtil.createTempTableByPool((TempTablePool)this.pool, (String)ksql.toString());
        String T_NCM_AllCostCalResult = this.calcParam.GetTBL_CostCalResult();
        String T_NCM_CostObjectRange = this.calcParam.GetTempTBL_CostObjList();
        ksql.setLength(0);
        ksql.append(" Insert Into ").append(this.T_NCM_CostCalResult).append(" \n");
        ksql.append("       (FID,FCostCenterID,FCostObjectID,FCostItemID,FFinishedAmount,FFinishedQty,FCalcLevel) \n");
        ksql.append(" select FID,FCostCenterID,FCostObjectID,FCostItemID,FFinishedAmount,FFinishedQty,FCalcLevel \n");
        ksql.append(" From ").append(T_NCM_AllCostCalResult).append(" cal \n");
        ksql.append(" Where exists (Select 1 From ").append(T_NCM_CostObjectRange).append(" co \n");
        ksql.append("                  Where co.FCostObjectID = cal.FCostObjectID) \n");
        NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_CostCalResult, (String)"FCostCenterID ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_CostCalResult, (String)"FCostObjectID ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_CostCalResult, (String)"FCostItemID ASC", (boolean)false, (boolean)false);
        return this.T_NCM_CostCalResult;
    }

    public String getCostCalMatDetailResultTable() throws EASBizException, BOSException {
        if (this.T_NCM_CostCalMatDetailResult != null) {
            return this.T_NCM_CostCalMatDetailResult;
        }
        StringBuffer ksql = new StringBuffer();
        ksql.setLength(0);
        ksql.append("create table T ( \n");
        ksql.append("    FID VARCHAR(44) NOT NULL, \n");
        ksql.append("    FCostCenterID VARCHAR(44), \n");
        ksql.append("    FCostObjectID VARCHAR(44), \n");
        ksql.append("    FCostItemID VARCHAR(44), \n");
        ksql.append("    FMaterialID VARCHAR(44), \n");
        ksql.append("    FLot NVARCHAR(80), \n");
        ksql.append("    FFinishedQty NUMERIC(21,8), \n");
        ksql.append("    FFinishedAmount NUMERIC(17,4), \n");
        ksql.append("    FEoPWIPQty NUMERIC(21,8), \n");
        ksql.append("    FEoPWIPAmount NUMERIC(17,4), \n");
        ksql.append("    FCalcLevel INT \n");
        ksql.append(") \n");
        this.T_NCM_CostCalMatDetailResult = NCMDbUtil.createTempTableByPool((TempTablePool)this.pool, (String)ksql.toString());
        String T_NCM_AllCostCalMatDetailResult = this.calcParam.GetTBL_CostCalMatDetailResult();
        String T_NCM_CostObjectRange = this.calcParam.GetTempTBL_CostObjList();
        ksql.setLength(0);
        ksql.append(" Insert Into ").append(this.T_NCM_CostCalMatDetailResult).append(" \n");
        ksql.append("       (FID,FCostCenterID,FCostObjectID,FCostItemID,FMaterialID,FLot,FFinishedAmount,FFinishedQty,FEoPWIPQty,FEoPWIPAmount,FCalcLevel) \n");
        ksql.append(" select FID,FCostCenterID,FCostObjectID,FCostItemID,FMaterialID,isnull(FLot,' '),FFinishedAmount,FFinishedQty,FEoPWIPQty,FEoPWIPAmount,FCalcLevel \n");
        ksql.append(" From ").append(T_NCM_AllCostCalMatDetailResult).append(" cal \n");
        ksql.append(" Where exists (Select 1 From ").append(T_NCM_CostObjectRange).append(" co \n");
        ksql.append("                  Where co.FCostObjectID = cal.FCostObjectID) \n");
        ksql.append(" And cal.FCalcLevel >= ").append(this.calcParam.rank).append(" \n");
        NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_CostCalMatDetailResult, (String)"FCostCenterID ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_CostCalMatDetailResult, (String)"FCostObjectID ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_CostCalMatDetailResult, (String)"FMaterialID ASC", (boolean)false, (boolean)false);
        return this.T_NCM_CostCalMatDetailResult;
    }

    public String getCostCalPrdResultTable() throws EASBizException, BOSException {
        if (this.T_NCM_CostCalPrdResult != null) {
            return this.T_NCM_CostCalPrdResult;
        }
        StringBuffer ksql = new StringBuffer();
        ksql.setLength(0);
        ksql.append("create table T ( \n");
        ksql.append("    FID VARCHAR(44) NOT NULL, \n");
        ksql.append("    FCostCenterID VARCHAR(44), \n");
        ksql.append("    FCostObjectID VARCHAR(44), \n");
        ksql.append("    FCostItemID VARCHAR(44), \n");
        ksql.append("    FProductID VARCHAR(44), \n");
        ksql.append("    FLot NVARCHAR(80), \n");
        ksql.append("    FFinishedQty NUMERIC(21,8), \n");
        ksql.append("    FFinishedAmount NUMERIC(17,4), \n");
        ksql.append("    FFinishedPrice NUMERIC(21,8), \n");
        ksql.append("    FCalcLevel INT \n");
        ksql.append(") \n");
        this.T_NCM_CostCalPrdResult = NCMDbUtil.createTempTableByPool((TempTablePool)this.pool, (String)ksql.toString());
        String T_NCM_AllCostCalPrdResult = this.calcParam.GetTBL_CostCalPrdDetailResult();
        String T_NCM_CostObjectRange = this.calcParam.GetTempTBL_CostObjList();
        ksql.setLength(0);
        ksql.append(" Insert Into ").append(this.T_NCM_CostCalPrdResult).append(" \n");
        ksql.append("       (FID,FCostCenterID,FCostObjectID,FCostItemID,FProductID,FLot,FFinishedAmount,FFinishedQty,FFinishedPrice,FCalcLevel) \n");
        ksql.append(" select FID,FCostCenterID,FCostObjectID,FCostItemID,FProductID,isnull(FLot,' '),FFinishedAmount,FFinishedQty,FFinishedPrice,FCalcLevel \n");
        ksql.append(" From ").append(T_NCM_AllCostCalPrdResult).append(" cal \n");
        ksql.append(" Where exists (Select 1 From ").append(T_NCM_CostObjectRange).append(" co \n");
        ksql.append("                  Where co.FCostObjectID = cal.FCostObjectID) \n");
        NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_CostCalPrdResult, (String)"FCostCenterID ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_CostCalPrdResult, (String)"FCostObjectID ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_CostCalPrdResult, (String)"FProductID ASC", (boolean)false, (boolean)false);
        return this.T_NCM_CostCalPrdResult;
    }

    public String getBopWIPCoefTable() throws EASBizException, BOSException {
        if (this.T_NCM_BopWIPCoef != null) {
            return this.T_NCM_BopWIPCoef;
        }
        StringBuffer ksql = new StringBuffer();
        if (this.calcParam.recoveryModel.getValue().compareTo("0") == 0) {
            ksql.setLength(0);
            ksql.append("create table T ( \n");
            ksql.append("    FID VARCHAR(44) NOT NULL, \n");
            ksql.append("    FCalculatePeriodID VARCHAR(44), \n");
            ksql.append("    FCostObjectID VARCHAR(44), \n");
            ksql.append("    FProductID VARCHAR(44), \n");
            ksql.append("    FProdBatchNo NVARCHAR(80), \n");
            ksql.append("    FCostItemID VARCHAR(44), \n");
            ksql.append("    FMaterialID VARCHAR(44), \n");
            ksql.append("    FMatBatchNo NVARCHAR(80), \n");
            ksql.append("    FSubCostItemID VARCHAR(44), \n");
            ksql.append("    FSubCostObjID VARCHAR(44), \n");
            ksql.append("    FSubProductID VARCHAR(44), \n");
            ksql.append("    FSubProdBatchNo NVARCHAR(80), \n");
            ksql.append("    FAmtCoef NUMERIC(24,12) DEFAULT 0, \n");
            ksql.append("    FQtyCoef NUMERIC(24,12) DEFAULT 0 \n");
            ksql.append(") \n");
        } else {
            ksql.setLength(0);
            ksql.append("create table T ( \n");
            ksql.append("    FID VARCHAR(44) NOT NULL, \n");
            ksql.append("    FCalculatePeriodID VARCHAR(44), \n");
            ksql.append("    FCostObjectID VARCHAR(44), \n");
            ksql.append("    FProductID VARCHAR(44), \n");
            ksql.append("    FProdBatchNo NVARCHAR(80), \n");
            ksql.append("    FCostItemID VARCHAR(44), \n");
            ksql.append("    FMaterialID VARCHAR(44), \n");
            ksql.append("    FMatBatchNo NVARCHAR(80), \n");
            ksql.append("    FSubCostItemID VARCHAR(44), \n");
            ksql.append("    FSubCostObjID VARCHAR(44), \n");
            ksql.append("    FSubProductID VARCHAR(44), \n");
            ksql.append("    FSubProdBatchNo NVARCHAR(80), \n");
            ksql.append("    FAmtCoef NUMERIC(24,12) DEFAULT 0, \n");
            ksql.append("    FQtyCoef NUMERIC(24,12) DEFAULT 0, \n");
            ksql.append("    FLayer smallint DEFAULT 0, \n");
            ksql.append("    FDispLayer smallint DEFAULT 0, \n");
            ksql.append("    FIsLeaf smallint DEFAULT 0,\n");
            ksql.append("    FBranch varchar(1020) NOT NULL DEFAULT (' ') \n");
            ksql.append(") \n");
        }
        this.T_NCM_BopWIPCoef = NCMDbUtil.createTempTableByPool((TempTablePool)this.pool, (String)ksql.toString());
        String T_NCM_ALLBopWIPCoef = this.calcParam.GetTBL_BopWIPCoef();
        String T_NCM_CostObjectRange = this.calcParam.GetTempTBL_CostObjList();
        if (this.calcParam.recoveryModel.getValue().compareTo("0") == 0) {
            ksql.setLength(0);
            ksql.append(" Insert Into ").append(this.T_NCM_BopWIPCoef).append(" \n");
            ksql.append("       (FID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo, \n");
            ksql.append("        FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo,FAmtCoef,FQtyCoef) \n");
            ksql.append(" select FID,FCalculatePeriodID,FCostObjectID,FProductID,isnull(FProdBatchNo,' '),FCostItemID,FMaterialID,isnull(FMatBatchNo,' '), \n");
            ksql.append("        FSubCostItemID,FSubCostObjID,FSubProductID,isnull(FSubProdBatchNo,' '),FAmtCoef,FQtyCoef \n");
            ksql.append(" From ").append(T_NCM_ALLBopWIPCoef).append(" cal \n");
            ksql.append(" Where exists (Select 1 From ").append(T_NCM_CostObjectRange).append(" co \n");
            ksql.append("                  Where co.FCostObjectID = cal.FCostObjectID) \n");
            ksql.append("       AND cal.FCalculatePeriodID = '").append(this.calcParam.prePeriodId).append("' \n");
            NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append(" Insert Into ").append(this.T_NCM_BopWIPCoef).append(" \n");
            ksql.append("       (FID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo, \n");
            ksql.append("        FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo,FAmtCoef,FQtyCoef) \n");
            ksql.append(" select FID,FCalculatePeriodID,FCostObjectID,FProductID,isnull(FProdBatchNo,' '),FCostItemID,FMaterialID,isnull(FMatBatchNo,' '), \n");
            ksql.append("        FSubCostItemID,FSubCostObjID,FSubProductID,isnull(FSubProdBatchNo,' '),FAmtCoef,FQtyCoef \n");
            ksql.append(" From ").append(T_NCM_ALLBopWIPCoef).append(" cal \n");
            ksql.append(" Where exists (Select 1 From ").append(this.calcParam.GetTBL_CostCalResult()).append(" co \n");
            ksql.append("                  Where co.FCostObjectID = cal.FCostObjectID \n");
            ksql.append("                   AND co.FCalcLevel >= ").append(this.calcParam.rank).append(" + 1) \n");
            NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        } else {
            ksql.setLength(0);
            ksql.append(" Insert Into ").append(this.T_NCM_BopWIPCoef).append(" \n");
            ksql.append("       (FID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo, \n");
            ksql.append("        FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo,FAmtCoef,FQtyCoef,FLayer,FDispLayer,FIsLeaf,FBranch) \n");
            ksql.append(" select FID,FCalculatePeriodID,FCostObjectID,FProductID,isnull(FProdBatchNo,' '),FCostItemID,FMaterialID,isnull(FMatBatchNo,' '), \n");
            ksql.append("        FSubCostItemID,FSubCostObjID,FSubProductID,isnull(FSubProdBatchNo,' '),FAmtCoef,FQtyCoef,FLayer,FDispLayer,FIsLeaf,FBranch \n");
            ksql.append(" From ").append(T_NCM_ALLBopWIPCoef).append(" cal \n");
            ksql.append(" Where exists (Select 1 From ").append(T_NCM_CostObjectRange).append(" co \n");
            ksql.append("                  Where co.FCostObjectID = cal.FCostObjectID) \n");
            NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append(" Insert Into ").append(this.T_NCM_BopWIPCoef).append(" \n");
            ksql.append("       (FID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo, \n");
            ksql.append("        FSubCostItemID,FSubCostObjID,FSubProductID,FSubProdBatchNo,FAmtCoef,FQtyCoef,FLayer,FDispLayer,FIsLeaf,FBranch) \n");
            ksql.append(" select FID,FCalculatePeriodID,FCostObjectID,FProductID,isnull(FProdBatchNo,' '),FCostItemID,FMaterialID,isnull(FMatBatchNo,' '), \n");
            ksql.append("        FSubCostItemID,FSubCostObjID,FSubProductID,isnull(FSubProdBatchNo,' '),FAmtCoef,FQtyCoef,FLayer,FDispLayer,FIsLeaf,FBranch \n");
            ksql.append(" From ").append(T_NCM_ALLBopWIPCoef).append(" cal \n");
            ksql.append(" Where exists (Select 1 From ").append(this.calcParam.GetTBL_CostCalMatDetailResult()).append(" mat \n");
            ksql.append("                  Where mat.FMaterialID = cal.FProductID )\n");
            ksql.append(" and not exists (select 1 from ").append(this.T_NCM_BopWIPCoef).append(" a where a.fcostobjectid = cal.fcostobjectid)");
            NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        }
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_BopWIPCoef, (String)"FCostObjectID ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_BopWIPCoef, (String)"FProductID ASC, FProdBatchNo ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_BopWIPCoef, (String)"FSubCostObjID ASC,FSubProductID ASC, FSubProdBatchNo ASC,FSubCostItemID ASC", (boolean)false, (boolean)false);
        return this.T_NCM_BopWIPCoef;
    }

    public String getBopInvCoefTable() throws EASBizException, BOSException {
        if (this.T_NCM_BopInvCoef != null) {
            return this.T_NCM_BopInvCoef;
        }
        StringBuffer ksql = new StringBuffer();
        if (this.calcParam.recoveryModel.getValue().compareTo("0") == 0) {
            ksql.setLength(0);
            ksql.append("create table T ( \n");
            ksql.append("    FID VARCHAR(44) NOT NULL, \n");
            ksql.append("    FCalculatePeriodID VARCHAR(44), \n");
            ksql.append("    FCostObjectID VARCHAR(44), \n");
            ksql.append("    FProductID VARCHAR(44), \n");
            ksql.append("    FProdBatchNo NVARCHAR(80), \n");
            ksql.append("    FCostItemID VARCHAR(44), \n");
            ksql.append("    FMaterialID VARCHAR(44), \n");
            ksql.append("    FMatBatchNo NVARCHAR(80), \n");
            ksql.append("    FAmtCoef NUMERIC(24,12) DEFAULT 0, \n");
            ksql.append("    FQtyCoef NUMERIC(24,12) DEFAULT 0 \n");
            ksql.append(") \n");
        } else {
            ksql.setLength(0);
            ksql.append("create table T ( \n");
            ksql.append("    FID VARCHAR(44) NOT NULL, \n");
            ksql.append("    FCalculatePeriodID VARCHAR(44), \n");
            ksql.append("    FCostObjectID VARCHAR(44), \n");
            ksql.append("    FProductID VARCHAR(44), \n");
            ksql.append("    FProdBatchNo NVARCHAR(80), \n");
            ksql.append("    FCostItemID VARCHAR(44), \n");
            ksql.append("    FMaterialID VARCHAR(44), \n");
            ksql.append("    FMatBatchNo NVARCHAR(80), \n");
            ksql.append("    FAmtCoef NUMERIC(24,12) DEFAULT 0, \n");
            ksql.append("    FQtyCoef NUMERIC(24,12) DEFAULT 0, \n");
            ksql.append("    FLayer smallint DEFAULT 0, \n");
            ksql.append("    FDispLayer smallint DEFAULT 0, \n");
            ksql.append("    FIsLeaf smallint DEFAULT 0,\n");
            ksql.append("    FBranch varchar(1020) NOT NULL DEFAULT (' ') \n");
            ksql.append(") \n");
        }
        this.T_NCM_BopInvCoef = NCMDbUtil.createTempTableByPool((TempTablePool)this.pool, (String)ksql.toString());
        String T_NCM_ALLBopInvCoef = this.calcParam.GetTBL_BopInvCoef();
        String T_NCM_CostObjectRange = this.calcParam.GetTempTBL_CostObjList();
        if (this.calcParam.recoveryModel.getValue().compareTo("0") == 0) {
            ksql.setLength(0);
            ksql.append(" Insert Into ").append(this.T_NCM_BopInvCoef).append(" \n");
            ksql.append("        (FID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo, \n");
            ksql.append("        FAmtCoef,FQtyCoef) \n");
            ksql.append(" select FID,FCalculatePeriodID,FCostObjectID,FProductID,isnull(FProdBatchNo,' '),FCostItemID,FMaterialID,isnull(FMatBatchNo,' '), \n");
            ksql.append("        FAmtCoef,FQtyCoef \n");
            ksql.append(" From ").append(T_NCM_ALLBopInvCoef).append(" cal \n");
            ksql.append(" Where exists (Select 1 From ").append(T_NCM_CostObjectRange).append(" co \n");
            ksql.append("                  Where co.FCostObjectID = cal.FCostObjectID) \n");
            ksql.append("       AND cal.FCalculatePeriodID = '").append(this.calcParam.prePeriodId).append("' \n");
            NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        } else {
            ksql.setLength(0);
            ksql.append(" Insert Into ").append(this.T_NCM_BopInvCoef).append(" \n");
            ksql.append("       (FID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo, \n");
            ksql.append("        FAmtCoef,FQtyCoef,FLayer,FDispLayer,FIsLeaf,FBranch) \n");
            ksql.append(" select FID,FCalculatePeriodID,FCostObjectID,FProductID,isnull(FProdBatchNo,' '),FCostItemID,FMaterialID,isnull(FMatBatchNo,' '), \n");
            ksql.append("        FAmtCoef,FQtyCoef,FLayer,FDispLayer,FIsLeaf,FBranch \n");
            ksql.append(" From ").append(T_NCM_ALLBopInvCoef).append(" cal \n");
            ksql.append(" Where exists (Select 1 From ").append(T_NCM_CostObjectRange).append(" co \n");
            ksql.append("                  Where co.FCostObjectID = cal.FCostObjectID) \n");
            ksql.append("       AND cal.FCalculatePeriodID = '").append(this.calcParam.prePeriodId).append("' \n");
            NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append(" Insert Into ").append(this.T_NCM_BopInvCoef).append(" \n");
            ksql.append("       (FID,FCalculatePeriodID,FCostObjectID,FProductID,FProdBatchNo,FCostItemID,FMaterialID,FMatBatchNo, \n");
            ksql.append("        FAmtCoef,FQtyCoef,FLayer,FDispLayer,FIsLeaf,FBranch) \n");
            ksql.append(" select FID,FCalculatePeriodID,FCostObjectID,FProductID,isnull(FProdBatchNo,' '),FCostItemID,FMaterialID,isnull(FMatBatchNo,' '), \n");
            ksql.append("        FAmtCoef,FQtyCoef,FLayer,FDispLayer,FIsLeaf,FBranch \n");
            ksql.append(" From ").append(T_NCM_ALLBopInvCoef).append(" cal \n");
            ksql.append(" Where exists (Select 1 From ").append(this.calcParam.GetTBL_CostCalMatDetailResult()).append(" mat \n");
            ksql.append("                  Where mat.FMaterialID = cal.FProductID )\n");
            ksql.append("  and not exists (Select 2 from ").append(this.T_NCM_BopInvCoef).append(" coef where cal.FCalculatePeriodID = coef.FCalculatePeriodID \n");
            ksql.append("  and cal.FCostObjectID = coef.FCostObjectID ) \n");
            NCMDbUtil.execute((Context)this.ctx, (String)ksql.toString());
        }
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_BopInvCoef, (String)"FCostObjectID ASC", (boolean)false, (boolean)false);
        NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_BopInvCoef, (String)"FProductID ASC, FProdBatchNo ASC", (boolean)false, (boolean)false);
        if (this.calcParam.recoveryModel.getValue().compareTo("0") == 1) {
            NCMDbUtil.createTempTableIndexByPool((TempTablePool)this.pool, (String)this.T_NCM_BopInvCoef, (String)"FBranch ASC", (boolean)false, (boolean)false);
        }
        return this.T_NCM_BopInvCoef;
    }

    public void initData() throws EASBizException, BOSException {
        this.getBalanceTable();
        this.getBalanceEntryTable();
        this.getBalanceMatDetailTable();
        this.getCostCalResultTable();
        this.getCostCalMatDetailResultTable();
        this.getCostCalPrdResultTable();
        this.getBopWIPCoefTable();
        this.getBopInvCoefTable();
    }
}

