/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.Map;

public class AllocStdSetByClassChecker
extends CMCalChecker {
    public static final String STFSOURCE_PATH = "com.kingdee.eas.ncm.cal.client.CheckResource";
    private static final char CLF = '\n';

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        CalCostCheckItemCheckResultCollection rc = new CalCostCheckItemCheckResultCollection();
        this.checkTable(param, rc);
        return rc;
    }

    private void checkTable(Map param, CalCostCheckItemCheckResultCollection rc) throws BOSException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        String locLan = ctx.getLocale().toString();
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        try {
            String T_TMP_FinishedQty = costDataCache.getFinishedQtyTable();
            StringBuffer ksql = new StringBuffer();
            ksql.append("SELECT top 100 \n");
            ksql.append("    OBJ.FNumber FCOnumber, OBJ.FName_" + locLan + " FCOName \n");
            ksql.append("FROM ( ").append('\n');
            ksql.append("     SELECT FCostObjectID ").append('\n');
            ksql.append("     FROM " + T_TMP_FinishedQty + " t \n");
            ksql.append("     Inner JOIN  T_BD_CostObject CO ON  CO.FID = t.FCostObjectID ").append('\n');
            ksql.append("     WHERE CO.FCalculateMode = 3 \n");
            ksql.append("        AND CO.FIsForbiden = 0 \n");
            ksql.append("     GROUP BY t.FCostObjectID \n");
            ksql.append("     HAVING SUM(t.FQty) <>0 \n");
            ksql.append(") a").append('\n');
            ksql.append("join T_BD_CostObject OBJ on OBJ.FID = a.FCostObjectID ").append('\n');
            ksql.append("where NOT EXISTS (").append('\n');
            ksql.append("    Select 1").append('\n');
            ksql.append("\t FROM T_NCM_AllocStdSetByCLASS cls ").append('\n');
            ksql.append("\t WHERE cls.FCompanyID = '").append(companyId).append("' ").append('\n');
            ksql.append("\t     AND cls.FCalculatePeriodID = '").append(periodId).append("' ").append('\n');
            ksql.append("\t     AND cls.FAllocStdID is not null ").append('\n');
            ksql.append("\t     AND cls.FCostObjectID = OBJ.FID ").append('\n');
            ksql.append(")").append('\n');
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            while (rs.next()) {
                String coNumber = rs.getString("FCOnumber");
                String coName = rs.getString("FCOName");
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(CalSeverUtils.getNcmCheckResource(ctx, "AllocStdSetByClassChecker_desc"), coNumber, coName));
                rinfo.setReason(CalSeverUtils.getNcmCheckResource(ctx, "AllocStdSetByClassChecker_reason"));
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "AllocStdSetByClassChecker_SO"));
                rc.add(rinfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

