/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.AllocStdSetModeByWIPEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AllocStdSetByPrdChecker
extends CMCalChecker {
    private static Logger logger = Logger.getLogger((String)AllocStdSetByPrdChecker.class.getName());
    private static final char CLF = '\n';
    private CalCostCheckItemCheckResultCollection rc;

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        AllocStdSetModeByWIPEnum theSetMode = NCMUtils.getAllocStdSetModeByWIP((Context)ctx, (String)companyId);
        this.rc = new CalCostCheckItemCheckResultCollection();
        if (theSetMode == AllocStdSetModeByWIPEnum.CostItem) {
            this.checktable_CostItem(ctx, companyId, periodId);
        } else if (theSetMode == AllocStdSetModeByWIPEnum.CostItemAndCostCenter) {
            this.checktable_CostItemCenter(ctx, companyId, periodId);
        } else {
            this.checktable(param);
        }
        this.checktable_EquivalentCoef(ctx, companyId, periodId);
        return this.rc;
    }

    private void checktable(Map param) throws BOSException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        StringBuffer sql = new StringBuffer();
        String locLan = ctx.getLocale().toString();
        String tempTable = null;
        IRowSet rs = null;
        try {
            String T_TMP_InputQty = costDataCache.getInputQtyTable();
            sql.append("create table T ( \n");
            sql.append("    FCostObjectID varchar(44) \n");
            sql.append(") \n");
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            sql.setLength(0);
            sql.append("insert into " + tempTable + " ( \n");
            sql.append("    FCostObjectID \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    FCostObjectID \n");
            sql.append("from " + T_TMP_InputQty + " \n");
            sql.append("group by FCostObjectID \n");
            sql.append("having sum(FQty) <> 0 \n");
            sql.append("; \n");
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("SELECT DISTINCT top 100 \n");
            sql.append("    O.FNumber, O.FName_" + locLan + " As FName \n");
            sql.append("FROM " + tempTable + " t \n");
            sql.append("JOIN T_BD_CostObject O \n");
            sql.append("    on O.FID = t.FCostObjectID ").append('\n');
            sql.append("WHERE O.FRelatedType = 0 AND O.FCompanyID='").append(companyId).append("'").append('\n');
            sql.append("and ( ");
            sql.append("    NOT EXISTS (").append('\n');
            sql.append("\t    select 1 from T_NCM_AllocStdSetByWIP WIP ").append('\n');
            sql.append("\t    where WIP.FCompanyID='").append(companyId).append("' ").append('\n');
            sql.append("\t    AND WIP.FCalculatePeriodID='").append(periodId).append("' ").append('\n');
            sql.append("\t    and WIP.FCostObjectID=O.FID \n").append('\n');
            sql.append("\t) ").append('\n');
            sql.append("\tor ").append('\n');
            sql.append("\tEXISTS ( ").append('\n');
            sql.append("\t    select 1 from T_NCM_AllocStdSetByWIP WIP ").append('\n');
            sql.append("\t    where WIP.FCompanyID='").append(companyId).append("' ").append('\n');
            sql.append("\t    AND WIP.FCalculatePeriodID='").append(periodId).append("' ").append('\n');
            sql.append("\t    and WIP.FCostObjectID=O.FID and WIP.FAllocStdID is null \n").append('\n');
            sql.append("\t) ").append('\n');
            sql.append(") ");
            sql.setLength(0);
            sql.append("SELECT top 100 \n");
            sql.append("    O.FNumber, O.FName_" + locLan + " As FName \n");
            sql.append("from ( \n");
            sql.append("    SELECT DISTINCT t.FCostObjectID \n");
            sql.append("    FROM " + tempTable + " t \n");
            sql.append("    left join T_NCM_AllocStdSetByWIP WIP ").append('\n');
            sql.append("    on WIP.FCompanyID='").append(companyId).append("' ").append('\n');
            sql.append("    AND WIP.FCalculatePeriodID='").append(periodId).append("' ").append('\n');
            sql.append("    and WIP.FCostObjectID=t.FCostObjectID \n").append('\n');
            sql.append("    where (WIP.FID is null or WIP.FAllocStdID is null) \n").append('\n');
            sql.append(") a \n").append('\n');
            sql.append("join T_BD_CostObject o on o.FID = a.FCostObjectID \n").append('\n');
            String descrip = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrDescription_AllocStdSetByPrdChecker");
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FName") + "(" + rs.getString("FNumber") + ")"));
                rinfo.setReason(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrReason_AllocStdSetByPrdChecker"));
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrSuggest_AllocStdSetByPrdChecker"));
                this.rc.add(rinfo);
            }
        }
        catch (Exception ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                if (tempTable != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        if (tempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
    }

    private void checktable_CostItem(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException {
        CtrlUnitInfo CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT I.FNumber,I.FName_" + locale + " As FName ").append('\n');
        sql.append("FROM T_NCM_CostItem I ").append('\n');
        sql.append("WHERE ( ").append('\n');
        sql.append("    I.FAdminCUID = '" + CU.getId().toString() + "'").append('\n');
        sql.append("    OR I.FID IN ( ").append('\n');
        sql.append("        SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '548C5A91' ").append('\n');
        sql.append("        AND FAssignCUID = '" + CU.getId().toString() + "' ").append('\n');
        sql.append("    ) ").append('\n');
        sql.append(")").append('\n');
        sql.append("and ( ");
        sql.append("    NOT EXISTS (").append('\n');
        sql.append("\t    select 1 from T_NCM_AllocStdSetByWIP WIP ").append('\n');
        sql.append("\t    where WIP.FCompanyID='").append(CompanyOrgID).append("' ").append('\n');
        sql.append("\t    AND WIP.FCalculatePeriodID='").append(PeriodId).append("' ").append('\n');
        sql.append("\t    and WIP.FCostItemID=I.FID and WIP.FCostObjectID is null and WIP.FCostCenterID is null \n").append('\n');
        sql.append("\t) ").append('\n');
        sql.append("\tor ").append('\n');
        sql.append("\tEXISTS ( ").append('\n');
        sql.append("\t    select 1 from T_NCM_AllocStdSetByWIP WIP ").append('\n');
        sql.append("\t    where WIP.FCompanyID='").append(CompanyOrgID).append("' ").append('\n');
        sql.append("\t    AND WIP.FCalculatePeriodID='").append(PeriodId).append("' ").append('\n');
        sql.append("\t    and WIP.FCostItemID=I.FID and WIP.FCostObjectID is null and WIP.FCostCenterID is null and WIP.FAllocStdID is null \n").append('\n');
        sql.append("\t) ").append('\n');
        sql.append(") ");
        IRowSet rs = null;
        String descrip = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrDescription_AllocStdSetByPrdChecker_Item");
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FName") + "(" + rs.getString("FNumber") + ")"));
                rinfo.setReason(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrReason_AllocStdSetByPrdChecker_Item"));
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrSuggest_AllocStdSetByPrdChecker_Item"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private void checktable_CostItemCenter(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException {
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        CtrlUnitInfo CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT I.FNumber As FCostItemNumber, I.FName_" + locale + " As FCostItemName, ").append('\n');
        sql.append("\tC.FNumber As FCostCenterNumber, C.FName_" + locale + " As FCostCenterName ").append('\n');
        sql.append("FROM (T_NCM_CostItem I ").append("INNER JOIN T_ORG_CtrlUnit CU ON I.FAdminCUID = CU.FID) ").append("CROSS JOIN T_ORG_CostCenter C ").append("WHERE (CU.FID ='").append(CU.getId().toString()).append("' OR I.FID in (").append("\tSELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '548C5A91' AND FAssignCUID = '").append(CU.getId().toString()).append("')").append(" )").append(" AND EXISTS(").append("\tSelect 1 ").append("\tFROM T_ORG_CostCenter CC ").append("\tINNER JOIN T_ORG_UnitRelation UR ON CC.FID=UR.FfromUnitID ").append("\tINNER JOIN T_ORG_TypeRelation TR ON TR.FID=UR.FTypeRelationID ").append("\tWHERE TR.FFromType=5 AND TR.FToType=1 AND UR.FToUnitID='").append(CompanyOrgID).append("'").append("\t\tAND CC.FIsBizUnit=1 AND CC.FCostCenterType=0 AND CC.FID=C.FID AND CC.FisSealUp=0 ").append("\t)").append(" AND (").append("\tNOT EXISTS(").append("\t\tSELECT 1").append("\t\tFROM T_NCM_AllocStdSetByWIP D").append("\t\tWHERE D.FCompanyID='").append(CompanyOrgID).append("' AND D.FCalculatePeriodID='").append(PeriodId).append("' AND D.FCostCenterID=C.FID AND D.FCostItemID=I.FID").append("\t)").append("\tOr").append("\tEXISTS(").append("\t\tSELECT 1").append("\t\tFROM T_NCM_AllocStdSetByWIP D").append("\t\tWHERE D.FCompanyID='").append(CompanyOrgID).append("' AND D.FCalculatePeriodID='").append(PeriodId).append("' AND D.FCostCenterID=C.FID AND D.FCostItemID=I.FID ").append("\t\t\tand D.FAllocStdID is null ").append("\t)").append(")");
        IRowSet rs = null;
        String descrip = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrDescription_AllocStdSetByPrdChecker_CC");
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FCostItemName") + "(" + rs.getString("FCostItemNumber") + ")", rs.getString("FCostCenterName") + "(" + rs.getString("FCostCenterNumber") + ")"));
                rinfo.setReason(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrReason_AllocStdSetByPrdChecker_CC"));
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrSuggest_AllocStdSetByPrdChecker_CC"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private void checktable_EquivalentCoef(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException {
        String tblBalance = null;
        try {
            tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)CompanyOrgID, (String)"T_NCM_Balance");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select top 51 * from ( ").append('\n').append("select distinct ").append('\n').append("cc.FNumber as FCCNumber, cc.FName_" + locale + " as FCCName, ").append('\n').append("co.FNumber as FCONumber, co.FName_" + locale + " as FCOName ").append('\n').append("from (").append('\n').append("\tselect ib.FCostCenterOrgUnitID as FCostCenterID, ibe.FCostObjectID as FCostObjectID ").append('\n').append("\tfrom T_NCM_InputQtyBill ib ").append('\n').append("\tleft join T_NCM_InputQtyBillEntry ibe on ibe.FParentID = ib.FID ").append('\n').append("\twhere ib.FBillStatus = 4 ").append('\n').append("\tand ib.FCompanyOrg = '" + CompanyOrgID + "' ").append('\n').append("\tand ib.FCalculatePeriod = '" + PeriodId + "' ").append('\n').append("\tgroup by ib.FCostCenterOrgUnitID, ibe.FCostObjectID ").append('\n').append("\thaving sum(ibe.FQty) <> 0 ").append('\n').append("\tunion ").append('\n').append("\tselect bb.FCostCenterID as FCostCenterID, bb.FCostObjectID as FCostObjectID ").append('\n').append("\tfrom " + tblBalance + " bb ").append('\n').append("\twhere bb.FCompanyOrg = '" + CompanyOrgID + "' ").append('\n').append("\tand bb.FCalculatePeriodID = '" + PeriodId + "' ").append('\n').append("\tgroup by bb.FCostCenterID, bb.FCostObjectID ").append('\n').append("\thaving sum(bb.FBopWIPQty) <> 0 ").append('\n').append(") qty ").append('\n').append("join T_NCM_AllocStdSetByWIP ass ").append('\n').append("on ass.FCostObjectID = qty.FCostObjectID ").append('\n').append("and ass.FCompanyID = '" + CompanyOrgID + "' ").append('\n').append("and ass.FCalculatePeriodID = '" + PeriodId + "' ").append('\n').append("left join T_NCM_EquiCoefIntegrated eci ").append('\n').append("on eci.FCostCenterID = qty.FCostCenterID ").append('\n').append("and eci.FCostObjectID = qty.FCostObjectID").append('\n').append("and eci.FCompanyID = '" + CompanyOrgID + "' ").append('\n').append("and eci.FCalculatePeriodID = '" + PeriodId + "'").append('\n').append("left join T_NCM_EquivalentCoef ec ").append('\n').append("on ec.FCostCenterID = qty.FCostCenterID ").append('\n').append("and ec.FCostObjectID = qty.FCostObjectID").append('\n').append("and ec.FCostItemID = ass.FCostItemID").append('\n').append("and ec.FCompanyID = '" + CompanyOrgID + "' ").append('\n').append("and ec.FCalculatePeriodID = '" + PeriodId + "'").append('\n').append("join T_ORG_CostCenter cc on cc.FID = qty.FCostCenterID").append('\n').append("join T_BD_CostObject co on co.FID = qty.FCostObjectID").append('\n').append("where ").append('\n').append("eci.FCostObjectID is null and ec.FCostItemID is null ").append('\n').append("and ").append('\n').append("ass.FAllocSTDID in (").append('\n').append("\tselect FID from T_NCM_AllocStd ").append('\n').append("\twhere FAllocStdType = 3 ").append('\n').append("\tand FFormulaforParse like '%d2T+lgEaEADgAAovwKgRj53UGuM=%' ").append('\n').append(")").append('\n').append(") as t ").append('\n').append("order by t.FCCName, t.FCOName ").append('\n');
        IRowSet rs = null;
        try {
            int count = 0;
            String desc = CalSeverUtils.getNcmCheckResource(ctx, "AllocStdSetByPrdChecker_EquivalentCoef_desc");
            String reason = CalSeverUtils.getNcmCheckResource(ctx, "AllocStdSetByPrdChecker_EquivalentCoef_reason");
            String suggest = CalSeverUtils.getNcmCheckResource(ctx, "AllocStdSetByPrdChecker_EquivalentCoef_suggest");
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                CalCostCheckItemCheckResultInfo rinfo;
                if (++count == 51) {
                    rinfo = new CalCostCheckItemCheckResultInfo();
                    String more = CalSeverUtils.getNcmCheckResource(ctx, "AllocStdSetByPrdChecker_EquivalentCoef_more");
                    rinfo.setDescription(more);
                    rinfo.setReason(more);
                    rinfo.setSuggestOperation(more);
                    break;
                }
                rinfo = new CalCostCheckItemCheckResultInfo();
                String cc = rs.getString("FCCName") + "[" + rs.getString("FCCNumber") + "]";
                String co = rs.getString("FCOName") + "[" + rs.getString("FCONumber") + "]";
                rinfo.setDescription(MessageFormat.format(desc, cc, co));
                rinfo.setReason(reason);
                rinfo.setSuggestOperation(suggest);
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

