/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.AllocStdSetModeByWIPEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class AllocWIPCountingChecker
extends CMCalChecker {
    private Logger logger = Logger.getLogger(AllocWIPCountingChecker.class);
    private static final char CLF = '\n';
    private CalCostCheckItemCheckResultCollection rc;
    AllocStdSetModeByWIPEnum setMode = null;

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        this.rc = new CalCostCheckItemCheckResultCollection();
        IRowSet rowset = null;
        try {
            boolean has = false;
            StringBuffer ksql = new StringBuffer();
            ksql.append("select top 1 1 \n");
            ksql.append("from T_NCM_WIPCountingMaterial \n");
            ksql.append("where FCompanyOrg = '").append(companyId).append("' \n");
            ksql.append("and FCalculatePeriod = '").append(periodId).append("' \n");
            rowset = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            has = rowset.next();
            rowset.close();
            if (!has) {
                CalCostCheckItemCheckResultCollection calCostCheckItemCheckResultCollection = this.rc;
                return calCostCheckItemCheckResultCollection;
            }
            ksql.setLength(0);
            ksql.append("select top 1 1 \n");
            ksql.append("from T_NCM_AllocStdSetByWIP \n");
            ksql.append("where FCompanyID = '").append(companyId).append("' \n");
            ksql.append("and FCalculatePeriodID = '").append(periodId).append("' \n");
            ksql.append("and FAllocStdID = '").append("xGHRiNoXTSCl3IYyA5xfENnqRL8=").append("' \n");
            rowset = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            has = rowset.next();
            if (!has) {
                CalCostCheckItemCheckResultCollection calCostCheckItemCheckResultCollection = this.rc;
                return calCostCheckItemCheckResultCollection;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (rowset != null) {
                    rowset.close();
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        this.setMode = NCMUtils.getAllocStdSetModeByWIP((Context)ctx, (String)companyId);
        if (this.isHavWipCountingConsumedMaterial(ctx, companyId, periodId)) {
            this.checkWIPCountingDataByCostCenter(ctx, companyId, periodId);
        } else {
            this.checkWIPCountingDataByCostObject(ctx, companyId, periodId);
        }
        return this.rc;
    }

    private void checkWIPCountingDataByCostCenter(Context ctx, String companyId, String periodId) throws BOSException {
        String tblWIPCounting = null;
        String tblInputData = null;
        try {
            tblWIPCounting = this.createtblWIPCounting(ctx);
            this.initTblWIPCountingByCostCenter(ctx, tblWIPCounting, companyId, periodId);
            tblInputData = this.createInputDataTbl(ctx);
            this.initTbltblInputDataByCostCenter(ctx, tblInputData, companyId, periodId);
            StringBuffer sb = new StringBuffer();
            boolean usingQtyOrAmount = NCMUtils.isQtyWipType((Context)ctx, (String)companyId);
            sb.append("select cc.FNumber as costCenterNumber, cc.FName_l2 as costCenterName, ").append("       mat.FNumber as materialNumber, mat.FName_l2 as materialName, ").append("       ci.FNumber as costItemNumber, ci.FName_l2 as costItemName, ").append('\n').append("       isnull(d.Flot, '') as Flot, ").append('\n').append("       ").append(usingQtyOrAmount ? "(CASE WHEN isnull(b.FQty, 0)>0 and isnull(b.FQty, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(b.FQty, 0))) \n ELSE CONVERT(VARCHAR, isnull(b.FQty, 0)) END) as wipData, \n(CASE WHEN isnull(d.FQty, 0)>0 and isnull(d.FQty, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(d.FQty, 0))) \n ELSE CONVERT(VARCHAR, isnull(d.FQty, 0)) END) as inputData " : "(CASE WHEN isnull(b.FAmount, 0)>0 and isnull(b.FAmount, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(b.FAmount, 0)))\n ELSE CONVERT(VARCHAR, isnull(b.FAmount, 0)) END) as wipData, \n(CASE WHEN isnull(d.FAmount, 0)>0 and isnull(d.FAmount, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(d.FAmount, 0))) \n ELSE CONVERT(VARCHAR, isnull(d.FAmount, 0)) END) as inputData ").append('\n').append("  from ").append(tblWIPCounting).append(" as b ").append('\n').append("  left outer join ").append(tblInputData).append(" as d ").append('\n').append("    on b.FCostCenterID=d.FCostCenterID  ").append('\n').append("   and b.FMaterialID=d.FMaterialID and isnull(b.FLot, ' ')=isnull(d.FLot, ' ') ").append('\n').append("   and b.FCostItemId=d.FCostItemId ").append('\n').append(" inner join t_org_costcenter cc on b.FCostCenterID=cc.FID").append('\n').append(" inner join t_bd_material mat on b.FMaterialID=mat.FID").append('\n').append(" inner join T_NCM_CostItem ci on b.FCostItemId=ci.FID").append('\n').append(" where ").append(usingQtyOrAmount ? "isnull(b.FQty, 0)>isnull(d.FQty, 0)" : "isnull(b.FAmount, 0)>isnull(d.FAmount, 0)").append('\n').append(" order by b.FCostCenterid, b.FMaterialID, b.FLot, b.FCostItemId");
            IRowSet _Data = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (_Data != null && _Data.size() > 0) {
                String error = null;
                String errorTemplet = usingQtyOrAmount ? CalculateUtil.getSrvCalResource(ctx, "AllocWIPCountingChecker_Error_DESC_Qty") : CalculateUtil.getSrvCalResource(ctx, "AllocWIPCountingChecker_Error_DESC_Amount");
                String reason = usingQtyOrAmount ? CalculateUtil.getSrvCalResource(ctx, "Cost_Cal_AllocWIPCounting_Error_Reason_Qty") : CalculateUtil.getSrvCalResource(ctx, "Cost_Cal_AllocWIPCounting_Error_Reason_Amount");
                String advice = usingQtyOrAmount ? CalculateUtil.getSrvCalResource(ctx, "Cost_Cal_AllocWIPCounting_Error_Advice_Qty") : CalculateUtil.getSrvCalResource(ctx, "Cost_Cal_AllocWIPCounting_Error_Advice_Amount");
                _Data.first();
                while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                    error = MessageFormat.format(errorTemplet, _Data.getString("costCenterNumber"), _Data.getString("costCenterName"), _Data.getString("materialNumber"), _Data.getString("materialName"), _Data.getString("Flot") == null ? "" : _Data.getString("Flot"), _Data.getString("costItemNumber"), _Data.getString("costItemName"), _Data.getString("wipData"), _Data.getString("inputData"));
                    CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                    rinfo.setDescription(error);
                    rinfo.setReason(reason);
                    rinfo.setSuggestOperation(advice);
                    this.rc.add(rinfo);
                    _Data.next();
                }
            }
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tblWIPCounting);
                TempTablePool.getInstance((Context)ctx).releaseTable(tblInputData);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tblWIPCounting);
        TempTablePool.getInstance((Context)ctx).releaseTable(tblInputData);
    }

    private void checkWIPCountingDataByCostObject(Context ctx, String companyId, String periodId) throws BOSException {
        String tblWIPCounting = null;
        String tblInputData = null;
        try {
            tblWIPCounting = this.createtblWIPCounting(ctx);
            this.initTblWIPCountingByCostObject(ctx, tblWIPCounting, companyId, periodId);
            tblInputData = this.createInputDataTbl(ctx);
            this.initTbltblInputDataByCostObject(ctx, tblInputData, companyId, periodId);
            StringBuffer sb = new StringBuffer();
            boolean usingQtyOrAmount = NCMUtils.isQtyWipType((Context)ctx, (String)companyId);
            sb.append("select cc.FNumber as costCenterNumber, cc.FName_l2 as costCenterName, ").append("       mat.FNumber as materialNumber, mat.FName_l2 as materialName, ").append("       ci.FNumber as costItemNumber, ci.FName_l2 as costItemName, ").append('\n').append("       co.FNumber as costObjectNumber, co.FName_l2 as costObjectName, ").append('\n').append("       isnull(d.Flot, '') as Flot, ").append('\n').append("       ").append(usingQtyOrAmount ? "(CASE WHEN isnull(b.FQty, 0)>0 and isnull(b.FQty, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(b.FQty, 0))) \n ELSE CONVERT(VARCHAR, isnull(b.FQty, 0)) END) as wipData, \n(CASE WHEN isnull(d.FQty, 0)>0 and isnull(d.FQty, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(d.FQty, 0))) \n ELSE CONVERT(VARCHAR, isnull(d.FQty, 0)) END) as inputData " : "(CASE WHEN isnull(b.FAmount, 0)>0 and isnull(b.FAmount, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(b.FAmount, 0)))\n ELSE CONVERT(VARCHAR, isnull(b.FAmount, 0)) END) as wipData, \n(CASE WHEN isnull(d.FAmount, 0)>0 and isnull(d.FAmount, 0)<1 THEN CONCAT('0', CONVERT(VARCHAR, isnull(d.FAmount, 0))) \n ELSE CONVERT(VARCHAR, isnull(d.FAmount, 0)) END) as inputData ").append('\n').append("  from ").append(tblWIPCounting).append(" as b ").append('\n').append("  left outer join ").append(tblInputData).append(" as d ").append('\n').append("    on b.FCostCenterID=d.FCostCenterID  ").append('\n').append("   and b.FCostObjectID = d.FCostObjectID ").append('\n').append("   and b.FMaterialID=d.FMaterialID and isnull(b.FLot, ' ')=isnull(d.FLot, ' ') ").append('\n').append("   and b.FCostItemId=d.FCostItemId ").append('\n').append(" inner join t_org_costcenter cc on b.FCostCenterID=cc.FID").append('\n').append(" inner join t_bd_material mat on b.FMaterialID=mat.FID").append('\n').append(" inner join T_NCM_CostItem ci on b.FCostItemId=ci.FID").append('\n').append(" inner join T_BD_CostObject co on b.FCostObjectId=co.FID").append('\n').append(" where ").append(usingQtyOrAmount ? "isnull(b.FQty, 0)>isnull(d.FQty, 0)" : "isnull(b.FAmount, 0)>isnull(d.FAmount, 0)").append('\n').append(" order by b.FCostCenterid, b.FMaterialID, b.FLot, b.FCostItemId");
            IRowSet _Data = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (_Data != null && _Data.size() > 0) {
                String error = null;
                String errorTemplet = usingQtyOrAmount ? CalculateUtil.getSrvCalResource(ctx, "AllocWIPCountingByCOChecker_Error_DESC_Qty") : CalculateUtil.getSrvCalResource(ctx, "AllocWIPCountingByCOChecker_Error_DESC_Amount");
                String reason = usingQtyOrAmount ? CalculateUtil.getSrvCalResource(ctx, "Cost_Cal_AllocWIPCounting_Error_Reason_Qty") : CalculateUtil.getSrvCalResource(ctx, "Cost_Cal_AllocWIPCounting_Error_Reason_Amount");
                String advice = usingQtyOrAmount ? CalculateUtil.getSrvCalResource(ctx, "Cost_Cal_AllocWIPCounting_Error_Advice_Qty") : CalculateUtil.getSrvCalResource(ctx, "Cost_Cal_AllocWIPCounting_Error_Advice_Amount");
                _Data.first();
                while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                    error = MessageFormat.format(errorTemplet, _Data.getString("costCenterNumber"), _Data.getString("costCenterName"), _Data.getString("costObjectNumber"), _Data.getString("costObjectName"), _Data.getString("materialNumber"), _Data.getString("materialName"), _Data.getString("Flot") == null ? "" : _Data.getString("Flot"), _Data.getString("costItemNumber"), _Data.getString("costItemName"), _Data.getString("wipData"), _Data.getString("inputData"));
                    CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                    rinfo.setDescription(error);
                    rinfo.setReason(reason);
                    rinfo.setSuggestOperation(advice);
                    this.rc.add(rinfo);
                    _Data.next();
                }
            }
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tblWIPCounting);
                TempTablePool.getInstance((Context)ctx).releaseTable(tblInputData);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tblWIPCounting);
        TempTablePool.getInstance((Context)ctx).releaseTable(tblInputData);
    }

    private void initTblWIPCountingByCostObject(Context ctx, String tblWIPCounting, String companyId, String periodId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(tblWIPCounting).append('\n').append("select distinct FCostCenterid,FCostObjectID, FMaterialID, FBatch, FCostItemId, ").append('\n').append("       sum(FAmount), sum(FBaseQty)").append('\n').append("  from T_NCM_WIPCountingMaterial").append('\n').append(" where FCompanyOrg='").append(companyId).append("'").append('\n').append("   and FCalculatePeriod='").append(periodId).append("'").append('\n').append(" and exists ( ").append('\n').append("     select 1 from T_NCM_AllocStdSetByWIP ass ").append('\n').append("     where ass.FCompanyId = '" + companyId + "' ").append('\n').append("     and ass.FCalculatePeriodID = '" + periodId + "' ").append('\n');
        if (AllocStdSetModeByWIPEnum.CostItemAndCostCenter.equals((Object)this.setMode)) {
            sb.append("     and ass.FCostCenterID = T_NCM_WIPCountingMaterial.FCostCenterid ").append('\n');
        } else if (AllocStdSetModeByWIPEnum.CostItemAndCostObj.equals((Object)this.setMode)) {
            sb.append("     and ass.FCostObjectID = T_NCM_WIPCountingMaterial.FCostObjectID ").append('\n');
        }
        sb.append("     and ass.FCostItemID = T_NCM_WIPCountingMaterial.FCostItemID").append('\n').append("     and ass.FAllocStdID = 'xGHRiNoXTSCl3IYyA5xfENnqRL8=' ").append('\n').append(" )").append('\n').append(" group by FCostCenterid, FCostObjectID, FMaterialID, FBatch, FCostItemId");
        NCMDbUtil.execute((Context)ctx, (String)sb.toString());
        NCMUtils.analyzeTempTable((Context)ctx, (String)tblWIPCounting);
    }

    private void initTblWIPCountingByCostCenter(Context ctx, String tblWIPCounting, String companyId, String periodId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(tblWIPCounting).append('\n').append(" (FCostCenterid,FMaterialID, FLot, FCostItemId, FAmount, FQty) ").append('\n').append("select distinct FCostCenterid,FMaterialID, FBatch, FCostItemId, ").append('\n').append("       sum(FAmount), sum(FBaseQty)").append('\n').append("  from T_NCM_WIPCountingMaterial").append('\n').append(" where FCompanyOrg='").append(companyId).append("'").append('\n').append("   and FCalculatePeriod='").append(periodId).append("'").append('\n').append(" and exists ( ").append('\n').append("     select 1 from T_NCM_AllocStdSetByWIP ass ").append('\n').append("     where ass.FCompanyId = '" + companyId + "' ").append('\n').append("     and ass.FCalculatePeriodID = '" + periodId + "' ").append('\n');
        if (AllocStdSetModeByWIPEnum.CostItemAndCostCenter.equals((Object)this.setMode)) {
            sb.append("     and ass.FCostCenterID = T_NCM_WIPCountingMaterial.FCostCenterid ").append('\n');
        }
        sb.append("     and ass.FCostItemID = T_NCM_WIPCountingMaterial.FCostItemID").append('\n').append("     and ass.FAllocStdID = 'xGHRiNoXTSCl3IYyA5xfENnqRL8=' ").append('\n').append(" )").append('\n').append(" group by FCostCenterid, FMaterialID, FBatch, FCostItemId");
        NCMDbUtil.execute((Context)ctx, (String)sb.toString());
        NCMUtils.analyzeTempTable((Context)ctx, (String)tblWIPCounting);
    }

    private String createtblWIPCounting(Context ctx) throws BOSException {
        String columns = "Create Table t_tempWIPCounting ( FCostCenterid VARCHAR(44), FCostObjectID VARCHAR(44),FMaterialID VARCHAR(44), FLot NVARCHAR(80), FCostItemId VARCHAR(44), FAmount NUMERIC(21,8) DEFAULT 0 , FQty NUMERIC(21,8) DEFAULT 0 )";
        String index = "FCostCenterid,FCostObjectID, FMaterialID, FLot, FCostItemId";
        return NCMDbUtil.createTempTable((Context)ctx, (String)columns, (String)index);
    }

    private void initTbltblInputDataByCostObject(Context ctx, String tblInputData, String companyId, String periodId) throws BOSException {
        String tblBalance = null;
        String tblBalanceEntry = null;
        String tblBalanceMatDetail = null;
        String tblMatAllocResult = null;
        try {
            tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
            tblBalanceEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceEntry");
            tblBalanceMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceMatDetail");
            tblMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult");
        }
        catch (EASBizException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(tblInputData).append('\n').append("(FCostCenterID,FCostObjectID,FCostItemID,FMaterialID,FLot,FAmount,FQty)").append("SELECT FEE.FCostCenterID, FEE.FCostObjectID, FEE.FCostItemID, FEE.FMaterialID, FEE.FLot,").append('\n').append("\t      SUM(FEE.FAmount)As FAmount, SUM(FEE.FQty)As FQty ").append('\n').append(" FROM (").append('\n').append("\tSELECT BOP.FCostCenterID, BOP.FCostObjectID, BOPEntry.FCostItemID, BOPDetail.FMaterialID, BOPDetail.FBatchNo As FLot,").append('\n').append("\t\t   BOPDetail.FAmount, BOPDetail.FQty ").append('\n').append("\t  FROM ").append(tblBalance).append(" BOP ").append('\n').append("\t INNER JOIN ").append(tblBalanceEntry).append(" BOPEntry ON BOPEntry.FParentID=BOP.FID ").append('\n').append("\t  LEFT JOIN ").append(tblBalanceMatDetail).append(" BOPDetail ON BOPDetail.FParentID=BOPEntry.FID").append('\n').append("  WHERE BOP.FCompanyOrg='").append(companyId).append("' AND BOP.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("\tUNION ALL ").append('\n').append("\tSELECT FCostCenterID, FCostObjectID, FCostItemID, FMaterialID, FLot, FAmount, FQty ").append('\n').append("\t  FROM ").append(tblMatAllocResult).append(" MAT ").append('\n').append("\t WHERE MAT.FCompanyID='").append(companyId).append("' AND MAT.FCalculatePeriodID='").append(periodId).append("'").append('\n').append(") FEE ").append('\n').append("GROUP BY FEE.FCostCenterID, FEE.FCostObjectID, FEE.FCostItemID, FEE.FMaterialID, FEE.FLot").append('\n').append(";");
        sb.append("delete from ").append(tblInputData).append(" where FMaterialID is null ").append('\n').append(";");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString());
        NCMUtils.analyzeTempTable((Context)ctx, (String)tblInputData);
    }

    private void initTbltblInputDataByCostCenter(Context ctx, String tblInputData, String companyId, String periodId) throws BOSException {
        String tblBalance = null;
        String tblBalanceEntry = null;
        String tblBalanceMatDetail = null;
        String tblMatAllocResult = null;
        try {
            tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
            tblBalanceEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceEntry");
            tblBalanceMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceMatDetail");
            tblMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult");
        }
        catch (EASBizException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(tblInputData).append('\n').append("(FCostCenterID,FCostItemID,FMaterialID,FLot,FAmount,FQty)").append("SELECT FEE.FCostCenterID, FEE.FCostItemID, FEE.FMaterialID, FEE.FLot,").append('\n').append("\t      SUM(FEE.FAmount)As FAmount, SUM(FEE.FQty)As FQty ").append('\n').append(" FROM (").append('\n').append("\tSELECT BOP.FCostCenterID, BOP.FCostObjectID, BOPEntry.FCostItemID, BOPDetail.FMaterialID, BOPDetail.FBatchNo As FLot,").append('\n').append("\t\t   BOPDetail.FAmount, BOPDetail.FQty ").append('\n').append("\t  FROM ").append(tblBalance).append(" BOP ").append('\n').append("\t INNER JOIN ").append(tblBalanceEntry).append(" BOPEntry ON BOPEntry.FParentID=BOP.FID ").append('\n').append("\t  LEFT JOIN ").append(tblBalanceMatDetail).append(" BOPDetail ON BOPDetail.FParentID=BOPEntry.FID").append('\n').append("  WHERE BOP.FCompanyOrg='").append(companyId).append("' AND BOP.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("\tUNION ALL ").append('\n').append("\tSELECT FCostCenterID, FCostObjectID, FCostItemID, FMaterialID, FLot, FAmount, FQty ").append('\n').append("\t  FROM ").append(tblMatAllocResult).append(" MAT ").append('\n').append("\t WHERE MAT.FCompanyID='").append(companyId).append("' AND MAT.FCalculatePeriodID='").append(periodId).append("'").append('\n').append(") FEE ").append('\n').append("GROUP BY FEE.FCostCenterID, FEE.FCostItemID, FEE.FMaterialID, FEE.FLot").append('\n').append(";");
        sb.append("delete from ").append(tblInputData).append(" where FMaterialID is null ").append('\n').append(";");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString());
        NCMUtils.analyzeTempTable((Context)ctx, (String)tblInputData);
    }

    private String createInputDataTbl(Context ctx) throws BOSException {
        String columns = "Create Table t_tempInputData ( FCostCenterID VARCHAR(44), FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FLot NVARCHAR(80),FAmount NUMERIC(17,4) DEFAULT 0, FQty NUMERIC(21,8) DEFAULT 0)";
        String index = "FCostCenterid, FMaterialID, FLot, FCostItemId";
        return NCMDbUtil.createTempTable((Context)ctx, (String)columns, (String)index);
    }

    private boolean isHavWipCountingConsumedMaterial(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer getData = new StringBuffer();
        getData.append(" select 1 ").append("  from T_NCM_WIPCountingMaterial").append('\n').append(" where FCompanyOrg='").append(companyId).append("'").append('\n').append("   and FCalculatePeriod='").append(periodId).append("'").append('\n').append("     and (FCostObjectID is null or FCostObjectID = '') ");
        try {
            IRowSet _Data = NCMDbUtil.executeQuery((Context)ctx, (String)getData.toString());
            if (_Data != null && _Data.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

