/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.Map;

public class ByPorductUnitCostChecker
extends CMCalChecker {
    public static final String STFSOURCE_PATH = "com.kingdee.eas.ncm.cal.client.CheckResource";
    private static final char CLF = '\n';

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        CalCostCheckItemCheckResultCollection rc = new CalCostCheckItemCheckResultCollection();
        this.checkTable(param, rc);
        return rc;
    }

    private void checkTable(Map param, CalCostCheckItemCheckResultCollection rc) throws BOSException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        String locLan = ctx.getLocale().toString();
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        try {
            String T_TMP_RecBillCostObjectTable = costDataCache.getRecBillCostObjectTable();
            StringBuffer ksql = new StringBuffer();
            ksql.append(" SELECT DISTINCT CO.FNumber FCONumber,CO.FName_").append(locLan).append(" FCOName,MAT.FNumber FMatNumber,MAT.FName_").append(locLan).append(" FMatName ").append('\n').append(" FROM " + T_TMP_RecBillCostObjectTable + " PARENT     \t\t\t\t\t\t\t\t\t\t ").append('\n').append(" INNER JOIN T_BD_Material MAT ON MAT.FID = PARENT.FMaterialID ").append(" Inner JOIN  T_BD_CostObject  CO ON  CO.FID = PARENT.FCostObjectID     ").append('\n').append(" where CO.FCalculateMode = ").append(3).append(" AND PARENT.FIsByProduct = 1 ").append('\n').append(" AND NOT EXISTS(").append('\n').append("\t\tSelect 1").append('\n').append("\t\tFROM T_NCM_ByProductUnitCost uc ").append('\n').append("\t\tWHERE uc.FCompanyID='").append(companyId).append("' ").append('\n').append("\t\tAND uc.FCalculatePeriodID='").append(periodId).append("' ").append('\n').append("\t\t\tAND  uc.FMaterialID = MAT.FID").append('\n').append("\t)").append('\n').append(" GROUP BY Mat.FID,CO.FNumber,CO.FName_").append(locLan).append(" \t,MAT.FNumber ,MAT.FName_").append(locLan).append(" HAVING SUM(PARENT.FBaseQty) > 0 ");
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            while (rs.next()) {
                String coNumber = rs.getString("FCOnumber");
                String coName = rs.getString("FCOName");
                String matNumber = rs.getString("FMatNumber");
                String matName = rs.getString("FMatName");
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(CalSeverUtils.getNcmCheckResource(ctx, "ByPorductUnitCostChecker_desc"), coNumber, coName, matNumber, matName));
                rinfo.setReason(CalSeverUtils.getNcmCheckResource(ctx, "ByPorductUnitCostChecker_reason"));
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "ByPorductUnitCostChecker_SO"));
                rc.add(rinfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

