/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.LowLevelCodeTypeEnum;
import com.kingdee.eas.ncm.cal.app.ICMCalChecker;
import com.kingdee.eas.ncm.cal.app.LowLevelCodeBuilder;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DirectRankCodeCycleChecker
implements ICMCalChecker {
    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        CalCostCheckItemCheckResultCollection rc = new CalCostCheckItemCheckResultCollection();
        this.checking(param, rc);
        return rc;
    }

    private void checking(Map param, CalCostCheckItemCheckResultCollection results) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        Integer stage = (Integer)param.get("stage");
        if (stage == null) {
            return;
        }
        if (stage == 5) {
            return;
        }
        CalCostCheckItemCheckResultInfo result = null;
        Map co_billNumbers = null;
        try {
            param.put("llcType", LowLevelCodeTypeEnum.Normal);
            param.put("isDirectRankChecker", "true");
            LowLevelCodeBuilder builder = new LowLevelCodeBuilder(param);
            co_billNumbers = builder.build2();
        }
        catch (EASBizException e) {
            if (EASBizException.CHECKBLANK.getCode().equals(e.getSubCode()) || EASBizException.CHECKDUPLICATED.getCode().equals(e.getSubCode())) {
                result = new CalCostCheckItemCheckResultInfo();
                result.setDescription(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_description2"));
                result.setReason(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_reason2"));
                result.setSuggestOperation(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_SO2"));
                results.add(result);
                return;
            }
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (co_billNumbers == null || co_billNumbers.size() == 0) {
            return;
        }
        List costObjectIds = (List)co_billNumbers.get("costObjectIds");
        List billNumbers = (List)co_billNumbers.get("billNumbers");
        if (costObjectIds != null && costObjectIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            HashSet ids = new HashSet();
            ids.addAll(costObjectIds);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            SelectorItemCollection seletor = new SelectorItemCollection();
            seletor.add("id");
            seletor.add("number");
            view.setFilter(filter);
            view.setSelector(seletor);
            CostObjectCollection coll = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(view);
            HashMap<String, String> costObjects = new HashMap<String, String>();
            for (CostObjectInfo costObject : coll) {
                costObjects.put(costObject.getId().toString(), costObject.getNumber());
            }
            result = new CalCostCheckItemCheckResultInfo();
            StringBuffer tips = new StringBuffer();
            for (String costObjectId : costObjectIds) {
                String costObjectNumber = (String)costObjects.get(costObjectId);
                if (costObjectNumber == null) continue;
                tips.append(costObjectNumber).append(" -> ");
            }
            if (tips.length() > 0) {
                tips.delete(tips.length() - 4, tips.length());
            }
            result.setDescription(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_description1") + tips);
            tips.setLength(0);
            for (String billNumber : billNumbers) {
                if (billNumber == null) continue;
                tips.append(billNumber).append(" -> ");
            }
            if (tips.length() > 0) {
                tips.delete(tips.length() - 4, tips.length());
            }
            result.setReason(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_reason1") + tips);
            result.setSuggestOperation(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_SO1"));
            results.add(result);
        }
    }
}

