/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.Map;

public class MainProductManufactureChecker
extends CMCalChecker {
    public static final String STFSOURCE_PATH = "com.kingdee.eas.ncm.cal.client.CheckResource";
    private static final char CLF = '\n';

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        CalCostCheckItemCheckResultCollection rc = new CalCostCheckItemCheckResultCollection();
        this.checkTable(param, rc);
        return rc;
    }

    private void checkTable(Map param, CalCostCheckItemCheckResultCollection rc) throws BOSException {
        Context ctx = (Context)param.get("ctx");
        String locLan = ctx.getLocale().toString();
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        try {
            String T_TMP_RecBillCostObjectTable = costDataCache.getRecBillCostObjectTable();
            StringBuffer ksql = new StringBuffer();
            ksql.append("SELECT top 100 \n");
            ksql.append("    CO.FNumber FCOnumber, CO.FName_" + locLan + " FCOName").append('\n');
            ksql.append("FROM " + T_TMP_RecBillCostObjectTable + " r \n");
            ksql.append("JOIN T_BD_CostObject CO ON CO.FID = r.FCostObjectID     \n");
            ksql.append("WHERE CO.FCalculateMode = 3 \n");
            ksql.append("    AND r.FIsByProduct = 1 \n");
            ksql.append("    AND NOT exists ( \n");
            ksql.append("        SELECT 1 \n");
            ksql.append("        FROM " + T_TMP_RecBillCostObjectTable + " t \n");
            ksql.append("        WHERE t.FCostObjectID = CO.FID \n");
            ksql.append("            and t.FIsMainProduct = 1 \n");
            ksql.append(") \n");
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            while (rs.next()) {
                String coNumber = rs.getString("FCOnumber");
                String coName = rs.getString("FCOName");
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(CalSeverUtils.getNcmCheckResource(ctx, "MainProductManufactureChecker_desc"), coNumber, coName));
                rinfo.setReason(CalSeverUtils.getNcmCheckResource(ctx, "MainProductManufactureChecker_reason"));
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "MainProductManufactureChecker_SO"));
                rc.add(rinfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

