/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.ICMCalChecker;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MatCostInfoNoSetForInventoryInfoChecker
implements ICMCalChecker {
    public static final String STFSOURCE_PATH = "com.kingdee.eas.ncm.cal.CheckResource";
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        CalCostCheckItemCheckResultCollection rc = new CalCostCheckItemCheckResultCollection();
        Set sIDs = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)companyId);
        if (sIDs.size() == 0) {
            return rc;
        }
        Iterator ir = sIDs.iterator();
        ArrayList idList = new ArrayList();
        while (ir.hasNext()) {
            idList.add(ir.next());
        }
        IObjectPK[] pks = new IObjectPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pks[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        StringBuffer params = null;
        if (pks != null) {
            params = NCMUtils.splitPK((IObjectPK[])pks);
        }
        try {
            StringBuffer select = new StringBuffer();
            select.append("\tselect distinct mat.FNumber FMatNumber, mat.FName_" + locLan + " FMatName \n");
            select.append("\tfrom t_bd_material mat \n");
            select.append("\tinner join t_bd_materialInventory matInv on mat.FID = matInv.FMaterialID \n");
            select.append("\tleft join t_bd_materialCost matCost on mat.FID = matCost.FMaterialID \n");
            select.append("\twhere matInv.Fstatus = 1 \n");
            select.append("\tand ( \n");
            select.append("\t\t(matCost.FStatus = 0 or matCost.FDefaultCostItemID is null or matCost.FOrgUnit is null )\n");
            select.append("\t\t  and matCost.FOrgUnit in (" + params.toString() + ") \n");
            select.append("\t\tor not exists (select * from t_bd_materialCost  where fmaterialId = mat.FID ) \n");
            select.append("\t) \n");
            select.append("\tand matInv.FOrgUnit in (" + params.toString() + ")");
            select.append("\tand mat.FStatus = 1 \n");
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)select.toString());
            while (rs.next()) {
                String matNumber = rs.getString("FMatNumber");
                String matName = rs.getString("FMatName");
                CalCostCheckItemCheckResultInfo rInfo = new CalCostCheckItemCheckResultInfo();
                rInfo.setDescription(matNumber + ResourceBase.getString((String)STFSOURCE_PATH, (String)"MatCostInfoNoSetForInventoryInfoChecker_01", (Locale)ctx.getLocale()));
                rInfo.setReason(matNumber + ResourceBase.getString((String)STFSOURCE_PATH, (String)"MatCostInfoNoSetForInventoryInfoChecker_02", (Locale)ctx.getLocale()));
                rInfo.setSuggestOperation(ResourceBase.getString((String)STFSOURCE_PATH, (String)"MatCostInfoNoSetForInventoryInfoChecker_03", (Locale)ctx.getLocale()));
                rc.add(rInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return rc;
    }
}

