/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.ICMCalChecker;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MatReqNoInputQtyChecker
implements ICMCalChecker {
    public static final String STFSOURCE_PATH = "com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource";
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        CalCostCheckItemCheckResultCollection rc = new CalCostCheckItemCheckResultCollection();
        String tblBalance = null;
        String tblBalanceEntry = null;
        String tblBalanceDetial = null;
        try {
            tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
            tblBalanceEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceEntry");
            tblBalanceDetial = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceMatDetail");
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        Set sIDs = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)companyId);
        if (sIDs.size() == 0) {
            return rc;
        }
        Iterator ir = sIDs.iterator();
        ArrayList idList = new ArrayList();
        while (ir.hasNext()) {
            idList.add(ir.next());
        }
        IObjectPK[] pks = new IObjectPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pks[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        StringBuffer params = null;
        if (pks != null) {
            params = NCMUtils.splitPK((IObjectPK[])pks);
        }
        try {
            StringBuffer select = new StringBuffer();
            String T_TMP_MatReq = costDataCache.getMatReqTable();
            String T_TMP_InputQty = costDataCache.getInputQtyTable();
            select.append("select  \n");
            select.append("     distinct co.FNumber FCoNumber, co.FName_" + locLan + " FCoName,cc.FName_l2 FCCName \n");
            select.append("from ( \n");
            select.append("    select \n");
            select.append("        FCostCenterID, FCostObjectID \n");
            select.append("    from ( \n");
            select.append("        select \n");
            select.append("            b.FCostCenterID FCostCenterID, b.FCostObjectID, b.FActualCost FAmount, b.FBaseQty FQty \n");
            select.append("        from " + T_TMP_MatReq + " b \n");
            select.append("        where b.FCostObjectID is not null \n");
            select.append("        UNION  ALL \n ");
            select.append("        select \n");
            select.append("            bala.FCostCenterID FCostCenterID, bala.FCostObjectID FCostObejctID, balaMat.FAmount FAmount, balaMat.FQty FQty \n");
            select.append("        from " + tblBalance + " bala \n");
            select.append("        inner join " + tblBalanceEntry + " balaEntry on balaEntry.FParentID = bala.FID \n");
            select.append("        inner join " + tblBalanceDetial + " balaMat on balaMat.FParentID = balaEntry.FID \n ");
            select.append("    ) a \n");
            select.append("    group by FCostCenterID, FCostObjectID \n");
            select.append("    having sum(FAmount) <> 0 or sum(FQty) <> 0\n");
            select.append(") t \n");
            select.append("join T_ORG_CostCenter cc on cc.FID = t.FCostCenterID \n");
            select.append("join T_BD_CostObject co on co.FID = t.FCostObjectID \n");
            select.append("where 1=1 \n");
            select.append("and (cc.FCostCenterType = 0) \n");
            select.append("and co.FNumber <> 'SCOID' \n");
            select.append("and co.FRELATEDTYPE <> 3 \n");
            select.append("and not exists ( \n");
            select.append("    select 1 from " + T_TMP_InputQty + " a \n");
            select.append("    where a.FCostCenterID = t.FCostCenterID and a.FCostObjectID = t.FCostObjectID \n");
            select.append(") \n");
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)select.toString());
            while (rs.next()) {
                String coNumber = rs.getString("FCoNumber");
                String ccName = rs.getString("FCCName");
                CalCostCheckItemCheckResultInfo rInfo = new CalCostCheckItemCheckResultInfo();
                rInfo.setDescription(coNumber + ResourceBase.getString((String)STFSOURCE_PATH, (String)"MatReqNoInputQtyChecker_1", (Locale)ctx.getLocale()) + ccName + ResourceBase.getString((String)STFSOURCE_PATH, (String)"MatReqNoInputQtyChecker_2", (Locale)ctx.getLocale()));
                rInfo.setReason(ResourceBase.getString((String)STFSOURCE_PATH, (String)"MatReqNoInputQtyChecker_3", (Locale)ctx.getLocale()));
                rInfo.setSuggestOperation(ResourceBase.getString((String)STFSOURCE_PATH, (String)"MatReqNoInputQtyChecker_4", (Locale)ctx.getLocale()));
                rc.add(rInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rc;
    }
}

